(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1334520,      65429]*)
(*NotebookOutlinePosition[   1358630,      66198]*)
(*  CellTagsIndexPosition[   1358586,      66194]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Introduction to the Maths Lab - Part 2", "Title",
  CellFrame->False,
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellDingbat->None],

Cell[TextData[{
  "In this session we will concentrate on the graphical capabilities of ",
  StyleBox["Mathematica;",
    FontSlant->"Italic"],
  " we will also show you how data can be imported into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from other applications and how it can be exported out of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Two Dimensional Plotting", "Section",
  CellDingbat->None],

Cell[TextData[{
  "A standard task in the physical laboratory is the plotting and analysis of \
two dimensional experimental data. In many cases this data will be held as a \
sequence of numbers in a file external to ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "(in fact, all computer-driven lab instruments can give you results \
directly in this form). The numbers can be stored in a variety of formats; \
for this exercise the file is simply a text file holding pairs of values of \
time and intensity separated by a space, each pair appearing on a new line. \n\
\nTo see what is inside any file you simply type in two exclamation marks \
followed by the path to the file. The example from our Macintosh computer \
was:"
}], "Text"],

Cell[BoxData[
    \(\(! \(! "\<Hard disk:Desktop Folder:expt1.dat\>"\)\)\)], "Input"],

Cell[TextData[{
  "The path will be different for you, and the way the path is expressed will \
look different on a Windows PC. So to find ",
  StyleBox["expt1.dat",
    FontFamily->"Arial"],
  " on your computer, first start ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " open up a new notebook, type in two exclamation marks and then go to  \
the",
  StyleBox[" Input",
    FontFamily->"Arial"],
  " menu and select ",
  StyleBox["Get File Path ...",
    FontFamily->"Arial"],
  "  to locate the data file ",
  StyleBox["expt1.dat ",
    FontFamily->"Arial"],
  "on your hard disk. When you click on ",
  StyleBox["Open",
    FontFamily->"Arial"],
  " the appropriate file path will appear on the input line. Press \
<shift-return> now and the contents of the file will appear.\n\nTo read the \
data into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " we use the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " command. The following command opens up the disk file and reads the pairs \
of numbers into a list that we have called ",
  StyleBox["data",
    FontFamily->"Courier"],
  ". Try this command, using your own file path, and compare it to the \
contents you saw above."
}], "Text"],

Cell[BoxData[
    \(data = Import["\<Hard disk:Desktop Folder:expt1.dat\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["Import",
    FontFamily->"Courier"],
  " is a sophisticated command with many options (see the help system for the \
details); you can tell it explicitly what kind of data format you have got, \
or, as here, you can allow it to make an assumption - when it sees the \".dat\
\" in the filename it assumes that the data is going to be in a plain text \
\"tabular\" format."
}], "Text"],

Cell[TextData[{
  "We can plot the ",
  StyleBox["data",
    FontFamily->"Courier"],
  " list using the following command."
}], "Text"],

Cell[BoxData[
    \(ListPlot[data]\)], "Input"],

Cell[TextData[{
  "The data is from a kinetic experiment measuring current in \[Mu]A as a \
function of time in ",
  StyleBox["s",
    FontSlant->"Italic"],
  ", so we should label the plot appropriately. We also choose to join up the \
data points, colour the resulting line, put the plot into a frame, add a \
title and change the font."
}], "Text",
  CellMargins->{{Inherited, 21}, {Inherited, Inherited}}],

Cell[BoxData[
    \(plot = 
      ListPlot[data, Frame -> True, 
        FrameLabel -> {"\<t/s\>", "\<I/\[Mu]A\>"}, \nRotateLabel -> False, 
        PlotLabel -> "\<Kinetic Data\>", 
        DefaultFont -> {"\<Helvetica\>", 9}, \n
        PlotStyle \[Rule] RGBColor[1, 0, 0]]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}],

Cell["\<\
It is anticipated that the data should follow first order kinetics; \
we can check this by plotting the (natural) logarithm of the current against \
the time. To do this we first need to load up an add-on package which allows \
all sorts of graphical manipulations\
\>", "Text"],

Cell[BoxData[
    \(Needs[\ "\<Graphics`Graphics`\>"]\)], "Input",
  CellMargins->{{Inherited, 19}, {Inherited, Inherited}}],

Cell["and then plot the intensity data on logarithmic scales.", "Text",
  CellMargins->{{Inherited, 24}, {Inherited, Inherited}}],

Cell[BoxData[
    \(logplot = 
      LogListPlot[data, Frame -> True, \n
        FrameLabel -> {"\<t/s\>", "\<I/\[Mu]A\>"}, RotateLabel -> False, 
        PlotLabel -> "\<Kinetic Data\>", \n
        DefaultFont -> {"\<Helvetica\>", 9}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0]}]\)], "Input",
  CellMargins->{{Inherited, 24}, {Inherited, Inherited}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Exercises and Explorations 1",
  FontFamily->"Helvetica",
  FontSize->14]], "Subsection",
  PageWidth->PaperWidth,
  CellFrame->False,
  CellDingbat->None,
  TextAlignment->Center,
  TextJustification->0],

Cell[CellGroupData[{

Cell["1: Logging the data", "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 19}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "You can estimate the gradient and intercept from this plot and use these \
values in the model of the current as a function of the time,",
  StyleBox[" t",
    FontSlant->"Italic"],
  ". "
}], "Text"],

Cell[BoxData[
    \(current[t_] := I\_0\ \[ExponentialE]\^\(\(-\[Lambda]\)\ t\)\)], "Input"],

Cell[TextData[{
  "Notice that you have to define the function via the \"colon-equals\" sign \
and each variable must be declared (on the left hand side) by being followed \
by an underscore. However, when you want to evaluate the function, for \
example at ",
  StyleBox["t ",
    FontSlant->"Italic"],
  "= 10, you simply type ",
  StyleBox["current[10]",
    FontFamily->"Courier"],
  "; there is no underscore. Below we show how the function has been used to \
plot the model for rather poor guesses at the kinetic parameters. "
}], "Text"],

Cell[BoxData[
    \(logmodel = 
      LogPlot[current[t]\  /. {I\_0 -> \ 1.5, \[Lambda]\  -> \  .3}, {t, 0, 
          4}, Frame -> True, \nFrameLabel -> {"\<t/s\>", "\<I/\[Mu]A\>"}, 
        RotateLabel -> False, \nDefaultFont -> {"\<Helvetica\>", 9}, 
        PlotStyle \[Rule] {RGBColor[0, 0, 1]}]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}],

Cell[TextData[{
  "Here we have introduced the idea of ",
  StyleBox["replacement rules",
    FontSlant->"Italic"],
  " when we asked for ",
  StyleBox["current[t]",
    FontFamily->"Courier"],
  " to be evaluated for ",
  Cell[BoxData[
      StyleBox[\({I\_0 -> \ 1.5, \[Lambda]\  -> \  .3}\),
        FontSize->9,
        FontWeight->"Bold"]]],
  ". (Using replacement rules means that the values for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["I",
            FontSlant->"Plain"], "0"], TraditionalForm]],
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and",
  StyleBox[" \[Lambda]",
    FontSize->9,
    FontWeight->"Bold"],
  " are only \"remembered\" during the calculation; we haven't assigned \
permanent values to them.) Adjust the parameters until you find the best fit \
to the experimental data; checking your guesses by superimposing data and \
model:"
}], "Text"],

Cell[BoxData[
    \(Show[logplot, logmodel]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2: Exporting data from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 19}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "There may be occasions when you need to \"export\" calculations that you \
have done with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to other programs - for example Excel, CricketGraph, CurveFit or \
SigmaPlot. There are a number of ways of doing this, but the most \
straightforward is to generate a simple data file which such programs can \
read."
}], "Text"],

Cell[TextData[{
  "In this way, the model function that you worked out in question 1 can be \
exported as a table of values for ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and ",
  StyleBox["current",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  "). Try the following command, substituting your calculated values for ",
  Cell[BoxData[
      \(TraditionalForm\`I\_0\)]],
  " and \[Lambda], and an ",
  StyleBox["appropriate file path",
    FontSlant->"Italic"],
  " for your computer."
}], "Text"],

Cell[BoxData[
    \(Export["\<Hard disk:Desktop Folder:mymodel.dat\>", \
\[IndentingNewLine]Table[{t, 
          current[t] /. {I\_0 -> \ 1.5, \[Lambda]\  -> \  .3}}, {t, 0.0, 4.0, 
          0.2}]\[IndentingNewLine]]\)], "Input"],

Cell["And to see the contents:", "Text"],

Cell[BoxData[
    \(\(!! "\<Hard disk:Desktop Folder:mymodel.dat\>"\)\)], "Input"],

Cell[TextData[{
  "This model has a simple decaying graph. When a graph is more \"wiggly\" \
you'll probably need to increase the number of data points by setting the \
step value (",
  StyleBox["0.2",
    FontFamily->"Courier"],
  " above) appropriately."
}], "Text"],

Cell["\<\
If you are familiar with the plotting features of Excel, or  a \
general plotting program, try recreating with it the superimposed plot of the \
data points and model curve, based on the files \"expt1.dat\" and \
\"mymodel.dat\".\
\>", "Text"],

Cell[TextData[{
  "Import and Export are powerful commands, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many others as well for handling the input and output of data, text \
and graphics. A good place to start hunting for information about this is \
Section 2.11 of ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ". (In the Help system, click on the button labelled \"The Mathematica Book\
\" and type \"2.11\" into the Go To box; the same information can be found on \
the web at ",
  StyleBox["http://documents.wolfram.com/v4/",
    FontFamily->"Courier"],
  StyleBox[" .)",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[TextData[{
  "\n",
  StyleBox["It would be a good idea at this point to save all your work from \
Section 1, and begin a fresh notebook for Section 2.",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Surface Plots", "Section",
  CellDingbat->None],

Cell[TextData[{
  "A surface plot arises when we have a function ",
  StyleBox["z",
    FontSlant->"Italic"],
  "=",
  StyleBox["f(x,y)",
    FontSlant->"Italic"],
  "; that is, the height",
  StyleBox[" z",
    FontSlant->"Italic"],
  " of the surface is a function of position in the ",
  StyleBox["x-y",
    FontSlant->"Italic"],
  " plane.  A good chemical example of this arises when we consider the \
quantum mechanical wave function of a particle confined to a rectangular \
planar surface of side ",
  Cell[BoxData[
      \(TraditionalForm\`l\_1\)]],
  "in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " direction and ",
  Cell[BoxData[
      \(TraditionalForm\`l\_2\)]],
  "in the ",
  StyleBox["y",
    FontSlant->"Italic"],
  " direction. (This is a reasonable model of the wave function for a \
molecule adsorbed on to a crystal surface.) The wave function, \[Psi]",
  StyleBox["(x,y)",
    FontSlant->"Italic"],
  ", for the particle is given by \n\n\[Psi](x,y)=",
  Cell[BoxData[
      \(TraditionalForm\`2\/\@\(\(l\_1\) l\_2\)\)]],
  "sin",
  Cell[BoxData[
      \(TraditionalForm\`\((\(\(n\_1\) \[Pi]x\)\/l\_1)\)\)]],
  "sin",
  Cell[BoxData[
      \(TraditionalForm\`\((\(\(n\_2\) \[Pi]y\)\/l\_2)\)\)]],
  "   ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "= 1, 2, ... and ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  "= 1, 2, ...\n\nwhere ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  " are the quantum numbers and the energy of each state is given by\n\nE = \
",
  Cell[BoxData[
      \(TraditionalForm\`\(h\^2\/\(8  m\)\) \((n\_1\%2\/l\_1\%2 + 
            n\_2\%2\/l\_2\%2)\)\)]],
  "\n\nIgnoring the scaling constants, you can plot the three dimensional \
surfaces using the following code. We start by looking at the wavefunction \
for a particle confined to a square surface."
}], "Text"],

Cell[BoxData[
    \(\[Psi][x_, y_] := 
      Sin[\(\(n\_1\) \[Pi]\ x\)\/l\_1] 
        Sin[\(\(n\_2\) \[Pi]\ y\)\/l\_2]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}],

Cell[BoxData[
    \(Plot3D[\[Psi][x, y]\  /. {n\_1 -> 1, n\_2 -> 2, l\_1 -> 1, 
          l\_2 -> 1}, {x, 0, 1}, {y, 0, 1}]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}],

Cell[TextData[{
  "As with two dimensional plots we can change the appearance of the surface \
plot in a large number of ways. We increase the resolution of the plot, label \
the axes, change the viewpoint, the length of the edges of the box, within \
which we plot \[Psi], and colour code the height of the function. The latter \
makes high points red and low points orange. The view point was set using the \
",
  StyleBox["3D ViewPoint Selector ...",
    FontFamily->"Arial"],
  " under the ",
  StyleBox["Input",
    FontFamily->"Arial"],
  " pull down."
}], "Text"],

Cell[BoxData[
    \(Plot3D[\[Psi][x, y]\  /. {n\_1 -> 1, n\_2 -> 2, l\_1 -> 1, 
          l\_2 -> 1}, {x, 0, 1}, {y, 0, 1}, \nPlotPoints -> 30, 
      ColorFunction -> Hue, AxesLabel -> {"\<x\>", "\<y\>", "\<\[Psi]\>"}, \n
      ViewPoint -> {5.375, \ 2.227, \ 2.965}, 
      BoxRatios \[Rule] {1, 1, 1}]\)], "Input",
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Exercises and Explorations  2",
  FontFamily->"Helvetica",
  FontSize->14]], "Subsection",
  PageWidth->PaperWidth,
  CellFrame->False,
  CellDingbat->None,
  TextAlignment->Center,
  TextJustification->0],

Cell[CellGroupData[{

Cell[TextData[{
  "1: Plotting ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\^2\)]]
}], "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "The probability of finding the particle at a position ",
  StyleBox["(x, y)",
    FontSlant->"Italic"],
  " is ",
  StyleBox["equal",
    FontSlant->"Italic"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\^2\)]],
  ". Plot ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\^2\)]],
  " for the quantum numbers used above. (N.B. you should use the \
normalisation constant given above.)"
}], "Text"],

Cell["\<\
This would be a good time to try out the \"RealTime3D\" graphics \
feature that we introduced in Maths Lab 1. Note, however, that in RealTime3D \
mode, axes and axes labels (and other things) will not appear.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2: Contours", "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell["\<\
Plot the function from exercise 1 as a contour plot, making sure \
the axes are labelled.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3: Degeneracy", "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "Show that the wave functions for ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "= 1, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  "= 2 and for ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "= 2, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  "= 1 are degenerate when ",
  Cell[BoxData[
      \(TraditionalForm\`l\_1\)]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`l\_2\)]],
  ". That is, you should show that the energy for these two states is the \
same, but the wave functions are different. What is the relationship between \
these degenerate wavefunctions?"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4: Accidental degeneracy", "Subsubsection",
  CellFrame->True,
  CellMargins->{{Inherited, 20}, {Inherited, Inherited}},
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "Obvious symmetries do not always exist between degenerate states. Show \
that when ",
  Cell[BoxData[
      \(TraditionalForm\`l\_2 = 2  l\_1\)]],
  " there is degeneracy between states ",
  Cell[BoxData[
      \(TraditionalForm\`n\_\(\(1\)\(\ \)\)\)]],
  "= 1, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  " = 4 and  ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  " = 2, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  " = 2, but that a simple symmetry operation does not connect the \
wavefunctions. If you have time, find another non-symmetrical pair of \
degenerate states for ",
  Cell[BoxData[
      \(TraditionalForm\`l\_2\)]],
  "= 2",
  Cell[BoxData[
      \(TraditionalForm\`l\_1\)]],
  ". N.B. since ",
  Cell[BoxData[
      \(TraditionalForm\`l\_1\)]],
  "\[NotEqual] ",
  Cell[BoxData[
      \(TraditionalForm\`l\_2\)]],
  "  now you will have to change the range over which you are plotting.\n\n\n\
",
  StyleBox["We recommend that you now save your work  from Section 2, quit \
and restart Mathematica, and begin a fresh  Notebook to work on Section 3.",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Three Dimensional  Surface Representations", "Section",
  CellDingbat->None],

Cell[TextData[{
  "The surface plots of Section 2 are single valued functions of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", i.e. there is only one value of ",
  StyleBox["z",
    FontSlant->"Italic"],
  " for each position ",
  StyleBox["(x, y)",
    FontSlant->"Italic"],
  ". Frequently we want to make three dimensional surface representations \
where the surface is a function of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " and ",
  StyleBox["z",
    FontSlant->"Italic"],
  " as well. A good chemical example of this are the molecular orbitals of \
hydrogen.\n\nIn this case the spherical symmetry of the problem indicates \
that we will simplify the mathematical description if we use the spherical \
coordinates ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta] and \[Phi]. Here ",
  StyleBox["r",
    FontSlant->"Italic"],
  " is the radial distance from the origin, \[Theta] is the angle with \
respect to the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "-axis and \[Phi] is the angle in the ",
  StyleBox["x-y",
    FontSlant->"Italic"],
  " plane with respect to the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis. (Hence ",
  StyleBox["x",
    FontSlant->"Italic"],
  " = ",
  StyleBox["r",
    FontSlant->"Italic"],
  " sin\[Theta] cos\[Phi], ",
  StyleBox["y",
    FontSlant->"Italic"],
  " = ",
  StyleBox["r",
    FontSlant->"Italic"],
  " sin\[Theta] sin\[Phi] and ",
  StyleBox["z",
    FontSlant->"Italic"],
  " = ",
  StyleBox["r",
    FontSlant->"Italic"],
  " cos\[Theta].) In these coordinates the hydrogenic wave function, \
\[CapitalPsi], can be expressed as\n\n\[CapitalPsi](",
  StyleBox["r",
    FontSlant->"Italic"],
  ",\[Theta],\[Phi]) = R(",
  StyleBox["r",
    FontSlant->"Italic"],
  ") \[CapitalTheta](\[Theta]) \[CapitalPhi](\[Phi])\n\nIn other words the \
wave function is the product of separate functions of ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta] and \[Phi]. The angular parts, \[CapitalTheta](\[Theta]) \
\[CapitalPhi](\[Phi]), are functions called spherical harmonics and are what \
give us the hydrogenic molecular orbitals (henceforth MO). The MOs and their \
associated spherical harmonics are given below."
}], "Text",
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->0],

Cell[TextData[{
  "\n\n",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          UnderscriptBox[GridBox[{
                {"MO", \(Spherical\ Harmonic\)}
                }], "_"], "_"], TraditionalForm]]],
  "\n",
  Cell[BoxData[
      FormBox[
        StyleBox[
          UnderscriptBox[
            StyleBox[GridBox[{
                  {
                    AdjustmentBox["s",
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    AdjustmentBox["Constant",
                      BoxMargins->{{-0.1, 0.1}, {0, 0}}]},
                  {
                    AdjustmentBox[\(p\_z\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    AdjustmentBox["cos\[Theta]",
                      BoxMargins->{{-0.1, 0.1}, {0, 0}}]},
                  {
                    AdjustmentBox[\(p\_y\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    RowBox[{
                      AdjustmentBox["sin\[Theta]",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      AdjustmentBox["  ",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      StyleBox[
                        RowBox[{
                          AdjustmentBox["sin",
                            BoxMargins->{{-0.3, 0.3}, {0, 0}}], 
                          AdjustmentBox["\[Phi]",
                            BoxMargins->{{-0.1, 0.1}, {0, 0}}]}]]}]},
                  {
                    AdjustmentBox[\(p\_x\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    StyleBox[
                      AdjustmentBox["-",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}],
                      SpanMaxSize->Infinity]},
                  {
                    AdjustmentBox[\(d\_\(z\^2\)\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    AdjustmentBox[\(3\ \(cos\^2\) \[Theta]\  - \ 1\),
                      BoxMargins->{{-0.1, 0.1}, {0, 0}}]},
                  {
                    AdjustmentBox[\(d\_yz\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    RowBox[{
                      AdjustmentBox["cos\[Theta]",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      AdjustmentBox[" ",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      AdjustmentBox["sin\[Theta]",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      AdjustmentBox["  ",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}], 
                      StyleBox[
                        RowBox[{
                          AdjustmentBox["sin",
                            BoxMargins->{{-0.3, 0.3}, {0, 0}}], 
                          AdjustmentBox["\[Phi]",
                            BoxMargins->{{-0.1, 0.1}, {0, 0}}]}]]}]},
                  {
                    AdjustmentBox[\(d\_zx\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    StyleBox[
                      AdjustmentBox["-",
                        BoxMargins->{{-0.1, 0.1}, {0, 0}}],
                      SpanMaxSize->Infinity]},
                  {
                    AdjustmentBox[\(d\_\(x\^2 - y\^2\)\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    
                    AdjustmentBox[\(\(\ \)\(\(sin\^2\) \[Theta]\ cos2\[Phi]\)\
\),
                      BoxMargins->{{-0.1, 0.1}, {0, 0}}]},
                  {
                    AdjustmentBox[\(d\_xy\),
                      BoxMargins->{{0.1, -0.1}, {0, 0}}], 
                    StyleBox["-",
                      SpanMaxSize->Infinity]}
                  }],
              SpanMaxSize->Infinity], "_"],
          SpanMaxSize->Infinity], TraditionalForm]],
    TextAlignment->Left,
    TextJustification->0]
}], "Text",
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  TextAlignment->Center,
  TextJustification->0],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71236
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0169609 0.31746 [
[ 0 0 0 0 ]
[ 1 .71236 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .71236 L
0 .71236 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0169609 0.321429 0.340025 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
-0.30443 1.63518 -0.0106411 1.63518 [
[.5 1.63703 -19.625 0 ]
[.5 1.63703 19.625 10 ]
[.08347 .2009 -19.3756 -10 ]
[.08347 .2009 1.18695 0 ]
[.21284 .14994 -23.0109 -10 ]
[.21284 .14994 1.98915 0 ]
[.3456 .09765 -7.58187 -10 ]
[.3456 .09765 .85563 0 ]
[.4819 .04399 -17.0966 -10 ]
[.4819 .04399 2.40337 0 ]
[.62186 -0.01111 -12.8771 -10 ]
[.62186 -0.01111 2.18545 0 ]
[.2819 .01774 -7.18874 -10 ]
[.2819 .01774 .81126 0 ]
[.67411 .0028 0 -6.95638 ]
[.67411 .0028 20.5625 3.04362 ]
[.74455 .10274 0 -6.89654 ]
[.74455 .10274 25 3.10346 ]
[.81167 .19797 0 -6.84024 ]
[.81167 .19797 8.4375 3.15976 ]
[.87569 .28881 0 -6.7872 ]
[.87569 .28881 19.5 3.2128 ]
[.93683 .37557 0 -6.73712 ]
[.93683 .37557 15.0625 3.26288 ]
[.90758 .16267 0 -6.84024 ]
[.90758 .16267 8 3.15976 ]
[.06357 .25073 -13.9375 -3.04815 ]
[.06357 .25073 0 6.95185 ]
[.04583 .48129 -20.5625 -3.16049 ]
[.04583 .48129 0 6.83951 ]
[.02659 .73148 -8.4375 -3.28285 ]
[.02659 .73148 0 6.71715 ]
[.00564 1.00394 -15.0625 -3.41663 ]
[.00564 1.00394 0 6.58337 ]
[-0.01725 1.30176 -8.4375 -3.56352 ]
[-0.01725 1.30176 0 6.43648 ]
[-0.07007 .76468 -8 -3.28285 ]
[-0.07007 .76468 0 6.71715 ]
[ 0 0 0 0 ]
[ 1 1.62453 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.63703 -80.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
67.437500 12.375000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
71.500000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
76.625000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
98.250000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.0843 .2212 m
.64785 0 L
s
.09701 .21621 m
.10379 .22387 L
s
gsave
.08347 .2009 -80.3756 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.226 .16558 m
.23257 .17341 L
s
gsave
.21284 .14994 -84.0109 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.35834 .11363 m
.36471 .12163 L
s
gsave
.3456 .09765 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4942 .06031 m
.50035 .06847 L
s
gsave
.4819 .04399 -78.0966 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.63369 .00556 m
.63961 .01389 L
s
gsave
.62186 -0.01111 -73.877 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.12255 .20619 m
.12659 .2108 L
s
.14821 .19612 m
.15223 .20075 L
s
.17401 .18599 m
.178 .19064 L
s
.19993 .17581 m
.2039 .18049 L
s
.25219 .1553 m
.25611 .16001 L
s
.27852 .14497 m
.28242 .1497 L
s
.30499 .13458 m
.30886 .13933 L
s
.3316 .12413 m
.33545 .12891 L
s
.38523 .10308 m
.38903 .1079 L
s
.41226 .09247 m
.41603 .09731 L
s
.43943 .08181 m
.44317 .08666 L
s
.46674 .07109 m
.47046 .07596 L
s
.5218 .04948 m
.52546 .05439 L
s
.54955 .03858 m
.55318 .04352 L
s
.57745 .02763 m
.58105 .03259 L
s
.60549 .01662 m
.60907 .0216 L
s
gsave
.2819 .01774 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.64785 0 m
.92348 .39072 L
s
.65508 .01025 m
.64556 .01397 L
s
gsave
.67411 .0028 -61 -10.9564 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.72544 .10999 m
.71588 .11361 L
s
gsave
.74455 .10274 -61 -10.8965 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.79249 .20503 m
.78289 .20856 L
s
gsave
.81167 .19797 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.85644 .29569 m
.84682 .29913 L
s
gsave
.87569 .28881 -61 -10.7872 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.91753 .38228 m
.90787 .38563 L
s
gsave
.93683 .37557 -61 -10.7371 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.66943 .03059 m
.66371 .03281 L
s
.68363 .05073 m
.67791 .05294 L
s
.69771 .07067 m
.69198 .07287 L
s
.71164 .09043 m
.70591 .09261 L
s
.73911 .12936 m
.73337 .13152 L
s
.75264 .14855 m
.7469 .1507 L
s
.76605 .16756 m
.7603 .1697 L
s
.77933 .18638 m
.77358 .18851 L
s
.80552 .2235 m
.79976 .22561 L
s
.81843 .2418 m
.81266 .2439 L
s
.83122 .25993 m
.82545 .26202 L
s
.84389 .2779 m
.83812 .27997 L
s
.86888 .31333 m
.86311 .31538 L
s
.88121 .3308 m
.87543 .33284 L
s
.89343 .34812 m
.88764 .35015 L
s
.90553 .36527 m
.89974 .3673 L
s
gsave
.90758 .16267 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
.08261 .2433 m
.09213 .23959 L
s
gsave
.06357 .25073 -74.9375 -7.04815 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.06502 .47423 m
.07461 .4707 L
s
gsave
.04583 .48129 -81.5625 -7.16049 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.04592 .72484 m
.05559 .72152 L
s
gsave
.02659 .73148 -69.4375 -7.28285 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.02512 .99776 m
.03487 .99468 L
s
gsave
.00564 1.00394 -76.0625 -7.41663 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00239 1.29611 m
.01221 1.29329 L
s
gsave
-0.01725 1.30176 -69.4375 -7.56352 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.07921 .28803 m
.08493 .28582 L
s
.07574 .33346 m
.08147 .33128 L
s
.07222 .37963 m
.07796 .37747 L
s
.06865 .42655 m
.0744 .42441 L
s
.06132 .5227 m
.06709 .52061 L
s
.05757 .57198 m
.06334 .56991 L
s
.05375 .62208 m
.05953 .62004 L
s
.04987 .67303 m
.05566 .67101 L
s
.0419 .77755 m
.04771 .77559 L
s
.03782 .83117 m
.04364 .82924 L
s
.03366 .88573 m
.03949 .88382 L
s
.02943 .94125 m
.03527 .93937 L
s
.02074 1.05529 m
.0266 1.05347 L
s
.01628 1.11386 m
.02214 1.11207 L
s
.01173 1.1735 m
.01761 1.17174 L
s
.0071 1.23424 m
.01299 1.23251 L
s
gsave
-0.07007 .76468 -69 -7.28285 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
.3971 .57309 m
.0843 .2212 L
s
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
.3971 .57309 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
0 0 m
1 0 L
1 1.62453 L
0 1.62453 L
closepath
clip
newpath
.5 Mabswid
.45497 .52499 m .44189 .59924 L .50638 .60568 L p .652 g
F P
0 g
s
.50638 .60568 m .50762 .53036 L .45497 .52499 L p .652 g
F P
0 g
s
.50556 .67826 m .50638 .60568 L .44189 .59924 L p .624 g
F P
0 g
s
.50762 .53036 m .50638 .60568 L .57126 .60145 L p .621 g
F P
0 g
s
.50638 .60568 m .50556 .67826 L .57823 .67362 L p .587 g
F P
0 g
s
.57823 .67362 m .57126 .60145 L .50638 .60568 L p .587 g
F P
0 g
s
.47184 .4526 m .45497 .52499 L .50762 .53036 L p .675 g
F P
0 g
s
.50762 .53036 m .50922 .4565 L .47184 .4526 L p .675 g
F P
0 g
s
.50922 .4565 m .50762 .53036 L .5606 .52683 L p .651 g
F P
0 g
s
.57126 .60145 m .5606 .52683 L .50762 .53036 L p .621 g
F P
0 g
s
.5606 .52683 m .57126 .60145 L .63268 .58675 L p .591 g
F P
0 g
s
.57126 .60145 m .57823 .67362 L .64708 .65749 L p .55 g
F P
0 g
s
.64708 .65749 m .63268 .58675 L .57126 .60145 L p .55 g
F P
0 g
s
.5606 .52683 m .54685 .45394 L .50922 .4565 L p .651 g
F P
0 g
s
.54685 .45394 m .5606 .52683 L .61069 .51459 L p .629 g
F P
0 g
s
.63268 .58675 m .61069 .51459 L .5606 .52683 L p .591 g
F P
0 g
s
.40588 .51101 m .38166 .58245 L .44189 .59924 L p .685 g
F P
0 g
s
.44189 .59924 m .45497 .52499 L .40588 .51101 L p .685 g
F P
0 g
s
.43334 .6712 m .44189 .59924 L .38166 .58245 L p .663 g
F P
0 g
s
.44189 .59924 m .43334 .6712 L .50556 .67826 L p .624 g
F P
0 g
s
.43707 .44249 m .40588 .51101 L .45497 .52499 L p .702 g
F P
0 g
s
.45497 .52499 m .47184 .4526 L .43707 .44249 L p .702 g
F P
0 g
s
.50523 .744 m .50556 .67826 L .43334 .6712 L p .588 g
F P
0 g
s
.50556 .67826 m .50523 .744 L .58107 .73924 L p .545 g
F P
0 g
s
.58107 .73924 m .57823 .67362 L .50556 .67826 L p .545 g
F P
0 g
s
.61069 .51459 m .58236 .44508 L .54685 .45394 L p .629 g
F P
0 g
s
.58236 .44508 m .61069 .51459 L .65476 .49431 L p .609 g
F P
0 g
s
.61069 .51459 m .63268 .58675 L .68691 .56236 L p .562 g
F P
0 g
s
.68691 .56236 m .65476 .49431 L .61069 .51459 L p .562 g
F P
0 g
s
.49159 .3862 m .47184 .4526 L .50922 .4565 L p .698 g
F P
0 g
s
.50922 .4565 m .5111 .38827 L .49159 .3862 L p .698 g
F P
0 g
s
.5111 .38827 m .50922 .4565 L .54685 .45394 L p .681 g
F P
0 g
s
.57823 .67362 m .58107 .73924 L .65296 .72273 L p .498 g
F P
0 g
s
.65296 .72273 m .64708 .65749 L .57823 .67362 L p .498 g
F P
0 g
s
.63268 .58675 m .64708 .65749 L .708 .63068 L p .509 g
F P
0 g
s
.708 .63068 m .68691 .56236 L .63268 .58675 L p .509 g
F P
0 g
s
.54685 .45394 m .53075 .38691 L .5111 .38827 L p .681 g
F P
0 g
s
.53075 .38691 m .54685 .45394 L .58236 .44508 L p .666 g
F P
0 g
s
.40715 .42674 m .36344 .48918 L .40588 .51101 L p .731 g
F P
0 g
s
.40588 .51101 m .43707 .44249 L .40715 .42674 L p .731 g
F P
0 g
s
.38166 .58245 m .40588 .51101 L .36344 .48918 L p .722 g
F P
0 g
s
.38166 .58245 m .3658 .65277 L .43334 .6712 L p .663 g
F P
0 g
s
.42986 .73676 m .43334 .6712 L .3658 .65277 L p .633 g
F P
0 g
s
.43334 .6712 m .42986 .73676 L .50523 .744 L p .588 g
F P
0 g
s
.4735 .38083 m .43707 .44249 L .47184 .4526 L p .716 g
F P
0 g
s
.47184 .4526 m .49159 .3862 L .4735 .38083 L p .716 g
F P
0 g
s
.36344 .48918 m .32938 .55619 L .38166 .58245 L p .722 g
F P
0 g
s
.3658 .65277 m .38166 .58245 L .32938 .55619 L p .707 g
F P
0 g
s
.58236 .44508 m .54924 .3822 L .53075 .38691 L p .666 g
F P
0 g
s
.54924 .3822 m .58236 .44508 L .61346 .43043 L p .654 g
F P
0 g
s
.65476 .49431 m .61346 .43043 L .58236 .44508 L p .609 g
F P
0 g
s
.45802 .3725 m .40715 .42674 L .43707 .44249 L p .736 g
F P
0 g
s
.43707 .44249 m .4735 .38083 L .45802 .3725 L p .736 g
F P
0 g
s
.64708 .65749 m .65296 .72273 L .71662 .69525 L p .442 g
F P
0 g
s
.71662 .69525 m .708 .63068 L .64708 .65749 L p .442 g
F P
0 g
s
.61346 .43043 m .65476 .49431 L .68994 .46712 L p .589 g
F P
0 g
s
.65476 .49431 m .68691 .56236 L .73044 .52957 L p .531 g
F P
0 g
s
.73044 .52957 m .68994 .46712 L .65476 .49431 L p .531 g
F P
0 g
s
.32938 .55619 m .30703 .62389 L .3658 .65277 L p .707 g
F P
0 g
s
.35932 .71789 m .3658 .65277 L .30703 .62389 L p .681 g
F P
0 g
s
.3658 .65277 m .35932 .71789 L .42986 .73676 L p .633 g
F P
0 g
s
.38407 .40631 m .33043 .46075 L .36344 .48918 L p .764 g
F P
0 g
s
.36344 .48918 m .40715 .42674 L .38407 .40631 L p .764 g
F P
0 g
s
.32938 .55619 m .36344 .48918 L .33043 .46075 L p .765 g
F P
0 g
s
.50541 .79893 m .50523 .744 L .42986 .73676 L p .535 g
F P
0 g
s
.50523 .744 m .50541 .79893 L .57952 .79436 L p .484 g
F P
0 g
s
.57952 .79436 m .58107 .73924 L .50523 .744 L p .484 g
F P
0 g
s
.61346 .43043 m .56535 .37445 L .54924 .3822 L p .654 g
F P
0 g
s
.56535 .37445 m .61346 .43043 L .63811 .41088 L p .644 g
F P
0 g
s
.68994 .46712 m .63811 .41088 L .61346 .43043 L p .589 g
F P
0 g
s
.68691 .56236 m .708 .63068 L .75709 .59457 L p .461 g
F P
0 g
s
.75709 .59457 m .73044 .52957 L .68691 .56236 L p .461 g
F P
0 g
s
.44619 .36175 m .38407 .40631 L .40715 .42674 L p .757 g
F P
0 g
s
.40715 .42674 m .45802 .3725 L .44619 .36175 L p .757 g
F P
0 g
s
.58107 .73924 m .57952 .79436 L .64976 .77848 L p .423 g
F P
0 g
s
.64976 .77848 m .65296 .72273 L .58107 .73924 L p .423 g
F P
0 g
s
.5111 .38827 m .51316 .32978 L .49159 .3862 L closepath p .719 g
F P
0 g
s
.53075 .38691 m .51316 .32978 L .5111 .38827 L closepath p .713 g
F P
0 g
s
.33043 .46075 m .28847 .52187 L .32938 .55619 L p .765 g
F P
0 g
s
.30703 .62389 m .32938 .55619 L .28847 .52187 L p .758 g
F P
0 g
s
.54924 .3822 m .51316 .32978 L .53075 .38691 L closepath p .707 g
F P
0 g
s
.43176 .79198 m .42986 .73676 L .35932 .71789 L p .584 g
F P
0 g
s
.42986 .73676 m .43176 .79198 L .50541 .79893 L p .535 g
F P
0 g
s
.49159 .3862 m .51316 .32978 L .4735 .38083 L closepath p .727 g
F P
0 g
s
.56535 .37445 m .51316 .32978 L .54924 .3822 L closepath p .703 g
F P
0 g
s
.4735 .38083 m .51316 .32978 L .45802 .3725 L closepath p .734 g
F P
0 g
s
.63811 .41088 m .57801 .36415 L .56535 .37445 L p .644 g
F P
0 g
s
.57801 .36415 m .63811 .41088 L .65459 .38762 L p .637 g
F P
0 g
s
.63811 .41088 m .68994 .46712 L .71377 .43463 L p .572 g
F P
0 g
s
.71377 .43463 m .65459 .38762 L .63811 .41088 L p .572 g
F P
0 g
s
.57801 .36415 m .51316 .32978 L .56535 .37445 L closepath p .7 g
F P
0 g
s
.708 .63068 m .71662 .69525 L .76799 .65822 L p .367 g
F P
0 g
s
.76799 .65822 m .75709 .59457 L .708 .63068 L p .367 g
F P
0 g
s
.68994 .46712 m .73044 .52957 L .76024 .49023 L p .495 g
F P
0 g
s
.76024 .49023 m .71377 .43463 L .68994 .46712 L p .495 g
F P
0 g
s
.45802 .3725 m .51316 .32978 L .44619 .36175 L closepath p .742 g
F P
0 g
s
.65296 .72273 m .64976 .77848 L .71192 .75208 L p .343 g
F P
0 g
s
.71192 .75208 m .71662 .69525 L .65296 .72273 L p .343 g
F P
0 g
s
.43884 .34927 m .36946 .38246 L .38407 .40631 L p .779 g
F P
0 g
s
.38407 .40631 m .44619 .36175 L .43884 .34927 L p .779 g
F P
0 g
s
.33043 .46075 m .38407 .40631 L .36946 .38246 L p .8 g
F P
0 g
s
.36946 .38246 m .3092 .4274 L .33043 .46075 L p .8 g
F P
0 g
s
.28847 .52187 m .33043 .46075 L .3092 .4274 L p .814 g
F P
0 g
s
.28847 .52187 m .26085 .58608 L .30703 .62389 L p .758 g
F P
0 g
s
.2979 .68829 m .30703 .62389 L .26085 .58608 L p .737 g
F P
0 g
s
.30703 .62389 m .2979 .68829 L .35932 .71789 L p .681 g
F P
0 g
s
.36286 .77383 m .35932 .71789 L .2979 .68829 L p .633 g
F P
0 g
s
.35932 .71789 m .36286 .77383 L .43176 .79198 L p .584 g
F P
0 g
s
.58635 .35196 m .51316 .32978 L .57801 .36415 L closepath p .699 g
F P
0 g
s
.65459 .38762 m .58635 .35196 L .57801 .36415 L p .637 g
F P
0 g
s
.44619 .36175 m .51316 .32978 L .43884 .34927 L closepath p .749 g
F P
0 g
s
.73044 .52957 m .75709 .59457 L .79091 .55114 L p .397 g
F P
0 g
s
.79091 .55114 m .76024 .49023 L .73044 .52957 L p .397 g
F P
0 g
s
.58975 .3387 m .51316 .32978 L .58635 .35196 L closepath p .7 g
F P
0 g
s
.58635 .35196 m .65459 .38762 L .66165 .36215 L p .634 g
F P
0 g
s
.66165 .36215 m .58975 .3387 L .58635 .35196 L p .634 g
F P
0 g
s
.3092 .4274 m .26185 .48145 L .28847 .52187 L p .814 g
F P
0 g
s
.26085 .58608 m .28847 .52187 L .26185 .48145 L p .818 g
F P
0 g
s
.65459 .38762 m .71377 .43463 L .72439 .39884 L p .555 g
F P
0 g
s
.72439 .39884 m .66165 .36215 L .65459 .38762 L p .555 g
F P
0 g
s
.50611 .8394 m .50541 .79893 L .43176 .79198 L p .441 g
F P
0 g
s
.50541 .79893 m .50611 .8394 L .57352 .83529 L p .378 g
F P
0 g
s
.57352 .83529 m .57952 .79436 L .50541 .79893 L p .378 g
F P
0 g
s
.43884 .34927 m .51316 .32978 L .4365 .33589 L closepath p .755 g
F P
0 g
s
.36946 .38246 m .43884 .34927 L .4365 .33589 L p .799 g
F P
0 g
s
.4365 .33589 m .36445 .35673 L .36946 .38246 L p .799 g
F P
0 g
s
.3092 .4274 m .36946 .38246 L .36445 .35673 L p .838 g
F P
0 g
s
.57952 .79436 m .57352 .83529 L .63736 .82103 L p .294 g
F P
0 g
s
.63736 .82103 m .64976 .77848 L .57952 .79436 L p .294 g
F P
0 g
s
.43912 .83315 m .43176 .79198 L .36286 .77383 L p .49 g
F P
0 g
s
.43176 .79198 m .43912 .83315 L .50611 .8394 L p .441 g
F P
0 g
s
.58795 .32524 m .51316 .32978 L .58975 .3387 L closepath p .702 g
F P
0 g
s
.4365 .33589 m .51316 .32978 L .4394 .32251 L closepath p .759 g
F P
0 g
s
.581 .31252 m .51316 .32978 L .58795 .32524 L closepath p .707 g
F P
0 g
s
.56934 .30142 m .51316 .32978 L .581 .31252 L closepath p .713 g
F P
0 g
s
.4394 .32251 m .51316 .32978 L .44737 .31005 L closepath p .762 g
F P
0 g
s
.55374 .29274 m .51316 .32978 L .56934 .30142 L closepath p .721 g
F P
0 g
s
.44737 .31005 m .51316 .32978 L .45992 .29939 L closepath p .762 g
F P
0 g
s
.53529 .2871 m .51316 .32978 L .55374 .29274 L closepath p .73 g
F P
0 g
s
.51527 .28492 m .51316 .32978 L .53529 .2871 L closepath p .739 g
F P
0 g
s
.4951 .28635 m .51316 .32978 L .51527 .28492 L closepath p .747 g
F P
0 g
s
.47621 .2913 m .51316 .32978 L .4951 .28635 L closepath p .754 g
F P
0 g
s
.45992 .29939 m .51316 .32978 L .47621 .2913 L closepath p .759 g
F P
0 g
s
.71662 .69525 m .71192 .75208 L .76205 .71651 L p .222 g
F P
0 g
s
.76205 .71651 m .76799 .65822 L .71662 .69525 L p .222 g
F P
0 g
s
.71377 .43463 m .76024 .49023 L .7739 .44671 L p .452 g
F P
0 g
s
.7739 .44671 m .72439 .39884 L .71377 .43463 L p .452 g
F P
0 g
s
.58975 .3387 m .66165 .36215 L .65863 .33613 L p .635 g
F P
0 g
s
.65863 .33613 m .58795 .32524 L .58975 .3387 L p .635 g
F P
0 g
s
.36445 .35673 m .4365 .33589 L .4394 .32251 L p .817 g
F P
0 g
s
.75709 .59457 m .76799 .65822 L .80348 .61365 L p .253 g
F P
0 g
s
.80348 .61365 m .79091 .55114 L .75709 .59457 L p .253 g
F P
0 g
s
.26085 .58608 m .24954 .64951 L .2979 .68829 L p .737 g
F P
0 g
s
.30288 .7454 m .2979 .68829 L .24954 .64951 L p .683 g
F P
0 g
s
.2979 .68829 m .30288 .7454 L .36286 .77383 L p .633 g
F P
0 g
s
.36445 .35673 m .30149 .3912 L .3092 .4274 L p .838 g
F P
0 g
s
.26185 .48145 m .3092 .4274 L .30149 .3912 L p .87 g
F P
0 g
s
.64976 .77848 m .63736 .82103 L .69375 .79734 L p .169 g
F P
0 g
s
.69375 .79734 m .71192 .75208 L .64976 .77848 L p .169 g
F P
0 g
s
.26185 .48145 m .23057 .54144 L .26085 .58608 L p .818 g
F P
0 g
s
.24954 .64951 m .26085 .58608 L .23057 .54144 L p .8 g
F P
0 g
s
.66165 .36215 m .72439 .39884 L .7207 .36208 L p .54 g
F P
0 g
s
.7207 .36208 m .65863 .33613 L .66165 .36215 L p .54 g
F P
0 g
s
.58795 .32524 m .65863 .33613 L .64553 .31138 L p .641 g
F P
0 g
s
.64553 .31138 m .581 .31252 L .58795 .32524 L p .641 g
F P
0 g
s
.36959 .33083 m .4394 .32251 L .44737 .31005 L p .83 g
F P
0 g
s
.4394 .32251 m .36959 .33083 L .36445 .35673 L p .817 g
F P
0 g
s
.37652 .81685 m .36286 .77383 L .30288 .7454 L p .527 g
F P
0 g
s
.36286 .77383 m .37652 .81685 L .43912 .83315 L p .49 g
F P
0 g
s
.30149 .3912 m .36445 .35673 L .36959 .33083 L p .875 g
F P
0 g
s
.76024 .49023 m .79091 .55114 L .8067 .50297 L p .299 g
F P
0 g
s
.8067 .50297 m .7739 .44671 L .76024 .49023 L p .299 g
F P
0 g
s
.581 .31252 m .64553 .31138 L .62308 .28965 L p .654 g
F P
0 g
s
.62308 .28965 m .56934 .30142 L .581 .31252 L p .654 g
F P
0 g
s
.38472 .30656 m .44737 .31005 L .45992 .29939 L p .832 g
F P
0 g
s
.44737 .31005 m .38472 .30656 L .36959 .33083 L p .83 g
F P
0 g
s
.30149 .3912 m .25176 .43741 L .26185 .48145 L p .87 g
F P
0 g
s
.23057 .54144 m .26185 .48145 L .25176 .43741 L p .885 g
F P
0 g
s
.72439 .39884 m .7739 .44671 L .76993 .40182 L p .391 g
F P
0 g
s
.76993 .40182 m .7207 .36208 L .72439 .39884 L p .391 g
F P
0 g
s
.56934 .30142 m .62308 .28965 L .59274 .27258 L p .674 g
F P
0 g
s
.59274 .27258 m .55374 .29274 L .56934 .30142 L p .674 g
F P
0 g
s
.76799 .65822 m .76205 .71651 L .79662 .67372 L p .061 g
F P
0 g
s
.79662 .67372 m .80348 .61365 L .76799 .65822 L p .061 g
F P
0 g
s
.40895 .28568 m .45992 .29939 L .47621 .2913 L p .823 g
F P
0 g
s
.45992 .29939 m .40895 .28568 L .38472 .30656 L p .832 g
F P
0 g
s
.65863 .33613 m .7207 .36208 L .70253 .32691 L p .526 g
F P
0 g
s
.70253 .32691 m .64553 .31138 L .65863 .33613 L p .526 g
F P
0 g
s
.71192 .75208 m .69375 .79734 L .73908 .76549 L p .058 g
F P
0 g
s
.73908 .76549 m .76205 .71651 L .71192 .75208 L p .058 g
F P
0 g
s
.50731 .86221 m .50611 .8394 L .43912 .83315 L p .225 g
F P
0 g
s
.50611 .8394 m .50731 .86221 L .56326 .85883 L p .148 g
F P
0 g
s
.56326 .85883 m .57352 .83529 L .50611 .8394 L p .148 g
F P
0 g
s
.36959 .33083 m .30821 .35457 L .30149 .3912 L p .875 g
F P
0 g
s
.25176 .43741 m .30149 .3912 L .30821 .35457 L p .922 g
F P
0 g
s
.30821 .35457 m .36959 .33083 L .38472 .30656 L p .899 g
F P
0 g
s
.55374 .29274 m .59274 .27258 L .55662 .26145 L p .702 g
F P
0 g
s
.55662 .26145 m .53529 .2871 L .55374 .29274 L p .702 g
F P
0 g
s
.44068 .26974 m .47621 .2913 L .4951 .28635 L p .801 g
F P
0 g
s
.47621 .2913 m .44068 .26974 L .40895 .28568 L p .823 g
F P
0 g
s
.23057 .54144 m .21774 .60368 L .24954 .64951 L p .8 g
F P
0 g
s
.25571 .70815 m .24954 .64951 L .21774 .60368 L p .713 g
F P
0 g
s
.24954 .64951 m .25571 .70815 L .30288 .7454 L p .683 g
F P
0 g
s
.57352 .83529 m .56326 .85883 L .61617 .84709 L p .099 g
F P
0 g
s
.61617 .84709 m .63736 .82103 L .57352 .83529 L p .099 g
F P
0 g
s
.32214 .79135 m .30288 .7454 L .25571 .70815 L p .533 g
F P
0 g
s
.30288 .7454 m .32214 .79135 L .37652 .81685 L p .527 g
F P
0 g
s
.79091 .55114 m .80348 .61365 L .82018 .56414 L p .057 g
F P
0 g
s
.82018 .56414 m .8067 .50297 L .79091 .55114 L p .057 g
F P
0 g
s
.45171 .85706 m .43912 .83315 L .37652 .81685 L p .263 g
F P
0 g
s
.43912 .83315 m .45171 .85706 L .50731 .86221 L p .225 g
F P
0 g
s
.53529 .2871 m .55662 .26145 L .51731 .25714 L p .734 g
F P
0 g
s
.51731 .25714 m .51527 .28492 L .53529 .2871 L p .734 g
F P
0 g
s
.47769 .25997 m .4951 .28635 L .51527 .28492 L p .769 g
F P
0 g
s
.4951 .28635 m .47769 .25997 L .44068 .26974 L p .801 g
F P
0 g
s
.51527 .28492 m .51731 .25714 L .47769 .25997 L p .769 g
F P
0 g
s
.25176 .43741 m .21878 .49265 L .23057 .54144 L p .885 g
F P
0 g
s
.21774 .60368 m .23057 .54144 L .21878 .49265 L p .839 g
F P
0 g
s
.64553 .31138 m .70253 .32691 L .6708 .29589 L p .514 g
F P
0 g
s
.6708 .29589 m .62308 .28965 L .64553 .31138 L p .514 g
F P
0 g
s
.63736 .82103 m .61617 .84709 L .66276 .82762 L p .031 g
F P
0 g
s
.66276 .82762 m .69375 .79734 L .63736 .82103 L p .031 g
F P
0 g
s
.7739 .44671 m .8067 .50297 L .80268 .45312 L p .144 g
F P
0 g
s
.80268 .45312 m .76993 .40182 L .7739 .44671 L p .144 g
F P
0 g
s
.32931 .32005 m .38472 .30656 L .40895 .28568 L p .893 g
F P
0 g
s
.38472 .30656 m .32931 .32005 L .30821 .35457 L p .899 g
F P
0 g
s
.39985 .84365 m .37652 .81685 L .32214 .79135 L p .262 g
F P
0 g
s
.37652 .81685 m .39985 .84365 L .45171 .85706 L p .263 g
F P
0 g
s
.7207 .36208 m .76993 .40182 L .74797 .35867 L p .296 g
F P
0 g
s
.74797 .35867 m .70253 .32691 L .7207 .36208 L p .296 g
F P
0 g
s
.30821 .35457 m .25948 .39261 L .25176 .43741 L p .922 g
F P
0 g
s
.21878 .49265 m .25176 .43741 L .25948 .39261 L p .911 g
F P
0 g
s
.25948 .39261 m .30821 .35457 L .32931 .32005 L p .926 g
F P
0 g
s
.76205 .71651 m .73908 .76549 L .77017 .72724 L p F P
s
.77017 .72724 m .79662 .67372 L .76205 .71651 L p F P
s
.62308 .28965 m .6708 .29589 L .62751 .27139 L p .507 g
F P
0 g
s
.62751 .27139 m .59274 .27258 L .62308 .28965 L p .507 g
F P
0 g
s
.80348 .61365 m .79662 .67372 L .81282 .62621 L p .013 g
F P
0 g
s
.81282 .62621 m .82018 .56414 L .80348 .61365 L p .013 g
F P
0 g
s
.36364 .29019 m .40895 .28568 L .44068 .26974 L p .839 g
F P
0 g
s
.40895 .28568 m .36364 .29019 L .32931 .32005 L p .893 g
F P
0 g
s
.21774 .60368 m .22474 .66415 L .25571 .70815 L p .713 g
F P
0 g
s
.27952 .758 m .25571 .70815 L .22474 .66415 L p .446 g
F P
0 g
s
.25571 .70815 m .27952 .758 L .32214 .79135 L p .533 g
F P
0 g
s
.69375 .79734 m .66276 .82762 L .7 .80151 L p F P
s
.7 .80151 m .73908 .76549 L .69375 .79734 L p F P
s
.21878 .49265 m .20523 .55352 L .21774 .60368 L p .839 g
F P
0 g
s
.22474 .66415 m .21774 .60368 L .20523 .55352 L p .6 g
F P
0 g
s
.35497 .8227 m .32214 .79135 L .27952 .758 L p .179 g
F P
0 g
s
.32214 .79135 m .35497 .8227 L .39985 .84365 L p .262 g
F P
0 g
s
.8067 .50297 m .82018 .56414 L .81616 .51285 L p .032 g
F P
0 g
s
.81616 .51285 m .80268 .45312 L .8067 .50297 L p .032 g
F P
0 g
s
.59274 .27258 m .62751 .27139 L .57568 .25537 L p .515 g
F P
0 g
s
.57568 .25537 m .55662 .26145 L .59274 .27258 L p .515 g
F P
0 g
s
.40898 .26731 m .44068 .26974 L .47769 .25997 L p .741 g
F P
0 g
s
.44068 .26974 m .40898 .26731 L .36364 .29019 L p .839 g
F P
0 g
s
.50895 .865 m .50731 .86221 L .45171 .85706 L p .044 g
F P
0 g
s
.50731 .86221 m .50895 .865 L .5492 .86257 L p .013 g
F P
0 g
s
.5492 .86257 m .56326 .85883 L .50731 .86221 L p .013 g
F P
0 g
s
.70253 .32691 m .74797 .35867 L .70901 .32044 L p .224 g
F P
0 g
s
.70901 .32044 m .6708 .29589 L .70253 .32691 L p .224 g
F P
0 g
s
.56326 .85883 m .5492 .86257 L .58719 .85414 L p F P
s
.58719 .85414 m .61617 .84709 L .56326 .85883 L p F P
s
.76993 .40182 m .80268 .45312 L .77831 .40506 L p .054 g
F P
0 g
s
.77831 .40506 m .74797 .35867 L .76993 .40182 L p .054 g
F P
0 g
s
.25948 .39261 m .22703 .44288 L .21878 .49265 L p .911 g
F P
0 g
s
.20523 .55352 m .21878 .49265 L .22703 .44288 L p .681 g
F P
0 g
s
.45171 .85706 m .46896 .8613 L .50895 .865 L p .044 g
F P
0 g
s
.46896 .8613 m .45171 .85706 L .39985 .84365 L p .326 g
F P
0 g
s
.55662 .26145 m .57568 .25537 L .51913 .24915 L p .555 g
F P
0 g
s
.51913 .24915 m .51731 .25714 L .55662 .26145 L p .555 g
F P
0 g
s
.46212 .25325 m .47769 .25997 L .51731 .25714 L p .634 g
F P
0 g
s
.47769 .25997 m .46212 .25325 L .40898 .26731 L p .741 g
F P
0 g
s
.28509 .35022 m .32931 .32005 L .36364 .29019 L p .791 g
F P
0 g
s
.32931 .32005 m .28509 .35022 L .25948 .39261 L p .926 g
F P
0 g
s
.51731 .25714 m .51913 .24915 L .46212 .25325 L p .634 g
F P
0 g
s
.22703 .44288 m .25948 .39261 L .28509 .35022 L p .723 g
F P
0 g
s
.61617 .84709 m .58719 .85414 L .6205 .8402 L p .693 g
F P
0 g
s
.6205 .8402 m .66276 .82762 L .61617 .84709 L p .693 g
F P
0 g
s
.73908 .76549 m .7 .80151 L .7253 .77028 L p .815 g
F P
0 g
s
.7253 .77028 m .77017 .72724 L .73908 .76549 L p .815 g
F P
0 g
s
.79662 .67372 m .77017 .72724 L .78451 .68489 L p .791 g
F P
0 g
s
.78451 .68489 m .81282 .62621 L .79662 .67372 L p .791 g
F P
0 g
s
.43174 .85167 m .39985 .84365 L .35497 .8227 L p .346 g
F P
0 g
s
.39985 .84365 m .43174 .85167 L .46896 .8613 L p .326 g
F P
0 g
s
.22474 .66415 m .25173 .7187 L .27952 .758 L p .446 g
F P
0 g
s
.27952 .758 m .32 .79539 L .35497 .8227 L p .179 g
F P
0 g
s
.32 .79539 m .27952 .758 L .25173 .7187 L p .16 g
F P
0 g
s
.20523 .55352 m .21262 .61603 L .22474 .66415 L p .6 g
F P
0 g
s
.25173 .7187 m .22474 .66415 L .21262 .61603 L p .055 g
F P
0 g
s
.6708 .29589 m .70901 .32044 L .65545 .29015 L p .127 g
F P
0 g
s
.65545 .29015 m .62751 .27139 L .6708 .29589 L p .127 g
F P
0 g
s
.82018 .56414 m .81282 .62621 L .8088 .57704 L p .741 g
F P
0 g
s
.8088 .57704 m .81616 .51285 L .82018 .56414 L p .741 g
F P
0 g
s
.36364 .29019 m .32733 .31341 L .28509 .35022 L p .791 g
F P
0 g
s
.32733 .31341 m .36364 .29019 L .40898 .26731 L p F P
s
.66276 .82762 m .6205 .8402 L .64693 .82158 L p .845 g
F P
0 g
s
.64693 .82158 m .7 .80151 L .66276 .82762 L p .845 g
F P
0 g
s
.22703 .44288 m .21367 .5023 L .20523 .55352 L p .681 g
F P
0 g
s
.21262 .61603 m .20523 .55352 L .21367 .5023 L p .036 g
F P
0 g
s
.3997 .83668 m .35497 .8227 L .32 .79539 L p .384 g
F P
0 g
s
.35497 .8227 m .3997 .83668 L .43174 .85167 L p .346 g
F P
0 g
s
.80268 .45312 m .81616 .51285 L .79082 .46333 L p .613 g
F P
0 g
s
.79082 .46333 m .77831 .40506 L .80268 .45312 L p .613 g
F P
0 g
s
.74797 .35867 m .77831 .40506 L .7346 .36237 L p .397 g
F P
0 g
s
.7346 .36237 m .70901 .32044 L .74797 .35867 L p .397 g
F P
0 g
s
.62751 .27139 m .65545 .29015 L .59104 .2703 L p .145 g
F P
0 g
s
.59104 .2703 m .57568 .25537 L .62751 .27139 L p .145 g
F P
0 g
s
.28509 .35022 m .25555 .39564 L .22703 .44288 L p .723 g
F P
0 g
s
.21367 .5023 m .22703 .44288 L .25555 .39564 L p .017 g
F P
0 g
s
.25555 .39564 m .28509 .35022 L .32733 .31341 L p F P
s
.38349 .2851 m .40898 .26731 L .46212 .25325 L p .031 g
F P
0 g
s
.40898 .26731 m .38349 .2851 L .32733 .31341 L p F P
s
.77017 .72724 m .7253 .77028 L .73665 .73584 L p .934 g
F P
0 g
s
.73665 .73584 m .78451 .68489 L .77017 .72724 L p .934 g
F P
0 g
s
.51094 .8465 m .50895 .865 L .46896 .8613 L p .696 g
F P
0 g
s
.50895 .865 m .51094 .8465 L .53214 .84521 L p .74 g
F P
0 g
s
.53214 .84521 m .5492 .86257 L .50895 .865 L p .74 g
F P
0 g
s
.7 .80151 m .64693 .82158 L .66464 .79941 L p .913 g
F P
0 g
s
.66464 .79941 m .7253 .77028 L .7 .80151 L p .913 g
F P
0 g
s
.5492 .86257 m .53214 .84521 L .55209 .84075 L p .787 g
F P
0 g
s
.55209 .84075 m .58719 .85414 L .5492 .86257 L p .787 g
F P
0 g
s
.48989 .84454 m .46896 .8613 L .43174 .85167 L p .663 g
F P
0 g
s
.46896 .8613 m .48989 .84454 L .51094 .8465 L p .696 g
F P
0 g
s
.57568 .25537 m .59104 .2703 L .5206 .26258 L p .13 g
F P
0 g
s
.5206 .26258 m .51913 .24915 L .57568 .25537 L p .13 g
F P
0 g
s
.81282 .62621 m .78451 .68489 L .78051 .64116 L p .899 g
F P
0 g
s
.78051 .64116 m .8088 .57704 L .81282 .62621 L p .899 g
F P
0 g
s
.21262 .61603 m .2411 .67583 L .25173 .7187 L p .055 g
F P
0 g
s
.29746 .76332 m .25173 .7187 L .2411 .67583 L p .271 g
F P
0 g
s
.25173 .7187 m .29746 .76332 L .32 .79539 L p .16 g
F P
0 g
s
.44958 .26766 m .46212 .25325 L .51913 .24915 L p .092 g
F P
0 g
s
.46212 .25325 m .44958 .26766 L .38349 .2851 L p .031 g
F P
0 g
s
.37494 .81722 m .32 .79539 L .29746 .76332 L p .447 g
F P
0 g
s
.32 .79539 m .37494 .81722 L .3997 .83668 L p .384 g
F P
0 g
s
.51913 .24915 m .5206 .26258 L .44958 .26766 L p .092 g
F P
0 g
s
.58719 .85414 m .55209 .84075 L .5695 .83341 L p .827 g
F P
0 g
s
.5695 .83341 m .6205 .8402 L .58719 .85414 L p .827 g
F P
0 g
s
.47036 .83945 m .43174 .85167 L .3997 .83668 L p .641 g
F P
0 g
s
.43174 .85167 m .47036 .83945 L .48989 .84454 L p .663 g
F P
0 g
s
.21367 .5023 m .22097 .56693 L .21262 .61603 L p .036 g
F P
0 g
s
.2411 .67583 m .21262 .61603 L .22097 .56693 L p .166 g
F P
0 g
s
.70901 .32044 m .7346 .36237 L .67421 .32847 L p .442 g
F P
0 g
s
.67421 .32847 m .65545 .29015 L .70901 .32044 L p .442 g
F P
0 g
s
.81616 .51285 m .8088 .57704 L .78399 .52959 L p .803 g
F P
0 g
s
.78399 .52959 m .79082 .46333 L .81616 .51285 L p .803 g
F P
0 g
s
.45025 1.00576 m .43612 1.08601 L .50583 1.09201 L p .653 g
F P
0 g
s
.50583 1.09201 m .50717 1.01079 L .45025 1.00576 L p .653 g
F P
0 g
s
.50495 1.17257 m .50583 1.09201 L .43612 1.08601 L p .624 g
F P
0 g
s
.50717 1.01079 m .50583 1.09201 L .57596 1.08807 L p .62 g
F P
0 g
s
.50583 1.09201 m .50495 1.17257 L .58352 1.16826 L p .585 g
F P
0 g
s
.58352 1.16826 m .57596 1.08807 L .50583 1.09201 L p .585 g
F P
0 g
s
.46847 .92967 m .45025 1.00576 L .50717 1.01079 L p .68 g
F P
0 g
s
.50717 1.01079 m .5089 .93333 L .46847 .92967 L p .68 g
F P
0 g
s
.5089 .93333 m .50717 1.01079 L .56445 1.00749 L p .653 g
F P
0 g
s
.57596 1.08807 m .56445 1.00749 L .50717 1.01079 L p .62 g
F P
0 g
s
.56445 1.00749 m .57596 1.08807 L .64241 1.07436 L p .588 g
F P
0 g
s
.57596 1.08807 m .58352 1.16826 L .65803 1.1533 L p .545 g
F P
0 g
s
.65803 1.1533 m .64241 1.07436 L .57596 1.08807 L p .545 g
F P
0 g
s
.56445 1.00749 m .5496 .93093 L .5089 .93333 L p .653 g
F P
0 g
s
.5496 .93093 m .56445 1.00749 L .61862 .99601 L p .628 g
F P
0 g
s
.64241 1.07436 m .61862 .99601 L .56445 1.00749 L p .588 g
F P
0 g
s
.303 .3545 m .32733 .31341 L .38349 .2851 L p .079 g
F P
0 g
s
.32733 .31341 m .303 .3545 L .25555 .39564 L p F P
s
.39715 .99265 m .37095 1.07035 L .43612 1.08601 L p .689 g
F P
0 g
s
.43612 1.08601 m .45025 1.00576 L .39715 .99265 L p .689 g
F P
0 g
s
.42684 1.16602 m .43612 1.08601 L .37095 1.07035 L p .665 g
F P
0 g
s
.43612 1.08601 m .42684 1.16602 L .50495 1.17257 L p .624 g
F P
0 g
s
.43085 .92014 m .39715 .99265 L .45025 1.00576 L p .71 g
F P
0 g
s
.45025 1.00576 m .46847 .92967 L .43085 .92014 L p .71 g
F P
0 g
s
.77831 .40506 m .79082 .46333 L .74518 .4193 L p .658 g
F P
0 g
s
.74518 .4193 m .7346 .36237 L .77831 .40506 L p .658 g
F P
0 g
s
.6205 .8402 m .5695 .83341 L .58318 .82364 L p .851 g
F P
0 g
s
.58318 .82364 m .64693 .82158 L .6205 .8402 L p .851 g
F P
0 g
s
.25555 .39564 m .24336 .45361 L .21367 .5023 L p .017 g
F P
0 g
s
.22097 .56693 m .21367 .5023 L .24336 .45361 L p .119 g
F P
0 g
s
.45364 .83156 m .3997 .83668 L .37494 .81722 L p .629 g
F P
0 g
s
.3997 .83668 m .45364 .83156 L .47036 .83945 L p .641 g
F P
0 g
s
.50458 1.24799 m .50495 1.17257 L .42684 1.16602 L p .587 g
F P
0 g
s
.50495 1.17257 m .50458 1.24799 L .58664 1.24361 L p .543 g
F P
0 g
s
.58664 1.24361 m .58352 1.16826 L .50495 1.17257 L p .543 g
F P
0 g
s
.24336 .45361 m .25555 .39564 L .303 .3545 L p .097 g
F P
0 g
s
.7253 .77028 m .66464 .79941 L .67228 .7751 L p .909 g
F P
0 g
s
.67228 .7751 m .73665 .73584 L .7253 .77028 L p .909 g
F P
0 g
s
.61862 .99601 m .588 .92258 L .5496 .93093 L p .628 g
F P
0 g
s
.588 .92258 m .61862 .99601 L .66634 .97697 L p .605 g
F P
0 g
s
.61862 .99601 m .64241 1.07436 L .70115 1.05159 L p .555 g
F P
0 g
s
.70115 1.05159 m .66634 .97697 L .61862 .99601 L p .555 g
F P
0 g
s
.48982 .86203 m .46847 .92967 L .5089 .93333 L p .706 g
F P
0 g
s
.5089 .93333 m .51093 .86399 L .48982 .86203 L p .706 g
F P
0 g
s
.51093 .86399 m .5089 .93333 L .5496 .93093 L p .687 g
F P
0 g
s
.58352 1.16826 m .58664 1.24361 L .66449 1.22838 L p .495 g
F P
0 g
s
.66449 1.22838 m .65803 1.1533 L .58352 1.16826 L p .495 g
F P
0 g
s
.64241 1.07436 m .65803 1.1533 L .72406 1.12841 L p .501 g
F P
0 g
s
.72406 1.12841 m .70115 1.05159 L .64241 1.07436 L p .501 g
F P
0 g
s
.78451 .68489 m .73665 .73584 L .73287 .70043 L p .906 g
F P
0 g
s
.73287 .70043 m .78051 .64116 L .78451 .68489 L p .906 g
F P
0 g
s
.5496 .93093 m .53219 .8627 L .51093 .86399 L p .687 g
F P
0 g
s
.53219 .8627 m .5496 .93093 L .588 .92258 L p .67 g
F P
0 g
s
.39845 .9053 m .35117 .97217 L .39715 .99265 L p .743 g
F P
0 g
s
.39715 .99265 m .43085 .92014 L .39845 .9053 L p .743 g
F P
0 g
s
.37095 1.07035 m .39715 .99265 L .35117 .97217 L p .73 g
F P
0 g
s
.37095 1.07035 m .35373 1.14892 L .42684 1.16602 L p .665 g
F P
0 g
s
.42301 1.24132 m .42684 1.16602 L .35373 1.14892 L p .632 g
F P
0 g
s
.42684 1.16602 m .42301 1.24132 L .50458 1.24799 L p .587 g
F P
0 g
s
.47024 .85696 m .43085 .92014 L .46847 .92967 L p .727 g
F P
0 g
s
.46847 .92967 m .48982 .86203 L .47024 .85696 L p .727 g
F P
0 g
s
.2411 .67583 m .28918 .72849 L .29746 .76332 L p .271 g
F P
0 g
s
.35923 .79449 m .29746 .76332 L .28918 .72849 L p .493 g
F P
0 g
s
.29746 .76332 m .35923 .79449 L .37494 .81722 L p .447 g
F P
0 g
s
.35117 .97217 m .31429 1.04582 L .37095 1.07035 L p .73 g
F P
0 g
s
.35373 1.14892 m .37095 1.07035 L .31429 1.04582 L p .71 g
F P
0 g
s
.65545 .29015 m .67421 .32847 L .60136 .30621 L p .424 g
F P
0 g
s
.60136 .30621 m .59104 .2703 L .65545 .29015 L p .424 g
F P
0 g
s
.64693 .82158 m .58318 .82364 L .5922 .81208 L p .856 g
F P
0 g
s
.5922 .81208 m .66464 .79941 L .64693 .82158 L p .856 g
F P
0 g
s
.22097 .56693 m .249 .63218 L .2411 .67583 L p .166 g
F P
0 g
s
.28918 .72849 m .2411 .67583 L .249 .63218 L p .388 g
F P
0 g
s
.588 .92258 m .5522 .85826 L .53219 .8627 L p .67 g
F P
0 g
s
.5522 .85826 m .588 .92258 L .62168 .90878 L p .656 g
F P
0 g
s
.66634 .97697 m .62168 .90878 L .588 .92258 L p .605 g
F P
0 g
s
.36637 .32281 m .38349 .2851 L .44958 .26766 L p .18 g
F P
0 g
s
.38349 .2851 m .36637 .32281 L .303 .3545 L p .079 g
F P
0 g
s
.44085 .82136 m .37494 .81722 L .35923 .79449 L p .623 g
F P
0 g
s
.37494 .81722 m .44085 .82136 L .45364 .83156 L p .629 g
F P
0 g
s
.45347 .84909 m .39845 .9053 L .43085 .92014 L p .75 g
F P
0 g
s
.43085 .92014 m .47024 .85696 L .45347 .84909 L p .75 g
F P
0 g
s
.8088 .57704 m .78051 .64116 L .75776 .59908 L p .845 g
F P
0 g
s
.75776 .59908 m .78399 .52959 L .8088 .57704 L p .845 g
F P
0 g
s
.65803 1.1533 m .66449 1.22838 L .73355 1.20302 L p .437 g
F P
0 g
s
.73355 1.20302 m .72406 1.12841 L .65803 1.1533 L p .437 g
F P
0 g
s
.62168 .90878 m .66634 .97697 L .70451 .95144 L p .582 g
F P
0 g
s
.66634 .97697 m .70115 1.05159 L .74843 1.02093 L p .519 g
F P
0 g
s
.74843 1.02093 m .70451 .95144 L .66634 .97697 L p .519 g
F P
0 g
s
.51316 .80695 m .51094 .8465 L .48989 .84454 L closepath p .748 g
F P
0 g
s
.51316 .80695 m .53214 .84521 L .51094 .8465 L closepath p .759 g
F P
0 g
s
.31429 1.04582 m .29 1.1221 L .35373 1.14892 L p .71 g
F P
0 g
s
.34662 1.22391 m .35373 1.14892 L .29 1.1221 L p .682 g
F P
0 g
s
.35373 1.14892 m .34662 1.22391 L .42301 1.24132 L p .632 g
F P
0 g
s
.51316 .80695 m .55209 .84075 L .53214 .84521 L closepath p .768 g
F P
0 g
s
.51316 .80695 m .48989 .84454 L .47036 .83945 L closepath p .738 g
F P
0 g
s
.37341 .88604 m .31533 .94545 L .35117 .97217 L p .78 g
F P
0 g
s
.35117 .97217 m .39845 .9053 L .37341 .88604 L p .78 g
F P
0 g
s
.31429 1.04582 m .35117 .97217 L .31533 .94545 L p .777 g
F P
0 g
s
.59104 .2703 m .60136 .30621 L .52159 .29754 L p .372 g
F P
0 g
s
.52159 .29754 m .5206 .26258 L .59104 .2703 L p .372 g
F P
0 g
s
.24336 .45361 m .25002 .52029 L .22097 .56693 L p .119 g
F P
0 g
s
.249 .63218 m .22097 .56693 L .25002 .52029 L p .329 g
F P
0 g
s
.50477 1.31386 m .50458 1.24799 L .42301 1.24132 L p .538 g
F P
0 g
s
.50458 1.24799 m .50477 1.31386 L .58503 1.30967 L p .487 g
F P
0 g
s
.58503 1.30967 m .58664 1.24361 L .50458 1.24799 L p .487 g
F P
0 g
s
.62168 .90878 m .56965 .85093 L .5522 .85826 L p .656 g
F P
0 g
s
.56965 .85093 m .62168 .90878 L .6484 .89035 L p .643 g
F P
0 g
s
.70451 .95144 m .6484 .89035 L .62168 .90878 L p .582 g
F P
0 g
s
.70115 1.05159 m .72406 1.12841 L .77742 1.09483 L p .448 g
F P
0 g
s
.77742 1.09483 m .74843 1.02093 L .70115 1.05159 L p .448 g
F P
0 g
s
.7346 .36237 m .74518 .4193 L .68197 .38429 L p .618 g
F P
0 g
s
.68197 .38429 m .67421 .32847 L .7346 .36237 L p .618 g
F P
0 g
s
.44114 .30324 m .44958 .26766 L .5206 .26258 L p .295 g
F P
0 g
s
.44958 .26766 m .44114 .30324 L .36637 .32281 L p .18 g
F P
0 g
s
.79082 .46333 m .78399 .52959 L .7394 .48743 L p .747 g
F P
0 g
s
.7394 .48743 m .74518 .4193 L .79082 .46333 L p .747 g
F P
0 g
s
.51316 .80695 m .5695 .83341 L .55209 .84075 L closepath p .774 g
F P
0 g
s
.44065 .83892 m .37341 .88604 L .39845 .9053 L p .774 g
F P
0 g
s
.39845 .9053 m .45347 .84909 L .44065 .83892 L p .774 g
F P
0 g
s
.51316 .80695 m .47036 .83945 L .45364 .83156 L closepath p .728 g
F P
0 g
s
.66464 .79941 m .5922 .81208 L .5959 .79949 L p .845 g
F P
0 g
s
.5959 .79949 m .67228 .7751 L .66464 .79941 L p .845 g
F P
0 g
s
.58664 1.24361 m .58503 1.30967 L .66116 1.29512 L p .428 g
F P
0 g
s
.66116 1.29512 m .66449 1.22838 L .58664 1.24361 L p .428 g
F P
0 g
s
.73665 .73584 m .67228 .7751 L .66912 .75025 L p .871 g
F P
0 g
s
.66912 .75025 m .73287 .70043 L .73665 .73584 L p .871 g
F P
0 g
s
.51093 .86399 m .51316 .80695 L .48982 .86203 L closepath p .731 g
F P
0 g
s
.53219 .8627 m .51316 .80695 L .51093 .86399 L closepath p .724 g
F P
0 g
s
.5206 .26258 m .52159 .29754 L .44114 .30324 L p .295 g
F P
0 g
s
.31533 .94545 m .26983 1.01373 L .31429 1.04582 L p .777 g
F P
0 g
s
.29 1.1221 m .31429 1.04582 L .26983 1.01373 L p .764 g
F P
0 g
s
.5522 .85826 m .51316 .80695 L .53219 .8627 L closepath p .717 g
F P
0 g
s
.42499 1.30749 m .42301 1.24132 L .34662 1.22391 L p .586 g
F P
0 g
s
.42301 1.24132 m .42499 1.30749 L .50477 1.31386 L p .538 g
F P
0 g
s
.48982 .86203 m .51316 .80695 L .47024 .85696 L closepath p .74 g
F P
0 g
s
.29294 .41118 m .303 .3545 L .36637 .32281 L p .263 g
F P
0 g
s
.303 .3545 m .29294 .41118 L .24336 .45361 L p .097 g
F P
0 g
s
.28918 .72849 m .35379 .76993 L .35923 .79449 L p .493 g
F P
0 g
s
.4329 .80952 m .35923 .79449 L .35379 .76993 L p .622 g
F P
0 g
s
.35923 .79449 m .4329 .80952 L .44085 .82136 L p .623 g
F P
0 g
s
.51316 .80695 m .58318 .82364 L .5695 .83341 L closepath p .778 g
F P
0 g
s
.25002 .52029 m .24336 .45361 L .29294 .41118 L p .297 g
F P
0 g
s
.51316 .80695 m .45364 .83156 L .44085 .82136 L closepath p .719 g
F P
0 g
s
.56965 .85093 m .51316 .80695 L .5522 .85826 L closepath p .711 g
F P
0 g
s
.47024 .85696 m .51316 .80695 L .45347 .84909 L closepath p .749 g
F P
0 g
s
.249 .63218 m .29617 .69318 L .28918 .72849 L p .388 g
F P
0 g
s
.35379 .76993 m .28918 .72849 L .29617 .69318 L p .527 g
F P
0 g
s
.78051 .64116 m .73287 .70043 L .71375 .66651 L p .844 g
F P
0 g
s
.71375 .66651 m .75776 .59908 L .78051 .64116 L p .844 g
F P
0 g
s
.6484 .89035 m .58338 .84119 L .56965 .85093 L p .643 g
F P
0 g
s
.58338 .84119 m .6484 .89035 L .66632 .8684 L p .633 g
F P
0 g
s
.6484 .89035 m .70451 .95144 L .73047 .92088 L p .559 g
F P
0 g
s
.73047 .92088 m .66632 .8684 L .6484 .89035 L p .559 g
F P
0 g
s
.58338 .84119 m .51316 .80695 L .56965 .85093 L closepath p .708 g
F P
0 g
s
.51316 .80695 m .5922 .81208 L .58318 .82364 L closepath p .779 g
F P
0 g
s
.72406 1.12841 m .73355 1.20302 L .78944 1.16878 L p .36 g
F P
0 g
s
.78944 1.16878 m .77742 1.09483 L .72406 1.12841 L p .36 g
F P
0 g
s
.70451 .95144 m .74843 1.02093 L .78093 .9841 L p .475 g
F P
0 g
s
.78093 .9841 m .73047 .92088 L .70451 .95144 L p .475 g
F P
0 g
s
.45347 .84909 m .51316 .80695 L .44065 .83892 L closepath p .758 g
F P
0 g
s
.51316 .80695 m .44085 .82136 L .4329 .80952 L closepath p .713 g
F P
0 g
s
.66449 1.22838 m .66116 1.29512 L .72866 1.27089 L p .351 g
F P
0 g
s
.72866 1.27089 m .73355 1.20302 L .66449 1.22838 L p .351 g
F P
0 g
s
.43267 .82711 m .35752 .86352 L .37341 .88604 L p .8 g
F P
0 g
s
.37341 .88604 m .44065 .83892 L .43267 .82711 L p .8 g
F P
0 g
s
.31533 .94545 m .37341 .88604 L .35752 .86352 L p .821 g
F P
0 g
s
.35752 .86352 m .29219 .91407 L .31533 .94545 L p .821 g
F P
0 g
s
.26983 1.01373 m .31533 .94545 L .29219 .91407 L p .832 g
F P
0 g
s
.26983 1.01373 m .23976 1.08693 L .29 1.1221 L p .764 g
F P
0 g
s
.27994 1.19659 m .29 1.1221 L .23976 1.08693 L p .738 g
F P
0 g
s
.29 1.1221 m .27994 1.19659 L .34662 1.22391 L p .682 g
F P
0 g
s
.25002 .52029 m .27556 .59084 L .249 .63218 L p .329 g
F P
0 g
s
.29617 .69318 m .249 .63218 L .27556 .59084 L p .46 g
F P
0 g
s
.35028 1.29085 m .34662 1.22391 L .27994 1.19659 L p .634 g
F P
0 g
s
.34662 1.22391 m .35028 1.29085 L .42499 1.30749 L p .586 g
F P
0 g
s
.67228 .7751 m .5959 .79949 L .59397 .78671 L p .826 g
F P
0 g
s
.59397 .78671 m .66912 .75025 L .67228 .7751 L p .826 g
F P
0 g
s
.59242 .82966 m .51316 .80695 L .58338 .84119 L closepath p .706 g
F P
0 g
s
.66632 .8684 m .59242 .82966 L .58338 .84119 L p .633 g
F P
0 g
s
.67421 .32847 m .68197 .38429 L .60564 .36129 L p .566 g
F P
0 g
s
.60564 .36129 m .60136 .30621 L .67421 .32847 L p .566 g
F P
0 g
s
.51316 .80695 m .5959 .79949 L .5922 .81208 L closepath p .777 g
F P
0 g
s
.44065 .83892 m .51316 .80695 L .43267 .82711 L closepath p .766 g
F P
0 g
s
.74843 1.02093 m .77742 1.09483 L .81437 1.05438 L p .374 g
F P
0 g
s
.81437 1.05438 m .78093 .9841 L .74843 1.02093 L p .374 g
F P
0 g
s
.35379 .76993 m .43035 .79682 L .4329 .80952 L p .622 g
F P
0 g
s
.51316 .80695 m .4329 .80952 L .43035 .79682 L closepath p .708 g
F P
0 g
s
.29617 .69318 m .35922 .74519 L .35379 .76993 L p .527 g
F P
0 g
s
.43035 .79682 m .35379 .76993 L .35922 .74519 L p .626 g
F P
0 g
s
.78399 .52959 m .75776 .59908 L .71726 .56178 L p .776 g
F P
0 g
s
.71726 .56178 m .7394 .48743 L .78399 .52959 L p .776 g
F P
0 g
s
.35929 .37845 m .36637 .32281 L .44114 .30324 L p .372 g
F P
0 g
s
.36637 .32281 m .35929 .37845 L .29294 .41118 L p .263 g
F P
0 g
s
.73287 .70043 m .66912 .75025 L .65514 .72659 L p .827 g
F P
0 g
s
.65514 .72659 m .71375 .66651 L .73287 .70043 L p .827 g
F P
0 g
s
.59613 .81709 m .51316 .80695 L .59242 .82966 L closepath p .706 g
F P
0 g
s
.59242 .82966 m .66632 .8684 L .67406 .84432 L p .627 g
F P
0 g
s
.67406 .84432 m .59613 .81709 L .59242 .82966 L p .627 g
F P
0 g
s
.29219 .91407 m .24075 .97587 L .26983 1.01373 L p .832 g
F P
0 g
s
.23976 1.08693 m .26983 1.01373 L .24075 .97587 L p .829 g
F P
0 g
s
.74518 .4193 m .7394 .48743 L .67773 .45393 L p .685 g
F P
0 g
s
.67773 .45393 m .68197 .38429 L .74518 .4193 L p .685 g
F P
0 g
s
.66632 .8684 m .73047 .92088 L .74216 .88717 L p .534 g
F P
0 g
s
.74216 .88717 m .67406 .84432 L .66632 .8684 L p .534 g
F P
0 g
s
.50552 1.36593 m .50477 1.31386 L .42499 1.30749 L p .459 g
F P
0 g
s
.50477 1.31386 m .50552 1.36593 L .57861 1.36218 L p .401 g
F P
0 g
s
.57861 1.36218 m .58503 1.30967 L .50477 1.31386 L p .401 g
F P
0 g
s
.29294 .41118 m .29843 .47966 L .25002 .52029 L p .297 g
F P
0 g
s
.27556 .59084 m .25002 .52029 L .29843 .47966 L p .423 g
F P
0 g
s
.43267 .82711 m .51316 .80695 L .43012 .81443 L closepath p .772 g
F P
0 g
s
.35752 .86352 m .43267 .82711 L .43012 .81443 L p .824 g
F P
0 g
s
.51316 .80695 m .59397 .78671 L .5959 .79949 L closepath p .772 g
F P
0 g
s
.43012 .81443 m .352 .8392 L .35752 .86352 L p .824 g
F P
0 g
s
.29219 .91407 m .35752 .86352 L .352 .8392 L p .864 g
F P
0 g
s
.35922 .74519 m .43345 .78411 L .43035 .79682 L p .626 g
F P
0 g
s
.51316 .80695 m .43035 .79682 L .43345 .78411 L closepath p .706 g
F P
0 g
s
.58503 1.30967 m .57861 1.36218 L .64789 1.34918 L p .326 g
F P
0 g
s
.64789 1.34918 m .66116 1.29512 L .58503 1.30967 L p .326 g
F P
0 g
s
.27556 .59084 m .3184 .65988 L .29617 .69318 L p .46 g
F P
0 g
s
.35922 .74519 m .29617 .69318 L .3184 .65988 L p .555 g
F P
0 g
s
.29843 .47966 m .29294 .41118 L .35929 .37845 L p .401 g
F P
0 g
s
.43286 1.36023 m .42499 1.30749 L .35028 1.29085 L p .507 g
F P
0 g
s
.42499 1.30749 m .43286 1.36023 L .50552 1.36593 L p .459 g
F P
0 g
s
.5942 .80435 m .51316 .80695 L .59613 .81709 L closepath p .708 g
F P
0 g
s
.58669 .79229 m .51316 .80695 L .5942 .80435 L closepath p .713 g
F P
0 g
s
.51316 .80695 m .43345 .78411 L .44205 .77227 L closepath p .706 g
F P
0 g
s
.43012 .81443 m .51316 .80695 L .43323 .80176 L closepath p .777 g
F P
0 g
s
.51316 .80695 m .58648 .77462 L .59397 .78671 L closepath p .766 g
F P
0 g
s
.57406 .78176 m .51316 .80695 L .58669 .79229 L closepath p .719 g
F P
0 g
s
.51316 .80695 m .44205 .77227 L .45561 .76214 L closepath p .708 g
F P
0 g
s
.43323 .80176 m .51316 .80695 L .44185 .78995 L closepath p .779 g
F P
0 g
s
.51316 .80695 m .57389 .76407 L .58648 .77462 L closepath p .758 g
F P
0 g
s
.51316 .80695 m .55704 .75581 L .57389 .76407 L closepath p .749 g
F P
0 g
s
.55717 .77352 m .51316 .80695 L .57406 .78176 L closepath p .728 g
F P
0 g
s
.51316 .80695 m .45561 .76214 L .4732 .75444 L closepath p .711 g
F P
0 g
s
.44185 .78995 m .51316 .80695 L .45544 .77984 L closepath p .778 g
F P
0 g
s
.51316 .80695 m .53709 .75045 L .55704 .75581 L closepath p .74 g
F P
0 g
s
.53716 .76817 m .51316 .80695 L .55717 .77352 L closepath p .738 g
F P
0 g
s
.51316 .80695 m .4732 .75444 L .49363 .74974 L closepath p .717 g
F P
0 g
s
.45544 .77984 m .51316 .80695 L .47309 .77216 L closepath p .774 g
F P
0 g
s
.51316 .80695 m .51544 .74837 L .53709 .75045 L closepath p .731 g
F P
0 g
s
.51545 .7661 m .51316 .80695 L .53716 .76817 L closepath p .748 g
F P
0 g
s
.51316 .80695 m .49363 .74974 L .51544 .74837 L closepath p .724 g
F P
0 g
s
.47309 .77216 m .51316 .80695 L .49357 .76746 L closepath p .768 g
F P
0 g
s
.49357 .76746 m .51316 .80695 L .51545 .7661 L closepath p .759 g
F P
0 g
s
.60136 .30621 m .60564 .36129 L .522 .35234 L p .511 g
F P
0 g
s
.522 .35234 m .52159 .29754 L .60136 .30621 L p .511 g
F P
0 g
s
.73355 1.20302 m .72866 1.27089 L .78325 1.23819 L p .236 g
F P
0 g
s
.78325 1.23819 m .78944 1.16878 L .73355 1.20302 L p .236 g
F P
0 g
s
.73047 .92088 m .78093 .9841 L .79602 .94327 L p .417 g
F P
0 g
s
.79602 .94327 m .74216 .88717 L .73047 .92088 L p .417 g
F P
0 g
s
.43765 .35823 m .44114 .30324 L .52159 .29754 L p .449 g
F P
0 g
s
.44114 .30324 m .43765 .35823 L .35929 .37845 L p .372 g
F P
0 g
s
.59613 .81709 m .67406 .84432 L .67088 .81971 L p .624 g
F P
0 g
s
.67088 .81971 m .5942 .80435 L .59613 .81709 L p .624 g
F P
0 g
s
.66912 .75025 m .59397 .78671 L .58648 .77462 L p .801 g
F P
0 g
s
.58648 .77462 m .65514 .72659 L .66912 .75025 L p .801 g
F P
0 g
s
.352 .8392 m .43012 .81443 L .43323 .80176 L p .843 g
F P
0 g
s
.77742 1.09483 m .78944 1.16878 L .82826 1.12749 L p .239 g
F P
0 g
s
.82826 1.12749 m .81437 1.05438 L .77742 1.09483 L p .239 g
F P
0 g
s
.52159 .29754 m .522 .35234 L .43765 .35823 L p .449 g
F P
0 g
s
.3184 .65988 m .37538 .72198 L .35922 .74519 L p .555 g
F P
0 g
s
.43345 .78411 m .35922 .74519 L .37538 .72198 L p .633 g
F P
0 g
s
.23976 1.08693 m .22729 1.16072 L .27994 1.19659 L p .738 g
F P
0 g
s
.28513 1.26475 m .27994 1.19659 L .22729 1.16072 L p .684 g
F P
0 g
s
.27994 1.19659 m .28513 1.26475 L .35028 1.29085 L p .634 g
F P
0 g
s
.75776 .59908 m .71375 .66651 L .68022 .63655 L p .785 g
F P
0 g
s
.68022 .63655 m .71726 .56178 L .75776 .59908 L p .785 g
F P
0 g
s
.37538 .72198 m .44205 .77227 L .43345 .78411 L p .633 g
F P
0 g
s
.352 .8392 m .28365 .87997 L .29219 .91407 L p .864 g
F P
0 g
s
.24075 .97587 m .29219 .91407 L .28365 .87997 L p .892 g
F P
0 g
s
.66116 1.29512 m .64789 1.34918 L .70918 1.32756 L p .217 g
F P
0 g
s
.70918 1.32756 m .72866 1.27089 L .66116 1.29512 L p .217 g
F P
0 g
s
.24075 .97587 m .20663 1.04532 L .23976 1.08693 L p .829 g
F P
0 g
s
.22729 1.16072 m .23976 1.08693 L .20663 1.04532 L p .801 g
F P
0 g
s
.67406 .84432 m .74216 .88717 L .73834 .85249 L p .505 g
F P
0 g
s
.73834 .85249 m .67088 .81971 L .67406 .84432 L p .505 g
F P
0 g
s
.5942 .80435 m .67088 .81971 L .65675 .79627 L p .625 g
F P
0 g
s
.65675 .79627 m .58669 .79229 L .5942 .80435 L p .625 g
F P
0 g
s
.29843 .47966 m .31948 .55491 L .27556 .59084 L p .423 g
F P
0 g
s
.3184 .65988 m .27556 .59084 L .31948 .55491 L p .51 g
F P
0 g
s
.65514 .72659 m .58648 .77462 L .57389 .76407 L p .776 g
F P
0 g
s
.35748 .81469 m .43323 .80176 L .44185 .78995 L p .854 g
F P
0 g
s
.43323 .80176 m .35748 .81469 L .352 .8392 L p .843 g
F P
0 g
s
.36491 1.34537 m .35028 1.29085 L .28513 1.26475 L p .546 g
F P
0 g
s
.35028 1.29085 m .36491 1.34537 L .43286 1.36023 L p .507 g
F P
0 g
s
.40132 .702 m .45561 .76214 L .44205 .77227 L p .643 g
F P
0 g
s
.44205 .77227 m .37538 .72198 L .40132 .702 L p .643 g
F P
0 g
s
.28365 .87997 m .352 .8392 L .35748 .81469 L p .902 g
F P
0 g
s
.68197 .38429 m .67773 .45393 L .6033 .43193 L p .63 g
F P
0 g
s
.6033 .43193 m .60564 .36129 L .68197 .38429 L p .63 g
F P
0 g
s
.78093 .9841 m .81437 1.05438 L .83186 1.0094 L p .256 g
F P
0 g
s
.83186 1.0094 m .79602 .94327 L .78093 .9841 L p .256 g
F P
0 g
s
.7394 .48743 m .71726 .56178 L .66149 .5322 L p .717 g
F P
0 g
s
.66149 .5322 m .67773 .45393 L .7394 .48743 L p .717 g
F P
0 g
s
.71375 .66651 m .65514 .72659 L .63111 .70581 L p .784 g
F P
0 g
s
.63111 .70581 m .68022 .63655 L .71375 .66651 L p .784 g
F P
0 g
s
.57389 .76407 m .63111 .70581 L .65514 .72659 L p .776 g
F P
0 g
s
.36316 .44834 m .35929 .37845 L .43765 .35823 L p .472 g
F P
0 g
s
.35929 .37845 m .36316 .44834 L .29843 .47966 L p .401 g
F P
0 g
s
.58669 .79229 m .65675 .79627 L .63246 .77568 L p .631 g
F P
0 g
s
.63246 .77568 m .57406 .78176 L .58669 .79229 L p .631 g
F P
0 g
s
.63111 .70581 m .57389 .76407 L .55704 .75581 L p .751 g
F P
0 g
s
.31948 .55491 m .35469 .63105 L .3184 .65988 L p .51 g
F P
0 g
s
.37538 .72198 m .3184 .65988 L .35469 .63105 L p .58 g
F P
0 g
s
.31948 .55491 m .29843 .47966 L .36316 .44834 L p .486 g
F P
0 g
s
.37381 .79171 m .44185 .78995 L .45544 .77984 L p .85 g
F P
0 g
s
.44185 .78995 m .37381 .79171 L .35748 .81469 L p .854 g
F P
0 g
s
.43535 .68674 m .4732 .75444 L .45561 .76214 L p .656 g
F P
0 g
s
.45561 .76214 m .40132 .702 L .43535 .68674 L p .656 g
F P
0 g
s
.35469 .63105 m .40132 .702 L .37538 .72198 L p .58 g
F P
0 g
s
.28365 .87997 m .22953 .93453 L .24075 .97587 L p .892 g
F P
0 g
s
.20663 1.04532 m .24075 .97587 L .22953 .93453 L p .894 g
F P
0 g
s
.74216 .88717 m .79602 .94327 L .792 .90107 L p .326 g
F P
0 g
s
.792 .90107 m .73834 .85249 L .74216 .88717 L p .326 g
F P
0 g
s
.55704 .75581 m .59858 .68946 L .63111 .70581 L p .751 g
F P
0 g
s
.59858 .68946 m .55704 .75581 L .53709 .75045 L p .728 g
F P
0 g
s
.47508 .67738 m .49363 .74974 L .4732 .75444 L p .671 g
F P
0 g
s
.4732 .75444 m .43535 .68674 L .47508 .67738 L p .671 g
F P
0 g
s
.57406 .78176 m .63246 .77568 L .59956 .75948 L p .645 g
F P
0 g
s
.59956 .75948 m .55717 .77352 L .57406 .78176 L p .645 g
F P
0 g
s
.78944 1.16878 m .78325 1.23819 L .8211 1.19878 L p .071 g
F P
0 g
s
.8211 1.19878 m .82826 1.12749 L .78944 1.16878 L p .071 g
F P
0 g
s
.40004 .77191 m .45544 .77984 L .47309 .77216 L p .828 g
F P
0 g
s
.45544 .77984 m .40004 .77191 L .37381 .79171 L p .85 g
F P
0 g
s
.67088 .81971 m .73834 .85249 L .71879 .81925 L p .468 g
F P
0 g
s
.71879 .81925 m .65675 .79627 L .67088 .81971 L p .468 g
F P
0 g
s
.72866 1.27089 m .70918 1.32756 L .75858 1.29843 L p .088 g
F P
0 g
s
.75858 1.29843 m .78325 1.23819 L .72866 1.27089 L p .088 g
F P
0 g
s
.53709 .75045 m .55982 .6788 L .59858 .68946 L p .728 g
F P
0 g
s
.55982 .6788 m .53709 .75045 L .51544 .74837 L p .707 g
F P
0 g
s
.60564 .36129 m .6033 .43193 L .52177 .42336 L p .58 g
F P
0 g
s
.52177 .42336 m .522 .35234 L .60564 .36129 L p .58 g
F P
0 g
s
.51761 .67466 m .51544 .74837 L .49363 .74974 L p .688 g
F P
0 g
s
.49363 .74974 m .47508 .67738 L .51761 .67466 L p .688 g
F P
0 g
s
.71726 .56178 m .68022 .63655 L .63439 .61288 L p .735 g
F P
0 g
s
.63439 .61288 m .66149 .5322 L .71726 .56178 L p .735 g
F P
0 g
s
.50681 1.40028 m .50552 1.36593 L .43286 1.36023 L p .306 g
F P
0 g
s
.50552 1.36593 m .50681 1.40028 L .56756 1.39721 L p .239 g
F P
0 g
s
.56756 1.39721 m .57861 1.36218 L .50552 1.36593 L p .239 g
F P
0 g
s
.51544 .74837 m .51761 .67466 L .55982 .6788 L p .707 g
F P
0 g
s
.35748 .81469 m .29075 .84539 L .28365 .87997 L p .902 g
F P
0 g
s
.22953 .93453 m .28365 .87997 L .29075 .84539 L p .935 g
F P
0 g
s
.43956 .429 m .43765 .35823 L .522 .35234 L p .529 g
F P
0 g
s
.43765 .35823 m .43956 .429 L .36316 .44834 L p .472 g
F P
0 g
s
.29075 .84539 m .35748 .81469 L .37381 .79171 L p .914 g
F P
0 g
s
.55717 .77352 m .59956 .75948 L .56035 .74891 L p .668 g
F P
0 g
s
.56035 .74891 m .53716 .76817 L .55717 .77352 L p .668 g
F P
0 g
s
.68022 .63655 m .63111 .70581 L .59858 .68946 L p .746 g
F P
0 g
s
.43446 .75679 m .47309 .77216 L .49357 .76746 L p .79 g
F P
0 g
s
.47309 .77216 m .43446 .75679 L .40004 .77191 L p .828 g
F P
0 g
s
.20663 1.04532 m .19245 1.11824 L .22729 1.16072 L p .801 g
F P
0 g
s
.23372 1.23049 m .22729 1.16072 L .19245 1.11824 L p .719 g
F P
0 g
s
.22729 1.16072 m .23372 1.23049 L .28513 1.26475 L p .684 g
F P
0 g
s
.57861 1.36218 m .56756 1.39721 L .62505 1.38655 L p .139 g
F P
0 g
s
.62505 1.38655 m .64789 1.34918 L .57861 1.36218 L p .139 g
F P
0 g
s
.30578 1.32208 m .28513 1.26475 L .23372 1.23049 L p .565 g
F P
0 g
s
.28513 1.26475 m .30578 1.32208 L .36491 1.34537 L p .546 g
F P
0 g
s
.36316 .44834 m .37798 .52726 L .31948 .55491 L p .486 g
F P
0 g
s
.35469 .63105 m .31948 .55491 L .37798 .52726 L p .55 g
F P
0 g
s
.40271 .60894 m .43535 .68674 L .40132 .702 L p .604 g
F P
0 g
s
.40132 .702 m .35469 .63105 L .40271 .60894 L p .604 g
F P
0 g
s
.522 .35234 m .52177 .42336 L .43956 .429 L p .529 g
F P
0 g
s
.81437 1.05438 m .82826 1.12749 L .84678 1.08152 L p .055 g
F P
0 g
s
.84678 1.08152 m .83186 1.0094 L .81437 1.05438 L p .055 g
F P
0 g
s
.44643 1.39561 m .43286 1.36023 L .36491 1.34537 L p .345 g
F P
0 g
s
.43286 1.36023 m .44643 1.39561 L .50681 1.40028 L p .306 g
F P
0 g
s
.59858 .68946 m .63439 .61288 L .68022 .63655 L p .746 g
F P
0 g
s
.53716 .76817 m .56035 .74891 L .51766 .74481 L p .701 g
F P
0 g
s
.51766 .74481 m .51545 .7661 L .53716 .76817 L p .701 g
F P
0 g
s
.47464 .74751 m .49357 .76746 L .51545 .7661 L p .744 g
F P
0 g
s
.49357 .76746 m .47464 .74751 L .43446 .75679 L p .79 g
F P
0 g
s
.67773 .45393 m .66149 .5322 L .59436 .5128 L p .667 g
F P
0 g
s
.59436 .5128 m .6033 .43193 L .67773 .45393 L p .667 g
F P
0 g
s
.51545 .7661 m .51766 .74481 L .47464 .74751 L p .744 g
F P
0 g
s
.37798 .52726 m .40271 .60894 L .35469 .63105 L p .55 g
F P
0 g
s
.37798 .52726 m .36316 .44834 L .43956 .429 L p .536 g
F P
0 g
s
.22953 .93453 m .19348 .99975 L .20663 1.04532 L p .894 g
F P
0 g
s
.19245 1.11824 m .20663 1.04532 L .19348 .99975 L p .833 g
F P
0 g
s
.63439 .61288 m .59858 .68946 L .55982 .6788 L p .712 g
F P
0 g
s
.65675 .79627 m .71879 .81925 L .68446 .78989 L p .418 g
F P
0 g
s
.68446 .78989 m .63246 .77568 L .65675 .79627 L p .418 g
F P
0 g
s
.64789 1.34918 m .62505 1.38655 L .67574 1.36885 L p .075 g
F P
0 g
s
.67574 1.36885 m .70918 1.32756 L .64789 1.34918 L p .075 g
F P
0 g
s
.45904 .59534 m .47508 .67738 L .43535 .68674 L p .628 g
F P
0 g
s
.43535 .68674 m .40271 .60894 L .45904 .59534 L p .628 g
F P
0 g
s
.79602 .94327 m .83186 1.0094 L .82786 .96276 L p .093 g
F P
0 g
s
.82786 .96276 m .792 .90107 L .79602 .94327 L p .093 g
F P
0 g
s
.31349 .81276 m .37381 .79171 L .40004 .77191 L p .864 g
F P
0 g
s
.37381 .79171 m .31349 .81276 L .29075 .84539 L p .914 g
F P
0 g
s
.39007 1.38343 m .36491 1.34537 L .30578 1.32208 L p .35 g
F P
0 g
s
.36491 1.34537 m .39007 1.38343 L .44643 1.39561 L p .345 g
F P
0 g
s
.66149 .5322 m .63439 .61288 L .57946 .5974 L p .693 g
F P
0 g
s
.57946 .5974 m .59436 .5128 L .66149 .5322 L p .693 g
F P
0 g
s
.73834 .85249 m .792 .90107 L .76841 .86042 L p .217 g
F P
0 g
s
.76841 .86042 m .71879 .81925 L .73834 .85249 L p .217 g
F P
0 g
s
.55982 .6788 m .57946 .5974 L .63439 .61288 L p .712 g
F P
0 g
s
.57946 .5974 m .55982 .6788 L .51761 .67466 L p .682 g
F P
0 g
s
.6033 .43193 m .59436 .5128 L .52092 .50525 L p .623 g
F P
0 g
s
.52092 .50525 m .52177 .42336 L .6033 .43193 L p .623 g
F P
0 g
s
.51949 .59138 m .51761 .67466 L .47508 .67738 L p .654 g
F P
0 g
s
.47508 .67738 m .45904 .59534 L .51949 .59138 L p .654 g
F P
0 g
s
.29075 .84539 m .23761 .8924 L .22953 .93453 L p .935 g
F P
0 g
s
.19348 .99975 m .22953 .93453 L .23761 .8924 L p .884 g
F P
0 g
s
.43956 .429 m .44686 .51022 L .37798 .52726 L p .536 g
F P
0 g
s
.40271 .60894 m .37798 .52726 L .44686 .51022 L p .585 g
F P
0 g
s
.44686 .51022 m .43956 .429 L .52177 .42336 L p .58 g
F P
0 g
s
.51761 .67466 m .51949 .59138 L .57946 .5974 L p .682 g
F P
0 g
s
.44686 .51022 m .45904 .59534 L .40271 .60894 L p .585 g
F P
0 g
s
.23761 .8924 m .29075 .84539 L .31349 .81276 L p .879 g
F P
0 g
s
.78325 1.23819 m .75858 1.29843 L .79263 1.26341 L p .005 g
F P
0 g
s
.79263 1.26341 m .8211 1.19878 L .78325 1.23819 L p .005 g
F P
0 g
s
.52177 .42336 m .52092 .50525 L .44686 .51022 L p .58 g
F P
0 g
s
.63246 .77568 m .68446 .78989 L .63749 .76667 L p .375 g
F P
0 g
s
.63749 .76667 m .59956 .75948 L .63246 .77568 L p .375 g
F P
0 g
s
.82826 1.12749 m .8211 1.19878 L .83909 1.15493 L p .017 g
F P
0 g
s
.83909 1.15493 m .84678 1.08152 L .82826 1.12749 L p .017 g
F P
0 g
s
.35066 .78449 m .40004 .77191 L .43446 .75679 L p .736 g
F P
0 g
s
.40004 .77191 m .35066 .78449 L .31349 .81276 L p .864 g
F P
0 g
s
.19245 1.11824 m .19976 1.18996 L .23372 1.23049 L p .719 g
F P
0 g
s
.2593 1.29159 m .23372 1.23049 L .19976 1.18996 L p .51 g
F P
0 g
s
.23372 1.23049 m .2593 1.29159 L .30578 1.32208 L p .565 g
F P
0 g
s
.59436 .5128 m .57946 .5974 L .51949 .59138 L p .655 g
F P
0 g
s
.51949 .59138 m .52092 .50525 L .59436 .5128 L p .655 g
F P
0 g
s
.70918 1.32756 m .67574 1.36885 L .71636 1.34509 L p F P
s
.71636 1.34509 m .75858 1.29843 L .70918 1.32756 L p F P
s
.52092 .50525 m .51949 .59138 L .45904 .59534 L p .62 g
F P
0 g
s
.45904 .59534 m .44686 .51022 L .52092 .50525 L p .62 g
F P
0 g
s
.19348 .99975 m .17846 1.07165 L .19245 1.11824 L p .833 g
F P
0 g
s
.19976 1.18996 m .19245 1.11824 L .17846 1.07165 L p .629 g
F P
0 g
s
.34121 1.36438 m .30578 1.32208 L .2593 1.29159 L p .31 g
F P
0 g
s
.30578 1.32208 m .34121 1.36438 L .39007 1.38343 L p .35 g
F P
0 g
s
.83186 1.0094 m .84678 1.08152 L .84282 1.03378 L p .028 g
F P
0 g
s
.84282 1.03378 m .82786 .96276 L .83186 1.0094 L p .028 g
F P
0 g
s
.59956 .75948 m .63749 .76667 L .58116 .75148 L p .363 g
F P
0 g
s
.58116 .75148 m .56035 .74891 L .59956 .75948 L p .363 g
F P
0 g
s
.39988 .76281 m .43446 .75679 L .47464 .74751 L p .572 g
F P
0 g
s
.43446 .75679 m .39988 .76281 L .35066 .78449 L p .736 g
F P
0 g
s
.50858 1.4137 m .50681 1.40028 L .44643 1.39561 L p .112 g
F P
0 g
s
.50681 1.40028 m .50858 1.4137 L .55236 1.4115 L p .083 g
F P
0 g
s
.55236 1.4115 m .56756 1.39721 L .50681 1.40028 L p .083 g
F P
0 g
s
.71879 .81925 m .76841 .86042 L .72624 .82434 L p .113 g
F P
0 g
s
.72624 .82434 m .68446 .78989 L .71879 .81925 L p .113 g
F P
0 g
s
.56756 1.39721 m .55236 1.4115 L .59369 1.40386 L p .036 g
F P
0 g
s
.59369 1.40386 m .62505 1.38655 L .56756 1.39721 L p .036 g
F P
0 g
s
.792 .90107 m .82786 .96276 L .8017 .91768 L p .041 g
F P
0 g
s
.8017 .91768 m .76841 .86042 L .792 .90107 L p .041 g
F P
0 g
s
.23761 .8924 m .20208 .95316 L .19348 .99975 L p .884 g
F P
0 g
s
.17846 1.07165 m .19348 .99975 L .20208 .95316 L p .645 g
F P
0 g
s
.46509 1.41035 m .44643 1.39561 L .39007 1.38343 L p .122 g
F P
0 g
s
.44643 1.39561 m .46509 1.41035 L .50858 1.4137 L p .112 g
F P
0 g
s
.56035 .74891 m .58116 .75148 L .51965 .74558 L p .025 g
F P
0 g
s
.51965 .74558 m .51766 .74481 L .56035 .74891 L p .025 g
F P
0 g
s
.47464 .74751 m .45765 .74946 L .39988 .76281 L p .572 g
F P
0 g
s
.45765 .74946 m .47464 .74751 L .51766 .74481 L p F P
s
.31349 .81276 m .2652 .85245 L .23761 .8924 L p .879 g
F P
0 g
s
.2652 .85245 m .31349 .81276 L .35066 .78449 L p F P
s
.51766 .74481 m .51965 .74558 L .45765 .74946 L p F P
s
.20208 .95316 m .23761 .8924 L .2652 .85245 L p F P
s
.62505 1.38655 m .59369 1.40386 L .62997 1.39123 L p F P
s
.62997 1.39123 m .67574 1.36885 L .62505 1.38655 L p F P
s
.75858 1.29843 m .71636 1.34509 L .74406 1.31663 L p F P
s
.74406 1.31663 m .79263 1.26341 L .75858 1.29843 L p F P
s
.8211 1.19878 m .79263 1.26341 L .80855 1.22454 L p .695 g
F P
0 g
s
.80855 1.22454 m .83909 1.15493 L .8211 1.19878 L p .695 g
F P
0 g
s
.42459 1.40163 m .39007 1.38343 L .34121 1.36438 L p .11 g
F P
0 g
s
.39007 1.38343 m .42459 1.40163 L .46509 1.41035 L p .122 g
F P
0 g
s
.19976 1.18996 m .22881 1.25558 L .2593 1.29159 L p .51 g
F P
0 g
s
.2593 1.29159 m .30306 1.33952 L .34121 1.36438 L p .31 g
F P
0 g
s
.30306 1.33952 m .2593 1.29159 L .22881 1.25558 L p .058 g
F P
0 g
s
.17846 1.07165 m .1862 1.14552 L .19976 1.18996 L p .629 g
F P
0 g
s
.22881 1.25558 m .19976 1.18996 L .1862 1.14552 L p .043 g
F P
0 g
s
.68446 .78989 m .72624 .82434 L .66808 .79572 L p .187 g
F P
0 g
s
.66808 .79572 m .63749 .76667 L .68446 .78989 L p .187 g
F P
0 g
s
.84678 1.08152 m .83909 1.15493 L .8351 1.10943 L p .716 g
F P
0 g
s
.8351 1.10943 m .84282 1.03378 L .84678 1.08152 L p .716 g
F P
0 g
s
.31095 .8177 m .35066 .78449 L .39988 .76281 L p F P
s
.35066 .78449 m .31095 .8177 L .2652 .85245 L p F P
s
.67574 1.36885 m .62997 1.39123 L .6588 1.37434 L p .696 g
F P
0 g
s
.6588 1.37434 m .71636 1.34509 L .67574 1.36885 L p .696 g
F P
0 g
s
.20208 .95316 m .18723 1.02395 L .17846 1.07165 L p .645 g
F P
0 g
s
.1862 1.14552 m .17846 1.07165 L .18723 1.02395 L p .033 g
F P
0 g
s
.34121 1.36438 m .38968 1.38805 L .42459 1.40163 L p .11 g
F P
0 g
s
.38968 1.38805 m .34121 1.36438 L .30306 1.33952 L p .263 g
F P
0 g
s
.82786 .96276 m .84282 1.03378 L .81562 .98758 L p .633 g
F P
0 g
s
.81562 .98758 m .8017 .91768 L .82786 .96276 L p .633 g
F P
0 g
s
.76841 .86042 m .8017 .91768 L .75438 .87755 L p .456 g
F P
0 g
s
.75438 .87755 m .72624 .82434 L .76841 .86042 L p .456 g
F P
0 g
s
.63749 .76667 m .66808 .79572 L .59799 .77693 L p .204 g
F P
0 g
s
.59799 .77693 m .58116 .75148 L .63749 .76667 L p .204 g
F P
0 g
s
.2652 .85245 m .23277 .90883 L .20208 .95316 L p F P
s
.18723 1.02395 m .20208 .95316 L .23277 .90883 L p .021 g
F P
0 g
s
.23277 .90883 m .2652 .85245 L .31095 .8177 L p .002 g
F P
0 g
s
.37197 .79094 m .39988 .76281 L .45765 .74946 L p .077 g
F P
0 g
s
.39988 .76281 m .37197 .79094 L .31095 .8177 L p F P
s
.79263 1.26341 m .74406 1.31663 L .75664 1.28518 L p .902 g
F P
0 g
s
.75664 1.28518 m .80855 1.22454 L .79263 1.26341 L p .902 g
F P
0 g
s
.51074 1.40404 m .50858 1.4137 L .46509 1.41035 L p .576 g
F P
0 g
s
.50858 1.4137 m .51074 1.40404 L .53383 1.40288 L p .627 g
F P
0 g
s
.53383 1.40288 m .55236 1.4115 L .50858 1.4137 L p .627 g
F P
0 g
s
.71636 1.34509 m .6588 1.37434 L .67818 1.35421 L p .872 g
F P
0 g
s
.67818 1.35421 m .74406 1.31663 L .71636 1.34509 L p .872 g
F P
0 g
s
.55236 1.4115 m .53383 1.40288 L .55557 1.39884 L p .7 g
F P
0 g
s
.55557 1.39884 m .59369 1.40386 L .55236 1.4115 L p .7 g
F P
0 g
s
.48781 1.40227 m .46509 1.41035 L .42459 1.40163 L p .553 g
F P
0 g
s
.46509 1.41035 m .48781 1.40227 L .51074 1.40404 L p .576 g
F P
0 g
s
.58116 .75148 m .59799 .77693 L .52126 .76962 L p .164 g
F P
0 g
s
.52126 .76962 m .51965 .74558 L .58116 .75148 L p .164 g
F P
0 g
s
.83909 1.15493 m .80855 1.22454 L .80452 1.18432 L p .89 g
F P
0 g
s
.80452 1.18432 m .8351 1.10943 L .83909 1.15493 L p .89 g
F P
0 g
s
.1862 1.14552 m .21693 1.21621 L .22881 1.25558 L p .043 g
F P
0 g
s
.27834 1.31028 m .22881 1.25558 L .21693 1.21621 L p .187 g
F P
0 g
s
.22881 1.25558 m .27834 1.31028 L .30306 1.33952 L p .058 g
F P
0 g
s
.4439 .77443 m .45765 .74946 L .51965 .74558 L p .127 g
F P
0 g
s
.45765 .74946 m .4439 .77443 L .37197 .79094 L p .077 g
F P
0 g
s
.36266 1.37039 m .30306 1.33952 L .27834 1.31028 L p .328 g
F P
0 g
s
.30306 1.33952 m .36266 1.37039 L .38968 1.38805 L p .263 g
F P
0 g
s
.51965 .74558 m .52126 .76962 L .4439 .77443 L p .127 g
F P
0 g
s
.59369 1.40386 m .55557 1.39884 L .57454 1.39219 L p .778 g
F P
0 g
s
.57454 1.39219 m .62997 1.39123 L .59369 1.40386 L p .778 g
F P
0 g
s
.46653 1.39767 m .42459 1.40163 L .38968 1.38805 L p .553 g
F P
0 g
s
.42459 1.40163 m .46653 1.39767 L .48781 1.40227 L p .553 g
F P
0 g
s
.18723 1.02395 m .19489 1.10006 L .1862 1.14552 L p .033 g
F P
0 g
s
.21693 1.21621 m .1862 1.14552 L .19489 1.10006 L p .105 g
F P
0 g
s
.72624 .82434 m .75438 .87755 L .68873 .84563 L p .483 g
F P
0 g
s
.68873 .84563 m .66808 .79572 L .72624 .82434 L p .483 g
F P
0 g
s
.84282 1.03378 m .8351 1.10943 L .80844 1.06543 L p .801 g
F P
0 g
s
.80844 1.06543 m .81562 .98758 L .84282 1.03378 L p .801 g
F P
0 g
s
.28419 .87015 m .31095 .8177 L .37197 .79094 L p .108 g
F P
0 g
s
.31095 .8177 m .28419 .87015 L .23277 .90883 L p .002 g
F P
0 g
s
.8017 .91768 m .81562 .98758 L .76617 .94641 L p .663 g
F P
0 g
s
.76617 .94641 m .75438 .87755 L .8017 .91768 L p .663 g
F P
0 g
s
.62997 1.39123 m .57454 1.39219 L .58947 1.38335 L p .84 g
F P
0 g
s
.58947 1.38335 m .6588 1.37434 L .62997 1.39123 L p .84 g
F P
0 g
s
.23277 .90883 m .2192 .9785 L .18723 1.02395 L p .021 g
F P
0 g
s
.19489 1.10006 m .18723 1.02395 L .2192 .9785 L p .096 g
F P
0 g
s
.44831 1.39052 m .38968 1.38805 L .36266 1.37039 L p .565 g
F P
0 g
s
.38968 1.38805 m .44831 1.39052 L .46653 1.39767 L p .553 g
F P
0 g
s
.2192 .9785 m .23277 .90883 L .28419 .87015 L p .105 g
F P
0 g
s
.74406 1.31663 m .67818 1.35421 L .68662 1.33211 L p .926 g
F P
0 g
s
.68662 1.33211 m .75664 1.28518 L .74406 1.31663 L p .926 g
F P
0 g
s
.80855 1.22454 m .75664 1.28518 L .75274 1.2528 L p .925 g
F P
0 g
s
.75274 1.2528 m .80452 1.18432 L .80855 1.22454 L p .925 g
F P
0 g
s
.21693 1.21621 m .2691 1.27847 L .27834 1.31028 L p .187 g
F P
0 g
s
.34545 1.34974 m .27834 1.31028 L .2691 1.27847 L p .425 g
F P
0 g
s
.27834 1.31028 m .34545 1.34974 L .36266 1.37039 L p .328 g
F P
0 g
s
.66808 .79572 m .68873 .84563 L .60937 .82464 L p .454 g
F P
0 g
s
.60937 .82464 m .59799 .77693 L .66808 .79572 L p .454 g
F P
0 g
s
.6588 1.37434 m .58947 1.38335 L .59932 1.37287 L p .871 g
F P
0 g
s
.59932 1.37287 m .67818 1.35421 L .6588 1.37434 L p .871 g
F P
0 g
s
.19489 1.10006 m .22521 1.17605 L .21693 1.21621 L p .105 g
F P
0 g
s
.2691 1.27847 m .21693 1.21621 L .22521 1.17605 L p .327 g
F P
0 g
s
.35312 .84029 m .37197 .79094 L .4439 .77443 L p .231 g
F P
0 g
s
.37197 .79094 m .35312 .84029 L .28419 .87015 L p .108 g
F P
0 g
s
.43435 1.38128 m .36266 1.37039 L .34545 1.34974 L p .581 g
F P
0 g
s
.36266 1.37039 m .43435 1.38128 L .44831 1.39052 L p .565 g
F P
0 g
s
.8351 1.10943 m .80452 1.18432 L .78002 1.14553 L p .856 g
F P
0 g
s
.78002 1.14553 m .80844 1.06543 L .8351 1.10943 L p .856 g
F P
0 g
s
.51316 1.3707 m .51074 1.40404 L .48781 1.40227 L closepath p .748 g
F P
0 g
s
.51316 1.3707 m .53383 1.40288 L .51074 1.40404 L closepath p .761 g
F P
0 g
s
.51316 1.3707 m .55557 1.39884 L .53383 1.40288 L closepath p .774 g
F P
0 g
s
.51316 1.3707 m .48781 1.40227 L .46653 1.39767 L closepath p .736 g
F P
0 g
s
.59799 .77693 m .60937 .82464 L .52235 .81646 L p .403 g
F P
0 g
s
.52235 .81646 m .52126 .76962 L .59799 .77693 L p .403 g
F P
0 g
s
.2192 .9785 m .2262 1.05679 L .19489 1.10006 L p .096 g
F P
0 g
s
.22521 1.17605 m .19489 1.10006 L .2262 1.05679 L p .292 g
F P
0 g
s
.75438 .87755 m .76617 .94641 L .6974 .91361 L p .621 g
F P
0 g
s
.6974 .91361 m .68873 .84563 L .75438 .87755 L p .621 g
F P
0 g
s
.4346 .82184 m .4439 .77443 L .52126 .76962 L p .332 g
F P
0 g
s
.4439 .77443 m .4346 .82184 L .35312 .84029 L p .231 g
F P
0 g
s
.81562 .98758 m .80844 1.06543 L .76008 1.02624 L p .748 g
F P
0 g
s
.76008 1.02624 m .76617 .94641 L .81562 .98758 L p .748 g
F P
0 g
s
.51316 1.3707 m .57454 1.39219 L .55557 1.39884 L closepath p .785 g
F P
0 g
s
.51316 1.3707 m .46653 1.39767 L .44831 1.39052 L closepath p .726 g
F P
0 g
s
.67818 1.35421 m .59932 1.37287 L .60339 1.36145 L p .872 g
F P
0 g
s
.60339 1.36145 m .68662 1.33211 L .67818 1.35421 L p .872 g
F P
0 g
s
.75664 1.28518 m .68662 1.33211 L .68328 1.30949 L p .902 g
F P
0 g
s
.68328 1.30949 m .75274 1.2528 L .75664 1.28518 L p .902 g
F P
0 g
s
.52126 .76962 m .52235 .81646 L .4346 .82184 L p .332 g
F P
0 g
s
.27297 .93881 m .28419 .87015 L .35312 .84029 L p .276 g
F P
0 g
s
.28419 .87015 m .27297 .93881 L .2192 .9785 L p .105 g
F P
0 g
s
.2691 1.27847 m .33941 1.3274 L .34545 1.34974 L p .425 g
F P
0 g
s
.42565 1.37055 m .34545 1.34974 L .33941 1.3274 L p .596 g
F P
0 g
s
.34545 1.34974 m .42565 1.37055 L .43435 1.38128 L p .581 g
F P
0 g
s
.51316 1.3707 m .58947 1.38335 L .57454 1.39219 L closepath p .792 g
F P
0 g
s
.2262 1.05679 m .2192 .9785 L .27297 .93881 L p .285 g
F P
0 g
s
.51316 1.3707 m .44831 1.39052 L .43435 1.38128 L closepath p .718 g
F P
0 g
s
.22521 1.17605 m .2765 1.24616 L .2691 1.27847 L p .327 g
F P
0 g
s
.33941 1.3274 m .2691 1.27847 L .2765 1.24616 L p .49 g
F P
0 g
s
.80452 1.18432 m .75274 1.2528 L .73208 1.22172 L p .865 g
F P
0 g
s
.73208 1.22172 m .78002 1.14553 L .80452 1.18432 L p .865 g
F P
0 g
s
.51316 1.3707 m .59932 1.37287 L .58947 1.38335 L closepath p .796 g
F P
0 g
s
.51316 1.3707 m .43435 1.38128 L .42565 1.37055 L closepath p .713 g
F P
0 g
s
.2262 1.05679 m .25389 1.13793 L .22521 1.17605 L p .292 g
F P
0 g
s
.2765 1.24616 m .22521 1.17605 L .25389 1.13793 L p .428 g
F P
0 g
s
.68662 1.33211 m .60339 1.36145 L .60132 1.34985 L p .855 g
F P
0 g
s
.60132 1.34985 m .68328 1.30949 L .68662 1.33211 L p .855 g
F P
0 g
s
.68873 .84563 m .6974 .91361 L .61415 .89203 L p .569 g
F P
0 g
s
.61415 .89203 m .60937 .82464 L .68873 .84563 L p .569 g
F P
0 g
s
.51316 1.3707 m .60339 1.36145 L .59932 1.37287 L closepath p .796 g
F P
0 g
s
.33941 1.3274 m .42285 1.35903 L .42565 1.37055 L p .596 g
F P
0 g
s
.51316 1.3707 m .42565 1.37055 L .42285 1.35903 L closepath p .71 g
F P
0 g
s
.2765 1.24616 m .34522 1.30487 L .33941 1.3274 L p .49 g
F P
0 g
s
.42285 1.35903 m .33941 1.3274 L .34522 1.30487 L p .611 g
F P
0 g
s
.80844 1.06543 m .78002 1.14553 L .73605 1.11108 L p .785 g
F P
0 g
s
.73605 1.11108 m .76008 1.02624 L .80844 1.06543 L p .785 g
F P
0 g
s
.3452 .90813 m .35312 .84029 L .4346 .82184 L p .38 g
F P
0 g
s
.35312 .84029 m .3452 .90813 L .27297 .93881 L p .276 g
F P
0 g
s
.75274 1.2528 m .68328 1.30949 L .66813 1.28791 L p .854 g
F P
0 g
s
.66813 1.28791 m .73208 1.22172 L .75274 1.2528 L p .854 g
F P
0 g
s
.76617 .94641 m .76008 1.02624 L .69292 .99504 L p .686 g
F P
0 g
s
.69292 .99504 m .6974 .91361 L .76617 .94641 L p .686 g
F P
0 g
s
.27297 .93881 m .27876 1.019 L .2262 1.05679 L p .285 g
F P
0 g
s
.25389 1.13793 m .2262 1.05679 L .27876 1.019 L p .403 g
F P
0 g
s
.51316 1.3707 m .60132 1.34985 L .60339 1.36145 L closepath p .792 g
F P
0 g
s
.34522 1.30487 m .4262 1.34749 L .42285 1.35903 L p .611 g
F P
0 g
s
.51316 1.3707 m .42285 1.35903 L .4262 1.34749 L closepath p .709 g
F P
0 g
s
.25389 1.13793 m .30056 1.21564 L .2765 1.24616 L p .428 g
F P
0 g
s
.34522 1.30487 m .2765 1.24616 L .30056 1.21564 L p .534 g
F P
0 g
s
.27876 1.019 m .27297 .93881 L .3452 .90813 L p .394 g
F P
0 g
s
.51316 1.3707 m .57945 1.32928 L .59317 1.33887 L closepath p .776 g
F P
0 g
s
.51316 1.3707 m .56107 1.32177 L .57945 1.32928 L closepath p .766 g
F P
0 g
s
.51316 1.3707 m .53929 1.3169 L .56107 1.32177 L closepath p .756 g
F P
0 g
s
.51316 1.3707 m .51565 1.31501 L .53929 1.3169 L closepath p .746 g
F P
0 g
s
.51316 1.3707 m .49183 1.31625 L .51565 1.31501 L closepath p .736 g
F P
0 g
s
.51316 1.3707 m .46953 1.32053 L .49183 1.31625 L closepath p .728 g
F P
0 g
s
.51316 1.3707 m .45033 1.32753 L .46953 1.32053 L closepath p .72 g
F P
0 g
s
.51316 1.3707 m .43556 1.33674 L .45033 1.32753 L closepath p .715 g
F P
0 g
s
.51316 1.3707 m .4262 1.34749 L .43556 1.33674 L closepath p .711 g
F P
0 g
s
.51316 1.3707 m .59317 1.33887 L .60132 1.34985 L closepath p .785 g
F P
0 g
s
.60937 .82464 m .61415 .89203 L .52281 .88362 L p .515 g
F P
0 g
s
.52281 .88362 m .52235 .81646 L .60937 .82464 L p .515 g
F P
0 g
s
.4307 .88916 m .4346 .82184 L .52235 .81646 L p .455 g
F P
0 g
s
.4346 .82184 m .4307 .88916 L .3452 .90813 L p .38 g
F P
0 g
s
.68328 1.30949 m .60132 1.34985 L .59317 1.33887 L p .828 g
F P
0 g
s
.59317 1.33887 m .66813 1.28791 L .68328 1.30949 L p .828 g
F P
0 g
s
.52235 .81646 m .52281 .88362 L .4307 .88916 L p .455 g
F P
0 g
s
.30056 1.21564 m .36275 1.28371 L .34522 1.30487 L p .534 g
F P
0 g
s
.4262 1.34749 m .34522 1.30487 L .36275 1.28371 L p .625 g
F P
0 g
s
.78002 1.14553 m .73208 1.22172 L .69563 1.19422 L p .801 g
F P
0 g
s
.69563 1.19422 m .73605 1.11108 L .78002 1.14553 L p .801 g
F P
0 g
s
.36275 1.28371 m .43556 1.33674 L .4262 1.34749 L p .625 g
F P
0 g
s
.27876 1.019 m .30162 1.10473 L .25389 1.13793 L p .403 g
F P
0 g
s
.30056 1.21564 m .25389 1.13793 L .30162 1.10473 L p .492 g
F P
0 g
s
.66813 1.28791 m .59317 1.33887 L .57945 1.32928 L p .799 g
F P
0 g
s
.39101 1.26547 m .45033 1.32753 L .43556 1.33674 L p .64 g
F P
0 g
s
.43556 1.33674 m .36275 1.28371 L .39101 1.26547 L p .64 g
F P
0 g
s
.6974 .91361 m .69292 .99504 L .61168 .97452 L p .63 g
F P
0 g
s
.61168 .97452 m .61415 .89203 L .6974 .91361 L p .63 g
F P
0 g
s
.76008 1.02624 m .73605 1.11108 L .67527 1.08371 L p .722 g
F P
0 g
s
.67527 1.08371 m .69292 .99504 L .76008 1.02624 L p .722 g
F P
0 g
s
.73208 1.22172 m .66813 1.28791 L .64198 1.26895 L p .805 g
F P
0 g
s
.64198 1.26895 m .69563 1.19422 L .73208 1.22172 L p .805 g
F P
0 g
s
.57945 1.32928 m .64198 1.26895 L .66813 1.28791 L p .799 g
F P
0 g
s
.34929 .98982 m .3452 .90813 L .4307 .88916 L p .468 g
F P
0 g
s
.3452 .90813 m .34929 .98982 L .27876 1.019 L p .394 g
F P
0 g
s
.64198 1.26895 m .57945 1.32928 L .56107 1.32177 L p .77 g
F P
0 g
s
.30162 1.10473 m .34004 1.18917 L .30056 1.21564 L p .492 g
F P
0 g
s
.36275 1.28371 m .30056 1.21564 L .34004 1.18917 L p .568 g
F P
0 g
s
.30162 1.10473 m .27876 1.019 L .34929 .98982 L p .475 g
F P
0 g
s
.42814 1.25153 m .46953 1.32053 L .45033 1.32753 L p .657 g
F P
0 g
s
.45033 1.32753 m .39101 1.26547 L .42814 1.25153 L p .657 g
F P
0 g
s
.34004 1.18917 m .39101 1.26547 L .36275 1.28371 L p .568 g
F P
0 g
s
.56107 1.32177 m .60649 1.25401 L .64198 1.26895 L p .77 g
F P
0 g
s
.60649 1.25401 m .56107 1.32177 L .53929 1.3169 L p .743 g
F P
0 g
s
.47154 1.24297 m .49183 1.31625 L .46953 1.32053 L p .675 g
F P
0 g
s
.46953 1.32053 m .42814 1.25153 L .47154 1.24297 L p .675 g
F P
0 g
s
.53929 1.3169 m .56415 1.24426 L .60649 1.25401 L p .743 g
F P
0 g
s
.56415 1.24426 m .53929 1.3169 L .51565 1.31501 L p .718 g
F P
0 g
s
.61415 .89203 m .61168 .97452 L .52258 .96652 L p .578 g
F P
0 g
s
.52258 .96652 m .52281 .88362 L .61415 .89203 L p .578 g
F P
0 g
s
.51803 1.24048 m .51565 1.31501 L .49183 1.31625 L p .695 g
F P
0 g
s
.49183 1.31625 m .47154 1.24297 L .51803 1.24048 L p .695 g
F P
0 g
s
.73605 1.11108 m .69563 1.19422 L .64566 1.17247 L p .746 g
F P
0 g
s
.64566 1.17247 m .67527 1.08371 L .73605 1.11108 L p .746 g
F P
0 g
s
.51565 1.31501 m .51803 1.24048 L .56415 1.24426 L p .718 g
F P
0 g
s
.43271 .97178 m .4307 .88916 L .52281 .88362 L p .526 g
F P
0 g
s
.4307 .88916 m .43271 .97178 L .34929 .98982 L p .468 g
F P
0 g
s
.69563 1.19422 m .64198 1.26895 L .60649 1.25401 L p .761 g
F P
0 g
s
.34929 .98982 m .36541 1.07914 L .30162 1.10473 L p .475 g
F P
0 g
s
.34004 1.18917 m .30162 1.10473 L .36541 1.07914 L p .54 g
F P
0 g
s
.39243 1.16884 m .42814 1.25153 L .39101 1.26547 L p .598 g
F P
0 g
s
.39101 1.26547 m .34004 1.18917 L .39243 1.16884 L p .598 g
F P
0 g
s
.52281 .88362 m .52258 .96652 L .43271 .97178 L p .526 g
F P
0 g
s
.60649 1.25401 m .64566 1.17247 L .69563 1.19422 L p .761 g
F P
0 g
s
.69292 .99504 m .67527 1.08371 L .60195 1.06574 L p .669 g
F P
0 g
s
.60195 1.06574 m .61168 .97452 L .69292 .99504 L p .669 g
F P
0 g
s
.36541 1.07914 m .39243 1.16884 L .34004 1.18917 L p .54 g
F P
0 g
s
.36541 1.07914 m .34929 .98982 L .43271 .97178 L p .53 g
F P
0 g
s
.64566 1.17247 m .60649 1.25401 L .56415 1.24426 L p .722 g
F P
0 g
s
.45398 1.15633 m .47154 1.24297 L .42814 1.25153 L p .627 g
F P
0 g
s
.42814 1.25153 m .39243 1.16884 L .45398 1.15633 L p .627 g
F P
0 g
s
.67527 1.08371 m .64566 1.17247 L .58565 1.15822 L p .698 g
F P
0 g
s
.58565 1.15822 m .60195 1.06574 L .67527 1.08371 L p .698 g
F P
0 g
s
.56415 1.24426 m .58565 1.15822 L .64566 1.17247 L p .722 g
F P
0 g
s
.58565 1.15822 m .56415 1.24426 L .51803 1.24048 L p .688 g
F P
0 g
s
.61168 .97452 m .60195 1.06574 L .52164 1.05874 L p .622 g
F P
0 g
s
.52164 1.05874 m .52258 .96652 L .61168 .97452 L p .622 g
F P
0 g
s
.52008 1.15268 m .51803 1.24048 L .47154 1.24297 L p .657 g
F P
0 g
s
.47154 1.24297 m .45398 1.15633 L .52008 1.15268 L p .657 g
F P
0 g
s
.43271 .97178 m .44067 1.06334 L .36541 1.07914 L p .53 g
F P
0 g
s
.39243 1.16884 m .36541 1.07914 L .44067 1.06334 L p .58 g
F P
0 g
s
.44067 1.06334 m .43271 .97178 L .52258 .96652 L p .577 g
F P
0 g
s
.51803 1.24048 m .52008 1.15268 L .58565 1.15822 L p .688 g
F P
0 g
s
.44067 1.06334 m .45398 1.15633 L .39243 1.16884 L p .58 g
F P
0 g
s
.52258 .96652 m .52164 1.05874 L .44067 1.06334 L p .577 g
F P
0 g
s
.60195 1.06574 m .58565 1.15822 L .52008 1.15268 L p .657 g
F P
0 g
s
.52008 1.15268 m .52164 1.05874 L .60195 1.06574 L p .657 g
F P
0 g
s
.52164 1.05874 m .52008 1.15268 L .45398 1.15633 L p .618 g
F P
0 g
s
.45398 1.15633 m .44067 1.06334 L .52164 1.05874 L p .618 g
F P
0 g
s
.25 Mabswid
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
.0843 .2212 m
.64785 0 L
s
.09701 .21621 m
.10379 .22387 L
s
gsave
.08347 .2009 -80.3756 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.226 .16558 m
.23257 .17341 L
s
gsave
.21284 .14994 -84.0109 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.35834 .11363 m
.36471 .12163 L
s
gsave
.3456 .09765 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4942 .06031 m
.50035 .06847 L
s
gsave
.4819 .04399 -78.0966 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.63369 .00556 m
.63961 .01389 L
s
gsave
.62186 -0.01111 -73.877 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.12255 .20619 m
.12659 .2108 L
s
.14821 .19612 m
.15223 .20075 L
s
.17401 .18599 m
.178 .19064 L
s
.19993 .17581 m
.2039 .18049 L
s
.25219 .1553 m
.25611 .16001 L
s
.27852 .14497 m
.28242 .1497 L
s
.30499 .13458 m
.30886 .13933 L
s
.3316 .12413 m
.33545 .12891 L
s
.38523 .10308 m
.38903 .1079 L
s
.41226 .09247 m
.41603 .09731 L
s
.43943 .08181 m
.44317 .08666 L
s
.46674 .07109 m
.47046 .07596 L
s
.5218 .04948 m
.52546 .05439 L
s
.54955 .03858 m
.55318 .04352 L
s
.57745 .02763 m
.58105 .03259 L
s
.60549 .01662 m
.60907 .0216 L
s
gsave
.2819 .01774 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.0169609 0.64881 0.340025 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
-0.00456621 1.00457 -0.0697153 1.00457 [
[.5 .82445 -19.625 0 ]
[.5 .82445 19.625 10 ]
[.04837 .26216 -13.9375 -9.78772 ]
[.04837 .26216 0 .21228 ]
[.21306 .20111 -20.0203 -10 ]
[.21306 .20111 .5422 0 ]
[.38678 .13673 -7.80548 -10 ]
[.38678 .13673 .63202 0 ]
[.5703 .06875 -13.2031 -10 ]
[.5703 .06875 1.85938 0 ]
[.76445 -0.00313 -6.9864 -10 ]
[.76445 -0.00313 1.4511 0 ]
[.34612 .08889 -7.40075 -10 ]
[.34612 .08889 .59925 0 ]
[.80748 .00247 0 -6.83927 ]
[.80748 .00247 20.5625 3.16073 ]
[.85024 .06868 0 -6.78058 ]
[.85024 .06868 25 3.21942 ]
[.89084 .13154 0 -6.72552 ]
[.89084 .13154 8.4375 3.27448 ]
[.92943 .1913 0 -6.67376 ]
[.92943 .1913 19.5 3.32624 ]
[.96616 .24819 0 -6.62501 ]
[.96616 .24819 15.0625 3.37499 ]
[.95019 .11106 0 -6.72552 ]
[.95019 .11106 8 3.27448 ]
[.02878 .28862 -20.5625 -3.16049 ]
[.02878 .28862 0 6.83951 ]
[.01947 .36565 -25 -3.22033 ]
[.01947 .36565 0 6.77967 ]
[.00976 .44587 -8.4375 -3.28285 ]
[.00976 .44587 0 6.71715 ]
[-0.00035 .52948 -19.5 -3.34821 ]
[-0.00035 .52948 0 6.65179 ]
[-0.0109 .6167 -15.0625 -3.41663 ]
[-0.0109 .6167 0 6.58337 ]
[-0.04962 .46627 -8 -3.28285 ]
[-0.04962 .46627 0 6.71715 ]
[ 0 0 0 0 ]
[ 1 .81195 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .82445 -80.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
67.437500 12.375000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.500000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
76.625000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
98.250000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.04148 .27674 m
.7913 0 L
s
.05744 .27085 m
.06197 .27519 L
s
gsave
.04837 .26216 -74.9375 -13.7877 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.2217 .21022 m
.22601 .21478 L
s
gsave
.21306 .20111 -81.0203 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.39492 .14629 m
.39898 .15108 L
s
gsave
.38678 .13673 -68.8055 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.57785 .07878 m
.58163 .08379 L
s
gsave
.5703 .06875 -74.2031 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.77133 .00737 m
.77478 .01262 L
s
gsave
.76445 -0.00313 -67.9864 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08961 .25897 m
.0923 .26161 L
s
.12211 .24698 m
.12478 .24963 L
s
.15496 .23486 m
.1576 .23754 L
s
.18815 .2226 m
.19077 .22531 L
s
.2556 .19771 m
.25816 .20047 L
s
.28987 .18506 m
.2924 .18785 L
s
.32451 .17228 m
.32701 .17509 L
s
.35952 .15936 m
.36199 .1622 L
s
.4307 .13309 m
.43311 .13598 L
s
.46688 .11973 m
.46925 .12266 L
s
.50346 .10623 m
.5058 .10919 L
s
.54045 .09258 m
.54275 .09556 L
s
.61567 .06482 m
.6179 .06786 L
s
.65393 .0507 m
.65612 .05377 L
s
.69262 .03642 m
.69477 .03951 L
s
.73175 .02198 m
.73386 .0251 L
s
gsave
.34612 .08889 -68.4008 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.7913 0 m
.95779 .2576 L
s
.7957 .0068 m
.7898 .00897 L
s
gsave
.80748 .00247 -61 -10.8393 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.83841 .07289 m
.8325 .075 L
s
gsave
.85024 .06868 -61 -10.7806 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.87897 .13564 m
.87303 .13769 L
s
gsave
.89084 .13154 -61 -10.7255 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.91752 .19529 m
.91157 .19728 L
s
gsave
.92943 .1913 -61 -10.6738 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.95422 .25207 m
.94825 .25401 L
s
gsave
.96616 .24819 -61 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.80442 .0203 m
.80088 .02159 L
s
.81305 .03366 m
.80951 .03494 L
s
.82159 .04687 m
.81805 .04815 L
s
.83005 .05995 m
.8265 .06122 L
s
.84669 .0857 m
.84314 .08696 L
s
.85488 .09838 m
.85133 .09963 L
s
.86299 .11092 m
.85944 .11217 L
s
.87102 .12334 m
.86746 .12458 L
s
.88683 .14781 m
.88327 .14903 L
s
.89462 .15986 m
.89105 .16107 L
s
.90233 .17178 m
.89876 .17299 L
s
.90996 .1836 m
.90639 .1848 L
s
.925 .20687 m
.92143 .20806 L
s
.93241 .21833 m
.92884 .21952 L
s
.93975 .22969 m
.93617 .23086 L
s
.94702 .24093 m
.94344 .2421 L
s
gsave
.95019 .11106 -61 -10.7255 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04148 .27674 m
0 .62185 L
s
.04057 .28429 m
.04646 .28212 L
s
gsave
.02878 .28862 -81.5625 -7.16049 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.0313 .36144 m
.03721 .35934 L
s
gsave
.01947 .36565 -86 -7.22033 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.02164 .44179 m
.02758 .43975 L
s
gsave
.00976 .44587 -69.4375 -7.28285 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.01157 .52554 m
.01754 .52357 L
s
gsave
-0.00035 .52948 -80.5 -7.34821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00107 .61291 m
.00706 .61101 L
s
gsave
-0.0109 .6167 -76.0625 -7.41663 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.03874 .29947 m
.04228 .29818 L
s
.0369 .31478 m
.04045 .31349 L
s
.03505 .33021 m
.03859 .32893 L
s
.03318 .34576 m
.03673 .34449 L
s
.0294 .37725 m
.03295 .37599 L
s
.02748 .39319 m
.03104 .39194 L
s
.02555 .40926 m
.02911 .40802 L
s
.0236 .42546 m
.02716 .42423 L
s
.01966 .45826 m
.02323 .45705 L
s
.01766 .47487 m
.02123 .47367 L
s
.01565 .49162 m
.01922 .49042 L
s
.01362 .50851 m
.0172 .50732 L
s
.00951 .54272 m
.01309 .54155 L
s
.00743 .56004 m
.01101 .55888 L
s
.00533 .57751 m
.00891 .57636 L
s
.00321 .59514 m
.0068 .59399 L
s
gsave
-0.04962 .46627 -69 -7.28285 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04148 .27674 m
0 .62185 L
s
0 .62185 m
.24023 .81195 L
s
.24023 .81195 m
.25974 .48381 L
s
.25974 .48381 m
.04148 .27674 L
s
.7913 0 m
.95779 .2576 L
s
.95779 .2576 m
1 .60412 L
s
1 .60412 m
.82157 .36284 L
s
.82157 .36284 m
.7913 0 L
s
.04148 .27674 m
0 .62185 L
s
0 .62185 m
.82157 .36284 L
s
.82157 .36284 m
.7913 0 L
s
.7913 0 m
.04148 .27674 L
s
.25974 .48381 m
.95779 .2576 L
s
.95779 .2576 m
1 .60412 L
s
1 .60412 m
.24023 .81195 L
s
.24023 .81195 m
.25974 .48381 L
s
0 0 m
1 0 L
1 .81195 L
0 .81195 L
closepath
clip
newpath
.5 Mabswid
.3013 .41653 m .27447 .4548 L .354 .47912 L p .658 g
F P
0 g
s
.354 .47912 m .37109 .44175 L .3013 .41653 L p .658 g
F P
0 g
s
.3405 .51894 m .354 .47912 L .27447 .4548 L p .651 g
F P
0 g
s
.37109 .44175 m .354 .47912 L .4332 .48519 L p .58 g
F P
0 g
s
.354 .47912 m .3405 .51894 L .4272 .51928 L p .57 g
F P
0 g
s
.4272 .51928 m .4332 .48519 L .354 .47912 L p .57 g
F P
0 g
s
.27447 .4548 m .25317 .49666 L .3405 .51894 L p .651 g
F P
0 g
s
.3314 .55887 m .3405 .51894 L .25317 .49666 L p .636 g
F P
0 g
s
.3405 .51894 m .3314 .55887 L .4232 .55295 L p .55 g
F P
0 g
s
.4232 .55295 m .4272 .51928 L .3405 .51894 L p .55 g
F P
0 g
s
.33211 .38409 m .3013 .41653 L .37109 .44175 L p .657 g
F P
0 g
s
.37109 .44175 m .39082 .40902 L .33211 .38409 L p .657 g
F P
0 g
s
.39082 .40902 m .37109 .44175 L .44086 .45269 L p .579 g
F P
0 g
s
.4332 .48519 m .44086 .45269 L .37109 .44175 L p .58 g
F P
0 g
s
.24808 .38027 m .21334 .41555 L .27447 .4548 L p .737 g
F P
0 g
s
.27447 .4548 m .3013 .41653 L .24808 .38027 L p .737 g
F P
0 g
s
.25317 .49666 m .27447 .4548 L .21334 .41555 L p .735 g
F P
0 g
s
.25317 .49666 m .23867 .53969 L .3314 .55887 L p .636 g
F P
0 g
s
.32729 .59658 m .3314 .55887 L .23867 .53969 L p .61 g
F P
0 g
s
.3314 .55887 m .32729 .59658 L .42146 .58416 L p .518 g
F P
0 g
s
.42146 .58416 m .4232 .55295 L .3314 .55887 L p .518 g
F P
0 g
s
.28776 .35199 m .24808 .38027 L .3013 .41653 L p .731 g
F P
0 g
s
.3013 .41653 m .33211 .38409 L .28776 .35199 L p .731 g
F P
0 g
s
.21334 .41555 m .18562 .45577 L .25317 .49666 L p .735 g
F P
0 g
s
.23867 .53969 m .25317 .49666 L .18562 .45577 L p .725 g
F P
0 g
s
.36514 .35949 m .33211 .38409 L .39082 .40902 L p .644 g
F P
0 g
s
.39082 .40902 m .41204 .38297 L .36514 .35949 L p .644 g
F P
0 g
s
.41204 .38297 m .39082 .40902 L .44972 .42374 L p .562 g
F P
0 g
s
.44086 .45269 m .44972 .42374 L .39082 .40902 L p .579 g
F P
0 g
s
.4332 .48519 m .4272 .51928 L .49286 .49956 L p .455 g
F P
0 g
s
.4272 .51928 m .4232 .55295 L .49259 .52404 L p .428 g
F P
0 g
s
.49259 .52404 m .49286 .49956 L .4272 .51928 L p .428 g
F P
0 g
s
.44086 .45269 m .4332 .48519 L .49327 .47457 L p .465 g
F P
0 g
s
.49286 .49956 m .49327 .47457 L .4332 .48519 L p .455 g
F P
0 g
s
.33005 .33244 m .28776 .35199 L .33211 .38409 L p .715 g
F P
0 g
s
.33211 .38409 m .36514 .35949 L .33005 .33244 L p .715 g
F P
0 g
s
.18562 .45577 m .16664 .49858 L .23867 .53969 L p .725 g
F P
0 g
s
.23195 .58134 m .23867 .53969 L .16664 .49858 L p .704 g
F P
0 g
s
.23867 .53969 m .23195 .58134 L .32729 .59658 L p .61 g
F P
0 g
s
.32851 .62974 m .32729 .59658 L .23195 .58134 L p .567 g
F P
0 g
s
.32729 .59658 m .32851 .62974 L .42214 .61099 L p .466 g
F P
0 g
s
.42214 .61099 m .42146 .58416 L .32729 .59658 L p .466 g
F P
0 g
s
.4232 .55295 m .42146 .58416 L .49248 .5465 L p .381 g
F P
0 g
s
.49248 .5465 m .49259 .52404 L .4232 .55295 L p .381 g
F P
0 g
s
.44972 .42374 m .44086 .45269 L .4938 .4506 L p .456 g
F P
0 g
s
.49327 .47457 m .4938 .4506 L .44086 .45269 L p .465 g
F P
0 g
s
.39843 .34439 m .36514 .35949 L .41204 .38297 L p .611 g
F P
0 g
s
.41204 .38297 m .43349 .36537 L .39843 .34439 L p .611 g
F P
0 g
s
.43349 .36537 m .41204 .38297 L .45927 .40017 L p .515 g
F P
0 g
s
.44972 .42374 m .45927 .40017 L .41204 .38297 L p .562 g
F P
0 g
s
.37246 .32292 m .33005 .33244 L .36514 .35949 L p .682 g
F P
0 g
s
.36514 .35949 m .39843 .34439 L .37246 .32292 L p .682 g
F P
0 g
s
.42146 .58416 m .42214 .61099 L .49254 .56548 L p .303 g
F P
0 g
s
.49254 .56548 m .49248 .5465 L .42146 .58416 L p .303 g
F P
0 g
s
.45927 .40017 m .44972 .42374 L .49442 .42915 L p .417 g
F P
0 g
s
.4938 .4506 m .49442 .42915 L .44972 .42374 L p .456 g
F P
0 g
s
.26927 .31946 m .22526 .3406 L .24808 .38027 L p .82 g
F P
0 g
s
.24808 .38027 m .28776 .35199 L .26927 .31946 L p .82 g
F P
0 g
s
.21334 .41555 m .24808 .38027 L .22526 .3406 L p .839 g
F P
0 g
s
.22526 .3406 m .18654 .36963 L .21334 .41555 L p .839 g
F P
0 g
s
.18562 .45577 m .21334 .41555 L .18654 .36963 L p .849 g
F P
0 g
s
.16664 .49858 m .15776 .54141 L .23195 .58134 L p .704 g
F P
0 g
s
.23361 .61904 m .23195 .58134 L .15776 .54141 L p .662 g
F P
0 g
s
.23195 .58134 m .23361 .61904 L .32851 .62974 L p .567 g
F P
0 g
s
.31591 .30747 m .26927 .31946 L .28776 .35199 L p .791 g
F P
0 g
s
.28776 .35199 m .33005 .33244 L .31591 .30747 L p .791 g
F P
0 g
s
.33516 .65614 m .32851 .62974 L .23361 .61904 L p .489 g
F P
0 g
s
.32851 .62974 m .33516 .65614 L .42524 .63164 L p .376 g
F P
0 g
s
.42524 .63164 m .42214 .61099 L .32851 .62974 L p .376 g
F P
0 g
s
.18654 .36963 m .15552 .40487 L .18562 .45577 L p .849 g
F P
0 g
s
.16664 .49858 m .18562 .45577 L .15552 .40487 L p .849 g
F P
0 g
s
.36236 .3054 m .31591 .30747 L .33005 .33244 L p .741 g
F P
0 g
s
.33005 .33244 m .37246 .32292 L .36236 .3054 L p .741 g
F P
0 g
s
.42214 .61099 m .42524 .63164 L .49276 .57973 L p .167 g
F P
0 g
s
.49276 .57973 m .49254 .56548 L .42214 .61099 L p .167 g
F P
0 g
s
.45927 .40017 m .46892 .3836 L .43349 .36537 L p .515 g
F P
0 g
s
.46892 .3836 m .45927 .40017 L .49508 .41161 L p .321 g
F P
0 g
s
.49442 .42915 m .49508 .41161 L .45927 .40017 L p .417 g
F P
0 g
s
.41236 .32427 m .37246 .32292 L .39843 .34439 L p .611 g
F P
0 g
s
.39843 .34439 m .4299 .34004 L .41236 .32427 L p .611 g
F P
0 g
s
.4299 .34004 m .39843 .34439 L .43349 .36537 L p .535 g
F P
0 g
s
.43349 .36537 m .45383 .35764 L .4299 .34004 L p .535 g
F P
0 g
s
.45383 .35764 m .43349 .36537 L .46892 .3836 L p .404 g
F P
0 g
s
.15552 .40487 m .13427 .44423 L .16664 .49858 L p .849 g
F P
0 g
s
.15776 .54141 m .16664 .49858 L .13427 .44423 L p .825 g
F P
0 g
s
.15776 .54141 m .15981 .58156 L .23361 .61904 L p .662 g
F P
0 g
s
.24382 .65028 m .23361 .61904 L .15981 .58156 L p .569 g
F P
0 g
s
.23361 .61904 m .24382 .65028 L .33516 .65614 L p .489 g
F P
0 g
s
.49327 .47457 m .49286 .49956 L .51988 .46677 L p .153 g
F P
0 g
s
.49286 .49956 m .49259 .52404 L .5211 .4797 L p .109 g
F P
0 g
s
.5211 .4797 m .51988 .46677 L .49286 .49956 L p .109 g
F P
0 g
s
.4938 .4506 m .49327 .47457 L .518 .45357 L p .153 g
F P
0 g
s
.51988 .46677 m .518 .45357 L .49327 .47457 L p .153 g
F P
0 g
s
.49259 .52404 m .49248 .5465 L .52156 .49152 L p .05 g
F P
0 g
s
.52156 .49152 m .5211 .4797 L .49259 .52404 L p .05 g
F P
0 g
s
.49442 .42915 m .4938 .4506 L .51556 .44094 L p .131 g
F P
0 g
s
.518 .45357 m .51556 .44094 L .4938 .4506 L p .153 g
F P
0 g
s
.40579 .3135 m .36236 .3054 L .37246 .32292 L p .644 g
F P
0 g
s
.37246 .32292 m .41236 .32427 L .40579 .3135 L p .644 g
F P
0 g
s
.347 .67383 m .33516 .65614 L .24382 .65028 L p .332 g
F P
0 g
s
.33516 .65614 m .347 .67383 L .43063 .64459 L p .206 g
F P
0 g
s
.43063 .64459 m .42524 .63164 L .33516 .65614 L p .206 g
F P
0 g
s
.42524 .63164 m .43063 .64459 L .49315 .58819 L p .043 g
F P
0 g
s
.49315 .58819 m .49276 .57973 L .42524 .63164 L p .043 g
F P
0 g
s
.46892 .3836 m .47807 .37529 L .45383 .35764 L p .404 g
F P
0 g
s
.47807 .37529 m .46892 .3836 L .49575 .39918 L p .163 g
F P
0 g
s
.49508 .41161 m .49575 .39918 L .46892 .3836 L p .321 g
F P
0 g
s
.49248 .5465 m .49254 .56548 L .52123 .50144 L p .032 g
F P
0 g
s
.52123 .50144 m .52156 .49152 L .49248 .5465 L p .032 g
F P
0 g
s
.49508 .41161 m .49442 .42915 L .51272 .42972 L p .073 g
F P
0 g
s
.51556 .44094 m .51272 .42972 L .49442 .42915 L p .131 g
F P
0 g
s
.32723 .29226 m .28278 .29603 L .26927 .31946 L p .815 g
F P
0 g
s
.26927 .31946 m .31591 .30747 L .32723 .29226 L p .815 g
F P
0 g
s
.22526 .3406 m .26927 .31946 L .28278 .29603 L p .883 g
F P
0 g
s
.13427 .44423 m .12438 .48531 L .15776 .54141 L p .825 g
F P
0 g
s
.15981 .58156 m .15776 .54141 L .12438 .48531 L p .738 g
F P
0 g
s
.28278 .29603 m .24062 .30866 L .22526 .3406 L p .883 g
F P
0 g
s
.18654 .36963 m .22526 .3406 L .24062 .30866 L p .918 g
F P
0 g
s
.44713 .33672 m .41236 .32427 L .4299 .34004 L p .446 g
F P
0 g
s
.4299 .34004 m .45745 .34711 L .44713 .33672 L p .446 g
F P
0 g
s
.45745 .34711 m .4299 .34004 L .45383 .35764 L p .355 g
F P
0 g
s
.37125 .29754 m .32723 .29226 L .31591 .30747 L p .7 g
F P
0 g
s
.36236 .3054 m .37125 .29754 L p .35118 .30114 L .7 g
F P
0 g
s
.41213 .31157 m .37125 .29754 L .36236 .3054 L p .492 g
F P
0 g
s
.40579 .3135 m .41213 .31157 L p .38732 .30849 L .492 g
F P
0 g
s
.44339 .33148 m .40579 .3135 L .41236 .32427 L p .425 g
F P
0 g
s
.44713 .33672 m .44339 .33148 L p .41908 .32583 L .425 g
F P
0 g
s
.47262 .35843 m .44339 .33148 L .44713 .33672 L p .1 g
F P
0 g
s
.47428 .35985 m .44713 .33672 L .45745 .34711 L p .16 g
F P
0 g
s
.45745 .34711 m .47904 .36559 L .47428 .35985 L p .16 g
F P
0 g
s
.47904 .36559 m .45745 .34711 L .47165 .36066 L p .088 g
F P
0 g
s
.44713 .33672 m .47428 .35985 L .47262 .35843 L p .1 g
F P
0 g
s
.47262 .35843 m .47304 .35928 L p .44995 .33796 L .327 g
F P
0 g
s
.44995 .33796 m .47304 .35928 L .46534 .35321 L .327 g
F
.45205 .33945 m .47262 .35843 L p .44995 .33796 L F P
0 g
s
.44731 .33357 m .41999 .31648 L p .41997 .31667 L .098 g
F P
0 g
s
.40579 .3135 m .41963 .32012 L p .41963 .32019 L .098 g
F P
0 g
s
.41963 .32012 m .44339 .33148 L p .41963 .32019 L .098 g
F P
0 g
s
.44339 .33148 m .45205 .33945 L p .44995 .33796 L .327 g
F P
0 g
s
.47304 .35928 m .4745 .36227 L p .46534 .35321 L .327 g
F P
0 g
s
.44731 .33357 m .44379 .33186 L p .4745 .36227 L .327 g
F P
0 g
s
.44339 .33148 m .44731 .33357 L p .41963 .32019 L .098 g
F P
0 g
s
.41963 .32019 m .4362 .3282 L .41997 .31667 L .098 g
F
.4362 .3282 m .44731 .33357 L .41997 .31667 L F
.41999 .31648 m .41213 .31157 L p .41963 .32019 L F P
0 g
s
.419 .32665 m .44713 .33672 L p .41908 .32583 L .425 g
F P
0 g
s
.45383 .35764 m .47165 .36066 L .45745 .34711 L p .355 g
F P
0 g
s
.47165 .36066 m .45383 .35764 L .47807 .37529 L p .189 g
F P
0 g
s
.47807 .37529 m .48606 .37611 L .47165 .36066 L p .189 g
F P
0 g
s
.47165 .36066 m .48563 .37467 L .47904 .36559 L p .088 g
F P
0 g
s
.47165 .36066 m .48606 .37611 L p .48299 .37211 L .043 g
F P
0 g
s
.48493 .37397 m .48234 .37137 L p .48568 .37482 L .043 g
F P
0 g
s
.48234 .37137 m .47165 .36066 L p .48274 .37186 L .043 g
F P
0 g
s
.48568 .37482 m .48234 .37137 L .48274 .37186 L .043 g
F
.47262 .35843 m .47428 .35985 L p .47675 .36463 L .5 g
F P
0 g
s
.48606 .37611 m .47807 .37529 L .49638 .39278 L p .046 g
F P
0 g
s
.49575 .39918 m .49638 .39278 L .47807 .37529 L p .163 g
F P
0 g
s
.49126 .39283 m .47453 .36196 L p .47675 .36463 L .5 g
F P
0 g
s
.47453 .36196 m .47262 .35843 L p .47675 .36463 L .5 g
F P
0 g
s
.4929 .39465 m .49168 .39245 L p .48073 .36917 L .409 g
F P
0 g
s
.47904 .36559 m .48079 .36925 L p .48073 .36917 L .409 g
F P
0 g
s
.48079 .36925 m .4929 .39465 L p .48073 .36917 L .409 g
F P
0 g
s
.48606 .37611 m .48568 .37482 L .48299 .37211 L .043 g
F
.48563 .37467 m .48493 .37397 L p .48568 .37482 L F P
0 g
s
.47428 .35985 m .47904 .36559 L p .48073 .36917 L .409 g
F P
0 g
s
.49168 .39245 m .47697 .36488 L p .48073 .36917 L .409 g
F P
0 g
s
.47697 .36488 m .47428 .35985 L p .48073 .36917 L .409 g
F P
0 g
s
.4745 .36227 m .48064 .37425 L p .47934 .37262 L .579 g
F P
0 g
s
.47945 .372 m .4745 .36227 L p .47934 .37262 L .579 g
F P
0 g
s
.49126 .39283 m .49168 .39245 L .49328 .4031 L p .683 g
F P
0 g
s
.49269 .4016 m .49126 .39283 L p .49328 .4031 L .683 g
F P
0 g
s
.49176 .39597 m .49126 .39283 L .49269 .4016 L p .498 g
F P
0 g
s
.49269 .4016 m .49263 .40131 L .49176 .39597 L .498 g
F
.49383 .40869 m .49176 .39597 L p .49395 .40934 L F P
0 g
s
.49269 .4016 m .49395 .40934 L p .49263 .40131 L .498 g
F P
0 g
s
.49395 .40934 m .49545 .41863 L p .49383 .40869 L .498 g
F P
0 g
s
.49545 .41863 m .49772 .43257 L .49536 .41806 L p .498 g
F P
0 g
s
.49536 .41806 m .49383 .40869 L p .49545 .41863 L .498 g
F P
0 g
s
.49328 .4031 m .49446 .4109 L p .49269 .4016 L .683 g
F P
0 g
s
.49395 .40934 m .49269 .4016 L p .49446 .4109 L .683 g
F P
0 g
s
.49304 .40188 m .49255 .40083 L .49383 .40869 L p .047 g
F P
0 g
s
.49446 .4109 m .49772 .43257 L .49395 .40934 L p .683 g
F P
0 g
s
.49383 .40869 m .49536 .41806 L p .49406 .40898 L .047 g
F P
0 g
s
.49383 .40869 m .49406 .40898 L .49304 .40188 L .047 g
F
.49536 .41806 m .49556 .41838 L .49304 .40188 L F
.49176 .39597 m .49304 .40188 L p .47934 .37262 L .579 g
F P
0 g
s
.4929 .39465 m .49772 .43257 L .49168 .39245 L closepath p .676 g
F P
0 g
s
.49477 .41033 m .49304 .40188 L .49556 .41838 L p .186 g
F P
0 g
s
.49556 .41838 m .49772 .43257 L .49598 .41942 L p .186 g
F P
0 g
s
.49598 .41942 m .49477 .41033 L p .49556 .41838 L .186 g
F P
0 g
s
.49575 .39918 m .49508 .41161 L .50968 .42064 L p .049 g
F P
0 g
s
.51272 .42972 m .50968 .42064 L .49508 .41161 L p .073 g
F P
0 g
s
.4946 .39911 m .49772 .43257 L .4929 .39465 L closepath p .628 g
F P
0 g
s
.49304 .40188 m .49477 .41033 L p .48563 .38745 L .612 g
F P
0 g
s
.49143 .39844 m .49254 .4008 L .49111 .39764 L .579 g
F
.49304 .40188 m .49253 .40074 L p .49254 .4008 L F P
0 g
s
.49253 .40074 m .49111 .39764 L p .49254 .4008 L .579 g
F P
0 g
s
.48064 .37425 m .49176 .39597 L p .47934 .37262 L .579 g
F P
0 g
s
.47934 .37262 m .49143 .39844 L .47945 .372 L .579 g
F
.49111 .39764 m .47945 .372 L p .49143 .39844 L F P
0 g
s
.48555 .38722 m .49304 .40188 L .48563 .38745 L .612 g
F
.48335 .38056 m .48839 .39165 L p .48555 .38722 L F P
0 g
s
.48839 .39165 m .49304 .40188 L p .48555 .38722 L .612 g
F P
0 g
s
.47945 .372 m .48335 .38056 L p .48563 .38745 L .612 g
F P
0 g
s
.48618 .38763 m .47945 .372 L p .49135 .40176 L .612 g
F P
0 g
s
.4745 .36227 m .47945 .372 L p .45833 .34674 L .487 g
F P
0 g
s
.44731 .33357 m .46475 .35197 L p .45833 .34674 L .487 g
F P
0 g
s
.46475 .35197 m .4745 .36227 L p .45833 .34674 L .487 g
F P
0 g
s
.45404 .34068 m .44731 .33357 L p .46813 .35846 L .487 g
F P
0 g
s
.47945 .372 m .45796 .34481 L .45404 .34068 L p .487 g
F P
0 g
s
.46813 .35846 m .47945 .372 L .45404 .34068 L .487 g
F
.45796 .34481 m .47945 .372 L .48101 .37563 L p .575 g
F P
0 g
s
.48101 .37563 m .48618 .38763 L p .47316 .36787 L .575 g
F P
0 g
s
.47252 .36658 m .48101 .37563 L .47316 .36787 L .575 g
F
.45796 .34481 m .48101 .37563 L .47181 .36582 L F
.47181 .36582 m .47252 .36658 L .47316 .36787 L F
.48618 .38763 m .47255 .36592 L .46373 .35316 L p F P
0 g
s
.47308 .36775 m .48618 .38763 L .46373 .35316 L .575 g
F
.49361 .40742 m .49441 .40942 L .49356 .40712 L .612 g
F
.49477 .41033 m .49445 .40947 L p .49441 .40942 L F P
0 g
s
.49445 .40947 m .49356 .40712 L p .49441 .40942 L .612 g
F P
0 g
s
.49135 .40176 m .49194 .40325 L .49171 .40262 L .612 g
F
.49135 .40176 m .49171 .40262 L .48618 .38763 L F
.49194 .40325 m .49361 .40742 L .49095 .40022 L F
.49356 .40712 m .49095 .40022 L p .49361 .40742 L F P
0 g
s
.49095 .40022 m .48618 .38763 L p .49194 .40325 L .612 g
F P
0 g
s
.49477 .41033 m .49772 .43257 L .49648 .42081 L closepath p .331 g
F P
0 g
s
.48618 .38763 m .49477 .41033 L .49648 .42081 L p .648 g
F P
0 g
s
.49288 .40836 m .48618 .38763 L p .49362 .41157 L .648 g
F P
0 g
s
.49059 .40127 m .49288 .40836 L p .48647 .39498 L .636 g
F P
0 g
s
.48094 .38343 m .49059 .40127 L .48647 .39498 L .636 g
F
.49288 .40836 m .4877 .39723 L p .48298 .38769 L F P
0 g
s
.4877 .39723 m .48714 .39602 L p .48298 .38769 L .636 g
F P
0 g
s
.48714 .39602 m .47966 .3846 L .46046 .35526 L p .616 g
F P
0 g
s
.46373 .35316 m .45796 .34481 L p .47308 .36775 L .575 g
F P
0 g
s
.44731 .33357 m .45796 .34481 L p .43367 .32719 L .311 g
F P
0 g
s
.43019 .32467 m .43197 .3256 L .43367 .32719 L .311 g
F
.43197 .3256 m .44731 .33357 L .43367 .32719 L F
.41213 .31157 m .44731 .33357 L p .43019 .32467 L F P
0 g
s
.45796 .34481 m .43 .32197 L .42289 .31783 L p .311 g
F P
0 g
s
.42289 .31783 m .41405 .31269 L p .43863 .33067 L .311 g
F P
0 g
s
.43863 .33067 m .45796 .34481 L .42289 .31783 L .311 g
F
.41831 .31605 m .45796 .34481 L .41405 .31269 L F
.43 .32197 m .45796 .34481 L .46461 .35443 L p .511 g
F P
0 g
s
.46461 .35443 m .47255 .36592 L p .45324 .34597 L .511 g
F P
0 g
s
.43 .32197 m .46461 .35443 L .45324 .34597 L .511 g
F
.45476 .34655 m .43933 .33123 L p .45357 .34609 L F P
0 g
s
.47255 .36592 m .45476 .34655 L p .45357 .34609 L .511 g
F P
0 g
s
.45098 .34364 m .47255 .36592 L .43933 .33123 L .511 g
F
.41213 .31157 m .40579 .3135 L p .41963 .32019 L .098 g
F P
0 g
s
.43933 .33123 m .43 .32197 L p .44938 .34199 L .511 g
F P
0 g
s
.44938 .34199 m .45098 .34364 L .4498 .34238 L .511 g
F
.44938 .34199 m .4498 .34238 L .43933 .33123 L F
.41405 .31269 m .41213 .31157 L p .41831 .31605 L .311 g
F P
0 g
s
.41213 .31157 m .43 .32197 L p .40565 .31184 L .154 g
F P
0 g
s
.37125 .29754 m .39743 .30653 L p .40222 .30962 L .154 g
F P
0 g
s
.37125 .29754 m .40222 .30962 L .39606 .30786 L .154 g
F
.39349 .3056 m .39646 .30693 L .39591 .30446 L F
.39743 .30653 m .41213 .31157 L p .40565 .31184 L F P
0 g
s
.39646 .30693 m .43 .32197 L .39723 .30514 L .154 g
F
.39646 .30693 m .39723 .30514 L .39591 .30446 L F
.43 .32197 m .39735 .30486 L .39591 .30446 L p F P
0 g
s
.39591 .30446 m .37125 .29754 L p .39215 .30623 L .154 g
F P
0 g
s
.35604 .29571 m .37125 .29754 L .39735 .30486 L p .098 g
F P
0 g
s
.32723 .29226 m .35604 .29571 L p .36908 .2986 L .098 g
F P
0 g
s
.32723 .29226 m .36908 .2986 L .35743 .29769 L .098 g
F
.39735 .30486 m .36205 .29456 L .34604 .2935 L p F P
0 g
s
.34604 .2935 m .34355 .29334 L p .35113 .29496 L .098 g
F P
0 g
s
.35743 .29769 m .36908 .2986 L .39735 .30486 L .098 g
F
.35113 .29496 m .39735 .30486 L .34604 .2935 L F
.34355 .29334 m .32723 .29226 L p .34575 .29559 L F P
0 g
s
.34575 .29559 m .39735 .30486 L .34355 .29334 L .098 g
F
.28278 .29603 m .32723 .29226 L .33514 .29278 L p .057 g
F P
0 g
s
.33514 .29278 m .36205 .29456 L p .31607 .29541 L .057 g
F P
0 g
s
.28278 .29603 m .33514 .29278 L .31607 .29541 L .057 g
F
.36205 .29456 m .32626 .29173 L .30652 .29368 L p F P
0 g
s
.30652 .29368 m .28278 .29603 L p .32613 .29522 L .057 g
F P
0 g
s
.32613 .29522 m .36205 .29456 L .30652 .29368 L .057 g
F
.24062 .30866 m .28278 .29603 L .28909 .2954 L p .037 g
F P
0 g
s
.28909 .2954 m .32626 .29173 L p .27392 .30208 L .037 g
F P
0 g
s
.24062 .30866 m .28909 .2954 L .27392 .30208 L .037 g
F
.32626 .29173 m .29226 .29664 L .27061 .30168 L p F P
0 g
s
.27061 .30168 m .24062 .30866 L p .28819 .29926 L .037 g
F P
0 g
s
.28819 .29926 m .32626 .29173 L .27061 .30168 L .037 g
F
.29226 .29664 m .26225 .30911 L .24202 .31611 L p .038 g
F P
0 g
s
.24062 .30866 m .20341 .32947 L .18654 .36963 L p .918 g
F P
0 g
s
.24202 .31611 m .20341 .32947 L p .2549 .31045 L .038 g
F P
0 g
s
.2549 .31045 m .29226 .29664 L .24202 .31611 L .038 g
F
.39606 .30786 m .40222 .30962 L .40565 .31184 L .154 g
F
.40492 .31154 m .43 .32197 L .39349 .3056 L F
.44358 .33544 m .45476 .34655 L p .43037 .32884 L .44 g
F P
0 g
s
.39735 .30486 m .44358 .33544 L .43037 .32884 L .44 g
F
.45476 .34655 m .43395 .33075 L .41019 .31394 L p F P
0 g
s
.42364 .32395 m .45476 .34655 L .41019 .31394 L .44 g
F
.38495 .30961 m .40579 .3135 L p .38732 .30849 L .492 g
F P
0 g
s
.43395 .33075 m .41141 .31954 L .37875 .30301 L p .38 g
F P
0 g
s
.37875 .30301 m .36205 .29456 L p .39353 .3104 L .38 g
F P
0 g
s
.39353 .3104 m .43395 .33075 L .37875 .30301 L .38 g
F
.39735 .30486 m .43 .32197 L .44358 .33544 L p .44 g
F P
0 g
s
.41019 .31394 m .39735 .30486 L p .41771 .31965 L .44 g
F P
0 g
s
.41771 .31965 m .42364 .32395 L .4188 .32035 L .44 g
F
.41771 .31965 m .4188 .32035 L .41019 .31394 L F
.46046 .35526 m .45476 .34655 L p .46681 .36496 L .616 g
F P
0 g
s
.46681 .36496 m .48714 .39602 L .46046 .35526 L .616 g
F
.48618 .38763 m .49059 .40127 L p .48094 .38343 L .636 g
F P
0 g
s
.47255 .36592 m .48618 .38763 L p .48094 .38343 L .636 g
F P
0 g
s
.48714 .39602 m .47255 .36592 L p .48298 .38769 L .636 g
F P
0 g
s
.4959 .41893 m .4963 .42024 L .49597 .41905 L .648 g
F
.49648 .42081 m .49635 .42034 L p .4963 .42024 L F P
0 g
s
.49635 .42034 m .49597 .41905 L p .4963 .42024 L .648 g
F P
0 g
s
.49362 .41157 m .49502 .4161 L .49454 .41438 L .648 g
F
.49362 .41157 m .49454 .41438 L .49288 .40836 L F
.49502 .4161 m .4959 .41893 L .49488 .41527 L F
.49597 .41905 m .49488 .41527 L p .4959 .41893 L F P
0 g
s
.49536 .41806 m .49772 .43257 L p .49556 .41838 L .047 g
F P
0 g
s
.49488 .41527 m .49288 .40836 L p .49502 .4161 L .648 g
F P
0 g
s
.39215 .30623 m .40492 .31154 L .39349 .3056 L .154 g
F
.41236 .32427 m .419 .32665 L p .41908 .32583 L .425 g
F P
0 g
s
.36236 .3054 m .38495 .30961 L p .38732 .30849 L .492 g
F P
0 g
s
.31591 .30747 m .35563 .3057 L p .35118 .30114 L .7 g
F P
0 g
s
.35563 .3057 m .36236 .3054 L p .35118 .30114 L .7 g
F P
0 g
s
.49254 .56548 m .49276 .57973 L .52012 .50879 L p .005 g
F P
0 g
s
.49315 .58819 m .49366 .59016 L .49738 .5774 L p .879 g
F P
0 g
s
.52012 .50879 m .52123 .50144 L .50932 .52802 L p .005 g
F P
0 g
s
.52012 .50879 m .50932 .52802 L .50789 .53392 L .005 g
F
.50567 .54625 m .50101 .55834 L p .50546 .54667 L .687 g
F P
0 g
s
.50101 .55834 m .49276 .57973 L p .50252 .55425 L .687 g
F P
0 g
s
.5183 .51305 m .50101 .55834 L .50252 .55425 L .687 g
F
.49276 .57973 m .49315 .58819 L .49939 .56953 L p F P
0 g
s
.5183 .51305 m .52012 .50879 L .50567 .54625 L p .687 g
F P
0 g
s
.5183 .51305 m .50567 .54625 L .50546 .54667 L .687 g
F
.49939 .56953 m .5183 .51305 L p .50528 .54705 L F P
0 g
s
.50528 .54705 m .49276 .57973 L .49939 .56953 L .687 g
F
.51589 .5139 m .5183 .51305 L .49828 .57285 L p .879 g
F P
0 g
s
.49828 .57285 m .49315 .58819 L p .49741 .57428 L .879 g
F P
0 g
s
.51589 .5139 m .49828 .57285 L .49741 .57428 L .879 g
F
.43063 .64459 m .43805 .6487 L .49366 .59016 L p 0 g
F P
s
.49388 .5858 m .49315 .58819 L .49425 .58538 L .879 g
F
.49388 .5858 m .49425 .58538 L .49738 .5774 L F
.50089 .5629 m .49388 .5858 L .49738 .5774 L F
.49366 .59016 m .49315 .58819 L .45636 .62137 L p 0 g
F P
s
.45636 .62137 m .43063 .64459 L p .45976 .61944 L F P
s
.49366 .59016 m .45636 .62137 L .45976 .61944 L F
.45836 .62732 m .44912 .63704 L p .46097 .62348 L .873 g
F P
0 g
s
.45328 .63154 m .44912 .63704 L .44688 .63875 L .873 g
F
.49429 .58534 m .45477 .63058 L .45328 .63154 L F
.45477 .63058 m .44912 .63704 L .45328 .63154 L F
.36344 .68129 m .38351 .67755 L .42575 .65483 L p .68 g
F P
0 g
s
.347 .67383 m .36344 .68129 L .43805 .6487 L p .053 g
F P
0 g
s
.43805 .6487 m .43063 .64459 L .347 .67383 L p .053 g
F P
0 g
s
.44912 .63704 m .43805 .6487 L p .44688 .63875 L .873 g
F P
0 g
s
.49429 .58534 m .49366 .59016 L .45836 .62732 L p .873 g
F P
0 g
s
.49429 .58534 m .45836 .62732 L .46097 .62348 L .873 g
F
.46838 .61452 m .43805 .6487 L .47056 .61328 L F
.43805 .6487 m .44704 .64337 L .47922 .60385 L p F P
0 g
s
.44704 .64337 m .43805 .6487 L .37639 .67563 L p .68 g
F P
0 g
s
.37639 .67563 m .36344 .68129 L p .37498 .67605 L .68 g
F P
0 g
s
.44704 .64337 m .37639 .67563 L .37498 .67605 L .68 g
F
.36344 .68129 m .347 .67383 L .26223 .67275 L p .115 g
F P
0 g
s
.26223 .67275 m .28793 .68457 L .36344 .68129 L p .115 g
F P
0 g
s
.4316 .65037 m .36344 .68129 L .42575 .65483 L .68 g
F
.38351 .67755 m .36344 .68129 L .28793 .68457 L p .578 g
F P
0 g
s
.28793 .68457 m .31937 .68444 L .3624 .67981 L p .578 g
F P
0 g
s
.3624 .67981 m .38351 .67755 L p .36558 .67886 L .578 g
F P
0 g
s
.36558 .67886 m .28793 .68457 L .3624 .67981 L .578 g
F
.38351 .67755 m .4059 .66244 L .42459 .65009 L p .894 g
F P
0 g
s
.42459 .65009 m .45703 .62864 L p .43173 .64547 L .894 g
F P
0 g
s
.43173 .64547 m .38351 .67755 L .42459 .65009 L .894 g
F
.44704 .64337 m .45703 .62864 L .47911 .59677 L p .932 g
F P
0 g
s
.47911 .59677 m .49497 .57387 L p .47447 .6036 L .932 g
F P
0 g
s
.47447 .6036 m .44704 .64337 L .47911 .59677 L .932 g
F
.42575 .65483 m .44704 .64337 L p .4316 .65037 L .68 g
F P
0 g
s
.48229 .59886 m .46838 .61452 L .47922 .60385 L .873 g
F
.46838 .61452 m .47056 .61328 L .47922 .60385 L F
.47922 .60385 m .49429 .58534 L p .48229 .59886 L F P
0 g
s
.49366 .59016 m .49429 .58534 L .50258 .55254 L p .922 g
F P
0 g
s
.50932 .52802 m .49254 .56548 L p .50789 .53392 L .005 g
F P
0 g
s
.50258 .55254 m .51303 .51123 L p .50321 .55126 L .922 g
F P
0 g
s
.50321 .55126 m .49366 .59016 L .50258 .55254 L .922 g
F
.49738 .5774 m .51013 .53365 L p .50089 .5629 L .879 g
F P
0 g
s
.51013 .53365 m .51589 .5139 L p .50844 .53824 L .879 g
F P
0 g
s
.50844 .53824 m .50089 .5629 L .51013 .53365 L .879 g
F
.15981 .58156 m .17301 .61634 L .24382 .65028 L p .569 g
F P
0 g
s
.26223 .67275 m .24382 .65028 L .17301 .61634 L p .348 g
F P
0 g
s
.24382 .65028 m .26223 .67275 L .347 .67383 L p .332 g
F P
0 g
s
.15552 .40487 m .18654 .36963 L .20341 .32947 L p .908 g
F P
0 g
s
.20341 .32947 m .17358 .35728 L .15552 .40487 L p .908 g
F P
0 g
s
.15552 .40487 m .17358 .35728 L p .13637 .43958 L .8 g
F P
0 g
s
.13557 .44181 m .15552 .40487 L p .13637 .43958 L .8 g
F P
0 g
s
.17358 .35728 m .15323 .39044 L .13427 .44423 L p .8 g
F P
0 g
s
.14397 .42688 m .12438 .48531 L p .14926 .40352 L F P
s
.15323 .39044 m .15152 .39717 L p .14926 .40352 L F P
s
.15152 .39717 m .14397 .42688 L p .14926 .40352 L F P
s
.13427 .44423 m .13557 .44181 L p .13637 .43958 L .8 g
F P
0 g
s
.58154 .38365 m .60292 .39434 L .66444 .35421 L p .645 g
F P
0 g
s
.66444 .35421 m .63041 .34422 L .58154 .38365 L p .645 g
F P
0 g
s
.69641 .37095 m .66444 .35421 L .60292 .39434 L p .621 g
F P
0 g
s
.63041 .34422 m .66444 .35421 L .71196 .30336 L p .637 g
F P
0 g
s
.66444 .35421 m .69641 .37095 L .75382 .31737 L p .602 g
F P
0 g
s
.75382 .31737 m .71196 .30336 L .66444 .35421 L p .602 g
F P
0 g
s
.60292 .39434 m .6229 .40959 L .69641 .37095 L p .621 g
F P
0 g
s
.72435 .39339 m .69641 .37095 L .6229 .40959 L p .595 g
F P
0 g
s
.69641 .37095 m .72435 .39339 L .79072 .33934 L p .562 g
F P
0 g
s
.79072 .33934 m .75382 .31737 L .69641 .37095 L p .562 g
F P
0 g
s
.12438 .48531 m .12682 .52546 L .15981 .58156 L p .738 g
F P
0 g
s
.17301 .61634 m .15981 .58156 L .12682 .52546 L p .487 g
F P
0 g
s
.49638 .39278 m .49575 .39918 L .50662 .41433 L p .42 g
F P
0 g
s
.50968 .42064 m .50662 .41433 L .50173 .40752 L p .049 g
F P
0 g
s
.50968 .42064 m .50173 .40752 L .50198 .40879 L .049 g
F
.50662 .41433 m .50375 .41124 L .50132 .40517 L p .42 g
F P
0 g
s
.50132 .40517 m .49638 .39278 L p .50257 .40581 L .42 g
F P
0 g
s
.50662 .41433 m .50132 .40517 L .50257 .40581 L .42 g
F
.49692 .393 m .49638 .39278 L .50121 .40488 L p .553 g
F P
0 g
s
.49735 .4 m .49692 .393 L .49955 .40425 L p .646 g
F P
0 g
s
.50173 .40752 m .49575 .39918 L p .50198 .40879 L .049 g
F P
0 g
s
.49955 .40425 m .50127 .41161 L p .49862 .40378 L .646 g
F P
0 g
s
.49862 .40378 m .49735 .4 L .49955 .40425 L .646 g
F
.50121 .40488 m .50375 .41124 L p .50103 .40396 L .553 g
F P
0 g
s
.50103 .40396 m .49692 .393 L .50121 .40488 L .553 g
F
.56012 .37823 m .58154 .38365 L .63041 .34422 L p .666 g
F P
0 g
s
.63041 .34422 m .59644 .34165 L .56012 .37823 L p .666 g
F P
0 g
s
.59644 .34165 m .63041 .34422 L .66777 .29808 L p .666 g
F P
0 g
s
.71196 .30336 m .66777 .29808 L .63041 .34422 L p .637 g
F P
0 g
s
.6229 .40959 m .64021 .42842 L .72435 .39339 L p .595 g
F P
0 g
s
.74647 .42019 m .72435 .39339 L .64021 .42842 L p .567 g
F P
0 g
s
.72435 .39339 m .74647 .42019 L .82027 .36801 L p .516 g
F P
0 g
s
.82027 .36801 m .79072 .33934 L .72435 .39339 L p .516 g
F P
0 g
s
.5423 .42026 m .55077 .42975 L .6229 .40959 L p .652 g
F P
0 g
s
.6229 .40959 m .60292 .39434 L .5423 .42026 L p .652 g
F P
0 g
s
.64021 .42842 m .6229 .40959 L .55077 .42975 L p .638 g
F P
0 g
s
.55077 .42975 m .55807 .44091 L .64021 .42842 L p .638 g
F P
0 g
s
.65377 .44963 m .64021 .42842 L .55807 .44091 L p .622 g
F P
0 g
s
.64021 .42842 m .65377 .44963 L .74647 .42019 L p .567 g
F P
0 g
s
.53322 .41308 m .5423 .42026 L .60292 .39434 L p .666 g
F P
0 g
s
.60292 .39434 m .58154 .38365 L .53322 .41308 L p .666 g
F P
0 g
s
.55807 .44091 m .56372 .45301 L .65377 .44963 L p .622 g
F P
0 g
s
.66269 .47189 m .65377 .44963 L .56372 .45301 L p .607 g
F P
0 g
s
.65377 .44963 m .66269 .47189 L .7613 .44968 L p .537 g
F P
0 g
s
.7613 .44968 m .74647 .42019 L .65377 .44963 L p .537 g
F P
0 g
s
.66777 .29808 m .62394 .30185 L .59644 .34165 L p .666 g
F P
0 g
s
.62394 .30185 m .66777 .29808 L .68404 .25172 L p .684 g
F P
0 g
s
.66777 .29808 m .71196 .30336 L .73333 .24934 L p .646 g
F P
0 g
s
.73333 .24934 m .68404 .25172 L .66777 .29808 L p .646 g
F P
0 g
s
.54005 .37853 m .56012 .37823 L .59644 .34165 L p .683 g
F P
0 g
s
.59644 .34165 m .56468 .34673 L .54005 .37853 L p .683 g
F P
0 g
s
.56468 .34673 m .59644 .34165 L .62394 .30185 L p .69 g
F P
0 g
s
.71196 .30336 m .75382 .31737 L .78043 .25726 L p .598 g
F P
0 g
s
.78043 .25726 m .73333 .24934 L .71196 .30336 L p .598 g
F P
0 g
s
.74647 .42019 m .7613 .44968 L .84041 .40167 L p .463 g
F P
0 g
s
.84041 .40167 m .82027 .36801 L .74647 .42019 L p .463 g
F P
0 g
s
.17301 .61634 m .19689 .64319 L .26223 .67275 L p .348 g
F P
0 g
s
.28793 .68457 m .26223 .67275 L .19689 .64319 L p .09 g
F P
0 g
s
.62394 .30185 m .58319 .31447 L .56468 .34673 L p .69 g
F P
0 g
s
.58319 .31447 m .62394 .30185 L .63555 .26412 L p .713 g
F P
0 g
s
.68404 .25172 m .63555 .26412 L .62394 .30185 L p .684 g
F P
0 g
s
.52411 .40869 m .53322 .41308 L .58154 .38365 L p .677 g
F P
0 g
s
.58154 .38365 m .56012 .37823 L .52411 .40869 L p .677 g
F P
0 g
s
.12438 .48531 m .13427 .44423 L .15323 .39044 L p F P
s
.56372 .45301 m .56736 .46527 L .66269 .47189 L p .607 g
F P
0 g
s
.66634 .49378 m .66269 .47189 L .56736 .46527 L p .592 g
F P
0 g
s
.66269 .47189 m .66634 .49378 L .76776 .48002 L p .505 g
F P
0 g
s
.76776 .48002 m .7613 .44968 L .66269 .47189 L p .505 g
F P
0 g
s
.75382 .31737 m .79072 .33934 L .82235 .27518 L p .537 g
F P
0 g
s
.82235 .27518 m .78043 .25726 L .75382 .31737 L p .537 g
F P
0 g
s
.48716 .37781 m .48606 .37611 L p .48733 .37815 L .046 g
F P
0 g
s
.49638 .39278 m .49692 .393 L .48716 .37781 L p .046 g
F P
0 g
s
.49638 .39278 m .48716 .37781 L .48733 .37815 L .046 g
F
.49232 .38631 m .48712 .37782 L p .49692 .393 L .51 g
F P
0 g
s
.48712 .37782 m .48606 .37611 L .48716 .37781 L p .51 g
F P
0 g
s
.48716 .37781 m .49692 .393 L p .48712 .37782 L .51 g
F P
0 g
s
.4946 .39911 m .4929 .39465 L p .48682 .37793 L .415 g
F P
0 g
s
.48606 .37611 m .48712 .37782 L p .48563 .37467 L .043 g
F P
0 g
s
.48712 .37782 m .49232 .38631 L .48563 .37467 L p .043 g
F P
0 g
s
.48573 .37494 m .48683 .37793 L .48682 .37793 L .415 g
F
.48683 .37793 m .4946 .39911 L .48682 .37793 L F
.48563 .37467 m .48573 .37494 L p .48573 .37494 L F P
0 g
s
.48573 .37494 m .4946 .39911 L p .48573 .37494 L .415 g
F P
0 g
s
.49772 .43257 m .518 .45357 L .51988 .46677 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .51988 .46677 L .5211 .4797 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .51556 .44094 L .518 .45357 L closepath p .751 g
F P
0 g
s
.53721 .35926 m .56468 .34673 L .58319 .31447 L p .704 g
F P
0 g
s
.58319 .31447 m .54808 .33526 L .53721 .35926 L p .704 g
F P
0 g
s
.54808 .33526 m .58319 .31447 L .59079 .28573 L p .732 g
F P
0 g
s
.63555 .26412 m .59079 .28573 L .58319 .31447 L p .713 g
F P
0 g
s
.52267 .3846 m .54005 .37853 L .56468 .34673 L p .692 g
F P
0 g
s
.56468 .34673 m .53721 .35926 L .52267 .3846 L p .692 g
F P
0 g
s
.51559 .40741 m .52411 .40869 L .56012 .37823 L p .685 g
F P
0 g
s
.56012 .37823 m .54005 .37853 L .51559 .40741 L p .685 g
F P
0 g
s
.49772 .43257 m .5211 .4797 L .52156 .49152 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .51272 .42972 L .51556 .44094 L closepath p .751 g
F P
0 g
s
.7613 .44968 m .76776 .48002 L .84958 .43822 L p .399 g
F P
0 g
s
.84958 .43822 m .84041 .40167 L .7613 .44968 L p .399 g
F P
0 g
s
.56736 .46527 m .56873 .47689 L .66634 .49378 L p .592 g
F P
0 g
s
.66442 .51386 m .66634 .49378 L .56873 .47689 L p .577 g
F P
0 g
s
.66634 .49378 m .66442 .51386 L .76525 .50922 L p .471 g
F P
0 g
s
.76525 .50922 m .76776 .48002 L .66634 .49378 L p .471 g
F P
0 g
s
.12682 .52546 m .14182 .56194 L .17301 .61634 L p .487 g
F P
0 g
s
.19689 .64319 m .17301 .61634 L .14182 .56194 L p .105 g
F P
0 g
s
.59079 .28573 m .63555 .26412 L .62789 .23526 L p .754 g
F P
0 g
s
.63555 .26412 m .68404 .25172 L .67431 .21402 L p .725 g
F P
0 g
s
.67431 .21402 m .62789 .23526 L .63555 .26412 L p .725 g
F P
0 g
s
.20341 .32947 m .24062 .30866 L .29226 .29664 L p .038 g
F P
0 g
s
.49772 .43257 m .52156 .49152 L .52123 .50144 L closepath p .751 g
F P
0 g
s
.59079 .28573 m .55244 .31528 L .54808 .33526 L p .732 g
F P
0 g
s
.55244 .31528 m .59079 .28573 L .58533 .26531 L p .774 g
F P
0 g
s
.62789 .23526 m .58533 .26531 L .59079 .28573 L p .754 g
F P
0 g
s
.49772 .43257 m .50968 .42064 L .51272 .42972 L closepath p .751 g
F P
0 g
s
.79072 .33934 m .82027 .36801 L .85625 .30224 L p .457 g
F P
0 g
s
.85625 .30224 m .82235 .27518 L .79072 .33934 L p .457 g
F P
0 g
s
.68404 .25172 m .73333 .24934 L .72188 .20301 L p .682 g
F P
0 g
s
.72188 .20301 m .67431 .21402 L .68404 .25172 L p .682 g
F P
0 g
s
.51592 .37858 m .53721 .35926 L .54808 .33526 L p .703 g
F P
0 g
s
.54808 .33526 m .52093 .36304 L .51592 .37858 L p .703 g
F P
0 g
s
.52093 .36304 m .54808 .33526 L .55244 .31528 L p .734 g
F P
0 g
s
.55807 .44091 m .55077 .42975 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.56372 .45301 m .55807 .44091 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.12682 .52546 m .12438 .48531 L .14397 .42688 L p .038 g
F P
0 g
s
.50823 .40937 m .51559 .40741 L .54005 .37853 L p .689 g
F P
0 g
s
.54005 .37853 m .52267 .3846 L .50823 .40937 L p .689 g
F P
0 g
s
.55077 .42975 m .5423 .42026 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .52123 .50144 L .52012 .50879 L closepath p .751 g
F P
0 g
s
.56736 .46527 m .56372 .45301 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.4929 .39465 m .47904 .36559 L .48563 .37467 L p .415 g
F P
0 g
s
.49772 .43257 m .50662 .41433 L .50968 .42064 L closepath p .751 g
F P
0 g
s
.55244 .31528 m .5229 .35106 L .52093 .36304 L p .734 g
F P
0 g
s
.5229 .35106 m .55244 .31528 L .54909 .30234 L p .78 g
F P
0 g
s
.58533 .26531 m .54909 .30234 L .55244 .31528 L p .774 g
F P
0 g
s
.51303 .51123 m .51589 .5139 L .49366 .59016 L p .922 g
F P
0 g
s
.47428 .35985 m .49168 .39245 L .49126 .39283 L p .5 g
F P
0 g
s
.50921 .39615 m .52267 .3846 L .53721 .35926 L p .688 g
F P
0 g
s
.53721 .35926 m .51592 .37858 L .50921 .39615 L p .688 g
F P
0 g
s
.5423 .42026 m .53322 .41308 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.56873 .47689 m .56774 .48708 L .66442 .51386 L p .577 g
F P
0 g
s
.65696 .53077 m .66442 .51386 L .56774 .48708 L p .564 g
F P
0 g
s
.66442 .51386 m .65696 .53077 L .75373 .53528 L p .435 g
F P
0 g
s
.75373 .53528 m .76525 .50922 L .66442 .51386 L p .435 g
F P
0 g
s
.56873 .47689 m .56736 .46527 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.4946 .39911 m .48563 .37467 L .49232 .38631 L p .536 g
F P
0 g
s
.17358 .35728 m .20341 .32947 L .26225 .30911 L p .06 g
F P
0 g
s
.49692 .393 m .49735 .4 L .49232 .38631 L p .51 g
F P
0 g
s
.50375 .41124 m .50127 .41161 L .49692 .393 L p .553 g
F P
0 g
s
.76776 .48002 m .76525 .50922 L .84684 .47527 L p .322 g
F P
0 g
s
.84684 .47527 m .84958 .43822 L .76776 .48002 L p .322 g
F P
0 g
s
.73333 .24934 m .78043 .25726 L .76769 .20314 L p .619 g
F P
0 g
s
.76769 .20314 m .72188 .20301 L .73333 .24934 L p .619 g
F P
0 g
s
.54909 .30234 m .58533 .26531 L .56805 .25786 L p .821 g
F P
0 g
s
.58533 .26531 m .62789 .23526 L .6025 .22221 L p .809 g
F P
0 g
s
.6025 .22221 m .56805 .25786 L .58533 .26531 L p .809 g
F P
0 g
s
.49176 .39597 m .4745 .36227 L .47262 .35843 L p .55 g
F P
0 g
s
.47262 .35843 m .49126 .39283 L .49176 .39597 L p .55 g
F P
0 g
s
.19689 .64319 m .23018 .65992 L .28793 .68457 L p .09 g
F P
0 g
s
.31937 .68444 m .28793 .68457 L .23018 .65992 L p .588 g
F P
0 g
s
.54909 .30234 m .52132 .34422 L .5229 .35106 L p .78 g
F P
0 g
s
.52132 .34422 m .54909 .30234 L .53886 .29919 L p .828 g
F P
0 g
s
.56805 .25786 m .53886 .29919 L .54909 .30234 L p .821 g
F P
0 g
s
.53322 .41308 m .52411 .40869 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.56774 .48708 m .56873 .47689 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .52012 .50879 L .5183 .51305 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .50375 .41124 L .50662 .41433 L closepath p .751 g
F P
0 g
s
.82027 .36801 m .84041 .40167 L .87965 .33691 L p .349 g
F P
0 g
s
.87965 .33691 m .85625 .30224 L .82027 .36801 L p .349 g
F P
0 g
s
.62789 .23526 m .67431 .21402 L .64027 .1944 L p .789 g
F P
0 g
s
.64027 .1944 m .6025 .22221 L .62789 .23526 L p .789 g
F P
0 g
s
.45703 .62864 m .44704 .64337 L .38351 .67755 L p .894 g
F P
0 g
s
.49497 .57387 m .49429 .58534 L .44704 .64337 L p .932 g
F P
0 g
s
.36205 .29456 m .39735 .30486 L .43395 .33075 L p .38 g
F P
0 g
s
.49232 .38631 m .49633 .40551 L .4946 .39911 L p .536 g
F P
0 g
s
.49633 .40551 m .49232 .38631 L .49735 .4 L p .66 g
F P
0 g
s
.49772 .43257 m .50127 .41161 L .50375 .41124 L closepath p .751 g
F P
0 g
s
.50254 .41445 m .50823 .40937 L .52267 .3846 L p .685 g
F P
0 g
s
.52267 .3846 m .50921 .39615 L .50254 .41445 L p .685 g
F P
0 g
s
.50367 .39616 m .52093 .36304 L .5229 .35106 L p .699 g
F P
0 g
s
.5229 .35106 m .50418 .39097 L .50367 .39616 L p .699 g
F P
0 g
s
.50418 .39097 m .5229 .35106 L .52132 .34422 L p .763 g
F P
0 g
s
.52411 .40869 m .51559 .40741 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.50367 .39616 m .50418 .39097 L .50275 .40016 L p .801 g
F P
0 g
s
.50239 .40355 m .5029 .40259 L p .50289 .40244 L .667 g
F P
0 g
s
.52093 .36304 m .50367 .39616 L .50239 .40355 L p .667 g
F P
0 g
s
.50921 .39615 m .51592 .37858 L p .50182 .40991 L .662 g
F P
0 g
s
.49935 .41548 m .49735 .4 L p .50057 .40956 L .646 g
F P
0 g
s
.50127 .41161 m .50014 .41388 L p .50057 .40956 L .646 g
F P
0 g
s
.50014 .41388 m .49935 .41548 L p .50057 .40956 L .646 g
F P
0 g
s
.50182 .40991 m .50102 .41168 L .50187 .41017 L .662 g
F
.50066 .41249 m .50098 .41187 L p .50102 .41168 L F P
0 g
s
.50098 .41187 m .50187 .41017 L p .50102 .41168 L .662 g
F P
0 g
s
.51592 .37858 m .50239 .40355 L .50066 .41249 L p .662 g
F P
0 g
s
.50239 .40355 m .50367 .39616 L .5016 .40882 L p F P
s
.49772 .43257 m .49935 .41548 L .50127 .41161 L closepath p .751 g
F P
0 g
s
.50041 .41863 m .49953 .42087 L .50051 .41878 L .671 g
F
.49946 .42124 m .50254 .41445 L p .49953 .42087 L F P
0 g
s
.50921 .39615 m .50066 .41249 L .49895 .42236 L p .671 g
F P
0 g
s
.50254 .41445 m .49895 .42236 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49921 .42331 m .50239 .40355 L p .49917 .4237 L F P
s
.50066 .41249 m .50239 .40355 L .49988 .41914 L p .031 g
F P
0 g
s
.49953 .42087 m .49913 .4219 L .49946 .42124 L .671 g
F
.49988 .41914 m .49772 .43257 L .49946 .42069 L p .031 g
F P
0 g
s
.49946 .42069 m .50066 .41249 L p .49988 .41914 L .031 g
F P
0 g
s
.49895 .42236 m .49909 .42206 L p .49913 .4219 L .671 g
F P
0 g
s
.49909 .42206 m .49946 .42124 L p .49913 .4219 L .671 g
F P
0 g
s
.50149 .40826 m .49998 .41799 L p .5016 .40882 L .801 g
F P
0 g
s
.50008 .41813 m .49917 .4237 L p .49997 .41868 L F P
s
.49917 .4237 m .49772 .43257 L .49921 .42331 L p F P
s
.49998 .41799 m .49772 .43257 L .50008 .41813 L p .801 g
F P
0 g
s
.5016 .40882 m .50008 .41813 L p .50133 .41016 L F P
s
.50008 .41813 m .49997 .41868 L .50133 .41016 L F
.50008 .41813 m .5016 .40882 L p .49998 .41799 L .801 g
F P
0 g
s
.50254 .41445 m .50921 .39615 L p .50041 .41863 L .671 g
F P
0 g
s
.50041 .41863 m .50051 .41878 L .50254 .41445 L .671 g
F
.5016 .40882 m .50133 .41016 L .50239 .40355 L 0 g
F
.50187 .41017 m .50921 .39615 L p .50182 .40991 L .662 g
F P
0 g
s
.50275 .40016 m .50149 .40826 L p .50282 .40135 L .801 g
F P
0 g
s
.5016 .40882 m .50282 .40135 L p .50149 .40826 L .801 g
F P
0 g
s
.50282 .40135 m .50367 .39616 L p .50275 .40016 L .801 g
F P
0 g
s
.51592 .37858 m .52093 .36304 L p .50289 .40244 L .667 g
F P
0 g
s
.5029 .40259 m .51592 .37858 L p .50289 .40244 L .667 g
F P
0 g
s
.56442 .49516 m .56774 .48708 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.56774 .48708 m .56442 .49516 L .65696 .53077 L p .564 g
F P
0 g
s
.32626 .29173 m .36205 .29456 L .41141 .31954 L p .344 g
F P
0 g
s
.4059 .66244 m .38351 .67755 L .31937 .68444 L p .82 g
F P
0 g
s
.53886 .29919 m .51658 .3438 L .52132 .34422 L p .828 g
F P
0 g
s
.51658 .3438 m .53886 .29919 L .52441 .30754 L p .854 g
F P
0 g
s
.53886 .29919 m .56805 .25786 L .54342 .26656 L p .855 g
F P
0 g
s
.54342 .26656 m .52441 .30754 L .53886 .29919 L p .855 g
F P
0 g
s
.64436 .5433 m .65696 .53077 L .56442 .49516 L p .552 g
F P
0 g
s
.65696 .53077 m .64436 .5433 L .73378 .55634 L p .397 g
F P
0 g
s
.73378 .55634 m .75373 .53528 L .65696 .53077 L p .397 g
F P
0 g
s
.52132 .34422 m .50376 .38851 L .50418 .39097 L p .763 g
F P
0 g
s
.50376 .38851 m .52132 .34422 L .51658 .3438 L p .835 g
F P
0 g
s
.49772 .43257 m .5183 .51305 L .51589 .5139 L closepath p .751 g
F P
0 g
s
.14182 .56194 m .16874 .59206 L .19689 .64319 L p .105 g
F P
0 g
s
.23018 .65992 m .19689 .64319 L .16874 .59206 L p .397 g
F P
0 g
s
.56805 .25786 m .6025 .22221 L .56591 .22996 L p .859 g
F P
0 g
s
.56591 .22996 m .54342 .26656 L .56805 .25786 L p .859 g
F P
0 g
s
.78043 .25726 m .82235 .27518 L .80878 .21478 L p .521 g
F P
0 g
s
.80878 .21478 m .76769 .20314 L .78043 .25726 L p .521 g
F P
0 g
s
.49429 .58534 m .49497 .57387 L .50993 .50517 L p .895 g
F P
0 g
s
.50993 .50517 m .51303 .51123 L .49429 .58534 L p .895 g
F P
0 g
s
.26225 .30911 m .23828 .32848 L .17358 .35728 L p .06 g
F P
0 g
s
.15323 .39044 m .17358 .35728 L .23828 .32848 L p .106 g
F P
0 g
s
.51658 .3438 m .50254 .38915 L .50376 .38851 L p .835 g
F P
0 g
s
.50254 .38915 m .51658 .3438 L .50994 .35051 L p .86 g
F P
0 g
s
.52441 .30754 m .50994 .35051 L .51658 .3438 L p .854 g
F P
0 g
s
.76525 .50922 m .75373 .53528 L .83207 .51023 L p .228 g
F P
0 g
s
.83207 .51023 m .84684 .47527 L .76525 .50922 L p .228 g
F P
0 g
s
.14397 .42688 m .14673 .46422 L .12682 .52546 L p .038 g
F P
0 g
s
.14182 .56194 m .12682 .52546 L .14673 .46422 L p .156 g
F P
0 g
s
.51559 .40741 m .50823 .40937 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.67431 .21402 m .72188 .20301 L .67918 .1763 L p .752 g
F P
0 g
s
.67918 .1763 m .64027 .1944 L .67431 .21402 L p .752 g
F P
0 g
s
.55898 .50056 m .56442 .49516 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.56442 .49516 m .55898 .50056 L .64436 .5433 L p .552 g
F P
0 g
s
.49735 .4 m .49762 .41347 L .49633 .40551 L p .66 g
F P
0 g
s
.49762 .41347 m .49735 .4 L .49935 .41548 L p .709 g
F P
0 g
s
.41141 .31954 m .38858 .31368 L .32626 .29173 L p .344 g
F P
0 g
s
.29226 .29664 m .32626 .29173 L .38858 .31368 L p .335 g
F P
0 g
s
.50994 .35051 m .52441 .30754 L .50963 .32748 L p .85 g
F P
0 g
s
.52441 .30754 m .54342 .26656 L .51812 .29198 L p .863 g
F P
0 g
s
.51812 .29198 m .50963 .32748 L .52441 .30754 L p .863 g
F P
0 g
s
.50994 .35051 m .50084 .39301 L .50254 .38915 L p .86 g
F P
0 g
s
.50084 .39301 m .50994 .35051 L .50317 .36417 L p .844 g
F P
0 g
s
.50963 .32748 m .50317 .36417 L .50994 .35051 L p .85 g
F P
0 g
s
.49772 .43257 m .51589 .5139 L .51303 .51123 L closepath p .751 g
F P
0 g
s
.84041 .40167 m .84958 .43822 L .89059 .37706 L p .195 g
F P
0 g
s
.89059 .37706 m .87965 .33691 L .84041 .40167 L p .195 g
F P
0 g
s
.6025 .22221 m .64027 .1944 L .59061 .19998 L p .86 g
F P
0 g
s
.59061 .19998 m .56591 .22996 L .6025 .22221 L p .86 g
F P
0 g
s
.49633 .40551 m .49772 .43257 L .4946 .39911 L closepath p .577 g
F P
0 g
s
.50823 .40937 m .50254 .41445 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.62739 .55051 m .64436 .5433 L .55898 .50056 L p .544 g
F P
0 g
s
.64436 .5433 m .62739 .55051 L .70662 .57077 L p .358 g
F P
0 g
s
.70662 .57077 m .73378 .55634 L .64436 .5433 L p .358 g
F P
0 g
s
.55175 .50289 m .55898 .50056 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.55898 .50056 m .55175 .50289 L .62739 .55051 L p .544 g
F P
0 g
s
.45476 .34655 m .47255 .36592 L .48714 .39602 L p .616 g
F P
0 g
s
.43395 .33075 m .45476 .34655 L .47966 .3846 L p .593 g
F P
0 g
s
.54342 .26656 m .56591 .22996 L .52815 .25978 L p .882 g
F P
0 g
s
.52815 .25978 m .51812 .29198 L .54342 .26656 L p .882 g
F P
0 g
s
.50066 .41249 m .49772 .43257 L .49895 .42236 L closepath p .17 g
F P
0 g
s
.50376 .38851 m .49772 .43257 L .50418 .39097 L closepath p .805 g
F P
0 g
s
.50254 .38915 m .49772 .43257 L .50376 .38851 L closepath p .743 g
F P
0 g
s
.50317 .36417 m .49911 .39991 L .50084 .39301 L p .844 g
F P
0 g
s
.49911 .39991 m .50317 .36417 L .49809 .38373 L p .813 g
F P
0 g
s
.50317 .36417 m .50963 .32748 L .49852 .35731 L p .824 g
F P
0 g
s
.49852 .35731 m .49809 .38373 L .50317 .36417 L p .824 g
F P
0 g
s
.50963 .32748 m .51812 .29198 L .4991 .33168 L p .843 g
F P
0 g
s
.4991 .33168 m .49852 .35731 L .50963 .32748 L p .843 g
F P
0 g
s
.49935 .41548 m .49813 .42262 L .49762 .41347 L p .709 g
F P
0 g
s
.49772 .43257 m .49813 .42262 L .49935 .41548 L closepath p .751 g
F P
0 g
s
.50084 .39301 m .49772 .43257 L .50254 .38915 L closepath p .683 g
F P
0 g
s
.47966 .3846 m .47091 .37485 L .43395 .33075 L p .593 g
F P
0 g
s
.41141 .31954 m .43395 .33075 L .47091 .37485 L p .573 g
F P
0 g
s
.46729 .60531 m .45703 .62864 L .4059 .66244 L p .888 g
F P
0 g
s
.45703 .62864 m .46729 .60531 L .49567 .55645 L p .891 g
F P
0 g
s
.49567 .55645 m .49497 .57387 L .45703 .62864 L p .891 g
F P
0 g
s
.49762 .41347 m .49772 .43257 L .49633 .40551 L closepath p .526 g
F P
0 g
s
.23018 .65992 m .27078 .66497 L .31937 .68444 L p .588 g
F P
0 g
s
.35446 .67192 m .31937 .68444 L .27078 .66497 L p .748 g
F P
0 g
s
.31937 .68444 m .35446 .67192 L .4059 .66244 L p .82 g
F P
0 g
s
.38858 .31368 m .36693 .31362 L .29226 .29664 L p .335 g
F P
0 g
s
.26225 .30911 m .29226 .29664 L .36693 .31362 L p .349 g
F P
0 g
s
.49911 .39991 m .49772 .43257 L .50084 .39301 L closepath p .632 g
F P
0 g
s
.49772 .43257 m .51303 .51123 L .50993 .50517 L closepath p .751 g
F P
0 g
s
.49497 .57387 m .49567 .55645 L .5068 .49612 L p .854 g
F P
0 g
s
.5068 .49612 m .50993 .50517 L .49497 .57387 L p .854 g
F P
0 g
s
.23828 .32848 m .22211 .3536 L .15323 .39044 L p .106 g
F P
0 g
s
.14397 .42688 m .15323 .39044 L .22211 .3536 L p .213 g
F P
0 g
s
.54323 .50194 m .55175 .50289 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.55175 .50289 m .54323 .50194 L .60715 .55179 L p .538 g
F P
0 g
s
.60715 .55179 m .62739 .55051 L .55175 .50289 L p .538 g
F P
0 g
s
.82235 .27518 m .85625 .30224 L .84227 .23757 L p .355 g
F P
0 g
s
.84227 .23757 m .80878 .21478 L .82235 .27518 L p .355 g
F P
0 g
s
.75373 .53528 m .73378 .55634 L .806 .54056 L p .122 g
F P
0 g
s
.806 .54056 m .83207 .51023 L .75373 .53528 L p .122 g
F P
0 g
s
.49809 .38373 m .49781 .40935 L .49911 .39991 L p .813 g
F P
0 g
s
.49781 .40935 m .49809 .38373 L .49608 .40732 L p .774 g
F P
0 g
s
.49809 .38373 m .49852 .35731 L .49414 .39374 L p .784 g
F P
0 g
s
.49414 .39374 m .49608 .40732 L .49809 .38373 L p .784 g
F P
0 g
s
.49852 .35731 m .4991 .33168 L .4916 .38068 L p .802 g
F P
0 g
s
.4916 .38068 m .49414 .39374 L .49852 .35731 L p .802 g
F P
0 g
s
.49813 .42262 m .49772 .43257 L .49762 .41347 L closepath p .47 g
F P
0 g
s
.49781 .40935 m .49772 .43257 L .49911 .39991 L closepath p .584 g
F P
0 g
s
.51812 .29198 m .52815 .25978 L .49977 .30845 L p .87 g
F P
0 g
s
.49977 .30845 m .4991 .33168 L .51812 .29198 L p .87 g
F P
0 g
s
.72188 .20301 m .76769 .20314 L .71684 .16936 L p .676 g
F P
0 g
s
.71684 .16936 m .67918 .1763 L .72188 .20301 L p .676 g
F P
0 g
s
.47091 .37485 m .46146 .3674 L .41141 .31954 L p .573 g
F P
0 g
s
.38858 .31368 m .41141 .31954 L .46146 .3674 L p .559 g
F P
0 g
s
.42901 .6367 m .4059 .66244 L .35446 .67192 L p .85 g
F P
0 g
s
.4059 .66244 m .42901 .6367 L .46729 .60531 L p .888 g
F P
0 g
s
.16874 .59206 m .206 .61346 L .23018 .65992 L p .397 g
F P
0 g
s
.27078 .66497 m .23018 .65992 L .206 .61346 L p .593 g
F P
0 g
s
.48714 .39602 m .49288 .40836 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.47966 .3846 m .48714 .39602 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.4973 .42055 m .49772 .43257 L .49781 .40935 L closepath p .536 g
F P
0 g
s
.49608 .40732 m .4973 .42055 L .49781 .40935 L p .774 g
F P
0 g
s
.62739 .55051 m .60715 .55179 L .67404 .57741 L p .322 g
F P
0 g
s
.67404 .57741 m .70662 .57077 L .62739 .55051 L p .322 g
F P
0 g
s
.47091 .37485 m .47966 .3846 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49288 .40836 m .49648 .42081 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.4991 .33168 m .49977 .30845 L .48863 .36899 L p .827 g
F P
0 g
s
.48863 .36899 m .4916 .38068 L .4991 .33168 L p .827 g
F P
0 g
s
.56591 .22996 m .59061 .19998 L .53915 .23291 L p .905 g
F P
0 g
s
.53915 .23291 m .52815 .25978 L .56591 .22996 L p .905 g
F P
0 g
s
.14673 .46422 m .16166 .49983 L .14182 .56194 L p .156 g
F P
0 g
s
.16874 .59206 m .14182 .56194 L .16166 .49983 L p .364 g
F P
0 g
s
.49772 .43257 m .50993 .50517 L .5068 .49612 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .4973 .42055 L .49608 .40732 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .49608 .40732 L .49414 .39374 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .49414 .39374 L .4916 .38068 L closepath p .751 g
F P
0 g
s
.53398 .49775 m .54323 .50194 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.54323 .50194 m .53398 .49775 L .58505 .54694 L p .539 g
F P
0 g
s
.58505 .54694 m .60715 .55179 L .54323 .50194 L p .539 g
F P
0 g
s
.84958 .43822 m .84684 .47527 L .88788 .42005 L p .04 g
F P
0 g
s
.88788 .42005 m .89059 .37706 L .84958 .43822 L p .04 g
F P
0 g
s
.46146 .3674 m .47091 .37485 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.64027 .1944 m .67918 .1763 L .6161 .17864 L p .842 g
F P
0 g
s
.6161 .17864 m .59061 .19998 L .64027 .1944 L p .842 g
F P
0 g
s
.49772 .43257 m .4916 .38068 L .48863 .36899 L closepath p .751 g
F P
0 g
s
.46146 .3674 m .45193 .36278 L .38858 .31368 L p .559 g
F P
0 g
s
.36693 .31362 m .38858 .31368 L .45193 .36278 L p .551 g
F P
0 g
s
.36693 .31362 m .34792 .31945 L .26225 .30911 L p .349 g
F P
0 g
s
.23828 .32848 m .26225 .30911 L .34792 .31945 L p .376 g
F P
0 g
s
.49633 .53423 m .49567 .55645 L .46729 .60531 L p .843 g
F P
0 g
s
.49567 .55645 m .49633 .53423 L .50386 .48468 L p .814 g
F P
0 g
s
.50386 .48468 m .5068 .49612 L .49567 .55645 L p .814 g
F P
0 g
s
.49772 .43257 m .5068 .49612 L .50386 .48468 L closepath p .751 g
F P
0 g
s
.47706 .57492 m .46729 .60531 L .42901 .6367 L p .85 g
F P
0 g
s
.46729 .60531 m .47706 .57492 L .49633 .53423 L p .843 g
F P
0 g
s
.45193 .36278 m .46146 .3674 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.52466 .49058 m .53398 .49775 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .50386 .48468 L .50132 .47166 L closepath p .751 g
F P
0 g
s
.49896 .44438 m .50259 .45697 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.50259 .45697 m .49896 .44438 L .50069 .45502 L p .652 g
F P
0 g
s
.49772 .43257 m .50069 .45502 L .49896 .44438 L closepath p .331 g
F P
0 g
s
.50431 .47318 m .50378 .46985 L .50323 .46642 L p .498 g
F P
0 g
s
.50088 .45521 m .50185 .45783 L .50154 .45589 L .652 g
F
.50102 .4559 m .50457 .46533 L p .50088 .45521 L F P
0 g
s
.50457 .46533 m .50945 .47826 L p .50458 .46519 L .652 g
F P
0 g
s
.50457 .46533 m .50458 .46519 L .50088 .45521 L .652 g
F
.50945 .47826 m .50069 .45502 L .50246 .4637 L p .47 g
F P
0 g
s
.51647 .49475 m .50945 .47826 L p .50504 .46908 L .47 g
F P
0 g
s
.50246 .4637 m .50298 .46487 L p .50297 .46477 L .47 g
F P
0 g
s
.51647 .49475 m .50246 .4637 L .50378 .46985 L p .356 g
F P
0 g
s
.50323 .46642 m .50378 .46985 L p .50193 .46024 L .047 g
F P
0 g
s
.50323 .46642 m .50306 .46539 L p .50413 .47204 L .498 g
F P
0 g
s
.50193 .46024 m .49772 .43257 L .50323 .46642 L p .047 g
F P
0 g
s
.50306 .46539 m .49772 .43257 L .50313 .46592 L p .498 g
F P
0 g
s
.50313 .46592 m .50413 .47204 L p .50306 .46539 L .498 g
F P
0 g
s
.50297 .46477 m .50443 .46806 L .50504 .46908 L .47 g
F
.50298 .46487 m .50443 .46806 L p .50297 .46477 L F P
0 g
s
.50443 .46806 m .51647 .49475 L p .50504 .46908 L .47 g
F P
0 g
s
.50389 .47363 m .50403 .47348 L p .50327 .46857 L .683 g
F P
0 g
s
.50322 .46867 m .50389 .47363 L .50327 .46857 L .683 g
F
.5026 .46504 m .50389 .47363 L p .50277 .46532 L F P
0 g
s
.50069 .45502 m .50102 .4559 L p .50088 .45521 L .652 g
F P
0 g
s
.50224 .46263 m .50069 .45502 L .49772 .43257 L p .186 g
F P
0 g
s
.49772 .43257 m .50246 .4637 L .50224 .46263 L p .186 g
F P
0 g
s
.50264 .47139 m .50389 .47363 L .50223 .46255 L p .676 g
F P
0 g
s
.50154 .46267 m .50264 .47139 L p .50223 .46255 L .676 g
F P
0 g
s
.49772 .43257 m .5009 .46675 L .50264 .47139 L closepath p .628 g
F P
0 g
s
.52393 .51001 m .50431 .47318 L .50389 .47363 L p .435 g
F P
0 g
s
.50389 .47363 m .50264 .47139 L p .50992 .48527 L .488 g
F P
0 g
s
.52232 .50893 m .51742 .49953 L p .51741 .49956 L .488 g
F P
0 g
s
.50378 .46985 m .52178 .50542 L .51647 .49475 L p .356 g
F P
0 g
s
.52178 .50542 m .50378 .46985 L .50431 .47318 L p .37 g
F P
0 g
s
.54159 .52043 m .52341 .50061 L .53889 .52344 L p .361 g
F P
0 g
s
.51647 .49475 m .53889 .52344 L .52341 .50061 L p .431 g
F P
0 g
s
.53889 .52344 m .56816 .54763 L .54159 .52043 L p .361 g
F P
0 g
s
.50431 .47318 m .52393 .51001 L .52178 .50542 L p .37 g
F P
0 g
s
.51736 .503 m .52232 .50893 L p .51741 .49956 L .488 g
F P
0 g
s
.50992 .48527 m .51463 .49714 L .51741 .49956 L .488 g
F
.50884 .48471 m .51463 .49714 L p .50992 .48527 L F P
0 g
s
.51463 .49714 m .51736 .503 L p .51741 .49956 L .488 g
F P
0 g
s
.50264 .47139 m .50884 .48471 L p .50992 .48527 L .488 g
F P
0 g
s
.50968 .48472 m .50389 .47363 L p .50992 .48527 L .488 g
F P
0 g
s
.52232 .50893 m .52393 .51001 L p .51014 .48497 L .435 g
F P
0 g
s
.50389 .47363 m .50951 .48438 L p .51014 .48497 L .435 g
F P
0 g
s
.50951 .48438 m .52232 .50893 L p .51014 .48497 L .435 g
F P
0 g
s
.50264 .47139 m .5009 .46675 L p .51477 .49731 L .525 g
F P
0 g
s
.51463 .49714 m .50264 .47139 L p .51477 .49731 L .525 g
F P
0 g
s
.50992 .48527 m .51741 .49956 L .50968 .48472 L .488 g
F
.51742 .49953 m .50968 .48472 L p .51741 .49956 L F P
0 g
s
.51736 .503 m .51463 .49714 L p .51477 .49731 L .525 g
F P
0 g
s
.51039 .49327 m .51736 .503 L p .50956 .48582 L .525 g
F P
0 g
s
.50883 .48523 m .51039 .49327 L .50956 .48582 L .525 g
F
.50628 .48133 m .51039 .49327 L .50849 .48347 L F
.53889 .52344 m .51647 .49475 L .52178 .50542 L p .207 g
F P
0 g
s
.55071 .53666 m .53889 .52344 L p .53576 .52015 L .207 g
F P
0 g
s
.52178 .50542 m .53717 .52203 L p .53576 .52015 L .207 g
F P
0 g
s
.53717 .52203 m .55071 .53666 L p .53576 .52015 L .207 g
F P
0 g
s
.55071 .53666 m .52178 .50542 L .52393 .51001 L p .111 g
F P
0 g
s
.56816 .54763 m .53889 .52344 L .55071 .53666 L p .122 g
F P
0 g
s
.58869 .56118 m .56816 .54763 L p .55838 .54148 L .122 g
F P
0 g
s
.55071 .53666 m .55708 .54077 L p .55838 .54148 L .122 g
F P
0 g
s
.55708 .54077 m .58869 .56118 L p .55838 .54148 L .122 g
F P
0 g
s
.58869 .56118 m .55071 .53666 L .55565 .54037 L p .328 g
F P
0 g
s
.52393 .51001 m .55565 .54037 L .55071 .53666 L p .111 g
F P
0 g
s
.53945 .52509 m .55469 .53947 L .53886 .5243 L .128 g
F
.55565 .54037 m .55472 .53949 L p .55469 .53947 L F P
0 g
s
.55472 .53949 m .53886 .5243 L p .55469 .53947 L .128 g
F P
0 g
s
.52393 .51001 m .52232 .50893 L p .53945 .52509 L .128 g
F P
0 g
s
.53886 .5243 m .52393 .51001 L p .53945 .52509 L .128 g
F P
0 g
s
.53398 .49775 m .52466 .49058 L .56265 .53625 L p .546 g
F P
0 g
s
.56265 .53625 m .58505 .54694 L .53398 .49775 L p .546 g
F P
0 g
s
.52466 .49058 m .51592 .48092 L .54159 .52043 L p .561 g
F P
0 g
s
.54159 .52043 m .56265 .53625 L .52466 .49058 L p .561 g
F P
0 g
s
.52341 .50061 m .54159 .52043 L .51592 .48092 L p .584 g
F P
0 g
s
.54643 .51574 m .57322 .53559 L p .53821 .51677 L .323 g
F P
0 g
s
.51736 .503 m .51039 .49327 L p .53462 .51819 L .2 g
F P
0 g
s
.53462 .51819 m .53913 .52282 L .53422 .51835 L .2 g
F
.53462 .51819 m .53422 .51835 L .51736 .503 L F
.54129 .52505 m .54021 .52406 L p .53913 .52282 L F P
0 g
s
.54021 .52406 m .51736 .503 L p .53913 .52282 L .2 g
F P
0 g
s
.52583 .51011 m .54129 .52505 L p .51728 .50035 L .2 g
F P
0 g
s
.52583 .51011 m .54311 .51483 L p .53821 .51677 L .323 g
F P
0 g
s
.54311 .51483 m .54643 .51574 L p .53821 .51677 L .323 g
F P
0 g
s
.51153 .49444 m .51722 .50072 L .51728 .50035 L .2 g
F
.51039 .49327 m .51121 .49416 L p .51153 .49444 L F P
0 g
s
.51121 .49416 m .51722 .50072 L p .51153 .49444 L .2 g
F P
0 g
s
.51722 .50072 m .52583 .51011 L p .51728 .50035 L .2 g
F P
0 g
s
.50242 .4701 m .50628 .48133 L .50849 .48347 L .525 g
F
.5009 .46675 m .50222 .47045 L p .50242 .4701 L F P
0 g
s
.50222 .47045 m .51039 .49327 L p .50242 .4701 L .525 g
F P
0 g
s
.49772 .43257 m .49937 .45799 L .49814 .44464 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .50132 .47166 L .49937 .45799 L closepath p .751 g
F P
0 g
s
.49814 .44464 m .49937 .45799 L .49734 .48205 L p .689 g
F P
0 g
s
.49937 .45799 m .50132 .47166 L .4969 .5088 L p .739 g
F P
0 g
s
.4969 .5088 m .49734 .48205 L .49876 .46518 L p .739 g
F P
0 g
s
.49876 .46518 m .49937 .45799 L p .49891 .46741 L .739 g
F P
0 g
s
.49891 .46741 m .4969 .5088 L .49876 .46518 L .739 g
F
.49913 .46011 m .5009 .46675 L .49978 .45471 L p .577 g
F P
0 g
s
.49879 .45357 m .49913 .46011 L p .49978 .45471 L .577 g
F P
0 g
s
.49772 .43257 m .49814 .44464 L .49762 .45599 L closepath p .536 g
F P
0 g
s
.49734 .48205 m .49762 .45599 L .49796 .44851 L p .689 g
F P
0 g
s
.49796 .44851 m .49814 .44464 L p .49804 .44897 L .689 g
F P
0 g
s
.49804 .44897 m .49734 .48205 L .49796 .44851 L .689 g
F
.49772 .43257 m .49762 .45599 L .49631 .46564 L closepath p .584 g
F P
0 g
s
.49809 .46607 m .49781 .45191 L .49747 .44575 L p .568 g
F P
0 g
s
.49747 .44575 m .4973 .44258 L p .49739 .44528 L .568 g
F P
0 g
s
.49739 .44528 m .49809 .46607 L .49747 .44575 L .568 g
F
.49772 .43257 m .49781 .45191 L .49913 .46011 L closepath p .526 g
F P
0 g
s
.49913 .46011 m .49794 .4527 L p .49805 .45329 L .55 g
F P
0 g
s
.50739 .48444 m .50933 .49013 L .50708 .4839 L .54 g
F
.51039 .49327 m .50985 .49177 L p .50933 .49013 L F P
0 g
s
.50985 .49177 m .50697 .48371 L p .50933 .49013 L .54 g
F P
0 g
s
.50697 .48371 m .5009 .46675 L p .50708 .4839 L .54 g
F P
0 g
s
.50933 .49013 m .50697 .48371 L .50708 .4839 L .54 g
F
.5009 .46675 m .49913 .46011 L p .50739 .48444 L F P
0 g
s
.50739 .48444 m .50708 .4839 L .5009 .46675 L .54 g
F
.50333 .4807 m .50835 .48726 L p .50008 .46293 L F P
0 g
s
.51039 .49327 m .50333 .4807 L p .51836 .50036 L .315 g
F P
0 g
s
.52208 .50603 m .51039 .49327 L p .51836 .50036 L .315 g
F P
0 g
s
.50453 .48246 m .51574 .49889 L .50478 .48259 L .315 g
F
.51574 .49889 m .51572 .49886 L .50478 .48259 L F
.50478 .48259 m .51572 .49886 L .51111 .49087 L F
.49971 .46184 m .49993 .46296 L .50008 .46293 L .54 g
F
.49913 .46011 m .49993 .46296 L .49971 .46184 L F
.49913 .46011 m .49972 .46299 L p .49993 .46296 L F P
0 g
s
.49972 .46299 m .50333 .4807 L p .50008 .46293 L .54 g
F P
0 g
s
.50333 .4807 m .49913 .46011 L p .49894 .45893 L .55 g
F P
0 g
s
.49805 .45329 m .50333 .4807 L .49894 .45893 L .55 g
F
.49793 .4525 m .50333 .4807 L .49794 .4527 L F
.50132 .47166 m .50386 .48468 L .49633 .53423 L p .777 g
F P
0 g
s
.49633 .53423 m .4969 .5088 L .50132 .47166 L p .777 g
F P
0 g
s
.49809 .46607 m .50333 .4807 L p .49902 .45824 L .55 g
F P
0 g
s
.50338 .48077 m .50569 .48486 L .50784 .48731 L .315 g
F
.50569 .48486 m .51014 .49277 L .50784 .48731 L F
.50333 .4807 m .50336 .48076 L p .50338 .48077 L F P
0 g
s
.50336 .48076 m .51014 .49277 L p .50338 .48077 L .315 g
F P
0 g
s
.50333 .4807 m .50453 .48246 L .50478 .48259 L .315 g
F
.51014 .49277 m .50333 .4807 L .50211 .47728 L p .422 g
F P
0 g
s
.50211 .47728 m .49809 .46607 L p .50415 .47949 L .422 g
F P
0 g
s
.50415 .47949 m .51014 .49277 L .50211 .47728 L .422 g
F
.49855 .474 m .51014 .49277 L p .50297 .47688 L F P
0 g
s
.50849 .48347 m .50883 .48523 L .50956 .48582 L .525 g
F
.51111 .49087 m .51595 .49919 L .51396 .4946 L .315 g
F
.51572 .49886 m .51595 .49919 L .51111 .49087 L F
.50784 .48731 m .51325 .49621 L .51547 .49849 L F
.51014 .49277 m .51325 .49621 L p .50784 .48731 L F P
0 g
s
.52341 .50061 m .50945 .47826 L .51647 .49475 L p .431 g
F P
0 g
s
.51014 .49277 m .49855 .474 L p .50602 .48167 L .162 g
F P
0 g
s
.51921 .4952 m .5131 .49357 L p .50602 .48167 L .162 g
F P
0 g
s
.5131 .49357 m .51014 .49277 L p .50602 .48167 L .162 g
F P
0 g
s
.49113 .475 m .49165 .46966 L .49221 .46625 L p .801 g
F P
0 g
s
.47891 .48833 m .48594 .4699 L p .49246 .46263 L .838 g
F P
0 g
s
.49238 .46522 m .49772 .43257 L .4923 .46743 L p .801 g
F P
0 g
s
.49221 .46625 m .49238 .46522 L p .49131 .47382 L .801 g
F P
0 g
s
.4923 .46743 m .49131 .47382 L p .49238 .46522 L .801 g
F P
0 g
s
.49131 .47382 m .49113 .475 L p .49221 .46625 L .801 g
F P
0 g
s
.49165 .46966 m .49297 .46206 L .4935 .45878 L p F P
s
.49772 .43257 m .4928 .47679 L .49155 .4775 L closepath p .743 g
F P
0 g
s
.49772 .43257 m .49455 .47275 L .4928 .47679 L closepath p .683 g
F P
0 g
s
.49772 .43257 m .49631 .46564 L .49455 .47275 L closepath p .632 g
F P
0 g
s
.49216 .50228 m .49631 .46564 L .4975 .45692 L p .705 g
F P
0 g
s
.4975 .45692 m .49762 .45599 L p .49751 .45695 L .705 g
F P
0 g
s
.49751 .45695 m .49216 .50228 L .4975 .45692 L .705 g
F
.49762 .45599 m .49734 .48205 L .49216 .50228 L p F P
0 g
s
.49479 .45717 m .49855 .474 L p .49524 .4516 L .53 g
F P
0 g
s
.48519 .51669 m .49455 .47275 L .49631 .46564 L p .728 g
F P
0 g
s
.49631 .46564 m .49216 .50228 L .48519 .51669 L p .728 g
F P
0 g
s
.49855 .474 m .49809 .46607 L .4975 .46131 L p .53 g
F P
0 g
s
.4975 .46131 m .49675 .45539 L p .49733 .46139 L .53 g
F P
0 g
s
.49733 .46139 m .49855 .474 L .4975 .46131 L .53 g
F
.4935 .45878 m .49586 .44411 L p .49221 .46625 L 0 g
F P
s
.49589 .44373 m .49221 .46625 L p .49586 .44411 L F P
s
.49221 .46625 m .49165 .46966 L p .4935 .45878 L F P
s
.48594 .4699 m .49283 .45093 L p .49389 .45202 L .779 g
F P
0 g
s
.4935 .45527 m .48594 .4699 L p .49389 .45202 L .779 g
F P
0 g
s
.49772 .43257 m .49155 .4775 L .49113 .475 L closepath p .805 g
F P
0 g
s
.49474 .45288 m .49772 .43257 L .49394 .45606 L p .031 g
F P
0 g
s
.49394 .45606 m .49297 .46206 L .49409 .45628 L p .031 g
F P
0 g
s
.49409 .45628 m .49474 .45288 L p .49394 .45606 L .031 g
F P
0 g
s
.49455 .45269 m .4935 .45527 L .49389 .45202 L .779 g
F
.49441 .45352 m .4935 .45527 L p .49455 .45269 L F P
0 g
s
.48594 .4699 m .49474 .45288 L .49297 .46206 L p .838 g
F P
0 g
s
.48698 .45627 m .49283 .45093 L .48594 .4699 L p .742 g
F P
0 g
s
.49408 .45402 m .49148 .45461 L .49418 .46178 L p .428 g
F P
0 g
s
.49677 .45573 m .49855 .474 L .49675 .45539 L .53 g
F
.49652 .45433 m .49855 .474 L .49667 .45472 L F
.49606 .4499 m .49524 .4516 L p .49855 .474 L F P
0 g
s
.4983 .46976 m .49855 .474 L p .50297 .47688 L .422 g
F P
0 g
s
.49855 .474 m .49887 .47454 L p .50093 .47645 L .162 g
F P
0 g
s
.49887 .47454 m .49915 .47501 L p .50093 .47645 L .162 g
F P
0 g
s
.49915 .47501 m .49855 .474 L .49515 .4588 L p .428 g
F P
0 g
s
.49542 .45956 m .49915 .47501 L .49515 .4588 L .428 g
F
.49474 .45288 m .49441 .45352 L p .49455 .45269 L .779 g
F P
0 g
s
.49772 .43257 m .49474 .45288 L .49648 .44284 L closepath p .17 g
F P
0 g
s
.49283 .45093 m .49648 .44284 L .49474 .45288 L p .779 g
F P
0 g
s
.49524 .4516 m .49408 .45402 L .49479 .45717 L p .53 g
F P
0 g
s
.49515 .4588 m .49408 .45402 L p .49542 .45956 L .428 g
F P
0 g
s
.49408 .45402 m .49418 .46178 L .49717 .4668 L .428 g
F
.49418 .46178 m .49736 .47026 L p .49717 .4668 L F P
0 g
s
.49736 .47026 m .49915 .47501 L p .49723 .46707 L .428 g
F P
0 g
s
.49717 .4668 m .49736 .47026 L .49723 .46707 L .428 g
F
.49809 .46607 m .4983 .46976 L p .50297 .47688 L .422 g
F P
0 g
s
.49797 .45496 m .49809 .46607 L .49902 .45824 L .55 g
F
.49782 .45244 m .49809 .46607 L p .49794 .45258 L F P
0 g
s
.4973 .44258 m .49606 .4499 L .49809 .46607 L p .568 g
F P
0 g
s
.49986 .46882 m .49915 .47501 L .49148 .45461 L p .272 g
F P
0 g
s
.49552 .46228 m .49737 .46507 L p .49589 .4621 L .272 g
F P
0 g
s
.49737 .46507 m .49986 .46882 L p .49695 .4639 L .272 g
F P
0 g
s
.49589 .4621 m .49737 .46507 L .49695 .4639 L .272 g
F
.48698 .45627 m .47932 .45847 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49283 .45093 m .48698 .45627 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49148 .45461 m .48843 .45159 L .49552 .46228 L p .272 g
F P
0 g
s
.49148 .45461 m .49552 .46228 L .49589 .4621 L .272 g
F
.49675 .45539 m .49667 .45472 L p .49677 .45573 L .53 g
F P
0 g
s
.49667 .45472 m .49606 .4499 L p .49652 .45433 L .53 g
F P
0 g
s
.49586 .44411 m .49772 .43257 L .49589 .44373 L p F P
s
.49297 .46206 m .49244 .46304 L p .49246 .46263 L .838 g
F P
0 g
s
.49244 .46304 m .47891 .48833 L p .49246 .46263 L .838 g
F P
0 g
s
.49915 .47501 m .51154 .48749 L p .50093 .47645 L .162 g
F P
0 g
s
.51154 .48749 m .51921 .4952 L p .50886 .48458 L .162 g
F P
0 g
s
.50093 .47645 m .51154 .48749 L .50886 .48458 L .162 g
F
.52583 .51011 m .52208 .50603 L p .51836 .50036 L .315 g
F P
0 g
s
.51574 .49889 m .51595 .49919 L .51572 .49886 L .315 g
F
.49794 .45258 m .49797 .45496 L .49902 .45824 L .55 g
F
.49794 .4527 m .49781 .45191 L p .49793 .4525 L F P
0 g
s
.49781 .45191 m .49782 .45244 L p .49794 .45258 L .55 g
F P
0 g
s
.49978 .45471 m .49772 .43257 L .49879 .45357 L p .577 g
F P
0 g
s
.51325 .49621 m .51595 .49919 L p .51547 .49849 L .315 g
F P
0 g
s
.51595 .49919 m .52583 .51011 L p .51396 .4946 L .315 g
F P
0 g
s
.50223 .46255 m .49772 .43257 L .50154 .46267 L p .676 g
F P
0 g
s
.50277 .46532 m .50322 .46867 L .50327 .46857 L .683 g
F
.50378 .46985 m .50268 .46474 L p .50222 .46172 L .047 g
F P
0 g
s
.50268 .46474 m .50246 .4637 L p .50222 .46172 L .047 g
F P
0 g
s
.50246 .4637 m .50193 .46024 L p .50222 .46172 L .047 g
F P
0 g
s
.49772 .43257 m .5026 .46504 L p .50277 .46532 L .683 g
F P
0 g
s
.50403 .47348 m .50431 .47318 L .50413 .47204 L p .683 g
F P
0 g
s
.50413 .47204 m .49772 .43257 L p .50403 .47348 L .683 g
F P
0 g
s
.50413 .47204 m .50431 .47318 L p .50323 .46642 L .498 g
F P
0 g
s
.50945 .47826 m .50259 .45697 L p .50154 .45589 L .652 g
F P
0 g
s
.50185 .45783 m .50945 .47826 L .50154 .45589 L .652 g
F
.49772 .43257 m .4973 .44258 L .49781 .45191 L closepath p .47 g
F P
0 g
s
.49772 .43257 m .48863 .36899 L .48541 .35945 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .48541 .35945 L .48217 .35271 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .48217 .35271 L .4791 .34924 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .4791 .34924 L .47643 .34934 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .47643 .34934 L .47434 .35303 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .47434 .35303 L .47299 .36012 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .47299 .36012 L .47247 .37015 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .47247 .37015 L .47285 .38243 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .47285 .38243 L .47408 .3961 L closepath p .751 g
F P
0 g
s
.44295 .3613 m .45193 .36278 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.43515 .36312 m .44295 .3613 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.42905 .36813 m .43515 .36312 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .47408 .3961 L .4761 .41018 L closepath p .751 g
F P
0 g
s
.4251 .37604 m .42905 .36813 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.42361 .38632 m .4251 .37604 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.42469 .39827 m .42361 .38632 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.42829 .41106 m .42469 .39827 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .4761 .41018 L .47874 .42366 L closepath p .751 g
F P
0 g
s
.43417 .42379 m .42829 .41106 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.44191 .43554 m .43417 .42379 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.45095 .44548 m .44191 .43554 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .47874 .42366 L .48183 .43558 L closepath p .751 g
F P
0 g
s
.46066 .45291 m .45095 .44548 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.47034 .45734 m .46066 .45291 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.47932 .45847 m .47034 .45734 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .48183 .43558 L .48514 .44511 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .48514 .44511 L .48843 .45159 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .48843 .45159 L .49148 .45461 L closepath p .751 g
F P
0 g
s
.49648 .44284 m .49283 .45093 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.49772 .43257 m .49148 .45461 L .49408 .45402 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .49408 .45402 L .49606 .4499 L closepath p .751 g
F P
0 g
s
.49772 .43257 m .49606 .4499 L .4973 .44258 L closepath p .751 g
F P
0 g
s
.51592 .48092 m .52466 .49058 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.50839 .46944 m .51592 .48092 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.50259 .45697 m .50839 .46944 L .49772 .43257 L closepath p .688 g
F P
0 g
s
.52815 .25978 m .53915 .23291 L .50051 .2891 L p .903 g
F P
0 g
s
.50051 .2891 m .49977 .30845 L .52815 .25978 L p .903 g
F P
0 g
s
.48541 .35945 m .48863 .36899 L .49977 .30845 L p .856 g
F P
0 g
s
.49977 .30845 m .50051 .2891 L .48541 .35945 L p .856 g
F P
0 g
s
.73378 .55634 m .70662 .57077 L .77027 .56393 L p .078 g
F P
0 g
s
.77027 .56393 m .806 .54056 L .73378 .55634 L p .078 g
F P
0 g
s
.60715 .55179 m .58505 .54694 L .63835 .57563 L p .294 g
F P
0 g
s
.63835 .57563 m .67404 .57741 L .60715 .55179 L p .294 g
F P
0 g
s
.27078 .66497 m .3159 .65757 L .35446 .67192 L p .748 g
F P
0 g
s
.39064 .64755 m .35446 .67192 L .3159 .65757 L p .796 g
F P
0 g
s
.35446 .67192 m .39064 .64755 L .42901 .6367 L p .85 g
F P
0 g
s
.22211 .3536 m .21503 .38289 L .14397 .42688 L p .213 g
F P
0 g
s
.14673 .46422 m .14397 .42688 L .21503 .38289 L p .324 g
F P
0 g
s
.45193 .36278 m .44295 .3613 L .36693 .31362 L p .551 g
F P
0 g
s
.48217 .35271 m .48541 .35945 L .50051 .2891 L p .887 g
F P
0 g
s
.85625 .30224 m .87965 .33691 L .86554 .27039 L p .112 g
F P
0 g
s
.86554 .27039 m .84227 .23757 L .85625 .30224 L p .112 g
F P
0 g
s
.45106 .60201 m .42901 .6367 L .39064 .64755 L p .838 g
F P
0 g
s
.42901 .6367 m .45106 .60201 L .47706 .57492 L p .85 g
F P
0 g
s
.4969 .5088 m .49633 .53423 L .47706 .57492 L p .799 g
F P
0 g
s
.50839 .46944 m .50259 .45697 L .50945 .47826 L p .616 g
F P
0 g
s
.51592 .48092 m .50839 .46944 L .52341 .50061 L p .584 g
F P
0 g
s
.34792 .31945 m .36693 .31362 L .44295 .3613 L p .55 g
F P
0 g
s
.50945 .47826 m .52341 .50061 L .50839 .46944 L p .616 g
F P
0 g
s
.76769 .20314 m .80878 .21478 L .75077 .17447 L p .494 g
F P
0 g
s
.75077 .17447 m .71684 .16936 L .76769 .20314 L p .494 g
F P
0 g
s
.59061 .19998 m .6161 .17864 L .55046 .21316 L p .913 g
F P
0 g
s
.55046 .21316 m .53915 .23291 L .59061 .19998 L p .913 g
F P
0 g
s
.58505 .54694 m .56265 .53625 L .60216 .56547 L p .285 g
F P
0 g
s
.60216 .56547 m .63835 .57563 L .58505 .54694 L p .285 g
F P
0 g
s
.206 .61346 m .25113 .62433 L .27078 .66497 L p .593 g
F P
0 g
s
.3159 .65757 m .27078 .66497 L .25113 .62433 L p .691 g
F P
0 g
s
.48558 .53968 m .47706 .57492 L .45106 .60201 L p .813 g
F P
0 g
s
.47706 .57492 m .48558 .53968 L .4969 .5088 L p .799 g
F P
0 g
s
.49734 .48205 m .4969 .5088 L .48558 .53968 L p .757 g
F P
0 g
s
.48558 .53968 m .49216 .50228 L .49734 .48205 L p .757 g
F P
0 g
s
.34792 .31945 m .33286 .33091 L .23828 .32848 L p .376 g
F P
0 g
s
.22211 .3536 m .23828 .32848 L .33286 .33091 L p .411 g
F P
0 g
s
.16166 .49983 m .18799 .53112 L .16874 .59206 L p .364 g
F P
0 g
s
.206 .61346 m .16874 .59206 L .18799 .53112 L p .499 g
F P
0 g
s
.44295 .3613 m .43515 .36312 L .34792 .31945 L p .55 g
F P
0 g
s
.84684 .47527 m .83207 .51023 L .87132 .46281 L p .004 g
F P
0 g
s
.87132 .46281 m .88788 .42005 L .84684 .47527 L p .004 g
F P
0 g
s
.50126 .27495 m .50051 .2891 L .53915 .23291 L p .933 g
F P
0 g
s
.50051 .2891 m .50126 .27495 L .48217 .35271 L p .887 g
F P
0 g
s
.4791 .34924 m .48217 .35271 L .50126 .27495 L p .91 g
F P
0 g
s
.47828 .52404 m .4928 .47679 L .49455 .47275 L p .756 g
F P
0 g
s
.49455 .47275 m .48519 .51669 L .47828 .52404 L p .756 g
F P
0 g
s
.47891 .48833 m .49297 .46206 L .49165 .46966 L p .854 g
F P
0 g
s
.70662 .57077 m .67404 .57741 L .72738 .57846 L p .058 g
F P
0 g
s
.72738 .57846 m .77027 .56393 L .70662 .57077 L p .058 g
F P
0 g
s
.67918 .1763 m .71684 .16936 L .64077 .1676 L p .748 g
F P
0 g
s
.64077 .1676 m .6161 .17864 L .67918 .1763 L p .748 g
F P
0 g
s
.53915 .23291 m .55046 .21316 L .50126 .27495 L p .933 g
F P
0 g
s
.56265 .53625 m .54159 .52043 L .56816 .54763 L p .308 g
F P
0 g
s
.56816 .54763 m .60216 .56547 L .56265 .53625 L p .308 g
F P
0 g
s
.47329 .524 m .49155 .4775 L .4928 .47679 L p .788 g
F P
0 g
s
.4928 .47679 m .47828 .52404 L .47329 .524 L p .788 g
F P
0 g
s
.49165 .46966 m .47365 .50467 L .47891 .48833 L p .854 g
F P
0 g
s
.47365 .50467 m .49165 .46966 L .49113 .475 L p .843 g
F P
0 g
s
.45106 .60201 m .47031 .56095 L .48558 .53968 L p .813 g
F P
0 g
s
.49216 .50228 m .48558 .53968 L .47031 .56095 L p .775 g
F P
0 g
s
.47031 .56095 m .48519 .51669 L .49216 .50228 L p .775 g
F P
0 g
s
.47159 .51713 m .49113 .475 L .49155 .4775 L p .818 g
F P
0 g
s
.49155 .4775 m .47329 .524 L .47159 .51713 L p .818 g
F P
0 g
s
.49113 .475 m .47159 .51713 L .47365 .50467 L p .843 g
F P
0 g
s
.39064 .64755 m .42511 .61293 L .45106 .60201 L p .838 g
F P
0 g
s
.47031 .56095 m .45106 .60201 L .42511 .61293 L p .817 g
F P
0 g
s
.43515 .36312 m .42905 .36813 L .33286 .33091 L p .555 g
F P
0 g
s
.33286 .33091 m .34792 .31945 L .43515 .36312 L p .555 g
F P
0 g
s
.47932 .45847 m .48698 .45627 L .4718 .4824 L p .723 g
F P
0 g
s
.48594 .4699 m .4718 .4824 L .48698 .45627 L p .742 g
F P
0 g
s
.3159 .65757 m .36219 .63798 L .39064 .64755 L p .796 g
F P
0 g
s
.42511 .61293 m .39064 .64755 L .36219 .63798 L p .811 g
F P
0 g
s
.21503 .38289 m .21778 .41439 L .14673 .46422 L p .324 g
F P
0 g
s
.16166 .49983 m .14673 .46422 L .21778 .41439 L p .414 g
F P
0 g
s
.47643 .34934 m .4791 .34924 L .50197 .26704 L p .891 g
F P
0 g
s
.50126 .27495 m .50197 .26704 L .49016 .30949 L p .91 g
F P
0 g
s
.50197 .26704 m .50126 .27495 L .55046 .21316 L p .913 g
F P
0 g
s
.56136 .20204 m .55046 .21316 L .6161 .17864 L p .825 g
F P
0 g
s
.55046 .21316 m .56136 .20204 L .50502 .26371 L p .913 g
F P
0 g
s
.50502 .26371 m .50197 .26704 L p .50525 .26339 L .913 g
F P
0 g
s
.50525 .26339 m .55046 .21316 L .50502 .26371 L .913 g
F
.48824 .31176 m .47643 .34934 L p .488 .31205 L .891 g
F P
0 g
s
.488 .31205 m .50197 .26704 L .48824 .31176 L .891 g
F
.50261 .26608 m .50197 .26704 L .56136 .20204 L p .703 g
F P
0 g
s
.50197 .26704 m .50261 .26608 L .48824 .31176 L p .891 g
F P
0 g
s
.48824 .31176 m .50216 .26751 L p .48745 .3127 L .763 g
F P
0 g
s
.50216 .26751 m .50261 .26608 L p .50213 .26755 L .763 g
F P
0 g
s
.48745 .3127 m .50216 .26751 L .50213 .26755 L .763 g
F
.47434 .35303 m .47643 .34934 L .48824 .31176 L p F P
0 g
s
.47434 .35303 m .48824 .31176 L .48745 .3127 L .763 g
F
.49016 .30949 m .4791 .34924 L p .49139 .30804 L .91 g
F P
0 g
s
.49139 .30804 m .50126 .27495 L .49016 .30949 L .91 g
F
.4718 .4824 m .48594 .4699 L .47891 .48833 L p .781 g
F P
0 g
s
.45512 .57066 m .47828 .52404 L .48519 .51669 L p .792 g
F P
0 g
s
.48519 .51669 m .47031 .56095 L .45512 .57066 L p .792 g
F P
0 g
s
.42511 .61293 m .45512 .57066 L .47031 .56095 L p .817 g
F P
0 g
s
.67404 .57741 m .63835 .57563 L .68045 .58296 L p .049 g
F P
0 g
s
.68045 .58296 m .72738 .57846 L .67404 .57741 L p .049 g
F P
0 g
s
.42905 .36813 m .4251 .37604 L .32288 .34731 L p .563 g
F P
0 g
s
.32288 .34731 m .33286 .33091 L .42905 .36813 L p .563 g
F P
0 g
s
.25113 .62433 m .30089 .62361 L .3159 .65757 L p .691 g
F P
0 g
s
.36219 .63798 m .3159 .65757 L .30089 .62361 L p .745 g
F P
0 g
s
.47034 .45734 m .47932 .45847 L .45318 .48943 L p .706 g
F P
0 g
s
.4718 .4824 m .45318 .48943 L .47932 .45847 L p .723 g
F P
0 g
s
.87965 .33691 m .89059 .37706 L .87653 .31129 L p .026 g
F P
0 g
s
.87653 .31129 m .86554 .27039 L .87965 .33691 L p .026 g
F P
0 g
s
.33286 .33091 m .32288 .34731 L .22211 .3536 L p .411 g
F P
0 g
s
.21503 .38289 m .22211 .3536 L .32288 .34731 L p .449 g
F P
0 g
s
.44409 .56851 m .47329 .524 L .47828 .52404 L p .806 g
F P
0 g
s
.47828 .52404 m .45512 .57066 L .44409 .56851 L p .806 g
F P
0 g
s
.83207 .51023 m .806 .54056 L .84176 .50215 L p F P
s
.84176 .50215 m .87132 .46281 L .83207 .51023 L p F P
s
.18799 .53112 m .22403 .55568 L .206 .61346 L p .499 g
F P
0 g
s
.25113 .62433 m .206 .61346 L .22403 .55568 L p .591 g
F P
0 g
s
.36219 .63798 m .40607 .60753 L .42511 .61293 L p .811 g
F P
0 g
s
.45512 .57066 m .42511 .61293 L .40607 .60753 L p .813 g
F P
0 g
s
.47891 .48833 m .45626 .5095 L .4718 .4824 L p .781 g
F P
0 g
s
.45626 .5095 m .47891 .48833 L .47365 .50467 L p .805 g
F P
0 g
s
.80878 .21478 m .84227 .23757 L .77849 .19182 L p .191 g
F P
0 g
s
.77849 .19182 m .75077 .17447 L .80878 .21478 L p .191 g
F P
0 g
s
.44023 .55579 m .47159 .51713 L .47329 .524 L p .814 g
F P
0 g
s
.47329 .524 m .44409 .56851 L .44023 .55579 L p .814 g
F P
0 g
s
.40607 .60753 m .44409 .56851 L .45512 .57066 L p .813 g
F P
0 g
s
.6161 .17864 m .64077 .1676 L .56136 .20204 L p .825 g
F P
0 g
s
.63835 .57563 m .60216 .56547 L .63303 .57704 L p .055 g
F P
0 g
s
.63303 .57704 m .68045 .58296 L .63835 .57563 L p .055 g
F P
0 g
s
.4251 .37604 m .42361 .38632 L .31877 .36761 L p .575 g
F P
0 g
s
.31877 .36761 m .32288 .34731 L .4251 .37604 L p .575 g
F P
0 g
s
.47365 .50467 m .44468 .53504 L .45626 .5095 L p .805 g
F P
0 g
s
.44468 .53504 m .47365 .50467 L .47159 .51713 L p .815 g
F P
0 g
s
.46066 .45291 m .47034 .45734 L .43131 .49039 L p .689 g
F P
0 g
s
.45318 .48943 m .43131 .49039 L .47034 .45734 L p .706 g
F P
0 g
s
.47159 .51713 m .44023 .55579 L .44468 .53504 L p .815 g
F P
0 g
s
.45318 .48943 m .4718 .4824 L .45626 .5095 L p .746 g
F P
0 g
s
.60216 .56547 m .56816 .54763 L .58869 .56118 L p .081 g
F P
0 g
s
.58869 .56118 m .63303 .57704 L .60216 .56547 L p .081 g
F P
0 g
s
.30089 .62361 m .35154 .61121 L .36219 .63798 L p .745 g
F P
0 g
s
.40607 .60753 m .36219 .63798 L .35154 .61121 L p .779 g
F P
0 g
s
.21778 .41439 m .23037 .44587 L .16166 .49983 L p .414 g
F P
0 g
s
.18799 .53112 m .16166 .49983 L .23037 .44587 L p .488 g
F P
0 g
s
.50063 .45569 m .49986 .46882 L .48843 .45159 L p .085 g
F P
0 g
s
.48843 .45159 m .48514 .44511 L .50063 .45569 L p .085 g
F P
0 g
s
.50261 .26608 m .50311 .27233 L .47434 .35303 L p .763 g
F P
0 g
s
.47299 .36012 m .47434 .35303 L .50311 .27233 L p F P
s
.42361 .38632 m .42469 .39827 L .32093 .39042 L p .589 g
F P
0 g
s
.32093 .39042 m .31877 .36761 L .42361 .38632 L p .589 g
F P
0 g
s
.45095 .44548 m .46066 .45291 L .40769 .48511 L p .672 g
F P
0 g
s
.43131 .49039 m .40769 .48511 L .46066 .45291 L p .689 g
F P
0 g
s
.3992 .588 m .44023 .55579 L .44409 .56851 L p .801 g
F P
0 g
s
.44409 .56851 m .40607 .60753 L .3992 .588 L p .801 g
F P
0 g
s
.66298 .16802 m .64077 .1676 L .71684 .16936 L p .414 g
F P
0 g
s
.71684 .16936 m .75077 .17447 L .66298 .16802 L p .414 g
F P
0 g
s
.35154 .61121 m .3992 .588 L .40607 .60753 L p .779 g
F P
0 g
s
.22403 .55568 m .26726 .57156 L .25113 .62433 L p .591 g
F P
0 g
s
.30089 .62361 m .25113 .62433 L .26726 .57156 L p .658 g
F P
0 g
s
.32288 .34731 m .31877 .36761 L .21503 .38289 L p .449 g
F P
0 g
s
.21778 .41439 m .21503 .38289 L .31877 .36761 L p .487 g
F P
0 g
s
.806 .54056 m .77027 .56393 L .80122 .53502 L p .811 g
F P
0 g
s
.80122 .53502 m .84176 .50215 L .806 .54056 L p .811 g
F P
0 g
s
.42469 .39827 m .42829 .41106 L .3293 .41415 L p .604 g
F P
0 g
s
.3293 .41415 m .32093 .39042 L .42469 .39827 L p .604 g
F P
0 g
s
.44191 .43554 m .45095 .44548 L .38402 .47388 L p .655 g
F P
0 g
s
.40769 .48511 m .38402 .47388 L .45095 .44548 L p .672 g
F P
0 g
s
.45626 .5095 m .42644 .52393 L .45318 .48943 L p .746 g
F P
0 g
s
.42644 .52393 m .45626 .5095 L .44468 .53504 L p .766 g
F P
0 g
s
.52232 .50893 m .55223 .53584 L .55565 .54037 L p .128 g
F P
0 g
s
.55223 .53584 m .52232 .50893 L .51736 .503 L p .092 g
F P
0 g
s
.40661 .55843 m .44468 .53504 L .44023 .55579 L p .785 g
F P
0 g
s
.44023 .55579 m .3992 .588 L .40661 .55843 L p .785 g
F P
0 g
s
.50141 .43639 m .50063 .45569 L .48514 .44511 L p .159 g
F P
0 g
s
.48514 .44511 m .48183 .43558 L .50141 .43639 L p .159 g
F P
0 g
s
.51736 .503 m .54129 .52505 L .55223 .53584 L p .092 g
F P
0 g
s
.42829 .41106 m .43417 .42379 L .34333 .43706 L p .621 g
F P
0 g
s
.34333 .43706 m .3293 .41415 L .42829 .41106 L p .621 g
F P
0 g
s
.50311 .27233 m .50345 .28555 L .47299 .36012 L p F P
s
.47247 .37015 m .47299 .36012 L .50345 .28555 L p .025 g
F P
0 g
s
.43417 .42379 m .44191 .43554 L .36203 .45747 L p .637 g
F P
0 g
s
.38402 .47388 m .36203 .45747 L .44191 .43554 L p .655 g
F P
0 g
s
.43131 .49039 m .45318 .48943 L .42644 .52393 L p .715 g
F P
0 g
s
.89059 .37706 m .88788 .42005 L .874 .35754 L p .744 g
F P
0 g
s
.874 .35754 m .87653 .31129 L .89059 .37706 L p .744 g
F P
0 g
s
.36203 .45747 m .34333 .43706 L .43417 .42379 L p .637 g
F P
0 g
s
.44468 .53504 m .40661 .55843 L .42644 .52393 L p .766 g
F P
0 g
s
.26726 .57156 m .31447 .57749 L .30089 .62361 L p .658 g
F P
0 g
s
.35154 .61121 m .30089 .62361 L .31447 .57749 L p .709 g
F P
0 g
s
.23037 .44587 m .25204 .47503 L .18799 .53112 L p .488 g
F P
0 g
s
.22403 .55568 m .18799 .53112 L .25204 .47503 L p .55 g
F P
0 g
s
.50214 .41221 m .50141 .43639 L .48183 .43558 L p .185 g
F P
0 g
s
.48183 .43558 m .47874 .42366 L .50214 .41221 L p .185 g
F P
0 g
s
.36212 .57298 m .40661 .55843 L .3992 .588 L p .75 g
F P
0 g
s
.3992 .588 m .35154 .61121 L .36212 .57298 L p .75 g
F P
0 g
s
.50345 .28555 m .50359 .30493 L .47247 .37015 L p .025 g
F P
0 g
s
.47285 .38243 m .47247 .37015 L .50359 .30493 L p .046 g
F P
0 g
s
.77027 .56393 m .72738 .57846 L .75267 .5588 L p .843 g
F P
0 g
s
.75267 .5588 m .80122 .53502 L .77027 .56393 L p .843 g
F P
0 g
s
.31447 .57749 m .36212 .57298 L .35154 .61121 L p .709 g
F P
0 g
s
.84227 .23757 m .86554 .27039 L .79777 .22072 L p .394 g
F P
0 g
s
.79777 .22072 m .77849 .19182 L .84227 .23757 L p .394 g
F P
0 g
s
.31877 .36761 m .32093 .39042 L .21778 .41439 L p .487 g
F P
0 g
s
.23037 .44587 m .21778 .41439 L .32093 .39042 L p .524 g
F P
0 g
s
.63303 .57704 m .58869 .56118 L .59754 .56186 L p .535 g
F P
0 g
s
.55565 .54037 m .59754 .56186 L .58869 .56118 L p .328 g
F P
0 g
s
.50276 .38491 m .50214 .41221 L .47874 .42366 L p .196 g
F P
0 g
s
.47874 .42366 m .4761 .41018 L .50276 .38491 L p .196 g
F P
0 g
s
.50359 .30493 m .50351 .32917 L .47285 .38243 L p .046 g
F P
0 g
s
.47408 .3961 m .47285 .38243 L .50351 .32917 L p .093 g
F P
0 g
s
.40769 .48511 m .43131 .49039 L .39143 .53045 L p .685 g
F P
0 g
s
.42644 .52393 m .39143 .53045 L .43131 .49039 L p .715 g
F P
0 g
s
.39143 .53045 m .42644 .52393 L .40661 .55843 L p .728 g
F P
0 g
s
.64077 .1676 m .66298 .16802 L .5711 .20063 L p F P
s
.5711 .20063 m .56136 .20204 L .64077 .1676 L p F P
s
.40661 .55843 m .36212 .57298 L .39143 .53045 L p .728 g
F P
0 g
s
.50323 .35652 m .50276 .38491 L .4761 .41018 L p .165 g
F P
0 g
s
.4761 .41018 m .47408 .3961 L .50323 .35652 L p .165 g
F P
0 g
s
.50351 .32917 m .50323 .35652 L .47408 .3961 L p .093 g
F P
0 g
s
.54643 .51574 m .52583 .51011 L .51014 .49277 L p .227 g
F P
0 g
s
.51014 .49277 m .51921 .4952 L .54643 .51574 L p .227 g
F P
0 g
s
.59754 .56186 m .55565 .54037 L .55223 .53584 L p .397 g
F P
0 g
s
.52999 .48745 m .51921 .4952 L .49915 .47501 L p .253 g
F P
0 g
s
.49915 .47501 m .49986 .46882 L .52999 .48745 L p .253 g
F P
0 g
s
.56136 .20204 m .5711 .20063 L .50261 .26608 L p .703 g
F P
0 g
s
.72738 .57846 m .68045 .58296 L .69984 .57165 L p .791 g
F P
0 g
s
.69984 .57165 m .75267 .5588 L .72738 .57846 L p .791 g
F P
0 g
s
.25204 .47503 m .28133 .49968 L .22403 .55568 L p .55 g
F P
0 g
s
.26726 .57156 m .22403 .55568 L .28133 .49968 L p .602 g
F P
0 g
s
.50311 .27233 m .50261 .26608 L .5711 .20063 L p F P
s
.68045 .58296 m .63303 .57704 L .64679 .57263 L p .689 g
F P
0 g
s
.59754 .56186 m .64679 .57263 L .63303 .57704 L p .535 g
F P
0 g
s
.32093 .39042 m .3293 .41415 L .23037 .44587 L p .524 g
F P
0 g
s
.64679 .57263 m .69984 .57165 L .68045 .58296 L p .689 g
F P
0 g
s
.88788 .42005 m .87132 .46281 L .85769 .4058 L p .884 g
F P
0 g
s
.85769 .4058 m .874 .35754 L .88788 .42005 L p .884 g
F P
0 g
s
.38402 .47388 m .40769 .48511 L .35373 .52844 L p .655 g
F P
0 g
s
.39143 .53045 m .35373 .52844 L .40769 .48511 L p .685 g
F P
0 g
s
.35373 .52844 m .39143 .53045 L .36212 .57298 L p .69 g
F P
0 g
s
.36212 .57298 m .31447 .57749 L .35373 .52844 L p .69 g
F P
0 g
s
.75077 .17447 m .77849 .19182 L .68108 .18038 L p .148 g
F P
0 g
s
.68108 .18038 m .66298 .16802 L .75077 .17447 L p .148 g
F P
0 g
s
.25204 .47503 m .23037 .44587 L .3293 .41415 L p .559 g
F P
0 g
s
.28133 .49968 m .31609 .51793 L .26726 .57156 L p .602 g
F P
0 g
s
.31447 .57749 m .26726 .57156 L .31609 .51793 L p .648 g
F P
0 g
s
.55223 .53584 m .59197 .55215 L .59754 .56186 L p .397 g
F P
0 g
s
.59197 .55215 m .55223 .53584 L .54129 .52505 L p .393 g
F P
0 g
s
.31609 .51793 m .35373 .52844 L .31447 .57749 L p .648 g
F P
0 g
s
.57322 .53559 m .54129 .52505 L .52583 .51011 L p .323 g
F P
0 g
s
.3293 .41415 m .34333 .43706 L .25204 .47503 L p .559 g
F P
0 g
s
.36203 .45747 m .38402 .47388 L .31609 .51793 L p .624 g
F P
0 g
s
.35373 .52844 m .31609 .51793 L .38402 .47388 L p .655 g
F P
0 g
s
.54129 .52505 m .57322 .53559 L .59197 .55215 L p .393 g
F P
0 g
s
.34333 .43706 m .36203 .45747 L .28133 .49968 L p .592 g
F P
0 g
s
.28133 .49968 m .25204 .47503 L .34333 .43706 L p .592 g
F P
0 g
s
.31609 .51793 m .28133 .49968 L .36203 .45747 L p .624 g
F P
0 g
s
.54177 .46968 m .52999 .48745 L .49986 .46882 L p .397 g
F P
0 g
s
.49986 .46882 m .50063 .45569 L .54177 .46968 L p .397 g
F P
0 g
s
.64679 .57263 m .59754 .56186 L .59197 .55215 L p .615 g
F P
0 g
s
.86554 .27039 m .87653 .31129 L .80683 .25953 L p .626 g
F P
0 g
s
.80683 .25953 m .79777 .22072 L .86554 .27039 L p .626 g
F P
0 g
s
.5711 .20063 m .57897 .20939 L .50311 .27233 L p F P
s
.50345 .28555 m .50311 .27233 L .57897 .20939 L p .088 g
F P
0 g
s
.87132 .46281 m .84176 .50215 L .82857 .45236 L p .907 g
F P
0 g
s
.82857 .45236 m .85769 .4058 L .87132 .46281 L p .907 g
F P
0 g
s
.57099 .50923 m .54643 .51574 L .51921 .4952 L p .448 g
F P
0 g
s
.51921 .4952 m .52999 .48745 L .57099 .50923 L p .448 g
F P
0 g
s
.57897 .20939 m .5711 .20063 L .66298 .16802 L p .092 g
F P
0 g
s
.66298 .16802 m .68108 .18038 L .57897 .20939 L p .092 g
F P
0 g
s
.69984 .57165 m .64679 .57263 L .63902 .55626 L p .734 g
F P
0 g
s
.59197 .55215 m .63902 .55626 L .64679 .57263 L p .615 g
F P
0 g
s
.5537 .44286 m .54177 .46968 L .50063 .45569 L p .461 g
F P
0 g
s
.50063 .45569 m .50141 .43639 L .5537 .44286 L p .461 g
F P
0 g
s
.63902 .55626 m .59197 .55215 L .57322 .53559 L p .601 g
F P
0 g
s
.84176 .50215 m .80122 .53502 L .78875 .49354 L p .89 g
F P
0 g
s
.78875 .49354 m .82857 .45236 L .84176 .50215 L p .89 g
F P
0 g
s
.77849 .19182 m .79777 .22072 L .69358 .20434 L p .392 g
F P
0 g
s
.69358 .20434 m .68108 .18038 L .77849 .19182 L p .392 g
F P
0 g
s
.57897 .20939 m .58433 .2281 L .50345 .28555 L p .088 g
F P
0 g
s
.50359 .30493 m .50345 .28555 L .58433 .2281 L p .233 g
F P
0 g
s
.61121 .53336 m .57322 .53559 L .54643 .51574 L p .548 g
F P
0 g
s
.54643 .51574 m .57099 .50923 L .61121 .53336 L p .548 g
F P
0 g
s
.75267 .5588 m .69984 .57165 L .69009 .54745 L p .807 g
F P
0 g
s
.63902 .55626 m .69009 .54745 L .69984 .57165 L p .734 g
F P
0 g
s
.57322 .53559 m .61121 .53336 L .63902 .55626 L p .601 g
F P
0 g
s
.80122 .53502 m .75267 .5588 L .74133 .52606 L p .856 g
F P
0 g
s
.74133 .52606 m .78875 .49354 L .80122 .53502 L p .856 g
F P
0 g
s
.87653 .31129 m .874 .35754 L .80459 .30567 L p .719 g
F P
0 g
s
.80459 .30567 m .80683 .25953 L .87653 .31129 L p .719 g
F P
0 g
s
.69009 .54745 m .74133 .52606 L .75267 .5588 L p .807 g
F P
0 g
s
.56489 .4088 m .5537 .44286 L .50141 .43639 L p .479 g
F P
0 g
s
.50141 .43639 m .50214 .41221 L .56489 .4088 L p .479 g
F P
0 g
s
.58433 .2281 m .58668 .2557 L .50359 .30493 L p .233 g
F P
0 g
s
.50351 .32917 m .50359 .30493 L .58668 .2557 L p .343 g
F P
0 g
s
.59787 .49055 m .57099 .50923 L .52999 .48745 L p .55 g
F P
0 g
s
.52999 .48745 m .54177 .46968 L .59787 .49055 L p .55 g
F P
0 g
s
.58433 .2281 m .57897 .20939 L .68108 .18038 L p .277 g
F P
0 g
s
.68108 .18038 m .69358 .20434 L .58433 .2281 L p .277 g
F P
0 g
s
.69009 .54745 m .63902 .55626 L .61121 .53336 L p .692 g
F P
0 g
s
.57444 .36999 m .56489 .4088 L .50214 .41221 L p .473 g
F P
0 g
s
.50214 .41221 m .50276 .38491 L .57444 .36999 L p .473 g
F P
0 g
s
.58668 .2557 m .58577 .29033 L .50351 .32917 L p .343 g
F P
0 g
s
.50323 .35652 m .50351 .32917 L .58577 .29033 L p .409 g
F P
0 g
s
.58159 .32944 m .57444 .36999 L .50276 .38491 L p .45 g
F P
0 g
s
.50276 .38491 m .50323 .35652 L .58159 .32944 L p .45 g
F P
0 g
s
.58577 .29033 m .58159 .32944 L .50323 .35652 L p .409 g
F P
0 g
s
.79777 .22072 m .80683 .25953 L .69931 .23856 L p .531 g
F P
0 g
s
.69931 .23856 m .69358 .20434 L .79777 .22072 L p .531 g
F P
0 g
s
.874 .35754 m .85769 .4058 L .79089 .35573 L p .755 g
F P
0 g
s
.79089 .35573 m .80459 .30567 L .874 .35754 L p .755 g
F P
0 g
s
.65269 .51799 m .61121 .53336 L .57099 .50923 L p .632 g
F P
0 g
s
.57099 .50923 m .59787 .49055 L .65269 .51799 L p .632 g
F P
0 g
s
.61121 .53336 m .65269 .51799 L .69009 .54745 L p .692 g
F P
0 g
s
.62512 .46064 m .59787 .49055 L .54177 .46968 L p .586 g
F P
0 g
s
.54177 .46968 m .5537 .44286 L .62512 .46064 L p .586 g
F P
0 g
s
.58668 .2557 m .58433 .2281 L .69358 .20434 L p .415 g
F P
0 g
s
.74133 .52606 m .69009 .54745 L .65269 .51799 L p .736 g
F P
0 g
s
.85769 .4058 m .82857 .45236 L .76661 .40579 L p .768 g
F P
0 g
s
.76661 .40579 m .79089 .35573 L .85769 .4058 L p .768 g
F P
0 g
s
.69358 .20434 m .69931 .23856 L .58668 .2557 L p .415 g
F P
0 g
s
.78875 .49354 m .74133 .52606 L .69459 .49019 L p .758 g
F P
0 g
s
.65269 .51799 m .69459 .49019 L .74133 .52606 L p .736 g
F P
0 g
s
.80683 .25953 m .80459 .30567 L .6976 .28077 L p .601 g
F P
0 g
s
.6976 .28077 m .69931 .23856 L .80683 .25953 L p .601 g
F P
0 g
s
.82857 .45236 m .78875 .49354 L .73362 .45183 L p .768 g
F P
0 g
s
.73362 .45183 m .76661 .40579 L .82857 .45236 L p .768 g
F P
0 g
s
.69459 .49019 m .73362 .45183 L .78875 .49354 L p .758 g
F P
0 g
s
.65062 .42148 m .62512 .46064 L .5537 .44286 L p .594 g
F P
0 g
s
.5537 .44286 m .56489 .4088 L .65062 .42148 L p .594 g
F P
0 g
s
.58577 .29033 m .58668 .2557 L .69931 .23856 L p .493 g
F P
0 g
s
.69459 .49019 m .65269 .51799 L .59787 .49055 L p .665 g
F P
0 g
s
.59787 .49055 m .62512 .46064 L .69459 .49019 L p .665 g
F P
0 g
s
.6723 .37601 m .65062 .42148 L .56489 .4088 L p .587 g
F P
0 g
s
.56489 .4088 m .57444 .36999 L .6723 .37601 L p .587 g
F P
0 g
s
.69931 .23856 m .6976 .28077 L .58577 .29033 L p .493 g
F P
0 g
s
.58159 .32944 m .58577 .29033 L .6976 .28077 L p .54 g
F P
0 g
s
.80459 .30567 m .79089 .35573 L .68839 .32782 L p .64 g
F P
0 g
s
.68839 .32782 m .6976 .28077 L .80459 .30567 L p .64 g
F P
0 g
s
.73362 .45183 m .69459 .49019 L .62512 .46064 L p .675 g
F P
0 g
s
.68839 .32782 m .6723 .37601 L .57444 .36999 L p .57 g
F P
0 g
s
.57444 .36999 m .58159 .32944 L .68839 .32782 L p .57 g
F P
0 g
s
.6976 .28077 m .68839 .32782 L .58159 .32944 L p .54 g
F P
0 g
s
.62512 .46064 m .65062 .42148 L .73362 .45183 L p .675 g
F P
0 g
s
.79089 .35573 m .76661 .40579 L .6723 .37601 L p .662 g
F P
0 g
s
.6723 .37601 m .68839 .32782 L .79089 .35573 L p .662 g
F P
0 g
s
.76661 .40579 m .73362 .45183 L .65062 .42148 L p .674 g
F P
0 g
s
.65062 .42148 m .6723 .37601 L .76661 .40579 L p .674 g
F P
0 g
s
.25 Mabswid
.7913 0 m
.95779 .2576 L
s
.95779 .2576 m
1 .60412 L
s
1 .60412 m
.82157 .36284 L
s
.82157 .36284 m
.7913 0 L
s
.04148 .27674 m
0 .62185 L
s
0 .62185 m
.82157 .36284 L
s
.82157 .36284 m
.7913 0 L
s
.7913 0 m
.04148 .27674 L
s
.04148 .27674 m
.7913 0 L
s
.05744 .27085 m
.06197 .27519 L
s
gsave
.04837 .26216 -74.9375 -13.7877 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.2217 .21022 m
.22601 .21478 L
s
gsave
.21306 .20111 -81.0203 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.39492 .14629 m
.39898 .15108 L
s
gsave
.38678 .13673 -68.8055 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.57785 .07878 m
.58163 .08379 L
s
gsave
.5703 .06875 -74.2031 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.77133 .00737 m
.77478 .01262 L
s
gsave
.76445 -0.00313 -67.9864 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08961 .25897 m
.0923 .26161 L
s
.12211 .24698 m
.12478 .24963 L
s
.15496 .23486 m
.1576 .23754 L
s
.18815 .2226 m
.19077 .22531 L
s
.2556 .19771 m
.25816 .20047 L
s
.28987 .18506 m
.2924 .18785 L
s
.32451 .17228 m
.32701 .17509 L
s
.35952 .15936 m
.36199 .1622 L
s
.4307 .13309 m
.43311 .13598 L
s
.46688 .11973 m
.46925 .12266 L
s
.50346 .10623 m
.5058 .10919 L
s
.54045 .09258 m
.54275 .09556 L
s
.61567 .06482 m
.6179 .06786 L
s
.65393 .0507 m
.65612 .05377 L
s
.69262 .03642 m
.69477 .03951 L
s
.73175 .02198 m
.73386 .0251 L
s
gsave
.34612 .08889 -68.4008 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.0169609 0.97619 0.340025 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
-0.066106 1.21212 0 1.21212 [
[.5 1.12503 -19.625 0 ]
[.5 1.12503 19.625 10.625 ]
[.04889 .17135 -20.0203 -10 ]
[.04889 .17135 .5422 0 ]
[.15639 .12856 -23.7341 -10 ]
[.15639 .12856 1.26593 0 ]
[.26699 .08455 -7.80548 -10 ]
[.26699 .08455 .63202 0 ]
[.38085 .03925 -17.5661 -10 ]
[.38085 .03925 1.93392 0 ]
[.49809 -0.00739 -13.2031 -10 ]
[.49809 -0.00739 1.85938 0 ]
[.21792 .02683 -7.40075 -10 ]
[.21792 .02683 .59925 0 ]
[.54614 .01177 0 -6.96909 ]
[.54614 .01177 13.9375 3.03091 ]
[.66854 .17551 0 -6.83927 ]
[.66854 .17551 20.5625 3.16073 ]
[.7789 .32314 0 -6.72552 ]
[.7789 .32314 8.4375 3.27448 ]
[.87891 .45694 0 -6.62501 ]
[.87891 .45694 15.0625 3.37499 ]
[.96996 .57877 0 -6.53557 ]
[.96996 .57877 8.4375 3.46443 ]
[.85051 .29843 0 -6.72552 ]
[.85051 .29843 8 3.27448 ]
[.03361 .20153 -20.5625 -3.02288 ]
[.03361 .20153 0 6.97712 ]
[.02271 .29784 -25 -3.08408 ]
[.02271 .29784 0 6.91592 ]
[.01132 .39849 -8.4375 -3.14821 ]
[.01132 .39849 0 6.85179 ]
[-0.00059 .50376 -19.5 -3.21551 ]
[-0.00059 .50376 0 6.78449 ]
[-0.01306 .61401 -15.0625 -3.28621 ]
[-0.01306 .61401 0 6.71379 ]
[-0.05972 .4248 -8 -3.14821 ]
[-0.05972 .4248 0 6.85179 ]
[ 0 0 0 0 ]
[ 1 1.11253 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.12503 -80.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.625000 moveto
 540.000000 14.625000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.625000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
67.437500 12.375000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.500000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
76.625000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
98.250000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.04875 .18654 m
.51908 0 L
s
.05931 .18235 m
.06452 .18785 L
s
gsave
.04889 .17135 -81.0203 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.16652 .13983 m
.17158 .14547 L
s
gsave
.15639 .12856 -84.7341 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.27681 .09609 m
.28172 .10186 L
s
gsave
.26699 .08455 -68.8055 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.39032 .05107 m
.39506 .05698 L
s
gsave
.38085 .03925 -78.5661 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.5072 .00471 m
.51176 .01076 L
s
gsave
.49809 -0.00739 -74.2031 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08051 .17394 m
.08362 .17726 L
s
.10183 .16549 m
.10492 .16882 L
s
.12327 .15699 m
.12634 .16033 L
s
.14483 .14843 m
.14789 .1518 L
s
.18832 .13118 m
.19134 .13458 L
s
.21025 .12249 m
.21326 .1259 L
s
.23231 .11374 m
.2353 .11717 L
s
.2545 .10494 m
.25746 .10839 L
s
.29925 .08719 m
.30217 .09067 L
s
.32182 .07824 m
.32472 .08173 L
s
.34452 .06923 m
.34741 .07275 L
s
.36736 .06018 m
.37022 .06371 L
s
.41342 .04191 m
.41625 .04547 L
s
.43666 .03269 m
.43946 .03627 L
s
.46004 .02342 m
.46282 .02701 L
s
.48355 .01409 m
.48631 .01771 L
s
gsave
.21792 .02683 -68.4008 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.51908 0 m
.96413 .59478 L
s
.53205 .01733 m
.525 .0201 L
s
gsave
.54614 .01177 -61 -10.9691 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.65432 .18074 m
.64721 .18336 L
s
gsave
.66854 .17551 -61 -10.8393 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.76458 .32809 m
.75741 .33056 L
s
gsave
.7789 .32314 -61 -10.7255 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.8645 .46163 m
.85729 .46397 L
s
gsave
.87891 .45694 -61 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.95548 .58322 m
.94824 .58544 L
s
gsave
.96996 .57877 -61 -10.5356 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.55756 .05142 m
.55332 .05306 L
s
.58252 .08478 m
.57828 .08641 L
s
.60696 .11744 m
.60271 .11905 L
s
.63089 .14942 m
.62663 .15101 L
s
.67727 .21142 m
.673 .21297 L
s
.69976 .24147 m
.69548 .243 L
s
.7218 .27092 m
.71752 .27244 L
s
.7434 .29979 m
.73911 .30129 L
s
.78534 .35584 m
.78104 .3573 L
s
.8057 .38305 m
.80139 .3845 L
s
.82567 .40974 m
.82136 .41118 L
s
.84527 .43593 m
.84095 .43735 L
s
.88337 .48685 m
.87904 .48824 L
s
.90189 .51161 m
.89756 .51298 L
s
.92008 .53591 m
.91574 .53727 L
s
.93794 .55978 m
.9336 .56112 L
s
gsave
.85051 .29843 -61 -10.7255 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04875 .18654 m
0 .62042 L
s
.0477 .19596 m
.05474 .19317 L
s
gsave
.03361 .20153 -81.5625 -7.02288 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.03686 .29242 m
.04393 .28971 L
s
gsave
.02271 .29784 -86 -7.08408 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.02553 .39322 m
.03263 .39059 L
s
gsave
.01132 .39849 -69.4375 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.01368 .49867 m
.02082 .49613 L
s
gsave
-0.00059 .50376 -80.5 -7.21551 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00127 .60909 m
.00844 .60664 L
s
gsave
-0.01306 .61401 -76.0625 -7.28621 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.04557 .21492 m
.0498 .21325 L
s
.04342 .23404 m
.04765 .23239 L
s
.04125 .25333 m
.04549 .25168 L
s
.03906 .27279 m
.0433 .27115 L
s
.03463 .31222 m
.03888 .31061 L
s
.03239 .3322 m
.03664 .3306 L
s
.03012 .35236 m
.03438 .35076 L
s
.02784 .3727 m
.03209 .37111 L
s
.0232 .41393 m
.02747 .41236 L
s
.02085 .43483 m
.02512 .43327 L
s
.01849 .45591 m
.02276 .45437 L
s
.01609 .4772 m
.02037 .47566 L
s
.01125 .52035 m
.01553 .51883 L
s
.00879 .54222 m
.01308 .54072 L
s
.00631 .56431 m
.0106 .56281 L
s
.0038 .58659 m
.0081 .58511 L
s
gsave
-0.05972 .4248 -69 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04875 .18654 m
0 .62042 L
s
0 .62042 m
.5574 1.11253 L
s
.5574 1.11253 m
.5561 .7194 L
s
.5561 .7194 m
.04875 .18654 L
s
.51908 0 m
.96413 .59478 L
s
.96413 .59478 m
1 .99897 L
s
1 .99897 m
.51687 .44401 L
s
.51687 .44401 m
.51908 0 L
s
.04875 .18654 m
0 .62042 L
s
0 .62042 m
.51687 .44401 L
s
.51687 .44401 m
.51908 0 L
s
.51908 0 m
.04875 .18654 L
s
.5561 .7194 m
.96413 .59478 L
s
.96413 .59478 m
1 .99897 L
s
1 .99897 m
.5574 1.11253 L
s
.5574 1.11253 m
.5561 .7194 L
s
0 0 m
1 0 L
1 1.11253 L
0 1.11253 L
closepath
clip
newpath
.5 Mabswid
.53101 .69057 m .53018 .74085 L .6324 .74871 L p .673 g
F P
0 g
s
.6324 .74871 m .62454 .69365 L .53101 .69057 L p .673 g
F P
0 g
s
.63773 .80318 m .6324 .74871 L .53018 .74085 L p .643 g
F P
0 g
s
.62454 .69365 m .6324 .74871 L .73703 .73168 L p .609 g
F P
0 g
s
.6324 .74871 m .63773 .80318 L .74853 .78715 L p .571 g
F P
0 g
s
.74853 .78715 m .73703 .73168 L .6324 .74871 L p .571 g
F P
0 g
s
.53206 .6424 m .53101 .69057 L .62454 .69365 L p .705 g
F P
0 g
s
.62454 .69365 m .61459 .6411 L .53206 .6424 L p .705 g
F P
0 g
s
.61459 .6411 m .62454 .69365 L .72014 .67627 L p .645 g
F P
0 g
s
.73703 .73168 m .72014 .67627 L .62454 .69365 L p .609 g
F P
0 g
s
.53018 .74085 m .52962 .79035 L .63773 .80318 L p .643 g
F P
0 g
s
.6402 .85394 m .63773 .80318 L .52962 .79035 L p .61 g
F P
0 g
s
.63773 .80318 m .6402 .85394 L .75389 .83951 L p .528 g
F P
0 g
s
.75389 .83951 m .74853 .78715 L .63773 .80318 L p .528 g
F P
0 g
s
.53328 .59916 m .53206 .6424 L .61459 .6411 L p .741 g
F P
0 g
s
.61459 .6411 m .60309 .59409 L .53328 .59916 L p .741 g
F P
0 g
s
.60309 .59409 m .61459 .6411 L .69881 .62407 L p .684 g
F P
0 g
s
.72014 .67627 m .69881 .62407 L .61459 .6411 L p .645 g
F P
0 g
s
.69881 .62407 m .72014 .67627 L .79541 .64136 L p .591 g
F P
0 g
s
.72014 .67627 m .73703 .73168 L .81971 .69272 L p .543 g
F P
0 g
s
.81971 .69272 m .79541 .64136 L .72014 .67627 L p .543 g
F P
0 g
s
.73703 .73168 m .74853 .78715 L .83623 .74521 L p .49 g
F P
0 g
s
.83623 .74521 m .81971 .69272 L .73703 .73168 L p .49 g
F P
0 g
s
.69881 .62407 m .67422 .57808 L .60309 .59409 L p .684 g
F P
0 g
s
.67422 .57808 m .69881 .62407 L .7648 .5941 L p .639 g
F P
0 g
s
.79541 .64136 m .7648 .5941 L .69881 .62407 L p .591 g
F P
0 g
s
.46175 .66985 m .45447 .71118 L .53018 .74085 L p .761 g
F P
0 g
s
.53018 .74085 m .53101 .69057 L .46175 .66985 L p .761 g
F P
0 g
s
.52962 .79035 m .53018 .74085 L .45447 .71118 L p .733 g
F P
0 g
s
.47103 .63045 m .46175 .66985 L .53101 .69057 L p .791 g
F P
0 g
s
.53101 .69057 m .53206 .6424 L .47103 .63045 L p .791 g
F P
0 g
s
.74853 .78715 m .75389 .83951 L .84389 .79574 L p .424 g
F P
0 g
s
.84389 .79574 m .83623 .74521 L .74853 .78715 L p .424 g
F P
0 g
s
.52962 .79035 m .52937 .83622 L .6402 .85394 L p .61 g
F P
0 g
s
.63959 .89795 m .6402 .85394 L .52937 .83622 L p .57 g
F P
0 g
s
.6402 .85394 m .63959 .89795 L .75266 .88559 L p .472 g
F P
0 g
s
.75266 .88559 m .75389 .83951 L .6402 .85394 L p .472 g
F P
0 g
s
.5346 .56352 m .53328 .59916 L .60309 .59409 L p .785 g
F P
0 g
s
.60309 .59409 m .59068 .55549 L .5346 .56352 L p .785 g
F P
0 g
s
.59068 .55549 m .60309 .59409 L .67422 .57808 L p .729 g
F P
0 g
s
.45447 .71118 m .44962 .75199 L .52962 .79035 L p .733 g
F P
0 g
s
.52937 .83622 m .52962 .79035 L .44962 .75199 L p .704 g
F P
0 g
s
.48177 .59536 m .47103 .63045 L .53206 .6424 L p .828 g
F P
0 g
s
.53206 .6424 m .53328 .59916 L .48177 .59536 L p .828 g
F P
0 g
s
.67422 .57808 m .64774 .54113 L .59068 .55549 L p .729 g
F P
0 g
s
.64774 .54113 m .67422 .57808 L .72962 .55371 L p .69 g
F P
0 g
s
.7648 .5941 m .72962 .55371 L .67422 .57808 L p .639 g
F P
0 g
s
.75389 .83951 m .75266 .88559 L .842 .84121 L p .329 g
F P
0 g
s
.842 .84121 m .84389 .79574 L .75389 .83951 L p .329 g
F P
0 g
s
.44962 .75199 m .44752 .78983 L .52937 .83622 L p .704 g
F P
0 g
s
.52944 .87566 m .52937 .83622 L .44752 .78983 L p .669 g
F P
0 g
s
.52937 .83622 m .52944 .87566 L .63959 .89795 L p .57 g
F P
0 g
s
.49334 .56679 m .48177 .59536 L .53328 .59916 L p .873 g
F P
0 g
s
.53328 .59916 m .5346 .56352 L .49334 .56679 L p .873 g
F P
0 g
s
.7648 .5941 m .79541 .64136 L .83094 .59759 L p .514 g
F P
0 g
s
.79541 .64136 m .81971 .69272 L .85904 .64096 L p .438 g
F P
0 g
s
.85904 .64096 m .83094 .59759 L .79541 .64136 L p .438 g
F P
0 g
s
.72962 .55371 m .7648 .5941 L .79554 .55915 L p .58 g
F P
0 g
s
.83094 .59759 m .79554 .55915 L .7648 .5941 L p .514 g
F P
0 g
s
.63584 .93232 m .63959 .89795 L .52944 .87566 L p .51 g
F P
0 g
s
.63959 .89795 m .63584 .93232 L .74468 .92235 L p .387 g
F P
0 g
s
.74468 .92235 m .75266 .88559 L .63959 .89795 L p .387 g
F P
0 g
s
.81971 .69272 m .83623 .74521 L .87806 .68666 L p .34 g
F P
0 g
s
.87806 .68666 m .85904 .64096 L .81971 .69272 L p .34 g
F P
0 g
s
.53593 .53792 m .5346 .56352 L .59068 .55549 L p .841 g
F P
0 g
s
.59068 .55549 m .57808 .52794 L .53593 .53792 L p .841 g
F P
0 g
s
.57808 .52794 m .59068 .55549 L .64774 .54113 L p .785 g
F P
0 g
s
.64774 .54113 m .62091 .51572 L .57808 .52794 L p .785 g
F P
0 g
s
.62091 .51572 m .64774 .54113 L .69187 .52266 L p .746 g
F P
0 g
s
.72962 .55371 m .69187 .52266 L .64774 .54113 L p .69 g
F P
0 g
s
.69187 .52266 m .72962 .55371 L .75497 .52793 L p .636 g
F P
0 g
s
.79554 .55915 m .75497 .52793 L .72962 .55371 L p .58 g
F P
0 g
s
.83623 .74521 m .84389 .79574 L .88668 .73193 L p .197 g
F P
0 g
s
.88668 .73193 m .87806 .68666 L .83623 .74521 L p .197 g
F P
0 g
s
.75266 .88559 m .74468 .92235 L .83037 .87858 L p .167 g
F P
0 g
s
.83037 .87858 m .842 .84121 L .75266 .88559 L p .167 g
F P
0 g
s
.44752 .78983 m .44833 .82235 L .52944 .87566 L p .669 g
F P
0 g
s
.52985 .90608 m .52944 .87566 L .44833 .82235 L p .614 g
F P
0 g
s
.52944 .87566 m .52985 .90608 L .63584 .93232 L p .51 g
F P
0 g
s
.43546 .63991 m .42569 .66884 L .45447 .71118 L p .88 g
F P
0 g
s
.45447 .71118 m .46175 .66985 L .43546 .63991 L p .88 g
F P
0 g
s
.44962 .75199 m .45447 .71118 L .42569 .66884 L p .849 g
F P
0 g
s
.44799 .61273 m .43546 .63991 L .46175 .66985 L p .906 g
F P
0 g
s
.46175 .66985 m .47103 .63045 L .45167 .61556 L p .906 g
F P
0 g
s
.46175 .66985 m .45167 .61556 L .44952 .61906 L .906 g
F
.4625 .589 m .44799 .61273 L .47103 .63045 L p .922 g
F P
0 g
s
.47103 .63045 m .48177 .59536 L .46873 .59105 L p .922 g
F P
0 g
s
.46873 .59105 m .4625 .589 L p .46434 .59794 L .922 g
F P
0 g
s
.47103 .63045 m .46873 .59105 L .46434 .59794 L .922 g
F
.47199 .60051 m .46264 .61376 L .44095 .63463 L p .015 g
F P
0 g
s
.44095 .63463 m .43846 .63703 L p .44161 .63359 L .015 g
F P
0 g
s
.44161 .63359 m .47199 .60051 L .44095 .63463 L .015 g
F
.43846 .63703 m .43546 .63991 L p .4391 .63599 L F P
0 g
s
.4391 .63599 m .47199 .60051 L .43846 .63703 L .015 g
F
.45167 .61556 m .44799 .61273 L p .44952 .61906 L .906 g
F P
0 g
s
.50505 .54669 m .49334 .56679 L .5346 .56352 L p .921 g
F P
0 g
s
.5346 .56352 m .53593 .53792 L .50505 .54669 L p .921 g
F P
0 g
s
.42569 .66884 m .41927 .69771 L .44962 .75199 L p .849 g
F P
0 g
s
.44752 .78983 m .44962 .75199 L .41927 .69771 L p .806 g
F P
0 g
s
.69187 .52266 m .65378 .50308 L .62091 .51572 L p .746 g
F P
0 g
s
.65378 .50308 m .69187 .52266 L .71164 .50586 L p .661 g
F P
0 g
s
.75497 .52793 m .71164 .50586 L .69187 .52266 L p .636 g
F P
0 g
s
.84389 .79574 m .842 .84121 L .88411 .77388 L p .039 g
F P
0 g
s
.88411 .77388 m .88668 .73193 L .84389 .79574 L p .039 g
F P
0 g
s
.62906 .95447 m .63584 .93232 L .52985 .90608 L p .402 g
F P
0 g
s
.63584 .93232 m .62906 .95447 L .73018 .94707 L p .228 g
F P
0 g
s
.73018 .94707 m .74468 .92235 L .63584 .93232 L p .228 g
F P
0 g
s
.5372 .52438 m .53593 .53792 L .57808 .52794 L p .9 g
F P
0 g
s
.57808 .52794 m .56608 .51365 L .5372 .52438 L p .9 g
F P
0 g
s
.56608 .51365 m .57808 .52794 L .62091 .51572 L p .844 g
F P
0 g
s
.62091 .51572 m .5954 .50392 L .56608 .51365 L p .844 g
F P
0 g
s
.5954 .50392 m .62091 .51572 L .65378 .50308 L p .771 g
F P
0 g
s
.41927 .69771 m .41665 .72473 L .44752 .78983 L p .806 g
F P
0 g
s
.44833 .82235 m .44752 .78983 L .41665 .72473 L p .734 g
F P
0 g
s
.4781 .57025 m .4625 .589 L .48177 .59536 L p .903 g
F P
0 g
s
.48177 .59536 m .48714 .5682 L .47928 .57831 L .903 g
F
.48284 .58934 m .47199 .60051 L .45552 .6089 L p .017 g
F P
0 g
s
.45552 .6089 m .44799 .61273 L p .45749 .60635 L .017 g
F P
0 g
s
.45749 .60635 m .48284 .58934 L .45552 .6089 L .017 g
F
.48177 .59536 m .49334 .56679 L .48714 .5682 L p .903 g
F P
0 g
s
.48714 .5682 m .4781 .57025 L p .47928 .57831 L .903 g
F P
0 g
s
.44833 .82235 m .45209 .84738 L .52985 .90608 L p .614 g
F P
0 g
s
.53058 .92519 m .52985 .90608 L .45209 .84738 L p .5 g
F P
0 g
s
.52985 .90608 m .53058 .92519 L .62906 .95447 L p .402 g
F P
0 g
s
.74468 .92235 m .73018 .94707 L .80938 .90511 L p .028 g
F P
0 g
s
.80938 .90511 m .83037 .87858 L .74468 .92235 L p .028 g
F P
0 g
s
.51863 .54284 m .53593 .53792 L p .52464 .53718 L .914 g
F P
0 g
s
.53593 .53792 m .5372 .52438 L .51613 .53663 L p .914 g
F P
0 g
s
.53832 .52432 m .52583 .53761 L p .53275 .52956 L F P
s
.5372 .52438 m .53832 .52432 L p .53275 .52956 L F P
s
.51613 .53663 m .50505 .54669 L .51863 .54284 L p .914 g
F P
0 g
s
.52464 .53718 m .51613 .53663 L .51863 .54284 L .914 g
F
.75497 .52793 m .79554 .55915 L .78082 .53136 L p .352 g
F P
0 g
s
.79554 .55915 m .83094 .59759 L .81468 .55857 L p .27 g
F P
0 g
s
.81468 .55857 m .78082 .53136 L .79554 .55915 L p .27 g
F P
0 g
s
.83094 .59759 m .85904 .64096 L .8415 .59105 L p .14 g
F P
0 g
s
.8415 .59105 m .81468 .55857 L .83094 .59759 L p .14 g
F P
0 g
s
.65378 .50308 m .61773 .49657 L .5954 .50392 L p .771 g
F P
0 g
s
.61773 .49657 m .65378 .50308 L .66815 .49444 L p .533 g
F P
0 g
s
.71164 .50586 m .66815 .49444 L .65378 .50308 L p .661 g
F P
0 g
s
.41665 .72473 m .41802 .74814 L .44833 .82235 L p .734 g
F P
0 g
s
.45209 .84738 m .44833 .82235 L .41802 .74814 L p .592 g
F P
0 g
s
.4938 .55777 m .4781 .57025 L .49334 .56679 L p .787 g
F P
0 g
s
.49334 .56679 m .50505 .54669 L .4938 .55777 L p .787 g
F P
0 g
s
.842 .84121 m .83037 .87858 L .87019 .8097 L p F P
s
.88411 .77388 m .842 .84121 L p .86431 .81628 L F P
s
.80938 .90511 m .84549 .83678 L p .83246 .8728 L .864 g
F P
0 g
s
.83037 .87858 m .82631 .88371 L p .83246 .8728 L .864 g
F P
0 g
s
.82631 .88371 m .80938 .90511 L p .83246 .8728 L .864 g
F P
0 g
s
.87019 .8097 m .87503 .79725 L p .86431 .81628 L F P
s
.87503 .79725 m .88411 .77388 L p .86431 .81628 L F P
s
.71164 .50586 m .75497 .52793 L .74206 .51107 L p .383 g
F P
0 g
s
.78082 .53136 m .74206 .51107 L .75497 .52793 L p .352 g
F P
0 g
s
.85904 .64096 m .87806 .68666 L .85947 .62681 L p .049 g
F P
0 g
s
.85947 .62681 m .8415 .59105 L .85904 .64096 L p .049 g
F P
0 g
s
.61956 .96237 m .62906 .95447 L .53058 .92519 L p .169 g
F P
0 g
s
.62906 .95447 m .61956 .96237 L .70983 .95752 L p .077 g
F P
0 g
s
.70983 .95752 m .73018 .94707 L .62906 .95447 L p .077 g
F P
0 g
s
.66815 .49444 m .71164 .50586 L .70081 .49896 L p .046 g
F P
0 g
s
.74206 .51107 m .70081 .49896 L .71164 .50586 L p .383 g
F P
0 g
s
.55529 .52584 m .54719 .53027 L p .56446 .51476 L .009 g
F P
0 g
s
.5372 .52438 m .56608 .51365 L p .54435 .522 L .824 g
F P
0 g
s
.53832 .52432 m .53785 .52435 L p .54435 .522 L .824 g
F P
0 g
s
.53785 .52435 m .5372 .52438 L p .54435 .522 L .824 g
F P
0 g
s
.56608 .51365 m .55552 .51419 L .53832 .52432 L p .824 g
F P
0 g
s
.56608 .51365 m .5954 .50392 L p .5598 .51309 L .768 g
F P
0 g
s
.55552 .51419 m .55708 .51411 L p .5598 .51309 L .768 g
F P
0 g
s
.55708 .51411 m .56608 .51365 L p .5598 .51309 L .768 g
F P
0 g
s
.5954 .50392 m .57296 .50713 L .55552 .51419 L p .768 g
F P
0 g
s
.57102 .50887 m .56642 .51405 L .56446 .51476 L .009 g
F
.57296 .50713 m .57148 .5087 L p .57102 .50887 L F P
0 g
s
.57148 .5087 m .56642 .51405 L p .57102 .50887 L .009 g
F P
0 g
s
.56642 .51405 m .55529 .52584 L p .56446 .51476 L .009 g
F P
0 g
s
.57296 .50713 m .5954 .50392 L .61773 .49657 L p F P
s
.87806 .68666 m .88668 .73193 L .86731 .66358 L p .528 g
F P
0 g
s
.86731 .66358 m .85947 .62681 L .87806 .68666 L p .528 g
F P
0 g
s
.45209 .84738 m .45863 .86308 L .53058 .92519 L p .5 g
F P
0 g
s
.53159 .93126 m .53058 .92519 L .45863 .86308 L p .255 g
F P
0 g
s
.53058 .92519 m .53159 .93126 L .61956 .96237 L p .169 g
F P
0 g
s
.41802 .74814 m .42339 .76638 L .45209 .84738 L p .592 g
F P
0 g
s
.45863 .86308 m .45209 .84738 L .42339 .76638 L p .033 g
F P
0 g
s
.50858 .5525 m .4938 .55777 L .50505 .54669 L p F P
s
.50505 .54669 m .51613 .53663 L .50858 .5525 L p F P
s
.43546 .63991 m .44799 .61273 L .47199 .60051 L p .015 g
F P
0 g
s
.42569 .66884 m .43546 .63991 L .46264 .61376 L p .017 g
F P
0 g
s
.73018 .94707 m .70983 .95752 L .78007 .91853 L p .68 g
F P
0 g
s
.78007 .91853 m .80938 .90511 L .73018 .94707 L p .68 g
F P
0 g
s
.52583 .53761 m .51613 .53663 L .5372 .52438 L p F P
s
.46264 .61376 m .45539 .62822 L .42569 .66884 L p .017 g
F P
0 g
s
.41927 .69771 m .42569 .66884 L .45539 .62822 L p .023 g
F P
0 g
s
.61773 .49657 m .58616 .50405 L .57296 .50713 L p F P
s
.66815 .49444 m .62725 .49462 L .61773 .49657 L p .533 g
F P
0 g
s
.58616 .50405 m .61773 .49657 L .62725 .49462 L p .065 g
F P
0 g
s
.44799 .61273 m .4625 .589 L .48284 .58934 L p .017 g
F P
0 g
s
.84549 .83678 m .87019 .8097 L .83037 .87858 L p .864 g
F P
0 g
s
.62725 .49462 m .66815 .49444 L .65963 .49584 L p .088 g
F P
0 g
s
.70081 .49896 m .65963 .49584 L .66815 .49444 L p .046 g
F P
0 g
s
.45539 .62822 m .45072 .64296 L .41927 .69771 L p .023 g
F P
0 g
s
.41665 .72473 m .41927 .69771 L .45072 .64296 L p .032 g
F P
0 g
s
.88668 .73193 m .88411 .77388 L .86427 .69898 L p .776 g
F P
0 g
s
.86427 .69898 m .86731 .66358 L .88668 .73193 L p .776 g
F P
0 g
s
.49449 .581 m .48284 .58934 L .4625 .589 L p .021 g
F P
0 g
s
.4625 .589 m .4781 .57025 L .49449 .581 L p .021 g
F P
0 g
s
.45072 .64296 m .44896 .657 L .41665 .72473 L p .032 g
F P
0 g
s
.41802 .74814 m .41665 .72473 L .44896 .657 L p .042 g
F P
0 g
s
.60785 .95474 m .61956 .96237 L .53159 .93126 L p .364 g
F P
0 g
s
.61956 .96237 m .60785 .95474 L .68477 .95227 L p .629 g
F P
0 g
s
.68477 .95227 m .70983 .95752 L .61956 .96237 L p .629 g
F P
0 g
s
.50615 .57604 m .49449 .581 L .4781 .57025 L p .053 g
F P
0 g
s
.4781 .57025 m .4938 .55777 L .50615 .57604 L p .053 g
F P
0 g
s
.42339 .76638 m .43247 .77812 L .45863 .86308 L p .033 g
F P
0 g
s
.46763 .86806 m .45863 .86308 L .43247 .77812 L p .065 g
F P
0 g
s
.45863 .86308 m .46763 .86806 L .53159 .93126 L p .255 g
F P
0 g
s
.52143 .55495 m .50858 .5525 L .51613 .53663 L p .006 g
F P
0 g
s
.51613 .53663 m .52583 .53761 L .52143 .55495 L p .006 g
F P
0 g
s
.62725 .49462 m .59164 .50671 L .58616 .50405 L p .065 g
F P
0 g
s
.59164 .50671 m .62725 .49462 L .62113 .502 L p .129 g
F P
0 g
s
.65963 .49584 m .62113 .502 L .62725 .49462 L p .088 g
F P
0 g
s
.54719 .53027 m .55552 .51419 L .57296 .50713 L p .009 g
F P
0 g
s
.55529 .52584 m .57296 .50713 L .58616 .50405 L p .086 g
F P
0 g
s
.53919 .53838 m .53832 .52432 L .55552 .51419 L p F P
s
.55552 .51419 m .54719 .53027 L .53919 .53838 L p F P
s
.70081 .49896 m .74206 .51107 L .69216 .51426 L p .153 g
F P
0 g
s
.74206 .51107 m .78082 .53136 L .72166 .52433 L p .207 g
F P
0 g
s
.72166 .52433 m .69216 .51426 L .74206 .51107 L p .207 g
F P
0 g
s
.78082 .53136 m .81468 .55857 L .74739 .54006 L p .315 g
F P
0 g
s
.74739 .54006 m .72166 .52433 L .78082 .53136 L p .315 g
F P
0 g
s
.53283 .92325 m .53159 .93126 L .46763 .86806 L p .253 g
F P
0 g
s
.53159 .93126 m .53283 .92325 L .60785 .95474 L p .364 g
F P
0 g
s
.44896 .657 m .45023 .66941 L .41802 .74814 L p .042 g
F P
0 g
s
.42339 .76638 m .41802 .74814 L .45023 .66941 L p .051 g
F P
0 g
s
.88411 .77388 m .87019 .8097 L .85031 .73057 L p .871 g
F P
0 g
s
.85031 .73057 m .86427 .69898 L .88411 .77388 L p .871 g
F P
0 g
s
.65963 .49584 m .70081 .49896 L .66081 .51048 L p .139 g
F P
0 g
s
.69216 .51426 m .66081 .51048 L .70081 .49896 L p .153 g
F P
0 g
s
.81468 .55857 m .8415 .59105 L .76764 .56049 L p .449 g
F P
0 g
s
.76764 .56049 m .74739 .54006 L .81468 .55857 L p .449 g
F P
0 g
s
.58616 .50405 m .56139 .52559 L .55529 .52584 L p .086 g
F P
0 g
s
.56139 .52559 m .58616 .50405 L .59164 .50671 L p .168 g
F P
0 g
s
.53342 .54999 m .52583 .53761 L .53832 .52432 L p .001 g
F P
0 g
s
.53832 .52432 m .53919 .53838 L .53342 .54999 L p .001 g
F P
0 g
s
.80938 .90511 m .78007 .91853 L .81137 .85293 L p .927 g
F P
0 g
s
.81137 .85293 m .84549 .83678 L .80938 .90511 L p .927 g
F P
0 g
s
.70983 .95752 m .68477 .95227 L .74417 .91733 L p .856 g
F P
0 g
s
.74417 .91733 m .78007 .91853 L .70983 .95752 L p .856 g
F P
0 g
s
.51707 .57484 m .50615 .57604 L .4938 .55777 L p .088 g
F P
0 g
s
.4938 .55777 m .50858 .5525 L .51707 .57484 L p .088 g
F P
0 g
s
.62113 .502 m .65963 .49584 L .62961 .51322 L p .157 g
F P
0 g
s
.66081 .51048 m .62961 .51322 L .65963 .49584 L p .139 g
F P
0 g
s
.8415 .59105 m .85947 .62681 L .781 .58433 L p .572 g
F P
0 g
s
.781 .58433 m .76764 .56049 L .8415 .59105 L p .572 g
F P
0 g
s
.45023 .66941 m .45449 .67934 L .42339 .76638 L p .051 g
F P
0 g
s
.43247 .77812 m .42339 .76638 L .45449 .67934 L p .126 g
F P
0 g
s
.59164 .50671 m .56386 .53028 L .56139 .52559 L p .168 g
F P
0 g
s
.56386 .53028 m .59164 .50671 L .58783 .5172 L p .266 g
F P
0 g
s
.62113 .502 m .58783 .5172 L .59164 .50671 L p .129 g
F P
0 g
s
.43247 .77812 m .44474 .78242 L .46763 .86806 L p .065 g
F P
0 g
s
.47853 .8616 m .46763 .86806 L .44474 .78242 L p .229 g
F P
0 g
s
.46763 .86806 m .47853 .8616 L .53283 .92325 L p .253 g
F P
0 g
s
.53141 .56514 m .52143 .55495 L .52583 .53761 L p .068 g
F P
0 g
s
.52583 .53761 m .53342 .54999 L .53141 .56514 L p .068 g
F P
0 g
s
.58783 .5172 m .62113 .502 L .60057 .52232 L p .226 g
F P
0 g
s
.62961 .51322 m .60057 .52232 L .62113 .502 L p .157 g
F P
0 g
s
.5265 .57751 m .51707 .57484 L .50858 .5525 L p .135 g
F P
0 g
s
.50858 .5525 m .52143 .55495 L .5265 .57751 L p .135 g
F P
0 g
s
.85947 .62681 m .86731 .66358 L .78649 .61002 L p .659 g
F P
0 g
s
.78649 .61002 m .781 .58433 L .85947 .62681 L p .659 g
F P
0 g
s
.87019 .8097 m .84549 .83678 L .82612 .7561 L p .865 g
F P
0 g
s
.82612 .7561 m .85031 .73057 L .87019 .8097 L p .865 g
F P
0 g
s
.5947 .9314 m .60785 .95474 L .53283 .92325 L p .593 g
F P
0 g
s
.60785 .95474 m .5947 .9314 L .65663 .93098 L p .735 g
F P
0 g
s
.65663 .93098 m .68477 .95227 L .60785 .95474 L p .735 g
F P
0 g
s
.54182 .56147 m .54719 .53027 L .55529 .52584 L p .117 g
F P
0 g
s
.55529 .52584 m .54391 .55945 L .54182 .56147 L p .117 g
F P
0 g
s
.54391 .55945 m .55529 .52584 L .56139 .52559 L p .279 g
F P
0 g
s
.53976 .56615 m .53919 .53838 L .54719 .53027 L p .051 g
F P
0 g
s
.54719 .53027 m .54182 .56147 L .53976 .56615 L p .051 g
F P
0 g
s
.53422 .90113 m .53283 .92325 L .47853 .8616 L p .451 g
F P
0 g
s
.53283 .92325 m .53422 .90113 L .5947 .9314 L p .593 g
F P
0 g
s
.45449 .67934 m .46147 .68611 L .43247 .77812 L p .126 g
F P
0 g
s
.44474 .78242 m .43247 .77812 L .46147 .68611 L p .213 g
F P
0 g
s
.56139 .52559 m .54548 .56028 L .54391 .55945 L p .279 g
F P
0 g
s
.54548 .56028 m .56139 .52559 L .56386 .53028 L p .371 g
F P
0 g
s
.78007 .91853 m .74417 .91733 L .76997 .85663 L p .857 g
F P
0 g
s
.76997 .85663 m .81137 .85293 L .78007 .91853 L p .857 g
F P
0 g
s
.46264 .61376 m .47199 .60051 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.45539 .62822 m .46264 .61376 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53827 .57326 m .53342 .54999 L .53919 .53838 L p .054 g
F P
0 g
s
.53919 .53838 m .53976 .56615 L .53827 .57326 L p .054 g
F P
0 g
s
.47199 .60051 m .48284 .58934 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.45072 .64296 m .45539 .62822 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.58783 .5172 m .56203 .54062 L .56386 .53028 L p .266 g
F P
0 g
s
.56203 .54062 m .58783 .5172 L .57558 .53722 L p .309 g
F P
0 g
s
.60057 .52232 m .57558 .53722 L .58783 .5172 L p .226 g
F P
0 g
s
.48284 .58934 m .49449 .581 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.86731 .66358 m .86427 .69898 L .78361 .63586 L p .708 g
F P
0 g
s
.78361 .63586 m .78649 .61002 L .86731 .66358 L p .708 g
F P
0 g
s
.68477 .95227 m .65663 .93098 L .70408 .90102 L p .797 g
F P
0 g
s
.70408 .90102 m .74417 .91733 L .68477 .95227 L p .797 g
F P
0 g
s
.44896 .657 m .45072 .64296 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53378 .58391 m .5265 .57751 L .52143 .55495 L p .194 g
F P
0 g
s
.52143 .55495 m .53141 .56514 L .53378 .58391 L p .194 g
F P
0 g
s
.62961 .51322 m .66081 .51048 L .60168 .54615 L p .262 g
F P
0 g
s
.66081 .51048 m .69216 .51426 L .61775 .54556 L p .292 g
F P
0 g
s
.61775 .54556 m .60168 .54615 L .66081 .51048 L p .292 g
F P
0 g
s
.56386 .53028 m .5461 .56408 L .54548 .56028 L p .371 g
F P
0 g
s
.5461 .56408 m .56386 .53028 L .56203 .54062 L p .402 g
F P
0 g
s
.69216 .51426 m .72166 .52433 L .63283 .54847 L p .343 g
F P
0 g
s
.63283 .54847 m .61775 .54556 L .69216 .51426 L p .343 g
F P
0 g
s
.49449 .581 m .50615 .57604 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.60057 .52232 m .62961 .51322 L .58568 .55018 L p .259 g
F P
0 g
s
.60168 .54615 m .58568 .55018 L .62961 .51322 L p .262 g
F P
0 g
s
.45023 .66941 m .44896 .657 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.41829 .45125 m .37549 .43876 L .41892 .50645 L p .623 g
F P
0 g
s
.41892 .50645 m .4502 .51023 L .41829 .45125 L p .623 g
F P
0 g
s
.38746 .50919 m .41892 .50645 L .37549 .43876 L p .652 g
F P
0 g
s
.4502 .51023 m .41892 .50645 L .47864 .56387 L p .559 g
F P
0 g
s
.41892 .50645 m .38746 .50919 L .46282 .56787 L p .581 g
F P
0 g
s
.46282 .56787 m .47864 .56387 L .41892 .50645 L p .581 g
F P
0 g
s
.44474 .78242 m .45942 .7788 L .47853 .8616 L p .229 g
F P
0 g
s
.49063 .84375 m .47853 .8616 L .45942 .7788 L p .368 g
F P
0 g
s
.47853 .8616 m .49063 .84375 L .53422 .90113 L p .451 g
F P
0 g
s
.45045 .42683 m .40694 .39368 L .41829 .45125 L p .633 g
F P
0 g
s
.41829 .45125 m .45787 .47199 L .45045 .42683 L p .633 g
F P
0 g
s
.37549 .43876 m .41829 .45125 L .40694 .39368 L p .672 g
F P
0 g
s
.45787 .47199 m .41829 .45125 L .4502 .51023 L p .59 g
F P
0 g
s
.53777 .58254 m .53141 .56514 L .53342 .54999 L p .101 g
F P
0 g
s
.53342 .54999 m .53827 .57326 L .53777 .58254 L p .101 g
F P
0 g
s
.48751 .46716 m .45045 .42683 L .45787 .47199 L p .593 g
F P
0 g
s
.45787 .47199 m .49176 .49968 L .48751 .46716 L p .593 g
F P
0 g
s
.49176 .49968 m .45787 .47199 L .47929 .5203 L p .555 g
F P
0 g
s
.4502 .51023 m .47929 .5203 L .45787 .47199 L p .59 g
F P
0 g
s
.47929 .5203 m .4502 .51023 L .49446 .56331 L p .533 g
F P
0 g
s
.47864 .56387 m .49446 .56331 L .4502 .51023 L p .559 g
F P
0 g
s
.72166 .52433 m .74739 .54006 L .64591 .55469 L p .405 g
F P
0 g
s
.64591 .55469 m .63283 .54847 L .72166 .52433 L p .405 g
F P
0 g
s
.37549 .43876 m .33211 .43533 L .38746 .50919 L p .652 g
F P
0 g
s
.35783 .51829 m .38746 .50919 L .33211 .43533 L p .677 g
F P
0 g
s
.38746 .50919 m .35783 .51829 L .44801 .57503 L p .598 g
F P
0 g
s
.44801 .57503 m .46282 .56787 L .38746 .50919 L p .598 g
F P
0 g
s
.84549 .83678 m .81137 .85293 L .79319 .77359 L p .826 g
F P
0 g
s
.79319 .77359 m .82612 .7561 L .84549 .83678 L p .826 g
F P
0 g
s
.57558 .53722 m .60057 .52232 L .57081 .55738 L p .28 g
F P
0 g
s
.58568 .55018 m .57081 .55738 L .60057 .52232 L p .259 g
F P
0 g
s
.49269 .44272 m .45913 .39139 L .45045 .42683 L p .617 g
F P
0 g
s
.45045 .42683 m .48751 .46716 L .49269 .44272 L p .617 g
F P
0 g
s
.40694 .39368 m .45045 .42683 L .45913 .39139 L p .661 g
F P
0 g
s
.46147 .68611 m .47073 .68921 L .44474 .78242 L p .213 g
F P
0 g
s
.45942 .7788 m .44474 .78242 L .47073 .68921 L p .283 g
F P
0 g
s
.40694 .39368 m .35953 .36977 L .37549 .43876 L p .672 g
F P
0 g
s
.33211 .43533 m .37549 .43876 L .35953 .36977 L p .711 g
F P
0 g
s
.51829 .49771 m .49269 .44272 L .48751 .46716 L p .575 g
F P
0 g
s
.48751 .46716 m .51588 .51228 L .51829 .49771 L p .575 g
F P
0 g
s
.51588 .51228 m .48751 .46716 L .49176 .49968 L p .554 g
F P
0 g
s
.50615 .57604 m .51707 .57484 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.47929 .5203 m .50431 .53605 L .49176 .49968 L p .555 g
F P
0 g
s
.50431 .53605 m .47929 .5203 L .5092 .56623 L p .503 g
F P
0 g
s
.49446 .56331 m .5092 .56623 L .47929 .5203 L p .533 g
F P
0 g
s
.49176 .49968 m .51782 .53264 L .51588 .51228 L p .554 g
F P
0 g
s
.51782 .53264 m .49176 .49968 L .50431 .53605 L p .519 g
F P
0 g
s
.45449 .67934 m .45023 .66941 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.33211 .43533 m .29089 .44129 L .35783 .51829 L p .677 g
F P
0 g
s
.33198 .53321 m .35783 .51829 L .29089 .44129 L p .697 g
F P
0 g
s
.35783 .51829 m .33198 .53321 L .43522 .58488 L p .609 g
F P
0 g
s
.43522 .58488 m .44801 .57503 L .35783 .51829 L p .609 g
F P
0 g
s
.52441 .49086 m .506 .43017 L .49269 .44272 L p .579 g
F P
0 g
s
.49269 .44272 m .51829 .49771 L .52441 .49086 L p .579 g
F P
0 g
s
.45913 .39139 m .49269 .44272 L .506 .43017 L p .623 g
F P
0 g
s
.56203 .54062 m .54561 .57088 L .5461 .56408 L p .402 g
F P
0 g
s
.54561 .57088 m .56203 .54062 L .55632 .55703 L p .401 g
F P
0 g
s
.57558 .53722 m .55632 .55703 L .56203 .54062 L p .309 g
F P
0 g
s
.74739 .54006 m .76764 .56049 L .6561 .56384 L p .467 g
F P
0 g
s
.6561 .56384 m .64591 .55469 L .74739 .54006 L p .467 g
F P
0 g
s
.45913 .39139 m .41947 .34668 L .40694 .39368 L p .661 g
F P
0 g
s
.35953 .36977 m .40694 .39368 L .41947 .34668 L p .707 g
F P
0 g
s
.55632 .55703 m .57558 .53722 L .55805 .56728 L p .323 g
F P
0 g
s
.57081 .55738 m .55805 .56728 L .57558 .53722 L p .28 g
F P
0 g
s
.506 .43017 m .48177 .37191 L .45913 .39139 L p .623 g
F P
0 g
s
.41947 .34668 m .45913 .39139 L .48177 .37191 L p .669 g
F P
0 g
s
.86427 .69898 m .85031 .73057 L .77242 .66006 L p .728 g
F P
0 g
s
.77242 .66006 m .78361 .63586 L .86427 .69898 L p .728 g
F P
0 g
s
.53262 .49292 m .52391 .43203 L .506 .43017 L p .555 g
F P
0 g
s
.506 .43017 m .52441 .49086 L .53262 .49292 L p .555 g
F P
0 g
s
.48177 .37191 m .506 .43017 L .52391 .43203 L p .602 g
F P
0 g
s
.53598 .55062 m .52441 .49086 L .51829 .49771 L p .537 g
F P
0 g
s
.51829 .49771 m .53441 .55324 L .53598 .55062 L p .537 g
F P
0 g
s
.53441 .55324 m .51829 .49771 L .51588 .51228 L p .543 g
F P
0 g
s
.53995 .60606 m .47864 .56387 L .46282 .56787 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .46282 .56787 L .44801 .57503 L closepath p .479 g
F P
0 g
s
.51588 .51228 m .5338 .55954 L .53441 .55324 L p .543 g
F P
0 g
s
.5338 .55954 m .51588 .51228 L .51782 .53264 L p .525 g
F P
0 g
s
.50431 .53605 m .52358 .55649 L .51782 .53264 L p .519 g
F P
0 g
s
.52358 .55649 m .50431 .53605 L .5219 .57246 L p .473 g
F P
0 g
s
.5092 .56623 m .5219 .57246 L .50431 .53605 L p .503 g
F P
0 g
s
.53995 .60606 m .44801 .57503 L .43522 .58488 L closepath p .479 g
F P
0 g
s
.51707 .57484 m .5265 .57751 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .49446 .56331 L .47864 .56387 L closepath p .479 g
F P
0 g
s
.53808 .55204 m .53262 .49292 L .52441 .49086 L p .489 g
F P
0 g
s
.52441 .49086 m .53598 .55062 L .53808 .55204 L p .489 g
F P
0 g
s
.35953 .36977 m .31104 .35669 L .33211 .43533 L p .711 g
F P
0 g
s
.29089 .44129 m .33211 .43533 L .31104 .35669 L p .749 g
F P
0 g
s
.53141 .56514 m .53714 .58856 L .53633 .5893 L .226 g
F
.53838 .59364 m .53773 .59226 L p .53714 .58856 L F P
0 g
s
.53773 .59226 m .53633 .5893 L p .53714 .58856 L .226 g
F P
0 g
s
.53141 .56514 m .53777 .58254 L .53838 .59364 L p .226 g
F P
0 g
s
.53378 .58391 m .53838 .59364 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53633 .5893 m .53378 .58391 L .53288 .57682 L p .226 g
F P
0 g
s
.53288 .57682 m .53141 .56514 L p .53633 .5893 L .226 g
F P
0 g
s
.5265 .57751 m .53378 .58391 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53167 .5816 m .53784 .59305 L .53577 .58035 L p .451 g
F P
0 g
s
.53577 .58035 m .53784 .59305 L .53836 .59627 L p .498 g
F P
0 g
s
.53995 .60606 m .53784 .59305 L .53167 .5816 L closepath p .479 g
F P
0 g
s
.53836 .59627 m .53995 .60606 L .53852 .59724 L p .498 g
F P
0 g
s
.53852 .59724 m .53577 .58035 L p .53836 .59627 L .498 g
F P
0 g
s
.53429 .56886 m .53577 .58035 L .53852 .59724 L p .047 g
F P
0 g
s
.53852 .59724 m .53995 .60606 L .53873 .59799 L p .047 g
F P
0 g
s
.53873 .59799 m .53429 .56886 L p .53852 .59724 L .047 g
F P
0 g
s
.46147 .68611 m .45449 .67934 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.42527 .59678 m .43522 .58488 L .33198 .53321 L p .613 g
F P
0 g
s
.53995 .60606 m .43522 .58488 L .42527 .59678 L closepath p .479 g
F P
0 g
s
.29089 .44129 m .25451 .45641 L .33198 .53321 L p .697 g
F P
0 g
s
.31162 .55302 m .33198 .53321 L .25451 .45641 L p .71 g
F P
0 g
s
.33198 .53321 m .31162 .55302 L .42527 .59678 L p .613 g
F P
0 g
s
.51782 .53264 m .53429 .56886 L .5338 .55954 L p .525 g
F P
0 g
s
.53429 .56886 m .51782 .53264 L .52358 .55649 L p .494 g
F P
0 g
s
.58104 .89341 m .5947 .9314 L .53422 .90113 L p .628 g
F P
0 g
s
.5947 .9314 m .58104 .89341 L .62743 .89458 L p .699 g
F P
0 g
s
.62743 .89458 m .65663 .93098 L .5947 .9314 L p .699 g
F P
0 g
s
.53565 .86599 m .53422 .90113 L .49063 .84375 L p .532 g
F P
0 g
s
.53422 .90113 m .53565 .86599 L .58104 .89341 L p .628 g
F P
0 g
s
.54015 .55747 m .54072 .50402 L .53262 .49292 L p .398 g
F P
0 g
s
.53262 .49292 m .53808 .55204 L .54015 .55747 L p .398 g
F P
0 g
s
.52391 .43203 m .53262 .49292 L .54072 .50402 L p .5 g
F P
0 g
s
.53995 .60606 m .5092 .56623 L .49446 .56331 L closepath p .479 g
F P
0 g
s
.54072 .50402 m .54164 .44877 L .52391 .43203 L p .5 g
F P
0 g
s
.51244 .37271 m .52391 .43203 L .54164 .44877 L p .549 g
F P
0 g
s
.52391 .43203 m .51244 .37271 L .48177 .37191 L p .602 g
F P
0 g
s
.54391 .55945 m .53995 .60606 L .54182 .56147 L closepath p .403 g
F P
0 g
s
.54548 .56028 m .53995 .60606 L .54391 .55945 L closepath p .312 g
F P
0 g
s
.54182 .56147 m .53995 .60606 L .53976 .56615 L closepath p .47 g
F P
0 g
s
.76764 .56049 m .781 .58433 L .66268 .57532 L p .522 g
F P
0 g
s
.66268 .57532 m .6561 .56384 L .76764 .56049 L p .522 g
F P
0 g
s
.41886 .60995 m .42527 .59678 L .31162 .55302 L p .609 g
F P
0 g
s
.53995 .60606 m .42527 .59678 L .41886 .60995 L closepath p .479 g
F P
0 g
s
.5461 .56408 m .53995 .60606 L .54548 .56028 L closepath p .17 g
F P
0 g
s
.54164 .56647 m .54656 .52315 L .54072 .50402 L p .313 g
F P
0 g
s
.54072 .50402 m .54015 .55747 L .54164 .56647 L p .313 g
F P
0 g
s
.54164 .44877 m .54072 .50402 L .54656 .52315 L p .427 g
F P
0 g
s
.74417 .91733 m .70408 .90102 L .72413 .84727 L p .781 g
F P
0 g
s
.72413 .84727 m .76997 .85663 L .74417 .91733 L p .781 g
F P
0 g
s
.54656 .52315 m .5544 .47867 L .54164 .44877 L p .427 g
F P
0 g
s
.54284 .39483 m .54164 .44877 L .5544 .47867 L p .473 g
F P
0 g
s
.54164 .44877 m .54284 .39483 L .51244 .37271 L p .549 g
F P
0 g
s
.45303 .31937 m .48177 .37191 L .51244 .37271 L p .645 g
F P
0 g
s
.48177 .37191 m .45303 .31937 L .41947 .34668 L p .669 g
F P
0 g
s
.53995 .60606 m .5219 .57246 L .5092 .56623 L closepath p .479 g
F P
0 g
s
.53976 .56615 m .53995 .60606 L .53827 .57326 L closepath p .526 g
F P
0 g
s
.55632 .55703 m .54414 .58048 L .54561 .57088 L p .401 g
F P
0 g
s
.54414 .58048 m .55632 .55703 L .54824 .57923 L p .384 g
F P
0 g
s
.55805 .56728 m .54824 .57923 L .55632 .55703 L p .323 g
F P
0 g
s
.47073 .68921 m .48166 .68839 L .45942 .7788 L p .283 g
F P
0 g
s
.47554 .76734 m .45942 .7788 L .48166 .68839 L p .336 g
F P
0 g
s
.45942 .7788 m .47554 .76734 L .49063 .84375 L p .368 g
F P
0 g
s
.52358 .55649 m .53577 .58035 L .53429 .56886 L p .494 g
F P
0 g
s
.53577 .58035 m .52358 .55649 L .53167 .5816 L p .451 g
F P
0 g
s
.5219 .57246 m .53167 .5816 L .52358 .55649 L p .473 g
F P
0 g
s
.41947 .34668 m .37595 .31132 L .35953 .36977 L p .707 g
F P
0 g
s
.31104 .35669 m .35953 .36977 L .37595 .31132 L p .758 g
F P
0 g
s
.54561 .57088 m .53995 .60606 L .5461 .56408 L closepath p .031 g
F P
0 g
s
.47073 .68921 m .46147 .68611 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.54215 .57828 m .54855 .54833 L .54656 .52315 L p .28 g
F P
0 g
s
.54656 .52315 m .54164 .56647 L .54215 .57828 L p .28 g
F P
0 g
s
.5544 .47867 m .54656 .52315 L .54855 .54833 L p .366 g
F P
0 g
s
.54855 .54833 m .55874 .51807 L .5544 .47867 L p .366 g
F P
0 g
s
.56469 .43563 m .5544 .47867 L .55874 .51807 L p .401 g
F P
0 g
s
.5544 .47867 m .56469 .43563 L .54284 .39483 L p .473 g
F P
0 g
s
.31162 .55302 m .29818 .57649 L .41886 .60995 L p .609 g
F P
0 g
s
.41644 .62351 m .41886 .60995 L .29818 .57649 L p .596 g
F P
0 g
s
.53995 .60606 m .41886 .60995 L .41644 .62351 L closepath p .479 g
F P
0 g
s
.37595 .31132 m .41947 .34668 L .45303 .31937 L p .719 g
F P
0 g
s
.53827 .57326 m .53995 .60606 L .53777 .58254 L closepath p .577 g
F P
0 g
s
.53598 .55062 m .53995 .60606 L .53808 .55204 L closepath p .484 g
F P
0 g
s
.53777 .58254 m .53995 .60606 L .53838 .59364 L closepath p .628 g
F P
0 g
s
.53441 .55324 m .53995 .60606 L .53598 .55062 L closepath p .42 g
F P
0 g
s
.50307 .81547 m .49063 .84375 L .47554 .76734 L p .442 g
F P
0 g
s
.49063 .84375 m .50307 .81547 L .53565 .86599 L p .532 g
F P
0 g
s
.5338 .55954 m .53995 .60606 L .53441 .55324 L closepath p .331 g
F P
0 g
s
.25451 .45641 m .22546 .47988 L .31162 .55302 L p .71 g
F P
0 g
s
.29818 .57649 m .31162 .55302 L .22546 .47988 L p .713 g
F P
0 g
s
.53995 .60606 m .53167 .5816 L .5219 .57246 L closepath p .479 g
F P
0 g
s
.53808 .55204 m .53995 .60606 L .54015 .55747 L closepath p .536 g
F P
0 g
s
.53429 .56886 m .53995 .60606 L .5338 .55954 L closepath p .186 g
F P
0 g
s
.65663 .93098 m .62743 .89458 L .6627 .87031 L p .726 g
F P
0 g
s
.6627 .87031 m .70408 .90102 L .65663 .93098 L p .726 g
F P
0 g
s
.31104 .35669 m .26449 .35552 L .29089 .44129 L p .749 g
F P
0 g
s
.25451 .45641 m .29089 .44129 L .26449 .35552 L p .786 g
F P
0 g
s
.49881 .3183 m .51244 .37271 L .54284 .39483 L p .581 g
F P
0 g
s
.51244 .37271 m .49881 .3183 L .45303 .31937 L p .645 g
F P
0 g
s
.54561 .57088 m .54414 .58048 L .54139 .59729 L p F P
s
.54118 .59842 m .54561 .57088 L p .54139 .59729 L F P
s
.54414 .58048 m .54207 .59245 L .54154 .59582 L p .801 g
F P
0 g
s
.54139 .59729 m .53995 .60606 L .54118 .59842 L p F P
s
.54154 .59582 m .53995 .60606 L .54139 .59729 L p .801 g
F P
0 g
s
.54139 .59729 m .54414 .58048 L p .54154 .59582 L .801 g
F P
0 g
s
.54824 .57923 m .54207 .59245 L .54414 .58048 L p .384 g
F P
0 g
s
.54855 .54833 m .54278 .58415 L .54359 .58521 L .292 g
F
.54153 .59186 m .54219 .58975 L p .54278 .58415 L F P
0 g
s
.54219 .58975 m .54359 .58521 L p .54278 .58415 L .292 g
F P
0 g
s
.54359 .58521 m .54615 .57691 L .54705 .56614 L p .292 g
F P
0 g
s
.54705 .56614 m .54855 .54833 L p .54359 .58521 L .292 g
F P
0 g
s
.53995 .60606 m .57081 .55738 L .58568 .55018 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .58568 .55018 L .60168 .54615 L closepath p .479 g
F P
0 g
s
.54015 .55747 m .53995 .60606 L .54164 .56647 L closepath p .584 g
F P
0 g
s
.54615 .57691 m .55349 .56219 L .55874 .51807 L p .333 g
F P
0 g
s
.55874 .51807 m .54855 .54833 L .54615 .57691 L p .333 g
F P
0 g
s
.57208 .48937 m .55874 .51807 L .55349 .56219 L p .351 g
F P
0 g
s
.55874 .51807 m .57208 .48937 L .56469 .43563 L p .401 g
F P
0 g
s
.53995 .60606 m .55805 .56728 L .57081 .55738 L closepath p .479 g
F P
0 g
s
.81137 .85293 m .76997 .85663 L .7537 .78164 L p .778 g
F P
0 g
s
.7537 .78164 m .79319 .77359 L .81137 .85293 L p .778 g
F P
0 g
s
.53995 .60606 m .60168 .54615 L .61775 .54556 L closepath p .479 g
F P
0 g
s
.54855 .54833 m .54215 .57828 L .54153 .59186 L p .292 g
F P
0 g
s
.781 .58433 m .78649 .61002 L .66517 .58837 L p .565 g
F P
0 g
s
.66517 .58837 m .66268 .57532 L .781 .58433 L p .565 g
F P
0 g
s
.29818 .57649 m .29265 .60209 L .41644 .62351 L p .596 g
F P
0 g
s
.41819 .63656 m .41644 .62351 L .29265 .60209 L p .57 g
F P
0 g
s
.53995 .60606 m .41644 .62351 L .41819 .63656 L closepath p .479 g
F P
0 g
s
.85031 .73057 m .82612 .7561 L .75357 .68089 L p .728 g
F P
0 g
s
.75357 .68089 m .77242 .66006 L .85031 .73057 L p .728 g
F P
0 g
s
.54427 .34528 m .54284 .39483 L .56469 .43563 L p .491 g
F P
0 g
s
.54284 .39483 m .54427 .34528 L .49881 .3183 L p .581 g
F P
0 g
s
.53995 .60606 m .54824 .57923 L .55805 .56728 L closepath p .479 g
F P
0 g
s
.54164 .56647 m .53995 .60606 L .54215 .57828 L closepath p .632 g
F P
0 g
s
.57685 .39661 m .56469 .43563 L .57208 .48937 L p .408 g
F P
0 g
s
.56469 .43563 m .57685 .39661 L .54427 .34528 L p .491 g
F P
0 g
s
.53995 .60606 m .61775 .54556 L .63283 .54847 L closepath p .479 g
F P
0 g
s
.55349 .56219 m .56306 .54865 L .57208 .48937 L p .351 g
F P
0 g
s
.58776 .46403 m .57208 .48937 L .56306 .54865 L p .354 g
F P
0 g
s
.57208 .48937 m .58776 .46403 L .57685 .39661 L p .408 g
F P
0 g
s
.48166 .68839 m .47073 .68921 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .54207 .59245 L .54824 .57923 L closepath p .479 g
F P
0 g
s
.55349 .56219 m .54615 .57691 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.56306 .54865 m .55349 .56219 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.54215 .57828 m .53995 .60606 L .54153 .59186 L closepath p .683 g
F P
0 g
s
.57426 .53719 m .56306 .54865 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.56306 .54865 m .57426 .53719 L .58776 .46403 L p .354 g
F P
0 g
s
.53995 .60606 m .63283 .54847 L .64591 .55469 L closepath p .479 g
F P
0 g
s
.54615 .57691 m .54153 .59186 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.29265 .60209 m .29556 .6281 L .41819 .63656 L p .57 g
F P
0 g
s
.42404 .6482 m .41819 .63656 L .29556 .6281 L p .531 g
F P
0 g
s
.53995 .60606 m .41819 .63656 L .42404 .6482 L closepath p .479 g
F P
0 g
s
.22546 .47988 m .20585 .51034 L .29818 .57649 L p .713 g
F P
0 g
s
.29265 .60209 m .29818 .57649 L .20585 .51034 L p .702 g
F P
0 g
s
.48166 .68839 m .49351 .68366 L .47554 .76734 L p .336 g
F P
0 g
s
.49194 .7487 m .47554 .76734 L .49351 .68366 L p .376 g
F P
0 g
s
.47554 .76734 m .49194 .7487 L .50307 .81547 L p .442 g
F P
0 g
s
.42132 .27569 m .45303 .31937 L .49881 .3183 L p .687 g
F P
0 g
s
.45303 .31937 m .42132 .27569 L .37595 .31132 L p .719 g
F P
0 g
s
.58634 .52856 m .57426 .53719 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.57426 .53719 m .58634 .52856 L .60481 .44368 L p .344 g
F P
0 g
s
.60481 .44368 m .58776 .46403 L .57426 .53719 L p .344 g
F P
0 g
s
.37595 .31132 m .33107 .28767 L .31104 .35669 L p .758 g
F P
0 g
s
.26449 .35552 m .31104 .35669 L .33107 .28767 L p .814 g
F P
0 g
s
.49351 .68366 m .48166 .68839 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.58776 .46403 m .60481 .44368 L .59018 .36402 L p .393 g
F P
0 g
s
.59018 .36402 m .57685 .39661 L .58776 .46403 L p .393 g
F P
0 g
s
.53995 .60606 m .64591 .55469 L .6561 .56384 L closepath p .479 g
F P
0 g
s
.53703 .82011 m .53565 .86599 L .50307 .81547 L p .556 g
F P
0 g
s
.53565 .86599 m .53703 .82011 L .56792 .84324 L p .616 g
F P
0 g
s
.56792 .84324 m .58104 .89341 L .53565 .86599 L p .616 g
F P
0 g
s
.78649 .61002 m .78361 .63586 L .66337 .6021 L p .595 g
F P
0 g
s
.66337 .6021 m .66517 .58837 L .78649 .61002 L p .595 g
F P
0 g
s
.26449 .35552 m .22293 .36667 L .25451 .45641 L p .786 g
F P
0 g
s
.22546 .47988 m .25451 .45641 L .22293 .36667 L p .819 g
F P
0 g
s
.29556 .6281 m .30682 .65272 L .42404 .6482 L p .531 g
F P
0 g
s
.43362 .65761 m .42404 .6482 L .30682 .65272 L p .475 g
F P
0 g
s
.53995 .60606 m .42404 .6482 L .43362 .65761 L closepath p .479 g
F P
0 g
s
.58104 .89341 m .56792 .84324 L .59944 .84545 L p .654 g
F P
0 g
s
.59944 .84545 m .62743 .89458 L .58104 .89341 L p .654 g
F P
0 g
s
.59852 .52335 m .58634 .52856 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.58634 .52856 m .59852 .52335 L .62217 .4297 L p .321 g
F P
0 g
s
.62217 .4297 m .60481 .44368 L .58634 .52856 L p .321 g
F P
0 g
s
.33107 .28767 m .37595 .31132 L .42132 .27569 L p .776 g
F P
0 g
s
.51491 .77863 m .50307 .81547 L .49194 .7487 L p .481 g
F P
0 g
s
.50307 .81547 m .51491 .77863 L .53703 .82011 L p .556 g
F P
0 g
s
.60999 .52193 m .59852 .52335 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .43362 .65761 L .44629 .66414 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .5456 .65985 L .544 .66251 L closepath p .42 g
F P
0 g
s
.53995 .60606 m .54622 .65337 L .5456 .65985 L closepath p .331 g
F P
0 g
s
.53995 .60606 m .54217 .62987 L .54154 .61856 L closepath p .628 g
F P
0 g
s
.53995 .60606 m .544 .66251 L .54186 .66102 L closepath p .484 g
F P
0 g
s
.53995 .60606 m .54167 .63945 L .54217 .62987 L closepath p .577 g
F P
0 g
s
.53995 .60606 m .54186 .66102 L .53975 .6554 L closepath p .536 g
F P
0 g
s
.53995 .60606 m .54015 .64686 L .54167 .63945 L closepath p .526 g
F P
0 g
s
.53995 .60606 m .53975 .6554 L .53825 .64615 L closepath p .584 g
F P
0 g
s
.53322 .69057 m .53825 .64615 L .53975 .6554 L p .548 g
F P
0 g
s
.53995 .60606 m .53804 .65176 L .54015 .64686 L closepath p .47 g
F P
0 g
s
.53995 .60606 m .53774 .63409 L .53837 .62033 L closepath p .683 g
F P
0 g
s
.53995 .60606 m .53825 .64615 L .53774 .63409 L closepath p .632 g
F P
0 g
s
.53621 .63461 m .53488 .63505 L .53755 .62379 L .467 g
F
.5363 .62704 m .53837 .62033 L p .53488 .63505 L F P
0 g
s
.53837 .62033 m .53371 .63544 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53371 .63544 m .5263 .65034 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.5263 .65034 m .51665 .66396 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .53158 .63316 L .53783 .61974 L closepath p .479 g
F P
0 g
s
.53371 .63544 m .5363 .62704 L p .53488 .63505 L .467 g
F P
0 g
s
.5263 .65034 m .53371 .63544 L .53123 .66462 L p .439 g
F P
0 g
s
.53774 .63409 m .53123 .66462 L .53278 .6464 L p .467 g
F P
0 g
s
.53278 .6464 m .53371 .63544 L p .53488 .63505 L .467 g
F P
0 g
s
.53774 .63409 m .53278 .6464 L .53488 .63505 L .467 g
F
.53572 .63192 m .53783 .61974 L p .53758 .62037 L .061 g
F P
0 g
s
.51665 .66396 m .5263 .65034 L .52088 .6954 L p .423 g
F P
0 g
s
.52324 .65613 m .53572 .63192 L p .53758 .62037 L .061 g
F P
0 g
s
.53158 .63316 m .52324 .65613 L p .53758 .62037 L .061 g
F P
0 g
s
.53783 .61974 m .53759 .62025 L p .53758 .62037 L .061 g
F P
0 g
s
.53759 .62025 m .53158 .63316 L p .53758 .62037 L .061 g
F P
0 g
s
.53572 .63192 m .5342 .64181 L .53732 .62245 L p F P
s
.53783 .61974 m .53572 .63192 L .53908 .6114 L p .801 g
F P
0 g
s
.53732 .62245 m .53809 .61764 L p .53739 .62186 L F P
s
.53739 .62186 m .53572 .63192 L .53732 .62245 L F
.53809 .61764 m .53923 .61054 L p .53788 .61878 L F P
s
.53788 .61878 m .53572 .63192 L .53809 .61764 L F
.53908 .6114 m .53995 .60606 L .53891 .61281 L p .801 g
F P
0 g
s
.53891 .61281 m .53783 .61974 L p .53908 .6114 L .801 g
F P
0 g
s
.53837 .62033 m .53774 .63409 L p .53621 .63461 L .467 g
F P
0 g
s
.53621 .63461 m .53755 .62379 L .53837 .62033 L .467 g
F
.53923 .61054 m .53995 .60606 L .53908 .6114 L p 0 g
F P
s
.53908 .6114 m .53572 .63192 L p .53923 .61054 L F P
s
.53123 .66462 m .53774 .63409 L .53825 .64615 L p .53 g
F P
0 g
s
.53825 .64615 m .53322 .69057 L .53123 .66462 L p .53 g
F P
0 g
s
.53995 .60606 m .5359 .65385 L .53804 .65176 L closepath p .403 g
F P
0 g
s
.53995 .60606 m .5343 .65293 L .5359 .65385 L closepath p .312 g
F P
0 g
s
.53995 .60606 m .53368 .6489 L .5343 .65293 L closepath p .17 g
F P
0 g
s
.53995 .60606 m .5342 .64181 L .53368 .6489 L closepath p .031 g
F P
0 g
s
.53995 .60606 m .5457 .6438 L .54622 .65337 L closepath p .186 g
F P
0 g
s
.54833 .63081 m .55667 .65666 L p .54233 .61979 L .369 g
F P
0 g
s
.54208 .61915 m .54232 .61959 L p .54233 .61979 L .369 g
F P
0 g
s
.54232 .61959 m .54833 .63081 L p .54233 .61979 L .369 g
F P
0 g
s
.54418 .63205 m .5457 .6438 L .54259 .62337 L p .047 g
F P
0 g
s
.54259 .62337 m .54067 .61079 L p .54244 .62136 L .047 g
F P
0 g
s
.54083 .61142 m .54244 .62136 L p .54067 .61079 L .047 g
F P
0 g
s
.54244 .62136 m .54418 .63205 L p .54259 .62337 L .047 g
F P
0 g
s
.54208 .61915 m .54418 .63205 L .54083 .61142 L p .498 g
F P
0 g
s
.54067 .61079 m .53995 .60606 L .54083 .61142 L p .047 g
F P
0 g
s
.54083 .61142 m .53995 .60606 L .541 .61251 L p .498 g
F P
0 g
s
.541 .61251 m .54208 .61915 L p .54083 .61142 L .498 g
F P
0 g
s
.54154 .61856 m .54217 .62987 L p .54371 .62936 L .322 g
F P
0 g
s
.55667 .65666 m .54418 .63205 L .54208 .61915 L p .369 g
F P
0 g
s
.54371 .62936 m .54505 .62891 L .54236 .62099 L .322 g
F
.54371 .62936 m .54236 .62099 L .54154 .61856 L F
.54622 .62851 m .54361 .62298 L p .54505 .62891 L F P
0 g
s
.54361 .62298 m .54154 .61856 L p .54505 .62891 L .322 g
F P
0 g
s
.53995 .60606 m .6561 .56384 L .66268 .57532 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .66268 .57532 L .66517 .58837 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .66517 .58837 L .66337 .6021 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .66337 .6021 L .65736 .61556 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .65736 .61556 L .64755 .62782 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .64755 .62782 L .63459 .638 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .63459 .638 L .61939 .64539 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .61939 .64539 L .60303 .64946 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .60303 .64946 L .58664 .64993 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .58664 .64993 L .57139 .64678 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .57139 .64678 L .55832 .64025 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .55832 .64025 L .54833 .63081 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .54833 .63081 L .54208 .61915 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .44629 .66414 L .4612 .6673 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .4612 .6673 L .47731 .66686 L closepath p .479 g
F P
0 g
s
.50545 .67533 m .49351 .68366 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.51665 .66396 m .50545 .67533 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .52162 .64536 L .53158 .63316 L closepath p .479 g
F P
0 g
s
.61997 .52445 m .60999 .52193 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.53995 .60606 m .47731 .66686 L .4935 .66283 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .50863 .65549 L .52162 .64536 L closepath p .479 g
F P
0 g
s
.53995 .60606 m .4935 .66283 L .50863 .65549 L closepath p .479 g
F P
0 g
s
.62775 .53078 m .61997 .52445 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.54154 .61856 m .54622 .62851 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.63279 .54051 m .62775 .53078 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.54622 .62851 m .5537 .63522 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.6347 .55302 m .63279 .54051 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.5537 .63522 m .5635 .63819 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.63332 .56745 m .6347 .55302 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.5635 .63819 m .57498 .63717 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.62872 .5828 m .63332 .56745 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.57498 .63717 m .58736 .63219 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.62121 .59797 m .62872 .5828 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.58736 .63219 m .59977 .62357 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.61133 .61189 m .62121 .59797 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.59977 .62357 m .61133 .61189 L .53995 .60606 L closepath p .323 g
F P
0 g
s
.57685 .39661 m .59018 .36402 L .54584 .30314 L p .485 g
F P
0 g
s
.54584 .30314 m .54427 .34528 L .57685 .39661 L p .485 g
F P
0 g
s
.70408 .90102 m .6627 .87031 L .67722 .82522 L p .717 g
F P
0 g
s
.67722 .82522 m .72413 .84727 L .70408 .90102 L p .717 g
F P
0 g
s
.49351 .68366 m .50545 .67533 L .49194 .7487 L p .376 g
F P
0 g
s
.48375 .27205 m .49881 .3183 L .54427 .34528 L p .6 g
F P
0 g
s
.49881 .3183 m .48375 .27205 L .42132 .27569 L p .687 g
F P
0 g
s
.82612 .7561 m .79319 .77359 L .72832 .69684 L p .716 g
F P
0 g
s
.72832 .69684 m .75357 .68089 L .82612 .7561 L p .716 g
F P
0 g
s
.20585 .51034 m .19727 .54585 L .29265 .60209 L p .702 g
F P
0 g
s
.29556 .6281 m .29265 .60209 L .19727 .54585 L p .668 g
F P
0 g
s
.54427 .34528 m .54584 .30314 L .48375 .27205 L p .6 g
F P
0 g
s
.30682 .65272 m .32576 .67421 L .43362 .65761 L p .475 g
F P
0 g
s
.44629 .66414 m .43362 .65761 L .32576 .67421 L p .403 g
F P
0 g
s
.50744 .72414 m .49194 .7487 L .50545 .67533 L p .403 g
F P
0 g
s
.49194 .7487 m .50744 .72414 L .51491 .77863 L p .481 g
F P
0 g
s
.59852 .52335 m .60999 .52193 L .63871 .42314 L p .285 g
F P
0 g
s
.63871 .42314 m .62217 .4297 L .59852 .52335 L p .285 g
F P
0 g
s
.76997 .85663 m .72413 .84727 L .71044 .77948 L p .731 g
F P
0 g
s
.71044 .77948 m .7537 .78164 L .76997 .85663 L p .731 g
F P
0 g
s
.50545 .67533 m .51665 .66396 L .50744 .72414 L p .403 g
F P
0 g
s
.62743 .89458 m .59944 .84545 L .62323 .82722 L p .667 g
F P
0 g
s
.62323 .82722 m .6627 .87031 L .62743 .89458 L p .667 g
F P
0 g
s
.60481 .44368 m .62217 .4297 L .60389 .34008 L p .349 g
F P
0 g
s
.60389 .34008 m .59018 .36402 L .60481 .44368 L p .349 g
F P
0 g
s
.78361 .63586 m .77242 .66006 L .65736 .61556 L p .613 g
F P
0 g
s
.65736 .61556 m .66337 .6021 L .78361 .63586 L p .613 g
F P
0 g
s
.32576 .67421 m .35115 .69099 L .44629 .66414 L p .403 g
F P
0 g
s
.4612 .6673 m .44629 .66414 L .35115 .69099 L p .319 g
F P
0 g
s
.52088 .6954 m .50744 .72414 L .51665 .66396 L p .423 g
F P
0 g
s
.53123 .66462 m .52088 .6954 L .5263 .65034 L p .439 g
F P
0 g
s
.50325 .67698 m .52324 .65613 L .53158 .63316 L p .094 g
F P
0 g
s
.53158 .63316 m .52162 .64536 L .50325 .67698 L p .094 g
F P
0 g
s
.56268 .68144 m .5457 .6438 L .54418 .63205 L p .407 g
F P
0 g
s
.54418 .63205 m .55667 .65666 L .56268 .68144 L p .407 g
F P
0 g
s
.51715 .67366 m .5342 .64181 L .53572 .63192 L p .06 g
F P
0 g
s
.53572 .63192 m .52324 .65613 L .51715 .67366 L p .06 g
F P
0 g
s
.60999 .52193 m .61997 .52445 L .65331 .42461 L p .234 g
F P
0 g
s
.65331 .42461 m .63871 .42314 L .60999 .52193 L p .234 g
F P
0 g
s
.57665 .67813 m .55667 .65666 L .54833 .63081 L p .46 g
F P
0 g
s
.54833 .63081 m .55832 .64025 L .57665 .67813 L p .46 g
F P
0 g
s
.50744 .72414 m .52088 .6954 L .52524 .7359 L p .501 g
F P
0 g
s
.52524 .7359 m .51491 .77863 L .50744 .72414 L p .501 g
F P
0 g
s
.35115 .69099 m .3812 .70181 L .4612 .6673 L p .319 g
F P
0 g
s
.47731 .66686 m .4612 .6673 L .3812 .70181 L p .232 g
F P
0 g
s
.54217 .62987 m .54873 .64811 L .54622 .62851 L p .322 g
F P
0 g
s
.56474 .70261 m .54622 .65337 L .5457 .6438 L p .445 g
F P
0 g
s
.5457 .6438 m .56268 .68144 L .56474 .70261 L p .445 g
F P
0 g
s
.54873 .64811 m .54217 .62987 L .54167 .63945 L p .318 g
F P
0 g
s
.51491 .77863 m .52524 .7359 L .53823 .76687 L p .558 g
F P
0 g
s
.53823 .76687 m .53703 .82011 L .51491 .77863 L p .558 g
F P
0 g
s
.47707 .69294 m .50325 .67698 L .52162 .64536 L p .107 g
F P
0 g
s
.52162 .64536 m .50863 .65549 L .47707 .69294 L p .107 g
F P
0 g
s
.53703 .82011 m .53823 .76687 L .55641 .7846 L p .595 g
F P
0 g
s
.55641 .7846 m .56792 .84324 L .53703 .82011 L p .595 g
F P
0 g
s
.22293 .36667 m .18929 .38982 L .22546 .47988 L p .819 g
F P
0 g
s
.20585 .51034 m .22546 .47988 L .18929 .38982 L p .838 g
F P
0 g
s
.5537 .63522 m .54622 .62851 L .54873 .64811 L p .212 g
F P
0 g
s
.19727 .54585 m .2006 .58403 L .29556 .6281 L p .668 g
F P
0 g
s
.30682 .65272 m .29556 .6281 L .2006 .58403 L p .6 g
F P
0 g
s
.52088 .6954 m .53123 .66462 L .53322 .69057 L p .513 g
F P
0 g
s
.3812 .70181 m .41377 .70585 L .47731 .66686 L p .232 g
F P
0 g
s
.4935 .66283 m .47731 .66686 L .41377 .70585 L p .155 g
F P
0 g
s
.33107 .28767 m .28757 .27762 L .26449 .35552 L p .814 g
F P
0 g
s
.22293 .36667 m .26449 .35552 L .28757 .27762 L p .877 g
F P
0 g
s
.44652 .70282 m .47707 .69294 L .50863 .65549 L p .123 g
F P
0 g
s
.50863 .65549 m .4935 .66283 L .44652 .70282 L p .123 g
F P
0 g
s
.53322 .69057 m .52524 .7359 L .52088 .6954 L p .513 g
F P
0 g
s
.53975 .6554 m .53917 .71046 L .53322 .69057 L p .548 g
F P
0 g
s
.53917 .71046 m .53975 .6554 L .54186 .66102 L p .544 g
F P
0 g
s
.41377 .70585 m .44652 .70282 L .4935 .66283 L p .155 g
F P
0 g
s
.515 .68517 m .53368 .6489 L .5342 .64181 L p .086 g
F P
0 g
s
.5342 .64181 m .51715 .67366 L .515 .68517 L p .086 g
F P
0 g
s
.56792 .84324 m .55641 .7846 L .57493 .78723 L p .612 g
F P
0 g
s
.57493 .78723 m .59944 .84545 L .56792 .84324 L p .612 g
F P
0 g
s
.79319 .77359 m .7537 .78164 L .6984 .70671 L p .695 g
F P
0 g
s
.6984 .70671 m .72832 .69684 L .79319 .77359 L p .695 g
F P
0 g
s
.38843 .2438 m .42132 .27569 L .48375 .27205 L p .729 g
F P
0 g
s
.42132 .27569 m .38843 .2438 L .33107 .28767 L p .776 g
F P
0 g
s
.56226 .71765 m .5456 .65985 L .54622 .65337 L p .478 g
F P
0 g
s
.54622 .65337 m .56474 .70261 L .56226 .71765 L p .478 g
F P
0 g
s
.54186 .66102 m .54748 .72217 L .53917 .71046 L p .544 g
F P
0 g
s
.54748 .72217 m .54186 .66102 L .544 .66251 L p .528 g
F P
0 g
s
.60279 .69489 m .57665 .67813 L .55832 .64025 L p .511 g
F P
0 g
s
.55832 .64025 m .57139 .64678 L .60279 .69489 L p .511 g
F P
0 g
s
.5456 .65985 m .56226 .71765 L .55594 .72455 L p .506 g
F P
0 g
s
.54167 .63945 m .54676 .66441 L .54873 .64811 L p .318 g
F P
0 g
s
.55594 .72455 m .544 .66251 L .5456 .65985 L p .506 g
F P
0 g
s
.54676 .66441 m .54167 .63945 L .54015 .64686 L p .304 g
F P
0 g
s
.77242 .66006 m .75357 .68089 L .64755 .62782 L p .621 g
F P
0 g
s
.64755 .62782 m .65736 .61556 L .77242 .66006 L p .621 g
F P
0 g
s
.59018 .36402 m .60389 .34008 L .54748 .27122 L p .442 g
F P
0 g
s
.54748 .27122 m .54584 .30314 L .59018 .36402 L p .442 g
F P
0 g
s
.544 .66251 m .55594 .72455 L .54748 .72217 L p .528 g
F P
0 g
s
.6627 .87031 m .62323 .82722 L .6328 .79199 L p .66 g
F P
0 g
s
.6328 .79199 m .67722 .82522 L .6627 .87031 L p .66 g
F P
0 g
s
.52524 .7359 m .53322 .69057 L .53917 .71046 L p .552 g
F P
0 g
s
.53917 .71046 m .53823 .76687 L .52524 .7359 L p .552 g
F P
0 g
s
.61997 .52445 m .62775 .53078 L .66491 .43421 L p .167 g
F P
0 g
s
.66491 .43421 m .65331 .42461 L .61997 .52445 L p .167 g
F P
0 g
s
.5174 .69072 m .5343 .65293 L .53368 .6489 L p .118 g
F P
0 g
s
.53368 .6489 m .515 .68517 L .5174 .69072 L p .118 g
F P
0 g
s
.72413 .84727 m .67722 .82522 L .66657 .76716 L p .684 g
F P
0 g
s
.66657 .76716 m .71044 .77948 L .72413 .84727 L p .684 g
F P
0 g
s
.58986 .71622 m .56268 .68144 L .55667 .65666 L p .499 g
F P
0 g
s
.55667 .65666 m .57665 .67813 L .58986 .71622 L p .499 g
F P
0 g
s
.62217 .4297 m .63871 .42314 L .6171 .32661 L p .264 g
F P
0 g
s
.6171 .32661 m .60389 .34008 L .62217 .4297 L p .264 g
F P
0 g
s
.4897 .69932 m .51715 .67366 L .52324 .65613 L p .066 g
F P
0 g
s
.52324 .65613 m .50325 .67698 L .4897 .69932 L p .066 g
F P
0 g
s
.5635 .63819 m .5537 .63522 L .55931 .65945 L p .115 g
F P
0 g
s
.54873 .64811 m .55931 .65945 L .5537 .63522 L p .212 g
F P
0 g
s
.54015 .64686 m .54075 .67715 L .54676 .66441 L p .304 g
F P
0 g
s
.54075 .67715 m .54015 .64686 L .53804 .65176 L p .276 g
F P
0 g
s
.63328 .7057 m .60279 .69489 L .57139 .64678 L p .548 g
F P
0 g
s
.57139 .64678 m .58664 .64993 L .63328 .7057 L p .548 g
F P
0 g
s
.59944 .84545 m .57493 .78723 L .58883 .77497 L p .615 g
F P
0 g
s
.58883 .77497 m .62323 .82722 L .59944 .84545 L p .615 g
F P
0 g
s
.53823 .76687 m .53917 .71046 L .54748 .72217 L p .569 g
F P
0 g
s
.54748 .72217 m .55641 .7846 L .53823 .76687 L p .569 g
F P
0 g
s
.28757 .27762 m .33107 .28767 L .38843 .2438 L p .842 g
F P
0 g
s
.52375 .69081 m .5359 .65385 L .5343 .65293 L p .177 g
F P
0 g
s
.5343 .65293 m .5174 .69072 L .52375 .69081 L p .177 g
F P
0 g
s
.2006 .58403 m .21586 .62219 L .30682 .65272 L p .6 g
F P
0 g
s
.32576 .67421 m .30682 .65272 L .21586 .62219 L p .489 g
F P
0 g
s
.53804 .65176 m .53232 .68609 L .54075 .67715 L p .276 g
F P
0 g
s
.53232 .68609 m .53804 .65176 L .5359 .65385 L p .234 g
F P
0 g
s
.5359 .65385 m .52375 .69081 L .53232 .68609 L p .234 g
F P
0 g
s
.55641 .7846 m .54748 .72217 L .55594 .72455 L p .572 g
F P
0 g
s
.55594 .72455 m .57493 .78723 L .55641 .7846 L p .572 g
F P
0 g
s
.66594 .70974 m .63328 .7057 L .58664 .64993 L p .576 g
F P
0 g
s
.58664 .64993 m .60303 .64946 L .66594 .70974 L p .576 g
F P
0 g
s
.54584 .30314 m .54748 .27122 L .4681 .23705 L p .595 g
F P
0 g
s
.4681 .23705 m .48375 .27205 L .54584 .30314 L p .595 g
F P
0 g
s
.48375 .27205 m .4681 .23705 L .38843 .2438 L p .729 g
F P
0 g
s
.59432 .75004 m .56474 .70261 L .56268 .68144 L p .528 g
F P
0 g
s
.56268 .68144 m .58986 .71622 L .59432 .75004 L p .528 g
F P
0 g
s
.75357 .68089 m .72832 .69684 L .63459 .638 L p .62 g
F P
0 g
s
.63459 .638 m .64755 .62782 L .75357 .68089 L p .62 g
F P
0 g
s
.62775 .53078 m .63279 .54051 L .67262 .45147 L p .085 g
F P
0 g
s
.67262 .45147 m .66491 .43421 L .62775 .53078 L p .085 g
F P
0 g
s
.55931 .65945 m .54873 .64811 L .54676 .66441 L p .115 g
F P
0 g
s
.7537 .78164 m .71044 .77948 L .66594 .70974 L p .669 g
F P
0 g
s
.66594 .70974 m .6984 .70671 L .7537 .78164 L p .669 g
F P
0 g
s
.57493 .78723 m .55594 .72455 L .56226 .71765 L p .564 g
F P
0 g
s
.6984 .70671 m .66594 .70974 L .60303 .64946 L p .597 g
F P
0 g
s
.60303 .64946 m .61939 .64539 L .6984 .70671 L p .597 g
F P
0 g
s
.57498 .63717 m .5635 .63819 L .57328 .66295 L p .074 g
F P
0 g
s
.55931 .65945 m .57328 .66295 L .5635 .63819 L p .115 g
F P
0 g
s
.61939 .64539 m .63459 .638 L .72832 .69684 L p .612 g
F P
0 g
s
.62535 .74554 m .58986 .71622 L .57665 .67813 L p .556 g
F P
0 g
s
.57665 .67813 m .60279 .69489 L .62535 .74554 L p .556 g
F P
0 g
s
.58883 .77497 m .56226 .71765 L .56474 .70261 L p .549 g
F P
0 g
s
.56474 .70261 m .59432 .75004 L .58883 .77497 L p .549 g
F P
0 g
s
.72832 .69684 m .6984 .70671 L .61939 .64539 L p .612 g
F P
0 g
s
.56226 .71765 m .58883 .77497 L .57493 .78723 L p .564 g
F P
0 g
s
.18929 .38982 m .16618 .4238 L .20585 .51034 L p .838 g
F P
0 g
s
.19727 .54585 m .20585 .51034 L .16618 .4238 L p .822 g
F P
0 g
s
.62323 .82722 m .58883 .77497 L .59432 .75004 L p .606 g
F P
0 g
s
.59432 .75004 m .6328 .79199 L .62323 .82722 L p .606 g
F P
0 g
s
.45355 .71682 m .4897 .69932 L .50325 .67698 L p .062 g
F P
0 g
s
.50325 .67698 m .47707 .69294 L .45355 .71682 L p .062 g
F P
0 g
s
.67722 .82522 m .6328 .79199 L .62535 .74554 L p .637 g
F P
0 g
s
.62535 .74554 m .66657 .76716 L .67722 .82522 L p .637 g
F P
0 g
s
.21586 .62219 m .24214 .65754 L .32576 .67421 L p .489 g
F P
0 g
s
.35115 .69099 m .32576 .67421 L .24214 .65754 L p .337 g
F P
0 g
s
.48474 .7122 m .515 .68517 L .51715 .67366 L p .053 g
F P
0 g
s
.51715 .67366 m .4897 .69932 L .48474 .7122 L p .053 g
F P
0 g
s
.63279 .54051 m .6347 .55302 L .6758 .47533 L p .047 g
F P
0 g
s
.6758 .47533 m .67262 .45147 L .63279 .54051 L p .047 g
F P
0 g
s
.6328 .79199 m .59432 .75004 L .58986 .71622 L p .586 g
F P
0 g
s
.58986 .71622 m .62535 .74554 L .6328 .79199 L p .586 g
F P
0 g
s
.66657 .76716 m .62535 .74554 L .60279 .69489 L p .6 g
F P
0 g
s
.60279 .69489 m .63328 .7057 L .66657 .76716 L p .6 g
F P
0 g
s
.58736 .63219 m .57498 .63717 L .58975 .65817 L p .033 g
F P
0 g
s
.57328 .66295 m .58975 .65817 L .57498 .63717 L p .074 g
F P
0 g
s
.71044 .77948 m .66657 .76716 L .63328 .7057 L p .637 g
F P
0 g
s
.63328 .7057 m .66594 .70974 L .71044 .77948 L p .637 g
F P
0 g
s
.63871 .42314 m .65331 .42461 L .62892 .32489 L p .131 g
F P
0 g
s
.62892 .32489 m .6171 .32661 L .63871 .42314 L p .131 g
F P
0 g
s
.41111 .72472 m .45355 .71682 L .47707 .69294 L p .073 g
F P
0 g
s
.47707 .69294 m .44652 .70282 L .41111 .72472 L p .073 g
F P
0 g
s
.28757 .27762 m .24835 .28238 L .22293 .36667 L p .877 g
F P
0 g
s
.18929 .38982 m .22293 .36667 L .24835 .28238 L p .929 g
F P
0 g
s
.24214 .65754 m .27764 .68741 L .35115 .69099 L p .337 g
F P
0 g
s
.3812 .70181 m .35115 .69099 L .27764 .68741 L p .186 g
F P
0 g
s
.54676 .66441 m .55502 .67904 L .55931 .65945 L p .115 g
F P
0 g
s
.55502 .67904 m .54676 .66441 L .54075 .67715 L p .083 g
F P
0 g
s
.60389 .34008 m .6171 .32661 L .54906 .25199 L p .319 g
F P
0 g
s
.54906 .25199 m .54748 .27122 L .60389 .34008 L p .319 g
F P
0 g
s
.6347 .55302 m .63332 .56745 L .67412 .50417 L p .037 g
F P
0 g
s
.67412 .50417 m .6758 .47533 L .6347 .55302 L p .037 g
F P
0 g
s
.3654 .72228 m .41111 .72472 L .44652 .70282 L p .095 g
F P
0 g
s
.38738 .71481 m .3654 .72228 L p .38818 .71681 L .095 g
F P
0 g
s
.31978 .70954 m .3654 .72228 L .41377 .70585 L p .13 g
F P
0 g
s
.27764 .68741 m .31978 .70954 L .3812 .70181 L p .186 g
F P
0 g
s
.33826 .70722 m .31978 .70954 L p .34005 .70875 L .13 g
F P
0 g
s
.2006 .58403 m .15877 .51519 L p .19841 .58949 L .498 g
F P
0 g
s
.21586 .62219 m .20293 .58984 L p .19841 .58949 L .498 g
F P
0 g
s
.20293 .58984 m .2006 .58403 L p .19841 .58949 L .498 g
F P
0 g
s
.15877 .51519 m .17577 .56623 L .21586 .62219 L p .498 g
F P
0 g
s
.24214 .65754 m .21586 .62219 L .20819 .61149 L p .05 g
F P
0 g
s
.24214 .65754 m .20819 .61149 L .21491 .62026 L .05 g
F
.19287 .5901 m .17577 .56623 L p .24214 .65754 L F P
0 g
s
.20819 .61149 m .19287 .5901 L p .21491 .62026 L .05 g
F P
0 g
s
.20558 .61579 m .24214 .65754 L p .19234 .58902 L .05 g
F P
0 g
s
.27764 .68741 m .24214 .65754 L .23 .64368 L p .187 g
F P
0 g
s
.27764 .68741 m .23 .64368 L .24809 .65804 L .187 g
F
.23 .64368 m .20558 .61579 L p .24809 .65804 L F P
0 g
s
.24602 .66 m .27764 .68741 L p .23024 .6403 L .187 g
F P
0 g
s
.31978 .70954 m .27764 .68741 L .26476 .67625 L p .325 g
F P
0 g
s
.26476 .67625 m .24602 .66 L p .28777 .68805 L .325 g
F P
0 g
s
.31978 .70954 m .26476 .67625 L .28777 .68805 L .325 g
F
.24602 .66 m .29397 .69544 L .29786 .69757 L p F P
0 g
s
.29786 .69757 m .31978 .70954 L p .27547 .67978 L .325 g
F P
0 g
s
.27547 .67978 m .24602 .66 L .29786 .69757 L .325 g
F
.20558 .61579 m .24171 .6553 L p .23024 .6403 L .187 g
F P
0 g
s
.24171 .6553 m .24602 .66 L p .23024 .6403 L .187 g
F P
0 g
s
.17577 .56623 m .18934 .58879 L p .19234 .58902 L .05 g
F P
0 g
s
.18934 .58879 m .20558 .61579 L p .19234 .58902 L .05 g
F P
0 g
s
.3654 .72228 m .31978 .70954 L .30834 .70329 L p .409 g
F P
0 g
s
.30834 .70329 m .29397 .69544 L p .33379 .7104 L .409 g
F P
0 g
s
.3654 .72228 m .30834 .70329 L .33379 .7104 L .409 g
F
.29397 .69544 m .34568 .71944 L .35029 .72011 L p F P
0 g
s
.35029 .72011 m .35395 .72063 L p .33939 .71452 L .409 g
F P
0 g
s
.33939 .71452 m .29397 .69544 L .35029 .72011 L .409 g
F
.34568 .71944 m .39328 .72956 L p .39213 .72669 L .443 g
F P
0 g
s
.41111 .72472 m .39091 .72364 L p .39068 .72307 L .443 g
F P
0 g
s
.39091 .72364 m .3654 .72228 L p .39068 .72307 L .443 g
F P
0 g
s
.35395 .72063 m .3654 .72228 L p .34841 .71589 L .409 g
F P
0 g
s
.34841 .71589 m .29397 .69544 L .35395 .72063 L .409 g
F
.3654 .72228 m .35511 .7208 L p .39068 .72307 L .443 g
F P
0 g
s
.39068 .72307 m .35511 .7208 L .36348 .72088 L .443 g
F
.39068 .72307 m .37451 .72177 L .39213 .72669 L F
.39716 .73038 m .41111 .72472 L p .39068 .72307 L F P
0 g
s
.39328 .72956 m .39716 .73038 L p .39068 .72307 L .443 g
F P
0 g
s
.40944 .72414 m .39716 .73038 L p .38465 .72108 L .682 g
F P
0 g
s
.41377 .70585 m .3812 .70181 L .33826 .70722 L p .13 g
F P
0 g
s
.41377 .70585 m .33826 .70722 L .34005 .70875 L .13 g
F
.44652 .70282 m .38738 .71481 L .38818 .71681 L .095 g
F
.36163 .70396 m .40261 .72125 L p .38465 .72108 L .682 g
F P
0 g
s
.40261 .72125 m .40944 .72414 L p .38465 .72108 L .682 g
F P
0 g
s
.35511 .7208 m .34568 .71944 L p .36348 .72088 L .443 g
F P
0 g
s
.37451 .72177 m .34568 .71944 L .39213 .72669 L .443 g
F
.44652 .70282 m .41377 .70585 L .38738 .71481 L p .095 g
F P
0 g
s
.59977 .62357 m .58736 .63219 L .60763 .64524 L p .014 g
F P
0 g
s
.58975 .65817 m .60763 .64524 L .58736 .63219 L p .033 g
F P
0 g
s
.4899 .71659 m .5174 .69072 L .515 .68517 L p .055 g
F P
0 g
s
.515 .68517 m .48474 .7122 L .4899 .71659 L p .055 g
F P
0 g
s
.57328 .66295 m .55931 .65945 L .55502 .67904 L p .004 g
F P
0 g
s
.63332 .56745 m .62872 .5828 L .66766 .5359 L p .028 g
F P
0 g
s
.66766 .5359 m .67412 .50417 L .63332 .56745 L p .028 g
F P
0 g
s
.35635 .22619 m .38843 .2438 L .4681 .23705 L p .745 g
F P
0 g
s
.38843 .2438 m .35635 .22619 L .28757 .27762 L p .842 g
F P
0 g
s
.16618 .4238 m .15561 .46654 L .19727 .54585 L p .822 g
F P
0 g
s
.2006 .58403 m .19727 .54585 L .15561 .46654 L p .721 g
F P
0 g
s
.61133 .61189 m .59977 .62357 L .62565 .62494 L p .012 g
F P
0 g
s
.60763 .64524 m .62565 .62494 L .59977 .62357 L p .014 g
F P
0 g
s
.44461 .72777 m .48474 .7122 L .4897 .69932 L p .028 g
F P
0 g
s
.4897 .69932 m .45355 .71682 L .44461 .72777 L p .028 g
F P
0 g
s
.62872 .5828 m .62121 .59797 L .65622 .56872 L p .019 g
F P
0 g
s
.62121 .59797 m .61133 .61189 L .64247 .59863 L p .014 g
F P
0 g
s
.62565 .62494 m .64247 .59863 L .61133 .61189 L p .012 g
F P
0 g
s
.64247 .59863 m .65684 .5682 L .62121 .59797 L p .014 g
F P
0 g
s
.60783 .61854 m .62139 .57724 L .64142 .59756 L p .926 g
F P
0 g
s
.64142 .59756 m .64247 .59863 L p .64019 .59994 L .926 g
F P
0 g
s
.60783 .61854 m .64142 .59756 L .64019 .59994 L .926 g
F
.65622 .56872 m .65684 .5682 L p .65636 .56845 L .019 g
F P
0 g
s
.65636 .56845 m .62872 .5828 L .65622 .56872 L .019 g
F
.65684 .5682 m .66766 .5359 L .62872 .5828 L p F P
0 g
s
.54075 .67715 m .54173 .69458 L .55502 .67904 L p .083 g
F P
0 g
s
.54173 .69458 m .54075 .67715 L .53232 .68609 L p .071 g
F P
0 g
s
.24835 .28238 m .28757 .27762 L .35635 .22619 L p .888 g
F P
0 g
s
.50391 .71411 m .52375 .69081 L .5174 .69072 L p .06 g
F P
0 g
s
.5174 .69072 m .4899 .71659 L .50391 .71411 L p .06 g
F P
0 g
s
.65331 .42461 m .66491 .43421 L .63846 .33552 L p .054 g
F P
0 g
s
.63846 .33552 m .62892 .32489 L .65331 .42461 L p .054 g
F P
0 g
s
.54748 .27122 m .54906 .25199 L .45282 .21602 L p .51 g
F P
0 g
s
.45282 .21602 m .45983 .22567 L p .47671 .22996 L .51 g
F P
0 g
s
.4681 .23705 m .45282 .21602 L .35635 .22619 L p .745 g
F P
0 g
s
.32725 .22475 m .35635 .22619 L .44012 .21736 L p .586 g
F P
0 g
s
.44012 .21736 m .45282 .21602 L p .44049 .21688 L .586 g
F P
0 g
s
.32725 .22475 m .44012 .21736 L .44049 .21688 L .586 g
F
.45282 .21602 m .43894 .2111 L .32725 .22475 L p F P
0 g
s
.45282 .21602 m .54906 .25199 L p .46201 .21966 L .077 g
F P
0 g
s
.43894 .2111 m .44363 .21276 L p .46201 .21966 L .077 g
F P
0 g
s
.44363 .21276 m .45282 .21602 L p .46201 .21966 L .077 g
F P
0 g
s
.4681 .23705 m .54748 .27122 L p .47671 .22996 L .51 g
F P
0 g
s
.45983 .22567 m .4681 .23705 L p .47671 .22996 L .51 g
F P
0 g
s
.55166 .25832 m .42752 .22351 L p .51994 .24141 L .231 g
F P
0 g
s
.54906 .25199 m .5501 .24859 L p .51791 .24042 L .077 g
F P
0 g
s
.5501 .24859 m .55049 .24733 L p .51791 .24042 L .077 g
F P
0 g
s
.54906 .25199 m .6171 .32661 L p .57327 .27444 L .14 g
F P
0 g
s
.55049 .24733 m .54921 .2515 L p .57327 .27444 L .14 g
F P
0 g
s
.54921 .2515 m .54906 .25199 L p .57327 .27444 L .14 g
F P
0 g
s
.6171 .32661 m .62892 .32489 L .55049 .24733 L p .14 g
F P
0 g
s
.62892 .32489 m .63846 .33552 L .62167 .32059 L p .354 g
F P
0 g
s
.62167 .32059 m .55166 .25832 L p .6005 .3004 L .354 g
F P
0 g
s
.6005 .3004 m .62892 .32489 L .62167 .32059 L .354 g
F
.55049 .24733 m .55111 .25312 L p .51994 .24141 L .231 g
F P
0 g
s
.55111 .25312 m .55166 .25832 L p .51994 .24141 L .231 g
F P
0 g
s
.55049 .24733 m .44374 .21265 L p .51791 .24042 L .077 g
F P
0 g
s
.44374 .21265 m .43894 .2111 L p .4436 .21283 L .077 g
F P
0 g
s
.4436 .21283 m .51791 .24042 L .44374 .21265 L .077 g
F
.53232 .68609 m .52296 .70639 L .54173 .69458 L p .071 g
F P
0 g
s
.52296 .70639 m .53232 .68609 L .52375 .69081 L p .066 g
F P
0 g
s
.52375 .69081 m .50391 .71411 L .52296 .70639 L p .066 g
F P
0 g
s
.24835 .28238 m .21626 .30231 L .18929 .38982 L p .929 g
F P
0 g
s
.16618 .4238 m .18929 .38982 L .21626 .30231 L p .886 g
F P
0 g
s
.15561 .46654 m .15877 .51519 L .2006 .58403 L p .721 g
F P
0 g
s
.58975 .65817 m .57328 .66295 L .56601 .68199 L p F P
s
.55502 .67904 m .56601 .68199 L .57328 .66295 L p .004 g
F P
0 g
s
.39716 .73038 m .44461 .72777 L .45355 .71682 L p .004 g
F P
0 g
s
.48474 .7122 m .44461 .72777 L .45318 .72822 L p F P
s
.45318 .72822 m .44461 .72777 L p .42746 .726 L .634 g
F P
0 g
s
.45355 .71682 m .41111 .72472 L .41037 .72502 L p .004 g
F P
0 g
s
.45355 .71682 m .41037 .72502 L .4177 .72544 L .004 g
F
.40944 .72414 m .43242 .72628 L p .42746 .726 L .634 g
F P
0 g
s
.43242 .72628 m .45318 .72822 L p .42746 .726 L .634 g
F P
0 g
s
.41037 .72502 m .39716 .73038 L p .4177 .72544 L .004 g
F P
0 g
s
.56601 .68199 m .55502 .67904 L .54173 .69458 L p F P
s
.45318 .72822 m .4899 .71659 L .48474 .7122 L p F P
s
.66491 .43421 m .67262 .45147 L .64495 .3582 L p .023 g
F P
0 g
s
.63846 .33552 m .66491 .43421 L p .64847 .37162 L .023 g
F P
0 g
s
.6758 .47533 m .6478 .39165 L p .66517 .43353 L .633 g
F P
0 g
s
.67262 .45147 m .67516 .47054 L p .66517 .43353 L .633 g
F P
0 g
s
.67516 .47054 m .6758 .47533 L p .66517 .43353 L .633 g
F P
0 g
s
.64495 .3582 m .64327 .35233 L p .64847 .37162 L .023 g
F P
0 g
s
.64327 .35233 m .63846 .33552 L p .64847 .37162 L .023 g
F P
0 g
s
.60763 .64524 m .58975 .65817 L .57907 .67259 L p .827 g
F P
0 g
s
.56601 .68199 m .57907 .67259 L .58975 .65817 L p F P
s
.35635 .22619 m .32725 .22475 L .24835 .28238 L p .888 g
F P
0 g
s
.21626 .30231 m .24835 .28238 L .32725 .22475 L p .728 g
F P
0 g
s
.54173 .69458 m .54303 .69739 L .56601 .68199 L p F P
s
.54303 .69739 m .54173 .69458 L .52296 .70639 L p .627 g
F P
0 g
s
.47731 .72146 m .50391 .71411 L .4899 .71659 L p F P
s
.4899 .71659 m .45318 .72822 L .47731 .72146 L p F P
s
.21626 .30231 m .19394 .33668 L .16618 .4238 L p .886 g
F P
0 g
s
.15561 .46654 m .16618 .4238 L .19394 .33668 L p F P
s
.6478 .39165 m .64495 .3582 L .67262 .45147 L p .633 g
F P
0 g
s
.52296 .70639 m .5104 .71058 L .54303 .69739 L p .627 g
F P
0 g
s
.5104 .71058 m .52296 .70639 L .50391 .71411 L p .61 g
F P
0 g
s
.50391 .71411 m .47731 .72146 L .5104 .71058 L p .61 g
F P
0 g
s
.44461 .72777 m .39716 .73038 L .40944 .72414 L p .634 g
F P
0 g
s
.57907 .67259 m .56601 .68199 L .54303 .69739 L p .874 g
F P
0 g
s
.55166 .25832 m .55049 .24733 L .62892 .32489 L p .354 g
F P
0 g
s
.62565 .62494 m .60763 .64524 L .59335 .65105 L p .916 g
F P
0 g
s
.57907 .67259 m .59335 .65105 L .60763 .64524 L p .827 g
F P
0 g
s
.6758 .47533 m .67412 .50417 L .64669 .43363 L p .766 g
F P
0 g
s
.64669 .43363 m .6478 .39165 L .6758 .47533 L p .766 g
F P
0 g
s
.64247 .59863 m .62565 .62494 L .60783 .61854 L p .926 g
F P
0 g
s
.59335 .65105 m .60783 .61854 L .62565 .62494 L p .916 g
F P
0 g
s
.19394 .33668 m .18344 .38357 L .15561 .46654 L p F P
s
.15877 .51519 m .15561 .46654 L .18344 .38357 L p .04 g
F P
0 g
s
.67412 .50417 m .66766 .5359 L .64163 .48104 L p .838 g
F P
0 g
s
.64163 .48104 m .64669 .43363 L .67412 .50417 L p .838 g
F P
0 g
s
.39716 .73038 m .34568 .71944 L .36163 .70396 L p .682 g
F P
0 g
s
.32725 .22475 m .3033 .24044 L .21626 .30231 L p .728 g
F P
0 g
s
.19394 .33668 m .21626 .30231 L .3033 .24044 L p F P
s
.65684 .5682 m .64247 .59863 L .62139 .57724 L p .909 g
F P
0 g
s
.44547 .71151 m .47731 .72146 L .45318 .72822 L p .763 g
F P
0 g
s
.45318 .72822 m .40944 .72414 L .44547 .71151 L p .763 g
F P
0 g
s
.66766 .5359 m .65684 .5682 L .63297 .5302 L p .88 g
F P
0 g
s
.63297 .5302 m .64163 .48104 L .66766 .5359 L p .88 g
F P
0 g
s
.54303 .69739 m .54459 .68465 L .57907 .67259 L p .874 g
F P
0 g
s
.54459 .68465 m .54303 .69739 L .5104 .71058 L p .87 g
F P
0 g
s
.3033 .24044 m .32725 .22475 L .43894 .2111 L p .078 g
F P
0 g
s
.62139 .57724 m .63297 .5302 L .65684 .5682 L p .909 g
F P
0 g
s
.59335 .65105 m .57907 .67259 L .54459 .68465 L p .915 g
F P
0 g
s
.63846 .33552 m .64495 .3582 L .55247 .2849 L p .556 g
F P
0 g
s
.55247 .2849 m .55166 .25832 L .63846 .33552 L p .556 g
F P
0 g
s
.42752 .22351 m .43894 .2111 L .55049 .24733 L p .231 g
F P
0 g
s
.18344 .38357 m .18604 .43985 L .15877 .51519 L p .04 g
F P
0 g
s
.17577 .56623 m .15877 .51519 L .18604 .43985 L p .161 g
F P
0 g
s
.49535 .69746 m .5104 .71058 L .47731 .72146 L p .826 g
F P
0 g
s
.47731 .72146 m .44547 .71151 L .49535 .69746 L p .826 g
F P
0 g
s
.5104 .71058 m .49535 .69746 L .54459 .68465 L p .87 g
F P
0 g
s
.31327 .66863 m .36163 .70396 L .34568 .71944 L p .635 g
F P
0 g
s
.34568 .71944 m .29397 .69544 L .31327 .66863 L p .635 g
F P
0 g
s
.43894 .2111 m .42752 .22351 L .3033 .24044 L p .078 g
F P
0 g
s
.18604 .43985 m .20191 .50134 L .17577 .56623 L p .161 g
F P
0 g
s
.20558 .61579 m .17577 .56623 L .20191 .50134 L p .342 g
F P
0 g
s
.26817 .62051 m .31327 .66863 L .29397 .69544 L p .559 g
F P
0 g
s
.29397 .69544 m .24602 .66 L .26817 .62051 L p .559 g
F P
0 g
s
.3033 .24044 m .28653 .27303 L .19394 .33668 L p F P
s
.18344 .38357 m .19394 .33668 L .28653 .27303 L p .123 g
F P
0 g
s
.60783 .61854 m .59335 .65105 L .54631 .65652 L p .88 g
F P
0 g
s
.54459 .68465 m .54631 .65652 L .59335 .65105 L p .915 g
F P
0 g
s
.64495 .3582 m .6478 .39165 L .55285 .32573 L p .657 g
F P
0 g
s
.55285 .32573 m .55247 .2849 L .64495 .3582 L p .657 g
F P
0 g
s
.41046 .68407 m .44547 .71151 L .40944 .72414 L p .756 g
F P
0 g
s
.40944 .72414 m .36163 .70396 L .41046 .68407 L p .756 g
F P
0 g
s
.20191 .50134 m .23001 .56323 L .20558 .61579 L p .342 g
F P
0 g
s
.24602 .66 m .20558 .61579 L .23001 .56323 L p .465 g
F P
0 g
s
.23001 .56323 m .26817 .62051 L .24602 .66 L p .465 g
F P
0 g
s
.54631 .65652 m .54459 .68465 L .49535 .69746 L p .848 g
F P
0 g
s
.28653 .27303 m .3033 .24044 L .42752 .22351 L p .228 g
F P
0 g
s
.55166 .25832 m .55247 .2849 L .41954 .25329 L p .436 g
F P
0 g
s
.41954 .25329 m .42752 .22351 L .55166 .25832 L p .436 g
F P
0 g
s
.62139 .57724 m .60783 .61854 L .54805 .61444 L p .84 g
F P
0 g
s
.54631 .65652 m .54805 .61444 L .60783 .61854 L p .88 g
F P
0 g
s
.6478 .39165 m .64669 .43363 L .55274 .3781 L p .709 g
F P
0 g
s
.55274 .3781 m .55285 .32573 L .6478 .39165 L p .709 g
F P
0 g
s
.47877 .66706 m .49535 .69746 L .44547 .71151 L p .797 g
F P
0 g
s
.44547 .71151 m .41046 .68407 L .47877 .66706 L p .797 g
F P
0 g
s
.49535 .69746 m .47877 .66706 L .54631 .65652 L p .848 g
F P
0 g
s
.42752 .22351 m .41954 .25329 L .28653 .27303 L p .228 g
F P
0 g
s
.28653 .27303 m .27857 .32084 L .18344 .38357 L p .123 g
F P
0 g
s
.18604 .43985 m .18344 .38357 L .27857 .32084 L p .316 g
F P
0 g
s
.37485 .64046 m .41046 .68407 L .36163 .70396 L p .698 g
F P
0 g
s
.36163 .70396 m .31327 .66863 L .37485 .64046 L p .698 g
F P
0 g
s
.63297 .5302 m .62139 .57724 L .5497 .56121 L p .806 g
F P
0 g
s
.54805 .61444 m .5497 .56121 L .62139 .57724 L p .84 g
F P
0 g
s
.64669 .43363 m .64163 .48104 L .55214 .43806 L p .745 g
F P
0 g
s
.55214 .43806 m .55274 .3781 L .64669 .43363 L p .745 g
F P
0 g
s
.54805 .61444 m .54631 .65652 L .47877 .66706 L p .797 g
F P
0 g
s
.64163 .48104 m .63297 .5302 L .5511 .5008 L p .775 g
F P
0 g
s
.5497 .56121 m .5511 .5008 L .63297 .5302 L p .806 g
F P
0 g
s
.5511 .5008 m .55214 .43806 L .64163 .48104 L p .775 g
F P
0 g
s
.55247 .2849 m .55285 .32573 L .41578 .299 L p .539 g
F P
0 g
s
.41578 .299 m .41954 .25329 L .55247 .2849 L p .539 g
F P
0 g
s
.27857 .32084 m .28653 .27303 L .41954 .25329 L p .393 g
F P
0 g
s
.27857 .32084 m .28041 .38072 L .18604 .43985 L p .316 g
F P
0 g
s
.20191 .50134 m .18604 .43985 L .28041 .38072 L p .431 g
F P
0 g
s
.34148 .58356 m .37485 .64046 L .31327 .66863 L p .638 g
F P
0 g
s
.31327 .66863 m .26817 .62051 L .34148 .58356 L p .638 g
F P
0 g
s
.46186 .62087 m .47877 .66706 L .41046 .68407 L p .742 g
F P
0 g
s
.41046 .68407 m .37485 .64046 L .46186 .62087 L p .742 g
F P
0 g
s
.47877 .66706 m .46186 .62087 L .54805 .61444 L p .797 g
F P
0 g
s
.28041 .38072 m .2922 .44815 L .20191 .50134 L p .431 g
F P
0 g
s
.23001 .56323 m .20191 .50134 L .2922 .44815 L p .512 g
F P
0 g
s
.41954 .25329 m .41578 .299 L .27857 .32084 L p .393 g
F P
0 g
s
.31312 .51767 m .34148 .58356 L .26817 .62051 L p .578 g
F P
0 g
s
.26817 .62051 m .23001 .56323 L .31312 .51767 L p .578 g
F P
0 g
s
.2922 .44815 m .31312 .51767 L .23001 .56323 L p .512 g
F P
0 g
s
.5497 .56121 m .54805 .61444 L .46186 .62087 L p .753 g
F P
0 g
s
.55285 .32573 m .55274 .3781 L .41671 .3576 L p .599 g
F P
0 g
s
.41671 .3576 m .41578 .299 L .55285 .32573 L p .599 g
F P
0 g
s
.28041 .38072 m .27857 .32084 L .41578 .299 L p .487 g
F P
0 g
s
.44597 .56193 m .46186 .62087 L .37485 .64046 L p .691 g
F P
0 g
s
.37485 .64046 m .34148 .58356 L .44597 .56193 L p .691 g
F P
0 g
s
.5511 .5008 m .5497 .56121 L .44597 .56193 L p .714 g
F P
0 g
s
.46186 .62087 m .44597 .56193 L .5497 .56121 L p .753 g
F P
0 g
s
.55274 .3781 m .55214 .43806 L .42239 .42466 L p .642 g
F P
0 g
s
.42239 .42466 m .41671 .3576 L .55274 .3781 L p .642 g
F P
0 g
s
.41578 .299 m .41671 .3576 L .28041 .38072 L p .487 g
F P
0 g
s
.2922 .44815 m .28041 .38072 L .41671 .3576 L p .55 g
F P
0 g
s
.55214 .43806 m .5511 .5008 L .43242 .49471 L p .679 g
F P
0 g
s
.44597 .56193 m .43242 .49471 L .5511 .5008 L p .714 g
F P
0 g
s
.43242 .49471 m .42239 .42466 L .55214 .43806 L p .679 g
F P
0 g
s
.43242 .49471 m .44597 .56193 L .34148 .58356 L p .646 g
F P
0 g
s
.34148 .58356 m .31312 .51767 L .43242 .49471 L p .646 g
F P
0 g
s
.41671 .3576 m .42239 .42466 L .2922 .44815 L p .55 g
F P
0 g
s
.31312 .51767 m .2922 .44815 L .42239 .42466 L p .6 g
F P
0 g
s
.42239 .42466 m .43242 .49471 L .31312 .51767 L p .6 g
F P
0 g
s
.25 Mabswid
.51908 0 m
.96413 .59478 L
s
.96413 .59478 m
1 .99897 L
s
1 .99897 m
.51687 .44401 L
s
.51687 .44401 m
.51908 0 L
s
.04875 .18654 m
0 .62042 L
s
0 .62042 m
.51687 .44401 L
s
.51687 .44401 m
.51908 0 L
s
.51908 0 m
.04875 .18654 L
s
.04875 .18654 m
.51908 0 L
s
.05931 .18235 m
.06452 .18785 L
s
gsave
.04889 .17135 -81.0203 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.16652 .13983 m
.17158 .14547 L
s
gsave
.15639 .12856 -84.7341 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.27681 .09609 m
.28172 .10186 L
s
gsave
.26699 .08455 -68.8055 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.39032 .05107 m
.39506 .05698 L
s
gsave
.38085 .03925 -78.5661 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.25) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.5072 .00471 m
.51176 .01076 L
s
gsave
.49809 -0.00739 -74.2031 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08051 .17394 m
.08362 .17726 L
s
.10183 .16549 m
.10492 .16882 L
s
.12327 .15699 m
.12634 .16033 L
s
.14483 .14843 m
.14789 .1518 L
s
.18832 .13118 m
.19134 .13458 L
s
.21025 .12249 m
.21326 .1259 L
s
.23231 .11374 m
.2353 .11717 L
s
.2545 .10494 m
.25746 .10839 L
s
.29925 .08719 m
.30217 .09067 L
s
.32182 .07824 m
.32472 .08173 L
s
.34452 .06923 m
.34741 .07275 L
s
.36736 .06018 m
.37022 .06371 L
s
.41342 .04191 m
.41625 .04547 L
s
.43666 .03269 m
.43946 .03627 L
s
.46004 .02342 m
.46282 .02701 L
s
.48355 .01409 m
.48631 .01771 L
s
gsave
.21792 .02683 -68.4008 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.372331 0.321429 0.695396 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.11022e-16 1.16608 [
[.5 1.098 -17.375 0 ]
[.5 1.098 17.375 10 ]
[.09072 .22988 -13.7418 -10 ]
[.09072 .22988 .19568 0 ]
[.21906 .17566 -19.3756 -10 ]
[.21906 .17566 1.18695 0 ]
[.3545 .11847 -7.58187 -10 ]
[.3545 .11847 .85563 0 ]
[.49765 .05807 -12.8771 -10 ]
[.49765 .05807 2.18545 0 ]
[.64919 -0.00583 -6.8447 -10 ]
[.64919 -0.00583 1.5928 0 ]
[.30907 .06148 -7.18874 -10 ]
[.30907 .06148 .81126 0 ]
[.6933 .00644 0 -7.08817 ]
[.6933 .00644 13.9375 2.91183 ]
[.76325 .12052 0 -6.95638 ]
[.76325 .12052 20.5625 3.04362 ]
[.82642 .22355 0 -6.84024 ]
[.82642 .22355 8.4375 3.15976 ]
[.88375 .31706 0 -6.73712 ]
[.88375 .31706 15.0625 3.26288 ]
[.93601 .40232 0 -6.64494 ]
[.93601 .40232 8.4375 3.35506 ]
[.89481 .19838 0 -6.84024 ]
[.89481 .19838 8 3.15976 ]
[.07325 .26228 -13.9375 -2.90855 ]
[.07325 .26228 0 7.09145 ]
[.05474 .37813 -20.5625 -3.02288 ]
[.05474 .37813 0 6.97712 ]
[.03462 .5041 -8.4375 -3.14821 ]
[.03462 .5041 0 6.85179 ]
[.01266 .64157 -15.0625 -3.28621 ]
[.01266 .64157 0 6.71379 ]
[-0.01139 .79218 -8.4375 -3.43891 ]
[-0.01139 .79218 0 6.56109 ]
[-0.03373 .52941 -8 -3.14821 ]
[-0.03373 .52941 0 6.85179 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.098 -78.375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
67.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
72.125000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
93.750000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
gsave
.09072 .22988 -74.7418 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.22871 .18658 m
.23354 .19204 L
s
gsave
.21906 .17566 -80.3756 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.36358 .12987 m
.36813 .13557 L
s
gsave
.3545 .11847 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.50609 .06995 m
.51031 .07589 L
s
gsave
.49765 .05807 -73.877 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.65689 .00654 m
.66074 .01273 L
s
gsave
.64919 -0.00583 -67.8447 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
gsave
.30907 .06148 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.67985 .01205 m
.67313 .01486 L
s
gsave
.6933 .00644 -61 -11.0882 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.74968 .12583 m
.74289 .12848 L
s
gsave
.76325 .12052 -61 -10.9564 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.81274 .22858 m
.8059 .2311 L
s
gsave
.82642 .22355 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.86998 .32185 m
.86309 .32424 L
s
gsave
.88375 .31706 -61 -10.7371 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.92216 .40688 m
.91524 .40915 L
s
gsave
.93601 .40232 -61 -10.6449 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.69441 .03577 m
.69037 .03744 L
s
.70866 .059 m
.70461 .06064 L
s
.72262 .08174 m
.71856 .08337 L
s
.73629 .10401 m
.73222 .10562 L
s
.7628 .14721 m
.75872 .14878 L
s
.77566 .16816 m
.77157 .16972 L
s
.78826 .1887 m
.78417 .19024 L
s
.80062 .20884 m
.79652 .21036 L
s
.82463 .24795 m
.82052 .24945 L
s
.83629 .26695 m
.83217 .26843 L
s
.84773 .2856 m
.84361 .28706 L
s
.85896 .30389 m
.85483 .30534 L
s
.8808 .33948 m
.87666 .3409 L
s
.89142 .35678 m
.88728 .35819 L
s
.90185 .37378 m
.8977 .37518 L
s
.91209 .39048 m
.90795 .39186 L
s
gsave
.89481 .19838 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
gsave
.07325 .26228 -74.9375 -6.90855 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.0683 .37277 m
.07507 .37009 L
s
gsave
.05474 .37813 -81.5625 -7.02288 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.04829 .49904 m
.05512 .49651 L
s
gsave
.03462 .5041 -69.4375 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.02645 .63684 m
.03334 .63448 L
s
gsave
.01266 .64157 -76.0625 -7.28621 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00252 .78784 m
.00948 .78567 L
s
gsave
-0.01139 .79218 -69.4375 -7.43891 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08314 .27912 m
.08718 .27745 L
s
.07952 .30196 m
.08356 .30031 L
s
.07584 .32518 m
.07989 .32354 L
s
.0721 .34878 m
.07616 .34715 L
s
.06443 .39717 m
.0685 .39558 L
s
.0605 .42199 m
.06458 .42042 L
s
.0565 .44723 m
.06058 .44568 L
s
.05243 .47291 m
.05652 .47137 L
s
.04407 .52563 m
.04818 .52413 L
s
.03978 .55269 m
.0439 .55121 L
s
.03542 .58024 m
.03954 .57878 L
s
.03097 .60828 m
.0351 .60685 L
s
.02184 .66593 m
.02598 .66453 L
s
.01714 .69556 m
.0213 .69418 L
s
.01236 .72574 m
.01652 .72439 L
s
.00749 .7565 m
.01165 .75517 L
s
gsave
-0.03373 .52941 -69 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.46959 .53525 m .46274 .57135 L .52027 .57679 L p .657 g
F P
0 g
s
.52027 .57679 m .52092 .54021 L .46959 .53525 L p .657 g
F P
0 g
s
.51972 .61343 m .52027 .57679 L .46274 .57135 L p .645 g
F P
0 g
s
.52092 .54021 m .52027 .57679 L .57812 .57321 L p .629 g
F P
0 g
s
.52027 .57679 m .51972 .61343 L .58292 .60961 L p .613 g
F P
0 g
s
.58292 .60961 m .57812 .57321 L .52027 .57679 L p .613 g
F P
0 g
s
.46274 .57135 m .45685 .60762 L .51972 .61343 L p .645 g
F P
0 g
s
.51925 .64975 m .51972 .61343 L .45685 .60762 L p .632 g
F P
0 g
s
.51972 .61343 m .51925 .64975 L .58688 .64576 L p .597 g
F P
0 g
s
.58688 .64576 m .58292 .60961 L .51972 .61343 L p .597 g
F P
0 g
s
.47733 .49972 m .46959 .53525 L .52092 .54021 L p .669 g
F P
0 g
s
.52092 .54021 m .52166 .5041 L .47733 .49972 L p .669 g
F P
0 g
s
.52166 .5041 m .52092 .54021 L .57254 .53695 L p .644 g
F P
0 g
s
.57812 .57321 m .57254 .53695 L .52092 .54021 L p .629 g
F P
0 g
s
.57254 .53695 m .57812 .57321 L .63324 .56076 L p .602 g
F P
0 g
s
.57812 .57321 m .58292 .60961 L .64322 .59629 L p .583 g
F P
0 g
s
.64322 .59629 m .63324 .56076 L .57812 .57321 L p .583 g
F P
0 g
s
.58292 .60961 m .58688 .64576 L .65147 .63181 L p .563 g
F P
0 g
s
.65147 .63181 m .64322 .59629 L .58292 .60961 L p .563 g
F P
0 g
s
.42135 .52227 m .40857 .5571 L .46274 .57135 L p .688 g
F P
0 g
s
.46274 .57135 m .46959 .53525 L .42135 .52227 L p .688 g
F P
0 g
s
.45685 .60762 m .46274 .57135 L .40857 .5571 L p .679 g
F P
0 g
s
.57254 .53695 m .56624 .50122 L .52166 .5041 L p .644 g
F P
0 g
s
.56624 .50122 m .57254 .53695 L .62165 .52561 L p .62 g
F P
0 g
s
.63324 .56076 m .62165 .52561 L .57254 .53695 L p .602 g
F P
0 g
s
.45685 .60762 m .45198 .64367 L .51925 .64975 L p .632 g
F P
0 g
s
.5189 .68534 m .51925 .64975 L .45198 .64367 L p .617 g
F P
0 g
s
.51925 .64975 m .5189 .68534 L .58995 .68123 L p .58 g
F P
0 g
s
.58995 .68123 m .58688 .64576 L .51925 .64975 L p .58 g
F P
0 g
s
.40857 .5571 m .39755 .59237 L .45685 .60762 L p .679 g
F P
0 g
s
.45198 .64367 m .45685 .60762 L .39755 .59237 L p .668 g
F P
0 g
s
.43576 .4883 m .42135 .52227 L .46959 .53525 L p .697 g
F P
0 g
s
.46959 .53525 m .47733 .49972 L .43576 .4883 L p .697 g
F P
0 g
s
.48587 .46517 m .47733 .49972 L .52166 .5041 L p .681 g
F P
0 g
s
.52166 .5041 m .52247 .46885 L .48587 .46517 L p .681 g
F P
0 g
s
.52247 .46885 m .52166 .5041 L .56624 .50122 L p .658 g
F P
0 g
s
.58688 .64576 m .58995 .68123 L .65788 .6669 L p .542 g
F P
0 g
s
.65788 .6669 m .65147 .63181 L .58688 .64576 L p .542 g
F P
0 g
s
.56624 .50122 m .55928 .46643 L .52247 .46885 L p .658 g
F P
0 g
s
.55928 .46643 m .56624 .50122 L .60859 .49123 L p .638 g
F P
0 g
s
.62165 .52561 m .60859 .49123 L .56624 .50122 L p .62 g
F P
0 g
s
.39755 .59237 m .38844 .6277 L .45198 .64367 L p .668 g
F P
0 g
s
.4482 .67909 m .45198 .64367 L .38844 .6277 L p .656 g
F P
0 g
s
.45198 .64367 m .4482 .67909 L .5189 .68534 L p .617 g
F P
0 g
s
.45164 .45556 m .43576 .4883 L .47733 .49972 L p .705 g
F P
0 g
s
.47733 .49972 m .48587 .46517 L .45164 .45556 L p .705 g
F P
0 g
s
.51865 .71979 m .5189 .68534 L .4482 .67909 L p .601 g
F P
0 g
s
.5189 .68534 m .51865 .71979 L .59209 .71564 L p .561 g
F P
0 g
s
.59209 .71564 m .58995 .68123 L .5189 .68534 L p .561 g
F P
0 g
s
.62165 .52561 m .63324 .56076 L .6826 .5399 L p .575 g
F P
0 g
s
.63324 .56076 m .64322 .59629 L .69738 .57394 L p .552 g
F P
0 g
s
.69738 .57394 m .6826 .5399 L .63324 .56076 L p .552 g
F P
0 g
s
.60859 .49123 m .62165 .52561 L .66548 .50664 L p .598 g
F P
0 g
s
.6826 .5399 m .66548 .50664 L .62165 .52561 L p .575 g
F P
0 g
s
.49514 .43199 m .48587 .46517 L .52247 .46885 L p .692 g
F P
0 g
s
.52247 .46885 m .52335 .43488 L .49514 .43199 L p .692 g
F P
0 g
s
.52335 .43488 m .52247 .46885 L .55928 .46643 L p .673 g
F P
0 g
s
.58995 .68123 m .59209 .71564 L .66235 .70114 L p .519 g
F P
0 g
s
.66235 .70114 m .65788 .6669 L .58995 .68123 L p .519 g
F P
0 g
s
.64322 .59629 m .65147 .63181 L .70963 .60837 L p .528 g
F P
0 g
s
.70963 .60837 m .69738 .57394 L .64322 .59629 L p .528 g
F P
0 g
s
.37897 .50182 m .36079 .53459 L .40857 .5571 L p .723 g
F P
0 g
s
.40857 .5571 m .42135 .52227 L .37897 .50182 L p .723 g
F P
0 g
s
.39755 .59237 m .40857 .5571 L .36079 .53459 L p .716 g
F P
0 g
s
.55928 .46643 m .55173 .43298 L .52335 .43488 L p .673 g
F P
0 g
s
.55173 .43298 m .55928 .46643 L .59418 .45802 L p .657 g
F P
0 g
s
.60859 .49123 m .59418 .45802 L .55928 .46643 L p .638 g
F P
0 g
s
.39941 .47034 m .37897 .50182 L .42135 .52227 L p .728 g
F P
0 g
s
.42135 .52227 m .43576 .4883 L .39941 .47034 L p .728 g
F P
0 g
s
.59418 .45802 m .60859 .49123 L .64622 .47456 L p .62 g
F P
0 g
s
.66548 .50664 m .64622 .47456 L .60859 .49123 L p .598 g
F P
0 g
s
.38844 .6277 m .38136 .66267 L .4482 .67909 L p .656 g
F P
0 g
s
.44557 .71347 m .4482 .67909 L .38136 .66267 L p .641 g
F P
0 g
s
.4482 .67909 m .44557 .71347 L .51865 .71979 L p .601 g
F P
0 g
s
.46883 .42446 m .45164 .45556 L .48587 .46517 L p .712 g
F P
0 g
s
.48587 .46517 m .49514 .43199 L .46883 .42446 L p .712 g
F P
0 g
s
.36079 .53459 m .34507 .56824 L .39755 .59237 L p .716 g
F P
0 g
s
.38844 .6277 m .39755 .59237 L .34507 .56824 L p .708 g
F P
0 g
s
.42185 .4405 m .39941 .47034 L .43576 .4883 L p .732 g
F P
0 g
s
.43576 .4883 m .45164 .45556 L .42185 .4405 L p .732 g
F P
0 g
s
.65147 .63181 m .65788 .6669 L .71917 .64278 L p .501 g
F P
0 g
s
.71917 .64278 m .70963 .60837 L .65147 .63181 L p .501 g
F P
0 g
s
.51851 .75269 m .51865 .71979 L .44557 .71347 L p .581 g
F P
0 g
s
.51865 .71979 m .51851 .75269 L .59325 .74856 L p .539 g
F P
0 g
s
.59325 .74856 m .59209 .71564 L .51865 .71979 L p .539 g
F P
0 g
s
.59418 .45802 m .57858 .42639 L .55173 .43298 L p .657 g
F P
0 g
s
.57858 .42639 m .59418 .45802 L .62506 .44404 L p .643 g
F P
0 g
s
.64622 .47456 m .62506 .44404 L .59418 .45802 L p .62 g
F P
0 g
s
.34507 .56824 m .33205 .60239 L .38844 .6277 L p .708 g
F P
0 g
s
.38136 .66267 m .38844 .6277 L .33205 .60239 L p .699 g
F P
0 g
s
.44605 .41268 m .42185 .4405 L .45164 .45556 L p .734 g
F P
0 g
s
.45164 .45556 m .46883 .42446 L .44605 .41268 L p .734 g
F P
0 g
s
.59209 .71564 m .59325 .74856 L .66477 .73412 L p .493 g
F P
0 g
s
.66477 .73412 m .66235 .70114 L .59209 .71564 L p .493 g
F P
0 g
s
.50504 .40061 m .49514 .43199 L .52335 .43488 L p .703 g
F P
0 g
s
.52335 .43488 m .52429 .40262 L .50504 .40061 L p .703 g
F P
0 g
s
.52429 .40262 m .52335 .43488 L .55173 .43298 L p .689 g
F P
0 g
s
.55173 .43298 m .54366 .4013 L .52429 .40262 L p .689 g
F P
0 g
s
.54366 .4013 m .55173 .43298 L .57858 .42639 L p .676 g
F P
0 g
s
.38136 .66267 m .37643 .69687 L .44557 .71347 L p .641 g
F P
0 g
s
.44415 .7464 m .44557 .71347 L .37643 .69687 L p .624 g
F P
0 g
s
.44557 .71347 m .44415 .7464 L .51851 .75269 L p .581 g
F P
0 g
s
.48714 .39538 m .46883 .42446 L .49514 .43199 L p .719 g
F P
0 g
s
.49514 .43199 m .50504 .40061 L .48714 .39538 L p .719 g
F P
0 g
s
.65788 .6669 m .66235 .70114 L .72581 .67673 L p .472 g
F P
0 g
s
.72581 .67673 m .71917 .64278 L .65788 .6669 L p .472 g
F P
0 g
s
.64622 .47456 m .66548 .50664 L .70131 .48091 L p .577 g
F P
0 g
s
.66548 .50664 m .6826 .5399 L .7232 .5115 L p .549 g
F P
0 g
s
.7232 .5115 m .70131 .48091 L .66548 .50664 L p .549 g
F P
0 g
s
.62506 .44404 m .64622 .47456 L .67679 .45203 L p .604 g
F P
0 g
s
.70131 .48091 m .67679 .45203 L .64622 .47456 L p .577 g
F P
0 g
s
.6826 .5399 m .69738 .57394 L .74217 .54343 L p .519 g
F P
0 g
s
.74217 .54343 m .7232 .5115 L .6826 .5399 L p .519 g
F P
0 g
s
.57858 .42639 m .56194 .39672 L .54366 .4013 L p .676 g
F P
0 g
s
.56194 .39672 m .57858 .42639 L .60222 .41545 L p .666 g
F P
0 g
s
.62506 .44404 m .60222 .41545 L .57858 .42639 L p .643 g
F P
0 g
s
.33205 .60239 m .32191 .63661 L .38136 .66267 L p .699 g
F P
0 g
s
.37643 .69687 m .38136 .66267 L .32191 .63661 L p .686 g
F P
0 g
s
.37058 .44671 m .34512 .47482 L .37897 .50182 L p .763 g
F P
0 g
s
.37897 .50182 m .39941 .47034 L .37058 .44671 L p .763 g
F P
0 g
s
.36079 .53459 m .37897 .50182 L .34512 .47482 L p .762 g
F P
0 g
s
.47172 .38725 m .44605 .41268 L .46883 .42446 L p .736 g
F P
0 g
s
.46883 .42446 m .48714 .39538 L .47172 .38725 L p .736 g
F P
0 g
s
.39842 .42077 m .37058 .44671 L .39941 .47034 L p .761 g
F P
0 g
s
.39941 .47034 m .42185 .4405 L .39842 .42077 L p .761 g
F P
0 g
s
.5185 .7836 m .51851 .75269 L .44415 .7464 L p .559 g
F P
0 g
s
.51851 .75269 m .5185 .7836 L .59339 .77954 L p .513 g
F P
0 g
s
.59339 .77954 m .59325 .74856 L .51851 .75269 L p .513 g
F P
0 g
s
.60222 .41545 m .62506 .44404 L .64995 .4252 L p .631 g
F P
0 g
s
.67679 .45203 m .64995 .4252 L .62506 .44404 L p .604 g
F P
0 g
s
.69738 .57394 m .70963 .60837 L .75793 .5763 L p .487 g
F P
0 g
s
.75793 .5763 m .74217 .54343 L .69738 .57394 L p .487 g
F P
0 g
s
.34512 .47482 m .32236 .50477 L .36079 .53459 L p .762 g
F P
0 g
s
.34507 .56824 m .36079 .53459 L .32236 .50477 L p .76 g
F P
0 g
s
.4283 .39733 m .39842 .42077 L .42185 .4405 L p .758 g
F P
0 g
s
.42185 .4405 m .44605 .41268 L .4283 .39733 L p .758 g
F P
0 g
s
.59325 .74856 m .59339 .77954 L .66506 .76537 L p .462 g
F P
0 g
s
.66506 .76537 m .66477 .73412 L .59325 .74856 L p .462 g
F P
0 g
s
.66235 .70114 m .66477 .73412 L .72942 .70979 L p .438 g
F P
0 g
s
.72942 .70979 m .72581 .67673 L .66235 .70114 L p .438 g
F P
0 g
s
.51547 .37145 m .50504 .40061 L .52429 .40262 L p .714 g
F P
0 g
s
.52429 .40262 m .52528 .37249 L .51547 .37145 L p .714 g
F P
0 g
s
.52528 .37249 m .52429 .40262 L .54366 .4013 L p .705 g
F P
0 g
s
.32236 .50477 m .30263 .53618 L .34507 .56824 L p .76 g
F P
0 g
s
.33205 .60239 m .34507 .56824 L .30263 .53618 L p .755 g
F P
0 g
s
.54366 .4013 m .53516 .37181 L .52528 .37249 L p .705 g
F P
0 g
s
.53516 .37181 m .54366 .4013 L .56194 .39672 L p .696 g
F P
0 g
s
.37643 .69687 m .37375 .72986 L .44415 .7464 L p .624 g
F P
0 g
s
.44397 .77743 m .44415 .7464 L .37375 .72986 L p .603 g
F P
0 g
s
.44415 .7464 m .44397 .77743 L .5185 .7836 L p .559 g
F P
0 g
s
.50637 .36875 m .48714 .39538 L .50504 .40061 L p .724 g
F P
0 g
s
.50504 .40061 m .51547 .37145 L .50637 .36875 L p .724 g
F P
0 g
s
.60222 .41545 m .57796 .38916 L .56194 .39672 L p .666 g
F P
0 g
s
.57796 .38916 m .60222 .41545 L .62113 .40077 L p .658 g
F P
0 g
s
.64995 .4252 m .62113 .40077 L .60222 .41545 L p .631 g
F P
0 g
s
.70963 .60837 m .71917 .64278 L .77022 .60971 L p .452 g
F P
0 g
s
.77022 .60971 m .75793 .5763 L .70963 .60837 L p .452 g
F P
0 g
s
.32191 .63661 m .31483 .67049 L .37643 .69687 L p .686 g
F P
0 g
s
.37375 .72986 m .37643 .69687 L .31483 .67049 L p .671 g
F P
0 g
s
.45983 .37669 m .4283 .39733 L .44605 .41268 L p .754 g
F P
0 g
s
.44605 .41268 m .47172 .38725 L .45983 .37669 L p .754 g
F P
0 g
s
.56194 .39672 m .54446 .36944 L .53516 .37181 L p .696 g
F P
0 g
s
.54446 .36944 m .56194 .39672 L .57796 .38916 L p .69 g
F P
0 g
s
.49859 .36456 m .47172 .38725 L .48714 .39538 L p .735 g
F P
0 g
s
.48714 .39538 m .50637 .36875 L .49859 .36456 L p .735 g
F P
0 g
s
.30263 .53618 m .28623 .56867 L .33205 .60239 L p .755 g
F P
0 g
s
.32191 .63661 m .33205 .60239 L .28623 .56867 L p .749 g
F P
0 g
s
.64995 .4252 m .67679 .45203 L .69815 .42478 L p .59 g
F P
0 g
s
.67679 .45203 m .70131 .48091 L .72665 .44966 L p .556 g
F P
0 g
s
.72665 .44966 m .69815 .42478 L .67679 .45203 L p .556 g
F P
0 g
s
.62113 .40077 m .64995 .4252 L .66712 .40254 L p .622 g
F P
0 g
s
.69815 .42478 m .66712 .40254 L .64995 .4252 L p .59 g
F P
0 g
s
.57796 .38916 m .55256 .36554 L .54446 .36944 L p .69 g
F P
0 g
s
.55256 .36554 m .57796 .38916 L .59067 .37906 L p .686 g
F P
0 g
s
.62113 .40077 m .59067 .37906 L .57796 .38916 L p .658 g
F P
0 g
s
.5186 .81208 m .5185 .7836 L .44397 .77743 L p .531 g
F P
0 g
s
.5185 .7836 m .5186 .81208 L .59248 .80815 L p .482 g
F P
0 g
s
.59248 .80815 m .59339 .77954 L .5185 .7836 L p .482 g
F P
0 g
s
.71917 .64278 m .72581 .67673 L .77881 .64323 L p .412 g
F P
0 g
s
.77881 .64323 m .77022 .60971 L .71917 .64278 L p .412 g
F P
0 g
s
.70131 .48091 m .7232 .5115 L .75221 .47687 L p .52 g
F P
0 g
s
.75221 .47687 m .72665 .44966 L .70131 .48091 L p .52 g
F P
0 g
s
.49264 .35914 m .45983 .37669 L .47172 .38725 L p .746 g
F P
0 g
s
.47172 .38725 m .49859 .36456 L .49264 .35914 L p .746 g
F P
0 g
s
.66477 .73412 m .66506 .76537 L .72986 .7415 L p .398 g
F P
0 g
s
.72986 .7415 m .72942 .70979 L .66477 .73412 L p .398 g
F P
0 g
s
.59067 .37906 m .62113 .40077 L .63399 .38321 L p .653 g
F P
0 g
s
.66712 .40254 m .63399 .38321 L .62113 .40077 L p .622 g
F P
0 g
s
.41684 .3793 m .38305 .39748 L .39842 .42077 L p .783 g
F P
0 g
s
.39842 .42077 m .4283 .39733 L .41684 .3793 L p .783 g
F P
0 g
s
.37058 .44671 m .39842 .42077 L .38305 .39748 L p .793 g
F P
0 g
s
.38305 .39748 m .35137 .41867 L .37058 .44671 L p .793 g
F P
0 g
s
.34512 .47482 m .37058 .44671 L .35137 .41867 L p .801 g
F P
0 g
s
.59339 .77954 m .59248 .80815 L .66316 .79445 L p .424 g
F P
0 g
s
.66316 .79445 m .66506 .76537 L .59339 .77954 L p .424 g
F P
0 g
s
.7232 .5115 m .74217 .54343 L .77445 .50609 L p .481 g
F P
0 g
s
.77445 .50609 m .75221 .47687 L .7232 .5115 L p .481 g
F P
0 g
s
.45229 .36437 m .41684 .3793 L .4283 .39733 L p .771 g
F P
0 g
s
.4283 .39733 m .45983 .37669 L .45229 .36437 L p .771 g
F P
0 g
s
.52528 .37249 m .52632 .34495 L .51547 .37145 L closepath p .725 g
F P
0 g
s
.53516 .37181 m .52632 .34495 L .52528 .37249 L closepath p .721 g
F P
0 g
s
.35137 .41867 m .32225 .44262 L .34512 .47482 L p .801 g
F P
0 g
s
.32236 .50477 m .34512 .47482 L .32225 .44262 L p .807 g
F P
0 g
s
.37375 .72986 m .37343 .7612 L .44397 .77743 L p .603 g
F P
0 g
s
.4451 .80611 m .44397 .77743 L .37343 .7612 L p .577 g
F P
0 g
s
.44397 .77743 m .4451 .80611 L .5186 .81208 L p .531 g
F P
0 g
s
.28623 .56867 m .27342 .60184 L .32191 .63661 L p .749 g
F P
0 g
s
.31483 .67049 m .32191 .63661 L .27342 .60184 L p .739 g
F P
0 g
s
.54446 .36944 m .52632 .34495 L .53516 .37181 L closepath p .718 g
F P
0 g
s
.31483 .67049 m .31099 .70357 L .37375 .72986 L p .671 g
F P
0 g
s
.37343 .7612 m .37375 .72986 L .31099 .70357 L p .65 g
F P
0 g
s
.51547 .37145 m .52632 .34495 L .50637 .36875 L closepath p .729 g
F P
0 g
s
.59067 .37906 m .55893 .36035 L .55256 .36554 L p .686 g
F P
0 g
s
.55893 .36035 m .59067 .37906 L .59917 .36703 L p .683 g
F P
0 g
s
.63399 .38321 m .59917 .36703 L .59067 .37906 L p .653 g
F P
0 g
s
.55256 .36554 m .52632 .34495 L .54446 .36944 L closepath p .716 g
F P
0 g
s
.50637 .36875 m .52632 .34495 L .49859 .36456 L closepath p .733 g
F P
0 g
s
.48894 .35286 m .45229 .36437 L .45983 .37669 L p .757 g
F P
0 g
s
.45983 .37669 m .49264 .35914 L .48894 .35286 L p .757 g
F P
0 g
s
.32225 .44262 m .2961 .46905 L .32236 .50477 L p .807 g
F P
0 g
s
.30263 .53618 m .32236 .50477 L .2961 .46905 L p .811 g
F P
0 g
s
.55893 .36035 m .52632 .34495 L .55256 .36554 L closepath p .715 g
F P
0 g
s
.74217 .54343 m .75793 .5763 L .79299 .53694 L p .437 g
F P
0 g
s
.79299 .53694 m .77445 .50609 L .74217 .54343 L p .437 g
F P
0 g
s
.49859 .36456 m .52632 .34495 L .49264 .35914 L closepath p .736 g
F P
0 g
s
.72581 .67673 m .72942 .70979 L .78347 .67639 L p .366 g
F P
0 g
s
.78347 .67639 m .77881 .64323 L .72581 .67673 L p .366 g
F P
0 g
s
.56313 .35422 m .52632 .34495 L .55893 .36035 L closepath p .714 g
F P
0 g
s
.59917 .36703 m .56313 .35422 L .55893 .36035 L p .683 g
F P
0 g
s
.49264 .35914 m .52632 .34495 L .48894 .35286 L closepath p .74 g
F P
0 g
s
.59917 .36703 m .63399 .38321 L .63977 .36385 L p .651 g
F P
0 g
s
.63399 .38321 m .66712 .40254 L .67516 .3774 L p .616 g
F P
0 g
s
.67516 .3774 m .63977 .36385 L .63399 .38321 L p .616 g
F P
0 g
s
.56313 .35422 m .59917 .36703 L .60283 .35386 L p .684 g
F P
0 g
s
.63977 .36385 m .60283 .35386 L .59917 .36703 L p .651 g
F P
0 g
s
.2961 .46905 m .27332 .49764 L .30263 .53618 L p .811 g
F P
0 g
s
.28623 .56867 m .30263 .53618 L .27332 .49764 L p .812 g
F P
0 g
s
.27342 .60184 m .26448 .63525 L .31483 .67049 L p .739 g
F P
0 g
s
.31099 .70357 m .31483 .67049 L .26448 .63525 L p .724 g
F P
0 g
s
.66712 .40254 m .69815 .42478 L .70851 .39437 L p .578 g
F P
0 g
s
.70851 .39437 m .67516 .3774 L .66712 .40254 L p .578 g
F P
0 g
s
.66506 .76537 m .66316 .79445 L .72701 .77138 L p .35 g
F P
0 g
s
.72701 .77138 m .72986 .7415 L .66506 .76537 L p .35 g
F P
0 g
s
.51884 .83766 m .5186 .81208 L .4451 .80611 L p .494 g
F P
0 g
s
.5186 .81208 m .51884 .83766 L .59048 .83393 L p .442 g
F P
0 g
s
.59048 .83393 m .59248 .80815 L .5186 .81208 L p .442 g
F P
0 g
s
.48776 .34612 m .44969 .35106 L .45229 .36437 L p .766 g
F P
0 g
s
.45229 .36437 m .48894 .35286 L .48776 .34612 L p .766 g
F P
0 g
s
.41684 .3793 m .45229 .36437 L .44969 .35106 L p .788 g
F P
0 g
s
.44969 .35106 m .41261 .35971 L .41684 .3793 L p .788 g
F P
0 g
s
.38305 .39748 m .41684 .3793 L .41261 .35971 L p .808 g
F P
0 g
s
.75793 .5763 m .77022 .60971 L .80749 .56905 L p .387 g
F P
0 g
s
.80749 .56905 m .79299 .53694 L .75793 .5763 L p .387 g
F P
0 g
s
.56484 .34754 m .52632 .34495 L .56313 .35422 L closepath p .715 g
F P
0 g
s
.60283 .35386 m .56484 .34754 L .56313 .35422 L p .684 g
F P
0 g
s
.48894 .35286 m .52632 .34495 L .48776 .34612 L closepath p .743 g
F P
0 g
s
.69815 .42478 m .72665 .44966 L .73931 .41459 L p .535 g
F P
0 g
s
.73931 .41459 m .70851 .39437 L .69815 .42478 L p .535 g
F P
0 g
s
.41261 .35971 m .37704 .37201 L .38305 .39748 L p .808 g
F P
0 g
s
.35137 .41867 m .38305 .39748 L .37704 .37201 L p .826 g
F P
0 g
s
.59248 .80815 m .59048 .83393 L .65899 .82088 L p .376 g
F P
0 g
s
.65899 .82088 m .66316 .79445 L .59248 .80815 L p .376 g
F P
0 g
s
.31099 .70357 m .31053 .73539 L .37343 .7612 L p .65 g
F P
0 g
s
.37554 .79041 m .37343 .7612 L .31053 .73539 L p .623 g
F P
0 g
s
.37343 .7612 m .37554 .79041 L .4451 .80611 L p .577 g
F P
0 g
s
.44755 .83198 m .4451 .80611 L .37554 .79041 L p .541 g
F P
0 g
s
.4451 .80611 m .44755 .83198 L .51884 .83766 L p .494 g
F P
0 g
s
.56393 .34076 m .52632 .34495 L .56484 .34754 L closepath p .716 g
F P
0 g
s
.48776 .34612 m .52632 .34495 L .48922 .33939 L closepath p .745 g
F P
0 g
s
.56044 .33436 m .52632 .34495 L .56393 .34076 L closepath p .719 g
F P
0 g
s
.55457 .32877 m .52632 .34495 L .56044 .33436 L closepath p .722 g
F P
0 g
s
.54673 .3244 m .52632 .34495 L .55457 .32877 L closepath p .726 g
F P
0 g
s
.49323 .33312 m .52632 .34495 L .49954 .32775 L closepath p .746 g
F P
0 g
s
.48922 .33939 m .52632 .34495 L .49323 .33312 L closepath p .746 g
F P
0 g
s
.53745 .32156 m .52632 .34495 L .54673 .3244 L closepath p .73 g
F P
0 g
s
.49954 .32775 m .52632 .34495 L .50773 .32367 L closepath p .744 g
F P
0 g
s
.52738 .32046 m .52632 .34495 L .53745 .32156 L closepath p .735 g
F P
0 g
s
.51723 .32118 m .52632 .34495 L .52738 .32046 L closepath p .739 g
F P
0 g
s
.50773 .32367 m .52632 .34495 L .51723 .32118 L closepath p .742 g
F P
0 g
s
.56484 .34754 m .60283 .35386 L .60129 .3404 L p .687 g
F P
0 g
s
.60129 .3404 m .56393 .34076 L .56484 .34754 L p .687 g
F P
0 g
s
.72942 .70979 m .72986 .7415 L .78404 .70871 L p .31 g
F P
0 g
s
.78404 .70871 m .78347 .67639 L .72942 .70979 L p .31 g
F P
0 g
s
.44969 .35106 m .48776 .34612 L .48922 .33939 L p .774 g
F P
0 g
s
.37704 .37201 m .34348 .38783 L .35137 .41867 L p .826 g
F P
0 g
s
.32225 .44262 m .35137 .41867 L .34348 .38783 L p .843 g
F P
0 g
s
.27332 .49764 m .25432 .52803 L .28623 .56867 L p .812 g
F P
0 g
s
.27342 .60184 m .28623 .56867 L .25432 .52803 L p .809 g
F P
0 g
s
.72665 .44966 m .75221 .47687 L .76709 .43783 L p .488 g
F P
0 g
s
.76709 .43783 m .73931 .41459 L .72665 .44966 L p .488 g
F P
0 g
s
.60283 .35386 m .63977 .36385 L .63787 .34393 L p .654 g
F P
0 g
s
.63787 .34393 m .60129 .3404 L .60283 .35386 L p .654 g
F P
0 g
s
.48922 .33939 m .45232 .33766 L .44969 .35106 L p .774 g
F P
0 g
s
.41261 .35971 m .44969 .35106 L .45232 .33766 L p .802 g
F P
0 g
s
.56393 .34076 m .60129 .3404 L .59455 .32759 L p .693 g
F P
0 g
s
.59455 .32759 m .56044 .33436 L .56393 .34076 L p .693 g
F P
0 g
s
.77022 .60971 m .77881 .64323 L .81765 .60196 L p .328 g
F P
0 g
s
.81765 .60196 m .80749 .56905 L .77022 .60971 L p .328 g
F P
0 g
s
.45232 .33766 m .48922 .33939 L .49323 .33312 L p .778 g
F P
0 g
s
.26448 .63525 m .25961 .66843 L .31099 .70357 L p .724 g
F P
0 g
s
.31053 .73539 m .31099 .70357 L .25961 .66843 L p .702 g
F P
0 g
s
.63977 .36385 m .67516 .3774 L .67315 .35136 L p .615 g
F P
0 g
s
.67315 .35136 m .63787 .34393 L .63977 .36385 L p .615 g
F P
0 g
s
.34348 .38783 m .31244 .40702 L .32225 .44262 L p .843 g
F P
0 g
s
.2961 .46905 m .32225 .44262 L .31244 .40702 L p .857 g
F P
0 g
s
.75221 .47687 m .77445 .50609 L .79136 .46382 L p .432 g
F P
0 g
s
.79136 .46382 m .76709 .43783 L .75221 .47687 L p .432 g
F P
0 g
s
.45232 .33766 m .41614 .33985 L .41261 .35971 L p .802 g
F P
0 g
s
.37704 .37201 m .41261 .35971 L .41614 .33985 L p .83 g
F P
0 g
s
.56044 .33436 m .59455 .32759 L .58299 .31634 L p .702 g
F P
0 g
s
.58299 .31634 m .55457 .32877 L .56044 .33436 L p .702 g
F P
0 g
s
.66316 .79445 m .65899 .82088 L .72081 .79892 L p .288 g
F P
0 g
s
.72081 .79892 m .72701 .77138 L .66316 .79445 L p .288 g
F P
0 g
s
.46011 .3251 m .49323 .33312 L .49954 .32775 L p .778 g
F P
0 g
s
.49323 .33312 m .46011 .3251 L .45232 .33766 L p .778 g
F P
0 g
s
.25432 .52803 m .23944 .55982 L .27342 .60184 L p .809 g
F P
0 g
s
.26448 .63525 m .27342 .60184 L .23944 .55982 L p .8 g
F P
0 g
s
.67516 .3774 m .70851 .39437 L .70661 .3627 L p .569 g
F P
0 g
s
.70661 .3627 m .67315 .35136 L .67516 .3774 L p .569 g
F P
0 g
s
.60129 .3404 m .63787 .34393 L .62818 .32483 L p .661 g
F P
0 g
s
.62818 .32483 m .59455 .32759 L .60129 .3404 L p .661 g
F P
0 g
s
.5192 .85988 m .51884 .83766 L .44755 .83198 L p .445 g
F P
0 g
s
.51884 .83766 m .5192 .85988 L .58739 .85639 L p .388 g
F P
0 g
s
.58739 .85639 m .59048 .83393 L .51884 .83766 L p .388 g
F P
0 g
s
.55457 .32877 m .58299 .31634 L .56735 .3075 L p .714 g
F P
0 g
s
.56735 .3075 m .54673 .3244 L .55457 .32877 L p .714 g
F P
0 g
s
.41614 .33985 m .45232 .33766 L .46011 .3251 L p .811 g
F P
0 g
s
.31053 .73539 m .31355 .76547 L .37554 .79041 L p .623 g
F P
0 g
s
.38014 .81703 m .37554 .79041 L .31355 .76547 L p .584 g
F P
0 g
s
.37554 .79041 m .38014 .81703 L .44755 .83198 L p .541 g
F P
0 g
s
.47259 .31428 m .49954 .32775 L .50773 .32367 L p .775 g
F P
0 g
s
.49954 .32775 m .47259 .31428 L .46011 .3251 L p .778 g
F P
0 g
s
.31244 .40702 m .28442 .42938 L .2961 .46905 L p .857 g
F P
0 g
s
.27332 .49764 m .2961 .46905 L .28442 .42938 L p .869 g
F P
0 g
s
.72986 .7415 m .72701 .77138 L .78036 .7397 L p .24 g
F P
0 g
s
.78036 .7397 m .78404 .70871 L .72986 .7415 L p .24 g
F P
0 g
s
.41614 .33985 m .38119 .34601 L .37704 .37201 L p .83 g
F P
0 g
s
.34348 .38783 m .37704 .37201 L .38119 .34601 L p .858 g
F P
0 g
s
.59048 .83393 m .58739 .85639 L .65253 .84417 L p .313 g
F P
0 g
s
.65253 .84417 m .65899 .82088 L .59048 .83393 L p .313 g
F P
0 g
s
.54673 .3244 m .56735 .3075 L .54873 .30173 L p .728 g
F P
0 g
s
.54873 .30173 m .53745 .32156 L .54673 .3244 L p .728 g
F P
0 g
s
.77881 .64323 m .78347 .67639 L .82317 .6352 L p .256 g
F P
0 g
s
.82317 .6352 m .81765 .60196 L .77881 .64323 L p .256 g
F P
0 g
s
.77445 .50609 m .79299 .53694 L .81169 .49224 L p .366 g
F P
0 g
s
.81169 .49224 m .79136 .46382 L .77445 .50609 L p .366 g
F P
0 g
s
.48894 .30603 m .50773 .32367 L .51723 .32118 L p .767 g
F P
0 g
s
.50773 .32367 m .48894 .30603 L .47259 .31428 L p .775 g
F P
0 g
s
.45136 .85456 m .44755 .83198 L .38014 .81703 L p .491 g
F P
0 g
s
.44755 .83198 m .45136 .85456 L .5192 .85988 L p .445 g
F P
0 g
s
.53745 .32156 m .54873 .30173 L .52846 .2995 L p .742 g
F P
0 g
s
.52846 .2995 m .52738 .32046 L .53745 .32156 L p .742 g
F P
0 g
s
.50803 .30097 m .51723 .32118 L .52738 .32046 L p .755 g
F P
0 g
s
.51723 .32118 m .50803 .30097 L .48894 .30603 L p .767 g
F P
0 g
s
.70851 .39437 m .73931 .41459 L .73771 .37786 L p .515 g
F P
0 g
s
.73771 .37786 m .70661 .3627 L .70851 .39437 L p .515 g
F P
0 g
s
.52738 .32046 m .52846 .2995 L .50803 .30097 L p .755 g
F P
0 g
s
.63787 .34393 m .67315 .35136 L .66082 .32625 L p .62 g
F P
0 g
s
.66082 .32625 m .62818 .32483 L .63787 .34393 L p .62 g
F P
0 g
s
.25961 .66843 m .25902 .7009 L .31053 .73539 L p .702 g
F P
0 g
s
.31355 .76547 m .31053 .73539 L .25902 .7009 L p .669 g
F P
0 g
s
.59455 .32759 m .62818 .32483 L .61116 .30797 L p .674 g
F P
0 g
s
.61116 .30797 m .58299 .31634 L .59455 .32759 L p .674 g
F P
0 g
s
.42741 .32111 m .46011 .3251 L .47259 .31428 L p .813 g
F P
0 g
s
.46011 .3251 m .42741 .32111 L .41614 .33985 L p .811 g
F P
0 g
s
.38119 .34601 m .41614 .33985 L .42741 .32111 L p .846 g
F P
0 g
s
.23944 .55982 m .22903 .59258 L .26448 .63525 L p .8 g
F P
0 g
s
.25961 .66843 m .26448 .63525 L .22903 .59258 L p .784 g
F P
0 g
s
.28442 .42938 m .2599 .45464 L .27332 .49764 L p .869 g
F P
0 g
s
.25432 .52803 m .27332 .49764 L .2599 .45464 L p .876 g
F P
0 g
s
.38119 .34601 m .34801 .35616 L .34348 .38783 L p .858 g
F P
0 g
s
.31244 .40702 m .34348 .38783 L .34801 .35616 L p .884 g
F P
0 g
s
.79299 .53694 m .80749 .56905 L .82764 .52273 L p .286 g
F P
0 g
s
.82764 .52273 m .81169 .49224 L .79299 .53694 L p .286 g
F P
0 g
s
.73931 .41459 m .76709 .43783 L .7659 .39672 L p .447 g
F P
0 g
s
.7659 .39672 m .73771 .37786 L .73931 .41459 L p .447 g
F P
0 g
s
.65899 .82088 m .65253 .84417 L .7112 .82364 L p .205 g
F P
0 g
s
.7112 .82364 m .72081 .79892 L .65899 .82088 L p .205 g
F P
0 g
s
.58299 .31634 m .61116 .30797 L .58789 .29464 L p .692 g
F P
0 g
s
.58789 .29464 m .56735 .3075 L .58299 .31634 L p .692 g
F P
0 g
s
.78347 .67639 m .78404 .70871 L .82384 .66828 L p .168 g
F P
0 g
s
.82384 .66828 m .82317 .6352 L .78347 .67639 L p .168 g
F P
0 g
s
.44583 .30487 m .47259 .31428 L .48894 .30603 L p .807 g
F P
0 g
s
.47259 .31428 m .44583 .30487 L .42741 .32111 L p .813 g
F P
0 g
s
.67315 .35136 m .70661 .3627 L .69197 .33195 L p .565 g
F P
0 g
s
.69197 .33195 m .66082 .32625 L .67315 .35136 L p .565 g
F P
0 g
s
.72701 .77138 m .72081 .79892 L .77234 .76882 L p .15 g
F P
0 g
s
.77234 .76882 m .78036 .7397 L .72701 .77138 L p .15 g
F P
0 g
s
.31355 .76547 m .32016 .79331 L .38014 .81703 L p .584 g
F P
0 g
s
.38728 .84057 m .38014 .81703 L .32016 .79331 L p .527 g
F P
0 g
s
.38014 .81703 m .38728 .84057 L .45136 .85456 L p .491 g
F P
0 g
s
.51968 .87827 m .5192 .85988 L .45136 .85456 L p .375 g
F P
0 g
s
.5192 .85988 m .51968 .87827 L .58318 .87505 L p .313 g
F P
0 g
s
.58318 .87505 m .58739 .85639 L .5192 .85988 L p .313 g
F P
0 g
s
.34801 .35616 m .31714 .37025 L .31244 .40702 L p .884 g
F P
0 g
s
.28442 .42938 m .31244 .40702 L .31714 .37025 L p .907 g
F P
0 g
s
.2599 .45464 m .23936 .48252 L .25432 .52803 L p .876 g
F P
0 g
s
.23944 .55982 m .25432 .52803 L .23936 .48252 L p .875 g
F P
0 g
s
.62818 .32483 m .66082 .32625 L .63867 .30394 L p .632 g
F P
0 g
s
.63867 .30394 m .61116 .30797 L .62818 .32483 L p .632 g
F P
0 g
s
.42741 .32111 m .39563 .32133 L .38119 .34601 L p .846 g
F P
0 g
s
.34801 .35616 m .38119 .34601 L .39563 .32133 L p .88 g
F P
0 g
s
.56735 .3075 m .58789 .29464 L .56 .28592 L p .715 g
F P
0 g
s
.56 .28592 m .54873 .30173 L .56735 .3075 L p .715 g
F P
0 g
s
.47021 .29242 m .48894 .30603 L .50803 .30097 L p .791 g
F P
0 g
s
.48894 .30603 m .47021 .29242 L .44583 .30487 L p .807 g
F P
0 g
s
.39563 .32133 m .42741 .32111 L .44583 .30487 L p .849 g
F P
0 g
s
.22903 .59258 m .22336 .62584 L .25961 .66843 L p .784 g
F P
0 g
s
.25902 .7009 m .25961 .66843 L .22336 .62584 L p .755 g
F P
0 g
s
.58739 .85639 m .58318 .87505 L .64377 .86384 L p .225 g
F P
0 g
s
.64377 .86384 m .65253 .84417 L .58739 .85639 L p .225 g
F P
0 g
s
.25902 .7009 m .26286 .73215 L .31355 .76547 L p .669 g
F P
0 g
s
.32016 .79331 m .31355 .76547 L .26286 .73215 L p .62 g
F P
0 g
s
.76709 .43783 m .79136 .46382 L .79066 .41912 L p .362 g
F P
0 g
s
.79066 .41912 m .7659 .39672 L .76709 .43783 L p .362 g
F P
0 g
s
.80749 .56905 m .81765 .60196 L .83883 .55486 L p .188 g
F P
0 g
s
.83883 .55486 m .82764 .52273 L .80749 .56905 L p .188 g
F P
0 g
s
.45652 .87338 m .45136 .85456 L .38728 .84057 L p .417 g
F P
0 g
s
.45136 .85456 m .45652 .87338 L .51968 .87827 L p .375 g
F P
0 g
s
.54873 .30173 m .56 .28592 L .52953 .28253 L p .741 g
F P
0 g
s
.52953 .28253 m .52846 .2995 L .54873 .30173 L p .741 g
F P
0 g
s
.49882 .28476 m .50803 .30097 L .52846 .2995 L p .768 g
F P
0 g
s
.50803 .30097 m .49882 .28476 L .47021 .29242 L p .791 g
F P
0 g
s
.52846 .2995 m .52953 .28253 L .49882 .28476 L p .768 g
F P
0 g
s
.70661 .3627 m .73771 .37786 L .72109 .342 L p .492 g
F P
0 g
s
.72109 .342 m .69197 .33195 L .70661 .3627 L p .492 g
F P
0 g
s
.31714 .37025 m .28911 .38819 L .28442 .42938 L p .907 g
F P
0 g
s
.2599 .45464 m .28442 .42938 L .28911 .38819 L p .923 g
F P
0 g
s
.78404 .70871 m .78036 .7397 L .81948 .70066 L p .08 g
F P
0 g
s
.81948 .70066 m .82384 .66828 L .78404 .70871 L p .08 g
F P
0 g
s
.23936 .48252 m .22323 .51264 L .23944 .55982 L p .875 g
F P
0 g
s
.22903 .59258 m .23944 .55982 L .22323 .51264 L p .862 g
F P
0 g
s
.61116 .30797 m .63867 .30394 L .60804 .28621 L p .652 g
F P
0 g
s
.60804 .28621 m .58789 .29464 L .61116 .30797 L p .652 g
F P
0 g
s
.39563 .32133 m .36527 .3259 L .34801 .35616 L p .88 g
F P
0 g
s
.31714 .37025 m .34801 .35616 L .36527 .3259 L p .911 g
F P
0 g
s
.41968 .29983 m .44583 .30487 L .47021 .29242 L p .836 g
F P
0 g
s
.44583 .30487 m .41968 .29983 L .39563 .32133 L p .849 g
F P
0 g
s
.66082 .32625 m .69197 .33195 L .66507 .30448 L p .567 g
F P
0 g
s
.66507 .30448 m .63867 .30394 L .66082 .32625 L p .567 g
F P
0 g
s
.65253 .84417 m .64377 .86384 L .6982 .84502 L p .117 g
F P
0 g
s
.6982 .84502 m .7112 .82364 L .65253 .84417 L p .117 g
F P
0 g
s
.72081 .79892 m .7112 .82364 L .75995 .79554 L p .086 g
F P
0 g
s
.75995 .79554 m .77234 .76882 L .72081 .79892 L p .086 g
F P
0 g
s
.79136 .46382 m .81169 .49224 L .81148 .44479 L p .252 g
F P
0 g
s
.81148 .44479 m .79066 .41912 L .79136 .46382 L p .252 g
F P
0 g
s
.81765 .60196 m .82317 .6352 L .84493 .58816 L p .063 g
F P
0 g
s
.84493 .58816 m .83883 .55486 L .81765 .60196 L p .063 g
F P
0 g
s
.22336 .62584 m .22267 .65909 L .25902 .7009 L p .755 g
F P
0 g
s
.26286 .73215 m .25902 .7009 L .22267 .65909 L p .704 g
F P
0 g
s
.36527 .3259 m .39563 .32133 L .41968 .29983 L p .882 g
F P
0 g
s
.32016 .79331 m .33038 .8184 L .38728 .84057 L p .527 g
F P
0 g
s
.39695 .86054 m .38728 .84057 L .33038 .8184 L p .438 g
F P
0 g
s
.38728 .84057 m .39695 .86054 L .45652 .87338 L p .417 g
F P
0 g
s
.26286 .73215 m .27121 .76165 L .32016 .79331 L p .62 g
F P
0 g
s
.33038 .8184 m .32016 .79331 L .27121 .76165 L p .541 g
F P
0 g
s
.73771 .37786 m .7659 .39672 L .74763 .35639 L p .391 g
F P
0 g
s
.74763 .35639 m .72109 .342 L .73771 .37786 L p .391 g
F P
0 g
s
.58789 .29464 m .60804 .28621 L .57108 .27457 L p .682 g
F P
0 g
s
.57108 .27457 m .56 .28592 L .58789 .29464 L p .682 g
F P
0 g
s
.5203 .89234 m .51968 .87827 L .45652 .87338 L p .267 g
F P
0 g
s
.51968 .87827 m .5203 .89234 L .57788 .88946 L p .201 g
F P
0 g
s
.57788 .88946 m .58318 .87505 L .51968 .87827 L p .201 g
F P
0 g
s
.28911 .38819 m .26447 .40981 L .2599 .45464 L p .923 g
F P
0 g
s
.23936 .48252 m .2599 .45464 L .26447 .40981 L p .927 g
F P
0 g
s
.45183 .28325 m .47021 .29242 L .49882 .28476 L p .806 g
F P
0 g
s
.47021 .29242 m .45183 .28325 L .41968 .29983 L p .836 g
F P
0 g
s
.22323 .51264 m .2119 .54459 L .22903 .59258 L p .862 g
F P
0 g
s
.22336 .62584 m .22903 .59258 L .2119 .54459 L p .828 g
F P
0 g
s
.58318 .87505 m .57788 .88946 L .63274 .8794 L p .125 g
F P
0 g
s
.63274 .8794 m .64377 .86384 L .58318 .87505 L p .125 g
F P
0 g
s
.36527 .3259 m .33686 .33492 L .31714 .37025 L p .911 g
F P
0 g
s
.28911 .38819 m .31714 .37025 L .33686 .33492 L p .931 g
F P
0 g
s
.78036 .7397 m .77234 .76882 L .81 .73177 L p .028 g
F P
0 g
s
.81 .73177 m .81948 .70066 L .78036 .7397 L p .028 g
F P
0 g
s
.46304 .88795 m .45652 .87338 L .39695 .86054 L p .302 g
F P
0 g
s
.45652 .87338 m .46304 .88795 L .5203 .89234 L p .267 g
F P
0 g
s
.56 .28592 m .57108 .27457 L .53059 .27004 L p .721 g
F P
0 g
s
.53059 .27004 m .52953 .28253 L .56 .28592 L p .721 g
F P
0 g
s
.81169 .49224 m .82764 .52273 L .82787 .47342 L p .127 g
F P
0 g
s
.82787 .47342 m .81148 .44479 L .81169 .49224 L p .127 g
F P
0 g
s
.48977 .27302 m .49882 .28476 L .52953 .28253 L p .765 g
F P
0 g
s
.49882 .28476 m .48977 .27302 L .45183 .28325 L p .806 g
F P
0 g
s
.52953 .28253 m .53059 .27004 L .48977 .27302 L p .765 g
F P
0 g
s
.69197 .33195 m .72109 .342 L .68987 .30979 L p .467 g
F P
0 g
s
.68987 .30979 m .66507 .30448 L .69197 .33195 L p .467 g
F P
0 g
s
.63867 .30394 m .66507 .30448 L .62746 .28255 L p .578 g
F P
0 g
s
.62746 .28255 m .60804 .28621 L .63867 .30394 L p .578 g
F P
0 g
s
.82317 .6352 m .82384 .66828 L .84567 .6221 L p .04 g
F P
0 g
s
.84567 .6221 m .84493 .58816 L .82317 .6352 L p .04 g
F P
0 g
s
.39457 .2994 m .41968 .29983 L .45183 .28325 L p .852 g
F P
0 g
s
.41968 .29983 m .39457 .2994 L .36527 .3259 L p .882 g
F P
0 g
s
.22267 .65909 m .22714 .69179 L .26286 .73215 L p .704 g
F P
0 g
s
.27121 .76165 m .26286 .73215 L .22714 .69179 L p .618 g
F P
0 g
s
.33686 .33492 m .36527 .3259 L .39457 .2994 L p .899 g
F P
0 g
s
.7112 .82364 m .6982 .84502 L .74321 .81932 L p .028 g
F P
0 g
s
.74321 .81932 m .75995 .79554 L .7112 .82364 L p .028 g
F P
0 g
s
.7659 .39672 m .79066 .41912 L .77106 .37506 L p .253 g
F P
0 g
s
.77106 .37506 m .74763 .35639 L .7659 .39672 L p .253 g
F P
0 g
s
.26447 .40981 m .24373 .43488 L .23936 .48252 L p .927 g
F P
0 g
s
.22323 .51264 m .23936 .48252 L .24373 .43488 L p .904 g
F P
0 g
s
.64377 .86384 m .63274 .8794 L .68185 .86256 L p .063 g
F P
0 g
s
.68185 .86256 m .6982 .84502 L .64377 .86384 L p .063 g
F P
0 g
s
.2119 .54459 m .20573 .57789 L .22336 .62584 L p .828 g
F P
0 g
s
.22267 .65909 m .22336 .62584 L .20573 .57789 L p .758 g
F P
0 g
s
.33038 .8184 m .34421 .84022 L .39695 .86054 L p .438 g
F P
0 g
s
.40912 .87645 m .39695 .86054 L .34421 .84022 L p .306 g
F P
0 g
s
.39695 .86054 m .40912 .87645 L .46304 .88795 L p .302 g
F P
0 g
s
.27121 .76165 m .28412 .78885 L .33038 .8184 L p .541 g
F P
0 g
s
.34421 .84022 m .33038 .8184 L .28412 .78885 L p .417 g
F P
0 g
s
.33686 .33492 m .31093 .34841 L .28911 .38819 L p .931 g
F P
0 g
s
.26447 .40981 m .28911 .38819 L .31093 .34841 L p .923 g
F P
0 g
s
.82764 .52273 m .83883 .55486 L .8394 .50462 L p .056 g
F P
0 g
s
.8394 .50462 m .82787 .47342 L .82764 .52273 L p .056 g
F P
0 g
s
.60804 .28621 m .62746 .28255 L .58179 .26809 L p .603 g
F P
0 g
s
.58179 .26809 m .57108 .27457 L .60804 .28621 L p .603 g
F P
0 g
s
.77234 .76882 m .75995 .79554 L .79537 .76104 L p .002 g
F P
0 g
s
.79537 .76104 m .81 .73177 L .77234 .76882 L p .002 g
F P
0 g
s
.4341 .27888 m .45183 .28325 L .48977 .27302 L p .79 g
F P
0 g
s
.45183 .28325 m .4341 .27888 L .39457 .2994 L p .852 g
F P
0 g
s
.52104 .90165 m .5203 .89234 L .46304 .88795 L p .146 g
F P
0 g
s
.5203 .89234 m .52104 .90165 L .57151 .89914 L p .118 g
F P
0 g
s
.57151 .89914 m .57788 .88946 L .5203 .89234 L p .118 g
F P
0 g
s
.82384 .66828 m .81948 .70066 L .84086 .6561 L p .019 g
F P
0 g
s
.84086 .6561 m .84567 .6221 L .82384 .66828 L p .019 g
F P
0 g
s
.72109 .342 m .74763 .35639 L .71258 .31998 L p .318 g
F P
0 g
s
.71258 .31998 m .68987 .30979 L .72109 .342 L p .318 g
F P
0 g
s
.57788 .88946 m .57151 .89914 L .6195 .8904 L p .075 g
F P
0 g
s
.6195 .8904 m .63274 .8794 L .57788 .88946 L p .075 g
F P
0 g
s
.79066 .41912 m .81148 .44479 L .79083 .39784 L p .129 g
F P
0 g
s
.79083 .39784 m .77106 .37506 L .79066 .41912 L p .129 g
F P
0 g
s
.24373 .43488 m .22739 .46311 L .22323 .51264 L p .904 g
F P
0 g
s
.2119 .54459 m .22323 .51264 L .22739 .46311 L p .836 g
F P
0 g
s
.66507 .30448 m .68987 .30979 L .64578 .28395 L p .443 g
F P
0 g
s
.64578 .28395 m .62746 .28255 L .66507 .30448 L p .443 g
F P
0 g
s
.47087 .89783 m .46304 .88795 L .40912 .87645 L p .161 g
F P
0 g
s
.46304 .88795 m .47087 .89783 L .52104 .90165 L p .146 g
F P
0 g
s
.22714 .69179 m .23687 .72336 L .27121 .76165 L p .618 g
F P
0 g
s
.28412 .78885 m .27121 .76165 L .23687 .72336 L p .485 g
F P
0 g
s
.57108 .27457 m .58179 .26809 L .53162 .26245 L p .648 g
F P
0 g
s
.53162 .26245 m .53059 .27004 L .57108 .27457 L p .648 g
F P
0 g
s
.48101 .26617 m .48977 .27302 L .53059 .27004 L p .715 g
F P
0 g
s
.48977 .27302 m .48101 .26617 L .4341 .27888 L p .79 g
F P
0 g
s
.39457 .2994 m .37094 .30381 L .33686 .33492 L p .899 g
F P
0 g
s
.31093 .34841 m .33686 .33492 L .37094 .30381 L p .872 g
F P
0 g
s
.37094 .30381 m .39457 .2994 L .4341 .27888 L p .821 g
F P
0 g
s
.20573 .57789 m .20498 .61201 L .22267 .65909 L p .758 g
F P
0 g
s
.22714 .69179 m .22267 .65909 L .20498 .61201 L p .635 g
F P
0 g
s
.53059 .27004 m .53162 .26245 L .48101 .26617 L p .715 g
F P
0 g
s
.6982 .84502 m .68185 .86256 L .72225 .83964 L p F P
s
.72225 .83964 m .74321 .81932 L .6982 .84502 L p F P
s
.83883 .55486 m .84493 .58816 L .8457 .53792 L p .033 g
F P
0 g
s
.8457 .53792 m .8394 .50462 L .83883 .55486 L p .033 g
F P
0 g
s
.31093 .34841 m .28803 .36631 L .26447 .40981 L p .923 g
F P
0 g
s
.24373 .43488 m .26447 .40981 L .28803 .36631 L p .861 g
F P
0 g
s
.63274 .8794 m .6195 .8904 L .6623 .87579 L p .01 g
F P
0 g
s
.6623 .87579 m .68185 .86256 L .63274 .8794 L p .01 g
F P
0 g
s
.28412 .78885 m .30155 .81322 L .34421 .84022 L p .417 g
F P
0 g
s
.36158 .85828 m .34421 .84022 L .30155 .81322 L p .255 g
F P
0 g
s
.34421 .84022 m .36158 .85828 L .40912 .87645 L p .306 g
F P
0 g
s
.75995 .79554 m .74321 .81932 L .77567 .78787 L p F P
s
.77567 .78787 m .79537 .76104 L .75995 .79554 L p F P
s
.81948 .70066 m .81 .73177 L .8304 .68956 L p F P
s
.8304 .68956 m .84086 .6561 L .81948 .70066 L p F P
s
.42373 .88783 m .40912 .87645 L .36158 .85828 L p .158 g
F P
0 g
s
.40912 .87645 m .42373 .88783 L .47087 .89783 L p .161 g
F P
0 g
s
.22739 .46311 m .21589 .4941 L .2119 .54459 L p .836 g
F P
0 g
s
.20573 .57789 m .2119 .54459 L .21589 .4941 L p .704 g
F P
0 g
s
.74763 .35639 m .77106 .37506 L .73272 .33511 L p .176 g
F P
0 g
s
.73272 .33511 m .71258 .31998 L .74763 .35639 L p .176 g
F P
0 g
s
.81148 .44479 m .82787 .47342 L .80646 .42449 L p .051 g
F P
0 g
s
.80646 .42449 m .79083 .39784 L .81148 .44479 L p .051 g
F P
0 g
s
.62746 .28255 m .64578 .28395 L .59193 .26687 L p .435 g
F P
0 g
s
.59193 .26687 m .58179 .26809 L .62746 .28255 L p .435 g
F P
0 g
s
.23687 .72336 m .25188 .75322 L .28412 .78885 L p .485 g
F P
0 g
s
.30155 .81322 m .28412 .78885 L .25188 .75322 L p .314 g
F P
0 g
s
.41736 .27962 m .4341 .27888 L .48101 .26617 L p .69 g
F P
0 g
s
.4341 .27888 m .41736 .27962 L .37094 .30381 L p .821 g
F P
0 g
s
.20498 .61201 m .20985 .64638 L .22714 .69179 L p .635 g
F P
0 g
s
.23687 .72336 m .22714 .69179 L .20985 .64638 L p .468 g
F P
0 g
s
.68987 .30979 m .71258 .31998 L .66262 .29066 L p .28 g
F P
0 g
s
.66262 .29066 m .64578 .28395 L .68987 .30979 L p .28 g
F P
0 g
s
.37094 .30381 m .34929 .31321 L .31093 .34841 L p .872 g
F P
0 g
s
.28803 .36631 m .31093 .34841 L .34929 .31321 L p .76 g
F P
0 g
s
.5219 .90577 m .52104 .90165 L .47087 .89783 L p .083 g
F P
0 g
s
.52104 .90165 m .5219 .90577 L .56412 .90367 L p .055 g
F P
0 g
s
.56412 .90367 m .57151 .89914 L .52104 .90165 L p .055 g
F P
0 g
s
.84493 .58816 m .84567 .6221 L .84646 .57277 L p .006 g
F P
0 g
s
.84646 .57277 m .8457 .53792 L .84493 .58816 L p .006 g
F P
0 g
s
.28803 .36631 m .26868 .38849 L .24373 .43488 L p .861 g
F P
0 g
s
.22739 .46311 m .24373 .43488 L .26868 .38849 L p .719 g
F P
0 g
s
.57151 .89914 m .56412 .90367 L .60418 .89639 L p .008 g
F P
0 g
s
.60418 .89639 m .6195 .8904 L .57151 .89914 L p .008 g
F P
0 g
s
.34929 .31321 m .37094 .30381 L .41736 .27962 L p .69 g
F P
0 g
s
.47994 .90258 m .47087 .89783 L .42373 .88783 L p .091 g
F P
0 g
s
.47087 .89783 m .47994 .90258 L .5219 .90577 L p .083 g
F P
0 g
s
.58179 .26809 m .59193 .26687 L .53259 .26019 L p .469 g
F P
0 g
s
.53259 .26019 m .53162 .26245 L .58179 .26809 L p .469 g
F P
0 g
s
.68185 .86256 m .6623 .87579 L .69726 .85598 L p F P
s
.69726 .85598 m .72225 .83964 L .68185 .86256 L p F P
s
.47273 .26459 m .48101 .26617 L .53162 .26245 L p .558 g
F P
0 g
s
.48101 .26617 m .47273 .26459 L .41736 .27962 L p .69 g
F P
0 g
s
.81 .73177 m .79537 .76104 L .8143 .72183 L p .692 g
F P
0 g
s
.8143 .72183 m .8304 .68956 L .81 .73177 L p .692 g
F P
0 g
s
.21589 .4941 m .20961 .52739 L .20573 .57789 L p .704 g
F P
0 g
s
.20498 .61201 m .20573 .57789 L .20961 .52739 L p .004 g
F P
0 g
s
.53162 .26245 m .53259 .26019 L .47273 .26459 L p .558 g
F P
0 g
s
.74321 .81932 m .72225 .83964 L .75109 .81169 L p F P
s
.75109 .81169 m .77567 .78787 L .74321 .81932 L p F P
s
.30155 .81322 m .32335 .83421 L .36158 .85828 L p .255 g
F P
0 g
s
.38234 .87208 m .36158 .85828 L .32335 .83421 L p .122 g
F P
0 g
s
.36158 .85828 m .38234 .87208 L .42373 .88783 L p .158 g
F P
0 g
s
.82787 .47342 m .8394 .50462 L .81748 .45466 L p .44 g
F P
0 g
s
.81748 .45466 m .80646 .42449 L .82787 .47342 L p .44 g
F P
0 g
s
.6195 .8904 m .60418 .89639 L .63974 .88427 L p F P
s
.63974 .88427 m .6623 .87579 L .6195 .8904 L p F P
s
.77106 .37506 m .79083 .39784 L .74978 .35512 L p .226 g
F P
0 g
s
.74978 .35512 m .73272 .33511 L .77106 .37506 L p .226 g
F P
0 g
s
.42373 .88783 m .44063 .89426 L .47994 .90258 L p .091 g
F P
0 g
s
.44063 .89426 m .42373 .88783 L .38234 .87208 L p .272 g
F P
0 g
s
.20985 .64638 m .22044 .68036 L .23687 .72336 L p .468 g
F P
0 g
s
.25188 .75322 m .23687 .72336 L .22044 .68036 L p .046 g
F P
0 g
s
.25188 .75322 m .27207 .78076 L .30155 .81322 L p .314 g
F P
0 g
s
.32335 .83421 m .30155 .81322 L .27207 .78076 L p .094 g
F P
0 g
s
.84567 .6221 m .84086 .6561 L .8415 .60855 L p .7 g
F P
0 g
s
.8415 .60855 m .84646 .57277 L .84567 .6221 L p .7 g
F P
0 g
s
.64578 .28395 m .66262 .29066 L .60127 .27121 L p .086 g
F P
0 g
s
.60127 .27121 m .59193 .26687 L .64578 .28395 L p .086 g
F P
0 g
s
.26868 .38849 m .25338 .41473 L .22739 .46311 L p .719 g
F P
0 g
s
.21589 .4941 m .22739 .46311 L .25338 .41473 L p F P
s
.34929 .31321 m .33008 .32766 L .28803 .36631 L p .76 g
F P
0 g
s
.26868 .38849 m .28803 .36631 L .33008 .32766 L p F P
s
.71258 .31998 m .73272 .33511 L .6776 .30282 L p .151 g
F P
0 g
s
.6776 .30282 m .66262 .29066 L .71258 .31998 L p .151 g
F P
0 g
s
.41736 .27962 m .40196 .28573 L .34929 .31321 L p .69 g
F P
0 g
s
.40196 .28573 m .41736 .27962 L .47273 .26459 L p F P
s
.79537 .76104 m .77567 .78787 L .79271 .75226 L p .834 g
F P
0 g
s
.79271 .75226 m .8143 .72183 L .79537 .76104 L p .834 g
F P
0 g
s
.20961 .52739 m .20885 .56243 L .20498 .61201 L p .004 g
F P
0 g
s
.20985 .64638 m .20498 .61201 L .20885 .56243 L p .032 g
F P
0 g
s
.33008 .32766 m .34929 .31321 L .40196 .28573 L p F P
s
.52288 .90433 m .5219 .90577 L .47994 .90258 L p .45 g
F P
0 g
s
.5219 .90577 m .52288 .90433 L .55578 .90269 L p .511 g
F P
0 g
s
.55578 .90269 m .56412 .90367 L .5219 .90577 L p .511 g
F P
0 g
s
.8394 .50462 m .8457 .53792 L .82351 .48789 L p .615 g
F P
0 g
s
.82351 .48789 m .81748 .45466 L .8394 .50462 L p .615 g
F P
0 g
s
.6623 .87579 m .63974 .88427 L .66855 .86789 L p .745 g
F P
0 g
s
.66855 .86789 m .69726 .85598 L .6623 .87579 L p .745 g
F P
0 g
s
.72225 .83964 m .69726 .85598 L .72193 .83194 L p .822 g
F P
0 g
s
.72193 .83194 m .75109 .81169 L .72225 .83964 L p .822 g
F P
0 g
s
.56412 .90367 m .55578 .90269 L .58693 .89702 L p .609 g
F P
0 g
s
.58693 .89702 m .60418 .89639 L .56412 .90367 L p .609 g
F P
0 g
s
.49018 .90184 m .47994 .90258 L .44063 .89426 L p .434 g
F P
0 g
s
.47994 .90258 m .49018 .90184 L .52288 .90433 L p .45 g
F P
0 g
s
.79083 .39784 m .80646 .42449 L .7633 .37983 L p .428 g
F P
0 g
s
.7633 .37983 m .74978 .35512 L .79083 .39784 L p .428 g
F P
0 g
s
.59193 .26687 m .60127 .27121 L .53349 .2636 L p .077 g
F P
0 g
s
.53349 .2636 m .53259 .26019 L .59193 .26687 L p .077 g
F P
0 g
s
.32335 .83421 m .34932 .8513 L .38234 .87208 L p .122 g
F P
0 g
s
.40629 .88119 m .38234 .87208 L .34932 .8513 L p .325 g
F P
0 g
s
.38234 .87208 m .40629 .88119 L .44063 .89426 L p .272 g
F P
0 g
s
.84086 .6561 m .8304 .68956 L .83071 .6446 L p .829 g
F P
0 g
s
.83071 .6446 m .8415 .60855 L .84086 .6561 L p .829 g
F P
0 g
s
.22044 .68036 m .23672 .7133 L .25188 .75322 L p .046 g
F P
0 g
s
.27207 .78076 m .25188 .75322 L .23672 .7133 L p .09 g
F P
0 g
s
.46509 .26861 m .47273 .26459 L .53259 .26019 L p .039 g
F P
0 g
s
.47273 .26459 m .46509 .26861 L .40196 .28573 L p F P
s
.27207 .78076 m .29724 .80539 L .32335 .83421 L p .094 g
F P
0 g
s
.34932 .8513 m .32335 .83421 L .29724 .80539 L p .251 g
F P
0 g
s
.25338 .41473 m .24258 .44468 L .21589 .4941 L p F P
s
.20961 .52739 m .21589 .4941 L .24258 .44468 L p .016 g
F P
0 g
s
.53259 .26019 m .53349 .2636 L .46509 .26861 L p .039 g
F P
0 g
s
.60418 .89639 m .58693 .89702 L .61444 .8876 L p .727 g
F P
0 g
s
.61444 .8876 m .63974 .88427 L .60418 .89639 L p .727 g
F P
0 g
s
.33008 .32766 m .31379 .34714 L .26868 .38849 L p F P
s
.25338 .41473 m .26868 .38849 L .31379 .34714 L p F P
s
.45963 .89536 m .44063 .89426 L .40629 .88119 L p .452 g
F P
0 g
s
.44063 .89426 m .45963 .89536 L .49018 .90184 L p .434 g
F P
0 g
s
.20885 .56243 m .21381 .59859 L .20985 .64638 L p .032 g
F P
0 g
s
.22044 .68036 m .20985 .64638 L .21381 .59859 L p .054 g
F P
0 g
s
.77567 .78787 m .75109 .81169 L .76587 .78019 L p .908 g
F P
0 g
s
.76587 .78019 m .79271 .75226 L .77567 .78787 L p .908 g
F P
0 g
s
.73272 .33511 m .74978 .35512 L .69034 .32047 L p .323 g
F P
0 g
s
.69034 .32047 m .6776 .30282 L .73272 .33511 L p .323 g
F P
0 g
s
.66262 .29066 m .6776 .30282 L .6096 .28134 L p .164 g
F P
0 g
s
.6096 .28134 m .60127 .27121 L .66262 .29066 L p .164 g
F P
0 g
s
.8457 .53792 m .84646 .57277 L .82424 .52364 L p .743 g
F P
0 g
s
.82424 .52364 m .82351 .48789 L .8457 .53792 L p .743 g
F P
0 g
s
.38825 .29738 m .40196 .28573 L .46509 .26861 L p .048 g
F P
0 g
s
.40196 .28573 m .38825 .29738 L .33008 .32766 L p F P
s
.8304 .68956 m .8143 .72183 L .81416 .6802 L p .899 g
F P
0 g
s
.81416 .6802 m .83071 .6446 L .8304 .68956 L p .899 g
F P
0 g
s
.23672 .7133 m .25855 .74453 L .27207 .78076 L p .09 g
F P
0 g
s
.29724 .80539 m .27207 .78076 L .25855 .74453 L p .22 g
F P
0 g
s
.31379 .34714 m .33008 .32766 L .38825 .29738 L p .02 g
F P
0 g
s
.69726 .85598 m .66855 .86789 L .68861 .84811 L p .88 g
F P
0 g
s
.68861 .84811 m .72193 .83194 L .69726 .85598 L p .88 g
F P
0 g
s
.80646 .42449 m .81748 .45466 L .77287 .40897 L p .577 g
F P
0 g
s
.77287 .40897 m .7633 .37983 L .80646 .42449 L p .577 g
F P
0 g
s
.63974 .88427 m .61444 .8876 L .63654 .87494 L p .827 g
F P
0 g
s
.63654 .87494 m .66855 .86789 L .63974 .88427 L p .827 g
F P
0 g
s
.24258 .44468 m .23667 .4779 L .20961 .52739 L p .016 g
F P
0 g
s
.20885 .56243 m .20961 .52739 L .23667 .4779 L p .039 g
F P
0 g
s
.34932 .8513 m .37913 .86403 L .40629 .88119 L p .325 g
F P
0 g
s
.4331 .88522 m .40629 .88119 L .37913 .86403 L p .489 g
F P
0 g
s
.40629 .88119 m .4331 .88522 L .45963 .89536 L p .452 g
F P
0 g
s
.29724 .80539 m .32707 .82654 L .34932 .8513 L p .251 g
F P
0 g
s
.37913 .86403 m .34932 .8513 L .32707 .82654 L p .391 g
F P
0 g
s
.52395 .89704 m .52288 .90433 L .49018 .90184 L p .651 g
F P
0 g
s
.52288 .90433 m .52395 .89704 L .5466 .89591 L p .692 g
F P
0 g
s
.5466 .89591 m .55578 .90269 L .52288 .90433 L p .692 g
F P
0 g
s
.55578 .90269 m .5466 .89591 L .568 .89199 L p .744 g
F P
0 g
s
.568 .89199 m .58693 .89702 L .55578 .90269 L p .744 g
F P
0 g
s
.21381 .59859 m .22456 .6352 L .22044 .68036 L p .054 g
F P
0 g
s
.23672 .7133 m .22044 .68036 L .22456 .6352 L p .119 g
F P
0 g
s
.50144 .89532 m .49018 .90184 L .45963 .89536 L p .626 g
F P
0 g
s
.49018 .90184 m .50144 .89532 L .52395 .89704 L p .651 g
F P
0 g
s
.60127 .27121 m .6096 .28134 L .53429 .27292 L p .147 g
F P
0 g
s
.53429 .27292 m .53349 .2636 L .60127 .27121 L p .147 g
F P
0 g
s
.31379 .34714 m .30087 .37148 L .25338 .41473 L p F P
s
.24258 .44468 m .25338 .41473 L .30087 .37148 L p .031 g
F P
0 g
s
.75109 .81169 m .72193 .83194 L .7342 .80499 L p .929 g
F P
0 g
s
.7342 .80499 m .76587 .78019 L .75109 .81169 L p .929 g
F P
0 g
s
.45827 .27847 m .46509 .26861 L .53349 .2636 L p .109 g
F P
0 g
s
.46509 .26861 m .45827 .27847 L .38825 .29738 L p .048 g
F P
0 g
s
.84646 .57277 m .8415 .60855 L .81948 .56124 L p .816 g
F P
0 g
s
.81948 .56124 m .82424 .52364 L .84646 .57277 L p .816 g
F P
0 g
s
.58693 .89702 m .568 .89199 L .58678 .8855 L p .796 g
F P
0 g
s
.58678 .8855 m .61444 .8876 L .58693 .89702 L p .796 g
F P
0 g
s
.8143 .72183 m .79271 .75226 L .79203 .7146 L p .926 g
F P
0 g
s
.79203 .7146 m .81416 .6802 L .8143 .72183 L p .926 g
F P
0 g
s
.53349 .2636 m .53429 .27292 L .45827 .27847 L p .109 g
F P
0 g
s
.48047 .89084 m .45963 .89536 L .4331 .88522 L p .616 g
F P
0 g
s
.45963 .89536 m .48047 .89084 L .50144 .89532 L p .626 g
F P
0 g
s
.25855 .74453 m .28565 .77338 L .29724 .80539 L p .22 g
F P
0 g
s
.32707 .82654 m .29724 .80539 L .28565 .77338 L p .35 g
F P
0 g
s
.74978 .35512 m .7633 .37983 L .70046 .34353 L p .472 g
F P
0 g
s
.70046 .34353 m .69034 .32047 L .74978 .35512 L p .472 g
F P
0 g
s
.6776 .30282 m .69034 .32047 L .6167 .29738 L p .321 g
F P
0 g
s
.6167 .29738 m .6096 .28134 L .6776 .30282 L p .321 g
F P
0 g
s
.66855 .86789 m .63654 .87494 L .65167 .85975 L p .882 g
F P
0 g
s
.65167 .85975 m .68861 .84811 L .66855 .86789 L p .882 g
F P
0 g
s
.81748 .45466 m .82351 .48789 L .7781 .4421 L p .675 g
F P
0 g
s
.7781 .4421 m .77287 .40897 L .81748 .45466 L p .675 g
F P
0 g
s
.23667 .4779 m .23596 .51382 L .20885 .56243 L p .039 g
F P
0 g
s
.21381 .59859 m .20885 .56243 L .23596 .51382 L p .081 g
F P
0 g
s
.22456 .6352 m .24106 .67151 L .23672 .7133 L p .119 g
F P
0 g
s
.25855 .74453 m .23672 .7133 L .24106 .67151 L p .244 g
F P
0 g
s
.38825 .29738 m .37659 .31463 L .31379 .34714 L p .02 g
F P
0 g
s
.30087 .37148 m .31379 .34714 L .37659 .31463 L p .084 g
F P
0 g
s
.37659 .31463 m .38825 .29738 L .45827 .27847 L p .106 g
F P
0 g
s
.32707 .82654 m .36112 .84368 L .37913 .86403 L p .391 g
F P
0 g
s
.41233 .87197 m .37913 .86403 L .36112 .84368 L p .527 g
F P
0 g
s
.37913 .86403 m .41233 .87197 L .4331 .88522 L p .489 g
F P
0 g
s
.61444 .8876 m .58678 .8855 L .60173 .87683 L p .836 g
F P
0 g
s
.60173 .87683 m .63654 .87494 L .61444 .8876 L p .836 g
F P
0 g
s
.72193 .83194 m .68861 .84811 L .69823 .82608 L p .918 g
F P
0 g
s
.69823 .82608 m .7342 .80499 L .72193 .83194 L p .918 g
F P
0 g
s
.46239 .88387 m .4331 .88522 L .41233 .87197 L p .616 g
F P
0 g
s
.4331 .88522 m .46239 .88387 L .48047 .89084 L p .616 g
F P
0 g
s
.8415 .60855 m .83071 .6446 L .80917 .59996 L p .853 g
F P
0 g
s
.80917 .59996 m .81948 .56124 L .8415 .60855 L p .853 g
F P
0 g
s
.30087 .37148 m .29173 .40041 L .24258 .44468 L p .031 g
F P
0 g
s
.23667 .4779 m .24258 .44468 L .29173 .40041 L p .09 g
F P
0 g
s
.79271 .75226 m .76587 .78019 L .76466 .74704 L p .927 g
F P
0 g
s
.76466 .74704 m .79203 .7146 L .79271 .75226 L p .927 g
F P
0 g
s
.28565 .77338 m .31759 .79918 L .32707 .82654 L p .35 g
F P
0 g
s
.36112 .84368 m .32707 .82654 L .31759 .79918 L p .467 g
F P
0 g
s
.5251 .88372 m .52395 .89704 L .50144 .89532 L p .733 g
F P
0 g
s
.52395 .89704 m .5251 .88372 L .53673 .88314 L p .755 g
F P
0 g
s
.53673 .88314 m .5466 .89591 L .52395 .89704 L p .755 g
F P
0 g
s
.5466 .89591 m .53673 .88314 L .54767 .88111 L p .777 g
F P
0 g
s
.54767 .88111 m .568 .89199 L .5466 .89591 L p .777 g
F P
0 g
s
.51355 .88283 m .50144 .89532 L .48047 .89084 L p .715 g
F P
0 g
s
.50144 .89532 m .51355 .88283 L .5251 .88372 L p .733 g
F P
0 g
s
.6096 .28134 m .6167 .29738 L .53497 .28831 L p .276 g
F P
0 g
s
.53497 .28831 m .53429 .27292 L .6096 .28134 L p .276 g
F P
0 g
s
.23596 .51382 m .24062 .55179 L .21381 .59859 L p .081 g
F P
0 g
s
.22456 .6352 m .21381 .59859 L .24062 .55179 L p .205 g
F P
0 g
s
.24106 .67151 m .2631 .70675 L .25855 .74453 L p .244 g
F P
0 g
s
.28565 .77338 m .25855 .74453 L .2631 .70675 L p .355 g
F P
0 g
s
.7633 .37983 m .77287 .40897 L .70763 .37176 L p .572 g
F P
0 g
s
.70763 .37176 m .70046 .34353 L .7633 .37983 L p .572 g
F P
0 g
s
.45247 .29428 m .45827 .27847 L .53429 .27292 L p .189 g
F P
0 g
s
.45827 .27847 m .45247 .29428 L .37659 .31463 L p .106 g
F P
0 g
s
.82351 .48789 m .82424 .52364 L .77874 .47866 L p .732 g
F P
0 g
s
.77874 .47866 m .7781 .4421 L .82351 .48789 L p .732 g
F P
0 g
s
.63654 .87494 m .60173 .87683 L .61178 .86648 L p .855 g
F P
0 g
s
.61178 .86648 m .65167 .85975 L .63654 .87494 L p .855 g
F P
0 g
s
.568 .89199 m .54767 .88111 L .55723 .87777 L p .796 g
F P
0 g
s
.55723 .87777 m .58678 .8855 L .568 .89199 L p .796 g
F P
0 g
s
.50284 .88052 m .48047 .89084 L .46239 .88387 L p .702 g
F P
0 g
s
.48047 .89084 m .50284 .88052 L .51355 .88283 L p .715 g
F P
0 g
s
.68861 .84811 m .65167 .85975 L .65863 .84293 L p .89 g
F P
0 g
s
.65863 .84293 m .69823 .82608 L .68861 .84811 L p .89 g
F P
0 g
s
.36112 .84368 m .39881 .85636 L .41233 .87197 L p .527 g
F P
0 g
s
.44839 .8748 m .41233 .87197 L .39881 .85636 L p .621 g
F P
0 g
s
.41233 .87197 m .44839 .8748 L .46239 .88387 L p .616 g
F P
0 g
s
.83071 .6446 m .81416 .6802 L .79339 .63899 L p .869 g
F P
0 g
s
.79339 .63899 m .80917 .59996 L .83071 .6446 L p .869 g
F P
0 g
s
.76587 .78019 m .7342 .80499 L .73253 .77679 L p .915 g
F P
0 g
s
.73253 .77679 m .76466 .74704 L .76587 .78019 L p .915 g
F P
0 g
s
.53429 .27292 m .53497 .28831 L .45247 .29428 L p .189 g
F P
0 g
s
.69034 .32047 m .70046 .34353 L .62235 .31929 L p .448 g
F P
0 g
s
.62235 .31929 m .6167 .29738 L .69034 .32047 L p .448 g
F P
0 g
s
.37659 .31463 m .36732 .3374 L .30087 .37148 L p .084 g
F P
0 g
s
.29173 .40041 m .30087 .37148 L .36732 .3374 L p .158 g
F P
0 g
s
.31759 .79918 m .35383 .82135 L .36112 .84368 L p .467 g
F P
0 g
s
.39881 .85636 m .36112 .84368 L .35383 .82135 L p .557 g
F P
0 g
s
.58678 .8855 m .55723 .87777 L .56475 .87332 L p .81 g
F P
0 g
s
.56475 .87332 m .60173 .87683 L .58678 .8855 L p .81 g
F P
0 g
s
.29173 .40041 m .28672 .43351 L .23667 .4779 L p .09 g
F P
0 g
s
.23596 .51382 m .23667 .4779 L .28672 .43351 L p .191 g
F P
0 g
s
.49366 .87693 m .46239 .88387 L .44839 .8748 L p .692 g
F P
0 g
s
.46239 .88387 m .49366 .87693 L .50284 .88052 L p .702 g
F P
0 g
s
.36732 .3374 m .37659 .31463 L .45247 .29428 L p .199 g
F P
0 g
s
.2631 .70675 m .29034 .74015 L .28565 .77338 L p .355 g
F P
0 g
s
.31759 .79918 m .28565 .77338 L .29034 .74015 L p .444 g
F P
0 g
s
.24062 .55179 m .25072 .59106 L .22456 .6352 L p .205 g
F P
0 g
s
.24106 .67151 m .22456 .6352 L .25072 .59106 L p .302 g
F P
0 g
s
.7342 .80499 m .69823 .82608 L .69628 .80318 L p .895 g
F P
0 g
s
.69628 .80318 m .73253 .77679 L .7342 .80499 L p .895 g
F P
0 g
s
.81416 .6802 m .79203 .7146 L .77236 .67746 L p .874 g
F P
0 g
s
.77236 .67746 m .79339 .63899 L .81416 .6802 L p .874 g
F P
0 g
s
.82424 .52364 m .81948 .56124 L .7746 .51797 L p .765 g
F P
0 g
s
.7746 .51797 m .77874 .47866 L .82424 .52364 L p .765 g
F P
0 g
s
.65167 .85975 m .61178 .86648 L .61618 .85512 L p .855 g
F P
0 g
s
.61618 .85512 m .65863 .84293 L .65167 .85975 L p .855 g
F P
0 g
s
.60173 .87683 m .56475 .87332 L .56971 .86805 L p .817 g
F P
0 g
s
.56971 .86805 m .61178 .86648 L .60173 .87683 L p .817 g
F P
0 g
s
.39881 .85636 m .43945 .86418 L .44839 .8748 L p .621 g
F P
0 g
s
.48663 .87228 m .44839 .8748 L .43945 .86418 L p .687 g
F P
0 g
s
.44839 .8748 m .48663 .87228 L .49366 .87693 L p .692 g
F P
0 g
s
.77287 .40897 m .7781 .4421 L .71156 .40477 L p .633 g
F P
0 g
s
.71156 .40477 m .70763 .37176 L .77287 .40897 L p .633 g
F P
0 g
s
.35383 .82135 m .39366 .83933 L .39881 .85636 L p .557 g
F P
0 g
s
.43945 .86418 m .39881 .85636 L .39366 .83933 L p .628 g
F P
0 g
s
.52632 .86433 m .5251 .88372 L .51355 .88283 L closepath p .754 g
F P
0 g
s
.52632 .86433 m .53673 .88314 L .5251 .88372 L closepath p .76 g
F P
0 g
s
.29034 .74015 m .32227 .77096 L .31759 .79918 L p .444 g
F P
0 g
s
.35383 .82135 m .31759 .79918 L .32227 .77096 L p .518 g
F P
0 g
s
.52632 .86433 m .54767 .88111 L .53673 .88314 L closepath p .765 g
F P
0 g
s
.52632 .86433 m .51355 .88283 L .50284 .88052 L closepath p .748 g
F P
0 g
s
.6167 .29738 m .62235 .31929 L .53552 .30976 L p .393 g
F P
0 g
s
.53552 .30976 m .53497 .28831 L .6167 .29738 L p .393 g
F P
0 g
s
.52632 .86433 m .55723 .87777 L .54767 .88111 L closepath p .77 g
F P
0 g
s
.25072 .59106 m .26618 .63078 L .24106 .67151 L p .302 g
F P
0 g
s
.2631 .70675 m .24106 .67151 L .26618 .63078 L p .381 g
F P
0 g
s
.28672 .43351 m .28611 .47023 L .23596 .51382 L p .191 g
F P
0 g
s
.24062 .55179 m .23596 .51382 L .28611 .47023 L p .282 g
F P
0 g
s
.52632 .86433 m .50284 .88052 L .49366 .87693 L closepath p .743 g
F P
0 g
s
.44784 .31604 m .45247 .29428 L .53497 .28831 L p .315 g
F P
0 g
s
.45247 .29428 m .44784 .31604 L .36732 .3374 L p .199 g
F P
0 g
s
.69823 .82608 m .65863 .84293 L .65664 .82558 L p .87 g
F P
0 g
s
.65664 .82558 m .69628 .80318 L .69823 .82608 L p .87 g
F P
0 g
s
.36732 .3374 m .36076 .36547 L .29173 .40041 L p .158 g
F P
0 g
s
.28672 .43351 m .29173 .40041 L .36076 .36547 L p .261 g
F P
0 g
s
.79203 .7146 m .76466 .74704 L .74646 .71451 L p .871 g
F P
0 g
s
.74646 .71451 m .77236 .67746 L .79203 .7146 L p .871 g
F P
0 g
s
.52632 .86433 m .56475 .87332 L .55723 .87777 L closepath p .773 g
F P
0 g
s
.70046 .34353 m .70763 .37176 L .62635 .34688 L p .526 g
F P
0 g
s
.62635 .34688 m .62235 .31929 L .70046 .34353 L p .526 g
F P
0 g
s
.61178 .86648 m .56971 .86805 L .57176 .86231 L p .816 g
F P
0 g
s
.57176 .86231 m .61618 .85512 L .61178 .86648 L p .816 g
F P
0 g
s
.52632 .86433 m .49366 .87693 L .48663 .87228 L closepath p .738 g
F P
0 g
s
.53497 .28831 m .53552 .30976 L .44784 .31604 L p .315 g
F P
0 g
s
.39366 .83933 m .43629 .8527 L .43945 .86418 L p .628 g
F P
0 g
s
.48225 .86689 m .43945 .86418 L .43629 .8527 L p .685 g
F P
0 g
s
.43945 .86418 m .48225 .86689 L .48663 .87228 L p .687 g
F P
0 g
s
.32227 .77096 m .35826 .79846 L .35383 .82135 L p .518 g
F P
0 g
s
.39366 .83933 m .35383 .82135 L .35826 .79846 L p .581 g
F P
0 g
s
.81948 .56124 m .80917 .59996 L .76566 .5592 L p .785 g
F P
0 g
s
.76566 .5592 m .7746 .51797 L .81948 .56124 L p .785 g
F P
0 g
s
.52632 .86433 m .56971 .86805 L .56475 .87332 L closepath p .775 g
F P
0 g
s
.36076 .36547 m .36732 .3374 L .44784 .31604 L p .303 g
F P
0 g
s
.52632 .86433 m .48663 .87228 L .48225 .86689 L closepath p .735 g
F P
0 g
s
.65863 .84293 m .61618 .85512 L .61448 .84348 L p .841 g
F P
0 g
s
.61448 .84348 m .65664 .82558 L .65863 .84293 L p .841 g
F P
0 g
s
.26618 .63078 m .28676 .67008 L .2631 .70675 L p .381 g
F P
0 g
s
.29034 .74015 m .2631 .70675 L .28676 .67008 L p .447 g
F P
0 g
s
.76466 .74704 m .73253 .77679 L .71624 .74929 L p .863 g
F P
0 g
s
.71624 .74929 m .74646 .71451 L .76466 .74704 L p .863 g
F P
0 g
s
.35826 .79846 m .39755 .82202 L .39366 .83933 L p .581 g
F P
0 g
s
.43629 .8527 m .39366 .83933 L .39755 .82202 L p .636 g
F P
0 g
s
.7781 .4421 m .77874 .47866 L .71203 .442 L p .673 g
F P
0 g
s
.71203 .442 m .71156 .40477 L .7781 .4421 L p .673 g
F P
0 g
s
.52632 .86433 m .57176 .86231 L .56971 .86805 L closepath p .775 g
F P
0 g
s
.28611 .47023 m .29007 .50986 L .24062 .55179 L p .282 g
F P
0 g
s
.25072 .59106 m .24062 .55179 L .29007 .50986 L p .354 g
F P
0 g
s
.43629 .8527 m .48083 .8611 L .48225 .86689 L p .685 g
F P
0 g
s
.52632 .86433 m .48225 .86689 L .48083 .8611 L closepath p .733 g
F P
0 g
s
.61618 .85512 m .57176 .86231 L .57072 .85648 L p .809 g
F P
0 g
s
.57072 .85648 m .61448 .84348 L .61618 .85512 L p .809 g
F P
0 g
s
.39755 .82202 m .43928 .8411 L .43629 .8527 L p .636 g
F P
0 g
s
.48083 .8611 m .43629 .8527 L .43928 .8411 L p .686 g
F P
0 g
s
.28676 .67008 m .31207 .70807 L .29034 .74015 L p .447 g
F P
0 g
s
.32227 .77096 m .29034 .74015 L .31207 .70807 L p .504 g
F P
0 g
s
.80917 .59996 m .79339 .63899 L .75199 .60146 L p .798 g
F P
0 g
s
.75199 .60146 m .76566 .5592 L .80917 .59996 L p .798 g
F P
0 g
s
.73253 .77679 m .69628 .80318 L .68233 .78099 L p .852 g
F P
0 g
s
.68233 .78099 m .71624 .74929 L .73253 .77679 L p .852 g
F P
0 g
s
.52632 .86433 m .57072 .85648 L .57176 .86231 L closepath p .774 g
F P
0 g
s
.36076 .36547 m .35716 .39846 L .28672 .43351 L p .261 g
F P
0 g
s
.28611 .47023 m .28672 .43351 L .35716 .39846 L p .338 g
F P
0 g
s
.43928 .8411 m .48252 .8553 L .48083 .8611 L p .686 g
F P
0 g
s
.52632 .86433 m .48083 .8611 L .48252 .8553 L closepath p .732 g
F P
0 g
s
.52632 .86433 m .55971 .84614 L .56662 .85096 L closepath p .766 g
F P
0 g
s
.52632 .86433 m .55045 .84237 L .55971 .84614 L closepath p .761 g
F P
0 g
s
.52632 .86433 m .53948 .83991 L .55045 .84237 L closepath p .756 g
F P
0 g
s
.52632 .86433 m .52757 .83896 L .53948 .83991 L closepath p .751 g
F P
0 g
s
.52632 .86433 m .51557 .83959 L .52757 .83896 L closepath p .746 g
F P
0 g
s
.52632 .86433 m .50434 .84174 L .51557 .83959 L closepath p .741 g
F P
0 g
s
.52632 .86433 m .49467 .84526 L .50434 .84174 L closepath p .737 g
F P
0 g
s
.52632 .86433 m .48723 .84989 L .49467 .84526 L closepath p .734 g
F P
0 g
s
.52632 .86433 m .48252 .8553 L .48723 .84989 L closepath p .733 g
F P
0 g
s
.52632 .86433 m .56662 .85096 L .57072 .85648 L closepath p .771 g
F P
0 g
s
.62235 .31929 m .62635 .34688 L .5359 .3371 L p .468 g
F P
0 g
s
.5359 .3371 m .53552 .30976 L .62235 .31929 L p .468 g
F P
0 g
s
.70763 .37176 m .71156 .40477 L .62855 .37979 L p .578 g
F P
0 g
s
.62855 .37979 m .62635 .34688 L .70763 .37176 L p .578 g
F P
0 g
s
.44456 .34354 m .44784 .31604 L .53552 .30976 L p .398 g
F P
0 g
s
.44784 .31604 m .44456 .34354 L .36076 .36547 L p .303 g
F P
0 g
s
.69628 .80318 m .65664 .82558 L .64552 .80889 L p .838 g
F P
0 g
s
.64552 .80889 m .68233 .78099 L .69628 .80318 L p .838 g
F P
0 g
s
.31207 .70807 m .3416 .74386 L .32227 .77096 L p .504 g
F P
0 g
s
.35826 .79846 m .32227 .77096 L .3416 .74386 L p .555 g
F P
0 g
s
.61448 .84348 m .57072 .85648 L .56662 .85096 L p .798 g
F P
0 g
s
.44834 .83021 m .48723 .84989 L .48252 .8553 L p .69 g
F P
0 g
s
.48252 .8553 m .43928 .8411 L .44834 .83021 L p .69 g
F P
0 g
s
.29007 .50986 m .29862 .55157 L .25072 .59106 L p .354 g
F P
0 g
s
.26618 .63078 m .25072 .59106 L .29862 .55157 L p .413 g
F P
0 g
s
.65664 .82558 m .61448 .84348 L .60665 .83237 L p .82 g
F P
0 g
s
.60665 .83237 m .64552 .80889 L .65664 .82558 L p .82 g
F P
0 g
s
.56662 .85096 m .60665 .83237 L .61448 .84348 L p .798 g
F P
0 g
s
.53552 .30976 m .5359 .3371 L .44456 .34354 L p .398 g
F P
0 g
s
.35716 .39846 m .36076 .36547 L .44456 .34354 L p .376 g
F P
0 g
s
.3416 .74386 m .37467 .77663 L .35826 .79846 L p .555 g
F P
0 g
s
.39755 .82202 m .35826 .79846 L .37467 .77663 L p .602 g
F P
0 g
s
.77874 .47866 m .7746 .51797 L .70893 .48272 L p .7 g
F P
0 g
s
.70893 .48272 m .71203 .442 L .77874 .47866 L p .7 g
F P
0 g
s
.79339 .63899 m .77236 .67746 L .73384 .64378 L p .805 g
F P
0 g
s
.73384 .64378 m .75199 .60146 L .79339 .63899 L p .805 g
F P
0 g
s
.41053 .80562 m .44834 .83021 L .43928 .8411 L p .646 g
F P
0 g
s
.43928 .8411 m .39755 .82202 L .41053 .80562 L p .646 g
F P
0 g
s
.37467 .77663 m .41053 .80562 L .39755 .82202 L p .602 g
F P
0 g
s
.60665 .83237 m .56662 .85096 L .55971 .84614 L p .784 g
F P
0 g
s
.46298 .82081 m .49467 .84526 L .48723 .84989 L p .696 g
F P
0 g
s
.48723 .84989 m .44834 .83021 L .46298 .82081 L p .696 g
F P
0 g
s
.35716 .39846 m .35672 .43579 L .28611 .47023 L p .338 g
F P
0 g
s
.29007 .50986 m .28611 .47023 L .35672 .43579 L p .397 g
F P
0 g
s
.55971 .84614 m .59311 .8226 L .60665 .83237 L p .784 g
F P
0 g
s
.59311 .8226 m .55971 .84614 L .55045 .84237 L p .769 g
F P
0 g
s
.29862 .55157 m .31168 .59445 L .26618 .63078 L p .413 g
F P
0 g
s
.28676 .67008 m .26618 .63078 L .31168 .59445 L p .463 g
F P
0 g
s
.48222 .81362 m .50434 .84174 L .49467 .84526 L p .704 g
F P
0 g
s
.49467 .84526 m .46298 .82081 L .48222 .81362 L p .704 g
F P
0 g
s
.77236 .67746 m .74646 .71451 L .71158 .68516 L p .808 g
F P
0 g
s
.71158 .68516 m .73384 .64378 L .77236 .67746 L p .808 g
F P
0 g
s
.64552 .80889 m .60665 .83237 L .59311 .8226 L p .796 g
F P
0 g
s
.55045 .84237 m .57472 .8149 L .59311 .8226 L p .769 g
F P
0 g
s
.57472 .8149 m .55045 .84237 L .53948 .83991 L p .754 g
F P
0 g
s
.50473 .80921 m .51557 .83959 L .50434 .84174 L p .714 g
F P
0 g
s
.50434 .84174 m .48222 .81362 L .50473 .80921 L p .714 g
F P
0 g
s
.43196 .79138 m .46298 .82081 L .44834 .83021 L p .658 g
F P
0 g
s
.44834 .83021 m .41053 .80562 L .43196 .79138 L p .658 g
F P
0 g
s
.53948 .83991 m .55277 .80988 L .57472 .8149 L p .754 g
F P
0 g
s
.55277 .80988 m .53948 .83991 L .52757 .83896 L p .74 g
F P
0 g
s
.71156 .40477 m .71203 .442 L .62882 .41746 L p .614 g
F P
0 g
s
.62882 .41746 m .62855 .37979 L .71156 .40477 L p .614 g
F P
0 g
s
.52884 .80793 m .52757 .83896 L .51557 .83959 L p .726 g
F P
0 g
s
.51557 .83959 m .50473 .80921 L .52884 .80793 L p .726 g
F P
0 g
s
.7746 .51797 m .76566 .5592 L .70222 .52606 L p .719 g
F P
0 g
s
.70222 .52606 m .70893 .48272 L .7746 .51797 L p .719 g
F P
0 g
s
.62635 .34688 m .62855 .37979 L .53612 .36996 L p .52 g
F P
0 g
s
.53612 .36996 m .5359 .3371 L .62635 .34688 L p .52 g
F P
0 g
s
.74646 .71451 m .71624 .74929 L .68572 .7246 L p .809 g
F P
0 g
s
.68572 .7246 m .71158 .68516 L .74646 .71451 L p .809 g
F P
0 g
s
.52757 .83896 m .52884 .80793 L .55277 .80988 L p .74 g
F P
0 g
s
.68233 .78099 m .64552 .80889 L .62576 .7941 L p .803 g
F P
0 g
s
.59311 .8226 m .62576 .7941 L .64552 .80889 L p .796 g
F P
0 g
s
.31168 .59445 m .32901 .6375 L .28676 .67008 L p .463 g
F P
0 g
s
.31207 .70807 m .28676 .67008 L .32901 .6375 L p .507 g
F P
0 g
s
.44277 .37644 m .44456 .34354 L .5359 .3371 L p .456 g
F P
0 g
s
.44456 .34354 m .44277 .37644 L .35716 .39846 L p .376 g
F P
0 g
s
.71624 .74929 m .68233 .78099 L .65688 .7612 L p .807 g
F P
0 g
s
.65688 .7612 m .68572 .7246 L .71624 .74929 L p .807 g
F P
0 g
s
.62576 .7941 m .65688 .7612 L .68233 .78099 L p .803 g
F P
0 g
s
.40235 .75754 m .43196 .79138 L .41053 .80562 L p .622 g
F P
0 g
s
.41053 .80562 m .37467 .77663 L .40235 .75754 L p .622 g
F P
0 g
s
.35672 .43579 m .35716 .39846 L .44277 .37644 L p .43 g
F P
0 g
s
.62576 .7941 m .59311 .8226 L .57472 .8149 L p .771 g
F P
0 g
s
.32901 .6375 m .35024 .6797 L .31207 .70807 L p .507 g
F P
0 g
s
.3416 .74386 m .31207 .70807 L .35024 .6797 L p .547 g
F P
0 g
s
.35672 .43579 m .35956 .47675 L .29007 .50986 L p .397 g
F P
0 g
s
.29862 .55157 m .29007 .50986 L .35956 .47675 L p .444 g
F P
0 g
s
.5359 .3371 m .53612 .36996 L .44277 .37644 L p .456 g
F P
0 g
s
.46047 .78042 m .48222 .81362 L .46298 .82081 L p .672 g
F P
0 g
s
.46298 .82081 m .43196 .79138 L .46047 .78042 L p .672 g
F P
0 g
s
.37489 .72003 m .40235 .75754 L .37467 .77663 L p .585 g
F P
0 g
s
.37467 .77663 m .3416 .74386 L .37489 .72003 L p .585 g
F P
0 g
s
.35024 .6797 m .37489 .72003 L .3416 .74386 L p .547 g
F P
0 g
s
.76566 .5592 m .75199 .60146 L .69199 .57103 L p .733 g
F P
0 g
s
.69199 .57103 m .70222 .52606 L .76566 .5592 L p .733 g
F P
0 g
s
.57472 .8149 m .59857 .78238 L .62576 .7941 L p .771 g
F P
0 g
s
.59857 .78238 m .57472 .8149 L .55277 .80988 L p .748 g
F P
0 g
s
.49403 .77367 m .50473 .80921 L .48222 .81362 L p .688 g
F P
0 g
s
.48222 .81362 m .46047 .78042 L .49403 .77367 L p .688 g
F P
0 g
s
.65688 .7612 m .62576 .7941 L .59857 .78238 L p .77 g
F P
0 g
s
.71203 .442 m .70893 .48272 L .62708 .45914 L p .641 g
F P
0 g
s
.62708 .45914 m .62882 .41746 L .71203 .442 L p .641 g
F P
0 g
s
.35956 .47675 m .36571 .52046 L .29862 .55157 L p .444 g
F P
0 g
s
.31168 .59445 m .29862 .55157 L .36571 .52046 L p .484 g
F P
0 g
s
.4396 .74278 m .46047 .78042 L .43196 .79138 L p .642 g
F P
0 g
s
.43196 .79138 m .40235 .75754 L .4396 .74278 L p .642 g
F P
0 g
s
.55277 .80988 m .56587 .77469 L .59857 .78238 L p .748 g
F P
0 g
s
.56587 .77469 m .55277 .80988 L .52884 .80793 L p .726 g
F P
0 g
s
.62855 .37979 m .62882 .41746 L .53614 .4078 L p .558 g
F P
0 g
s
.53614 .4078 m .53612 .36996 L .62855 .37979 L p .558 g
F P
0 g
s
.53009 .7717 m .52884 .80793 L .50473 .80921 L p .706 g
F P
0 g
s
.50473 .80921 m .49403 .77367 L .53009 .7717 L p .706 g
F P
0 g
s
.75199 .60146 m .73384 .64378 L .67844 .61655 L p .745 g
F P
0 g
s
.67844 .61655 m .69199 .57103 L .75199 .60146 L p .745 g
F P
0 g
s
.52884 .80793 m .53009 .7717 L .56587 .77469 L p .726 g
F P
0 g
s
.44277 .37644 m .44255 .41416 L .35672 .43579 L p .43 g
F P
0 g
s
.35956 .47675 m .35672 .43579 L .44255 .41416 L p .473 g
F P
0 g
s
.44255 .41416 m .44277 .37644 L .53612 .36996 L p .499 g
F P
0 g
s
.68572 .7246 m .65688 .7612 L .62143 .74542 L p .766 g
F P
0 g
s
.59857 .78238 m .62143 .74542 L .65688 .7612 L p .77 g
F P
0 g
s
.73384 .64378 m .71158 .68516 L .66188 .66152 L p .753 g
F P
0 g
s
.66188 .66152 m .67844 .61655 L .73384 .64378 L p .753 g
F P
0 g
s
.36571 .52046 m .37508 .56589 L .31168 .59445 L p .484 g
F P
0 g
s
.32901 .6375 m .31168 .59445 L .37508 .56589 L p .52 g
F P
0 g
s
.42016 .7015 m .4396 .74278 L .40235 .75754 L p .612 g
F P
0 g
s
.40235 .75754 m .37489 .72003 L .42016 .7015 L p .612 g
F P
0 g
s
.53612 .36996 m .53614 .4078 L .44255 .41416 L p .499 g
F P
0 g
s
.71158 .68516 m .68572 .7246 L .64271 .70482 L p .761 g
F P
0 g
s
.62143 .74542 m .64271 .70482 L .68572 .7246 L p .766 g
F P
0 g
s
.62143 .74542 m .59857 .78238 L .56587 .77469 L p .739 g
F P
0 g
s
.64271 .70482 m .66188 .66152 L .71158 .68516 L p .761 g
F P
0 g
s
.70893 .48272 m .70222 .52606 L .62333 .50391 L p .662 g
F P
0 g
s
.62333 .50391 m .62708 .45914 L .70893 .48272 L p .662 g
F P
0 g
s
.48373 .73365 m .49403 .77367 L .46047 .78042 L p .663 g
F P
0 g
s
.46047 .78042 m .4396 .74278 L .48373 .73365 L p .663 g
F P
0 g
s
.37508 .56589 m .38748 .61197 L .32901 .6375 L p .52 g
F P
0 g
s
.35024 .6797 m .32901 .6375 L .38748 .61197 L p .552 g
F P
0 g
s
.40264 .65755 m .42016 .7015 L .37489 .72003 L p .582 g
F P
0 g
s
.37489 .72003 m .35024 .6797 L .40264 .65755 L p .582 g
F P
0 g
s
.38748 .61197 m .40264 .65755 L .35024 .6797 L p .552 g
F P
0 g
s
.44255 .41416 m .44397 .45597 L .35956 .47675 L p .473 g
F P
0 g
s
.36571 .52046 m .35956 .47675 L .44397 .45597 L p .509 g
F P
0 g
s
.56587 .77469 m .57846 .73503 L .62143 .74542 L p .739 g
F P
0 g
s
.57846 .73503 m .56587 .77469 L .53009 .7717 L p .711 g
F P
0 g
s
.62882 .41746 m .62708 .45914 L .53597 .44986 L p .587 g
F P
0 g
s
.53597 .44986 m .53614 .4078 L .62882 .41746 L p .587 g
F P
0 g
s
.5313 .73098 m .53009 .7717 L .49403 .77367 L p .686 g
F P
0 g
s
.49403 .77367 m .48373 .73365 L .5313 .73098 L p .686 g
F P
0 g
s
.53009 .7717 m .5313 .73098 L .57846 .73503 L p .711 g
F P
0 g
s
.44397 .45597 m .44255 .41416 L .53614 .4078 L p .533 g
F P
0 g
s
.64271 .70482 m .62143 .74542 L .57846 .73503 L p .729 g
F P
0 g
s
.70222 .52606 m .69199 .57103 L .61762 .55073 L p .679 g
F P
0 g
s
.61762 .55073 m .62333 .50391 L .70222 .52606 L p .679 g
F P
0 g
s
.47412 .69 m .48373 .73365 L .4396 .74278 L p .639 g
F P
0 g
s
.4396 .74278 m .42016 .7015 L .47412 .69 L p .639 g
F P
0 g
s
.53614 .4078 m .53597 .44986 L .44397 .45597 L p .533 g
F P
0 g
s
.44397 .45597 m .44704 .50094 L .36571 .52046 L p .509 g
F P
0 g
s
.37508 .56589 m .36571 .52046 L .44704 .50094 L p .539 g
F P
0 g
s
.66188 .66152 m .64271 .70482 L .59023 .69175 L p .718 g
F P
0 g
s
.57846 .73503 m .59023 .69175 L .64271 .70482 L p .729 g
F P
0 g
s
.69199 .57103 m .67844 .61655 L .61007 .59844 L p .694 g
F P
0 g
s
.61007 .59844 m .61762 .55073 L .69199 .57103 L p .694 g
F P
0 g
s
.59023 .69175 m .57846 .73503 L .5313 .73098 L p .696 g
F P
0 g
s
.62708 .45914 m .62333 .50391 L .53561 .49521 L p .611 g
F P
0 g
s
.53561 .49521 m .53597 .44986 L .62708 .45914 L p .611 g
F P
0 g
s
.46542 .64375 m .47412 .69 L .42016 .7015 L p .615 g
F P
0 g
s
.42016 .7015 m .40264 .65755 L .46542 .64375 L p .615 g
F P
0 g
s
.67844 .61655 m .66188 .66152 L .60086 .64584 L p .707 g
F P
0 g
s
.59023 .69175 m .60086 .64584 L .66188 .66152 L p .718 g
F P
0 g
s
.53243 .68664 m .5313 .73098 L .48373 .73365 L p .667 g
F P
0 g
s
.48373 .73365 m .47412 .69 L .53243 .68664 L p .667 g
F P
0 g
s
.60086 .64584 m .61007 .59844 L .67844 .61655 L p .707 g
F P
0 g
s
.44704 .50094 m .45171 .54801 L .37508 .56589 L p .539 g
F P
0 g
s
.38748 .61197 m .37508 .56589 L .45171 .54801 L p .566 g
F P
0 g
s
.44704 .50094 m .44397 .45597 L .53597 .44986 L p .562 g
F P
0 g
s
.5313 .73098 m .53243 .68664 L .59023 .69175 L p .696 g
F P
0 g
s
.45789 .59602 m .46542 .64375 L .40264 .65755 L p .591 g
F P
0 g
s
.40264 .65755 m .38748 .61197 L .45789 .59602 L p .591 g
F P
0 g
s
.45171 .54801 m .45789 .59602 L .38748 .61197 L p .566 g
F P
0 g
s
.53597 .44986 m .53561 .49521 L .44704 .50094 L p .562 g
F P
0 g
s
.60086 .64584 m .59023 .69175 L .53243 .68664 L p .681 g
F P
0 g
s
.62333 .50391 m .61762 .55073 L .53506 .54276 L p .631 g
F P
0 g
s
.53506 .54276 m .53561 .49521 L .62333 .50391 L p .631 g
F P
0 g
s
.53345 .6397 m .53243 .68664 L .47412 .69 L p .647 g
F P
0 g
s
.47412 .69 m .46542 .64375 L .53345 .6397 L p .647 g
F P
0 g
s
.45171 .54801 m .44704 .50094 L .53561 .49521 L p .586 g
F P
0 g
s
.53243 .68664 m .53345 .6397 L .60086 .64584 L p .681 g
F P
0 g
s
.61007 .59844 m .60086 .64584 L .53345 .6397 L p .666 g
F P
0 g
s
.61762 .55073 m .61007 .59844 L .53434 .59134 L p .649 g
F P
0 g
s
.53434 .59134 m .53506 .54276 L .61762 .55073 L p .649 g
F P
0 g
s
.53561 .49521 m .53506 .54276 L .45171 .54801 L p .586 g
F P
0 g
s
.53434 .59134 m .53345 .6397 L .46542 .64375 L p .628 g
F P
0 g
s
.46542 .64375 m .45789 .59602 L .53434 .59134 L p .628 g
F P
0 g
s
.53345 .6397 m .53434 .59134 L .61007 .59844 L p .666 g
F P
0 g
s
.45789 .59602 m .45171 .54801 L .53506 .54276 L p .608 g
F P
0 g
s
.53506 .54276 m .53434 .59134 L .45789 .59602 L p .608 g
F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
gsave
.09072 .22988 -74.7418 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.22871 .18658 m
.23354 .19204 L
s
gsave
.21906 .17566 -80.3756 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.36358 .12987 m
.36813 .13557 L
s
gsave
.3545 .11847 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.50609 .06995 m
.51031 .07589 L
s
gsave
.49765 .05807 -73.877 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.65689 .00654 m
.66074 .01273 L
s
gsave
.64919 -0.00583 -67.8447 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
gsave
.30907 .06148 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellFrame->False,
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  ImageSize->{474.625, 338},
  ImageMargins->{{0, 0}, {0, 12}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007J0001DQ000`40O003h00Oogoofgoo003oOooK
Ool00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00
ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo001EOol2000017oo001oogoo0P00ogooOWoo001D
Ool01000Oomoo`001Goo00<007ooOol0ogoo9Woo0P0000Aoo`00Oomoo`8004eoo`00?goo00<007oo
00004Woo00@007ooOol000Eoo`03001oogoo0?moobEoo`04001oogoo0005Ool00`00Oomoo`1:Ool0
03moo`03001oo`00019oo`04001oogoo0002Ool01000Oomoo`00ogoo9goo00@007ooOol000Eoo`03
001oogoo04Yoo`00@7oo00<007ooOol00Woo0P0000=oo`00Ool0100000=oo`0000000goo00@007oo
Ool0009oo`<000ioo`800004Ool007ooOol2003oOolBOol01000Oomoo`000Woo00@007ooOol004ao
o`00?goo00<007oo00000Woo00@007ooOol0009oo`03001oogoo00Aoo`04001oogooOol20004Ool3
0008Ool50002Ool00`00Oomoo`03Ool00`00Oomoo`3eOol00`00Ool0000FOol01000Oomoo`000Woo
0`00CGoo000oOol00`00Ool00002Ool01000Oomoo`000goo00<007ooOol00goo00<007ooOol037oo
0P0027oo00@007ooOol000Eoo`03001oogoo0?Eoo`03001oo`0001Moo`8000Aoo`<004aoo`00A7oo
00@007ooOol000Eoo`80009oo`03001oogoo00Uoo`D000Qoo`04001oogoo0002Ool01000Oomoo`00
n7oo00<007ooOol01Goo0P0000=oo`00Ool0100000=oo`0000007goo00<007ooOol0>7oo0014Ool2
00001Goo001oogoo00000Woo10002Woo100000Aoo`00000000Moo`04001oogoo0002Ool3003hOol0
0`00Ool00005Ool01000Oomoo`000Woo00<007ooOol017oo00<007ooOol03Woo0P001Goo10000goo
00<007ooOol0>7oo0013Ool01000Ool0000017oo0P000Woo0`001Woo10001Goo0`001goo0P0017oo
0`00mgoo00<007oo00001Goo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo00]oo`D000ao
o`03001oogoo03Qoo`00@goo00@007ooOol000ioo`<00003Ool007oo00Ioo`03001oo`000?mooa1o
o`04001oogoo0005Ool20002Ool00`00Oomoo`09Ool30002Ool3000;Ool00`00Oomoo`0hOol004=o
o`04001oogoo000<Ool20002Ool00`00Oomoo`07Ool01000Ool00000ogoo3goo00@007ooOol0009o
o`03001oogoo00@000Uoo`@000Eoo`<000Uoo`8003Yoo`00@goo00@007ooOol000Uoo`<0009oo`03
001oogoo00Uoo`03001oogoo008000]oo`800003Ool007oo00@00003Ool000000?Aoo`800003Ool0
000000Aoo`80009oo`<000Ioo`<000Qoo`04001oogoo0009Ool00`00Oomoo`0hOol002moo`800003
Ool007oo00@00003Ool0000000Uoo`8000Qoo`<00003Ool007oo00eoo`05001oogooOol00006Ool5
0002Ool01000Oomoo`001Woo00<007ooOol0l7oo00@007ooOol0011oo`<000]oo`04001oogoo0014
Ool002Yoo`D0009oo`04001oogoo0006Ool00`00Oomoo`0=Ool4000BOol01000Oomoogoo0P002Goo
00@007ooOol000=oo`03001oogoo00=oo`03001oogoo0?1oo`04001oogoo000>Ool2000>Ool01@00
Oomoogoo0000@goo000^Ool01000Oomoo`000goo00<007ooOol00goo00<007ooOol02goo0P0000=o
o`00Ool04goo00<007ooOol00goo00<007ooOol01Woo00@007ooOol000Eoo`80009oo`03001oogoo
0?1oo`04001oogoo000;Ool30002Ool00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`10Ool0
02ioo`04001oogoo0005Ool20002Ool00`00Oomoo`08Ool5000FOol00`00Oomoo`02Ool00`00Ool0
0007Ool01000Oomoo`000Woo00<007ooOol01000lgoo00@007ooOol000Uoo`80009oo`03001oogoo
00ioo`03001oogoo00=oo`03001oogoo03moo`00:7oo0P0000Aoo`00Oomoo`800005Ool007ooOol0
0002Ool40009Ool20002Ool00`00Oomoo`0FOol00`00Oomoo`04Ool00`00Oomoo`06Ool20004Ool2
00000goo00000002003LOol200000goo001oo`0400000goo0000000;Ool20007Ool30002Ool00`00
Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`0oOol002=oo`D0009oo`03001oogoo009oo`8000Ao
o`80009oo`<000Eoo`<00003Ool007oo01Yoo`03001oogoo00Eoo`03001oogoo00eoo`03001oo`00
0=Qoo`@00005Ool007ooOol00002Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool30002Ool00`00Oomo
o`0COol00`00Oomoo`04Ool00`00Oomoo`0nOol002Moo`04001oogoo0005Ool00`00Oomoo`0;Ool4
00000goo001oo`0LOol00`00Oomoo`05Ool2000>Ool00`00Ool0003MOol01000Oomoo`000goo00<0
07ooOol00goo00<007ooOol037oo0`0000=oo`00Ool05goo00<007ooOol01Goo00<007ooOol0?Goo
000WOol01000Oomoo`000Woo00@007ooOol000]oo`800003Ool007oo021oo`03001oogoo00Ioo`03
001oogoo00Aoo`8000Ioo`03001oo`000=eoo`04001oogoo0005Ool20002Ool00`00Oomoo`09Ool3
0002Ool00`00Oomoo`0HOol00`00Oomoo`05Ool00`00Oomoo`0mOol002Moo`04001oogoo0002Ool3
0009Ool300000goo001oo`0ROol00`00Oomoo`07Ool00`00Oomoo`02Ool01000Oomoo`0017oo00D0
07ooOomoo`000=aoo`04001oogoo0002Ool00`00Oomoo`04000:Ool300000goo001oo`0LOol00`00
Oomoo`06Ool00`00Oomoo`0lOol002Qoo`8000Aoo`<000Ioo`<00003Ool007oo02Aoo`03001oogoo
00Moo`8000=oo`04001oogoo002GOol00`00Oomoo`13Ool2000017oo001oogoo0P0000=oo`000000
17oo0P000Woo0`001Woo0`000Woo00<007ooOol07Goo00<007ooOol01Woo0P00?Goo000dOol40000
0goo001oo`0VOol00`00Oomoo`08Ool01@00Oomoogoo00000Woo00<007ooOol0UGoo00<007ooOol0
?Woo1@000Woo00<007ooOol00goo00<007ooOol03goo0`0000=oo`00Ool08Goo00<007ooOol027oo
00<007ooOol0>Woo000cOol3000[Ool00`00Oomoo`09Ool01000Oomoo`000Woo00<007ooOol0UGoo
00<007ooOol0@Woo00@007ooOol000Eoo`03001oogoo00aoo`<0009oo`03001oogoo029oo`03001o
ogoo00Qoo`03001oogoo03Yoo`00<goo00<007ooOol0:goo00<007ooOol02Goo0P000Woo0P00V7oo
00<007ooOol0@Woo00@007ooOol0009oo`04001oogoo000<Ool30002Ool00`00Oomoo`0TOol00`00
Oomoo`09Ool2000;Ool2000017oo001oogoo0P009goo000cOol2000/Ool00`00Oomoo`0:Ool2002J
Ool2000?Ool2000017oo001oogoo0P00;Goo00@007ooOol0009oo`<000Yoo`<0009oo`03001oogoo
02Moo`03001oogoo00Yoo`03001oogoo00Aoo`D0009oo`03001oogoo00=oo`03001oogoo02Aoo`00
<goo00<007oo00006Woo3P000goo00<007ooOol02goo0P001Goo0P0000=oo`00Ool0100000=oo`00
0000RGoo00<007ooOol01goo100000Eoo`00Oomoo`0000Eoo`03001oogoo02]oo`8000Aoo`<000Mo
o`<002ioo`03001oogoo00]oo`03001oogoo00Moo`04001oogoo0005Ool00`00Oomoo`0TOol002eo
o`03001oogoo00=oo`04001oogoo000FOolE000=Ool20004Ool01000Oomoo`000Woo00<007ooOol0
17oo00<007ooOol0UGoo00@007ooOol000Eoo`03001oogoo03Qoo`@0031oo`03001oogoo00]oo`03
001oogoo00Moo`04001oogoo0002Ool01000Oomoo`009Woo000WOol40002Ool00`00Oomoo`03Ool0
1@00Oomoogoo00004Woo10000aBU00<002DY9BT00bDY00<002e[;F/00Re[00<003F]000010003Goo
0P000goo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo08Uoo`04001oo`000008Ool01000
Oomoo`000Woo00@007ooOol003Uoo`8003=oo`03001oogoo00aoo`03001oogoo00Ioo`04001oogoo
0002Ool3000WOol002eoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00ioo`030008@P00
00@DY@04000U:BDY9BT70002;F/01000=Jde[CF]100037oo0P000Woo00@007ooOol000Eoo`80009o
o`03001oogoo06Yoo`800004Ool007ooOol2000FOol300000goo001oo`07Ool01000Oomoo`000Woo
0`00>Woo0P00<goo00<007ooOol03Goo00<007ooOol01Woo0P0017oo0`009Woo000]Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00248000025:D70003>Lh01000@Q12448@1@00
00<e[@0000000`002goo0P000Woo00@007ooOol0009oo`03001oogoo00@006aoo`04001oogoo0005
Ool00`00Oomoo`0@Ool30004Ool20008Ool20004Ool3000iOol2000cOol00`00Oomoo`0>Ool00`00
Oomoo`0dOol002aoo`8000Aoo`03001oogoo00Eoo`03001oogoo00Yoo`030008@P0000<000<]J`03
000icSW>00@icP030012448@00=24003001:DTYB00<000<icP03001oogoo00Uoo`80009oo`8000Ao
o`80009oo`<005Yoo`03001oo`0000ioo`04001oogoo0005Ool00`00Oomoo`0<Ool40007Ool3000k
Ool2000017oo001oogoo0P001Woo00<007oo00009Woo1P001Woo00<007ooOol03Woo0P00=Goo000]
Ool00`00Oomoo`02Ool20007Ool00`00Oomoo`08Ool300000b48000]J`04;F/00`00>LhicP04>Lh0
0`00@Q124003@Q000`00BU9:DP02BU8300000cW>0000000;Ool2001XOol00`00Ool0000>Ool01000
Oomoo`000Woo00@007ooOol000eoo`8000Yoo`04001oo`00000:Ool200000goo001oo`0400000goo
0000000NOol400001Goo001oogoo00001Goo00<007ooOol00Woo0P000Woo00<007ooOol077oo1`00
0`Q200<001cW7>L00`000goo00<007ooOol03goo00<007ooOol0<goo000bOol00`00Oomoo`07Ool0
0`00Oomoo`06Ool200038@P00`00;F/]J`03;F/00`00>LhicP04>Lh00`00@Q124003@Q000`00BU9:
DP02BU8200000dic00000002000;Ool00`00Oomoo`04Ool2000017oo001oogoo0P00Fgoo00<007oo
Ool03Goo00@007ooOol0009oo`<000]oo`<000aoo`04001oo`000005Ool50002Ool01000Oomoo`00
1Woo00<007ooOol087oo00@007ooOol000Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo
01Moo`@000H8@PH000@Li`@0019oo`03001oogoo039oo`00<Woo00<007ooOol01goo00<007ooOol0
1Goo0P00124800<002e[;F/00Re[30000T8@00<004YBBU800TYB0P000dic00<0036<00002Woo0P00
17oo00@007ooOol000Eoo`03001oogoo05Moo`03001oo`0000moo`8000Aoo`<000Ioo`@000moo`03
001oogoo008000Qoo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`0POol01000Oomoo`00
0Woo00@007ooOol000Aoo`8000Aoo`03001oogoo01Eoo`800088@PL000<Li`03000e[CF]00<000@L
i`<0011oo`03001oogoo039oo`00<Woo00<007ooOol027oo00<007ooOol00goo00<000aS00001248
00<002e[00000P0000<mk`00@Q001D8@00@004YBBU9:DPP00003BU8004ic009>L`8000]oo`8000=o
o`04001oogoo0005Ool00`00Oomoo`1GOol00`00Ool0000LOol3000COol00`00Oomoo`020007Ool0
1000Oomoo`000Woo0P0000=oo`0000000Woo00<007ooOol087oo00@007ooOol0009oo`<000Eoo`03
001oogoo00Aoo`03001oogoo019oo`H000TLi`03000e[CF]00@e[@D00004248Li`00000?Ool00`00
Oomoo`0aOol0039oo`8000Yoo`05001oogooOol0000236<010008@PQ22480`0013g_00<0048@@Q00
148@00<004YBBU800dYB00<005:DDY@00U:D10000Tic0`002goo0P000Woo00@007ooOol0009oo`04
001oogoo001MOol2000GOol2000FOol01@00Oomoogoo00001goo00@007ooOol0009oo`800003Ool0
0000008002Aoo`8000Aoo`<000Aoo`03001oogoo00Eoo`03001oogoo011oo`@000PLi`L000Pe[@<0
00037>L007oo00moo`03001oogoo015oo`8001eoo`00<Woo00<007ooOol02Woo00<007oo00000PaS
00<002488@P00P0000<aS000?Nl013g_00<0048@@Q00148@00<004YBBU800dYB00<005:DDY@00U:D
00@005:D001F]@<00003E[D007oo00Yoo`80009oo`04001oogoo0002Ool3001MOol01000Oomoo`00
4Woo100067oo00D007ooOomoo`0000Qoo`8000Aoo`80009oo`<0031oo`03001oogoo00Ioo`03001o
ogoo00eoo`D0008Li`L000@aS0030016<DHa00@000@e[@03000e[CF]00<0011oo`03001oogoo015o
o`03001oogoo01]oo`00<Woo00<007ooOol02goo0P000PaS0`000c6<00<003g_?Nl00cg_00<0048@
@Q00148@00<004YBBU800dYB00<005:DDY@00U:D00<005:D00000eJe0P0000=F]@00Ool01Woo0`00
00=oo`00Ool00Woo0P0017oo0`00G7oo00@007ooOol0011oo`<001]oo`03001oogoo009oo`03001o
ogoo00Yoo`03001oo`0003Eoo`03001oogoo00Moo`03001oogoo00]oo`P000/aS0030016<DHa00A6
<@<00003=Jd003F]008e[@030016<@0000moo`80019oo`03001oogoo01]oo`00<Woo00<007ooOol0
2goo0P0000<<H`0000001C6<00<003g_?Nl00cg_00<0048@@Q00148@00<004YBBU800dYB00<005:D
DY@00U:D00<005:D000015Je00<005Je000017oo0`0017oo00<007ooOol0IWoo00@007ooOol000eo
o`<001ioo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`03001oo`0003Eoo`03001oogoo00Qo
o`03001oogoo00Uoo`@0000336<0036<00`aS0030016<DHa00Q6<@@00005=Jd004HaAS40000?Ool0
0`00Oomoo`0?Ool00`00Ool0000LOol0039oo`8000aoo`05000<H`009BT00005<H`00`00?Nlmk`02
?NlA0002DY@20005E[D00`00E[D000040007Ool00`00Oomoo`1VOol01000Oomoo`002Woo0`008Goo
00<007ooOol00goo00<007ooOol00Woo00@007ooOol000=oo`03001oo`0003Aoo`8000]oo`03001o
ogoo00Moo`@0008<H`03000aS36<00/aS0030016<DHa00U6<@030016<DHa00<00096<@03001oogoo
00eoo`03001oogoo00ioo`03001oo`0001aoo`00<Woo00<007ooOol02Woo0`000RDY00<0036<<H`0
0c6<00<003g_00000P0000=6<@00BU801DYB00<004icCW<00dic00<005JeE[D010001EJe0P0000=F
]@00Ool02Goo00<007ooOol0Igoo0P002Goo0`008goo00<007ooOol017oo00D007ooOomoo`00009o
o`04001oogoo0003Ool00`00Oomoo`0aOol00`00Oomoo`0;Ool00`00Oomoo`05Ool3000436<00`00
<H`aS009<H`60008AS401`00AS56<DHa001F]@000096<@8000ioo`03001oogoo00Aoo`8000Moo`03
001oo`0001aoo`00<Woo00<007ooOol02Woo0P0012DY00@0036<<H`aS0<000A6<@03001:DTYB00A:
DP03001>Ldic00=>L`03001F]EJe009F]@<000AF]@03001Nm`00008000Uoo`03001oogoo06moo`<0
02Ioo`03001oogoo00Aoo`80009oo`04001oogoo000XOol200000goo001oo`0400000goo00000006
Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool2000536<00`00<H`aS005<H`50002?Nl01000CW=>Ldic
1@000dHa00D004HaAS56<@00009F]@050016<DHaAS40000=Ool00`00Oomoo`03Ool01000Oomoo`00
1Goo00D007ooOomoo`0001]oo`00<Woo0P002goo0P0012DY100000<mk`00AS4014Ha00<004YBBU80
14YB00<004icCW<00dic00<005JeE[D00UJe0P0000EJeP00001F]@0000=Nm`8000Uoo`03001oogoo
04ioo`800004Ool007ooOol2000FOol3000YOol00`00Oomoo`05Ool200001Goo001oogoo00008goo
1@000Woo00@007ooOol000Ioo`03001oogoo00=oo`8000ioo`04001oogooOol2000636<00`00<H`a
S0050007?Nl00`00CW=>L`06CW<50002AS401@00E[EF]EJe00000dHa00<007ooOol02goo00<007oo
Ool00Woo00@007ooOol002Eoo`00<Woo00<007ooOol02Goo0`000bDY0P0013g_00<004HaAS4014Ha
00<004YBBU800dYB00<004icCW<00Tic00<005JeE[D00eJe0P000e[F0P000ekg0P002Goo00<007oo
Ool0B7oo100000Eoo`00Oomoo`0000Eoo`03001oogoo011oo`<002aoo`03001oogoo00Ioo`800003
Ool0000002Qoo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool0
1000Oomoo`001`aS100033g_00<004icCW<02Dic00<004ic00000`000eJe0P000THa00<007ooOol0
2goo00D007ooOomoo`00009oo`03001oogoo02=oo`0097oo0P0000Aoo`00Oomoo`8000Ioo`03001o
ogoo00Uoo`80000636<002DY000e[@0013g_00<004HaAS4014Ha00<004YBBU800dYB00<004icCW<0
0Tic00<005JeE[D00eJe0P0015[F0P000Ukg0`002Goo00<007ooOol0C7oo00@007ooOol000Eoo`03
001oogoo00ioo`<001aoo``000Ioo`03001oogoo00Ioo`03001oogoo00Aoo`800003Ool007oo00@0
0003Ool0000001Yoo`04001oogoo0005Ool20002Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool20007
36<00`00:DX0000>?Nl00`00CW=>L`09CW<01`00CW=>Ldic001JeP0000AF]@040016<DHa000<Ool2
0002Ool01000Oomoo`009Goo000OOol50002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`0036<<H`020002=Jd00`00?Nlmk`03?Nl00`00AS56<@03AS400`00BU9:DP0700000dic
001F]@04E[D00`00F]IJeP03F]H01000HaP005kg0`002Goo00<007ooOol0C7oo00@007ooOol0009o
o`04001oogoo000=Ool3000LOol5000224800`0048@@Q00248@50004Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool01000Oomoo`000Woo00<007ooOol017oo00<007ooOol05goo00@007ooOol0009oo`03
001oogoo00@000Ioo`03001oogoo00moo`03000<H`aS00<<H`80008YBP03000mkcg_00`mk`03001>
Ldic00U>L`05001>LdicCW<00002F]H00`00E[EF]@02E[D00`00AS40000=Ool01000Oomoogoo0P00
9Woo000SOol01000Oomoo`001Goo00<007ooOol00Woo0P002goo00@000aS36<000<e[@03000mkcg_
00<mk`030016<DHa00H000=>L`04001BU5:DDY@50002E[D00`00F]IJeP02F]H01000HaQS66<H0P00
00=W>@00Ool027oo00<007ooOol0C7oo00@007ooOol0009oo`<000]oo`<001eoo`@000@8@PP000<@
Q005001oogooOol0000:Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Eoo`03001oogoo01Qo
o`8000Aoo`80009oo`<000Eoo`03001oogoo00moo`04000<H`aS36<20004:DX00`00?Nlmk`0<?Nl0
0`00CW=>L`09CW<01@00CW=>Ldic00000e[F0P000eJe0P003Woo00<007ooOol0:7oo000SOol01000
Oomoo`000Woo00@007ooOol000Aoo`8000Yoo`80008<H`03000e[CF]008e[@04000mkcg_?Nl40003
BU800`00CW=>L`03CW<00`00DYABU002DY@01000F]IJeU[F10000e[F00<006<HHaP00V<H00<006Li
00002Goo00<007ooOol0CGoo0P0017oo0`001goo0`007Woo10000PQ210000R4800<0036<<H`00c6<
1P000Woo00<007ooOol01goo0P000Woo00@007ooOol000Eoo`80009oo`03001oogoo02Yoo`03001o
ogoo00ioo`80008<H`03000YBRU:00@YBP03000mkcg_00Pmk`T000M>L`05001>LdicCW<00005F]H0
1000E[EF]EJe0P003Woo00<007ooOol09goo000SOol01000Oomoo`000Woo0`001Goo00<007ooOol0
2Goo0P0000@<H`00:DX000<e[@@00003AS4004YB00A:DP03001>Ldic00=>L`03001BU5:D009BU003
001JeU[F00=JeP03001Nm`00009JeP03001S66<H009S6004001W>@000008Ool00`00Oomoo`12Ool0
0`00Oomoo`0FOol3000OOol20002248300058@P60005<H`01@00<H`007oo00002Woo0P0000Eoo`00
Oomoo`00009oo`03001oogoo00@002eoo`03001oogoo00ioo`04000<H`000007:DX01000?Nlmkcg_
1`0014Ha00<005:DDY@00U:D20000dic00<005[FF]H015[F0P0000=F]@0000003goo00<007ooOol0
9Woo000TOol20004Ool30004Ool00`00Oomoo`09Ool30002:DX01@00=Jde[CF]000014Ha00<004YB
BU800dYB00<004icCW<00Tic00<005:DDY@00e:D00<005[FF]H00e[F00<005kgG_L00P0016<H00<0
06mk00000P0027oo00<007ooOol0?7oo10000Woo00<007ooOol04goo0`008Goo1@00124810000SF]
00@0048@@Q1240D00003<H`0036<008000Yoo`80009oo`8000Aoo`80009oo`<002]oo`03001oogoo
00moo`8000PYBPD000]6<@03001BU5:D00UBU0H000MJeP<000moo`03001oogoo02Ioo`00<Goo0P00
2Woo0P000bU:00<003F]=Jd00P001DHa00<004YBBU800dYB00D004icCW=>L`0000ABU003001JeU[F
00=JeP8000=Nm`8000=S6003001_N`00008000Qoo`03001oogoo049oo`03001oogoo011oo`<002=o
o`<00004248002488@P30006=Jd00`00@Q124006@Q06000:Ool20005Ool2000017oo001oogoo0P00
;7oo00<007ooOol03Woo0P0022U:00<003F]00003THa00<005:DDY@02E:D00H005:DDYABU000G_L2
0006F]H2000@Ool2000VOol0035oo`03001oogoo00Uoo`8000@YBP80009240030016<DHa0096<@03
001:DTYB00=:DP05001>LdicCW<00004DY@00`00F]IJeP03F]H20003G_L00`00IcT00002HaP00`00
Kg]_N`020008Ool00`00Oomoo`12Ool00`00Oomoo`0=Ool3000UOol300022483000:=Jd00`00@Q12
4007@Q001@00DY@0036<00002Woo00<007ooOol00Woo00@007ooOol000Eoo`03001oogoo02Uoo`80
00moo`8000HYBP80008e[@030016<DHa00e6<@03001BU5:D00QBU005001BU5:DDY@00003G_L00`00
F]IJeP04F]H2000@Ool00`00Oomoo`0TOol0035oo`03001oogoo00Yoo`035:D002U:008YBP050012
448@@Q000004AS400`00BU9:DP02BU8900000e:D001JeP04F]H20002G_L01000IcUW>FLi0P000fmk
0P0027oo00<007ooOol0@Goo0P003Goo0`009Woo0`000PQ200<001cW000023F]1`001T8@00<005:D
00000`002Goo0P000goo00@007ooOol000Eoo`03001oogoo029oo`8000Eoo`03001oogoo00ioo`80
00@YBP8000@e[@030016<DHa00e6<@03001BU5:D00QBU005001BU5:DDY@00004G_L20004F]H2000@
Ool00`00Oomoo`0TOol0035oo`03001oogoo00Yoo`03000DY@00008YBP030012448@009240030016
<DHa0096<@@00003DY@005:D009BU004001F]EJeE[D5000015[F001Nm`000Ukg00<006LiIcT00VLi
00<006mkKg/00P002Goo00<007ooOol0@Woo00<007ooOol027oo0`00:7oo0P000PQ20P000QcW00<0
03F]=Jd01P000cg_00@004icCW=>L`D000924080009BU003001oogoo00Qoo`80009oo`04001oogoo
0002Ool01000Oomoo`008goo00@007ooOol000Aoo`03001oogoo00eoo`<000<YBP03000e[CF]00@e
[@030016<DHa00e6<@03001BU5:D00QBU005001BU5:DDY@00006G_L20002F]H2000AOol2000TOol0
035oo`03001oogoo00Yoo`07000DY@00:DX003W>00000d8@00<004HaAS400`0015:D00D005:DDYAB
U00000AF]@04001JeU[FF]H400000ekg001W>@04IcT01@00Kg/007>L00002Goo00<007ooOol0BWoo
0`00:Woo0P000PQ200@001cW7>LLi`@000Tmk`03001>Ldic00I>L`@000=BU003001oogoo00Ioo`<0
009oo`04001oogoo0002Ool3000TOol01000Oomoo`0017oo00<007ooOol03Goo00@000@Q000YBP80
00Pe[@030016<DHa00Y6<@L000IBU005001BU5:DDY@00008G_L200000f<H001oo`0AOol00`00Oomo
o`0ROol0035oo`03001oogoo00Yoo`04000DYABU0002>Lh00`00@Q124002@Q020002CW<00`00DYAB
U002DY@01@00DYABU5:D000015Je00<005[FF]H00U[F00D005kg001Nm`0000AW>@06001_N`00001c
W0002Goo00<007ooOol0Agoo0`00;Goo00@000Q20000008Li`800003:DX003g_00Xmk`03001>Ldic
00Q>L`<000=BU003001oogoo009oo`<0009oo`04001oogooOol20004Ool3000KOol30005Ool01000
Oomoo`0017oo00<007ooOol03Goo00@000@Q000000Xe[@030016<DHa00E6<@D0009>L`03001F]EJe
009F]@L000=BU003001Nmekg00MNm`04001S6000000BOol00`00Oomoo`05Ool2000017oo001oogoo
0P0057oo000aOol00`00Oomoo`0:Ool010005:DDY@000cW>00<0048@@Q000P0014ic00<005:DDY@0
0U:D00@005:DDY@000AF]@05001JeU[FF]H00002G_L30003IcT01000Kg]_N`000W>L00<007ooOol0
1goo00<007ooOol0AWoo0`00;Woo0P000QcW0P000bU:00<003g_?Nl00cg_2@0024ic0P0000INm`00
001BU000Ool30005Ool00`00Oomoo`0UOol00`00Oomoo`05Ool01000Oomoo`0017oo00<007ooOol0
3Goo00<000@Q00002cF]00<004HaAS401@001dic00<005JeE[D025Je1P0025kg00@006<HHaP0019o
o`8000Eoo`04001oogoo0005Ool00`00Oomoo`0AOol0035oo`03001oogoo00]oo`8DY@80008icP03
00124000009:DP05001>LdicCW<00004DY@01000DYABU0000eJe00<005[FF]H00U[F00<005kgG_L0
0P0000AW>@00IcT000=_N`04001cW0000009Ool00`00Oomoo`16Ool00`00Ool0000IOol6000>Ool2
00027>L00`00:DXYBP02:DX70006AS400`00DYABU0040004CW<20003G_L30008Ool00`00Oomoo`0V
Ool00`00Oomoo`05Ool20004Ool00`00Oomoo`0=Ool200000`@Q000e[@09=Jd4000<CW<00`00E[EF
]@07E[D20003E[D01000HaP000001Ukg0P0000=S6000Ool04Woo00<007ooOol00goo00@007ooOol0
00Eoo`03001oogoo015oo`00<Goo00<007ooOol02goo0P000S6<00@003W>>Lh000A:DP05001>Ldic
CW<00003DY@01000DYABU0000eJe00D005[FF]IJeP0000=Nm`05001W>FLiIcT00003Kg/200000g>L
001oo`09Ool00`00Oomoo`0iOol2000017oo001oogoo0P001Goo00@007ooOol001=oo`L0008YBPH0
00Yoo`@000<YBP800003=Jd004Ha00Y6<@03001BU5:D00ABU0<00003CW<0000000ENm`03001oogoo
00Ioo`03001oogoo02Moo`03001oogoo00Yoo`8000ioo`0400048@000008=Jd200000d8@001>L`0=
CW<00`00E[EF]@04E[D300000eJe001F]@02E[D01000HaQS66<H0P0015kg0P0000=S6000Ool04goo
00<007ooOol00Woo00@007ooOol0009oo`04001oogoo000COol0035oo`03001oogoo00]oo`80008a
S005000icP00AS400003BU801@00CW=>Ldic00000U:D2`0000AJeP00G_MNm`80009W>@80009_N`03
001cW7>L008000]oo`03001oogoo039oo`@00005Ool007ooOol00005Ool00`00Oomoo`02Ool01@00
Oomoogoo00003goo3P0000<YBP00000010001Woo0`000RU:0`000cF]00<004HaAS4024Ha00<005:D
DY@025:D0`001Ukg00<007ooOol01Woo00<007ooOol097oo0`0037oo00<007ooOol03Goo00D000@Q
000DY@0000He[@030012448@00924003001>Ldic00a>L`03001F]EJe00<000EF]@04001F]EJe0005
HaP20002G_L01@00JeX006<H00004goo0P000goo00@007ooOol0009oo`<001Aoo`00<7oo00<007oo
Ool03Goo00@Q2000<H`aS0800096<@05001:DTYBBU800002CW<300001EJe001JeU[F00000e[F00<0
05kgG_L00P0000INm`00IcT006Li0002JeX00`00Kg/00002Li`2000;Ool00`00Oomoo`0gOol01000
Oomoo`001Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol02Woo1@001c6<30001Goo1@00
1CF]00<004HaAS402DHa00<005:DDY@02E:D00<006<H00001Ekg00<007ooOol01Woo00<007ooOol0
<goo00<007ooOol03Goo00D000@Q000DY@0000@e[@8000E24003001>Ldic00a>L`<000UF]@03001F
]@0000MS60<00004JeX006<H000DOol00`00Oomoo`02Ool20004Ool3000COol0031oo`03001oogoo
00eoo`04124Q2000<H`2@Q001000AS56<@000dYB0P0000EBU000E[EF]@00009JeP04001JeU[FF]H3
G_L00`00HaP00002IcT20004JeX00`00LiacW002000<Ool00`00Oomoo`0gOol01000Oomoo`000Woo
00@007ooOol000=oo`8000Eoo`03001oogoo00Qoo`8000031240000000D000DaS0030016<DHa00<0
0003AS4004Ha008000Aoo`<000He[A0000UBU003001S6000008000=Nm`03001oogoo00Ioo`03001o
ogoo03=oo`03001oogoo00eoo`80008DY@03000e[CF]008000M24003001>Ldic00U>L`@000aF]@80
00US6003001[FV]J008001Eoo`8001ioo`00<7oo00<007ooOol03Woo00@00248<H`0009240050016
<DHa001:DP020003DY@00`00E[D00002F]H01000F]IJeP000Ukg00<006<HHaP00P0000=W>@00JeX0
0V]J00@006mk001cW0<000aoo`03001oogoo03Moo`04001oogoo0002Ool30004Ool00`00Oomoo`05
Ool00`00Oomoo`06Ool400000`aS000e[@04=Jd70003AS4800001Goo000000@Q00000cF]0`0000<i
cP00BU802TYB00<005JeE[D0100015:D00@006<HHaP0009S6004001Nm`000008Ool00`00Oomoo`0c
Ool00`00Oomoo`0=Ool200035:D2000:@Q000`00CW=>L`05CW<300000dic000000080006E[D00`00
HaQS6007HaP00`00JeY[FP02000FOol00`00Oomoo`0LOol0031oo`8000moo`035:D0024800800092
40030016<DHa00800003DY@005:D009BU005001F]@00F]H00002F]H00`00G_L00002HaP00`00HaQS
600200000f]J00000002Kg/200000gNm001oo`0<Ool00`00Oomoo`0hOol20004Ool30003Ool20007
Ool00`00Oomoo`04Ool2000336<00`00=Jde[@02=Jd8000014YB000000000THa3P0013W>00<004YB
BU8024YB00<005JeE[D01EJe0`0000EBU000HaQS600000=S60800003G_L007oo00Ioo`03001oogoo
03=oo`8000ioo`8000<DY@030012448@00U24003001>Ldic009>L`L0009BU003001JeU[F00EJePP0
00QS6080009[FPH0019oo`03001oogoo01]oo`00:Goo0P001Goo00<007ooOol03goo00DDYB48000m
k`0000924096<@9BU003001BU000009BU003001F]@0000@00005G_L006<HHaP00002HaP016Li0000
000016mk00<007Nm00003Woo00<007ooOol0A7oo00<007ooOol01goo00<007ooOol00Woo00@000aS
36<<H`L000DicP03001:DTYB00l00003248003W>00HicP03001:DTYB00Q:DP03001F]EJe00QF]@<0
0003HaP006<H00=S6003001Nm`0000Moo`03001oogoo025oo`800003Ool007oo00@00003Ool00000
00Ioo`03001oogoo00eoo`03000DYABU008DY@030012448@00U24003001>L`0000@000MBU003001J
eU[F00]JeP03001W>@0000<000=S6003001cW000009[FP03000@Q124008@Q0@000moo`8001aoo`00
:7oo00@007ooOol000Aoo`03001oogoo00moo`04000DYB480002?Nl2@Q020002DY@A0003IcT00`00
Kg]_N`0200000gNm0000000?Ool00`00Oomoo`14Ool20009Ool01P00Oomoogoo000<H`8000036<H0
03W>00HicPL000=:DP/00003248003W>00HicP03001:DTYB00Q:DP03001F]EJe00UF]@@000AS6003
001Nm`0000Moo`03001oogoo021oo`04001oogoo0002Ool00`00Oomoo`04Ool00`00Oomoo`02Ool2
000?Ool01`005:DDYABU000YBP0000U240@000aBU003001JeU[F00YJeP04001W>FLi0002IcT40002
Li`00`00JeX0000400046<H2000>Ool00`00Oomoo`0JOol002Qoo`04001oogoo0004Ool00`00Oomo
o`0@Ool010005:D000000Sg_0P0000ABU00000000088@P03000@Q12400L000045:D001S66<H40000
16mk001g_GNm0P0047oo00<007ooOol0<Woo0P0000=oo`00Ool0100000=oo`0000001Woo00<007oo
Ool02Goo00D007oo000<H`0000<HaP03000icSW>00D000<mk`04001:DTYBBU8500000dYB00000005
00000`Q200000003>LhA0008E[D30002HaP20003HaP00`00G_L00008Ool00`00Oomoo`0OOol01000
Oomoo`000goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol03Woo00L001BU5:DDY@00:DX0
0006@Q0400000dYB001BU00<DY@00`00F]IJeP0:F]H01000IcUW>@001FLi00<007>LLi`00`000RU:
1`0000<HaP00Ool03Goo00<007ooOol06Goo000QOol30004Ool01000Oomoo`0017oo00<007ooOol0
4Goo00<DY@00>Lh01P0000<8@P00000010000bU:00@0036<<H`aS0@000036<H001BU008000=g_@03
001oogoo00moo`03001oogoo02eoo`D0009oo`04001oogoo0006Ool00`00Oomoo`03Ool00`00Oomo
o`0:Ool300036<H40008?Nl00`00BU9:DP06BU8900000aBU000000020004?Nl00`00BU9:DP07BU80
0`00E[EF]@030002E[D40005HaP200000f<H001cW0020008Ool00`00Oomoo`0OOol01000Oomoo`00
1Goo0P000Woo00<007ooOol00Woo00<007ooOol03goo00<001BU00000bU:00<0048@@Q001@0014YB
00<005:DDY@02U:D00<005[FF]H02E[F00<006LiIcT00VLi00<006LiIcT00VLi00@007>LLiacW0@0
00@aS003000YBRU:00@000aoo`8001Yoo`008Goo00<007ooOol017oo00@007ooOol000Aoo`03001o
ogoo019oo`035:D003W>00H0008Li`03000YBRU:00@YBP03000aS36<00<aS003000icP0000<00004
5:D00000000BOol00`00Oomoo`0aOol01000Oomoo`000goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol02Woo00<001S66<H00QS600<002U:00001cg_2P0014YB00<005[F00000`0000<DY@00
00001cg_00<004YBBU801TYB00<005JeE[D00eJe10000UJe00<006<HHaP016<H0`0000=cW0000000
27oo00<007ooOol07goo00@007ooOol0009oo`03001oogoo00@000Eoo`80011oo`03000DY@0000<Y
BP<00003@Q00000000I:DP03001BU5:D00YBU003001JeU[F00UJeP03001W>FLi00=W>@04001W>FLi
IcT20002Li`00`00<H`aS0090003:DX00`00Oomoo`0:Ool00`00Oomoo`0HOol0029oo`03001oogoo
00Aoo`8000Eoo`03001oogoo01=oo`@0000336<001cW00<Li`03000YBRU:00@YBP03000aS36<00<a
S003000icSW>008icP8000035:D007oo019oo`03001oogoo035oo`04001oogoo0005Ool20002Ool0
0`00Oomoo`03Ool00`00Oomoo`0:Ool00`006<HHaP020002:DX00`00?Nlmk`050003@Q000`00CW=>
L`04CW<600000e[F0000000200000aS6000mk`05?Nl00`00BU9:DP07BU800`00E[D000030004E[D3
0007HaP200000g>L00000008Ool00`00Oomoo`0POol20004Ool20002Ool30004Ool00`00Oomoo`0?
Ool00`005:D0000400000d8@00000009BU800`00DYABU00:DY@00`00F]IJeP08F]H00`00IcUW>@04
IcT01`00IcUW>@00Mkd007>L00<000LicP03000icP0000@000aoo`03001oogoo00Ioo`03001oogoo
00ioo`008goo00<007ooOol02Woo00<007ooOol04Woo0P000`aS00<001cW7>L00acW00@002U::DXY
BPP0008aS006000icSW>>Lh003g_0`004Woo00<007ooOol0<Goo00@007ooOol0009oo`03001oogoo
00@000Eoo`8000]oo`@000<YBP@000Q2414000036<H0000000`000=:DP<000UF]@03001S600000IS
6080009cW003001oogoo00Ioo`03001oogoo035oo`03001oogoo00moo`<000@YBP03001:DTYB00U:
DP03001BU5:D00MBU14000EW>@80009g_A00008icP8000aoo`03001oogoo00Eoo`03001oogoo00io
o`008Goo0`0037oo00<007ooOol04Goo0`000`aS00<001cW7>L01`000cW>00<0048@@Q000T8@1@00
00<icP0000000cg_00<007ooOol03goo00<007ooOol0<Woo0P0017oo0P000Woo0`0017oo0P002goo
0P0012U:00<003F]00001d8@0`0000=6<@00CW<01dic200000<DY@00?Nl01Cg_00<004icCW<00dic
10002UJe00@006<HHaQS608000AS6080009cW003001oogoo00Ioo`03001oogoo035oo`03001oogoo
00aoo`<00003Ool002U:00@YBP03001:DTYB00U:DP04001BU5:DDY@60003F]H00`00HaQS6008HaP0
0`00JeY[FP0500000fLi001g_@02Mkd00`00@Q124009@Q000`00BU9:DP0300000cW>001oo`0:Ool0
0`00Oomoo`05Ool00`00Oomoo`0>Ool0031oo`03001oogoo011oo`<0008<H`D000<aS003000icSW>
00@icP030012448@00A24003001:DTYB00<000<mk`80011oo`03001oogoo04=oo`03001oogoo00Yo
o`03000YBRU:008YBP04000e[CF]0004@Q030005AS400`00CW=>L`050002DY@01@00F]IJeU[F0000
0QBU00<003g_?Nl00cg_00@004icCW=>L`<000=>L`03001F]@00008000EF]@03001S66<H00AS6005
001S66<H001g_@0200000g>L001oo`07Ool00`00Oomoo`0aOol00`00Oomoo`09Ool30005Ool01`00
:DXYBRU:000icP0000Y:DP@000UJeP03001S66<H00QS6003001[FV]J00E[FP<0009g_@P000E24003
001:DTYB009:DP<000]oo`8000Eoo`03001oogoo00ioo`00<7oo00<007ooOol03goo0`0000D<H`00
000Q200000HaS003000icSW>00@icP030012448@00A24006001:DTYBBU8004YB0P000Sg_0P0047oo
00<007ooOol0@Woo0P002Woo0P000RU:0P0013F]10001dHa10001U:D3P0000A>L`00000000E>L`03
001F]EJe00=F]@<00003E[D006<H00MS6003001S6000009g_@8000Yoo`03001oogoo031oo`03001o
ogoo00Ioo`<000Qoo`05000YBRU::DX00002>Lh00`00BU9:DP06BU800`00DY@0000<F]H00`00HaQS
6007HaP00`00JeY[FP06JeX90003BU880005BU800`00Oomoo`09Ool00`00Oomoo`02Ool2000@Ool0
031oo`03001oogoo00moo`@000<Q2003000aS36<00<aS003000icSW>00DicP030012448@00A24003
001:DTYB009:DP800006CW<00000000icP003goo00<007ooOol0>goo0P001Goo00<007ooOol02Goo
0P0000<YBP00=Jd013F]0P001dHa0`000TYB00@005:DDYABU0@0009BU0<00004F]H000000002>Lh4
00000dYB000000020002CW<00`00E[EF]@07E[D20009HaP01000Mkeg_GNm0P002Woo00<007ooOol0
;goo00<007ooOol017oo0`0037oo00<002U:000013W>00<004YBBU800dYB0P000e:D00<005[FF]H0
2E[F00<006<HHaP01f<H00<006]JJeX01F]J00@007NmMkd0008mk`04001>LdicCW<70002BU801000
E[D000000dYB00<007ooOol027oo0`0017oo00<007ooOol03Woo000_Ool00`00Oomoo`0?Ool30005
8@P00`00<H`aS003<H`00`00>LhicP05>Lh00`00@Q124004@Q000`00BU9:DP02BU820004CW<2000?
Ool00`00Oomoo`0jOol01000Oomoo`0017oo00<007ooOol02Goo0`001CF]00<003g_00001DHa0P00
1DYB0`0015:D100000=JeP0000001@0000<icP00BU801TYB0P002EJe00@006<HHaP000MS608000=g
_@03001oo`0000Uoo`03001oogoo02moo`80009oo`<000moo`03000YBP0000@icP04001:DTYBBU82
0005DY@00`00F]IJeP09F]H00`00HaQS6007HaP00`00JeY[FP05JeX00`00Mkeg_@050009CW<40002
E[D300000dYB001oo`05Ool30002Ool00`00Oomoo`0COol002moo`8000moo`80000336<0024800<Q
2003000aS36<008aS1@0009:DP03001:DP0000=>L`03001F]@0000ioo`03001oogoo03Yoo`04001o
ogoo0004Ool00`00Oomoo`09Ool00`@Q000e[@03=Jd20003?Nl00`00AS4000020005BU820002CW<0
1@00DYABU5:D00000UJe00@005[F001JeP@0008aS08000M:DP03001F]EJe00<000AF]@03001S66<H
009S6003001S66<H00=S6003001cW00000=g_@04001oogoo0008Ool00`00Oomoo`0_Ool4000COol0
0`00>LhicP04>Lh00`00BU800008DY@00`00F]IJeP09F]H00`00HaQS6002HaP=00000gNm00000003
00000dic000000030006CW<00`00F]H00004E[D20003Ool30005Ool00`00Oomoo`0COol002moo`03
001oogoo00ioo`04000<H`aS00048@P00`00<H`000020002>Lh00`00@Q124005@Q000`00BU9:DP04
BU800`00DYABU00300000dYB001>L`02CW<01000E[EF]@003Goo00<007ooOol0=Goo0`000Woo00@0
07ooOol000Aoo`03001oogoo00Qoo`0300048@0000<e[@03000mkcg_00@mk`8000E:DP8000A>L`@0
009F]@9JeP<00008G_L00000000Q2000<H`00096<@<00003BU8005Je00EF]@800003E[D006<H00ES
6005001S66<HHaP00002Li`01000Mkeg_@0017oo00<007ooOol01Goo00<007ooOol08Woo0P0000Ao
o`00Oomoo`8000Eoo`8001Ioo`03000icSW>00@icP03001BU5:D00QBU003001JeU[F00IJePL000AW
>@03001cW7>L00AcW003001g_@0000P000=>L`D00005CW<005[FF]H00005E[D30008Ool00`00Oomo
o`0COol002moo`03001oogoo00eoo`05000<H`aS36<000038@P30005>Lh00`00@Q124005@Q000`00
BU9:DP04BU800`00DYABU002DY@40002CW<01@00E[EF]EJe000037oo00<007ooOol0=Goo00<007oo
Ool00Woo00@007ooOol000Aoo`03001oogoo00Qoo`80000448@003F]0006?Nl00`00AS56<@020000
0dYB00000004CW<20003DY@;000011BU000Q20001DHa0P002EJe00<006<HHaP01V<H00<006<H0000
17>L0P001Woo00<007ooOol017oo00<007ooOol08Goo00@007ooOol000Eoo`03001oogoo00Aoo`03
001oogoo01Aoo`03000icSW>00<icP8000UBU004001JeU[FF]H50002G_L00`00IcUW>@06IcT00`00
LiacW003Li`01P00Mkd00000?Nl0009>L`80009>L`<000E>L`<0009JeP8000=F]@03001oogoo00Qo
o`03001oogoo01=oo`00;goo00<007ooOol037oo0P000`aS100000<aS000>Lh01CW>00<0048@@Q00
1D8@00<004YBBU8014YB00<005:DDY@00U:D00@005:D001F]@800005CW<005JeE[D0000<Ool00`00
Oomoo`0fOol00`00Oomoo`02Ool20004Ool00`00Oomoo`09Ool2000248@00`00?Nlmk`04?Nl00`00
AS56<@03AS420004CW<01000DYABU5:D0`000UJe00<005[FF]H00P0000=W>@0000000`000SW>0P00
00=6<@00DY@00U:D0P0015Je00D005kgG_MNm`0000MS6003001cW7>L00=cW08000Ioo`03001oogoo
00Aoo`03001oogoo025oo`04001oogoo0005Ool00`00Oomoo`05Ool00`00Oomoo`0DOol01@00>Lhi
cSW>00000THa00<005:DDY@01U:D10001ekg00<006LiIcT01VLi00<007>LLi`00g>L1P0014ic0P00
0dic0P0014ic00<005kg00000e[F00@005JeE[D000Yoo`03001oogoo01=oo`00;goo00<007ooOol0
37oo0P000PaS0P00136<00<003W>>Lh013W>00<0048@@Q001D8@00<004YBBU8014YB00<005:DDY@0
0U:D00<005:D00000eJe0P000UJe0P002goo00<007ooOol0=goo00<007ooOol01goo0P002Woo0P00
0Q2400<003g_?Nl00cg_00<004HaAS400dHa00@004icCW<0009>L`03001BU00000<000=F]@03001J
eU[F00800003IcT0000000@000037>L003W>008000IBU0800003E[D005kg00ANm`04001S66<HHaP2
00000fmk001cW004Li`00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`0POol01000Oomoo`00
0Woo00@007ooOol000Qoo`03001oogoo01Aoo`03000icP0000A6<@03001BU5:D009BU0<00003F]H0
05kg00UNm`03001W>FLi00EW>@03001cW7>L00<00006JeX004icCW<004ic0P000dic0`000dic1000
0ekg00H005[FF]IJeP00E[D2000:Ool00`00Oomoo`0BOol002moo`03001oogoo00]oo`80000536<0
00009BT00004<H`00`00>LhicP04>Lh00`00@Q124005@Q000`00BU9:DP04BU800`00DYABU002DY@0
0`00DY@00004E[D200000eJe0000000;Ool00`00Oomoo`0eOol30009Ool00`00Oomoo`09Ool01P00
48@@Q124;F/000<mk`030016<DHa00=6<@03001>Ldic009>L`@00003DY@005Je00=F]@05001JeU[F
001S600;0003AS420004DY@20007G_L00`00HaP00004Kg/00`00LiacW002000:Ool00`00Oomoo`03
Ool00`00Oomoo`0POol01000Oomoo`000Woo0`002Woo00<007ooOol057oo0P001DHa00@005:D0000
00EJeP03001Nmekg00MNm`04001W>FLiIcT70002Mkd01000JeY:DP000Tic00<004icCW<00P000Tic
00@004ic000000A>L`8000=Nm`04001JeU[FF]H3000:Ool00`00Oomoo`0BOol002moo`03001oogoo
00]oo`<000<U:@03000aS36<00<aS003000icSW>00<icP040012448@@Q090002BU800`00DYABU002
DY@20005E[D01000G_L005Je0P002Woo00<007ooOol0@Goo0P002Woo00@0012448@0008]J`03000m
k`0000E6<@04001>LdicCW<30002DY@40002E[D400000f<H00000007000017oo0000000014Ha00@0
05:D000000=JeP03001Nmekg00ANm`03001_Nfmk00=_N`04001cW000000<Ool00`00Oomoo`02Ool0
0`00Oomoo`0QOol20004Ool3000:Ool00`00Oomoo`0DOol20005AS420007F]H00`00G_MNm`04G_L6
0004Kg/01`00Mkeg_GNm001[FP00009:DP03001>Ldic0080009>L`03001>L`0000=>L`800005CW<0
05kgG_L00003G_L01000F]IJeU[F0P002Woo00<007ooOol04Woo000_Ool00`00Oomoo`0;Ool20004
9BT00`00<H`aS003<H`00`00>LhicP070004BU800`00CW=>L`02CW<50002DY@20005E[D00`00G_MN
m`03000:Ool00`00Oomoo`0_Ool200000goo001oo`0400000goo00000006Ool00`00Oomoo`09Ool0
100048@@Q0000be[0P0014Ha1@0000=>L`00DY@00e:D00<005[FF]H00`000Ukg100000=[FP000000
0`000goo00<0036<00001@001U[F00<005kg00000P0000=W>@00Kg/01Fmk0P003Goo00<007ooOol0
0Woo00<007ooOol0=Goo00<007ooOol057oo0`000dHa00<005:D00001e[F00<005kgG_L00`000VLi
00<006mkKg/01Fmk00<007Nm00000`0000E6<@00BU9:DP0000=>L`03001>Ldic00<000A>L`03001N
mekg009Nm`05001NmekgG_L00002F]H00`00@Q000009Ool00`00Oomoo`0BOol002moo`03001oogoo
00Yoo`<000@U:@03000aS36<008aS0@000=24003001:DTYB00E:DP03001>Ldic00A>L`03001F]EJe
00@000EF]@04001NmekgG_L2000:Ool00`00Oomoo`0^Ool01000Oomoo`000Woo00<007ooOol017oo
00<007ooOol00goo00<007ooOol02Woo00<0012400000be[0Sg_1@0014ic00<005:DDY@00U:D00<0
05[FF]H00U[F00<005kgG_L00P0000=W>@00JeX01P0017oo0`0014ic00<005[FF]H015[F00<006Li
IcT00VLi00@006mkKg]_N`@000moo`05001oogooOol0000hOol2000FOol012U:0016<@000e:D00<0
05[FF]H015[F0`001VLi00@006mkKg]_N`D00007Kg/mkdHaAS4004Ha00000TYB00D004icCW=>L`00
00=>L`800004CW<005[F0005G_L01P00G_MNmekg001JeP<000Uoo`03001oogoo019oo`00;goo00<0
07ooOol02Woo0`0012DY00<0036<<H`00P0000<mk`00@Q00148@00<004YBBU801DYB00<004icCW<0
14ic00<005JeE[D00UJe10000eJe00@005kgG_MNm`<000Uoo`03001oogoo02ioo`04001oogoo0003
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool20003;F/00`00?Nl000040004CW<0
0`00DYABU002DY@00`00F]IJeP02F]H02000G_MNmekg001W>@00JeX70006Ool5000014ic00000000
0ekg00<006LiIcT00fLi1@004Woo00@007ooOol003Yoo`03001oogoo01Aoo`03:DX0000000ABU003
001JeU[F00<000=S6003001W>FLi00=W>@@0009_N`<00003@Q0000000096<@<0009:DP05001>Ldic
CW<00002CW<30003F]H00`00G_MNm`03G_L01000G_MNmekg10002Goo00<007ooOol04Woo000QOol2
000017oo001oogoo0P001Woo00<007ooOol02Woo0`0012DY0`000cg_00<0048@@Q000d8@00<004YB
BU801DYB00<004icCW<014ic00<005JeE[D00UJe0P000Ukg10000ekg0`002Goo00<007ooOol0;Woo
00@007ooOol000Eoo`80009oo`03001oogoo00=oo`03001oogoo00]oo`03000]Jbe[00<000<mk`9:
DP800003CW<005:D00ABU006001JeU[FF]H005kg0`0000AW>@00001[FPH000Qoo`<0009>L`03001N
mekg00ANm`03001W>FLi00<00003JeX007oo01Aoo`03001oo`0003]oo`03001oogoo01Eoo`<000=B
U0<000IS6003001W>@000080009[FP03001_Nfmk00800004@Q000000@Q02000014HaCW=>Ldic1000
0Tic0`000U[F0P000e[F00<005kgG_L00ekg00L005kgG_MNm`00HaP00009Ool00`00Oomoo`0BOol0
021oo`04001oogoo0005Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool0100036<<H`000RDY0P001Cg_
00<0048@@Q00148@00<004YBBU8014YB00<004icCW<00dic00<005JeE[D00eJe0P001Ekg0P000Ukg
0`002Goo00<007ooOol0;Woo00@007ooOol0009oo`03001oogoo00@000Ioo`03001oogoo00Yoo`@0
0003;F/003g_008mk`03001:DTYB009:DP@0009BU003001JeP0000@0009Nm`80009W>@800003JeX0
0000008000Yoo`030016<DHa00H00005G_L00000001W>@02000GOol01000Oomoo`00>goo00<007oo
Ool05Goo0`0000ABU000E[EF]@@0009S60D0009[FP@00003@Q00048@0080009240030016<DHa009>
L`03001BU5:D00<00003E[D005[F00=JeP8000=JeP03001Nmekg00=Nm`05001Nmekg001S60020008
Ool00`00Oomoo`0BOol0021oo`04001oogoo0005Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool02000
36<<H`009BT0036<0006?Nl00`00@Q124003@Q000`00BU9:DP04BU800`00CW=>L`03CW<00`00E[EF
]@03E[D20005G_L01`00IcT005kg001W>@0000Yoo`03001oogoo02ioo`8000Aoo`80009oo`<000Ao
o`8000Uoo`<0009oo`0336<0000000@mk`03001:DTYB009:DPAF]@@0009JeP04001NmekgG_L20002
IcT00`00JeX00005000=Ool400000e[F00000004000JOol00`00Ool0000lOol00`00Oomoo`0GOol4
0003E[D50002HaP400000c6<0012400600001D8@BU8004Ha00000Tic00@005:DDY@000=F]@03001J
eU[F009JeP8000=JeP03001Nmekg00=Nm`<00003HaP0000000Qoo`03001oogoo019oo`0087oo00@0
07ooOol0009oo`04001oogoo0004Ool2000;Ool2000236<20003<H`00`00?Nlmk`03?Nl00`00@Q12
4003@Q000`00BU9:DP04BU800`00CW=>L`03CW<00`00E[EF]@03E[D00`00G_MNm`04G_L00`00IcUW
>@0200000fLi001oo`09Ool00`00Oomoo`0oOol20006Ool30005Ool0100036<000000cg_00D004YB
BU9:DP0000EF]@03001JeU[F009JeP03001Nmekg0080009W>@04001[FP00JeX4000dOol2000mOol0
0`00Oomoo`0JOol>00000c6<00124005000014Ha000004YB0P000Tic00D005:DDYABU00000=F]@03
001JeU[F009JeP8000=JeP03001Nmekg00=Nm`05001_N`00HaP00009Ool00`00Oomoo`0AOol0021o
o`04001oogoo0002Ool30005Ool00`00Oomoo`0:Ool2000236<00`00<H`aS002<H`00`00?Nlmk`03
?Nl00`00@Q12400C0003E[D00`00G_MNm`03G_L00`00IcUW>@02IcT01000IcT000002Goo00<007oo
Ool0?goo00<007ooOol00Woo0`002Goo00<<Hc6<<H`00`0014YB00<005JeE[D00eJe00@005[FF]IJ
eP@00005HaP006Li001[FP06000dOol3000nOol00`00Oomoo`0NOol3000011S6000002U:100000=2
400000000P0000A:DP00AS40009:DP80009>L`05001BU5:DDY@00003E[D00`00F]IJeP02F]H00`00
F]IJeP02F]H01000G_MNmekg0P0000A_N`00HaP000Uoo`03001oogoo015oo`008Goo0P0017oo0`00
17oo00<007ooOol02Woo0P0000<<H`000000136<00<003g_?Nl00Sg_10000dYB00<004icCW<014ic
00<005JeE[D00eJe00<005[FF]H010001Ekg00<006LiIcT00VLi00@006Li000000Uoo`03001oogoo
03moo`D000aoo`03000<Hc6<008aS08000=:DP03001F]EJe009F]@04001JeU[FF]H20005HaP40000
0f]J00000002000`Ool40012Ool2000NOol3000011S6000002U:0P0000<mk`00@Q000`000TYB00@0
04HaAS40009:DP80009>L`04001BU5:D0004E[D01000F]IJeU[F0P0015[F00T005kg001_N`00Kg/0
06<H00002Goo00<007ooOol04Goo000^Ool00`00Oomoo`0:Ool00`0036<000029BT00`00<H`aS002
<H`400000dHa001:DP04BU800`00CW=>L`04CW<00`00E[EF]@03E[D00`00F]IJeP03F]H20004G_L0
1P00IcUW>FLi001_N`<000Uoo`03001oogoo039oo`800004Ool007ooOol20005Ool2000@Ool20002
<H`00`00BU8000020005E[D4000015kg001S66<H0P000VLi00L006]JJeX007>L001g_@0^Ool30018
Ool00`00Oomoo`0KOol300000aS6000000020003?Nl20005BU800`00AS400002BU800`00DY@00002
0003DY@01@00E[EF]EJe000015[F0P000e[F0P000fmk0`002Woo00<007ooOol04Goo000^Ool00`00
Oomoo`0:Ool200039BT01000<H`aS36<0P0014Ha00<004YBBU800dYB00<004icCW<014ic00<005Je
E[D00eJe00<005[FF]H00e[F00<005kg00000`0016Li00<006mk00000P002Goo00<007ooOol0<Goo
00@007ooOol000Eoo`03001oogoo00Aoo`03001oogoo00ioo`0536<0036<<H`00002BU870005G_L2
0003IcT01@00JeY[FP00Li`00P00:goo1000C7oo00<007ooOol06Woo00@00124000HaP<00007>Lh0
03g_?Nl004Ha00000TYB00P004YB000004ic001:DP0015:D0P0000=BU000E[D00eJe00<005[FF]H0
0U[F100000=[FP00Kg/00Vmk00<006mk00002Woo00<007ooOol04Goo000^Ool00`00Oomoo`0:Ool2
00039BT01P00<H`aS000?Nl000E6<@03001:DTYB009:DP03001>Ldic00=>L`03001F]EJe00AF]@03
001JeU[F00=JeP03001Nmekg009Nm`05001W>FLiIcT00003Kg/20009Ool00`00Oomoo`0aOol01000
Oomoo`001Goo00<007ooOol01Goo00<007ooOol03Woo00@0036<<H`0009:DP03001JeU[F00=JeP03
001Nmekg00=Nm`<00003IcT000000080009cW003001oogoo02Ioo`@0055oo`03001oogoo01Uoo`80
00046<H000000002>Lh01@00?Nlmk`00AS400P0000E:DP00BU9:DP00009>L`03001:DP0000=BU003
001F]@00008000AF]@03001JeU[F00@0009[FP07001_NfmkKg/006mk00002Woo00<007ooOol04Goo
000^Ool00`00Oomoo`0;Ool00`aS000U:@029BT20003?Nl00`00AS56<@02AS400`00BU9:DP03BU80
0`00CW=>L`02CW<00`00E[EF]@03E[D00`00F]IJeP03F]H20004G_L20002IcT01000Kg]_Nfmk0P00
2Goo00<007ooOol0<Goo00@007ooOol0009oo`04001oogoo0008Ool00`00Oomoo`0>Ool30003BU80
0`00F]IJeP03F]H40004IcT20002Kg/3000VOol3001FOol00`00Oomoo`0IOol4000012e[000icP00
0Sg_00@004Ha001>L`800003BU80000000=>L`03BU8005:D009BU003001F]EJe009F]@L0009S6003
001[FP00009[FP06001_Nfmk001_N`002Woo00<007ooOol04Goo000^Ool00`00Oomoo`0;Ool20003
9BT00`00?Nlmk`02?Nl00`00AS56<@02AS400`00BU9:DP03BU800`00CW=>L`02CW<00`00E[EF]@03
E[D00`00F]IJeP02F]H30003G_L01P00IcUW>@00IcT0009_N`8000Yoo`03001oogoo035oo`04001o
ogoo0002Ool3000:Ool2000@Ool00`Q2000000020003F]H30005IcT00`00Kg]_N`02Kg/2000TOol4
001JOol00`00Oomoo`0HOol2248011cW;F/]Jbe[0SW>00T003g_0016<@00CW<004ic00000Tic00@0
04icCW=>L`80009BU003001F]EJe009F]@03001Nmekg009Nm`05001S66<HHaP00002JeX00`00JeX0
0002Kg/00`00Kg/0000:Ool00`00Oomoo`0AOol002ioo`03001oogoo00]oo`03000<H`00008U:@03
000mkcg_00<mk`050016<DHaAS400005BU800`00CW=>L`060002E[D00`00F]H0000200000e[F0000
0003G_L01@00IcUW>FLi00000fmk0P002Woo00<007ooOol0<Woo0P0017oo0`002goo00<007ooOol0
3goo00<8@P0000000`0015kg0P0000=W>@00Kg/010008Woo1000Ggoo00<007ooOol05goo00@48@Q2
0000008]J`05000icP000016<@02000014ic001>L`000dic00H004icCW<005Je0002DY@01@00E[EF
]EJe000015kg00<006<HHaP00V<H00D006]J001[FP0000=_N`03001oogoo00Uoo`03001oogoo015o
o`00;Woo00<007ooOol02goo00L000aS000U:@00=Jd00004?Nl00`00AS56<@02AS400`00BU9:DP05
0002E[D01000F]IJeU[F1P0000MJeP00G_MNm`00G_L00004IcT01P00Kg]_N`00Li`000Yoo`03001o
ogoo04Moo`03001oogoo00moo`05001oo`00001:DP030003G_L300000f]J001oo`0POol3001TOol2
000HOol224801AcW;F/]J`00>Lh00P0000=6<@0000000Tic00<004ic00000Tic00@004icCW<0009F
]@9BU005001F]EJeE[D00004G_L00`00HaQS6002HaP00`00JeY[FP020003Kg/00`00Oomoo`0:Ool0
0`00Oomoo`0@Ool002ioo`03001oogoo00aoo`8<H`05000e[CF]=Jd00003?Nl00`00AS56<@050002
DY@00`00E[EF]@02E[D40002F]H01000G_MNmekg0`000Ukg0P000fLi00L006mk001_N`00Li`0000:
Ool00`00Oomoo`18Ool00`00Oomoo`0>Ool01000Oomoogoo0`0000=:DP0000000`0087oo1000JGoo
00<007ooOol05Goo0PQ200HLi`00;F/003W>0003AS42000014ic001>L`000dic0P0015Je00=BU000
E[D00eJe00D005kgG_MNm`0000AS6005001[FV]JJeX00002Kg/2000<Ool00`00Oomoo`0@Ool002io
o`03001oogoo00aoo`8<H`05000e[CF]=Jd00003?Nl30002CW<00`00DYABU002DY@00`00E[D00003
0005F]H00`00G_MNm`02G_L01P00HaP00000G_L000=W>@06001_Nfmk001cW0002goo00<007ooOol0
BGoo0P003Woo00<007ooOol09Woo1000KWoo00<007ooOol057oo00P48@Q2000002e[000icP000dHa
00@004ic0000009>L`03001>Ldic008000EF]@8000=F]@03001Nmekg009Nm`05001S66<HHaP00004
JeX3000=Ool00`00Oomoo`0@Ool002ioo`03001oogoo00aoo`800003:DX003F]008e[@05000mk`00
BU800004CW<00`00DY@000030003E[D00`00F]IJeP02F]H00`00G_MNm`02G_L00`00HaQS6002HaP3
00000fLi001_N`02Kg/00`00Li`0000;Ool00`00Oomoo`1;Ool00`00Oomoo`0;Ool00`00Oomoo`0S
Ool3001cOol00`00Oomoo`0DOol00`Q200000002;F/00`00AS400002AS401000CW=>L`000Tic00D0
04ic001F]@0000EF]@06001JeP00001F]@0015kg00D006<HHaQS600000=[FP<000ioo`03001oogoo
011oo`00;Woo00<007ooOol03Goo00@002U::DX000<e[@05001:DTYBBU800002CW<30003DY@01@00
E[EF]EJe000015[F00<005kgG_L00Ukg00<006<HHaP00V<H00<006Li00000P000Vmk00@007Nm0000
00aoo`03001oogoo04]oo`03001oogoo00Yoo`03001oogoo01moo`@007Moo`03001oogoo01=oo`<0
008]J`060016<DHa0016<@000dic10000eJe00D005JeE[EF]@0000EJeP@00003G_L006<H00=S60<0
0004Mkd00000000=Ool00`00Oomoo`0@Ool002ioo`03001oogoo00eoo`04000YBRU:0003=Jd00`00
BU9:DP040002CW<01@00DYABU5:D00000eJe00<005[FF]H00U[F00D005kgG_MNm`0000AS6004001W
>FLiIcT200001Fmk001g_GNm00003Goo00<007ooOol0C7oo00<007ooOol02Goo00<007ooOol06goo
1000O7oo00<007ooOol04Woo00<48@Q200000`000dHa0P000dic00@005:DDY@000AF]@04001F]EJe
0005F]H01000HaQS66<H1`000WNm0P000Woo00<007ooOol02Woo00<007ooOol047oo000]Ool2000?
Ool20002:DX00`00=Jd000030002BU801@00CW=>Ldic000015:D00<005Je00000`0000=JeP00G_L0
0Ukg00<006<HHaP00V<H00P006LiIcUW>Fmk001_N`000gNm00<007ooOol02goo00<007ooOol0CGoo
0P0027oo00<007ooOol06Goo0`00PGoo0P004goo00<8@P0000000SW>00@004HaAS56<@80009>L`05
001BU5:DDY@00004E[D00`00E[D00004F]H00`00HaQS6003HaP00`00Kg]_N`02Kg/00`00Mkeg_@02
0003Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool002eoo`03001oogoo00moo`D000=6<@05001:DTYB
BU800002CW<7000015[F001JeU[F100000=Nm`00HaP00V<H00@006LiIcT000=_N`05001g_@00Mkd0
000>Ool00`00Oomoo`1?Ool00`00Oomoo`05Ool00`00Oomoo`0EOol40026Ool00`00Oomoo`0AOol0
0`008@P00002>Lh02000AS56<@00DY@004ic0003DY@00`00E[EF]@02E[D30004F]H00`00HaQS6003
HaP01@00Kg]_Nfmk00000WNm0P0017oo00<007ooOol02Goo00<007ooOol047oo000]Ool00`00Oomo
o`0=Ool40002:DX00cg_0016<@02AS401000BU9:DTYB0P0000=F]@00E[D00UJe00@005[FF]H000=J
eP03001Nmekg00<00005HaP006LiIcT00003Kg/20002Mkd00`00Oomoo`0=Ool00`00Oomoo`1@Ool0
0`00Oomoo`04Ool00`00Oomoo`0AOol4002;Ool00`00Oomoo`0AOol00`008@P00002>Lh00`00AS40
0002DY@00`00CW<00003DY@01000E[EF]@000ekg0P000U[F00<006<HHaP00V<H00<006mkKg/00Vmk
00@007NmMkd000Ioo`03001oogoo00Qoo`03001oogoo011oo`00;Goo00<007ooOol02Woo0`000Woo
0P0000DDY@00000mk`0000=6<@05001:DP00DY@00002E[D01000E[EF]@000U[F00@005[FF]IJeP=N
m`03001S66<H00800003IcT006mk009_N`03001cW7>L00@000ioo`03001oogoo055oo`03001oogoo
00=oo`03001oogoo00ioo`<0091oo`03001oogoo015oo`03000Q2000008icP8000=BU08000=BU003
001F]@0000INm`03F]H006<H00AS6005001_NfmkKg/00002Mkd20007Ool00`00Oomoo`08Ool00`00
Oomoo`0?Ool002eoo`03001oogoo00Ioo`@000Ioo`07000DY@00=Jd003g_00000dHa0P000U:D00<0
05Je00000UJe00@005[FF]H0009JeP04001Nmekg0002HaP01000IcUW>@000fmk00@007>LLiacW080
009oo`03001oogoo00]oo`03001oogoo059oo`8000=oo`03001oogoo00Yoo`@009Aoo`03001oogoo
015oo`03000Q2000008icP03001BU5:D009BU0H000MNm`<000AS6005001_NfmkKg/00002Mkd00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0?Ool002eoo`8000=oo`@000]oo`06000DY@00=Jd0
03g_0THa00@004icCW<0009BU003001F]@00009F]@03001JeP00009JeP03001Nm`00009S6003001W
>FLi009[FP03001_N`0000=cW003Mkd007oo00=oo`03001oogoo00Yoo`03001oogoo05Aoo`04001o
ogoo0008Ool4002IOol00`00Oomoo`0AOol01P008@P003W>001:DP800003DY@005[F00AJeP03001N
mekg00=Nm`04001W>FLiIcT200000f<H001_N`03Kg/3000;Ool00`00Oomoo`06Ool00`00Oomoo`0?
Ool002Moo`03001oogoo00=oo`03001oo`000080015oo`80008e[@03?Nl0000000=>L`800003DY@0
0000009F]@D0009Nm`05001S6000IcT00004JeX01@00Li`00000Mkd00P001Goo00<007ooOol02Goo
00<007ooOol0EGoo00<007oo00001Goo0`00WWoo00<007ooOol04Goo00@00248000000=:DP03001B
U00000EJeP05001NmekgG_L00006IcT7000>Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool002Moo`03
001oogoo00=oo`8001Eoo`80008e[@D0009>L`03001BU00000<00003G_L005kg00<00003HaP006Li
00A[FP04001_N`000003Mkd00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`1FOol200000goo
00000002002ROol2000BOol00`008@P00004BU820006F]H00`00G_L00005IcT20003Kg/2000AOol0
0`00Oomoo`04Ool00`00Oomoo`0?Ool002Moo`03001oogoo00Eoo`03001oogoo01=oo`05000YBSF]
001>L`02000014ic001>Ldic0P0000IJeP00001Nm`00G_L500000f]J00000004Kg/01000Mkeg_@00
2Woo00<007ooOol01goo00<007ooOol0Egoo0P00Z7oo00<007ooOol047oo00<002e[;F/00P000dYB
2@0016Li00@006mkKg]_N`8001Aoo`03001oogoo00=oo`03001oogoo00moo`009goo00<007ooOol0
1Woo00<007ooOol057oo100014ic3`000fmk00<006mkKg/00`0037oo00<007ooOol01Woo00<007oo
Ool0ogoo0goo00<007ooOol04Woo0Re[0P0000=:DP00G_L01ekg00@006Li0000009_N`<001Eoo`03
001oogoo00=oo`03001oogoo00moo`009Woo0P002Goo00<007ooOol057oo0P0000=:DP0000000Tic
400016mk00<006mkOol03Woo00<007ooOol01Goo00<007ooOol0ogoo17oo00<007ooOol04Goo00@0
07ooOol]J`<000ANm`L00003Kg/0000001Qoo`03001oogoo009oo`03001oogoo00moo`009goo00<0
07ooOol027oo0P005Woo0`0000=:DP00000040000Vmk0P004Goo00<007ooOol017oo00<007ooOol0
ogoo1Goo00<007ooOol047oo00<007ooOol00goo3@006goo00D007ooOomoo`00015oo`00=7oo00<0
07ooOol057oo0P0000=:DP0000001`0000=S600000001@0000=[FP00000057oo00<007ooOol00goo
00<007ooOol0HGoo00<007ooOol00goo0P00W7oo00<007ooOol03goo00<007ooOol0;7oo00D007oo
Oomoo`00011oo`00=Goo00<007ooOol04goo00H007ooOomoo`00BU8700000f<H00000005000GOol0
0`00Oomoo`03Ool00`00Oomoo`1POol00`00Oomoo`03Ool2002MOol00`00Oomoo`0>Ool00`00Oomo
o`0]Ool01000Oomoo`0047oo000fOol00`00Oomoo`0BOol00`00Oomoo`04Ool01000BU9:DTYB2000
6Woo00<007ooOol00Woo00<007ooOol0H7oo0`000goo0P001goo0P0000Aoo`00Oomoo`<00006Ool0
07ooOol007oo1000Q7oo0P003Woo00<007ooOol0;Woo00<007oo000047oo000gOol2000BOol00`00
Oomoo`0[Ool01@00Oomoogoo0000HWoo00@007ooOol0009oo`80009oo`D0009oo`80009oo`03001o
ogoo0080009oo`80009oo`8008Ioo`03001oogoo00]oo`03001oogoo02moo`80011oo`00>Goo00<0
07ooOol03goo00<007ooOol0;7oo00@007ooOol0069oo`04001oogoo000:Ool00`00Oomoo`020002
Ool00`00Oomoo`020002Ool300000goo00000027Ool00`00Oomoo`0:Ool00`00Oomoo`0^Ool3000@
Ool003Yoo`03001oogoo00ioo`03001oogoo02eoo`03001oo`00069oo`04001oogoo000:Ool00`00
Oomoo`020002Ool00`00Oomoo`020002Ool00`00Oomoo`030028Ool00`00Oomoo`09Ool00`00Oomo
o`0ZOol4000COol003]oo`03001oogoo00eoo`03001oogoo02ioo`80069oo`<000aoo`800004Ool0
0000Ool300000goo001oo`0200001Goo000007oo0000RGoo00<007ooOol027oo00<007ooOol09Goo
1@005goo000lOol2000=Ool00`00Oomoo`0]Ool3001gOol01@00Oomoogoo00000Woo00<007ooOol0
0Woo00<007ooOol0R7oo00<007ooOol01goo00<007ooOol08Goo100077oo000nOol00`00Oomoo`0:
Ool00`00Oomoo`0YOol4003oOolCOol00`00Oomoo`06Ool00`00Oomoo`0MOol4000POol003moo`03
001oogoo00Uoo`03001oogoo02Eoo`@00?mooaQoo`8000Ioo`03001oogoo01Uoo`@002Aoo`00@7oo
00<007ooOol027oo00<007ooOol087oo1@00ogoo7Woo00<007ooOol00goo00<007ooOol057oo1@00
:7oo0011Ool20008Ool00`00Oomoo`0LOol4003oOolTOol00`00Oomoo`02Ool00`00Oomoo`0@Ool4
000]Ool004=oo`03001oogoo00Eoo`03001oogoo01Qoo`@00?moobUoo`05001oogooOol0000>Ool4
000aOol004Aoo`03001oogoo00Aoo`03001oogoo01Aoo`@00?moobioo`04001oogoo000:Ool4000e
Ool004Eoo`03001oogoo00=oo`03001oogoo011oo`@00?mooc=oo`03001oo`0000Eoo`D003Uoo`00
AWoo0P000goo00<007ooOol037oo1000ogoo>7oo0P0000=oo`0000000P00?Woo0018Ool01000Oomo
o`002Goo1@00ogoo?Goo0P00@Woo0019Ool00`00Ool00005Ool4003oOon6Ool004Yoo`800003Ool0
000000800?moohYoo`00Bgoo0P00ogooSWoo003oOomoOol00`00Oomoo`03Ool00`00Oomoo`1COol0
0?moogmoo`03001oogoo009oo`03001oo`0005Aoo`00@goo00<007ooOol0ogoo>Goo0`000Woo00<0
07oo00001goo0P0000Aoo`00Oomoo`<00006Ool007ooOol007oo1000>Woo0013Ool00`00Oomoo`02
Ool3003oOoldOol02000Oomoo`00Ool007oo0002Ool50002Ool20002Ool00`00Oomoo`020002Ool2
0002Ool2000jOol004=oo`<000=oo`03001oogoo00Ioo`800004Ool007ooOol300001Woo001oogoo
001oo`@00?mooaYoo`08001oogoo001oo`00Ool000Ioo`03001oogoo0080009oo`03001oogoo0080
009oo`<00003Ool0000003Yoo`00@goo00@007ooOol0009oo`04001oogooOol50002Ool20002Ool0
0`00Oomoo`020002Ool20002Ool2003oOolJOol01000Oomoo`002Woo00<007ooOol00P000Woo00<0
07ooOol00P000Woo00<007ooOol00`00>Woo0013Ool01@00Oomoo`00Ool00`001Woo00<007ooOol0
0P000Woo00<007ooOol00P000Woo0`0000=oo`000000ogoo6Woo0`0037oo0P0000Aoo`00001oo`<0
0003Ool007oo00800005Ool00000Ool0000jOol004=oo`04001oogoo000:Ool00`00Oomoo`020002
Ool00`00Oomoo`020002Ool00`00Oomoo`03003oOol_Ool01@00Oomoogoo00000Woo00<007ooOol0
0Woo00<007ooOol0>7oo0013Ool3000<Ool2000017oo000007oo0`0000=oo`00Ool00P0000Eoo`00
001oo`000?moogIoo`00F7oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moogAo
o`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003o
OooKOol00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol00?moom]o
o`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol006Moo`03001oogoo0?moog5o
o`00Igoo00<007ooOol0ogooLGoo001WOol00`00Oomoo`3oOomaOol006Moo`03001oogoo0?moog5o
o`00IWoo0P004Goo00<007ooOol0ogooGgoo001WOol00`00Oomoo`08Ool40003Ool00`00Oomoo`3o
OomOOol006aoo`8000]oo`03001oogoo0?mooemoo`00CWoo0P0000Aoo`00Oomoo`8001=oo`<00003
Ool007oo00Yoo`03001oogoo0?mooemoo`00?Goo00<007oo00003Goo00@007ooOol000Eoo`03001o
ogoo00ioo`80009oo`04001oo`000009Ool2003oOomQOol003eoo`03001oo`0000eoo`04001oogoo
0005Ool00`00Oomoo`0<Ool30005Ool00`00Ool00009Ool00`00Oomoo`3oOomOOol003ioo`03001o
ogoo00aoo`04001oogoo0002Ool01000Oomoo`002goo0`0027oo00<007oo0000ogooJgoo000mOol0
0`00Ool0000=Ool01000Oomoo`000Woo0`002Woo0P000Woo00<007ooOol01Woo00@007oo00000?mo
ofYoo`00?Goo00<007oo00003Woo0P0017oo0`001goo0`0037oo00@007ooOol00?moofYoo`00Fgoo
0`003goo00D007ooOomoo`000?moofUoo`00FGoo0P0000=oo`00Ool03goo00H007ooOol007oo003o
OomXOol0049oo`8001=oo`<001=oo`03001oogoo009oo`03001oogoo0?moofIoo`00@Goo00@007oo
Ool000moo`<0009oo`03001oogoo019oo`04001oogooOol2003oOomWOol0045oo`04001oogoo000=
Ool200000goo001oo`0GOol00`00Oomoo`02Ool00`00Oomoo`3oOomUOol0045oo`04001oogoo000:
Ool4000KOol00`00Oomoo`03Ool00`00Oomoo`09Ool2000017oo001oogoo0P00ogooDgoo0011Ool0
1000Oomoo`0027oo0P007goo00<007ooOol00goo0P001Goo1@000Woo00<007ooOol00goo00<007oo
Ool0ogooD7oo0012Ool20007Ool20002Ool00`00Oomoo`0LOol00`00Oomoo`04Ool00`00Oomoo`07
Ool01000Oomoo`001Goo00<007ooOol0ogooD7oo0018Ool4000ROol00`00Oomoo`05Ool00`00Oomo
o`06Ool01000Oomoo`000Woo00@007ooOol00?mooe9oo`00:goo0P0000Aoo`00Oomoo`8001=oo`80
02Ioo`03001oogoo00Aoo`8000Qoo`04001oogoo0002Ool3003oOomCOol002Ioo`D0009oo`03001o
ogoo00=oo`03001oogoo00ioo`80009oo`03001oogoo02=oo`03001oogoo00Ioo`03001oogoo00Io
o`8000Aoo`<00?mooe9oo`00:Woo00@007ooOol000Eoo`03001oogoo00]oo`@002Uoo`03001oogoo
00Ioo`800?moof9oo`00:Woo00@007ooOol0009oo`04001oogoo000;Ool3000/Ool00`00Oomoo`07
Ool00`00Oomoo`0?Ool2003oOom?Ool002Yoo`04001oogoo0002Ool30009Ool3000_Ool00`00Oomo
o`08Ool00`00Oomoo`0?Ool00`00Oomoo`3oOom=Ool002]oo`8000Aoo`<000Ioo`80009oo`03001o
ogoo02eoo`03001oogoo00Qoo`03001oogoo00moo`03001oogoo0?moodeoo`008Woo00<007ooOol0
4goo1000<Woo00<007ooOol02Goo00<007ooOol03Goo00<007oo0000ogooCWoo000LOol40002Ool0
0`00Oomoo`0@Ool4000eOol00`00Oomoo`09Ool2000>Ool00`00Ool0003oOom>Ool0029oo`03001o
ogoo00ioo`8003Uoo`03001oogoo00Yoo`03001oogoo00Aoo`8000Ioo`03001oo`000?moodioo`00
8Woo00<007ooOol037oo0P0000=oo`00Ool0>7oo00<007ooOol02goo00<007ooOol00Woo00@007oo
Ool000Aoo`05001oogooOol0003oOom=Ool0025oo`8000]oo`@003aoo`03001oogoo00]oo`03001o
ogoo009oo`04001oogoo003oOomFOol0029oo`03001oogoo00Moo`<003moo`03001oogoo00aoo`05
001oogooOol00002Ool00`00Oomoo`3oOomDOol002Yoo`8004=oo`03001oogoo00]oo`80009oo`04
001oogoo003oOomFOol002Moo`<004Eoo`03001oogoo00aoo`04001oogooOol2003oOomGOol002Io
o`03001oo`0004Ioo`03001oogoo00aoo`800?mooe]oo`009Woo0P00Agoo00<007ooOol03Goo00<0
07ooOol0ogooFGoo000VOol00`00Ool0000ZOolB000:Ool00`00Oomoo`0>Ool00`00Oomoo`3oOomH
Ool0021oo`03001oogoo00=oo`04001oogoo000VOolG0008Ool00`00Oomoo`0>Ool2003oOomIOol0
01Yoo`@0009oo`03001oogoo009oo`8000=oo`03001oogoo021oo`/000@HaP03000Q224800<Q20P0
00Eoo`03001oogoo00moo`03001oogoo0?mooeMoo`0087oo00<007ooOol00Woo00<007ooOol00goo
00<007ooOol07Goo1P000PaS00@001S66<HHaP/000<Q2003000YBP0000D0009oo`03001oogoo00mo
o`800?mooeQoo`0087oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol06Woo0`0010aS1`00
1BU:00<0036<<H`00c6<1`0000<YBP0000000P0000=oo`00Ool04Goo00<007ooOol017oo0P0000Ao
o`00Oomoo`800?moodYoo`007goo0P0017oo0P001Woo00<007ooOol05goo2@000QS600<002U::DX0
1bU:00<0036<<H`01c6<00<003W>>Lh00`0000@YBP00000001=oo`03001oogoo009oo`04001oogoo
0005Ool00`00Oomoo`3oOom7Ool0021oo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo01Ao
o`H000DHaQ<000@aS003000icSW>008icPD001=oo`05001oogooOol00002Ool00`00Oomoo`03Ool0
0`00Oomoo`3oOom7Ool002Eoo`03001oogoo00Moo`03001oogoo019oo`@00003248001S6008HaP<0
008U:@03000aS36<00LaS003000icSW>00@icPL000DicP@0015oo`05001oogooOol00002Ool01000
Oomoo`000Woo00<007ooOol0ogooAgoo000UOol00`00Oomoo`08Ool00`00Oomoo`0?Ool400022480
0`006<H0000200059BT00`00<H`aS007<H`00`00>LhicP08>Lh00`00@Q1240030002>Lh00`00?Nl0
0002000AOol01000Oomoo`000Woo00<007ooOol00`00ogooBWoo000TOol00`00Oomoo`0:Ool00`00
Oomoo`0=Ool30003248300079BT00`00<H`aS003<H`<0004>Lh00`00@Q124003@Q040002?Nl2000@
Ool20002Ool20004Ool3003oOom9Ool002Aoo`8000aoo`03001oogoo00]oo`8000<8@P8000035:D0
02DY00DU:@P000DicP030012448@00A240L000E240<0008mk`80011oo`03001oogoo0?mooe9oo`00
97oo00<007ooOol037oo00<007ooOol02Goo0`0000<8@P0000000QBU00<002DY9BT01@000S6<00<0
03W>>Lh023W>00<0048@@Q00248@00<004YBBU800`000T8@0P0000=:DP0000000Sg_00<007ooOol0
3Goo0P00ogooDgoo000TOol00`00Oomoo`0=Ool00`00Oomoo`07Ool500035:D40007<H`00`00>Lhi
cP08>Lh00`00@Q124008@Q000`00BU9:DP03BU830000148@001:DTYB10003goo00<007ooOol0ogoo
DGoo000TOol2000?Ool00`00Oomoo`06Ool300045:D00`008@P00009<H`00`00>LhicP03>Lh<0004
@Q000`00BU9:DP06BU830003BU83000?Ool00`00Oomoo`3oOom@Ool002Aoo`03001oogoo00moo`03
001oogoo00Aoo`@0008DY@80008Q2003000aS36<00DaS0P000Dmk`030016<DHa00A6<@L000I:DP80
0003DY@004YB00=:DP8000ioo`03001oogoo00Eoo`03001oogoo0?moodQoo`005Woo0P0000Aoo`00
Oomoo`8000Ioo`03001oogoo011oo`03001oogoo009oo`L000@Q2003000aS36<00D0008e[@03000m
kcg_00Pmk`030016<DHa00Q6<@03001>Ldic00<000=:DP80009BU080009:DP<000ioo`03001oogoo
00Aoo`03001oogoo0?moodQoo`004Goo1@000Woo00<007ooOol00goo00<007ooOol00Woo0P004goo
00@007ooOomoo`D000DQ20@000Le[@03000mkcg_00Pmk`030016<DHa00Q6<@03001>Ldic00=>L`D0
00ABU0<00003BU80000000eoo`8000Eoo`03001oogoo0?moodQoo`005Goo00@007ooOol000Eoo`03
001oogoo009oo`03001oogoo01=oo`03001oo`0000@000@Q20800003:DX003F]00Pe[@03000mkcg_
00<mk`T000M6<@03001>Ldic00I>L`<000EBU0800003BU8007oo00eoo`8000Aoo`03001oogoo0?mo
odQoo`005Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0DOol4000010Q2000Q2248
0P000bU:00<003F]=Jd01CF]20001DHa00@004YBBU9:DPD00096<@03001>Ldic00I>L`800003E[D0
05:D00ABU004001:DTYB000<Ool30003Ool2003oOom:Ool001Eoo`04001oogoo0002Ool30005Ool0
0`00Oomoo`0DOol3000224800`008@P00005:DX00`00=Jde[@02=Jd30002?Nl00`00AS56<@08AS40
0`00BU9:DP06BU850006CW<20002E[D20003DY@20002BU800`00Oomoo`06Ool30002Ool00`00Oomo
o`02Ool00`00Oomoo`3oOom8Ool001Ioo`8000Aoo`<000Aoo`03001oogoo01=oo`<00088@P<000HY
BP03000e[@00008000Dmk`030016<DHa00Q6<@03001:DTYB00Q:DP03001BU5:D00<000=>L`8000AF
]@800006DY@005Je001:DP001Goo0`001Goo00<007ooOol0ogooCGoo000SOol00`00Oomoo`0COol2
000224820007:DX30008?Nl00`00AS56<@08AS400`00BU9:DP08BU800`00DYABU003DY@50006E[D2
0002E[D3000017oo0000000027oo00<007ooOol0ogooCGoo000ROol2000DOol2000224800`006<H0
0005:DX200000c6<000mk`08?Nl00`00AS56<@08AS400`00BU9:DP08BU800`00DYABU006DY@30006
E[D20002E[D3000;Ool00`00Oomoo`3oOom=Ool0029oo`03001oogoo01=oo`800005248001S66<H0
0002:DX30003<H`00`00?Nlmk`05?NlD0004BU800`00DYABU006DY@200000e[F00000004E[D00`00
G_L00002E[D00`00Oomoo`0;Ool00`00Oomoo`3oOom<Ool0029oo`03001oogoo019oo`@000<HaP<0
00HaS003000mkcg_008mk`<0009240030016<DHa00Q6<@03001>Ldic00A>L`P000EBU08000=JeP80
009F]@05001Nmekg001F]@02000<Ool00`00Oomoo`3oOom<Ool0029oo`03001oogoo019oo`<000<H
aP8000PaS003000mk`00008000E240030016<DHa00Q6<@03001>Ldic00Q>L`04001F]EJeE[D70005
F]H30003G_L3000<Ool00`00Oomoo`3oOom<Ool0029oo`03001oogoo019oo`8000<HaP03000U:@00
00LaS0<000Q240030016<DHa00Q6<@03001>Ldic00Q>L`03001F]EJe00IF]@<000IJeP8000=Nm`80
00aoo`03001oogoo0?moodaoo`008Woo00<007ooOol04Goo0`000QS600@002DY9BT000DaS0800003
>Lh0048@00Q240030016<DHa00Q6<@03001>Ldic00Q>L`03001F]EJe00IF]@800003G_L005[F00AJ
eP03001S600000=Nm`8000]oo`03001oogoo0?moodaoo`008Woo00<007ooOol04Goo0`0000<HaP00
9BT00bDY00<0036<<H`00P000cW>00<0048@@Q001d8@00<004HaAS400dHa300014ic00<005JeE[D0
1UJe0P000Ukg0P000e[F00@006<HHaP0009Nm`8000]oo`03001oogoo0?moodaoo`008Goo00<007oo
Ool04Woo10001BDY0`001SW>00<0048@@Q00148@20001DYB00<005:DDY@015:D1`001UJe0P0015kg
0P0000=JeP00HaP00V<H00<005kg00000P002Woo00<007ooOol0ogooC7oo000JOol20005Ool00`00
Oomoo`0BOol00`00124000059BT20008>Lh00`00@Q0000040002AS400`00BU9:DP08BU800`00DYAB
U008DY@00`00E[EF]@030003E[D00`00G_MNm`05G_L20004HaP4000;Ool00`00Oomoo`3oOom;Ool0
01Uoo`04001oogoo0004Ool00`00Oomoo`0AOol200000`@Q000U:@039BT00`00;F/00007>Lh30007
AS400`00BU9:DP08BU800`00DYABU008DY@00`00E[EF]@03E[D50007G_L00`00HaQS6003HaP3000;
Ool00`00Oomoo`3oOom;Ool001Uoo`04001oogoo0004Ool00`00Oomoo`0AOol01000124000000bDY
00@002e[;F/000DicP800003?Nl004Ha00Q6<@03001:DTYB00M:DP03001BU5:D00QBU003001F]EJe
00IF]@8000MNm`8000AS6003001Nm`0000]oo`03001oogoo0?mood]oo`004Woo0`0017oo00@007oo
Ool000Aoo`03001oogoo015oo`0700048@00248002DY000012e[00<003W>>Lh00P000cg_00<004Ha
AS401dHa00<004YBBU801dYB00<005:DDY@01e:D00<005JeE[D01eJe10001Ekg00<006Li00000f<H
0`002goo00<007ooOol0ogooBgoo000BOol00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0
4Goo0P000PQ20P001Be[0`001Sg_00<004HaAS4014Ha4P0015:D00<005JeE[D01eJe0P000Ukg0P00
0Ukg00P006LiIcUW>@00HaP006]J0P002goo00<007ooOol0ogooBgoo000COol00`00Oomoo`04Ool2
0004Ool2000COol2000224800`00;F/]J`03;F/20008?Nl00`00AS4000040002BU800`00CW=>L`07
CW<00`00DYABU003DY@70006E[D00`00G_L00004G_L30004IcT20002JeX00`00Oomoo`09Ool00`00
Oomoo`3oOom;Ool001Aoo`03001oogoo00Uoo`03001oogoo015oo`8000<8@P03000]Jbe[008]J`03
000e[@0000Lmk`<000M:DP03001>Ldic00M>L`03001BU5:D00MBU003001JeU[F00D00004E[D005kg
0006G_L00`00IcUW>@03IcT00`00JeY[FP02000:Ool00`00Oomoo`3oOom;Ool0019oo`<000]oo`03
001oogoo015oo`800088@P8000<]J`04000e[CF]0005?Nl200000d8@001:DP07BU800`00CW=>L`07
CW<00`00DYABU007DY@00`00F]IJeP05F]H40006G_L20004IcT01@00JeY[FV]J00002goo00<007oo
Ool0ogooBWoo000POol00`00Oomoo`0AOol200001`Q2000HaQS6000]J`0000@e[@03000mkcg_0080
00=24003001:DTYB00M:DP03001>Ldic00I>L`03001BU5:D00IBU003001JeU[F00MJeP04001Nm`00
0004G_L01000IcUW>@000fLi0P000V]J00<007ooOol02Goo00<007ooOol0ogooBWoo000POol00`00
Oomoo`0AOol300036<H20005=Jd30005@Q000`00BU9:DP07BU800`00CW=>L`06CW<00`00DYABU006
DY@00`00F]IJeP06F]H400000ekg001Nm`02G_L02@00IcUW>FLi001W>@00Kg/00002JeX00`00Oomo
o`09Ool00`00Oomoo`3oOom:Ool0021oo`03001oogoo015oo`8000@HaP03000e[CF]00<e[@8000Q2
4003001:DTYB00A:DQH000EJeP<0009Nm`03001Nmekg00800003G_L006Li00=W>@80009_N`<000]o
o`03001oogoo0?moodYoo`0087oo00<007ooOol04Goo0P0011S600<003F]=Jd00SF]00<003W>0000
248@00<004YB000010000TYB00<005:DDY@01U:D00<005JeE[D01UJe00<005[F000010000U[F00D0
05kgG_MNm`0000=Nm`8000EW>@03001_Nfmk008000aoo`03001oogoo0?moodYoo`007goo0P004goo
00<000@Q00000QS600<002DY00000SF]00D003W>>LhicP0000I240<000M:DP03001BU5:D00IBU003
001F]EJe00IF]@@00003F]H00000008000ENm`06001Nmekg001W>@0016Li00D006mkKg]_N`0000ao
o`03001oogoo0?moodYoo`007goo00<007ooOol04Woo00D000@Q000HaP00008U:@03000e[@0000@i
cP040012448@@Q0300000dHa001:DP07BU800`00DYABU006DY@00`00E[EF]@03E[D40007F]H20005
G_L20003IcT01P00IcUW>@00Kg/0009_N`03001oogoo00Yoo`03001oogoo0?moodYoo`007goo00<0
07ooOol04Woo00D000@Q000HaP0000<U:@03000icSW>00<icP04001240000005AS400`00BU9:DP06
BU800`00DYABU005DY@00`00E[EF]@030002E[D00`00F]IJeP06F]H00`00HaP000020003G_L00`00
IcUW>@02IcT00`00IcT00002Kg/00`00Kg/0000=Ool00`00Oomoo`3oOom9Ool001moo`8001Aoo`84
8@03000U:BDY008U:@03000icSW>00<icP8000M6<@03001:DTYB00I:DP04001BU5:DDY@90003E[D0
0`00F]IJeP05F]H00`00HaQS6003HaP200000ekg001W>@04IcT01000Kg]_Nfmk0`003Goo00<007oo
Ool0ogooBGoo000AOol2000017oo001oogoo0P001Woo00<007ooOol04goo00<000@Q00000bDY00<0
036<00000cW>00<0048@00001dHa00<004YBBU8014YB2`0015Je100000=JeP00F]H015[F00<006<H
HaP01F<H0`0016Li00<006mkKg/00Vmk0P003Goo00<007ooOol0ogooBGoo000@Ool01000Oomoo`00
1Goo00<007ooOol00goo00<007ooOol04goo00H000@Q36<002DY0002<H`01000>LhicP000d8@00<0
04HaAS401DHa00<004YB00000`000Tic100015:D00<005JeE[D01EJe00<005[FF]H00`000U[F00<0
06<HHaP01F<H00@006Li0000009W>@03001_N`0000=_N`8000eoo`03001oogoo0?moodUoo`0047oo
00@007ooOol000Eoo`03001oogoo00=oo`03001oogoo01=oo`80000436<002DY0002<H`00`00>Lh0
0005@Q000`00AS56<@03AS430004CW<30007DY@00`00E[EF]@05E[D00`00F]IJeP03F]H30006HaP0
1000IcUW>FLi0P0000IW>@00Kg]_N`00Kg/3000=Ool00`00Oomoo`3oOom9Ool0011oo`04001oogoo
0002Ool01000Oomoo`0017oo00<007ooOol05Goo00@000aS36<000@aS0030012448@00A240030016
<DHa00<00004BU8004icCW<30003CW<00`00DYABU004DY@00`00E[EF]@05E[D00`00F]IJeP04F]H0
1000HaP000000f<H00<006LiIcT00fLi0`000Vmk00<006mk00000P003Goo00<007ooOol0ogooBGoo
000@Ool01000Oomoo`000Woo0`001Goo00<007ooOol05Goo00@000aS36<000@aS0030012448@00A2
40<000=:DP@000I>L`03001BU5:D00ABU003001F]EJe00AF]@03001JeU[F00AJeP03001S66<H009S
60800003HaP006Li00EW>@8000=_N`03001cW00000ioo`03001oogoo0?moodUoo`004Goo0P0017oo
0`0017oo00<007ooOol05Goo00D000aS36<Li`00008aS003000icP0000A240040016<@00BU830002
BU800`00CW=>L`03CW<>0002E[D00`00F]IJeP04F]H00`00HaQS6004HaP20006IcT20003Kg/00`00
Li`0000?Ool00`00Oomoo`3oOom8Ool001ioo`03001oogoo01Ioo`8000047>L0036<0003>Lh01@00
@Q124000AS400`001DYB00<004icCW<00`000U:D00<005JeE[D015Je00<005[FF]H00U[F1P000e[F
00<006<HHaP016<H00@006Li000000=W>@05001_N`00001_N`0200000g>L001oo`0>Ool00`00Oomo
o`3oOom8Ool001ioo`03001oogoo01Ioo`80008Li`03000icSW>008icP0300124000008000=6<@03
001:DTYB009:DP<000EBU003001F]EJe00AF]@03001JeU[F00AJeP04001NmekgG_L30006HaP00`00
IcUW>@02IcT00`00IcT00002Kg/01000Kg/007Nm0P0047oo00<007ooOol0ogooB7oo000NOol00`00
Oomoo`0FOol200027>L00be[000icP040006AS400`00BU80000200000dic001BU005DY@00`00E[EF
]@04E[D00`00F]IJeP03F]H00`00G_MNm`04G_L01000HaP000000V<H00<006LiIcT016Li00<006mk
Kg/00Vmk00<007Nm00000P0047oo00<007ooOol0ogooB7oo000NOol00`00Oomoo`0GOol00`007>LL
i`030003>Lh00d8@0016<@04AS420005CW<00`00DYABU004DY@00`00E[EF]@03E[D00`00F]IJeP03
F]H00`00G_MNm`03G_L00`00HaQS6002HaP00`00HaP00006IcT00`00Kg]_N`02Kg/01000Mkeg_@00
4Goo00<007ooOol0ogooB7oo000MOol2000IOol40002;F/00`00>Lh00002@Q001`00AS56<DHa001:
DP0000I>L`03001BU5:D00=BU003001F]EJe00L0009JeP03001Nmekg009Nm`03001S66<H00AS6080
00EW>@03001_N`00009_N`80009g_@03001oogoo00moo`03001oogoo0?moodQoo`007Goo00<007oo
Ool05Goo0`0000Aoo`Q2000000<]J`030012448@009240030016<@0000=:DP03001>Ldic00=>L`04
001BU5:DDY@50003E[D01000F]IJeU[F1@000Ukg00<006<HHaP016<H00<006Li00000fLi00`006mk
Kg/006mk001g_@00Mkd007oo000@Ool00`00Oomoo`3oOom8Ool001eoo`03001oogoo015oo`@000Ao
o`030008@P0000<]J`030012448@00=24003001:DTYB00=:DP03001>Ldic009>L`@0009F]@03001F
]EJe00=F]@03001JeU[F009JeP04001NmekgG_L20006HaP01`00IcUW>FLi001W>@0000A_N`03001g
_GNm008000=oo`03001oogoo00ioo`03001oogoo0?moodMoo`007Goo00<007ooOol03Woo0`002Goo
00<8@QcW00000Re[0P000d8@00<004Ha000014YB00<004ic00000P0000=BU000E[D00eJe00<005Je
E[D00UJe00<005[FF]H00e[F00<005kgG_L00Ukg00<006<H00000P0000=S6000IcT016Li00<006mk
Kg/00Vmk0P000WNm0P0017oo00<007ooOol03Goo00<007ooOol0ogooAgoo000MOol00`00Oomoo`0;
Ool3000<Ool200000acW;F/00002>Lh00`00@Q000003AS401000BU9:DTYB0P001E:D00<005JeE[D0
0UJe00D005JeE[EF]@0000AJeP03001Nmekg009Nm`03001S66<H00=S608000=W>@03001_N`0000=_
N`04001g_@00Mkd20006Ool00`00Oomoo`0<Ool00`00Oomoo`3oOom7Ool001eoo`03001oogoo00Mo
o`@0011oo`04248LiacW0003>Lh20004AS400`00BU800002CW<00`00DYABU002DY@00`00E[EF]@0:
00000e[F001Nm`03G_L00`00HaQS6002HaP01P00IcUW>@00IcT000=_N`03001_N`00009g_@@000Mo
o`03001oogoo00]oo`03001oogoo0?moodMoo`007Goo00<007ooOol017oo0`005Goo00@001cW;F/0
008icP92408000=6<@8000=>L`04001BU5:DDY@30002F]H01@00F]IJeU[F00000ekg10000Ukg00D0
06<HHaQS600000AW>@03001_Nfmk00=_N`07001g_GNmMkd007Nm000027oo00<007ooOol02goo00<0
07ooOol0ogooAgoo000LOol20003Ool3000IOol2000012e[000icP000d8@00<004Ha00000Tic00T0
04icCW=>L`00DY@005Je00000e[F00D005[FF]IJeP0000ANm`03001Nmekg00@00003HaP006Li009W
>@03001[FP00009_N`800005Li`007Nm001g_@02000:Ool00`00Oomoo`0:Ool00`00Oomoo`3oOom7
Ool001Ioo`03001oogoo00=oo`03001oo`00008001eoo`057>L002e[>Lh00004@Q020003CW<00`00
CW=>L`020003E[D01@00F]IJeU[F00000U[F00D005kgG_MNm`0000=Nm`05001S66<HHaP00003IcT0
1000JeY[FV]J0P000g>L0P0000=g_@00000037oo00<007ooOol02Goo00<007ooOol0ogooAgoo000F
Ool00`00Oomoo`03Ool2000QOol200000be[00000003@Q02BU820002CW<20002E[D01@00E[EF]EJe
00000U[F00@005[FF]H000=Nm`04001Nmekg0003HaP2IcT00`00IcT00004JeX00`00LiacW002Li`0
1000Mkeg_@003Woo00<007ooOol02Goo00<007ooOol0ogooAWoo000FOol00`00Oomoo`05Ool00`00
Oomoo`0OOol01`00;F/003W>0012400000A:DP9>L`06001BU000001F]@000UJe3@000V<H00<006Li
IcT00VLi00L006]JJeY[FP00Kg/00002Li`00`00Mkd00002000@Ool00`00Oomoo`08Ool00`00Oomo
o`3oOom6Ool001Ioo`03001oogoo00Ioo`80021oo`03000]J`00008icP8000A:DP8000=BU008001F
]@00001JeP00F]H0009Nm`04001Nmekg0002HaP00`00HaP00003IcT01P00JeY[FP00JeX000=_N`80
0004Mkd00000000AOol00`00Oomoo`08Ool00`00Oomoo`3oOom6Ool001Eoo`8000Yoo`03001oogoo
01ioo`<00003>Lh004Ha0080009:DP04001BU0000002DY@200002U[F001JeP00F]H005kg001Nm`00
0V<H00L006<HIcUW>@00IcT00004JeX00`00Kg]_N`02Kg/00`00Mkeg_@02000COol00`00Oomoo`07
Ool00`00Oomoo`3oOom6Ool001Ioo`03001oogoo00Uoo`03001oogoo01ioo`<00003>Lh004Ha0096
<@8000=BU006001BU000F]H005[F0P0000=JeP0000000`0000=S6000000016Li00<006]JJeX00P00
00=[FP0000000P0000=cW00000000P005Goo00<007ooOol01Woo00<007ooOol0ogooAWoo000SOol2
000POol00`00<H`0000400000e:D00000002DY@500000e[F00000003000016<H000000000VLi0P00
0VLi00<006]JJeX00V]J00L007>LLiacW000Li`0000HOol00`00Oomoo`05Ool00`00Oomoo`3oOom6
Ool002Eoo`03001oogoo01ioo`<0009240@00004DY@000000002E[D<0005IcT30002Kg/6000JOol0
0`00Oomoo`04Ool00`00Oomoo`3oOom6Ool002Ioo`8001moo`06000YBP00001240000dic0`0000=F
]@0000003@000f]J00D006mk001_N`00009cW08001aoo`03001oogoo00Eoo`03001oogoo0?moodEo
o`00:7oo00<007ooOol07Woo00<DY@00?Nl0100000A>L`00E[EF]@H00003G_L006<H00L00005JeX0
0000001_N`04000OOol00`00Oomoo`04Ool00`00Oomoo`3oOom5Ool002Uoo`03001oogoo021oo`05
8@P003g_001>L`030003F]H200000ekg000000050002IcT00f]J00000006000QOol00`00Oomoo`03
Ool00`00Oomoo`3oOom5Ool002Yoo`80025oo`03001oo`0000D0009JeP03001JeP0000<0009S609W
>@T002Aoo`03001oogoo009oo`03001oogoo0?moodEoo`00;7oo00<007ooOol07Woo00@007ooOomo
o`<0009>L`04001JeP00G_L>000WOol01@00Oomoogoo0000ogooAgoo000]Ool2000NOol00`00Oomo
o`04Ool01@00=Jd00000DY@02P00;Goo00@007ooOol00?moodMoo`00;goo00<007ooOol06goo00<0
07ooOol0@7oo00@007ooOol00?moodMoo`00<7oo00<007ooOol06Woo00<007ooOol0@Goo00@007oo
Ool00?moodIoo`00<Goo0P006Woo00<007ooOol0@Woo00<007oo0000ogooAWoo000cOol00`00Oomo
o`0GOol00`00Oomoo`13Ool2003oOom6Ool003Aoo`8001Moo`03001oogoo049oo`<00?moodIoo`00
=Woo00<007ooOol057oo00<007ooOol0?Woo1000ogooBGoo000gOol2000DOol00`00Oomoo`0iOol5
003oOom=Ool003Uoo`03001oogoo011oo`03001oogoo03Ioo`@00?mooe9oo`00>Woo00<007ooOol0
3goo00<007ooOol0<Woo1000ogooEWoo000kOol2000?Ool00`00Oomoo`0^Ool4003oOomJOol003eo
o`03001oogoo00aoo`03001oogoo02Uoo`D00?mooeioo`00?Woo0P0037oo00<007ooOol09Goo1000
ogooHgoo0010Ool00`00Oomoo`09Ool00`00Oomoo`0QOol4003oOomWOol0045oo`03001oogoo00Qo
o`03001oogoo01eoo`@00?moof]oo`00@Woo0P0027oo00<007ooOol06Goo1000ogooKgoo0014Ool0
0`00Oomoo`05Ool00`00Oomoo`0DOol5003oOomcOol004Eoo`8000Eoo`03001oogoo011oo`@00?mo
ogQoo`00Agoo00<007ooOol00Woo00<007ooOol037oo1000ogooO7oo0018Ool01@00Oomoogoo0000
2Woo1000ogooP7oo0019Ool200000goo001oo`04Ool5003oOon4Ool004]oo`800003Ool000000080
0?moohUoo`00C7oo0P00ogooSGoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol004Uoo`03
001oogoo00Moo`800004Ool007ooOol300001Woo001oogoo001oo`@00?moogEoo`00BWoo00<007oo
Ool0100000Aoo`00Oomoo`80009oo`03001oogoo0080009oo`80009oo`800?moogEoo`00BGoo00<0
07ooOol01Woo00<007ooOol00P000Woo00<007ooOol00P000Woo0`0000=oo`000000ogooMGoo0018
Ool00`00Oomoo`07Ool00`00Oomoo`020002Ool00`00Oomoo`020002Ool00`00Oomoo`03003oOome
Ool004Uoo`03001oogoo00Moo`800004Ool00000Ool300000goo001oo`0200001Goo000007oo0000
ogooMGoo001IOol01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0ogooLgoo003oOooK
Ool00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00ogoofgoo003oOooKOol00?moom]oo`00
ogoofgoo0000\
\>"],
  ImageRangeCache->{{{0, 473.625}, {337, 0}} -> {-0.0768455, -0.0534381, \
0.00665863, 0.00665863}, {{11.5, 152.313}, {328.938, 176.125}} -> {-0.15582, \
-0.137371, 0.00758916, 0.00758916}, {{166.375, 307.188}, {328.938, 176.125}} -> \
{-1.77598, -0.316248, 0.00940511, 0.00940511}, {{321.25, 462.063}, {328.938, \
176.125}} -> {-2.44679, -0.151474, 0.00727814, 0.00727814}, {{11.5, 152.313}, \
{160.813, 8}} -> {-0.152333, -1.33206, 0.00712753, 0.00712753}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0661
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0253834 0.31746 [
[ 0 0 0 0 ]
[ 1 1.0661 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0661 L
0 1.0661 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0253834 0.321429 0.508876 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
-0.218821 1.52137 -1.11022e-16 1.52137 [
[.5 1.46717 -21.125 0 ]
[.5 1.46717 21.125 10.625 ]
[.08216 .16577 -19.415 -10 ]
[.08216 .16577 1.14747 0 ]
[.1847 .1225 -18.9462 -10 ]
[.1847 .1225 1.61633 0 ]
[.29019 .07798 -7.58187 -10 ]
[.29019 .07798 .85563 0 ]
[.39878 .03217 -13.1916 -10 ]
[.39878 .03217 1.87091 0 ]
[.51059 -0.01498 -12.8481 -10 ]
[.51059 -0.01498 2.21437 0 ]
[.23092 .00363 -7.18874 -10 ]
[.23092 .00363 .81126 0 ]
[.54184 -0.00533 0 -7.10061 ]
[.54184 -0.00533 20.5625 2.89939 ]
[.65925 .16129 0 -6.96183 ]
[.65925 .16129 20.5625 3.03817 ]
[.76511 .31152 0 -6.84024 ]
[.76511 .31152 8.4375 3.15976 ]
[.86103 .44765 0 -6.73285 ]
[.86103 .44765 15.0625 3.26715 ]
[.94834 .57159 0 -6.63731 ]
[.94834 .57159 15.0625 3.36269 ]
[.85434 .27867 0 -6.84024 ]
[.85434 .27867 8 3.15976 ]
[.07587 .18984 -20.5625 -2.89898 ]
[.07587 .18984 0 7.10102 ]
[.05559 .36867 -20.5625 -3.01764 ]
[.05559 .36867 0 6.98236 ]
[.03341 .5643 -8.4375 -3.14821 ]
[.03341 .5643 0 6.85179 ]
[.00904 .77922 -15.0625 -3.2926 ]
[.00904 .77922 0 6.7074 ]
[-0.01784 1.01642 -15.0625 -3.45311 ]
[-0.01784 1.01642 0 6.54689 ]
[-0.05576 .59732 -8 -3.14821 ]
[-0.05576 .59732 0 6.85179 ]
[ 0 0 0 0 ]
[ 1 1.45467 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.46717 -82.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.625000 moveto
 540.000000 14.625000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.625000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
67.437500 12.375000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(yz) show
74.500000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
79.625000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
101.250000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.09363 .18048 m
.52287 0 L
s
.09479 .17999 m
.10111 .1871 L
s
gsave
.08216 .16577 -80.415 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.19695 .13704 m
.20308 .14431 L
s
gsave
.1847 .1225 -79.9462 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.30205 .09285 m
.30798 .10028 L
s
gsave
.29019 .07798 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4102 .04737 m
.41592 .05497 L
s
gsave
.39878 .03217 -74.1916 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.52156 .00055 m
.52704 .00832 L
s
gsave
.51059 -0.01498 -73.8481 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.115 .1715 m
.11876 .17578 L
s
.13531 .16295 m
.13906 .16726 L
s
.15575 .15436 m
.15947 .15869 L
s
.17629 .14572 m
.17999 .15007 L
s
.21773 .1283 m
.22139 .13268 L
s
.23863 .11951 m
.24226 .12391 L
s
.25965 .11067 m
.26326 .1151 L
s
.28079 .10179 m
.28437 .10623 L
s
.32343 .08386 m
.32696 .08834 L
s
.34494 .07482 m
.34844 .07932 L
s
.36657 .06572 m
.37005 .07024 L
s
.38832 .05657 m
.39178 .06111 L
s
.43222 .03812 m
.43562 .0427 L
s
.45436 .02881 m
.45773 .03341 L
s
.47662 .01944 m
.47997 .02407 L
s
.49903 .01003 m
.50234 .01467 L
s
gsave
.23092 .00363 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.52287 0 m
.93124 .57888 L
s
.5243 .00203 m
.51554 .00572 L
s
gsave
.54184 -0.00533 -61 -11.1006 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.64155 .16824 m
.6327 .17171 L
s
gsave
.65925 .16129 -61 -10.9618 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.74726 .31808 m
.73834 .32137 L
s
gsave
.76511 .31152 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.84306 .45388 m
.83407 .45699 L
s
gsave
.86103 .44765 -61 -10.7328 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.93027 .57751 m
.92124 .58047 L
s
gsave
.94834 .57159 -61 -10.6373 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.5548 .04526 m
.54953 .04744 L
s
.58448 .08734 m
.5792 .08949 L
s
.61339 .12832 m
.60809 .13043 L
s
.66899 .20713 m
.66367 .20919 L
s
.69574 .24505 m
.69041 .24707 L
s
.72182 .28202 m
.71648 .28402 L
s
.77208 .35327 m
.76672 .35521 L
s
.79631 .38761 m
.79094 .38953 L
s
.81996 .42114 m
.81458 .42303 L
s
.86562 .48586 m
.86022 .4877 L
s
.88766 .51711 m
.88226 .51893 L
s
.90921 .54765 m
.90379 .54945 L
s
gsave
.85434 .27867 -61 -10.8402 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.09363 .18048 m
0 1.0137 L
s
.0934 .18247 m
.10217 .17879 L
s
gsave
.07587 .18984 -81.5625 -6.89898 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.07327 .36166 m
.08211 .35815 L
s
gsave
.05559 .36867 -81.5625 -7.01764 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.05124 .5577 m
.06016 .55439 L
s
gsave
.03341 .5643 -69.4375 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.02704 .77307 m
.03604 .77 L
s
gsave
.00904 .77922 -76.0625 -7.2926 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00033 1.0108 m
.00941 1.00799 L
s
gsave
-0.01784 1.01642 -76.0625 -7.45311 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.08853 .22581 m
.0938 .22362 L
s
.08356 .2701 m
.08884 .26794 L
s
.07847 .31537 m
.08376 .31324 L
s
.06795 .409 m
.07326 .40693 L
s
.06251 .45743 m
.06783 .45538 L
s
.05694 .50698 m
.06228 .50497 L
s
.04541 .60962 m
.05077 .60767 L
s
.03943 .66279 m
.04481 .66088 L
s
.03331 .71726 m
.0387 .71538 L
s
.02061 .83028 m
.02602 .82847 L
s
.01402 .88893 m
.01944 .88716 L
s
.00726 .94909 m
.0127 .94736 L
s
gsave
-0.05576 .59732 -69 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.09363 .18048 m
0 1.0137 L
s
0 1.0137 m
.5592 1.45467 L
s
.5592 1.45467 m
.55672 .70144 L
s
.55672 .70144 m
.09363 .18048 L
s
.52287 0 m
.93124 .57888 L
s
.93124 .57888 m
1 1.3537 L
s
1 1.3537 m
.51861 .85346 L
s
.51861 .85346 m
.52287 0 L
s
.09363 .18048 m
0 1.0137 L
s
0 1.0137 m
.51861 .85346 L
s
.51861 .85346 m
.52287 0 L
s
.52287 0 m
.09363 .18048 L
s
.55672 .70144 m
.93124 .57888 L
s
.93124 .57888 m
1 1.3537 L
s
1 1.3537 m
.5592 1.45467 L
s
.5592 1.45467 m
.55672 .70144 L
s
0 0 m
1 0 L
1 1.45467 L
0 1.45467 L
closepath
clip
newpath
.5 Mabswid
.53445 .63506 m .53302 .69047 L .62513 .67768 L p .745 g
F P
0 g
s
.62513 .67768 m .61172 .61755 L .53445 .63506 L p .745 g
F P
0 g
s
.63243 .74351 m .62513 .67768 L .53302 .69047 L p .663 g
F P
0 g
s
.61172 .61755 m .62513 .67768 L .71902 .65396 L p .677 g
F P
0 g
s
.62513 .67768 m .63243 .74351 L .73472 .7205 L p .588 g
F P
0 g
s
.73472 .7205 m .71902 .65396 L .62513 .67768 L p .588 g
F P
0 g
s
.71902 .65396 m .69034 .595 L .61172 .61755 L p .677 g
F P
0 g
s
.69034 .595 m .71902 .65396 L .79349 .62255 L p .619 g
F P
0 g
s
.71902 .65396 m .73472 .7205 L .81608 .68499 L p .504 g
F P
0 g
s
.81608 .68499 m .79349 .62255 L .71902 .65396 L p .504 g
F P
0 g
s
.53302 .69047 m .53225 .75074 L .63243 .74351 L p .663 g
F P
0 g
s
.63193 .80297 m .63243 .74351 L .53225 .75074 L p .568 g
F P
0 g
s
.63243 .74351 m .63193 .80297 L .73373 .78244 L p .475 g
F P
0 g
s
.73373 .78244 m .73472 .7205 L .63243 .74351 L p .475 g
F P
0 g
s
.73472 .7205 m .73373 .78244 L .81453 .74619 L p .339 g
F P
0 g
s
.81453 .74619 m .81608 .68499 L .73472 .7205 L p .339 g
F P
0 g
s
.5363 .59559 m .53445 .63506 L .61172 .61755 L p .841 g
F P
0 g
s
.61172 .61755 m .59436 .57502 L .5363 .59559 L p .841 g
F P
0 g
s
.59436 .57502 m .61172 .61755 L .69034 .595 L p .777 g
F P
0 g
s
.69034 .595 m .65331 .55538 L .59436 .57502 L p .777 g
F P
0 g
s
.65331 .55538 m .69034 .595 L .75225 .57036 L p .728 g
F P
0 g
s
.79349 .62255 m .75225 .57036 L .69034 .595 L p .619 g
F P
0 g
s
.4767 .64984 m .46401 .6951 L .53302 .69047 L p .845 g
F P
0 g
s
.53302 .69047 m .53445 .63506 L .4767 .64984 L p .845 g
F P
0 g
s
.53225 .75074 m .53302 .69047 L .46401 .6951 L p .761 g
F P
0 g
s
.46401 .6951 m .45725 .74513 L .53225 .75074 L p .761 g
F P
0 g
s
.53232 .80464 m .53225 .75074 L .45725 .74513 L p .665 g
F P
0 g
s
.53225 .75074 m .53232 .80464 L .63193 .80297 L p .568 g
F P
0 g
s
.62245 .84414 m .63193 .80297 L .53232 .80464 L p .393 g
F P
0 g
s
.63193 .80297 m .62245 .84414 L .71352 .82758 L p .254 g
F P
0 g
s
.71352 .82758 m .73373 .78244 L .63193 .80297 L p .254 g
F P
0 g
s
.75225 .57036 m .79349 .62255 L .82988 .5926 L p .511 g
F P
0 g
s
.79349 .62255 m .81608 .68499 L .85604 .64653 L p .331 g
F P
0 g
s
.85604 .64653 m .82988 .5926 L .79349 .62255 L p .331 g
F P
0 g
s
.49314 .61867 m .4767 .64984 L .53445 .63506 L p .926 g
F P
0 g
s
.53445 .63506 m .5363 .59559 L .49314 .61867 L p .926 g
F P
0 g
s
.73373 .78244 m .71352 .82758 L .78523 .79432 L p .079 g
F P
0 g
s
.78523 .79432 m .81453 .74619 L .73373 .78244 L p .079 g
F P
0 g
s
.75225 .57036 m .69924 .53914 L .65331 .55538 L p .728 g
F P
0 g
s
.69924 .53914 m .75225 .57036 L .7819 .5517 L p .566 g
F P
0 g
s
.82988 .5926 m .7819 .5517 L .75225 .57036 L p .511 g
F P
0 g
s
.81608 .68499 m .81453 .74619 L .85376 .70345 L p .053 g
F P
0 g
s
.85376 .70345 m .85604 .64653 L .81608 .68499 L p .053 g
F P
0 g
s
.5363 .59559 m .59436 .57502 L p .55392 .58032 L .922 g
F P
0 g
s
.55392 .58032 m .54899 .58096 L .54197 .58906 L .922 g
F
.55392 .58032 m .54197 .58906 L .5363 .59559 L F
.59436 .57502 m .57564 .56128 L .53829 .58237 L p F P
0 g
s
.55859 .58553 m .5401 .6037 L p .56883 .56941 L F P
s
.57564 .56128 m .57108 .56776 L p .56883 .56941 L F P
s
.57108 .56776 m .55859 .58553 L p .56883 .56941 L F P
s
.57564 .56128 m .59436 .57502 L .65331 .55538 L p .866 g
F P
0 g
s
.65331 .55538 m .6135 .54595 L .57564 .56128 L p .866 g
F P
0 g
s
.57731 .57535 m .55859 .58553 L p .60064 .55523 L F P
s
.6135 .54595 m .60439 .55335 L p .60064 .55523 L F P
s
.60439 .55335 m .57731 .57535 L p .60064 .55523 L F P
s
.53829 .58237 m .53765 .58661 L p .54899 .58096 L .922 g
F P
0 g
s
.53765 .58661 m .5363 .59559 L p .54899 .58096 L .922 g
F P
0 g
s
.6135 .54595 m .65331 .55538 L .69924 .53914 L p .706 g
F P
0 g
s
.45725 .74513 m .45804 .79035 L .53232 .80464 L p .665 g
F P
0 g
s
.53334 .84119 m .53232 .80464 L .45804 .79035 L p .488 g
F P
0 g
s
.53232 .80464 m .53334 .84119 L .62245 .84414 L p .393 g
F P
0 g
s
.5401 .6037 m .5266 .62975 L p .5346 .59731 L F P
s
.50959 .60988 m .5363 .59559 L p .52118 .60406 L .836 g
F P
0 g
s
.52118 .60406 m .51075 .6099 L .50959 .60988 L .836 g
F
.5363 .59559 m .53829 .58237 L .51075 .6099 L p F P
0 g
s
.53829 .58237 m .53936 .59493 L p .5346 .59731 L F P
s
.53936 .59493 m .5401 .6037 L p .5346 .59731 L F P
s
.51075 .6099 m .49314 .61867 L .50959 .60988 L p .836 g
F P
0 g
s
.45416 .66892 m .43682 .69987 L .46401 .6951 L p .863 g
F P
0 g
s
.46401 .6951 m .4767 .64984 L .45416 .66892 L p .863 g
F P
0 g
s
.45725 .74513 m .46401 .6951 L .43682 .69987 L p .851 g
F P
0 g
s
.69924 .53914 m .64264 .53819 L .6135 .54595 L p .706 g
F P
0 g
s
.64264 .53819 m .69924 .53914 L .72054 .53259 L p .053 g
F P
0 g
s
.7819 .5517 m .72054 .53259 L .69924 .53914 L p .566 g
F P
0 g
s
.81453 .74619 m .78523 .79432 L .81907 .75262 L p F P
s
.81907 .75262 m .85376 .70345 L .81453 .74619 L p F P
s
.43682 .69987 m .42774 .73554 L .45725 .74513 L p .851 g
F P
0 g
s
.45804 .79035 m .45725 .74513 L .42774 .73554 L p .746 g
F P
0 g
s
.60356 .85589 m .62245 .84414 L .53334 .84119 L p .095 g
F P
0 g
s
.62245 .84414 m .60356 .85589 L .67319 .84439 L p .019 g
F P
0 g
s
.67319 .84439 m .71352 .82758 L .62245 .84414 L p .019 g
F P
0 g
s
.47664 .64933 m .45416 .66892 L .4767 .64984 L p .687 g
F P
0 g
s
.4767 .64984 m .49314 .61867 L .47664 .64933 L p .687 g
F P
0 g
s
.71352 .82758 m .67319 .84439 L .72728 .81812 L p .651 g
F P
0 g
s
.72728 .81812 m .78523 .79432 L .71352 .82758 L p .651 g
F P
0 g
s
.7819 .5517 m .82988 .5926 L .81589 .57824 L p .145 g
F P
0 g
s
.82988 .5926 m .85604 .64653 L .84088 .62015 L p .36 g
F P
0 g
s
.84088 .62015 m .81589 .57824 L .82988 .5926 L p .36 g
F P
0 g
s
.72054 .53259 m .7819 .5517 L .76953 .55102 L p .13 g
F P
0 g
s
.81589 .57824 m .76953 .55102 L .7819 .5517 L p .145 g
F P
0 g
s
.45804 .79035 m .46736 .82145 L .53334 .84119 L p .488 g
F P
0 g
s
.53536 .8504 m .53334 .84119 L .46736 .82145 L p .128 g
F P
0 g
s
.53334 .84119 m .53536 .8504 L .60356 .85589 L p .095 g
F P
0 g
s
.42774 .73554 m .42918 .76886 L .45804 .79035 L p .746 g
F P
0 g
s
.46736 .82145 m .45804 .79035 L .42918 .76886 L p .494 g
F P
0 g
s
.85604 .64653 m .85376 .70345 L .83795 .66886 L p .742 g
F P
0 g
s
.83795 .66886 m .84088 .62015 L .85604 .64653 L p .742 g
F P
0 g
s
.55859 .58553 m .57564 .56128 L .6135 .54595 L p F P
s
.57731 .57535 m .6135 .54595 L .64264 .53819 L p .07 g
F P
0 g
s
.5401 .6037 m .53829 .58237 L .57564 .56128 L p F P
s
.5005 .64658 m .47664 .64933 L .49314 .61867 L p F P
s
.49314 .61867 m .51075 .6099 L .5005 .64658 L p F P
s
.72054 .53259 m .65559 .54206 L .64264 .53819 L p .053 g
F P
0 g
s
.65559 .54206 m .72054 .53259 L .71043 .54461 L p .144 g
F P
0 g
s
.76953 .55102 m .71043 .54461 L .72054 .53259 L p .13 g
F P
0 g
s
.64264 .53819 m .59153 .57425 L .57731 .57535 L p .07 g
F P
0 g
s
.59153 .57425 m .64264 .53819 L .65559 .54206 L p .158 g
F P
0 g
s
.78523 .79432 m .72728 .81812 L .75165 .78363 L p .896 g
F P
0 g
s
.75165 .78363 m .81907 .75262 L .78523 .79432 L p .896 g
F P
0 g
s
.5266 .62975 m .51075 .6099 L .53829 .58237 L p F P
s
.85376 .70345 m .81907 .75262 L .80357 .71545 L p .922 g
F P
0 g
s
.80357 .71545 m .83795 .66886 L .85376 .70345 L p .922 g
F P
0 g
s
.42918 .76886 m .44233 .79293 L .46736 .82145 L p .494 g
F P
0 g
s
.46736 .82145 m .48533 .8302 L .53536 .8504 L p .128 g
F P
0 g
s
.48533 .8302 m .46736 .82145 L .44233 .79293 L p .183 g
F P
0 g
s
.47635 .70251 m .4632 .71732 L .43682 .69987 L p .031 g
F P
0 g
s
.43682 .69987 m .45416 .66892 L .47635 .70251 L p .031 g
F P
0 g
s
.42774 .73554 m .43682 .69987 L .4632 .71732 L p .031 g
F P
0 g
s
.57596 .82941 m .60356 .85589 L .53536 .8504 L p .697 g
F P
0 g
s
.60356 .85589 m .57596 .82941 L .61432 .82359 L p .773 g
F P
0 g
s
.61432 .82359 m .67319 .84439 L .60356 .85589 L p .773 g
F P
0 g
s
.4632 .71732 m .45646 .73569 L .42774 .73554 L p .031 g
F P
0 g
s
.42918 .76886 m .42774 .73554 L .45646 .73569 L p .039 g
F P
0 g
s
.65559 .54206 m .59757 .58412 L .59153 .57425 L p .158 g
F P
0 g
s
.59757 .58412 m .65559 .54206 L .64843 .56292 L p .277 g
F P
0 g
s
.71043 .54461 m .64843 .56292 L .65559 .54206 L p .144 g
F P
0 g
s
.49341 .69457 m .47635 .70251 L .45416 .66892 L p .071 g
F P
0 g
s
.45416 .66892 m .47664 .64933 L .49341 .69457 L p .071 g
F P
0 g
s
.52174 .66427 m .5005 .64658 L .51075 .6099 L p .051 g
F P
0 g
s
.51075 .6099 m .5266 .62975 L .52174 .66427 L p .051 g
F P
0 g
s
.67319 .84439 m .61432 .82359 L .64359 .80846 L p .833 g
F P
0 g
s
.64359 .80846 m .72728 .81812 L .67319 .84439 L p .833 g
F P
0 g
s
.71043 .54461 m .76953 .55102 L .71516 .58124 L p .283 g
F P
0 g
s
.76953 .55102 m .81589 .57824 L .75085 .59541 L p .38 g
F P
0 g
s
.75085 .59541 m .71516 .58124 L .76953 .55102 L p .38 g
F P
0 g
s
.81589 .57824 m .84088 .62015 L .76974 .62325 L p .552 g
F P
0 g
s
.76974 .62325 m .75085 .59541 L .81589 .57824 L p .552 g
F P
0 g
s
.53828 .8246 m .53536 .8504 L .48533 .8302 L p .629 g
F P
0 g
s
.53536 .8504 m .53828 .8246 L .57596 .82941 L p .697 g
F P
0 g
s
.45646 .73569 m .45789 .75383 L .42918 .76886 L p .039 g
F P
0 g
s
.44233 .79293 m .42918 .76886 L .45789 .75383 L p .057 g
F P
0 g
s
.64843 .56292 m .71043 .54461 L .66962 .58418 L p .275 g
F P
0 g
s
.71516 .58124 m .66962 .58418 L .71043 .54461 L p .283 g
F P
0 g
s
.81907 .75262 m .75165 .78363 L .73835 .75091 L p .91 g
F P
0 g
s
.73835 .75091 m .80357 .71545 L .81907 .75262 L p .91 g
F P
0 g
s
.54639 .65271 m .55859 .58553 L .57731 .57535 L p .108 g
F P
0 g
s
.57731 .57535 m .55145 .64786 L .54639 .65271 L p .108 g
F P
0 g
s
.55145 .64786 m .57731 .57535 L .59153 .57425 L p .273 g
F P
0 g
s
.54139 .66386 m .5401 .6037 L .55859 .58553 L p .038 g
F P
0 g
s
.55859 .58553 m .54639 .65271 L .54139 .66386 L p .038 g
F P
0 g
s
.51138 .69598 m .49341 .69457 L .47664 .64933 L p .113 g
F P
0 g
s
.47664 .64933 m .5005 .64658 L .51138 .69598 L p .113 g
F P
0 g
s
.84088 .62015 m .83795 .66886 L .76672 .65954 L p .716 g
F P
0 g
s
.76672 .65954 m .76974 .62325 L .84088 .62015 L p .716 g
F P
0 g
s
.59153 .57425 m .55525 .64974 L .55145 .64786 L p .273 g
F P
0 g
s
.55525 .64974 m .59153 .57425 L .59757 .58412 L p .372 g
F P
0 g
s
.72728 .81812 m .64359 .80846 L .65597 .78789 L p .858 g
F P
0 g
s
.65597 .78789 m .75165 .78363 L .72728 .81812 L p .858 g
F P
0 g
s
.53521 .95837 m .53293 1.0647 L .62675 1.09259 L p .674 g
F P
0 g
s
.62675 1.09259 m .60515 .97602 L .53521 .95837 L p .674 g
F P
0 g
s
.63965 1.19836 m .62675 1.09259 L .53293 1.0647 L p .642 g
F P
0 g
s
.60515 .97602 m .62675 1.09259 L .72308 1.08554 L p .63 g
F P
0 g
s
.62675 1.09259 m .63965 1.19836 L .7509 1.19317 L p .584 g
F P
0 g
s
.7509 1.19317 m .72308 1.08554 L .62675 1.09259 L p .584 g
F P
0 g
s
.53778 .68086 m .5266 .62975 L .5401 .6037 L p .045 g
F P
0 g
s
.5401 .6037 m .54139 .66386 L .53778 .68086 L p .045 g
F P
0 g
s
.53293 1.0647 m .53158 1.16044 L .63965 1.19836 L p .642 g
F P
0 g
s
.64311 1.28061 m .63965 1.19836 L .53158 1.16044 L p .602 g
F P
0 g
s
.63965 1.19836 m .64311 1.28061 L .75848 1.27855 L p .521 g
F P
0 g
s
.75848 1.27855 m .7509 1.19317 L .63965 1.19836 L p .521 g
F P
0 g
s
.44233 .79293 m .46697 .80183 L .48533 .8302 L p .183 g
F P
0 g
s
.51095 .81063 m .48533 .8302 L .46697 .80183 L p .575 g
F P
0 g
s
.48533 .8302 m .51095 .81063 L .53828 .8246 L p .629 g
F P
0 g
s
.48425 .91893 m .4644 1.00552 L .53293 1.0647 L p .731 g
F P
0 g
s
.53293 1.0647 m .53521 .95837 L .48425 .91893 L p .731 g
F P
0 g
s
.53158 1.16044 m .53293 1.0647 L .4644 1.00552 L p .715 g
F P
0 g
s
.64843 .56292 m .59367 .60708 L .59757 .58412 L p .277 g
F P
0 g
s
.59367 .60708 m .64843 .56292 L .62213 .60561 L p .323 g
F P
0 g
s
.66962 .58418 m .62213 .60561 L .64843 .56292 L p .275 g
F P
0 g
s
.45789 .75383 m .46821 .76802 L .44233 .79293 L p .057 g
F P
0 g
s
.46697 .80183 m .44233 .79293 L .46821 .76802 L p .251 g
F P
0 g
s
.72308 1.08554 m .67671 .96901 L .60515 .97602 L p .63 g
F P
0 g
s
.67671 .96901 m .72308 1.08554 L .79852 1.04556 L p .591 g
F P
0 g
s
.72308 1.08554 m .7509 1.19317 L .8385 1.14672 L p .523 g
F P
0 g
s
.8385 1.14672 m .79852 1.04556 L .72308 1.08554 L p .523 g
F P
0 g
s
.83795 .66886 m .80357 .71545 L .73946 .69782 L p .806 g
F P
0 g
s
.73946 .69782 m .76672 .65954 L .83795 .66886 L p .806 g
F P
0 g
s
.4644 1.00552 m .4527 1.08369 L .53158 1.16044 L p .715 g
F P
0 g
s
.53124 1.23398 m .53158 1.16044 L .4527 1.08369 L p .694 g
F P
0 g
s
.53158 1.16044 m .53124 1.23398 L .64311 1.28061 L p .602 g
F P
0 g
s
.59757 .58412 m .5568 .65873 L .55525 .64974 L p .372 g
F P
0 g
s
.5568 .65873 m .59757 .58412 L .59367 .60708 L p .404 g
F P
0 g
s
.53826 .85318 m .53521 .95837 L .60515 .97602 L p .704 g
F P
0 g
s
.60515 .97602 m .57619 .86124 L .53826 .85318 L p .704 g
F P
0 g
s
.57619 .86124 m .60515 .97602 L .67671 .96901 L p .674 g
F P
0 g
s
.52716 .70796 m .51138 .69598 L .5005 .64658 L p .184 g
F P
0 g
s
.5005 .64658 m .52174 .66427 L .52716 .70796 L p .184 g
F P
0 g
s
.7509 1.19317 m .75848 1.27855 L .84929 1.22927 L p .416 g
F P
0 g
s
.84929 1.22927 m .8385 1.14672 L .7509 1.19317 L p .416 g
F P
0 g
s
.53652 .70321 m .52174 .66427 L .5266 .62975 L p .097 g
F P
0 g
s
.5266 .62975 m .53778 .68086 L .53652 .70321 L p .097 g
F P
0 g
s
.51079 .83404 m .48425 .91893 L .53521 .95837 L p .745 g
F P
0 g
s
.53521 .95837 m .53826 .85318 L .51079 .83404 L p .745 g
F P
0 g
s
.67671 .96901 m .61484 .85658 L .57619 .86124 L p .674 g
F P
0 g
s
.61484 .85658 m .67671 .96901 L .73213 .93923 L p .65 g
F P
0 g
s
.79852 1.04556 m .73213 .93923 L .67671 .96901 L p .591 g
F P
0 g
s
.63718 1.32709 m .64311 1.28061 L .53124 1.23398 L p .52 g
F P
0 g
s
.64311 1.28061 m .63718 1.32709 L .7458 1.32861 L p .385 g
F P
0 g
s
.7458 1.32861 m .75848 1.27855 L .64311 1.28061 L p .385 g
F P
0 g
s
.46594 .86511 m .43948 .92459 L .4644 1.00552 L p .825 g
F P
0 g
s
.4644 1.00552 m .48425 .91893 L .46594 .86511 L p .825 g
F P
0 g
s
.4527 1.08369 m .4644 1.00552 L .43948 .92459 L p .831 g
F P
0 g
s
.42418 .44901 m .35321 .38289 L .36913 .47855 L p .61 g
F P
0 g
s
.36913 .47855 m .43365 .52182 L .42418 .44901 L p .61 g
F P
0 g
s
.30653 .46124 m .36913 .47855 L .35321 .38289 L p .663 g
F P
0 g
s
.43365 .52182 m .36913 .47855 L .4139 .57977 L p .568 g
F P
0 g
s
.36913 .47855 m .30653 .46124 L .36818 .57525 L p .61 g
F P
0 g
s
.36818 .57525 m .4139 .57977 L .36913 .47855 L p .61 g
F P
0 g
s
.75165 .78363 m .65597 .78789 L .64772 .76756 L p .848 g
F P
0 g
s
.64772 .76756 m .73835 .75091 L .75165 .78363 L p .848 g
F P
0 g
s
.49091 .50582 m .43565 .39359 L .42418 .44901 L p .585 g
F P
0 g
s
.42418 .44901 m .48523 .54004 L .49091 .50582 L p .585 g
F P
0 g
s
.35321 .38289 m .42418 .44901 L .43565 .39359 L p .639 g
F P
0 g
s
.48523 .54004 m .42418 .44901 L .43365 .52182 L p .562 g
F P
0 g
s
.4527 1.08369 m .44985 1.14348 L .53124 1.23398 L p .694 g
F P
0 g
s
.53188 1.27441 m .53124 1.23398 L .44985 1.14348 L p .626 g
F P
0 g
s
.53124 1.23398 m .53188 1.27441 L .63718 1.32709 L p .52 g
F P
0 g
s
.66962 .58418 m .71516 .58124 L .63142 .65125 L p .341 g
F P
0 g
s
.71516 .58124 m .75085 .59541 L .64984 .65588 L p .408 g
F P
0 g
s
.64984 .65588 m .63142 .65125 L .71516 .58124 L p .408 g
F P
0 g
s
.43948 .92459 m .42401 .97898 L .4527 1.08369 L p .831 g
F P
0 g
s
.44985 1.14348 m .4527 1.08369 L .42401 .97898 L p .8 g
F P
0 g
s
.43365 .52182 m .48967 .58759 L .48523 .54004 L p .562 g
F P
0 g
s
.48967 .58759 m .43365 .52182 L .46151 .60286 L p .526 g
F P
0 g
s
.4139 .57977 m .46151 .60286 L .43365 .52182 L p .568 g
F P
0 g
s
.62213 .60561 m .66962 .58418 L .60775 .65674 L p .318 g
F P
0 g
s
.63142 .65125 m .60775 .65674 L .66962 .58418 L p .341 g
F P
0 g
s
.43565 .39359 m .37079 .30633 L .35321 .38289 L p .639 g
F P
0 g
s
.28348 .34813 m .35321 .38289 L .37079 .30633 L p .706 g
F P
0 g
s
.35321 .38289 m .28348 .34813 L .30653 .46124 L p .663 g
F P
0 g
s
.25665 .47055 m .30653 .46124 L .28348 .34813 L p .724 g
F P
0 g
s
.30653 .46124 m .25665 .47055 L .33231 .58822 L p .649 g
F P
0 g
s
.33231 .58822 m .36818 .57525 L .30653 .46124 L p .649 g
F P
0 g
s
.59367 .60708 m .55566 .67495 L .5568 .65873 L p .404 g
F P
0 g
s
.55566 .67495 m .59367 .60708 L .58061 .64463 L p .404 g
F P
0 g
s
.62213 .60561 m .58061 .64463 L .59367 .60708 L p .323 g
F P
0 g
s
.4139 .57977 m .36818 .57525 L .45323 .67741 L p .544 g
F P
0 g
s
.36818 .57525 m .33231 .58822 L .43522 .6873 L p .571 g
F P
0 g
s
.43522 .6873 m .45323 .67741 L .36818 .57525 L p .571 g
F P
0 g
s
.50527 .48946 m .46535 .36436 L .43565 .39359 L p .588 g
F P
0 g
s
.43565 .39359 m .49091 .50582 L .50527 .48946 L p .588 g
F P
0 g
s
.37079 .30633 m .43565 .39359 L .46535 .36436 L p .646 g
F P
0 g
s
.80357 .71545 m .73835 .75091 L .68911 .73122 L p .83 g
F P
0 g
s
.68911 .73122 m .73946 .69782 L .80357 .71545 L p .83 g
F P
0 g
s
.46151 .60286 m .4139 .57977 L .47648 .67599 L p .512 g
F P
0 g
s
.45323 .67741 m .47648 .67599 L .4139 .57977 L p .544 g
F P
0 g
s
.75085 .59541 m .76974 .62325 L .65933 .66934 L p .503 g
F P
0 g
s
.65933 .66934 m .64984 .65588 L .75085 .59541 L p .503 g
F P
0 g
s
.73213 .93923 m .79852 1.04556 L .83292 .98046 L p .549 g
F P
0 g
s
.79852 1.04556 m .8385 1.14672 L .87891 1.06724 L p .434 g
F P
0 g
s
.87891 1.06724 m .83292 .98046 L .79852 1.04556 L p .434 g
F P
0 g
s
.54187 .76069 m .57596 .82941 L .53828 .8246 L closepath p .759 g
F P
0 g
s
.54187 .76069 m .61432 .82359 L .57596 .82941 L closepath p .768 g
F P
0 g
s
.46697 .80183 m .50131 .79148 L .51095 .81063 L p .575 g
F P
0 g
s
.50117 .80811 m .46594 .86511 L .48425 .91893 L p .813 g
F P
0 g
s
.48425 .91893 m .51079 .83404 L .50117 .80811 L p .813 g
F P
0 g
s
.4632 .71732 m .47635 .70251 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.45646 .73569 m .4632 .71732 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.46821 .76802 m .48696 .77508 L .46697 .80183 L p .251 g
F P
0 g
s
.50131 .79148 m .46697 .80183 L .48696 .77508 L p .514 g
F P
0 g
s
.5322 .62579 m .50527 .48946 L .49091 .50582 L p .54 g
F P
0 g
s
.49091 .50582 m .52839 .63216 L .5322 .62579 L p .54 g
F P
0 g
s
.52839 .63216 m .49091 .50582 L .48523 .54004 L p .546 g
F P
0 g
s
.54187 .76069 m .64359 .80846 L .61432 .82359 L closepath p .774 g
F P
0 g
s
.47635 .70251 m .49341 .69457 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.31331 .6155 m .33231 .58822 L .25665 .47055 L p .682 g
F P
0 g
s
.33231 .58822 m .31331 .6155 L .42597 .7033 L p .587 g
F P
0 g
s
.42597 .7033 m .43522 .6873 L .33231 .58822 L p .587 g
F P
0 g
s
.45789 .75383 m .45646 .73569 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.48523 .54004 m .52687 .64738 L .52839 .63216 L p .546 g
F P
0 g
s
.52687 .64738 m .48523 .54004 L .48967 .58759 L p .528 g
F P
0 g
s
.73213 .93923 m .64429 .84043 L .61484 .85658 L p .65 g
F P
0 g
s
.64429 .84043 m .73213 .93923 L .75665 .89313 L p .631 g
F P
0 g
s
.83292 .98046 m .75665 .89313 L .73213 .93923 L p .549 g
F P
0 g
s
.54187 .76069 m .53828 .8246 L .51095 .81063 L closepath p .748 g
F P
0 g
s
.58061 .64463 m .62213 .60561 L .58309 .67232 L p .335 g
F P
0 g
s
.60775 .65674 m .58309 .67232 L .62213 .60561 L p .318 g
F P
0 g
s
.75848 1.27855 m .7458 1.32861 L .83083 1.27999 L p .122 g
F P
0 g
s
.83083 1.27999 m .84929 1.22927 L .75848 1.27855 L p .122 g
F P
0 g
s
.52456 .49385 m .50562 .36747 L .46535 .36436 L p .56 g
F P
0 g
s
.46535 .36436 m .50527 .48946 L .52456 .49385 L p .56 g
F P
0 g
s
.41816 .26281 m .46535 .36436 L .50562 .36747 L p .616 g
F P
0 g
s
.46535 .36436 m .41816 .26281 L .37079 .30633 L p .646 g
F P
0 g
s
.5373 .62915 m .52456 .49385 L .50527 .48946 L p .49 g
F P
0 g
s
.50527 .48946 m .5322 .62579 L .5373 .62915 L p .49 g
F P
0 g
s
.46151 .60286 m .5031 .64333 L .48967 .58759 L p .526 g
F P
0 g
s
.5031 .64333 m .46151 .60286 L .50084 .68433 L p .478 g
F P
0 g
s
.47648 .67599 m .50084 .68433 L .46151 .60286 L p .512 g
F P
0 g
s
.52174 .66427 m .535 .71804 L .53309 .72011 L .223 g
F
.53799 .73018 m .53642 .72695 L p .535 .71804 L F P
0 g
s
.53642 .72695 m .53309 .72011 L p .535 .71804 L .223 g
F P
0 g
s
.52174 .66427 m .53652 .70321 L .53799 .73018 L p .223 g
F P
0 g
s
.52716 .70796 m .53799 .73018 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.53309 .72011 m .52716 .70796 L .5251 .69135 L p .223 g
F P
0 g
s
.5251 .69135 m .52174 .66427 L p .53309 .72011 L .223 g
F P
0 g
s
.51138 .69598 m .52716 .70796 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.52213 .70238 m .53668 .72873 L .53163 .69776 L p .453 g
F P
0 g
s
.54187 .76069 m .53668 .72873 L .52213 .70238 L closepath p .479 g
F P
0 g
s
.53163 .69776 m .53668 .72873 L .53797 .73668 L p .498 g
F P
0 g
s
.53797 .73668 m .54187 .76069 L .53834 .73904 L p .498 g
F P
0 g
s
.53834 .73904 m .53163 .69776 L p .53797 .73668 L .498 g
F P
0 g
s
.52805 .66992 m .53163 .69776 L .53834 .73904 L p .047 g
F P
0 g
s
.53834 .73904 m .54187 .76069 L .53885 .74085 L p .047 g
F P
0 g
s
.53885 .74085 m .52805 .66992 L p .53834 .73904 L .047 g
F P
0 g
s
.30627 .25348 m .37079 .30633 L .41816 .26281 L p .722 g
F P
0 g
s
.37079 .30633 m .30627 .25348 L .28348 .34813 L p .706 g
F P
0 g
s
.76974 .62325 m .76672 .65954 L .65731 .6891 L p .601 g
F P
0 g
s
.65731 .6891 m .65933 .66934 L .76974 .62325 L p .601 g
F P
0 g
s
.48967 .58759 m .52805 .66992 L .52687 .64738 L p .528 g
F P
0 g
s
.52805 .66992 m .48967 .58759 L .5031 .64333 L p .496 g
F P
0 g
s
.28348 .34813 m .22701 .34835 L .25665 .47055 L p .724 g
F P
0 g
s
.22947 .50407 m .25665 .47055 L .22701 .34835 L p .794 g
F P
0 g
s
.25665 .47055 m .22947 .50407 L .31331 .6155 L p .682 g
F P
0 g
s
.54235 .64219 m .54369 .51949 L .52456 .49385 L p .396 g
F P
0 g
s
.52456 .49385 m .5373 .62915 L .54235 .64219 L p .396 g
F P
0 g
s
.50562 .36747 m .52456 .49385 L .54369 .51949 L p .496 g
F P
0 g
s
.22701 .34835 m .28348 .34813 L .30627 .25348 L p .8 g
F P
0 g
s
.8385 1.14672 m .84929 1.22927 L .8909 1.14092 L p .19 g
F P
0 g
s
.8909 1.14092 m .87891 1.06724 L .8385 1.14672 L p .19 g
F P
0 g
s
.49341 .69457 m .51138 .69598 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.55145 .64786 m .54187 .76069 L .54639 .65271 L closepath p .403 g
F P
0 g
s
.55525 .64974 m .54187 .76069 L .55145 .64786 L closepath p .312 g
F P
0 g
s
.57619 .86124 m .54187 .76069 L .53826 .85318 L closepath p .724 g
F P
0 g
s
.61484 .85658 m .54187 .76069 L .57619 .86124 L closepath p .717 g
F P
0 g
s
.46821 .76802 m .45789 .75383 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.42401 .97898 m .42057 1.02087 L .44985 1.14348 L p .8 g
F P
0 g
s
.4557 1.17589 m .44985 1.14348 L .42057 1.02087 L p .515 g
F P
0 g
s
.44985 1.14348 m .4557 1.17589 L .53188 1.27441 L p .626 g
F P
0 g
s
.54639 .65271 m .54187 .76069 L .54139 .66386 L closepath p .47 g
F P
0 g
s
.54369 .51949 m .54568 .40448 L .50562 .36747 L p .496 g
F P
0 g
s
.48316 .26271 m .50562 .36747 L .54568 .40448 L p .54 g
F P
0 g
s
.50562 .36747 m .48316 .26271 L .41816 .26281 L p .616 g
F P
0 g
s
.5568 .65873 m .54187 .76069 L .55525 .64974 L closepath p .17 g
F P
0 g
s
.31634 .652 m .31331 .6155 L .22947 .50407 L p .681 g
F P
0 g
s
.31331 .6155 m .31634 .652 L .42793 .72223 L p .58 g
F P
0 g
s
.42793 .72223 m .42597 .7033 L .31331 .6155 L p .58 g
F P
0 g
s
.54187 .76069 m .65597 .78789 L .64359 .80846 L closepath p .778 g
F P
0 g
s
.64429 .84043 m .54187 .76069 L .61484 .85658 L closepath p .711 g
F P
0 g
s
.53826 .85318 m .54187 .76069 L .51079 .83404 L closepath p .731 g
F P
0 g
s
.54598 .66395 m .55752 .56417 L .54369 .51949 L p .308 g
F P
0 g
s
.54369 .51949 m .54235 .64219 L .54598 .66395 L p .308 g
F P
0 g
s
.54568 .40448 m .54369 .51949 L .55752 .56417 L p .414 g
F P
0 g
s
.54139 .66386 m .54187 .76069 L .53778 .68086 L closepath p .526 g
F P
0 g
s
.54187 .76069 m .51095 .81063 L .50131 .79148 L closepath p .738 g
F P
0 g
s
.54187 .76069 m .47648 .67599 L .45323 .67741 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .45323 .67741 L .43522 .6873 L closepath p .479 g
F P
0 g
s
.55752 .56417 m .57464 .47158 L .54568 .40448 L p .414 g
F P
0 g
s
.54804 .30909 m .54568 .40448 L .57464 .47158 L p .44 g
F P
0 g
s
.54568 .40448 m .54804 .30909 L .48316 .26271 L p .54 g
F P
0 g
s
.48657 .8081 m .46711 .83694 L .43948 .92459 L p .86 g
F P
0 g
s
.46711 .83694 m .45587 .86399 L .44731 .89486 L p F P
s
.43948 .92459 m .46453 .86828 L p .45844 .87768 L .86 g
F P
0 g
s
.43948 .92459 m .46711 .83694 L p .43037 .95802 L F P
s
.42401 .97898 m .42706 .96825 L p .43037 .95802 L F P
s
.42706 .96825 m .43948 .92459 L p .43037 .95802 L F P
s
.45149 .88841 m .46711 .83694 L .44731 .89486 L F
.45587 .86399 m .45365 .88527 L .4529 .88835 L p .03 g
F P
0 g
s
.4529 .88835 m .42057 1.02087 L p .44464 .9139 L .03 g
F P
0 g
s
.44731 .89486 m .42401 .97898 L p .45149 .88841 L F P
s
.44464 .9139 m .45587 .86399 L .4529 .88835 L .03 g
F
.46594 .86511 m .48657 .8081 L p .45844 .87768 L .86 g
F P
0 g
s
.46453 .86828 m .46594 .86511 L p .45844 .87768 L .86 g
F P
0 g
s
.58061 .64463 m .5521 .6981 L .55566 .67495 L p .404 g
F P
0 g
s
.5521 .6981 m .58061 .64463 L .56165 .69666 L p .386 g
F P
0 g
s
.58309 .67232 m .56165 .69666 L .58061 .64463 L p .335 g
F P
0 g
s
.55566 .67495 m .54187 .76069 L .5568 .65873 L closepath p .031 g
F P
0 g
s
.54187 .76069 m .43522 .6873 L .42597 .7033 L closepath p .479 g
F P
0 g
s
.5031 .64333 m .53163 .69776 L .52805 .66992 L p .496 g
F P
0 g
s
.53163 .69776 m .5031 .64333 L .52213 .70238 L p .453 g
F P
0 g
s
.50084 .68433 m .52213 .70238 L .5031 .64333 L p .478 g
F P
0 g
s
.76672 .65954 m .73946 .69782 L .6428 .71175 L p .681 g
F P
0 g
s
.6428 .71175 m .65731 .6891 L .76672 .65954 L p .681 g
F P
0 g
s
.3708 .19645 m .41816 .26281 L .48316 .26271 L p .678 g
F P
0 g
s
.41816 .26281 m .3708 .19645 L .30627 .25348 L p .722 g
F P
0 g
s
.54187 .76069 m .50084 .68433 L .47648 .67599 L closepath p .479 g
F P
0 g
s
.48696 .77508 m .46821 .76802 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.73835 .75091 m .64772 .76756 L .62054 .75359 L p .815 g
F P
0 g
s
.62054 .75359 m .68911 .73122 L .73835 .75091 L p .815 g
F P
0 g
s
.62293 1.3277 m .63718 1.32709 L .53188 1.27441 L p .154 g
F P
0 g
s
.63718 1.32709 m .62293 1.3277 L .7152 1.33241 L p .037 g
F P
0 g
s
.7152 1.33241 m .7458 1.32861 L .63718 1.32709 L p .037 g
F P
0 g
s
.53339 1.27309 m .53188 1.27441 L .4557 1.17589 L p .057 g
F P
0 g
s
.53188 1.27441 m .53339 1.27309 L .62293 1.3277 L p .154 g
F P
0 g
s
.54724 .69263 m .56232 .62336 L .55752 .56417 L p .277 g
F P
0 g
s
.55752 .56417 m .54598 .66395 L .54724 .69263 L p .277 g
F P
0 g
s
.57464 .47158 m .55752 .56417 L .56232 .62336 L p .352 g
F P
0 g
s
.42057 1.02087 m .42401 .97898 L .45587 .86399 L p .03 g
F P
0 g
s
.54187 .76069 m .50131 .79148 L .51244 .77285 L closepath p .728 g
F P
0 g
s
.51239 .7815 m .48657 .8081 L .46594 .86511 L p .936 g
F P
0 g
s
.46594 .86511 m .50117 .80811 L .51239 .7815 L p .936 g
F P
0 g
s
.53778 .68086 m .54187 .76069 L .53652 .70321 L closepath p .577 g
F P
0 g
s
.5322 .62579 m .54187 .76069 L .5373 .62915 L closepath p .484 g
F P
0 g
s
.53652 .70321 m .54187 .76069 L .53799 .73018 L closepath p .628 g
F P
0 g
s
.52839 .63216 m .54187 .76069 L .5322 .62579 L closepath p .42 g
F P
0 g
s
.52687 .64738 m .54187 .76069 L .52839 .63216 L closepath p .331 g
F P
0 g
s
.54187 .76069 m .42597 .7033 L .42793 .72223 L closepath p .479 g
F P
0 g
s
.51079 .83404 m .54187 .76069 L .50117 .80811 L closepath p .74 g
F P
0 g
s
.65668 .81667 m .54187 .76069 L .64429 .84043 L closepath p .708 g
F P
0 g
s
.75665 .89313 m .65668 .81667 L .64429 .84043 L p .631 g
F P
0 g
s
.56232 .62336 m .58462 .56047 L .57464 .47158 L p .352 g
F P
0 g
s
.59477 .39615 m .57464 .47158 L .58462 .56047 L p .364 g
F P
0 g
s
.57464 .47158 m .59477 .39615 L .54804 .30909 L p .44 g
F P
0 g
s
.22701 .34835 m .19549 .38335 L .22947 .50407 L p .794 g
F P
0 g
s
.23267 .55613 m .22947 .50407 L .19549 .38335 L p .722 g
F P
0 g
s
.22947 .50407 m .23267 .55613 L .31634 .652 L p .681 g
F P
0 g
s
.5373 .62915 m .54187 .76069 L .54235 .64219 L closepath p .536 g
F P
0 g
s
.34376 .69129 m .31634 .652 L .23267 .55613 L p .411 g
F P
0 g
s
.31634 .652 m .34376 .69129 L .4421 .74051 L p .497 g
F P
0 g
s
.4421 .74051 m .42793 .72223 L .31634 .652 L p .497 g
F P
0 g
s
.52805 .66992 m .54187 .76069 L .52687 .64738 L closepath p .186 g
F P
0 g
s
.54187 .76069 m .52213 .70238 L .50084 .68433 L closepath p .479 g
F P
0 g
s
.55566 .67495 m .5521 .6981 L .54539 .73916 L p F P
s
.54488 .74192 m .55566 .67495 L p .54539 .73916 L F P
s
.5521 .6981 m .54706 .72724 L .54577 .73557 L p .801 g
F P
0 g
s
.54539 .73916 m .54187 .76069 L .54488 .74192 L p F P
s
.54577 .73557 m .54187 .76069 L .54539 .73916 L p .801 g
F P
0 g
s
.54539 .73916 m .5521 .6981 L p .54577 .73557 L .801 g
F P
0 g
s
.56165 .69666 m .54706 .72724 L .5521 .6981 L p .386 g
F P
0 g
s
.56232 .62336 m .54876 .70713 L .55068 .71008 L .291 g
F
.54574 .72578 m .54733 .72075 L p .54876 .70713 L F P
0 g
s
.54733 .72075 m .55068 .71008 L p .54876 .70713 L .291 g
F P
0 g
s
.55068 .71008 m .55667 .69103 L .5588 .66546 L p .291 g
F P
0 g
s
.5588 .66546 m .56232 .62336 L p .55068 .71008 L .291 g
F P
0 g
s
.54187 .76069 m .64772 .76756 L .65597 .78789 L closepath p .779 g
F P
0 g
s
.65668 .81667 m .75665 .89313 L .74223 .84108 L p .615 g
F P
0 g
s
.75665 .89313 m .83292 .98046 L .81446 .9036 L p .483 g
F P
0 g
s
.81446 .9036 m .74223 .84108 L .75665 .89313 L p .483 g
F P
0 g
s
.54235 .64219 m .54187 .76069 L .54598 .66395 L closepath p .584 g
F P
0 g
s
.25329 .24208 m .30627 .25348 L .3708 .19645 L p .849 g
F P
0 g
s
.30627 .25348 m .25329 .24208 L .22701 .34835 L p .8 g
F P
0 g
s
.19549 .38335 m .22701 .34835 L .25329 .24208 L p .921 g
F P
0 g
s
.54187 .76069 m .42793 .72223 L .4421 .74051 L closepath p .479 g
F P
0 g
s
.83292 .98046 m .87891 1.06724 L .85784 .96973 L p .212 g
F P
0 g
s
.85784 .96973 m .81446 .9036 L .83292 .98046 L p .212 g
F P
0 g
s
.55667 .69103 m .57278 .66045 L .58462 .56047 L p .325 g
F P
0 g
s
.58462 .56047 m .56232 .62336 L .55667 .69103 L p .325 g
F P
0 g
s
.61061 .511 m .58462 .56047 L .57278 .66045 L p .33 g
F P
0 g
s
.58462 .56047 m .61061 .511 L .59477 .39615 L p .364 g
F P
0 g
s
.46056 .19198 m .48316 .26271 L .54804 .30909 L p .55 g
F P
0 g
s
.48316 .26271 m .46056 .19198 L .3708 .19645 L p .678 g
F P
0 g
s
.56232 .62336 m .54724 .69263 L .54574 .72578 L p .291 g
F P
0 g
s
.48696 .77508 m .51244 .77285 L .50131 .79148 L p .514 g
F P
0 g
s
.84929 1.22927 m .83083 1.27999 L .86891 1.18899 L p F P
s
.86891 1.18899 m .8909 1.14092 L .84929 1.22927 L p F P
s
.54187 .76069 m .58309 .67232 L .60775 .65674 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .60775 .65674 L .63142 .65125 L closepath p .479 g
F P
0 g
s
.42057 1.02087 m .42881 1.04375 L .4557 1.17589 L p .515 g
F P
0 g
s
.46903 1.17417 m .4557 1.17589 L .42881 1.04375 L p .1 g
F P
0 g
s
.4557 1.17589 m .46903 1.17417 L .53339 1.27309 L p .057 g
F P
0 g
s
.42881 1.04375 m .42057 1.02087 L .45365 .88527 L p .079 g
F P
0 g
s
.51244 .77285 m .48696 .77508 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54598 .66395 m .54187 .76069 L .54724 .69263 L closepath p .632 g
F P
0 g
s
.54187 .76069 m .63142 .65125 L .64984 .65588 L closepath p .479 g
F P
0 g
s
.73946 .69782 m .68911 .73122 L .61667 .7335 L p .736 g
F P
0 g
s
.61667 .7335 m .6428 .71175 L .73946 .69782 L p .736 g
F P
0 g
s
.54187 .76069 m .56165 .69666 L .58309 .67232 L closepath p .479 g
F P
0 g
s
.7458 1.32861 m .7152 1.33241 L .78672 1.28781 L p .845 g
F P
0 g
s
.78672 1.28781 m .83083 1.27999 L .7458 1.32861 L p .845 g
F P
0 g
s
.5504 .24482 m .54804 .30909 L .59477 .39615 L p .403 g
F P
0 g
s
.54804 .30909 m .5504 .24482 L .46056 .19198 L p .55 g
F P
0 g
s
.50117 .80811 m .54187 .76069 L .51239 .7815 L closepath p .749 g
F P
0 g
s
.61473 .34702 m .59477 .39615 L .61061 .511 L p .322 g
F P
0 g
s
.59477 .39615 m .61473 .34702 L .5504 .24482 L p .403 g
F P
0 g
s
.64826 .79117 m .54187 .76069 L .65668 .81667 L closepath p .706 g
F P
0 g
s
.74223 .84108 m .64826 .79117 L .65668 .81667 L p .615 g
F P
0 g
s
.54187 .76069 m .64984 .65588 L .65933 .66934 L closepath p .479 g
F P
0 g
s
.46771 .75468 m .4421 .74051 L .34376 .69129 L p .139 g
F P
0 g
s
.54187 .76069 m .4421 .74051 L .46771 .75468 L closepath p .479 g
F P
0 g
s
.57278 .66045 m .59142 .6376 L .61061 .511 L p .33 g
F P
0 g
s
.63605 .48087 m .61061 .511 L .59142 .6376 L p .308 g
F P
0 g
s
.61061 .511 m .63605 .48087 L .61473 .34702 L p .322 g
F P
0 g
s
.23267 .55613 m .26997 .61813 L .34376 .69129 L p .411 g
F P
0 g
s
.34376 .69129 m .39434 .72642 L .46771 .75468 L p .139 g
F P
0 g
s
.54187 .76069 m .46771 .75468 L .50228 .76196 L closepath p .479 g
F P
0 g
s
.50228 .76196 m .46771 .75468 L .39434 .72642 L p .6 g
F P
0 g
s
.39434 .72642 m .46311 .75106 L .50228 .76196 L p .6 g
F P
0 g
s
.43439 .72989 m .46311 .75106 L p .3696 .6969 L .614 g
F P
0 g
s
.34376 .69129 m .26997 .61813 L p .36735 .70292 L .358 g
F P
0 g
s
.39434 .72642 m .36594 .70669 L p .36735 .70292 L .358 g
F P
0 g
s
.36594 .70669 m .34376 .69129 L p .36735 .70292 L .358 g
F P
0 g
s
.26997 .61813 m .33969 .67957 L .39434 .72642 L p .358 g
F P
0 g
s
.33969 .67957 m .37005 .6957 L p .3696 .6969 L .614 g
F P
0 g
s
.37005 .6957 m .43439 .72989 L p .3696 .6969 L .614 g
F P
0 g
s
.54187 .76069 m .54706 .72724 L .56165 .69666 L closepath p .479 g
F P
0 g
s
.54724 .69263 m .54187 .76069 L .54574 .72578 L closepath p .683 g
F P
0 g
s
.57278 .66045 m .55667 .69103 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.59142 .6376 m .57278 .66045 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.19549 .38335 m .19825 .44816 L .23267 .55613 L p .722 g
F P
0 g
s
.26997 .61813 m .23267 .55613 L .19825 .44816 L p .152 g
F P
0 g
s
.54187 .76069 m .62054 .75359 L .64772 .76756 L closepath p .777 g
F P
0 g
s
.55667 .69103 m .54574 .72578 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .65933 .66934 L .65731 .6891 L closepath p .479 g
F P
0 g
s
.6094 .62511 m .59142 .6376 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.59142 .6376 m .6094 .62511 L .63605 .48087 L p .308 g
F P
0 g
s
.87891 1.06724 m .8909 1.14092 L .86849 1.02899 L p .521 g
F P
0 g
s
.86849 1.02899 m .85784 .96973 L .87891 1.06724 L p .521 g
F P
0 g
s
.46711 .83694 m .48657 .8081 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.45587 .86399 m .46711 .83694 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.48657 .8081 m .51239 .7815 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.68911 .73122 m .62054 .75359 L .58163 .75073 L p .766 g
F P
0 g
s
.58163 .75073 m .61667 .7335 L .68911 .73122 L p .766 g
F P
0 g
s
.45365 .88527 m .45587 .86399 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.33157 .17506 m .3708 .19645 L .46056 .19198 L p .723 g
F P
0 g
s
.3708 .19645 m .33157 .17506 L .25329 .24208 L p .849 g
F P
0 g
s
.45365 .88527 m .46007 .89735 L .42881 1.04375 L p .079 g
F P
0 g
s
.44684 1.04302 m .42881 1.04375 L .46007 .89735 L p .235 g
F P
0 g
s
.42881 1.04375 m .44684 1.04302 L .46903 1.17417 L p .1 g
F P
0 g
s
.46311 .75106 m .39434 .72642 L .33969 .67957 L p .614 g
F P
0 g
s
.62347 .62436 m .6094 .62511 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.6094 .62511 m .62347 .62436 L .65635 .47407 L p .25 g
F P
0 g
s
.65635 .47407 m .63605 .48087 L .6094 .62511 L p .25 g
F P
0 g
s
.54187 .76069 m .65731 .6891 L .6428 .71175 L closepath p .479 g
F P
0 g
s
.62083 .77034 m .54187 .76069 L .64826 .79117 L closepath p .706 g
F P
0 g
s
.64826 .79117 m .74223 .84108 L .69119 .79537 L p .591 g
F P
0 g
s
.69119 .79537 m .62083 .77034 L .64826 .79117 L p .591 g
F P
0 g
s
.74223 .84108 m .81446 .9036 L .74535 .83197 L p .305 g
F P
0 g
s
.74535 .83197 m .69119 .79537 L .74223 .84108 L p .305 g
F P
0 g
s
.63605 .48087 m .65635 .47407 L .63096 .33136 L p .173 g
F P
0 g
s
.63096 .33136 m .61473 .34702 L .63605 .48087 L p .173 g
F P
0 g
s
.25329 .24208 m .22319 .27496 L .19549 .38335 L p .921 g
F P
0 g
s
.19825 .44816 m .19549 .38335 L .22319 .27496 L p .04 g
F P
0 g
s
.46007 .89735 m .45365 .88527 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.53551 1.22601 m .53339 1.27309 L .46903 1.17417 L p .423 g
F P
0 g
s
.53339 1.27309 m .53551 1.22601 L .60277 1.2773 L p .56 g
F P
0 g
s
.60277 1.2773 m .62293 1.3277 L .53339 1.27309 L p .56 g
F P
0 g
s
.54187 .76069 m .50228 .76196 L .46311 .75106 L closepath p .708 g
F P
0 g
s
.54187 .76069 m .58163 .75073 L .62054 .75359 L closepath p .772 g
F P
0 g
s
.54187 .76069 m .6428 .71175 L .61667 .7335 L closepath p .479 g
F P
0 g
s
.62293 1.3277 m .60277 1.2773 L .67192 1.2841 L p .692 g
F P
0 g
s
.67192 1.2841 m .7152 1.33241 L .62293 1.3277 L p .692 g
F P
0 g
s
.5022 .77062 m .54187 .76069 L .46282 .76781 L closepath p .772 g
F P
0 g
s
.46717 .78784 m .5022 .77062 L .46282 .76781 L p .723 g
F P
0 g
s
.54187 .76069 m .5022 .77062 L .46717 .78784 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .46311 .75106 L .43439 .72989 L closepath p .706 g
F P
0 g
s
.19825 .44816 m .23989 .53266 L .26997 .61813 L p .152 g
F P
0 g
s
.33969 .67957 m .26997 .61813 L .23989 .53266 L p .489 g
F P
0 g
s
.63073 .63518 m .62347 .62436 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.62347 .62436 m .63073 .63518 L .66722 .4918 L p .13 g
F P
0 g
s
.66722 .4918 m .65635 .47407 L .62347 .62436 L p .13 g
F P
0 g
s
.22319 .27496 m .25329 .24208 L .33157 .17506 L p F P
s
.46282 .76781 m .39225 .79063 L .46717 .78784 L p .723 g
F P
0 g
s
.44058 .80979 m .46717 .78784 L .39225 .79063 L p .703 g
F P
0 g
s
.54187 .76069 m .46717 .78784 L .44058 .80979 L closepath p .479 g
F P
0 g
s
.48745 1.13564 m .46903 1.17417 L .44684 1.04302 L p .349 g
F P
0 g
s
.46903 1.17417 m .48745 1.13564 L .53551 1.22601 L p .423 g
F P
0 g
s
.62919 .6558 m .63073 .63518 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .44058 .80979 L .42515 .83306 L closepath p .479 g
F P
0 g
s
.58171 .75941 m .54187 .76069 L .62083 .77034 L closepath p .708 g
F P
0 g
s
.54187 .76069 m .55599 .89537 L .552 .90206 L closepath p .42 g
F P
0 g
s
.54187 .76069 m .55754 .87905 L .55599 .89537 L closepath p .331 g
F P
0 g
s
.54187 .76069 m .54739 .82004 L .5458 .79169 L closepath p .628 g
F P
0 g
s
.54187 .76069 m .552 .90206 L .54664 .8982 L closepath p .484 g
F P
0 g
s
.54187 .76069 m .54615 .84428 L .54739 .82004 L closepath p .577 g
F P
0 g
s
.54187 .76069 m .54664 .8982 L .54137 .88397 L closepath p .536 g
F P
0 g
s
.54187 .76069 m .54237 .86319 L .54615 .84428 L closepath p .526 g
F P
0 g
s
.54187 .76069 m .54137 .88397 L .53761 .86063 L closepath p .584 g
F P
0 g
s
.52544 .9669 m .53761 .86063 L .54137 .88397 L p .544 g
F P
0 g
s
.54187 .76069 m .53705 .87572 L .54237 .86319 L closepath p .47 g
F P
0 g
s
.54187 .76069 m .53637 .83037 L .53794 .79603 L closepath p .683 g
F P
0 g
s
.54187 .76069 m .53761 .86063 L .53637 .83037 L closepath p .632 g
F P
0 g
s
.53265 .83091 m .52948 .83138 L .53592 .80446 L .459 g
F
.53291 .81212 m .53794 .79603 L p .52948 .83138 L F P
0 g
s
.53794 .79603 m .52676 .83177 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.51025 .86319 m .49135 .88617 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.52676 .83177 m .51025 .86319 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .52159 .82633 L .5366 .7946 L closepath p .479 g
F P
0 g
s
.52676 .83177 m .53291 .81212 L p .52948 .83138 L .459 g
F P
0 g
s
.49135 .88617 m .51025 .86319 L .49752 .9684 L p .382 g
F P
0 g
s
.51025 .86319 m .52676 .83177 L .52066 .90306 L p .419 g
F P
0 g
s
.53637 .83037 m .52066 .90306 L .52448 .85845 L p .459 g
F P
0 g
s
.52448 .85845 m .52676 .83177 L p .52948 .83138 L .459 g
F P
0 g
s
.53637 .83037 m .52448 .85845 L .52948 .83138 L .459 g
F
.53134 .82505 m .5366 .7946 L p .53598 .79614 L .073 g
F P
0 g
s
.52066 .90306 m .49752 .9684 L .51025 .86319 L p .419 g
F P
0 g
s
.50102 .88305 m .53134 .82505 L p .53598 .79614 L .073 g
F P
0 g
s
.52159 .82633 m .50102 .88305 L p .53598 .79614 L .073 g
F P
0 g
s
.5366 .7946 m .53602 .79582 L p .53598 .79614 L .073 g
F P
0 g
s
.53602 .79582 m .52159 .82633 L p .53598 .79614 L .073 g
F P
0 g
s
.5366 .7946 m .53134 .82505 L .5397 .7739 L p .801 g
F P
0 g
s
.53386 .81047 m .53526 .80175 L p .53134 .82505 L F P
s
.53134 .82505 m .52749 .85005 L .53386 .81047 L p F P
s
.53526 .80175 m .53728 .78919 L p .53547 .80011 L F P
s
.53547 .80011 m .53134 .82505 L .53526 .80175 L F
.53728 .78919 m .54008 .77179 L p .53677 .79194 L F P
s
.53677 .79194 m .53134 .82505 L .53728 .78919 L F
.5397 .7739 m .54187 .76069 L .53927 .7774 L p .801 g
F P
0 g
s
.53927 .7774 m .5366 .7946 L p .5397 .7739 L .801 g
F P
0 g
s
.53794 .79603 m .53637 .83037 L p .53265 .83091 L .459 g
F P
0 g
s
.53265 .83091 m .53592 .80446 L .53794 .79603 L .459 g
F
.54008 .77179 m .54187 .76069 L .5397 .7739 L p 0 g
F P
s
.5397 .7739 m .53134 .82505 L p .54008 .77179 L F P
s
.52066 .90306 m .53637 .83037 L .53761 .86063 L p .524 g
F P
0 g
s
.53761 .86063 m .52544 .9669 L .52066 .90306 L p .524 g
F P
0 g
s
.54187 .76069 m .53164 .88104 L .53705 .87572 L closepath p .403 g
F P
0 g
s
.54187 .76069 m .52764 .87859 L .53164 .88104 L closepath p .312 g
F P
0 g
s
.54187 .76069 m .52612 .86817 L .52764 .87859 L closepath p .17 g
F P
0 g
s
.54187 .76069 m .52749 .85005 L .52612 .86817 L closepath p .031 g
F P
0 g
s
.54187 .76069 m .55621 .85491 L .55754 .87905 L closepath p .186 g
F P
0 g
s
.56219 .82073 m .58269 .8843 L p .54776 .79472 L .376 g
F P
0 g
s
.54847 .80403 m .54365 .77242 L p .54807 .79878 L .047 g
F P
0 g
s
.54365 .77242 m .54187 .76069 L .54403 .77397 L p .047 g
F P
0 g
s
.54403 .77397 m .54807 .79878 L p .54365 .77242 L .047 g
F P
0 g
s
.55239 .82538 m .55621 .85491 L .54847 .80403 L p .047 g
F P
0 g
s
.54807 .79878 m .55239 .82538 L p .54847 .80403 L .047 g
F P
0 g
s
.54713 .79313 m .55239 .82538 L .54403 .77397 L p .498 g
F P
0 g
s
.54403 .77397 m .54187 .76069 L .54446 .77667 L p .498 g
F P
0 g
s
.54446 .77667 m .54713 .79313 L p .54403 .77397 L .498 g
F P
0 g
s
.5458 .79169 m .54739 .82004 L p .55113 .81818 L .316 g
F P
0 g
s
.58269 .8843 m .55239 .82538 L .54713 .79313 L p .376 g
F P
0 g
s
.55113 .81818 m .55433 .8166 L .54783 .79761 L .316 g
F
.55113 .81818 m .54783 .79761 L .5458 .79169 L F
.55708 .81524 m .55086 .80226 L p .55433 .8166 L F P
0 g
s
.55086 .80226 m .5458 .79169 L p .55433 .8166 L .316 g
F P
0 g
s
.54713 .79313 m .54771 .79419 L p .54776 .79472 L .376 g
F P
0 g
s
.54771 .79419 m .56219 .82073 L p .54776 .79472 L .376 g
F P
0 g
s
.54187 .76069 m .61667 .7335 L .58163 .75073 L closepath p .479 g
F P
0 g
s
.61721 .76679 m .58171 .75941 L .62083 .77034 L p .475 g
F P
0 g
s
.54187 .76069 m .58171 .75941 L .61721 .76679 L closepath p .479 g
F P
0 g
s
.62083 .77034 m .69119 .79537 L .61721 .76679 L p .475 g
F P
0 g
s
.54187 .76069 m .61721 .76679 L .64435 .78141 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .64435 .78141 L .66018 .80062 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .66018 .80062 L .66331 .82081 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .66331 .82081 L .65425 .83801 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .65425 .83801 L .63538 .84855 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .63538 .84855 L .6106 .84971 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .6106 .84971 L .58464 .84028 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .58464 .84028 L .56219 .82073 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .56219 .82073 L .54713 .79313 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .42515 .83306 L .4221 .85382 L closepath p .479 g
F P
0 g
s
.61808 .68295 m .62919 .6558 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.59818 .7124 m .61808 .68295 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.57169 .73963 m .59818 .7124 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .58375 .71188 L .57169 .73963 L closepath p .749 g
F P
0 g
s
.59818 .7124 m .57169 .73963 L .58375 .71188 L p .874 g
F P
0 g
s
.58391 .72876 m .54187 .76069 L .57174 .74833 L closepath p .728 g
F P
0 g
s
.54187 .76069 m .4221 .85382 L .43092 .86837 L closepath p .479 g
F P
0 g
s
.47351 .89791 m .46007 .89735 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .43439 .72989 L .42378 .7031 L closepath p .706 g
F P
0 g
s
.46282 .76781 m .54187 .76069 L .43382 .75367 L closepath p .777 g
F P
0 g
s
.54187 .76069 m .43092 .86837 L .44935 .87375 L closepath p .479 g
F P
0 g
s
.49135 .88617 m .47351 .89791 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .49931 .85191 L .52159 .82633 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .44935 .87375 L .47367 .86828 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .47367 .86828 L .49931 .85191 L closepath p .479 g
F P
0 g
s
.54187 .76069 m .57441 .68385 L .58375 .71188 L closepath p .74 g
F P
0 g
s
.57459 .70783 m .54187 .76069 L .58391 .72876 L closepath p .738 g
F P
0 g
s
.54187 .76069 m .42378 .7031 L .43459 .67717 L closepath p .708 g
F P
0 g
s
.43382 .75367 m .54187 .76069 L .42301 .73235 L closepath p .779 g
F P
0 g
s
.5986 .74582 m .57174 .74833 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.54187 .76069 m .54569 .66253 L .57441 .68385 L closepath p .731 g
F P
0 g
s
.54572 .69199 m .54187 .76069 L .57459 .70783 L closepath p .748 g
F P
0 g
s
.54187 .76069 m .43459 .67717 L .46442 .65891 L closepath p .711 g
F P
0 g
s
.43439 .72989 m .33969 .67957 L .3182 .62276 L p .623 g
F P
0 g
s
.3182 .62276 m .42378 .7031 L .43439 .72989 L p .623 g
F P
0 g
s
.42301 .73235 m .54187 .76069 L .43381 .70994 L closepath p .778 g
F P
0 g
s
.54187 .76069 m .46442 .65891 L .50526 .65345 L closepath p .717 g
F P
0 g
s
.54187 .76069 m .50526 .65345 L .54569 .66253 L closepath p .724 g
F P
0 g
s
.50499 .68635 m .54187 .76069 L .54572 .69199 L closepath p .759 g
F P
0 g
s
.43381 .70994 m .54187 .76069 L .46383 .69293 L closepath p .774 g
F P
0 g
s
.46383 .69293 m .54187 .76069 L .50499 .68635 L closepath p .768 g
F P
0 g
s
.61927 .75298 m .5986 .74582 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.5458 .79169 m .55708 .81524 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.64435 .78141 m .61721 .76679 L .69119 .79537 L p .196 g
F P
0 g
s
.63138 .768 m .61927 .75298 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.55708 .81524 m .57395 .82878 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.63378 .78759 m .63138 .768 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.57395 .82878 m .59358 .83124 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.62684 .80752 m .63378 .78759 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.59358 .83124 m .61242 .82334 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.61242 .82334 m .62684 .80752 L .54187 .76069 L closepath p .323 g
F P
0 g
s
.61473 .34702 m .63096 .33136 L .55235 .22147 L p .191 g
F P
0 g
s
.5504 .24482 m .61473 .34702 L p .56318 .24327 L .191 g
F P
0 g
s
.63993 .35274 m .63096 .33136 L .65635 .47407 L p .038 g
F P
0 g
s
.63993 .35274 m .55345 .24486 L p .60776 .30547 L .52 g
F P
0 g
s
.63096 .33136 m .63751 .34698 L p .60776 .30547 L .52 g
F P
0 g
s
.63751 .34698 m .63993 .35274 L p .60776 .30547 L .52 g
F P
0 g
s
.55235 .22147 m .55185 .22746 L p .56318 .24327 L .191 g
F P
0 g
s
.55185 .22746 m .5504 .24482 L p .56318 .24327 L .191 g
F P
0 g
s
.83083 1.27999 m .78672 1.28781 L .81764 1.20101 L p .872 g
F P
0 g
s
.81764 1.20101 m .86891 1.18899 L .83083 1.27999 L p .872 g
F P
0 g
s
.46007 .89735 m .47351 .89791 L .44684 1.04302 L p .235 g
F P
0 g
s
.81446 .9036 m .85784 .96973 L .77753 .87426 L p .384 g
F P
0 g
s
.77753 .87426 m .74535 .83197 L .81446 .9036 L p .384 g
F P
0 g
s
.46056 .19198 m .5504 .24482 L p .45235 .17375 L .367 g
F P
0 g
s
.5504 .24482 m .55235 .22147 L .44181 .16611 L p .367 g
F P
0 g
s
.55345 .24486 m .43108 .19177 L p .52871 .21568 L .415 g
F P
0 g
s
.55235 .22147 m .5527 .22885 L p .52871 .21568 L .415 g
F P
0 g
s
.5527 .22885 m .55345 .24486 L p .52871 .21568 L .415 g
F P
0 g
s
.44181 .16611 m .44404 .16918 L p .45235 .17375 L .367 g
F P
0 g
s
.44404 .16918 m .46056 .19198 L p .45235 .17375 L .367 g
F P
0 g
s
.46056 .19198 m .44181 .16611 L .33157 .17506 L p .723 g
F P
0 g
s
.39225 .79063 m .33784 .8256 L .44058 .80979 L p .703 g
F P
0 g
s
.42515 .83306 m .44058 .80979 L .33784 .8256 L p .663 g
F P
0 g
s
.39225 .79063 m .46282 .76781 L .43382 .75367 L p .786 g
F P
0 g
s
.63073 .63518 m .62919 .6558 L .66548 .53173 L p .036 g
F P
0 g
s
.66548 .53173 m .66722 .4918 L .63073 .63518 L p .036 g
F P
0 g
s
.8909 1.14092 m .86891 1.18899 L .84665 1.07072 L p .841 g
F P
0 g
s
.84665 1.07072 m .86849 1.02899 L .8909 1.14092 L p .841 g
F P
0 g
s
.47126 1.01714 m .44684 1.04302 L .47351 .89791 L p .327 g
F P
0 g
s
.44684 1.04302 m .47126 1.01714 L .48745 1.13564 L p .349 g
F P
0 g
s
.23989 .53266 m .3182 .62276 L .33969 .67957 L p .489 g
F P
0 g
s
.33784 .8256 m .30547 .86702 L .42515 .83306 L p .663 g
F P
0 g
s
.4221 .85382 m .42515 .83306 L .30547 .86702 L p .601 g
F P
0 g
s
.47351 .89791 m .49135 .88617 L .47126 1.01714 L p .327 g
F P
0 g
s
.69119 .79537 m .74535 .83197 L .64435 .78141 L p .196 g
F P
0 g
s
.65635 .47407 m .66722 .4918 L .63993 .35274 L p .038 g
F P
0 g
s
.7152 1.33241 m .67192 1.2841 L .72486 1.24669 L p .743 g
F P
0 g
s
.72486 1.24669 m .78672 1.28781 L .7152 1.33241 L p .743 g
F P
0 g
s
.64984 .58785 m .66548 .53173 L .62919 .6558 L p F P
s
.62919 .6558 m .61808 .68295 L .64984 .58785 L p F P
s
.57174 .74833 m .5986 .74582 L .6226 .71634 L p .441 g
F P
0 g
s
.6226 .71634 m .58391 .72876 L .57174 .74833 L p .441 g
F P
0 g
s
.43382 .75367 m .33558 .77095 L .39225 .79063 L p .786 g
F P
0 g
s
.33784 .8256 m .39225 .79063 L .33558 .77095 L p .795 g
F P
0 g
s
.61808 .68295 m .59818 .7124 L .62144 .65125 L p .923 g
F P
0 g
s
.58375 .71188 m .62144 .65125 L .59818 .7124 L p .874 g
F P
0 g
s
.62144 .65125 m .64984 .58785 L .61808 .68295 L p .923 g
F P
0 g
s
.22319 .27496 m .22529 .34871 L .19825 .44816 L p .04 g
F P
0 g
s
.23989 .53266 m .19825 .44816 L .22529 .34871 L p .392 g
F P
0 g
s
.49752 .9684 m .47126 1.01714 L .49135 .88617 L p .382 g
F P
0 g
s
.30547 .86702 m .29822 .90763 L .4221 .85382 L p .601 g
F P
0 g
s
.43092 .86837 m .4221 .85382 L .29822 .90763 L p .512 g
F P
0 g
s
.33558 .77095 m .43382 .75367 L .42301 .73235 L p .832 g
F P
0 g
s
.85784 .96973 m .86849 1.02899 L .78474 .91497 L p .673 g
F P
0 g
s
.78474 .91497 m .77753 .87426 L .85784 .96973 L p .673 g
F P
0 g
s
.4556 .92735 m .50102 .88305 L .52159 .82633 L p .12 g
F P
0 g
s
.52159 .82633 m .49931 .85191 L .4556 .92735 L p .12 g
F P
0 g
s
.74535 .83197 m .77753 .87426 L .66018 .80062 L p .491 g
F P
0 g
s
.66018 .80062 m .64435 .78141 L .74535 .83197 L p .491 g
F P
0 g
s
.47126 1.01714 m .49752 .9684 L .50755 1.06339 L p .448 g
F P
0 g
s
.50755 1.06339 m .48745 1.13564 L .47126 1.01714 L p .448 g
F P
0 g
s
.29822 .90763 m .31556 .93966 L .43092 .86837 L p .512 g
F P
0 g
s
.44935 .87375 m .43092 .86837 L .31556 .93966 L p .402 g
F P
0 g
s
.59765 .94568 m .55621 .85491 L .55239 .82538 L p .413 g
F P
0 g
s
.55239 .82538 m .58269 .8843 L .59765 .94568 L p .413 g
F P
0 g
s
.48564 .9274 m .52749 .85005 L .53134 .82505 L p .071 g
F P
0 g
s
.53134 .82505 m .50102 .88305 L .48564 .9274 L p .071 g
F P
0 g
s
.33714 .56857 m .43459 .67717 L .42378 .7031 L p .636 g
F P
0 g
s
.42378 .7031 m .3182 .62276 L .33714 .56857 L p .636 g
F P
0 g
s
.48745 1.13564 m .50755 1.06339 L .53784 1.13644 L p .52 g
F P
0 g
s
.53784 1.13644 m .53551 1.22601 L .48745 1.13564 L p .52 g
F P
0 g
s
.62144 .65125 m .58375 .71188 L .57441 .68385 L p .776 g
F P
0 g
s
.62803 .92993 m .58269 .8843 L .56219 .82073 L p .469 g
F P
0 g
s
.56219 .82073 m .58464 .84028 L .62803 .92993 L p .469 g
F P
0 g
s
.53551 1.22601 m .53784 1.13644 L .58042 1.17892 L p .584 g
F P
0 g
s
.58042 1.17892 m .60277 1.2773 L .53551 1.22601 L p .584 g
F P
0 g
s
.30908 .20416 m .33157 .17506 L .44181 .16611 L p .144 g
F P
0 g
s
.33157 .17506 m .30908 .20416 L .22319 .27496 L p F P
s
.40303 .95251 m .4556 .92735 L .49931 .85191 L p .189 g
F P
0 g
s
.49931 .85191 m .47367 .86828 L .40303 .95251 L p .189 g
F P
0 g
s
.33558 .77095 m .2582 .80972 L .33784 .8256 L p .795 g
F P
0 g
s
.30547 .86702 m .33784 .8256 L .2582 .80972 L p .776 g
F P
0 g
s
.54739 .82004 m .56343 .86396 L .55708 .81524 L p .316 g
F P
0 g
s
.60282 .99815 m .55754 .87905 L .55621 .85491 L p .449 g
F P
0 g
s
.55621 .85491 m .59765 .94568 L .60282 .99815 L p .449 g
F P
0 g
s
.56343 .86396 m .54739 .82004 L .54615 .84428 L p .31 g
F P
0 g
s
.31556 .93966 m .35309 .95617 L .44935 .87375 L p .402 g
F P
0 g
s
.47367 .86828 m .44935 .87375 L .35309 .95617 L p .288 g
F P
0 g
s
.5986 .74582 m .61927 .75298 L .6532 .72462 L p .258 g
F P
0 g
s
.6532 .72462 m .6226 .71634 L .5986 .74582 L p .258 g
F P
0 g
s
.66722 .4918 m .66548 .53173 L .63887 .40932 L p .769 g
F P
0 g
s
.63887 .40932 m .63993 .35274 L .66722 .4918 L p .769 g
F P
0 g
s
.55345 .24486 m .55235 .22147 L .63096 .33136 L p .52 g
F P
0 g
s
.57395 .82878 m .55708 .81524 L .56343 .86396 L p .2 g
F P
0 g
s
.35309 .95617 m .40303 .95251 L .47367 .86828 L p .288 g
F P
0 g
s
.22529 .34871 m .22319 .27496 L .30908 .20416 L p .313 g
F P
0 g
s
.58391 .72876 m .6226 .71634 L .60541 .68254 L p .514 g
F P
0 g
s
.60541 .68254 m .57459 .70783 L .58391 .72876 L p .514 g
F P
0 g
s
.49752 .9684 m .52066 .90306 L .52544 .9669 L p .491 g
F P
0 g
s
.60277 1.2773 m .58042 1.17892 L .62404 1.18633 L p .626 g
F P
0 g
s
.62404 1.18633 m .67192 1.2841 L .60277 1.2773 L p .626 g
F P
0 g
s
.52544 .9669 m .50755 1.06339 L .49752 .9684 L p .491 g
F P
0 g
s
.22529 .34871 m .26411 .45238 L .23989 .53266 L p .392 g
F P
0 g
s
.3182 .62276 m .23989 .53266 L .26411 .45238 L p .547 g
F P
0 g
s
.66331 .82081 m .66018 .80062 L .77753 .87426 L p .575 g
F P
0 g
s
.86891 1.18899 m .81764 1.20101 L .79746 1.08591 L p .761 g
F P
0 g
s
.79746 1.08591 m .84665 1.07072 L .86891 1.18899 L p .761 g
F P
0 g
s
.78672 1.28781 m .72486 1.24669 L .74683 1.17114 L p .725 g
F P
0 g
s
.74683 1.17114 m .81764 1.20101 L .78672 1.28781 L p .725 g
F P
0 g
s
.54137 .88397 m .53994 1.01619 L .52544 .9669 L p .544 g
F P
0 g
s
.53994 1.01619 m .54137 .88397 L .54664 .8982 L p .542 g
F P
0 g
s
.26411 .45238 m .33714 .56857 L .3182 .62276 L p .547 g
F P
0 g
s
.31251 .7356 m .42301 .73235 L .43381 .70994 L p .855 g
F P
0 g
s
.42301 .73235 m .31251 .7356 L .33558 .77095 L p .832 g
F P
0 g
s
.47979 .95745 m .52612 .86817 L .52749 .85005 L p .093 g
F P
0 g
s
.52749 .85005 m .48564 .9274 L .47979 .95745 L p .093 g
F P
0 g
s
.68045 .95661 m .62803 .92993 L .58464 .84028 L p .522 g
F P
0 g
s
.58464 .84028 m .6106 .84971 L .68045 .95661 L p .522 g
F P
0 g
s
.59676 1.03524 m .55599 .89537 L .55754 .87905 L p .48 g
F P
0 g
s
.55754 .87905 m .60282 .99815 L .59676 1.03524 L p .48 g
F P
0 g
s
.77753 .87426 m .78474 .91497 L .66331 .82081 L p .575 g
F P
0 g
s
.54664 .8982 m .56034 1.04553 L .53994 1.01619 L p .542 g
F P
0 g
s
.56034 1.04553 m .54664 .8982 L .552 .90206 L p .528 g
F P
0 g
s
.86849 1.02899 m .84665 1.07072 L .7675 .94639 L p .697 g
F P
0 g
s
.7675 .94639 m .78474 .91497 L .86849 1.02899 L p .697 g
F P
0 g
s
.50755 1.06339 m .52544 .9669 L .53994 1.01619 L p .539 g
F P
0 g
s
.53994 1.01619 m .53784 1.13644 L .50755 1.06339 L p .539 g
F P
0 g
s
.55599 .89537 m .59676 1.03524 L .58116 1.05192 L p .507 g
F P
0 g
s
.54615 .84428 m .55874 .90543 L .56343 .86396 L p .31 g
F P
0 g
s
.58116 1.05192 m .552 .90206 L .55599 .89537 L p .507 g
F P
0 g
s
.55874 .90543 m .54615 .84428 L .54237 .86319 L p .296 g
F P
0 g
s
.39317 .53096 m .46442 .65891 L .43459 .67717 L p .652 g
F P
0 g
s
.43459 .67717 m .33714 .56857 L .39317 .53096 L p .652 g
F P
0 g
s
.57441 .68385 m .6041 .58975 L .62144 .65125 L p .776 g
F P
0 g
s
.6041 .58975 m .57441 .68385 L .54569 .66253 L p .729 g
F P
0 g
s
.65425 .83801 m .66331 .82081 L .78474 .91497 L p .592 g
F P
0 g
s
.552 .90206 m .58116 1.05192 L .56034 1.04553 L p .528 g
F P
0 g
s
.64984 .58785 m .62144 .65125 L .6041 .58975 L p .805 g
F P
0 g
s
.66548 .53173 m .64984 .58785 L .6266 .49288 L p .83 g
F P
0 g
s
.6266 .49288 m .63887 .40932 L .66548 .53173 L p .83 g
F P
0 g
s
.43108 .19177 m .44181 .16611 L .55235 .22147 L p .415 g
F P
0 g
s
.44181 .16611 m .43108 .19177 L .30908 .20416 L p .144 g
F P
0 g
s
.2582 .80972 m .33558 .77095 L .31251 .7356 L p .88 g
F P
0 g
s
.61927 .75298 m .63138 .768 L .67173 .75127 L p .086 g
F P
0 g
s
.67173 .75127 m .6532 .72462 L .61927 .75298 L p .086 g
F P
0 g
s
.73018 .96174 m .68045 .95661 L .6106 .84971 L p .559 g
F P
0 g
s
.6106 .84971 m .63538 .84855 L .73018 .96174 L p .559 g
F P
0 g
s
.67192 1.2841 m .62404 1.18633 L .65702 1.15868 L p .641 g
F P
0 g
s
.65702 1.15868 m .72486 1.24669 L .67192 1.2841 L p .641 g
F P
0 g
s
.2582 .80972 m .21091 .86333 L .30547 .86702 L p .776 g
F P
0 g
s
.29822 .90763 m .30547 .86702 L .21091 .86333 L p .71 g
F P
0 g
s
.59358 .83124 m .57395 .82878 L .58782 .88745 L p .106 g
F P
0 g
s
.56343 .86396 m .58782 .88745 L .57395 .82878 L p .2 g
F P
0 g
s
.65958 1.02053 m .59765 .94568 L .58269 .8843 L p .51 g
F P
0 g
s
.58269 .8843 m .62803 .92993 L .65958 1.02053 L p .51 g
F P
0 g
s
.78474 .91497 m .7675 .94639 L .65425 .83801 L p .592 g
F P
0 g
s
.63538 .84855 m .65425 .83801 L .7675 .94639 L p .583 g
F P
0 g
s
.4854 .97265 m .52764 .87859 L .52612 .86817 L p .122 g
F P
0 g
s
.52612 .86817 m .47979 .95745 L .4854 .97265 L p .122 g
F P
0 g
s
.42213 .98291 m .48564 .9274 L .50102 .88305 L p .096 g
F P
0 g
s
.50102 .88305 m .4556 .92735 L .42213 .98291 L p .096 g
F P
0 g
s
.6041 .58975 m .6266 .49288 L .64984 .58785 L p .805 g
F P
0 g
s
.53784 1.13644 m .53994 1.01619 L .56034 1.04553 L p .565 g
F P
0 g
s
.56034 1.04553 m .58042 1.17892 L .53784 1.13644 L p .565 g
F P
0 g
s
.7675 .94639 m .73018 .96174 L .63538 .84855 L p .583 g
F P
0 g
s
.54569 .66253 m .54922 .54229 L .6041 .58975 L p .729 g
F P
0 g
s
.57459 .70783 m .60541 .68254 L .54941 .65662 L p .588 g
F P
0 g
s
.54941 .65662 m .54572 .69199 L .57459 .70783 L p .588 g
F P
0 g
s
.54237 .86319 m .54386 .93843 L .55874 .90543 L p .296 g
F P
0 g
s
.54386 .93843 m .54237 .86319 L .53705 .87572 L p .271 g
F P
0 g
s
.54922 .54229 m .54569 .66253 L .50526 .65345 L p .697 g
F P
0 g
s
.47141 .52095 m .50526 .65345 L .46442 .65891 L p .672 g
F P
0 g
s
.46442 .65891 m .39317 .53096 L .47141 .52095 L p .672 g
F P
0 g
s
.33121 .69543 m .43381 .70994 L .46383 .69293 L p .838 g
F P
0 g
s
.43381 .70994 m .33121 .69543 L .31251 .7356 L p .855 g
F P
0 g
s
.50115 .97361 m .53164 .88104 L .52764 .87859 L p .181 g
F P
0 g
s
.52764 .87859 m .4854 .97265 L .50115 .97361 L p .181 g
F P
0 g
s
.58042 1.17892 m .56034 1.04553 L .58116 1.05192 L p .574 g
F P
0 g
s
.58116 1.05192 m .62404 1.18633 L .58042 1.17892 L p .574 g
F P
0 g
s
.53705 .87572 m .52268 .96167 L .54386 .93843 L p .271 g
F P
0 g
s
.52268 .96167 m .53705 .87572 L .53164 .88104 L p .233 g
F P
0 g
s
.63993 .35274 m .63887 .40932 L .55335 .31397 L p .697 g
F P
0 g
s
.55335 .31397 m .55345 .24486 L .63993 .35274 L p .697 g
F P
0 g
s
.63138 .768 m .63378 .78759 L .67516 .79017 L p .045 g
F P
0 g
s
.67512 .78982 m .63138 .768 L .67516 .79017 L .045 g
F
.67592 .79022 m .67173 .75127 L .63138 .768 L p F P
0 g
s
.65001 .78057 m .6461 .7238 L .67123 .75074 L p .67 g
F P
0 g
s
.67123 .75074 m .67173 .75127 L p .67134 .7518 L .67 g
F P
0 g
s
.65001 .78057 m .67123 .75074 L .67134 .7518 L .67 g
F
.67516 .79017 m .67592 .79022 L p .67512 .78982 L .045 g
F P
0 g
s
.50526 .65345 m .47141 .52095 L .54922 .54229 L p .697 g
F P
0 g
s
.53164 .88104 m .50115 .97361 L .52268 .96167 L p .233 g
F P
0 g
s
.61242 .82334 m .59358 .83124 L .61662 .88831 L p .065 g
F P
0 g
s
.58782 .88745 m .61662 .88831 L .59358 .83124 L p .106 g
F P
0 g
s
.30908 .20416 m .31051 .28202 L .22529 .34871 L p .313 g
F P
0 g
s
.26411 .45238 m .22529 .34871 L .31051 .28202 L p .502 g
F P
0 g
s
.81764 1.20101 m .74683 1.17114 L .73075 1.06918 L p .68 g
F P
0 g
s
.73075 1.06918 m .79746 1.08591 L .81764 1.20101 L p .68 g
F P
0 g
s
.84665 1.07072 m .79746 1.08591 L .73018 .96174 L p .667 g
F P
0 g
s
.73018 .96174 m .7675 .94639 L .84665 1.07072 L p .667 g
F P
0 g
s
.67019 1.10054 m .60282 .99815 L .59765 .94568 L p .539 g
F P
0 g
s
.59765 .94568 m .65958 1.02053 L .67019 1.10054 L p .539 g
F P
0 g
s
.21091 .86333 m .19921 .92174 L .29822 .90763 L p .71 g
F P
0 g
s
.31556 .93966 m .29822 .90763 L .19921 .92174 L p .578 g
F P
0 g
s
.72486 1.24669 m .65702 1.15868 L .67019 1.10054 L p .633 g
F P
0 g
s
.67019 1.10054 m .74683 1.17114 L .72486 1.24669 L p .633 g
F P
0 g
s
.58782 .88745 m .56343 .86396 L .55874 .90543 L p .101 g
F P
0 g
s
.73075 1.06918 m .65958 1.02053 L .62803 .92993 L p .573 g
F P
0 g
s
.62803 .92993 m .68045 .95661 L .73075 1.06918 L p .573 g
F P
0 g
s
.62404 1.18633 m .58116 1.05192 L .59676 1.03524 L p .571 g
F P
0 g
s
.59676 1.03524 m .65702 1.15868 L .62404 1.18633 L p .571 g
F P
0 g
s
.31051 .28202 m .30908 .20416 L .43108 .19177 L p .479 g
F P
0 g
s
.34773 1.00954 m .42213 .98291 L .4556 .92735 L p .121 g
F P
0 g
s
.4556 .92735 m .40303 .95251 L .34773 1.00954 L p .121 g
F P
0 g
s
.54572 .69199 m .54941 .65662 L .46933 .64875 L p .679 g
F P
0 g
s
.50499 .68635 m .54572 .69199 L p .47582 .65243 L .679 g
F P
0 g
s
.47262 .65223 m .50499 .68635 L p .47582 .65243 L .679 g
F P
0 g
s
.50499 .68635 m .46933 .64875 L .38865 .66303 L p .774 g
F P
0 g
s
.55248 .66044 m .43945 .65463 L p .54001 .65645 L .065 g
F P
0 g
s
.54941 .65662 m .54977 .65706 L p .54001 .65645 L .065 g
F P
0 g
s
.54977 .65706 m .55248 .66044 L p .54001 .65645 L .065 g
F P
0 g
s
.46933 .64875 m .47262 .65223 L p .47582 .65243 L .679 g
F P
0 g
s
.33927 .3975 m .39317 .53096 L .33714 .56857 L p .589 g
F P
0 g
s
.33714 .56857 m .26411 .45238 L .33927 .3975 L p .589 g
F P
0 g
s
.65702 1.15868 m .59676 1.03524 L .60282 .99815 L p .559 g
F P
0 g
s
.60282 .99815 m .67019 1.10054 L .65702 1.15868 L p .559 g
F P
0 g
s
.63378 .78759 m .62684 .80752 L .66593 .83251 L p .034 g
F P
0 g
s
.66593 .83251 m .67592 .79022 L .63378 .78759 L p .034 g
F P
0 g
s
.62684 .80752 m .61242 .82334 L .64455 .86813 L p .032 g
F P
0 g
s
.61662 .88831 m .64455 .86813 L .61242 .82334 L p .065 g
F P
0 g
s
.38865 .66303 m .46383 .69293 L .50499 .68635 L p .774 g
F P
0 g
s
.46383 .69293 m .38865 .66303 L .33121 .69543 L p .838 g
F P
0 g
s
.6226 .71634 m .6532 .72462 L .63045 .68843 L p .204 g
F P
0 g
s
.63045 .68843 m .60541 .68254 L .6226 .71634 L p .204 g
F P
0 g
s
.64455 .86813 m .66593 .83251 L .62684 .80752 L p .032 g
F P
0 g
s
.6266 .49288 m .6041 .58975 L .54922 .54229 L p .723 g
F P
0 g
s
.31051 .28202 m .33927 .3975 L .26411 .45238 L p .502 g
F P
0 g
s
.19921 .92174 m .22317 .97288 L .31556 .93966 L p .578 g
F P
0 g
s
.35309 .95617 m .31556 .93966 L .22317 .97288 L p .39 g
F P
0 g
s
.79746 1.08591 m .73075 1.06918 L .68045 .95661 L p .624 g
F P
0 g
s
.68045 .95661 m .73018 .96174 L .79746 1.08591 L p .624 g
F P
0 g
s
.31251 .7356 m .22339 .76995 L .2582 .80972 L p .88 g
F P
0 g
s
.21091 .86333 m .2582 .80972 L .22339 .76995 L p .897 g
F P
0 g
s
.40847 1.01711 m .47979 .95745 L .48564 .9274 L p .078 g
F P
0 g
s
.48564 .9274 m .42213 .98291 L .40847 1.01711 L p .078 g
F P
0 g
s
.74683 1.17114 m .67019 1.10054 L .65958 1.02053 L p .609 g
F P
0 g
s
.65958 1.02053 m .73075 1.06918 L .74683 1.17114 L p .609 g
F P
0 g
s
.27656 1.00503 m .34773 1.00954 L .40303 .95251 L p .205 g
F P
0 g
s
.40303 .95251 m .35309 .95617 L .27656 1.00503 L p .205 g
F P
0 g
s
.63887 .40932 m .6266 .49288 L .5519 .41901 L p .716 g
F P
0 g
s
.5519 .41901 m .55335 .31397 L .63887 .40932 L p .716 g
F P
0 g
s
.22317 .97288 m .27656 1.00503 L .35309 .95617 L p .39 g
F P
0 g
s
.55345 .24486 m .55335 .31397 L .43183 .26815 L p .589 g
F P
0 g
s
.43183 .26815 m .43108 .19177 L .55345 .24486 L p .589 g
F P
0 g
s
.22339 .76995 m .31251 .7356 L .33121 .69543 L p .918 g
F P
0 g
s
.54922 .54229 m .5519 .41901 L .6266 .49288 L p .723 g
F P
0 g
s
.43108 .19177 m .43183 .26815 L .31051 .28202 L p .479 g
F P
0 g
s
.44565 .38449 m .47141 .52095 L .39317 .53096 L p .628 g
F P
0 g
s
.39317 .53096 m .33927 .3975 L .44565 .38449 L p .628 g
F P
0 g
s
.5519 .41901 m .54922 .54229 L .47141 .52095 L p .67 g
F P
0 g
s
.55874 .90543 m .5782 .93675 L .58782 .88745 L p .101 g
F P
0 g
s
.5782 .93675 m .55874 .90543 L .54386 .93843 L p .061 g
F P
0 g
s
.33927 .3975 m .31051 .28202 L .43183 .26815 L p .574 g
F P
0 g
s
.61662 .88831 m .58782 .88745 L .5782 .93675 L p F P
s
.47141 .52095 m .44565 .38449 L .5519 .41901 L p .67 g
F P
0 g
s
.41954 1.03077 m .4854 .97265 L .47979 .95745 L p .068 g
F P
0 g
s
.47979 .95745 m .40847 1.01711 L .41954 1.03077 L p .068 g
F P
0 g
s
.55335 .31397 m .5519 .41901 L .44565 .38449 L p .639 g
F P
0 g
s
.44565 .38449 m .43183 .26815 L .55335 .31397 L p .639 g
F P
0 g
s
.22339 .76995 m .16748 .82939 L .21091 .86333 L p .897 g
F P
0 g
s
.19921 .92174 m .21091 .86333 L .16748 .82939 L p .823 g
F P
0 g
s
.43183 .26815 m .44565 .38449 L .33927 .3975 L p .574 g
F P
0 g
s
.6532 .72462 m .67173 .75127 L .6461 .7238 L p .381 g
F P
0 g
s
.6461 .7238 m .63045 .68843 L .6532 .72462 L p .381 g
F P
0 g
s
.32367 1.03923 m .40847 1.01711 L .42213 .98291 L p .081 g
F P
0 g
s
.42213 .98291 m .34773 1.00954 L .32367 1.03923 L p .081 g
F P
0 g
s
.55248 .66044 m .54941 .65662 L .60541 .68254 L p .102 g
F P
0 g
s
.60541 .68254 m .63045 .68843 L .55248 .66044 L p .102 g
F P
0 g
s
.54386 .93843 m .5462 .97693 L .5782 .93675 L p .061 g
F P
0 g
s
.5462 .97693 m .54386 .93843 L .52268 .96167 L p .055 g
F P
0 g
s
.24667 .71989 m .33121 .69543 L .38865 .66303 L p .786 g
F P
0 g
s
.33121 .69543 m .24667 .71989 L .22339 .76995 L p .918 g
F P
0 g
s
.45321 1.02642 m .50115 .97361 L .4854 .97265 L p .063 g
F P
0 g
s
.4854 .97265 m .41954 1.03077 L .45321 1.02642 L p .063 g
F P
0 g
s
.16748 .82939 m .15263 .90212 L .19921 .92174 L p .823 g
F P
0 g
s
.22317 .97288 m .19921 .92174 L .15263 .90212 L p .562 g
F P
0 g
s
.64455 .86813 m .61662 .88831 L .60154 .93462 L p F P
s
.5782 .93675 m .60154 .93462 L .61662 .88831 L p F P
s
.52268 .96167 m .50007 1.00745 L .5462 .97693 L p .055 g
F P
0 g
s
.50007 1.00745 m .52268 .96167 L .50115 .97361 L p .057 g
F P
0 g
s
.50115 .97361 m .45321 1.02642 L .50007 1.00745 L p .057 g
F P
0 g
s
.16748 .82939 m .22339 .76995 L .24667 .71989 L p .864 g
F P
0 g
s
.24158 1.02213 m .32367 1.03923 L .34773 1.00954 L p .114 g
F P
0 g
s
.40847 1.01711 m .32367 1.03923 L .34009 1.04473 L p .02 g
F P
0 g
s
.34009 1.04473 m .32367 1.03923 L p .30281 1.03058 L .496 g
F P
0 g
s
.34773 1.00954 m .27656 1.00503 L .2583 1.01396 L p .114 g
F P
0 g
s
.34773 1.00954 m .2583 1.01396 L .27088 1.01865 L .114 g
F
.26217 1.01372 m .33067 1.04098 L p .30281 1.03058 L .496 g
F P
0 g
s
.33067 1.04098 m .34009 1.04473 L p .30281 1.03058 L .496 g
F P
0 g
s
.2583 1.01396 m .24158 1.02213 L p .27088 1.01865 L .114 g
F P
0 g
s
.67173 .75127 m .67592 .79022 L .65001 .78057 L p .67 g
F P
0 g
s
.43945 .65463 m .46933 .64875 L .54941 .65662 L p .065 g
F P
0 g
s
.15263 .90212 m .17978 .97201 L .22317 .97288 L p .562 g
F P
0 g
s
.27656 1.00503 m .22317 .97288 L .18838 .97218 L p .218 g
F P
0 g
s
.27656 1.00503 m .18838 .97218 L .19482 .97714 L .218 g
F
.17978 .97201 m .24158 1.02213 L .27656 1.00503 L p F P
0 g
s
.2031 .94666 m .26217 1.01372 L .24919 1.01902 L p .387 g
F P
0 g
s
.24919 1.01902 m .24158 1.02213 L p .23405 1.00735 L .387 g
F P
0 g
s
.23405 1.00735 m .2031 .94666 L .24919 1.01902 L .387 g
F
.18838 .97218 m .17978 .97201 L p .19482 .97714 L .218 g
F P
0 g
s
.38865 .66303 m .32583 .67651 L .24667 .71989 L p .786 g
F P
0 g
s
.32583 .67651 m .38865 .66303 L .46933 .64875 L p F P
s
.60154 .93462 m .5782 .93675 L .5462 .97693 L p .685 g
F P
0 g
s
.60154 .93462 m .62445 .90115 L .64455 .86813 L p F P
s
.66593 .83251 m .64455 .86813 L .62445 .90115 L p .832 g
F P
0 g
s
.34009 1.04473 m .41954 1.03077 L .40847 1.01711 L p .02 g
F P
0 g
s
.67592 .79022 m .66593 .83251 L .64202 .84506 L p .811 g
F P
0 g
s
.64202 .84506 m .65001 .78057 L .67592 .79022 L p .811 g
F P
0 g
s
.46933 .64875 m .43945 .65463 L .32583 .67651 L p F P
s
.62445 .90115 m .64202 .84506 L .66593 .83251 L p .832 g
F P
0 g
s
.63045 .68843 m .6461 .7238 L .55444 .70279 L p .426 g
F P
0 g
s
.55444 .70279 m .55248 .66044 L .63045 .68843 L p .426 g
F P
0 g
s
.24667 .71989 m .1925 .77927 L .16748 .82939 L p .864 g
F P
0 g
s
.15263 .90212 m .16748 .82939 L .1925 .77927 L p F P
s
.5462 .97693 m .54903 .9734 L .60154 .93462 L p .685 g
F P
0 g
s
.54903 .9734 m .5462 .97693 L .50007 1.00745 L p .787 g
F P
0 g
s
.1925 .77927 m .24667 .71989 L .32583 .67651 L p F P
s
.3948 1.03162 m .45321 1.02642 L .41954 1.03077 L p .574 g
F P
0 g
s
.41954 1.03077 m .34009 1.04473 L .3948 1.03162 L p .574 g
F P
0 g
s
.32367 1.03923 m .24158 1.02213 L .26217 1.01372 L p .496 g
F P
0 g
s
.62445 .90115 m .60154 .93462 L .54903 .9734 L p .935 g
F P
0 g
s
.50007 1.00745 m .47244 1.00625 L .54903 .9734 L p .787 g
F P
0 g
s
.47244 1.00625 m .50007 1.00745 L .45321 1.02642 L p .732 g
F P
0 g
s
.45321 1.02642 m .3948 1.03162 L .47244 1.00625 L p .732 g
F P
0 g
s
.1925 .77927 m .17744 .86128 L .15263 .90212 L p F P
s
.17978 .97201 m .15263 .90212 L .17744 .86128 L p .093 g
F P
0 g
s
.6461 .7238 m .65001 .78057 L .55496 .77424 L p .657 g
F P
0 g
s
.55496 .77424 m .55444 .70279 L .6461 .7238 L p .657 g
F P
0 g
s
.55248 .66044 m .55444 .70279 L .42008 .7035 L p .311 g
F P
0 g
s
.42008 .7035 m .43945 .65463 L .55248 .66044 L p .311 g
F P
0 g
s
.24158 1.02213 m .17978 .97201 L .2031 .94666 L p .387 g
F P
0 g
s
.17744 .86128 m .2031 .94666 L .17978 .97201 L p .093 g
F P
0 g
s
.28508 .73157 m .32583 .67651 L .43945 .65463 L p .128 g
F P
0 g
s
.32583 .67651 m .28508 .73157 L .1925 .77927 L p F P
s
.64202 .84506 m .62445 .90115 L .55185 .92976 L p .873 g
F P
0 g
s
.54903 .9734 m .55185 .92976 L .62445 .90115 L p .935 g
F P
0 g
s
.43945 .65463 m .42008 .7035 L .28508 .73157 L p .128 g
F P
0 g
s
.65001 .78057 m .64202 .84506 L .554 .85709 L p .778 g
F P
0 g
s
.554 .85709 m .55496 .77424 L .65001 .78057 L p .778 g
F P
0 g
s
.17744 .86128 m .1925 .77927 L .28508 .73157 L p .166 g
F P
0 g
s
.33693 .98939 m .3948 1.03162 L .34009 1.04473 L p .73 g
F P
0 g
s
.34009 1.04473 m .26217 1.01372 L .33693 .98939 L p .73 g
F P
0 g
s
.55185 .92976 m .554 .85709 L .64202 .84506 L p .873 g
F P
0 g
s
.55185 .92976 m .54903 .9734 L .47244 1.00625 L p .875 g
F P
0 g
s
.55444 .70279 m .55496 .77424 L .41465 .78481 L p .541 g
F P
0 g
s
.41465 .78481 m .42008 .7035 L .55444 .70279 L p .541 g
F P
0 g
s
.44497 .95924 m .47244 1.00625 L .3948 1.03162 L p .809 g
F P
0 g
s
.3948 1.03162 m .33693 .98939 L .44497 .95924 L p .809 g
F P
0 g
s
.47244 1.00625 m .44497 .95924 L .55185 .92976 L p .875 g
F P
0 g
s
.28508 .73157 m .27355 .81659 L .17744 .86128 L p .166 g
F P
0 g
s
.2031 .94666 m .17744 .86128 L .27355 .81659 L p .43 g
F P
0 g
s
.29273 .91077 m .33693 .98939 L .26217 1.01372 L p .605 g
F P
0 g
s
.26217 1.01372 m .2031 .94666 L .29273 .91077 L p .605 g
F P
0 g
s
.27355 .81659 m .28508 .73157 L .42008 .7035 L p .406 g
F P
0 g
s
.554 .85709 m .55185 .92976 L .44497 .95924 L p .771 g
F P
0 g
s
.27355 .81659 m .29273 .91077 L .2031 .94666 L p .43 g
F P
0 g
s
.42008 .7035 m .41465 .78481 L .27355 .81659 L p .406 g
F P
0 g
s
.55496 .77424 m .554 .85709 L .42388 .87831 L p .667 g
F P
0 g
s
.42388 .87831 m .41465 .78481 L .55496 .77424 L p .667 g
F P
0 g
s
.44497 .95924 m .42388 .87831 L .554 .85709 L p .771 g
F P
0 g
s
.42388 .87831 m .44497 .95924 L .33693 .98939 L p .69 g
F P
0 g
s
.33693 .98939 m .29273 .91077 L .42388 .87831 L p .69 g
F P
0 g
s
.29273 .91077 m .27355 .81659 L .41465 .78481 L p .567 g
F P
0 g
s
.41465 .78481 m .42388 .87831 L .29273 .91077 L p .567 g
F P
0 g
s
.25 Mabswid
.52287 0 m
.93124 .57888 L
s
.93124 .57888 m
1 1.3537 L
s
1 1.3537 m
.51861 .85346 L
s
.51861 .85346 m
.52287 0 L
s
.09363 .18048 m
0 1.0137 L
s
0 1.0137 m
.51861 .85346 L
s
.51861 .85346 m
.52287 0 L
s
.52287 0 m
.09363 .18048 L
s
.09363 .18048 m
.52287 0 L
s
.09479 .17999 m
.10111 .1871 L
s
gsave
.08216 .16577 -80.415 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.19695 .13704 m
.20308 .14431 L
s
gsave
.1847 .1225 -79.9462 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.30205 .09285 m
.30798 .10028 L
s
gsave
.29019 .07798 -68.5819 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4102 .04737 m
.41592 .05497 L
s
gsave
.39878 .03217 -74.1916 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.52156 .00055 m
.52704 .00832 L
s
gsave
.51059 -0.01498 -73.8481 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.115 .1715 m
.11876 .17578 L
s
.13531 .16295 m
.13906 .16726 L
s
.15575 .15436 m
.15947 .15869 L
s
.17629 .14572 m
.17999 .15007 L
s
.21773 .1283 m
.22139 .13268 L
s
.23863 .11951 m
.24226 .12391 L
s
.25965 .11067 m
.26326 .1151 L
s
.28079 .10179 m
.28437 .10623 L
s
.32343 .08386 m
.32696 .08834 L
s
.34494 .07482 m
.34844 .07932 L
s
.36657 .06572 m
.37005 .07024 L
s
.38832 .05657 m
.39178 .06111 L
s
.43222 .03812 m
.43562 .0427 L
s
.45436 .02881 m
.45773 .03341 L
s
.47662 .01944 m
.47997 .02407 L
s
.49903 .01003 m
.50234 .01467 L
s
gsave
.23092 .00363 -68.1887 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.0253834 0.64881 0.508876 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
1.66533e-16 1.05015 -0.0697213 1.05015 [
[.5 .82045 -26.8438 0 ]
[.5 .82045 26.8438 12.0625 ]
[.03101 .24391 -13.9375 -9.68197 ]
[.03101 .24391 0 .31803 ]
[.17566 .18707 -20.2255 -10 ]
[.17566 .18707 .33704 0 ]
[.32887 .12688 -7.87434 -10 ]
[.32887 .12688 .56316 0 ]
[.49142 .06307 -13.2987 -10 ]
[.49142 .06307 1.76379 0 ]
[.66418 -0.00472 -7.02463 -10 ]
[.66418 -0.00472 1.41287 0 ]
[.29055 .07541 -7.45437 -10 ]
[.29055 .07541 .54563 0 ]
[.70593 .00492 0 -6.94437 ]
[.70593 .00492 13.9375 3.05563 ]
[.78524 .12593 0 -6.81327 ]
[.78524 .12593 20.5625 3.18673 ]
[.85636 .23443 0 -6.69873 ]
[.85636 .23443 8.4375 3.30127 ]
[.92048 .33228 0 -6.59781 ]
[.92048 .33228 15.0625 3.40219 ]
[.97859 .42096 0 -6.5082 ]
[.97859 .42096 8.4375 3.4918 ]
[.9185 .21332 0 -6.69873 ]
[.9185 .21332 8 3.30127 ]
[.02382 .26035 -20.5625 -3.04587 ]
[.02382 .26035 0 6.95413 ]
[.01528 .3141 -20.5625 -3.09606 ]
[.01528 .3141 0 6.90394 ]
[.00644 .36975 -8.4375 -3.14821 ]
[.00644 .36975 0 6.85179 ]
[-0.00272 .4274 -15.0625 -3.20243 ]
[-0.00272 .4274 0 6.79757 ]
[-0.01222 .48717 -15.0625 -3.25885 ]
[-0.01222 .48717 0 6.74115 ]
[-0.05511 .39255 -8 -3.14821 ]
[-0.05511 .39255 0 6.85179 ]
[ 0 0 0 0 ]
[ 1 .80795 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .82045 -87.8438 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.0625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.062500 moveto
 540.000000 16.062500 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.062500 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
67.437500 13.812500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
70.437500 11.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
74.250000 13.812500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
78.062500 13.812500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
81.062500 11.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
85.937500 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
91.062500 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
112.687500 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.0362 .2546 m
.68734 0 L
s
.0406 .25288 m
.04539 .25737 L
s
gsave
.03101 .24391 -74.9375 -13.682 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.18479 .1965 m
.18935 .20122 L
s
gsave
.17566 .18707 -81.2255 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.33747 .1368 m
.34177 .14176 L
s
gsave
.32887 .12688 -68.8743 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4994 .07349 m
.50339 .0787 L
s
gsave
.49142 .06307 -74.2987 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.67145 .00621 m
.67509 .01168 L
s
gsave
.66418 -0.00472 -68.0246 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.06879 .24186 m
.07164 .24458 L
s
.0973 .23071 m
.10012 .23346 L
s
.12614 .21944 m
.12893 .22221 L
s
.1553 .20803 m
.15806 .21084 L
s
.21462 .18484 m
.21733 .1877 L
s
.2448 .17304 m
.24748 .17593 L
s
.27533 .1611 m
.27798 .16402 L
s
.30622 .14902 m
.30883 .15197 L
s
.36909 .12444 m
.37163 .12745 L
s
.40108 .11193 m
.40359 .11497 L
s
.43346 .09927 m
.43593 .10234 L
s
.46623 .08646 m
.46867 .08955 L
s
.53297 .06036 m
.53532 .06352 L
s
.56695 .04707 m
.56927 .05026 L
s
.60136 .03362 m
.60363 .03684 L
s
.63619 .02 m
.63841 .02325 L
s
gsave
.29055 .07541 -68.4544 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.68734 0 m
.97019 .4311 L
s
.69369 .00968 m
.68758 .01206 L
s
gsave
.70593 .00492 -61 -10.9444 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.7729 .1304 m
.76673 .13264 L
s
gsave
.78524 .12593 -61 -10.8133 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.84393 .23866 m
.83771 .24077 L
s
gsave
.85636 .23443 -61 -10.6987 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.90797 .33628 m
.90172 .33827 L
s
gsave
.92048 .33228 -61 -10.5978 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.96603 .42476 m
.95974 .42665 L
s
gsave
.97859 .42096 -61 -10.5082 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.71026 .03492 m
.70658 .03633 L
s
.72645 .0596 m
.72276 .06099 L
s
.74228 .08373 m
.73859 .0851 L
s
.75776 .10732 m
.75406 .10868 L
s
.78772 .15299 m
.78401 .15431 L
s
.80222 .17509 m
.79851 .1764 L
s
.81642 .19673 m
.8127 .19802 L
s
.83031 .21791 m
.82659 .21919 L
s
.85726 .25898 m
.85353 .26023 L
s
.87032 .27889 m
.86659 .28013 L
s
.88313 .2984 m
.87938 .29963 L
s
.89567 .31753 m
.89193 .31874 L
s
.92004 .35466 m
.91628 .35585 L
s
.93187 .37269 m
.92811 .37386 L
s
.94347 .39038 m
.93971 .39154 L
s
.95485 .40773 m
.95109 .40888 L
s
gsave
.9185 .21332 -61 -10.6987 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.0362 .2546 m
0 .48397 L
s
.03605 .25557 m
.04216 .25318 L
s
gsave
.02382 .26035 -81.5625 -7.04587 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.02755 .30943 m
.03368 .30709 L
s
gsave
.01528 .3141 -81.5625 -7.09606 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.01875 .36519 m
.0249 .36291 L
s
gsave
.00644 .36975 -69.4375 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00963 .42296 m
.01581 .42074 L
s
gsave
-0.00272 .4274 -76.0625 -7.20243 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00018 .48285 m
.00638 .48069 L
s
gsave
-0.01222 .48717 -76.0625 -7.25885 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.03395 .26886 m
.03762 .26744 L
s
.03183 .28227 m
.03551 .28085 L
s
.0297 .29579 m
.03338 .29438 L
s
.02538 .32319 m
.02906 .32179 L
s
.02319 .33707 m
.02687 .33568 L
s
.02098 .35107 m
.02467 .34969 L
s
.0165 .37944 m
.02019 .37808 L
s
.01423 .39382 m
.01793 .39247 L
s
.01194 .40832 m
.01564 .40698 L
s
.0073 .43773 m
.01101 .43641 L
s
.00495 .45263 m
.00866 .45132 L
s
.00257 .46767 m
.00629 .46637 L
s
gsave
-0.05511 .39255 -69 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.0362 .2546 m
0 .48397 L
s
0 .48397 m
.39943 .80795 L
s
.39943 .80795 m
.40657 .60039 L
s
.40657 .60039 m
.0362 .2546 L
s
.68734 0 m
.97019 .4311 L
s
.97019 .4311 m
1 .65038 L
s
1 .65038 m
.70104 .23999 L
s
.70104 .23999 m
.68734 0 L
s
.0362 .2546 m
0 .48397 L
s
0 .48397 m
.70104 .23999 L
s
.70104 .23999 m
.68734 0 L
s
.68734 0 m
.0362 .2546 L
s
.40657 .60039 m
.97019 .4311 L
s
.97019 .4311 m
1 .65038 L
s
1 .65038 m
.39943 .80795 L
s
.39943 .80795 m
.40657 .60039 L
s
0 0 m
1 0 L
1 .80795 L
0 .80795 L
closepath
clip
newpath
.5 Mabswid
.54261 .5056 m .54504 .53108 L .60708 .54431 L p .742 g
F P
0 g
s
.60708 .54431 m .59841 .51251 L .54261 .5056 L p .742 g
F P
0 g
s
.61349 .5767 m .60708 .54431 L .54504 .53108 L p .714 g
F P
0 g
s
.59841 .51251 m .60708 .54431 L .66555 .53385 L p .645 g
F P
0 g
s
.60708 .54431 m .61349 .5767 L .67643 .56689 L p .605 g
F P
0 g
s
.67643 .56689 m .66555 .53385 L .60708 .54431 L p .605 g
F P
0 g
s
.54504 .53108 m .54682 .55681 L .61349 .5767 L p .714 g
F P
0 g
s
.6172 .60751 m .61349 .5767 L .54682 .55681 L p .687 g
F P
0 g
s
.61349 .5767 m .6172 .60751 L .68278 .59877 L p .561 g
F P
0 g
s
.68278 .59877 m .67643 .56689 L .61349 .5767 L p .561 g
F P
0 g
s
.53968 .48207 m .54261 .5056 L .59841 .51251 L p .773 g
F P
0 g
s
.59841 .51251 m .58805 .48334 L .53968 .48207 L p .773 g
F P
0 g
s
.58805 .48334 m .59841 .51251 L .65091 .50185 L p .685 g
F P
0 g
s
.66555 .53385 m .65091 .50185 L .59841 .51251 L p .645 g
F P
0 g
s
.65091 .50185 m .66555 .53385 L .69024 .50577 L p .487 g
F P
0 g
s
.66555 .53385 m .67643 .56689 L .70311 .53357 L p .409 g
F P
0 g
s
.70311 .53357 m .69024 .50577 L .66555 .53385 L p .409 g
F P
0 g
s
.67643 .56689 m .68278 .59877 L .71053 .56088 L p .295 g
F P
0 g
s
.71053 .56088 m .70311 .53357 L .67643 .56689 L p .295 g
F P
0 g
s
.54682 .55681 m .54782 .58101 L .6172 .60751 L p .687 g
F P
0 g
s
.61793 .63454 m .6172 .60751 L .54782 .58101 L p .656 g
F P
0 g
s
.6172 .60751 m .61793 .63454 L .68408 .62721 L p .504 g
F P
0 g
s
.68408 .62721 m .68278 .59877 L .6172 .60751 L p .504 g
F P
0 g
s
.65091 .50185 m .63346 .47297 L .58805 .48334 L p .685 g
F P
0 g
s
.63346 .47297 m .65091 .50185 L .67287 .47942 L p .545 g
F P
0 g
s
.69024 .50577 m .67287 .47942 L .65091 .50185 L p .487 g
F P
0 g
s
.68278 .59877 m .68408 .62721 L .71188 .58571 L p .102 g
F P
0 g
s
.71188 .58571 m .71053 .56088 L .68278 .59877 L p .102 g
F P
0 g
s
.53646 .46197 m .53968 .48207 L .58805 .48334 L p .807 g
F P
0 g
s
.58805 .48334 m .57667 .45859 L .53646 .46197 L p .807 g
F P
0 g
s
.57667 .45859 m .58805 .48334 L .63346 .47297 L p .727 g
F P
0 g
s
.54782 .58101 m .54796 .60192 L .61793 .63454 L p .656 g
F P
0 g
s
.61553 .65576 m .61793 .63454 L .54796 .60192 L p .618 g
F P
0 g
s
.61793 .63454 m .61553 .65576 L .68012 .65004 L p .418 g
F P
0 g
s
.68012 .65004 m .68408 .62721 L .61793 .63454 L p .418 g
F P
0 g
s
.63346 .47297 m .61432 .44894 L .57667 .45859 L p .727 g
F P
0 g
s
.61432 .44894 m .63346 .47297 L .65219 .45624 L p .589 g
F P
0 g
s
.67287 .47942 m .65219 .45624 L .63346 .47297 L p .545 g
F P
0 g
s
.68408 .62721 m .68012 .65004 L .70693 .60612 L p .012 g
F P
0 g
s
.70693 .60612 m .71188 .58571 L .68408 .62721 L p .012 g
F P
0 g
s
.51118 .48277 m .51008 .49635 L .54504 .53108 L p .837 g
F P
0 g
s
.51346 .48443 m .51118 .48277 L p .51312 .48554 L .837 g
F P
0 g
s
.5125 .47024 m .51118 .48277 L .54261 .5056 L p .854 g
F P
0 g
s
.54261 .5056 m .53968 .48207 L .51682 .47212 L p .854 g
F P
0 g
s
.51639 .47194 m .51539 .4715 L p .51593 .47427 L .854 g
F P
0 g
s
.51539 .4715 m .51434 .47104 L p .5148 .47295 L .854 g
F P
0 g
s
.5148 .47295 m .51434 .47104 L .51421 .47225 L .854 g
F
.51434 .47104 m .5125 .47024 L p .51421 .47225 L F P
0 g
s
.51393 .45958 m .5125 .47024 L .53968 .48207 L p .869 g
F P
0 g
s
.51954 .46017 m .51731 .45994 L p .51826 .46336 L .869 g
F P
0 g
s
.51731 .45994 m .51393 .45958 L p .51643 .46176 L .869 g
F P
0 g
s
.51826 .46336 m .51731 .45994 L .51643 .46176 L .869 g
F
.5154 .45141 m .51393 .45958 L .53646 .46197 L p .878 g
F P
0 g
s
.5125 .47024 m .51714 .45714 L .517 .4579 L .005 g
F
.51692 .45835 m .51733 .457 L .51716 .45768 L F
.5125 .47024 m .517 .4579 L .51692 .45835 L F
.517 .4579 m .51733 .457 L .51692 .45835 L F
.51665 .45874 m .51662 .45884 L p .51726 .45742 L F P
0 g
s
.44609 .51221 m .4432 .52789 L .51198 .46888 L p .234 g
F P
0 g
s
.51659 .45891 m .51658 .45893 L p .51719 .45762 L .005 g
F P
0 g
s
.51658 .45893 m .513 .46883 L p .51718 .45765 L .005 g
F P
0 g
s
.51718 .45765 m .51719 .45762 L .51658 .45893 L .005 g
F
.51307 .4687 m .51727 .45739 L .513 .46883 L F
.51727 .45739 m .51727 .45739 L .513 .46883 L F
.51734 .45721 m .51734 .45721 L .513 .46883 L F
.513 .46883 m .5125 .47024 L p .51307 .4687 L F P
0 g
s
.51593 .47427 m .51539 .4715 L .5148 .47295 L .854 g
F
.51682 .47212 m .51639 .47194 L p .5161 .47447 L F P
0 g
s
.5161 .47447 m .51639 .47194 L .51593 .47427 L .854 g
F
.54261 .5056 m .51682 .47212 L .5161 .47447 L F
.54504 .53108 m .54261 .5056 L .51346 .48443 L p .837 g
F P
0 g
s
.54504 .53108 m .51346 .48443 L .51312 .48554 L .837 g
F
.54682 .55681 m .54504 .53108 L .51008 .49635 L p .817 g
F P
0 g
s
.51008 .49635 m .50928 .51003 L .54682 .55681 L p .817 g
F P
0 g
s
.54782 .58101 m .54682 .55681 L .50928 .51003 L p .795 g
F P
0 g
s
.50928 .51003 m .50883 .52279 L .54782 .58101 L p .795 g
F P
0 g
s
.54796 .60192 m .54782 .58101 L .50883 .52279 L p .769 g
F P
0 g
s
.50883 .52279 m .50878 .53366 L .54796 .60192 L p .769 g
F P
0 g
s
.54722 .61794 m .54796 .60192 L .50878 .53366 L p .732 g
F P
0 g
s
.50878 .53366 m .50913 .54178 L .54722 .61794 L p .732 g
F P
0 g
s
.51814 .46702 m .51743 .46844 L .51727 .46875 L p .69 g
F P
0 g
s
.51673 .46943 m .5167 .46989 L p .51607 .47028 L .022 g
F P
0 g
s
.51602 .47125 m .51607 .47028 L .5167 .46989 L .022 g
F
.51673 .46943 m .51743 .46844 L .5174 .46899 L p .026 g
F P
0 g
s
.5174 .46899 m .51367 .53768 L p .51665 .47104 L .026 g
F P
0 g
s
.51665 .47104 m .51673 .46943 L .5174 .46899 L .026 g
F
.51882 .46531 m .51814 .46702 L .51799 .46736 L p .819 g
F P
0 g
s
.51743 .46844 m .51673 .46943 L p .51714 .46888 L F P
s
.51517 .528 m .51367 .53768 L .51743 .46844 L p .029 g
F P
0 g
s
.5167 .46989 m .51673 .46943 L p .51671 .46988 L .026 g
F P
0 g
s
.51118 .48277 m .5125 .47024 L .51432 .46518 L p .005 g
F P
0 g
s
.51118 .48277 m .51432 .46518 L .51461 .46604 L .005 g
F
.51118 .48277 m .51538 .46226 L .51494 .46639 L F
.51538 .46226 m .51627 .4598 L p .51494 .46639 L F P
0 g
s
.51627 .4598 m .51675 .45846 L p .51597 .46186 L .005 g
F P
0 g
s
.51494 .46639 m .51627 .4598 L .51597 .46186 L .005 g
F
.51213 .47853 m .51483 .46682 L .51209 .47864 L F
.51483 .46682 m .51646 .45974 L .51481 .46686 L F
.51483 .46682 m .51481 .46686 L .51209 .47864 L F
.51646 .45974 m .51646 .45974 L .51631 .46039 L F
.51608 .46138 m .51608 .46138 L .51568 .46311 L F
.51568 .46311 m .51568 .46311 L .51209 .47864 L F
.51608 .46138 m .51568 .46311 L .51568 .46311 L F
.51656 .45929 m .51656 .4593 L .51209 .47864 L F
.51214 .47851 m .51219 .47831 L .51213 .47853 L F
.5125 .47024 m .51393 .45958 L .51714 .45714 L p F P
0 g
s
.51267 .46985 m .51198 .46888 L .51081 .4714 L .187 g
F
.51219 .47831 m .51656 .45929 L .51213 .47853 L .005 g
F
.51656 .45929 m .51656 .45929 L .51213 .47853 L F
.51664 .45896 m .51664 .45896 L .51657 .45925 L F
.4432 .52789 m .44287 .54162 L .51242 .47054 L p .187 g
F P
0 g
s
.51656 .45929 m .51656 .45929 L .51213 .47853 L .005 g
F
.51675 .45846 m .51611 .46031 L .51601 .4608 L p F P
0 g
s
.51601 .4608 m .51209 .47864 L p .51656 .4593 L .005 g
F P
0 g
s
.51656 .4593 m .51675 .45846 L .51601 .4608 L .005 g
F
.51365 .46719 m .51351 .46555 L .51236 .46805 L .234 g
F
.51167 .48061 m .51657 .45925 L .51164 .48068 L .005 g
F
.51657 .45925 m .51664 .45896 L .51657 .45925 L F
.51657 .45925 m .51657 .45925 L .51164 .48068 L F
.44287 .54162 m .44515 .55232 L .51118 .47386 L p .117 g
F P
0 g
s
.51664 .45896 m .51664 .45896 L .5166 .45914 L .005 g
F
.5166 .45913 m .5166 .45914 L .51164 .48068 L F
.51664 .45896 m .5166 .45914 L .5166 .45913 L F
.44515 .55232 m .4499 .5591 L .50975 .47769 L p .068 g
F P
0 g
s
.51008 .49635 m .51375 .47225 L .51381 .47216 L .005 g
F
.51375 .47225 m .51432 .46847 L .51381 .47216 L F
.51381 .47216 m .51432 .46847 L .51439 .46841 L F
.51167 .48062 m .51164 .48068 L .51163 .48072 L F
.51167 .48061 m .51164 .48068 L .51167 .48062 L F
.51209 .47864 m .51163 .48072 L p .51214 .47851 L F P
0 g
s
.51163 .48072 m .51118 .48277 L p .51167 .48061 L .005 g
F P
0 g
s
.51008 .49635 m .51118 .48277 L .51432 .46847 L p .005 g
F P
0 g
s
.51008 .49635 m .51452 .46754 L .51475 .46827 L .005 g
F
.51469 .46882 m .51475 .46827 L .51477 .46834 L F
.51008 .49635 m .51475 .46827 L .51469 .46882 L F
.50938 .5178 m .51154 .49793 L .50936 .51799 L .007 g
F
.51452 .46754 m .51585 .4615 L p .51477 .46834 L .005 g
F P
0 g
s
.51585 .4615 m .51611 .46031 L p .51557 .46353 L .005 g
F P
0 g
s
.51477 .46834 m .51585 .4615 L .51557 .46353 L .005 g
F
.51085 .49171 m .51202 .4847 L .51081 .49181 L F
.51202 .4847 m .5158 .4622 L .51191 .48531 L F
.5158 .4622 m .51611 .46031 L .51579 .46221 L F
.5158 .4622 m .51579 .46221 L .51191 .48531 L F
.51611 .46031 m .51558 .46234 L .51556 .46246 L p F P
0 g
s
.51242 .47054 m .51367 .46926 L p .51267 .46985 L .187 g
F P
0 g
s
.51552 .46268 m .51537 .46363 L p .51599 .46102 L .005 g
F P
0 g
s
.51537 .46363 m .51158 .48707 L p .51579 .46223 L .005 g
F P
0 g
s
.51579 .46223 m .51599 .46102 L .51537 .46363 L .005 g
F
.51246 .47341 m .51118 .47386 L .51046 .47576 L .068 g
F
.51191 .48531 m .51591 .46151 L .51158 .48707 L .005 g
F
.51591 .46151 m .51599 .46101 L .51591 .46151 L F
.51591 .46151 m .51591 .46151 L .51158 .48707 L F
.51599 .46101 m .51599 .46102 L .51591 .46151 L F
.51591 .46151 m .51591 .46151 L .51158 .48707 L F
.51599 .46101 m .51591 .46151 L .51591 .46151 L F
.51312 .47118 m .51242 .47054 L .51162 .47268 L .117 g
F
.51603 .4608 m .51603 .4608 L .516 .46096 L .005 g
F
.51376 .46894 m .51317 .4685 L .51267 .46985 L .187 g
F
.51599 .46102 m .51599 .46102 L .51158 .48707 L .005 g
F
.51047 .49402 m .51562 .46326 L .51044 .4941 L F
.51562 .46326 m .51611 .46031 L .51562 .46326 L F
.51562 .46326 m .51562 .46326 L .51044 .4941 L F
.51178 .47569 m .50975 .47769 L .50914 .47925 L .023 g
F
.50928 .51003 m .51399 .47271 L .51422 .47241 L .006 g
F
.51399 .47271 m .51432 .47013 L .51422 .47241 L F
.51422 .47241 m .51432 .47013 L .51455 .46985 L F
.51202 .4847 m .51191 .48531 L .51081 .49181 L .005 g
F
.51158 .48707 m .51081 .49181 L p .51191 .48531 L F P
0 g
s
.51081 .49181 m .51044 .4941 L p .51085 .49171 L .005 g
F P
0 g
s
.51044 .4941 m .51008 .49635 L p .51047 .49402 L .005 g
F P
0 g
s
.50928 .51003 m .51008 .49635 L .51432 .47013 L p .006 g
F P
0 g
s
.50928 .51003 m .51537 .46363 L .51537 .46391 L .006 g
F
.50928 .51003 m .51556 .46246 L .51556 .4625 L F
.51114 .49598 m .51523 .46497 L .51076 .49874 L F
.51523 .46497 m .51558 .46234 L .51523 .46498 L F
.51523 .46497 m .51523 .46498 L .51076 .49874 L F
.51432 .47013 m .51499 .46599 L p .51448 .46995 L F P
0 g
s
.51499 .46599 m .51537 .46363 L p .51448 .46995 L .006 g
F P
0 g
s
.51455 .46985 m .51448 .46995 L .51537 .46363 L .006 g
F
.51537 .46363 m .51556 .46246 L p .51537 .46391 L F P
0 g
s
.51556 .46246 m .51558 .46234 L p .51556 .4625 L .006 g
F P
0 g
s
.51496 .46621 m .51112 .49579 L p .51523 .465 L .006 g
F P
0 g
s
.51144 .49358 m .51552 .46279 L .51112 .49579 L .006 g
F
.51552 .46279 m .51552 .46279 L .51112 .49579 L F
.51553 .4627 m .51553 .4627 L .51552 .46279 L F
.51552 .46279 m .51552 .46279 L .51112 .49579 L F
.51553 .4627 m .51552 .46279 L .51552 .46279 L F
.51449 .46807 m .51351 .46756 L .51317 .4685 L .187 g
F
.51125 .50067 m .51486 .46759 L p .51222 .49637 L .01 g
F P
0 g
s
.51222 .49637 m .51486 .46759 L .51486 .46771 L .01 g
F
.51154 .49793 m .51497 .46647 L .5115 .4983 L .007 g
F
.51497 .46647 m .51497 .46647 L .5115 .4983 L F
.51518 .46457 m .51518 .46457 L .5115 .4983 L F
.51558 .46234 m .5152 .46438 L .51496 .46621 L p .006 g
F P
0 g
s
.51523 .465 m .51558 .46234 L .51496 .46621 L .006 g
F
.51519 .46444 m .51519 .46444 L .5115 .4983 L .007 g
F
.50878 .53366 m .51498 .46648 L .51498 .46651 L .01 g
F
.51399 .47544 m .5152 .46438 L .514 .4754 L .007 g
F
.51178 .49573 m .5152 .46438 L .5116 .4974 L F
.5101 .50378 m .51114 .49598 L .51006 .50401 L .006 g
F
.51114 .49598 m .51076 .49874 L .51006 .50401 L F
.51112 .49579 m .51006 .50401 L p .51144 .49358 L F P
0 g
s
.51006 .50401 m .50928 .51003 L p .5101 .50378 L .006 g
F P
0 g
s
.50883 .52279 m .50928 .51003 L .5152 .46438 L p .007 g
F P
0 g
s
.51464 .46965 m .51346 .47 L .51312 .47118 L .117 g
F
.515 .46629 m .51499 .46791 L .51497 .46813 L p .01 g
F P
0 g
s
.51609 .46989 m .51673 .46943 L p .51607 .47028 L .022 g
F P
0 g
s
.51553 .47011 m .51509 .47607 L p .51512 .47007 L .016 g
F P
0 g
s
.54561 .62771 m .54722 .61794 L .50913 .54178 L p .678 g
F P
0 g
s
.50913 .54178 m .50986 .54648 L .52374 .57803 L p .678 g
F P
0 g
s
.52374 .57803 m .54561 .62771 L p .52038 .56827 L .678 g
F P
0 g
s
.52038 .56827 m .50913 .54178 L .52374 .57803 L .678 g
F
.54326 .63036 m .54561 .62771 L .50986 .54648 L p .591 g
F P
0 g
s
.50986 .54648 m .51091 .54736 L .5253 .58428 L p .591 g
F P
0 g
s
.5253 .58428 m .54326 .63036 L p .52542 .58556 L .591 g
F P
0 g
s
.52542 .58556 m .50986 .54648 L .5253 .58428 L .591 g
F
.54031 .62553 m .54326 .63036 L .53054 .59772 L p .475 g
F P
0 g
s
.53698 .61355 m .54031 .62553 L .52503 .58138 L p .038 g
F P
0 g
s
.52503 .58138 m .51221 .54434 L p .52488 .57974 L .038 g
F P
0 g
s
.53698 .61355 m .52503 .58138 L .52488 .57974 L .038 g
F
.53054 .59772 m .51091 .54736 L p .53819 .61988 L .475 g
F P
0 g
s
.54031 .62553 m .53054 .59772 L .53819 .61988 L .475 g
F
.51509 .47607 m .50986 .54648 L p .51458 .47787 L .016 g
F P
0 g
s
.51458 .47787 m .51512 .47007 L .51509 .47607 L .016 g
F
.51483 .4696 m .50878 .53366 L p .51475 .46899 L .01 g
F P
0 g
s
.514 .4754 m .5116 .4974 L p .51399 .47544 L .007 g
F P
0 g
s
.51367 .53768 m .51221 .54434 L .5167 .46989 L p .026 g
F P
0 g
s
.51367 .53768 m .5167 .46989 L .51671 .46988 L .026 g
F
.51448 .47098 m .514 .4754 L p .51451 .47075 L .007 g
F P
0 g
s
.50913 .54178 m .50878 .53366 L .51363 .48237 L p .012 g
F P
0 g
s
.51363 .48237 m .51483 .4696 L p .514 .48045 L .012 g
F P
0 g
s
.514 .48045 m .51483 .4696 L .51485 .46969 L .012 g
F
.51609 .46989 m .51091 .54736 L p .51554 .47012 L .019 g
F P
0 g
s
.51556 .46978 m .51609 .46989 L p .51554 .47012 L .019 g
F P
0 g
s
.51091 .54736 m .50986 .54648 L .51509 .47607 L p .019 g
F P
0 g
s
.51509 .47607 m .51556 .46978 L p .51522 .47551 L .019 g
F P
0 g
s
.51091 .54736 m .51509 .47607 L .51522 .47551 L .019 g
F
.51511 .47003 m .51437 .47891 L p .51489 .46974 L .012 g
F P
0 g
s
.514 .48045 m .51499 .46791 L .51437 .47891 L .012 g
F
.50986 .54648 m .50913 .54178 L .51437 .47891 L p .016 g
F P
0 g
s
.51576 .47087 m .51545 .47132 L .51576 .47088 L .005 g
F
.51437 .47891 m .51511 .47003 L p .51458 .47787 L .016 g
F P
0 g
s
.51458 .47787 m .51511 .47003 L .51512 .47007 L .016 g
F
.51545 .47132 m .50797 .48241 L .51545 .47134 L .005 g
F
.51545 .47132 m .51545 .47134 L .51576 .47088 L F
.51511 .47003 m .51518 .4691 L p .51512 .47007 L .016 g
F P
0 g
s
.50986 .54648 m .51437 .47891 L .51458 .47787 L .016 g
F
.51221 .54434 m .51091 .54736 L .51609 .46989 L p .022 g
F P
0 g
s
.47487 .55213 m .51743 .46844 L p .47767 .53755 L F P
s
.46533 .559 m .47487 .55213 L p .47767 .53755 L F P
s
.51409 .47499 m .51409 .47501 L .50148 .4998 L .69 g
F
.50148 .4998 m .48013 .54179 L p .50139 .49998 L F P
0 g
s
.48013 .54179 m .47487 .55213 L p .48006 .54191 L .69 g
F P
0 g
s
.50139 .49998 m .48013 .54179 L .48006 .54191 L .69 g
F
.41629 .60696 m .43853 .59163 L .47472 .55229 L p .833 g
F P
0 g
s
.51409 .47499 m .50148 .4998 L .50139 .49998 L .69 g
F
.5169 .46948 m .51409 .47501 L p .51704 .4692 L F P
0 g
s
.51704 .4692 m .51409 .47501 L .51409 .47499 L .69 g
F
.51727 .46875 m .5169 .46948 L p .51768 .46793 L F P
0 g
s
.51768 .46793 m .5169 .46948 L .51704 .4692 L .69 g
F
.51743 .46844 m .51609 .47054 L .51613 .47069 L 0 g
F
.5167 .46989 m .51221 .54434 L p .51602 .47125 L .022 g
F P
0 g
s
.47487 .55213 m .48471 .54143 L .51729 .46892 L p .69 g
F P
0 g
s
.51814 .46702 m .51727 .46875 L .51768 .46793 L .69 g
F
.51743 .46844 m .51814 .46702 L .51811 .46767 L p .029 g
F P
0 g
s
.51811 .46767 m .51517 .528 L p .51736 .47034 L .029 g
F P
0 g
s
.51736 .47034 m .51743 .46844 L .51811 .46767 L .029 g
F
.53968 .48207 m .51954 .46017 L .51826 .46336 L .869 g
F
.51941 .46345 m .51882 .46531 L .51868 .46567 L p .882 g
F P
0 g
s
.51729 .46892 m .51814 .46702 L p .51635 .47055 L .69 g
F P
0 g
s
.51635 .47055 m .47487 .55213 L .51729 .46892 L .69 g
F
.51729 .46892 m .51684 .46992 L p .51691 .46968 L .819 g
F P
0 g
s
.51799 .46736 m .51729 .46892 L p .51838 .46629 L .819 g
F P
0 g
s
.51838 .46629 m .51729 .46892 L .51645 .47059 L .819 g
F
.51882 .46531 m .51799 .46736 L .51838 .46629 L F
.51661 .51616 m .51517 .528 L .51811 .46767 L p .031 g
F P
0 g
s
.51811 .46767 m .51814 .46702 L p .51812 .4676 L .031 g
F P
0 g
s
.51661 .51616 m .51811 .46767 L .51812 .4676 L .031 g
F
.51607 .47163 m .51569 .47248 L p .51611 .47146 L .819 g
F P
0 g
s
.51569 .47248 m .48991 .52986 L p .51572 .47232 L .819 g
F P
0 g
s
.48991 .52986 m .48471 .54143 L p .48987 .52993 L .819 g
F P
0 g
s
.51572 .47232 m .48991 .52986 L .48987 .52993 L .819 g
F
.39492 .61571 m .41629 .60696 L .47487 .55213 L p 0 g
F P
s
.47487 .55213 m .46533 .559 L .41591 .5988 L p F P
s
.41591 .5988 m .39492 .61571 L p .427 .59019 L F P
s
.47487 .55213 m .41591 .5988 L .427 .59019 L F
.48471 .54143 m .47487 .55213 L .41629 .60696 L p .833 g
F P
0 g
s
.47603 .54974 m .4628 .56242 L .47472 .55229 L .833 g
F
.4628 .56242 m .41629 .60696 L .46922 .55743 L F
.4628 .56242 m .46922 .55743 L .47472 .55229 L F
.47472 .55229 m .48471 .54143 L p .47603 .54974 L F P
0 g
s
.51611 .47146 m .51569 .47248 L .51572 .47232 L .819 g
F
.51618 .47139 m .51607 .47163 L p .51622 .4712 L F P
0 g
s
.51622 .4712 m .51607 .47163 L .51611 .47146 L .819 g
F
.51684 .46992 m .51618 .47139 L p .51691 .46968 L F P
0 g
s
.51691 .46968 m .51618 .47139 L .51622 .4712 L .819 g
F
.51645 .47059 m .51691 .46968 L .51545 .47294 L F
.51548 .47275 m .51545 .47294 L .48471 .54143 L F
.51645 .47059 m .51545 .47294 L .51548 .47275 L F
.51814 .46702 m .51882 .46531 L .51661 .51616 L p .031 g
F P
0 g
s
.4872 .53587 m .49414 .52792 L .51882 .46531 L p .819 g
F P
0 g
s
.49414 .52792 m .48471 .54143 L .43853 .59163 L p .927 g
F P
0 g
s
.43853 .59163 m .45997 .57124 L .48386 .54095 L p .927 g
F P
0 g
s
.48386 .54095 m .49414 .52792 L p .48569 .53761 L .927 g
F P
0 g
s
.48569 .53761 m .43853 .59163 L .48386 .54095 L .927 g
F
.51868 .46567 m .51831 .46659 L p .51901 .46448 L .882 g
F P
0 g
s
.51831 .46659 m .49414 .52792 L p .51843 .46596 L .882 g
F P
0 g
s
.51901 .46448 m .51831 .46659 L .51843 .46596 L .882 g
F
.51941 .46345 m .51868 .46567 L .51901 .46448 L F
.51609 .46989 m .51509 .47143 L p .51648 .46972 L .005 g
F P
0 g
s
.51673 .46943 m .51609 .46989 L p .51648 .46972 L .005 g
F P
0 g
s
.51622 .47018 m .51576 .47087 L .51623 .47018 L .005 g
F
.51576 .47087 m .51576 .47088 L .51623 .47018 L F
.51499 .46791 m .51518 .4691 L .51511 .47003 L p .012 g
F P
0 g
s
.51489 .46974 m .51499 .46791 L .51511 .47003 L .012 g
F
.51437 .47891 m .50913 .54178 L p .514 .48045 L F P
0 g
s
.51524 .47171 m .50797 .48241 L .50751 .48356 L .005 g
F
.51623 .47018 m .51523 .47167 L .51524 .47171 L F
.51523 .47167 m .50797 .48241 L .51524 .47171 L F
.51512 .47007 m .51516 .4694 L .51553 .47011 L .016 g
F
.51518 .4691 m .51503 .46928 L p .51533 .47 L .068 g
F P
0 g
s
.51498 .46648 m .51448 .47098 L p .51512 .46508 L .007 g
F P
0 g
s
.51451 .47075 m .5152 .46438 L .51448 .47098 L .007 g
F
.51503 .46928 m .51296 .47175 L p .51508 .47018 L .068 g
F P
0 g
s
.51533 .47 m .51503 .46928 L .51508 .47018 L .068 g
F
.51483 .4696 m .51497 .46813 L p .51485 .46969 L .012 g
F P
0 g
s
.51497 .46813 m .51499 .46791 L p .51497 .46816 L .012 g
F P
0 g
s
.51485 .46969 m .51497 .46813 L .51497 .46816 L .012 g
F
.50913 .54178 m .51363 .48237 L .514 .48045 L F
.51673 .46943 m .51622 .47018 L .51623 .47018 L .005 g
F
.51556 .46978 m .51553 .47011 L p .51516 .4694 L .016 g
F P
0 g
s
.51518 .4691 m .51556 .46978 L p .51516 .4694 L .016 g
F P
0 g
s
.51556 .46978 m .51448 .47126 L p .51586 .47008 L .023 g
F P
0 g
s
.51609 .46989 m .51556 .46978 L p .51586 .47008 L .023 g
F P
0 g
s
.51509 .47143 m .50797 .48241 L p .51513 .47179 L .005 g
F P
0 g
s
.51673 .46943 m .51509 .47143 L .51513 .47179 L .005 g
F
.51497 .46813 m .51483 .4696 L p .51494 .46696 L .01 g
F P
0 g
s
.51475 .46899 m .51494 .46696 L .51483 .4696 L .01 g
F
.51494 .46696 m .515 .46629 L .51497 .46813 L F
.51504 .47039 m .51277 .47238 L .51246 .47341 L .068 g
F
.51556 .46978 m .51503 .47027 L .51504 .47039 L F
.51503 .47027 m .51277 .47238 L .51504 .47039 L F
.51518 .4691 m .51467 .46937 L .51464 .46965 L .117 g
F
.51467 .46937 m .51346 .47 L .51464 .46965 L F
.515 .46629 m .51498 .46648 L p .51517 .46462 L .007 g
F P
0 g
s
.51512 .46508 m .51517 .46462 L .51498 .46648 L .007 g
F
.5152 .46438 m .515 .46629 L p .51517 .46462 L F P
0 g
s
.515 .46629 m .5148 .46646 L p .5149 .46721 L .187 g
F P
0 g
s
.51498 .46648 m .515 .46629 L p .51498 .46651 L .01 g
F P
0 g
s
.51499 .46791 m .515 .46629 L p .5149 .46721 L .187 g
F P
0 g
s
.51499 .46791 m .51454 .4678 L .51449 .46807 L .187 g
F
.51454 .4678 m .51351 .46756 L .51449 .46807 L F
.5148 .46646 m .51351 .46756 L p .51454 .4678 L F P
0 g
s
.51486 .46759 m .51498 .46648 L p .51486 .46771 L .01 g
F P
0 g
s
.51499 .46791 m .5148 .46646 L .51454 .4678 L .187 g
F
.51552 .46279 m .51553 .4627 L .51552 .46279 L .006 g
F
.51556 .46246 m .51552 .46268 L p .51603 .4608 L .005 g
F P
0 g
s
.51553 .4627 m .51558 .46234 L .51553 .4627 L .006 g
F
.51464 .46965 m .51405 .47024 L .51463 .46976 L .117 g
F
.51405 .47024 m .51162 .47268 L .51403 .47034 L F
.51405 .47024 m .51403 .47034 L .51463 .46976 L F
.51445 .47129 m .5136 .47245 L p .51438 .47198 L .023 g
F P
0 g
s
.5144 .47196 m .51445 .47129 L .51438 .47198 L .023 g
F
.51448 .47126 m .51445 .47129 L p .5144 .47196 L F P
0 g
s
.5136 .47245 m .50975 .47769 L p .51345 .47313 L .023 g
F P
0 g
s
.5144 .47196 m .5136 .47245 L .51345 .47313 L .023 g
F
.51508 .47113 m .51345 .47313 L .51509 .47124 L F
.51345 .47313 m .50975 .47769 L .51343 .47324 L F
.51345 .47313 m .51343 .47324 L .51509 .47124 L F
.51509 .47124 m .51201 .47495 L .51178 .47569 L F
.51201 .47495 m .50975 .47769 L .51178 .47569 L F
.51432 .46847 m .51452 .46754 L p .51439 .46841 L .005 g
F P
0 g
s
.51499 .46791 m .51396 .46824 L .51376 .46894 L .187 g
F
.51396 .46824 m .51317 .4685 L .51376 .46894 L F
.516 .46096 m .516 .46096 L .51599 .46102 L .005 g
F
.516 .46096 m .51599 .46102 L .51599 .46102 L F
.51603 .4608 m .516 .46096 L .516 .46096 L F
.51118 .47386 m .51296 .47175 L p .51162 .47268 L .117 g
F P
0 g
s
.51296 .47175 m .51463 .46976 L p .5131 .47125 L .117 g
F P
0 g
s
.5131 .47125 m .51162 .47268 L .51296 .47175 L .117 g
F
.51346 .47 m .51242 .47054 L .51312 .47118 L F
.51499 .46791 m .51367 .46926 L p .51501 .4692 L F P
0 g
s
.51367 .46926 m .51242 .47054 L p .51346 .47 L .117 g
F P
0 g
s
.51501 .4692 m .51367 .46926 L .51346 .47 L .117 g
F
.51481 .46806 m .51376 .46894 L .51481 .4681 L .187 g
F
.51376 .46894 m .51267 .46985 L .51376 .46896 L F
.51376 .46894 m .51376 .46896 L .51481 .4681 L F
.51599 .46101 m .51603 .4608 L .51599 .46102 L .005 g
F
.51603 .4608 m .51611 .46031 L .51603 .4608 L F
.51533 .47005 m .51246 .47341 L .51533 .4701 L .068 g
F
.51246 .47341 m .51046 .47576 L .51246 .47344 L F
.51246 .47341 m .51246 .47344 L .51533 .4701 L F
.51277 .47238 m .51118 .47386 L .51246 .47341 L F
.51367 .46926 m .51481 .4681 L p .51376 .46896 L .187 g
F P
0 g
s
.51376 .46896 m .51267 .46985 L .51367 .46926 L .187 g
F
.51599 .46102 m .51603 .4608 L .51552 .46268 L .005 g
F
.51603 .4608 m .51611 .46031 L .51556 .46246 L F
.50975 .47769 m .51219 .47436 L p .51046 .47576 L .068 g
F P
0 g
s
.51219 .47436 m .51533 .4701 L p .51246 .47344 L .068 g
F P
0 g
s
.51246 .47344 m .51046 .47576 L .51219 .47436 L .068 g
F
.51296 .47175 m .51118 .47386 L p .51277 .47238 L F P
0 g
s
.51533 .47 m .51296 .47175 L .51277 .47238 L .068 g
F
.51556 .46978 m .51533 .46937 L p .51533 .47 L F P
0 g
s
.51533 .46937 m .51518 .4691 L p .51533 .47 L .068 g
F P
0 g
s
.51533 .4701 m .51556 .46978 L p .51533 .47005 L .068 g
F P
0 g
s
.51609 .46989 m .51508 .47113 L .51509 .47124 L .023 g
F
.51609 .46989 m .51448 .47126 L .5144 .47196 L F
.51497 .46647 m .51518 .46457 L .51497 .46647 L .007 g
F
.51518 .46457 m .51519 .46444 L .51518 .46457 L F
.51481 .4681 m .51499 .46791 L p .51481 .46806 L .187 g
F P
0 g
s
.51463 .46976 m .51518 .4691 L p .51464 .46965 L .117 g
F P
0 g
s
.51519 .46444 m .5152 .46438 L .51519 .46444 L .007 g
F
.51154 .49793 m .5115 .4983 L .50936 .51799 L F
.51046 .47576 m .44515 .55232 L .50975 .47769 L .068 g
F
.51162 .47268 m .44287 .54162 L .51118 .47386 L .117 g
F
.515 .46629 m .51413 .46586 L .51365 .46719 L .234 g
F
.51413 .46586 m .51351 .46555 L .51365 .46719 L F
.51664 .45896 m .51675 .45846 L .51664 .45896 L .005 g
F
.51267 .46985 m .4432 .52789 L .51242 .47054 L .187 g
F
.51657 .45925 m .51657 .45925 L .51656 .45929 L .005 g
F
.51657 .45925 m .51656 .45929 L .51656 .45929 L F
.51664 .45896 m .51657 .45925 L .51657 .45925 L F
.51198 .46888 m .51351 .46756 L p .51236 .46805 L .234 g
F P
0 g
s
.51351 .46756 m .515 .46629 L p .51365 .46719 L .234 g
F P
0 g
s
.51365 .46719 m .51236 .46805 L .51351 .46756 L .234 g
F
.51317 .4685 m .51198 .46888 L .51267 .46985 L .187 g
F
.51656 .45929 m .51664 .45896 L .51656 .45929 L .005 g
F
.51664 .45896 m .51675 .45846 L .51664 .45896 L F
.51432 .46518 m .51538 .46226 L p .51461 .46604 L F P
0 g
s
.515 .46629 m .5152 .46438 L .51449 .46487 L p .234 g
F P
0 g
s
.51449 .46487 m .51351 .46555 L p .51413 .46586 L .234 g
F P
0 g
s
.515 .46629 m .51449 .46487 L .51413 .46586 L .234 g
F
.50797 .48241 m .45679 .5614 L p .50751 .48356 L .005 g
F P
0 g
s
.50975 .47769 m .4499 .5591 L p .50914 .47925 L .023 g
F P
0 g
s
.51631 .46038 m .51631 .46039 L .51608 .46138 L .005 g
F
.51631 .46038 m .51608 .46138 L .51608 .46138 L F
.51646 .45974 m .51631 .46039 L .51631 .46038 L F
.51118 .47386 m .44515 .55232 L p .51046 .47576 L .068 g
F P
0 g
s
.51421 .47381 m .50552 .48895 L p .51418 .47408 L F P
s
.50552 .48895 m .46533 .559 L p .50524 .48963 L F P
s
.51418 .47408 m .50552 .48895 L .50524 .48963 L F
.50878 .53366 m .50883 .52279 L .51125 .50067 L p .01 g
F P
0 g
s
.50878 .53366 m .51125 .50067 L .51222 .49637 L .01 g
F
.51518 .4691 m .51499 .46791 L p .51501 .4692 L .117 g
F P
0 g
s
.51609 .47054 m .51421 .47381 L p .51613 .47069 L F P
s
.51613 .47069 m .51421 .47381 L .51418 .47408 L F
.51673 .46943 m .51609 .47054 L p .51714 .46888 L F P
s
.5116 .4974 m .50936 .51799 L p .51178 .49573 L .007 g
F P
0 g
s
.51646 .45974 m .51656 .45929 L .51646 .45974 L .005 g
F
.51242 .47054 m .44287 .54162 L p .51162 .47268 L .117 g
F P
0 g
s
.51351 .46555 m .44609 .51221 L p .51236 .46805 L .234 g
F P
0 g
s
.51733 .457 m .51745 .45691 L p .51716 .45768 L .005 g
F P
0 g
s
.51727 .45739 m .51734 .45721 L .51727 .45739 L .005 g
F
.51734 .45721 m .51745 .45691 L .51734 .45721 L F
.5152 .46438 m .51558 .46234 L .5148 .46274 L p .263 g
F P
0 g
s
.5148 .46274 m .4513 .49578 L p .51372 .46511 L .263 g
F P
0 g
s
.5152 .46438 m .5148 .46274 L .51372 .46511 L .263 g
F
.51656 .45929 m .51675 .45846 L .51656 .4593 L .005 g
F
.51351 .46756 m .51198 .46888 L p .51317 .4685 L .187 g
F P
0 g
s
.51198 .46888 m .4432 .52789 L p .51081 .4714 L .187 g
F P
0 g
s
.51236 .46805 m .44609 .51221 L .51198 .46888 L .234 g
F
.51662 .45884 m .51659 .45891 L p .51722 .45754 L .005 g
F P
0 g
s
.51719 .45762 m .51722 .45754 L .51659 .45891 L .005 g
F
.51722 .45754 m .51726 .45742 L .51662 .45884 L F
.4513 .49578 m .44609 .51221 L .51351 .46555 L p .263 g
F P
0 g
s
.51351 .46555 m .5152 .46438 L p .51372 .46511 L .263 g
F P
0 g
s
.51372 .46511 m .4513 .49578 L .51351 .46555 L .263 g
F
.51714 .45714 m .51733 .457 L p .517 .4579 L .005 g
F P
0 g
s
.45843 .47979 m .4513 .49578 L .5148 .46274 L p .277 g
F P
0 g
s
.5148 .46274 m .51558 .46234 L p .51489 .46255 L .277 g
F P
0 g
s
.51489 .46255 m .45843 .47979 L .5148 .46274 L .277 g
F
.51745 .45691 m .51675 .45846 L .51665 .45874 L p .005 g
F P
0 g
s
.51726 .45742 m .51745 .45691 L .51665 .45874 L .005 g
F
.53968 .48207 m .53646 .46197 L .51954 .46017 L p .869 g
F P
0 g
s
.50936 .51799 m .50883 .52279 L p .50938 .5178 L .007 g
F P
0 g
s
.53315 .44644 m .53646 .46197 L .57667 .45859 L p .846 g
F P
0 g
s
.57667 .45859 m .56497 .43966 L .53315 .44644 L p .846 g
F P
0 g
s
.56497 .43966 m .57667 .45859 L .61432 .44894 L p .774 g
F P
0 g
s
.61432 .44894 m .59469 .4311 L .56497 .43966 L p .774 g
F P
0 g
s
.59469 .4311 m .61432 .44894 L .62957 .43767 L p .609 g
F P
0 g
s
.65219 .45624 m .62957 .43767 L .61432 .44894 L p .589 g
F P
0 g
s
.54796 .60192 m .54722 .61794 L .61553 .65576 L p .618 g
F P
0 g
s
.6101 .66938 m .61553 .65576 L .54722 .61794 L p .558 g
F P
0 g
s
.61553 .65576 m .6101 .66938 L .67102 .66537 L p .255 g
F P
0 g
s
.67102 .66537 m .68012 .65004 L .61553 .65576 L p .255 g
F P
0 g
s
.67287 .47942 m .69024 .50577 L .65861 .47379 L p .34 g
F P
0 g
s
.69024 .50577 m .70311 .53357 L .6691 .49143 L p .473 g
F P
0 g
s
.6691 .49143 m .65861 .47379 L .69024 .50577 L p .473 g
F P
0 g
s
.68012 .65004 m .67102 .66537 L .6959 .62043 L p .781 g
F P
0 g
s
.6959 .62043 m .70693 .60612 L .68012 .65004 L p .781 g
F P
0 g
s
.65219 .45624 m .67287 .47942 L .6443 .45758 L p .246 g
F P
0 g
s
.65861 .47379 m .6443 .45758 L .67287 .47942 L p .34 g
F P
0 g
s
.70311 .53357 m .71053 .56088 L .67496 .50919 L p .626 g
F P
0 g
s
.67496 .50919 m .6691 .49143 L .70311 .53357 L p .626 g
F P
0 g
s
.2859 .43186 m .2582 .4566 L .29163 .48791 L p .785 g
F P
0 g
s
.29163 .48791 m .31543 .46032 L .2859 .43186 L p .785 g
F P
0 g
s
.27385 .51789 m .29163 .48791 L .2582 .4566 L p .787 g
F P
0 g
s
.31543 .46032 m .29163 .48791 L .36605 .50415 L p .624 g
F P
0 g
s
.29163 .48791 m .27385 .51789 L .35428 .5302 L p .615 g
F P
0 g
s
.35428 .5302 m .36605 .50415 L .29163 .48791 L p .615 g
F P
0 g
s
.31856 .41208 m .2859 .43186 L .31543 .46032 L p .774 g
F P
0 g
s
.31543 .46032 m .3436 .43691 L .31856 .41208 L p .774 g
F P
0 g
s
.3436 .43691 m .31543 .46032 L .38194 .47939 L p .624 g
F P
0 g
s
.36605 .50415 m .38194 .47939 L .31543 .46032 L p .624 g
F P
0 g
s
.38194 .47939 m .36605 .50415 L .4513 .49578 L p .491 g
F P
0 g
s
.36605 .50415 m .35428 .5302 L .44609 .51221 L p .479 g
F P
0 g
s
.44609 .51221 m .4513 .49578 L .36605 .50415 L p .479 g
F P
0 g
s
.52996 .4362 m .53315 .44644 L .56497 .43966 L p .889 g
F P
0 g
s
.56497 .43966 m .55369 .42739 L .52996 .4362 L p .889 g
F P
0 g
s
.55369 .42739 m .56497 .43966 L .59469 .4311 L p .824 g
F P
0 g
s
.62957 .43767 m .65219 .45624 L .62723 .44388 L p .198 g
F P
0 g
s
.6443 .45758 m .62723 .44388 L .65219 .45624 L p .246 g
F P
0 g
s
.38194 .47939 m .40087 .45756 L .3436 .43691 L p .624 g
F P
0 g
s
.40087 .45756 m .38194 .47939 L .45843 .47979 L p .493 g
F P
0 g
s
.4513 .49578 m .45843 .47979 L .38194 .47939 L p .491 g
F P
0 g
s
.34752 .55572 m .35428 .5302 L .27385 .51789 L p .594 g
F P
0 g
s
.35428 .5302 m .34752 .55572 L .4432 .52789 L p .454 g
F P
0 g
s
.4432 .52789 m .44609 .51221 L .35428 .5302 L p .454 g
F P
0 g
s
.59469 .4311 m .5758 .42021 L .55369 .42739 L p .824 g
F P
0 g
s
.5758 .42021 m .59469 .4311 L .60649 .42467 L p .564 g
F P
0 g
s
.62957 .43767 m .60649 .42467 L .59469 .4311 L p .609 g
F P
0 g
s
.71053 .56088 m .71188 .58571 L .6757 .52572 L p .75 g
F P
0 g
s
.6757 .52572 m .67496 .50919 L .71053 .56088 L p .75 g
F P
0 g
s
.2582 .4566 m .23743 .48469 L .27385 .51789 L p .787 g
F P
0 g
s
.26342 .54819 m .27385 .51789 L .23743 .48469 L p .778 g
F P
0 g
s
.27385 .51789 m .26342 .54819 L .34752 .55572 L p .594 g
F P
0 g
s
.35396 .39838 m .31856 .41208 L .3436 .43691 L p .756 g
F P
0 g
s
.3436 .43691 m .37427 .41906 L .35396 .39838 L p .756 g
F P
0 g
s
.37427 .41906 m .3436 .43691 L .40087 .45756 L p .615 g
F P
0 g
s
.54722 .61794 m .54561 .62771 L .6101 .66938 L p .558 g
F P
0 g
s
.60194 .67414 m .6101 .66938 L .54561 .62771 L p .439 g
F P
0 g
s
.6101 .66938 m .60194 .67414 L .6573 .67178 L p .081 g
F P
0 g
s
.6573 .67178 m .67102 .66537 L .6101 .66938 L p .081 g
F P
0 g
s
.40087 .45756 m .42156 .44001 L .37427 .41906 L p .615 g
F P
0 g
s
.42156 .44001 m .40087 .45756 L .46697 .46535 L p .484 g
F P
0 g
s
.45843 .47979 m .46697 .46535 L .40087 .45756 L p .493 g
F P
0 g
s
.53646 .46197 m .53315 .44644 L .5154 .45141 L p .878 g
F P
0 g
s
.34631 .57883 m .34752 .55572 L .26342 .54819 L p .558 g
F P
0 g
s
.34752 .55572 m .34631 .57883 L .44287 .54162 L p .413 g
F P
0 g
s
.44287 .54162 m .4432 .52789 L .34752 .55572 L p .413 g
F P
0 g
s
.23743 .48469 m .22522 .51417 L .26342 .54819 L p .778 g
F P
0 g
s
.26123 .57658 m .26342 .54819 L .22522 .51417 L p .743 g
F P
0 g
s
.26342 .54819 m .26123 .57658 L .34631 .57883 L p .558 g
F P
0 g
s
.60649 .42467 m .62957 .43767 L .6086 .43357 L p .192 g
F P
0 g
s
.62723 .44388 m .6086 .43357 L .62957 .43767 L p .198 g
F P
0 g
s
.3898 .39133 m .35396 .39838 L .37427 .41906 L p .726 g
F P
0 g
s
.37427 .41906 m .40546 .40767 L .3898 .39133 L p .726 g
F P
0 g
s
.40546 .40767 m .37427 .41906 L .42156 .44001 L p .595 g
F P
0 g
s
.71188 .58571 m .70693 .60612 L .67118 .53971 L p .81 g
F P
0 g
s
.67118 .53971 m .6757 .52572 L .71188 .58571 L p .81 g
F P
0 g
s
.67102 .66537 m .6573 .67178 L .67945 .62736 L p .934 g
F P
0 g
s
.67945 .62736 m .6959 .62043 L .67102 .66537 L p .934 g
F P
0 g
s
.42156 .44001 m .44266 .42768 L .40546 .40767 L p .595 g
F P
0 g
s
.44266 .42768 m .42156 .44001 L .47633 .45339 L p .462 g
F P
0 g
s
.46697 .46535 m .47633 .45339 L .42156 .44001 L p .484 g
F P
0 g
s
.35086 .59773 m .34631 .57883 L .26123 .57658 L p .492 g
F P
0 g
s
.34631 .57883 m .35086 .59773 L .44515 .55232 L p .348 g
F P
0 g
s
.44515 .55232 m .44287 .54162 L .34631 .57883 L p .348 g
F P
0 g
s
.5271 .43139 m .52996 .4362 L .55369 .42739 L p .928 g
F P
0 g
s
.55369 .42739 m .54352 .42199 L .5271 .43139 L p .928 g
F P
0 g
s
.54352 .42199 m .55369 .42739 L .5758 .42021 L p .859 g
F P
0 g
s
.5758 .42021 m .55879 .41632 L .54352 .42199 L p .859 g
F P
0 g
s
.55879 .41632 m .5758 .42021 L .58438 .41772 L p .013 g
F P
0 g
s
.60649 .42467 m .58438 .41772 L .5758 .42021 L p .564 g
F P
0 g
s
.34116 .39711 m .31169 .40989 L .2859 .43186 L p .688 g
F P
0 g
s
.31169 .40989 m .28669 .42746 L .28041 .43388 L p F P
s
.2859 .43186 m .31856 .41208 L p .30535 .41963 L .688 g
F P
0 g
s
.2859 .43186 m .31169 .40989 L p .27354 .4432 L F P
s
.2582 .4566 m .27575 .44093 L p .27354 .4432 L F P
s
.27575 .44093 m .2859 .43186 L p .27354 .4432 L F P
s
.28041 .43388 m .2582 .4566 L p .29141 .4276 L F P
s
.29141 .4276 m .31169 .40989 L .28041 .43388 L F
.2582 .4566 m .28669 .42746 L p .2462 .47449 L F P
s
.23743 .48469 m .24319 .4769 L p .2462 .47449 L F P
s
.24319 .4769 m .2582 .4566 L p .2462 .47449 L F P
s
.25728 .472 m .22522 .51417 L p .25656 .46624 L .008 g
F P
0 g
s
.28669 .42746 m .26805 .44866 L .26683 .4501 L p F P
s
.26683 .4501 m .23743 .48469 L p .27005 .44679 L F P
s
.27005 .44679 m .28669 .42746 L .26683 .4501 L F
.26805 .44866 m .26191 .46198 L p .25656 .46624 L .008 g
F P
0 g
s
.26191 .46198 m .25728 .472 L p .25656 .46624 L .008 g
F P
0 g
s
.31856 .41208 m .34116 .39711 L p .30535 .41963 L .688 g
F P
0 g
s
.31856 .41208 m .31856 .41208 L p .30535 .41963 L .688 g
F P
0 g
s
.51679 .44608 m .5154 .45141 L .53315 .44644 L p .874 g
F P
0 g
s
.53315 .44644 m .52996 .4362 L .51679 .44608 L p .874 g
F P
0 g
s
.37301 .38979 m .34116 .39711 L .31856 .41208 L p .643 g
F P
0 g
s
.31856 .41208 m .35396 .39838 L .36749 .39227 L p .643 g
F P
0 g
s
.31856 .41208 m .36749 .39227 L .36365 .39362 L .643 g
F
.42385 .39089 m .3898 .39133 L .40546 .40767 L p .678 g
F P
0 g
s
.40546 .40767 m .43524 .40302 L .42385 .39089 L p .678 g
F P
0 g
s
.43524 .40302 m .40546 .40767 L .44266 .42768 L p .56 g
F P
0 g
s
.43076 .40506 m .41118 .4069 L .3501 .39836 L p .331 g
F P
0 g
s
.3501 .39836 m .34116 .39711 L p .35114 .398 L .331 g
F P
0 g
s
.40513 .3881 m .37301 .38979 L .35396 .39838 L p .53 g
F P
0 g
s
.35396 .39838 m .3898 .39133 L .39671 .38987 L p .53 g
F P
0 g
s
.39671 .38987 m .40513 .3881 L p .38812 .39151 L .53 g
F P
0 g
s
.35396 .39838 m .39671 .38987 L .38812 .39151 L .53 g
F
.35114 .398 m .35328 .39819 L .3501 .39836 L .331 g
F
.35328 .39819 m .43076 .40506 L .35169 .39849 L F
.35328 .39819 m .35169 .39849 L .3501 .39836 L F
.36749 .39227 m .37301 .38979 L p .36365 .39362 L .643 g
F P
0 g
s
.22522 .51417 m .22265 .54285 L .26123 .57658 L p .743 g
F P
0 g
s
.26765 .60085 m .26123 .57658 L .22265 .54285 L p .629 g
F P
0 g
s
.26123 .57658 m .26765 .60085 L .35086 .59773 L p .492 g
F P
0 g
s
.54561 .62771 m .54326 .63036 L .60194 .67414 L p .439 g
F P
0 g
s
.58438 .41772 m .60649 .42467 L .58967 .42713 L p .216 g
F P
0 g
s
.6086 .43357 m .58967 .42713 L .60649 .42467 L p .192 g
F P
0 g
s
.59158 .66942 m .60194 .67414 L .54326 .63036 L p .215 g
F P
0 g
s
.60194 .67414 m .59158 .66942 L .63985 .66855 L p .621 g
F P
0 g
s
.63985 .66855 m .6573 .67178 L .60194 .67414 L p .621 g
F P
0 g
s
.70693 .60612 m .6959 .62043 L .66168 .55001 L p .82 g
F P
0 g
s
.66168 .55001 m .67118 .53971 L .70693 .60612 L p .82 g
F P
0 g
s
.44266 .42768 m .46284 .42101 L .43524 .40302 L p .56 g
F P
0 g
s
.46284 .42101 m .44266 .42768 L .48586 .44459 L p .423 g
F P
0 g
s
.47633 .45339 m .48586 .44459 L .44266 .42768 L p .462 g
F P
0 g
s
.36098 .61085 m .35086 .59773 L .26765 .60085 L p .368 g
F P
0 g
s
.35086 .59773 m .36098 .61085 L .4499 .5591 L p .243 g
F P
0 g
s
.4499 .5591 m .44515 .55232 L .35086 .59773 L p .243 g
F P
0 g
s
.22522 .51417 m .23743 .48469 L .26805 .44866 L p .008 g
F P
0 g
s
.6573 .67178 m .63985 .66855 L .65874 .62626 L p .877 g
F P
0 g
s
.65874 .62626 m .67945 .62736 L .6573 .67178 L p .877 g
F P
0 g
s
.46697 .46535 m .45843 .47979 L .51611 .46031 L p .276 g
F P
0 g
s
.51558 .46234 m .51611 .46031 L .45843 .47979 L p .277 g
F P
0 g
s
.45417 .39639 m .42385 .39089 L .43524 .40302 L p .596 g
F P
0 g
s
.43524 .40302 m .46187 .40472 L .45417 .39639 L p .596 g
F P
0 g
s
.47923 .40655 m .45417 .39639 L .46187 .40472 L p .453 g
F P
0 g
s
.46187 .40472 m .48397 .41173 L .47923 .40655 L p .453 g
F P
0 g
s
.45417 .39639 m .47493 .40481 L p .46549 .40187 L .156 g
F P
0 g
s
.46236 .39977 m .45417 .39639 L p .46549 .40187 L .156 g
F P
0 g
s
.49812 .41956 m .47923 .40655 L .48397 .41173 L p .255 g
F P
0 g
s
.47923 .40655 m .48444 .41102 L p .46549 .40187 L .156 g
F P
0 g
s
.47493 .40481 m .47923 .40655 L p .46549 .40187 L .156 g
F P
0 g
s
.48444 .41102 m .46236 .39977 L p .46549 .40187 L .156 g
F P
0 g
s
.42385 .39089 m .45417 .39639 L .45433 .39646 L p .092 g
F P
0 g
s
.45433 .39646 m .46236 .39977 L p .45039 .39701 L .092 g
F P
0 g
s
.43903 .39439 m .45385 .3964 L .45039 .39701 L .092 g
F
.45385 .3964 m .45433 .39646 L .45039 .39701 L F
.46187 .40472 m .43524 .40302 L .46284 .42101 L p .502 g
F P
0 g
s
.46284 .42101 m .48089 .41985 L .46187 .40472 L p .502 g
F P
0 g
s
.48397 .41173 m .46187 .40472 L .48089 .41985 L p .411 g
F P
0 g
s
.48089 .41985 m .49586 .42348 L .48397 .41173 L p .411 g
F P
0 g
s
.48547 .41833 m .46908 .41131 L .44594 .39781 L p .403 g
F P
0 g
s
.42385 .39089 m .45433 .39646 L .43903 .39439 L .092 g
F
.46236 .39977 m .43549 .39171 L .43223 .39148 L p F P
0 g
s
.43223 .39148 m .42385 .39089 L p .44871 .39663 L .092 g
F P
0 g
s
.44871 .39663 m .46236 .39977 L .43223 .39148 L .092 g
F
.44594 .39781 m .43549 .39171 L p .44669 .39767 L .403 g
F P
0 g
s
.44669 .39767 m .48547 .41833 L .44594 .39781 L .403 g
F
.43549 .39171 m .40513 .3881 L .4002 .38914 L p .02 g
F P
0 g
s
.46908 .41131 m .45049 .40666 L .41554 .39236 L p .371 g
F P
0 g
s
.42385 .39089 m .42818 .39119 L p .3898 .39133 L .02 g
F P
0 g
s
.3898 .39133 m .42818 .39119 L .42368 .39161 L .02 g
F
.4002 .38914 m .3898 .39133 L p .41813 .39156 L F P
0 g
s
.42818 .39119 m .43549 .39171 L p .42368 .39161 L .02 g
F P
0 g
s
.41813 .39156 m .43549 .39171 L .4002 .38914 L .02 g
F
.41554 .39236 m .40513 .3881 L p .4166 .39226 L .371 g
F P
0 g
s
.4166 .39226 m .46908 .41131 L .41554 .39236 L .371 g
F
.22265 .54285 m .23019 .56847 L .26765 .60085 L p .629 g
F P
0 g
s
.28245 .619 m .26765 .60085 L .23019 .56847 L p .3 g
F P
0 g
s
.26765 .60085 m .28245 .619 L .36098 .61085 L p .368 g
F P
0 g
s
.52996 .4362 m .5271 .43139 L .51803 .44363 L p .848 g
F P
0 g
s
.51906 .44438 m .52355 .441 L p .52028 .44256 L .848 g
F P
0 g
s
.52333 .44061 m .51803 .44363 L .52355 .441 L .848 g
F
.52513 .43921 m .51803 .44363 L .52643 .43885 L F
.52418 .43748 m .52168 .44219 L p .52525 .43517 L 0 g
F P
s
.52471 .43158 m .5271 .43139 L .53339 .42779 L p .929 g
F P
0 g
s
.53339 .42779 m .54352 .42199 L p .53177 .42798 L .929 g
F P
0 g
s
.53177 .42798 m .52471 .43158 L .53339 .42779 L .929 g
F
.52028 .44256 m .51803 .44363 L .51906 .44438 L .848 g
F
.52168 .44219 m .52031 .4493 L p .52178 .44155 L 0 g
F P
s
.52238 .43775 m .52445 .43496 L p .52226 .43854 L .792 g
F P
0 g
s
.52354 .43687 m .51904 .44378 L .52445 .43496 L .792 g
F
.51904 .44378 m .51803 .44363 L .52238 .43775 L p F P
0 g
s
.52226 .43854 m .51904 .44378 L .52238 .43775 L .792 g
F
.52445 .43496 m .5271 .43139 L p .52354 .43687 L F P
0 g
s
.5271 .43139 m .52471 .43158 L .52058 .44047 L p .792 g
F P
0 g
s
.5271 .43139 m .52058 .44047 L .52133 .44026 L .792 g
F
.52058 .44047 m .51904 .44378 L p .52133 .44026 L F P
0 g
s
.5198 .44595 m .51904 .44378 L .52144 .43861 L p .707 g
F P
0 g
s
.52144 .43861 m .52471 .43158 L p .52298 .43665 L .707 g
F P
0 g
s
.52298 .43665 m .5198 .44595 L .52144 .43861 L .707 g
F
.52289 .4357 m .52208 .43841 L p .52293 .43618 L F P
0 g
s
.52471 .43158 m .52289 .4357 L p .52293 .43618 L .707 g
F P
0 g
s
.52471 .43158 m .52208 .43841 L .52226 .43874 L .707 g
F
.54352 .42199 m .53501 .42288 L .52471 .43158 L p .929 g
F P
0 g
s
.52289 .4357 m .52471 .43158 L .52799 .4288 L p .831 g
F P
0 g
s
.52799 .4288 m .53154 .42581 L p .52691 .43144 L .831 g
F P
0 g
s
.5327 .42532 m .52691 .43144 L .53154 .42581 L .831 g
F
.53154 .42581 m .53501 .42288 L p .5327 .42532 L F P
0 g
s
.53501 .42288 m .52899 .4283 L p .53 .42818 L .831 g
F P
0 g
s
.52899 .4283 m .52853 .42871 L p .53 .42818 L .831 g
F P
0 g
s
.53376 .42599 m .52853 .42871 L p .53664 .42367 L F P
s
.54352 .42199 m .55879 .41632 L p .53755 .42218 L .792 g
F P
0 g
s
.53501 .42288 m .53629 .42274 L p .53755 .42218 L .792 g
F P
0 g
s
.53629 .42274 m .54352 .42199 L p .53755 .42218 L .792 g
F P
0 g
s
.55879 .41632 m .54457 .41874 L .53501 .42288 L p .792 g
F P
0 g
s
.54293 .41976 m .53817 .42303 L .53664 .42367 L F
.54457 .41874 m .54329 .4196 L p .54293 .41976 L F P
s
.54329 .4196 m .53817 .42303 L p .54293 .41976 L F P
s
.53817 .42303 m .53376 .42599 L p .53664 .42367 L F P
s
.52691 .43144 m .52289 .4357 L .52799 .4288 L .831 g
F
.52598 .43373 m .52557 .43469 L .52525 .43517 L 0 g
F
.52853 .42871 m .52289 .4357 L p .52775 .43056 L .831 g
F P
0 g
s
.52853 .42871 m .52567 .43448 L p .52598 .43373 L F P
s
.52567 .43448 m .52557 .43469 L p .52598 .43373 L F P
s
.53 .42818 m .52946 .42838 L .52775 .43056 L .831 g
F
.52946 .42838 m .52853 .42871 L .52775 .43056 L F
.52289 .4357 m .52169 .44209 L p .52178 .44155 L 0 g
F P
s
.52169 .44209 m .52168 .44219 L p .52178 .44155 L F P
s
.52557 .43469 m .52418 .43748 L p .52525 .43517 L F P
s
.51803 .44363 m .51679 .44608 L .51906 .44438 L p .848 g
F P
0 g
s
.52355 .441 m .52643 .43885 L p .52333 .44061 L .848 g
F P
0 g
s
.52208 .43841 m .5198 .44595 L p .52226 .43874 L .707 g
F P
0 g
s
.52643 .43885 m .52996 .4362 L p .52513 .43921 L .848 g
F P
0 g
s
.58438 .41772 m .56458 .41667 L .55879 .41632 L p .013 g
F P
0 g
s
.56458 .41667 m .58438 .41772 L .57166 .42471 L p .26 g
F P
0 g
s
.58967 .42713 m .57166 .42471 L .58438 .41772 L p .216 g
F P
0 g
s
.54326 .63036 m .54031 .62553 L .59158 .66942 L p .215 g
F P
0 g
s
.22265 .54285 m .22522 .51417 L .25728 .472 L p .048 g
F P
0 g
s
.51739 .45695 m .51393 .45958 L p .51802 .45587 L .006 g
F P
0 g
s
.51802 .45587 m .51816 .45574 L .51739 .45695 L .006 g
F
.51393 .45958 m .5154 .45141 L .51816 .45574 L p F P
0 g
s
.51745 .45691 m .47633 .45339 L p .51654 .45843 L .262 g
F P
0 g
s
.51675 .45846 m .51745 .45691 L p .51654 .45843 L .262 g
F P
0 g
s
.51745 .45691 m .51739 .45695 L p .51799 .45602 L .006 g
F P
0 g
s
.51816 .45574 m .51745 .45691 L p .51799 .45602 L .006 g
F P
0 g
s
.47633 .45339 m .46697 .46535 L .5165 .4585 L p .262 g
F P
0 g
s
.5165 .4585 m .51675 .45846 L p .51654 .45843 L .262 g
F P
0 g
s
.51654 .45843 m .47633 .45339 L .5165 .4585 L .262 g
F
.51611 .46031 m .51675 .45846 L .46697 .46535 L p .276 g
F P
0 g
s
.54457 .41874 m .55879 .41632 L .56458 .41667 L p .088 g
F P
0 g
s
.6959 .62043 m .67945 .62736 L .64785 .55575 L p .804 g
F P
0 g
s
.64785 .55575 m .66168 .55001 L .6959 .62043 L p .804 g
F P
0 g
s
.48089 .41985 m .46284 .42101 L .49495 .43928 L p .363 g
F P
0 g
s
.48586 .44459 m .49495 .43928 L .46284 .42101 L p .423 g
F P
0 g
s
.62723 .44388 m .6443 .45758 L .56191 .45199 L p .527 g
F P
0 g
s
.6443 .45758 m .65861 .47379 L .5667 .45625 L p .564 g
F P
0 g
s
.57015 .46107 m .5667 .45625 L .56767 .45643 L p .6 g
F P
0 g
s
.56767 .45643 m .65861 .47379 L p .57015 .46107 L .6 g
F P
0 g
s
.57198 .4661 m .57015 .46107 L .57115 .46138 L p .633 g
F P
0 g
s
.57115 .46138 m .6691 .49143 L p .57198 .4661 L .633 g
F P
0 g
s
.57205 .47093 m .57198 .4661 L .57302 .46653 L p .659 g
F P
0 g
s
.57302 .46653 m .67496 .50919 L p .57205 .47093 L .659 g
F P
0 g
s
.57034 .47517 m .57205 .47093 L .57313 .4715 L p .676 g
F P
0 g
s
.57313 .4715 m .6757 .52572 L p .57034 .47517 L .676 g
F P
0 g
s
.56698 .47848 m .57034 .47517 L .57148 .4759 L p .684 g
F P
0 g
s
.57148 .4759 m .67118 .53971 L p .56698 .47848 L .684 g
F P
0 g
s
.56223 .4806 m .56698 .47848 L .56818 .47939 L p .686 g
F P
0 g
s
.56818 .47939 m .66168 .55001 L p .56223 .4806 L .686 g
F P
0 g
s
.55647 .48138 m .56223 .4806 L .5635 .48171 L p .681 g
F P
0 g
s
.5635 .48171 m .64785 .55575 L p .55647 .48138 L .681 g
F P
0 g
s
.55014 .48079 m .55647 .48138 L .55779 .48271 L p .672 g
F P
0 g
s
.55779 .48271 m .63073 .55648 L p .55014 .48079 L .672 g
F P
0 g
s
.5437 .47895 m .55014 .48079 L .5515 .48237 L p .66 g
F P
0 g
s
.5515 .48237 m .61162 .55221 L p .5437 .47895 L .66 g
F P
0 g
s
.53759 .47608 m .5437 .47895 L .59196 .54343 L p .644 g
F P
0 g
s
.5437 .47895 m .53759 .47608 L .5383 .47659 L p .365 g
F P
0 g
s
.61162 .55221 m .59196 .54343 L .5437 .47895 L p .66 g
F P
0 g
s
.5383 .47659 m .55042 .48512 L p .5437 .47895 L .365 g
F P
0 g
s
.55014 .48079 m .5437 .47895 L .54444 .47936 L p .365 g
F P
0 g
s
.63073 .55648 m .61162 .55221 L .55014 .48079 L p .672 g
F P
0 g
s
.54444 .47936 m .56117 .48856 L p .55014 .48079 L .365 g
F P
0 g
s
.55647 .48138 m .55014 .48079 L .5509 .48111 L p .377 g
F P
0 g
s
.64785 .55575 m .63073 .55648 L .55647 .48138 L p .681 g
F P
0 g
s
.5509 .48111 m .57253 .49021 L p .55647 .48138 L .377 g
F P
0 g
s
.56223 .4806 m .55647 .48138 L .55724 .48162 L p .396 g
F P
0 g
s
.67118 .53971 m .66168 .55001 L .56698 .47848 L p .684 g
F P
0 g
s
.66168 .55001 m .64785 .55575 L .56223 .4806 L p .686 g
F P
0 g
s
.55724 .48162 m .58368 .4898 L p .56223 .4806 L .396 g
F P
0 g
s
.56698 .47848 m .56223 .4806 L .563 .48076 L p .42 g
F P
0 g
s
.6757 .52572 m .67118 .53971 L .57034 .47517 L p .676 g
F P
0 g
s
.563 .48076 m .59381 .48724 L p .56698 .47848 L .42 g
F P
0 g
s
.57034 .47517 m .56698 .47848 L .56775 .47858 L p .446 g
F P
0 g
s
.67496 .50919 m .6757 .52572 L .57205 .47093 L p .659 g
F P
0 g
s
.56775 .47858 m .60213 .48267 L p .57034 .47517 L .446 g
F P
0 g
s
.57205 .47093 m .57034 .47517 L .57111 .4752 L p .472 g
F P
0 g
s
.6691 .49143 m .67496 .50919 L .57198 .4661 L p .633 g
F P
0 g
s
.57111 .4752 m .60798 .47642 L p .57205 .47093 L .472 g
F P
0 g
s
.57198 .4661 m .57205 .47093 L .57283 .47089 L p .499 g
F P
0 g
s
.65861 .47379 m .6691 .49143 L .57015 .46107 L p .6 g
F P
0 g
s
.57283 .47089 m .61091 .469 L p .57198 .4661 L .499 g
F P
0 g
s
.57015 .46107 m .57198 .4661 L .57277 .466 L p .524 g
F P
0 g
s
.57277 .466 m .6107 .461 L p .57015 .46107 L .524 g
F P
0 g
s
.5667 .45625 m .57015 .46107 L .57095 .4609 L p .548 g
F P
0 g
s
.56287 .45206 m .6443 .45758 L p .5667 .45625 L .564 g
F P
0 g
s
.57095 .4609 m .60739 .45308 L p .5667 .45625 L .548 g
F P
0 g
s
.5667 .45625 m .56191 .45199 L .56287 .45206 L p .564 g
F P
0 g
s
.37601 .61704 m .36098 .61085 L .28245 .619 L p .138 g
F P
0 g
s
.36098 .61085 m .37601 .61704 L .45679 .5614 L p .107 g
F P
0 g
s
.45679 .5614 m .4499 .5591 L .36098 .61085 L p .107 g
F P
0 g
s
.6086 .43357 m .62723 .44388 L .55616 .44862 L p .496 g
F P
0 g
s
.56191 .45199 m .5667 .45625 L .56753 .456 L p .571 g
F P
0 g
s
.5571 .44856 m .55998 .44837 L p .56191 .45199 L .527 g
F P
0 g
s
.55998 .44837 m .62723 .44388 L p .56338 .45181 L .527 g
F P
0 g
s
.56191 .45199 m .55998 .44837 L .56338 .45181 L .527 g
F
.60739 .45308 m .60127 .44586 L .56753 .456 L p .548 g
F P
0 g
s
.56753 .456 m .5667 .45625 L p .5677 .45617 L .548 g
F P
0 g
s
.60739 .45308 m .56753 .456 L .5677 .45617 L .548 g
F
.56753 .456 m .60127 .44586 L p .56191 .45199 L .571 g
F P
0 g
s
.56191 .45199 m .55616 .44862 L .5571 .44856 L p .527 g
F P
0 g
s
.57974 .65545 m .59158 .66942 L .54031 .62553 L p .246 g
F P
0 g
s
.59158 .66942 m .57974 .65545 L .61992 .65579 L p .729 g
F P
0 g
s
.61992 .65579 m .63985 .66855 L .59158 .66942 L p .729 g
F P
0 g
s
.48586 .44459 m .47633 .45339 L .51745 .45691 L p .233 g
F P
0 g
s
.58967 .42713 m .6086 .43357 L .54988 .44633 L p .472 g
F P
0 g
s
.55616 .44862 m .54988 .44633 L .6086 .43357 L p .496 g
F P
0 g
s
.25728 .472 m .25537 .49568 L .22265 .54285 L p .048 g
F P
0 g
s
.23019 .56847 m .22265 .54285 L .25537 .49568 L p .208 g
F P
0 g
s
.56458 .41667 m .54812 .42071 L .54457 .41874 L p .088 g
F P
0 g
s
.54812 .42071 m .56458 .41667 L .55564 .42601 L p .317 g
F P
0 g
s
.57166 .42471 m .55564 .42601 L .56458 .41667 L p .26 g
F P
0 g
s
.23019 .56847 m .24749 .58889 L .28245 .619 L p .3 g
F P
0 g
s
.28245 .619 m .3047 .62943 L .37601 .61704 L p .138 g
F P
0 g
s
.3047 .62943 m .28245 .619 L .24749 .58889 L p .322 g
F P
0 g
s
.63985 .66855 m .61992 .65579 L .63529 .61719 L p .808 g
F P
0 g
s
.63529 .61719 m .65874 .62626 L .63985 .66855 L p .808 g
F P
0 g
s
.49495 .43928 m .48586 .44459 L .51816 .45574 L p .185 g
F P
0 g
s
.51745 .45691 m .51816 .45574 L .48586 .44459 L p .233 g
F P
0 g
s
.34116 .39711 m .37301 .38979 L .43076 .40506 L p .331 g
F P
0 g
s
.31169 .40989 m .34116 .39711 L .41118 .4069 L p .328 g
F P
0 g
s
.51091 .54736 m .51221 .54434 L .54031 .62553 L p .475 g
F P
0 g
s
.54031 .62553 m .53698 .61355 L .57974 .65545 L p .246 g
F P
0 g
s
.45049 .40666 m .43076 .40506 L .37301 .38979 L p .346 g
F P
0 g
s
.37301 .38979 m .40513 .3881 L .45049 .40666 L p .346 g
F P
0 g
s
.49586 .42348 m .48089 .41985 L .50305 .43744 L p .273 g
F P
0 g
s
.49495 .43928 m .50305 .43744 L .48089 .41985 L p .363 g
F P
0 g
s
.41118 .4069 m .39311 .41227 L .31169 .40989 L p .328 g
F P
0 g
s
.28669 .42746 m .31169 .40989 L .39311 .41227 L p .337 g
F P
0 g
s
.67945 .62736 m .65874 .62626 L .63073 .55648 L p .778 g
F P
0 g
s
.63073 .55648 m .64785 .55575 L .67945 .62736 L p .778 g
F P
0 g
s
.57166 .42471 m .58967 .42713 L .54351 .44523 L p .458 g
F P
0 g
s
.54988 .44633 m .54351 .44523 L .58967 .42713 L p .472 g
F P
0 g
s
.52853 .42871 m .53501 .42288 L .54457 .41874 L p F P
s
.53376 .42599 m .54457 .41874 L .54812 .42071 L p .137 g
F P
0 g
s
.39492 .61571 m .37601 .61704 L .3047 .62943 L p .015 g
F P
0 g
s
.37601 .61704 m .39492 .61571 L .46533 .559 L p .011 g
F P
0 g
s
.46533 .559 m .45679 .5614 L .37601 .61704 L p .011 g
F P
0 g
s
.40513 .3881 m .43549 .39171 L .46908 .41131 L p .371 g
F P
0 g
s
.4499 .5591 m .45679 .5614 L .51609 .46989 L p .023 g
F P
0 g
s
.39311 .41227 m .37788 .4209 L .28669 .42746 L p .337 g
F P
0 g
s
.26805 .44866 m .28669 .42746 L .37788 .4209 L p .357 g
F P
0 g
s
.51884 .455 m .51816 .45574 L .5154 .45141 L p .008 g
F P
0 g
s
.51679 .44608 m .51803 .44363 L .51929 .45357 L p .01 g
F P
0 g
s
.51991 .45477 m .51943 .4547 L .51941 .45453 L p .012 g
F P
0 g
s
.52051 .45565 m .52027 .45513 L .52026 .45485 L p .017 g
F P
0 g
s
.52026 .45485 m .5198 .44595 L p .52051 .45565 L .017 g
F P
0 g
s
.52064 .45618 m .52058 .45595 L p .52031 .4493 L .018 g
F P
0 g
s
.52058 .45595 m .52051 .45565 L .5205 .45537 L p .018 g
F P
0 g
s
.5205 .45537 m .52031 .4493 L p .52058 .45595 L .018 g
F P
0 g
s
.51904 .44378 m .51968 .44558 L p .52025 .45474 L .015 g
F P
0 g
s
.51968 .44558 m .5198 .44595 L .51998 .44947 L p .015 g
F P
0 g
s
.51998 .44947 m .52025 .45474 L p .51968 .44558 L .015 g
F P
0 g
s
.51904 .44378 m .52025 .45474 L .52025 .45475 L .015 g
F
.51904 .44378 m .52026 .45485 L .52025 .45488 L F
.52025 .45474 m .52026 .45485 L p .52025 .45475 L F P
0 g
s
.51935 .4541 m .51803 .44363 L p .51988 .45458 L .012 g
F P
0 g
s
.52027 .45513 m .51991 .45477 L .51904 .44378 L p .015 g
F P
0 g
s
.52033 .45499 m .52006 .45404 L p .52021 .45488 L .043 g
F P
0 g
s
.51803 .44363 m .51904 .44378 L .51987 .45429 L p .012 g
F P
0 g
s
.51987 .45429 m .51989 .45454 L p .51986 .45434 L .012 g
F P
0 g
s
.51803 .44363 m .51987 .45429 L .51986 .45434 L .012 g
F
.51803 .44363 m .51989 .45454 L .51988 .45458 L F
.51807 .44692 m .51982 .45152 L p .51887 .448 L .048 g
F P
0 g
s
.51982 .45152 m .51989 .45172 L .51983 .45149 L p .048 g
F P
0 g
s
.51983 .45149 m .51887 .448 L p .51982 .45152 L .048 g
F P
0 g
s
.5198 .44595 m .52031 .4493 L .52051 .45557 L p .017 g
F P
0 g
s
.52051 .45557 m .52051 .45565 L p .52051 .45558 L .017 g
F P
0 g
s
.5198 .44595 m .52051 .45557 L .52051 .45558 L .017 g
F
.51989 .45172 m .52057 .45521 L p .52046 .45434 L .043 g
F P
0 g
s
.52057 .45521 m .52059 .45535 L .52057 .45517 L p .043 g
F P
0 g
s
.52057 .45517 m .52046 .45434 L p .52057 .45521 L .043 g
F P
0 g
s
.51989 .45172 m .51807 .44692 L .52051 .45565 L p .034 g
F P
0 g
s
.52046 .45434 m .51887 .448 L .51989 .45172 L p .043 g
F P
0 g
s
.52019 .45314 m .52043 .45419 L .52035 .45375 L .045 g
F
.51887 .448 m .52018 .4532 L p .52019 .45314 L F P
0 g
s
.52018 .4532 m .52043 .45419 L p .52019 .45314 L .045 g
F P
0 g
s
.52006 .45404 m .51807 .44692 L p .52002 .45417 L .043 g
F P
0 g
s
.52021 .45488 m .52006 .45404 L .52002 .45417 L .043 g
F
.51989 .45454 m .51991 .45477 L p .51988 .45458 L .012 g
F P
0 g
s
.51911 .45086 m .51804 .44709 L p .52033 .4547 L .524 g
F P
0 g
s
.51474 .44217 m .51807 .44692 L .51472 .43942 L p .061 g
F P
0 g
s
.51679 .44608 m .51929 .45357 L .5192 .45388 L .01 g
F
.51679 .44608 m .51941 .45453 L .51939 .45459 L F
.5154 .45141 m .51679 .44608 L .51875 .45465 L p .008 g
F P
0 g
s
.51875 .45465 m .51881 .45491 L p .51872 .45481 L .008 g
F P
0 g
s
.5154 .45141 m .51875 .45465 L .51872 .45481 L .008 g
F
.51963 .45362 m .51918 .45258 L p .51956 .45391 L .052 g
F P
0 g
s
.51943 .4547 m .51884 .455 L .51679 .44608 L p .01 g
F P
0 g
s
.51918 .45258 m .51474 .44217 L p .51913 .45286 L .052 g
F P
0 g
s
.51956 .45391 m .51918 .45258 L .51913 .45286 L .052 g
F
.51807 .44692 m .51474 .44217 L .52027 .45513 L p .043 g
F P
0 g
s
.50068 .42236 m .51184 .43447 L .51071 .43324 L p .055 g
F P
0 g
s
.51184 .43447 m .50068 .42236 L .50717 .43058 L p .121 g
F P
0 g
s
.50717 .43058 m .51472 .43942 L .51184 .43447 L p .121 g
F P
0 g
s
.51472 .43942 m .50717 .43058 L .51474 .44217 L p .061 g
F P
0 g
s
.51804 .44709 m .51201 .43645 L .51071 .43324 L p .516 g
F P
0 g
s
.51472 .43942 m .51887 .448 L .51798 .4457 L p .054 g
F P
0 g
s
.51472 .43942 m .51807 .44692 L p .51885 .44798 L .048 g
F P
0 g
s
.51887 .448 m .51883 .44792 L p .51885 .44798 L .048 g
F P
0 g
s
.51883 .44792 m .51472 .43942 L p .51885 .44798 L .048 g
F P
0 g
s
.52022 .45341 m .51989 .45172 L .52012 .45307 L p .031 g
F P
0 g
s
.52012 .45307 m .52064 .45618 L p .52022 .45341 L .031 g
F P
0 g
s
.52059 .45535 m .52022 .45341 L p .52064 .45618 L .031 g
F P
0 g
s
.52031 .45371 m .51764 .44532 L .51793 .44563 L p .608 g
F P
0 g
s
.51793 .44563 m .51798 .4457 L p .51807 .446 L .608 g
F P
0 g
s
.51807 .446 m .52031 .45371 L .51793 .44563 L .608 g
F
.51071 .43324 m .51764 .44532 L .51804 .44709 L p .516 g
F P
0 g
s
.51201 .43645 m .51804 .44709 L .51911 .45086 L p .521 g
F P
0 g
s
.51798 .4457 m .52035 .45375 L .52031 .45371 L p .608 g
F P
0 g
s
.52035 .45375 m .51798 .4457 L .51887 .448 L p .045 g
F P
0 g
s
.52036 .45423 m .51804 .44709 L .51764 .44532 L p .538 g
F P
0 g
s
.52037 .45459 m .51989 .45172 L p .52035 .45464 L .034 g
F P
0 g
s
.51764 .44532 m .52031 .45371 L .52036 .45423 L p .538 g
F P
0 g
s
.52051 .45565 m .52037 .45459 L .52035 .45464 L .034 g
F
.51804 .44709 m .52036 .45423 L .52049 .45524 L p .524 g
F P
0 g
s
.51958 .45178 m .51881 .44675 L p .51714 .4458 L .577 g
F P
0 g
s
.51704 .44573 m .51761 .4471 L p .51714 .4458 L .577 g
F P
0 g
s
.51761 .4471 m .51958 .45178 L p .51714 .4458 L .577 g
F P
0 g
s
.52033 .4547 m .52042 .455 L .52029 .45459 L .524 g
F
.52033 .4547 m .52029 .45459 L .51911 .45086 L F
.52059 .45591 m .52037 .45459 L p .52051 .45565 L .034 g
F P
0 g
s
.52049 .45524 m .52042 .45501 L p .52042 .455 L .524 g
F P
0 g
s
.52042 .45501 m .51911 .45086 L p .52042 .455 L .524 g
F P
0 g
s
.52043 .45419 m .52046 .45434 L .52043 .45417 L p .045 g
F P
0 g
s
.52043 .45417 m .52035 .45375 L p .52043 .45419 L .045 g
F P
0 g
s
.52026 .45485 m .52027 .45513 L p .52025 .45488 L .015 g
F P
0 g
s
.52035 .45375 m .5207 .45676 L .52031 .45371 L closepath p .702 g
F P
0 g
s
.52046 .45434 m .5207 .45676 L .52035 .45375 L closepath p .669 g
F P
0 g
s
.52055 .45552 m .52046 .4543 L p .52032 .45391 L .578 g
F P
0 g
s
.52031 .45371 m .5207 .45676 L .52036 .45423 L closepath p .677 g
F P
0 g
s
.52049 .45524 m .52036 .45423 L .52063 .4563 L p .013 g
F P
0 g
s
.51958 .45178 m .52051 .45535 L p .52032 .45391 L .578 g
F P
0 g
s
.52051 .45535 m .52055 .45552 L p .52032 .45391 L .578 g
F P
0 g
s
.52063 .4563 m .52066 .45647 L p .52063 .45624 L .013 g
F P
0 g
s
.52051 .45565 m .52064 .45618 L .52059 .45591 L p .034 g
F P
0 g
s
.52063 .4563 m .52063 .45624 L .52049 .45524 L .013 g
F
.52066 .45647 m .5207 .45676 L .52066 .45649 L p F P
0 g
s
.52066 .45649 m .52049 .45524 L p .52066 .45647 L .013 g
F P
0 g
s
.52027 .45513 m .52051 .45565 L .52033 .45499 L p .043 g
F P
0 g
s
.52027 .45513 m .52033 .45499 L .52021 .45488 L .043 g
F
.51941 .45453 m .51935 .4541 L p .51991 .45477 L .012 g
F P
0 g
s
.51988 .45458 m .51991 .45477 L .51935 .4541 L .012 g
F
.51991 .45477 m .52027 .45513 L .52017 .45489 L p .052 g
F P
0 g
s
.52017 .45489 m .51963 .45362 L p .51991 .45477 L .052 g
F P
0 g
s
.51929 .45357 m .51941 .45453 L p .5192 .45388 L .01 g
F P
0 g
s
.51941 .45453 m .51943 .4547 L p .51939 .45459 L .01 g
F P
0 g
s
.51991 .45477 m .51963 .45362 L .51956 .45391 L .052 g
F
.51943 .4547 m .51991 .45477 L .51908 .45345 L p .06 g
F P
0 g
s
.51908 .45345 m .50972 .43866 L p .51899 .45397 L .06 g
F P
0 g
s
.51943 .4547 m .51908 .45345 L .51899 .45397 L .06 g
F
.51881 .45491 m .51884 .455 L p .5188 .45497 L .008 g
F P
0 g
s
.5154 .45141 m .51881 .45491 L .5188 .45497 L .008 g
F
.50305 .43744 m .49495 .43928 L .51884 .455 L p .118 g
F P
0 g
s
.51816 .45574 m .51884 .455 L .49495 .43928 L p .185 g
F P
0 g
s
.43549 .39171 m .46236 .39977 L .48547 .41833 L p .403 g
F P
0 g
s
.25537 .49568 m .26265 .51779 L .23019 .56847 L p .208 g
F P
0 g
s
.24749 .58889 m .23019 .56847 L .26265 .51779 L p .365 g
F P
0 g
s
.55564 .42601 m .57166 .42471 L .53748 .44529 L p .454 g
F P
0 g
s
.54351 .44523 m .53748 .44529 L .57166 .42471 L p .458 g
F P
0 g
s
.56732 .6334 m .57974 .65545 L .53698 .61355 L p .406 g
F P
0 g
s
.57974 .65545 m .56732 .6334 L .59902 .6346 L p .705 g
F P
0 g
s
.59902 .6346 m .61992 .65579 L .57974 .65545 L p .705 g
F P
0 g
s
.48397 .41173 m .50068 .42236 L .49812 .41956 L p .255 g
F P
0 g
s
.50068 .42236 m .48397 .41173 L .49586 .42348 L p .272 g
F P
0 g
s
.54812 .42071 m .53566 .42846 L .53376 .42599 L p .137 g
F P
0 g
s
.53566 .42846 m .54812 .42071 L .54244 .43035 L p .373 g
F P
0 g
s
.55564 .42601 m .54244 .43035 L .54812 .42071 L p .317 g
F P
0 g
s
.37788 .4209 m .36669 .43224 L .26805 .44866 L p .357 g
F P
0 g
s
.25728 .472 m .26805 .44866 L .36669 .43224 L p .383 g
F P
0 g
s
.24749 .58889 m .27345 .60236 L .3047 .62943 L p .322 g
F P
0 g
s
.3047 .62943 m .33285 .63118 L .39492 .61571 L p .015 g
F P
0 g
s
.33285 .63118 m .3047 .62943 L .27345 .60236 L p .601 g
F P
0 g
s
.45679 .5614 m .46533 .559 L .51673 .46943 L p .005 g
F P
0 g
s
.49586 .42348 m .50717 .43058 L .50068 .42236 L p .272 g
F P
0 g
s
.50101 .42384 m .48444 .41102 L .47923 .40655 L p .299 g
F P
0 g
s
.47923 .40655 m .49812 .41956 L .50101 .42384 L p .299 g
F P
0 g
s
.50717 .43058 m .49586 .42348 L .50972 .43866 L p .151 g
F P
0 g
s
.50305 .43744 m .50972 .43866 L .49586 .42348 L p .273 g
F P
0 g
s
.51221 .54434 m .51367 .53768 L .53698 .61355 L p .038 g
F P
0 g
s
.53351 .59544 m .53698 .61355 L .51367 .53768 L p .055 g
F P
0 g
s
.53698 .61355 m .53351 .59544 L .56732 .6334 L p .406 g
F P
0 g
s
.61992 .65579 m .59902 .6346 L .61088 .60101 L p .751 g
F P
0 g
s
.61088 .60101 m .63529 .61719 L .61992 .65579 L p .751 g
F P
0 g
s
.49887 .42683 m .48547 .41833 L .46236 .39977 L p .439 g
F P
0 g
s
.46236 .39977 m .48444 .41102 L .49887 .42683 L p .439 g
F P
0 g
s
.65874 .62626 m .63529 .61719 L .61162 .55221 L p .748 g
F P
0 g
s
.61162 .55221 m .63073 .55648 L .65874 .62626 L p .748 g
F P
0 g
s
.50972 .43866 m .50305 .43744 L .51943 .4547 L p .06 g
F P
0 g
s
.51884 .455 m .51943 .4547 L .50305 .43744 L p .118 g
F P
0 g
s
.54244 .43035 m .55564 .42601 L .53215 .44636 L p .459 g
F P
0 g
s
.53748 .44529 m .53215 .44636 L .55564 .42601 L p .454 g
F P
0 g
s
.41629 .60696 m .39492 .61571 L .33285 .63118 L p .747 g
F P
0 g
s
.52418 .43748 m .52853 .42871 L .53376 .42599 L p .035 g
F P
0 g
s
.53376 .42599 m .5265 .43594 L .52418 .43748 L p .035 g
F P
0 g
s
.5265 .43594 m .53376 .42599 L .53566 .42846 L p .271 g
F P
0 g
s
.52168 .44219 m .52289 .4357 L .52853 .42871 L p F P
s
.36669 .43224 m .36046 .44546 L .25728 .472 L p .383 g
F P
0 g
s
.25537 .49568 m .25728 .472 L .36046 .44546 L p .414 g
F P
0 g
s
.55003 .43418 m .56057 .43277 L .61736 .38682 L p .566 g
F P
0 g
s
.61736 .38682 m .5918 .39347 L .55003 .43418 L p .566 g
F P
0 g
s
.64448 .38432 m .61736 .38682 L .56057 .43277 L p .559 g
F P
0 g
s
.5918 .39347 m .61736 .38682 L .65147 .34136 L p .616 g
F P
0 g
s
.61736 .38682 m .64448 .38432 L .68864 .3327 L p .597 g
F P
0 g
s
.68864 .3327 m .65147 .34136 L .61736 .38682 L p .597 g
F P
0 g
s
.56057 .43277 m .57171 .4332 L .64448 .38432 L p .559 g
F P
0 g
s
.67147 .38653 m .64448 .38432 L .57171 .4332 L p .549 g
F P
0 g
s
.64448 .38432 m .67147 .38653 L .72593 .3306 L p .573 g
F P
0 g
s
.72593 .3306 m .68864 .3327 L .64448 .38432 L p .573 g
F P
0 g
s
.51071 .43324 m .49812 .41956 L .50068 .42236 L p .055 g
F P
0 g
s
.26265 .51779 m .27874 .53651 L .24749 .58889 L p .365 g
F P
0 g
s
.27345 .60236 m .24749 .58889 L .27874 .53651 L p .475 g
F P
0 g
s
.50972 .43866 m .51474 .44217 L .50717 .43058 L p .151 g
F P
0 g
s
.50888 .43577 m .49887 .42683 L .48444 .41102 L p .473 g
F P
0 g
s
.48444 .41102 m .50101 .42384 L .50888 .43577 L p .473 g
F P
0 g
s
.54073 .43711 m .55003 .43418 L .5918 .39347 L p .571 g
F P
0 g
s
.5918 .39347 m .56928 .40334 L .54073 .43711 L p .571 g
F P
0 g
s
.56928 .40334 m .5918 .39347 L .6167 .35545 L p .63 g
F P
0 g
s
.65147 .34136 m .6167 .35545 L .5918 .39347 L p .616 g
F P
0 g
s
.6167 .35545 m .5862 .37338 L .56928 .40334 L p .63 g
F P
0 g
s
.5862 .37338 m .6167 .35545 L .618 .33142 L p .724 g
F P
0 g
s
.6167 .35545 m .65147 .34136 L .6536 .31067 L p .705 g
F P
0 g
s
.6536 .31067 m .618 .33142 L .6167 .35545 L p .705 g
F P
0 g
s
.53566 .42846 m .52733 .43804 L .5265 .43594 L p .271 g
F P
0 g
s
.52733 .43804 m .53566 .42846 L .53251 .43672 L p .425 g
F P
0 g
s
.54244 .43035 m .53251 .43672 L .53566 .42846 L p .373 g
F P
0 g
s
.57171 .4332 m .58273 .43559 L .67147 .38653 L p .549 g
F P
0 g
s
.69647 .39359 m .67147 .38653 L .58273 .43559 L p .539 g
F P
0 g
s
.67147 .38653 m .69647 .39359 L .76084 .33568 L p .543 g
F P
0 g
s
.76084 .33568 m .72593 .3306 L .67147 .38653 L p .543 g
F P
0 g
s
.51201 .43645 m .50101 .42384 L .49812 .41956 L p .436 g
F P
0 g
s
.49812 .41956 m .51071 .43324 L .51201 .43645 L p .436 g
F P
0 g
s
.65147 .34136 m .68864 .3327 L .69191 .29545 L p .679 g
F P
0 g
s
.69191 .29545 m .6536 .31067 L .65147 .34136 L p .679 g
F P
0 g
s
.52031 .4493 m .5198 .44595 L .52289 .4357 L p F P
s
.55084 .4152 m .56928 .40334 L .5862 .37338 L p .638 g
F P
0 g
s
.5862 .37338 m .56131 .39328 L .55084 .4152 L p .638 g
F P
0 g
s
.56131 .39328 m .5862 .37338 L .58694 .35567 L p .736 g
F P
0 g
s
.618 .33142 m .58694 .35567 L .5862 .37338 L p .724 g
F P
0 g
s
.53251 .43672 m .54244 .43035 L .52779 .4482 L p .471 g
F P
0 g
s
.53215 .44636 m .52779 .4482 L .54244 .43035 L p .459 g
F P
0 g
s
.55525 .60527 m .56732 .6334 L .53351 .59544 L p .485 g
F P
0 g
s
.56732 .6334 m .55525 .60527 L .57871 .60699 L p .669 g
F P
0 g
s
.57871 .60699 m .59902 .6346 L .56732 .6334 L p .669 g
F P
0 g
s
.51474 .44217 m .50972 .43866 L .51991 .45477 L p .052 g
F P
0 g
s
.53311 .44108 m .54073 .43711 L .56928 .40334 L p .574 g
F P
0 g
s
.56928 .40334 m .55084 .4152 L .53311 .44108 L p .574 g
F P
0 g
s
.27345 .60236 m .30615 .60772 L .33285 .63118 L p .601 g
F P
0 g
s
.33285 .63118 m .36479 .62411 L .41629 .60696 L p .747 g
F P
0 g
s
.36479 .62411 m .33285 .63118 L .30615 .60772 L p .711 g
F P
0 g
s
.50951 .44882 m .43076 .40506 L p .51065 .44871 L .529 g
F P
0 g
s
.43076 .40506 m .45049 .40666 L .51275 .44985 L p .529 g
F P
0 g
s
.41118 .4069 m .43076 .40506 L .51051 .44937 L p .528 g
F P
0 g
s
.51275 .44985 m .51174 .44916 L p .51414 .45033 L .53 g
F P
0 g
s
.51174 .44916 m .45049 .40666 L p .51281 .44928 L .53 g
F P
0 g
s
.51281 .44928 m .51486 .45068 L .51174 .44916 L .53 g
F
.51065 .44871 m .51275 .44985 L .50951 .44882 L .529 g
F
.45049 .40666 m .46908 .41131 L .51486 .45068 L p .53 g
F P
0 g
s
.51486 .45068 m .51459 .45045 L p .51563 .45109 L .532 g
F P
0 g
s
.51459 .45045 m .51289 .44899 L p .51596 .4511 L .532 g
F P
0 g
s
.51289 .44899 m .46908 .41131 L p .51378 .44926 L .532 g
F P
0 g
s
.51378 .44926 m .51596 .4511 L .51289 .44899 L .532 g
F
.46908 .41131 m .48547 .41833 L .51672 .45175 L p F P
0 g
s
.47084 .40297 m .4567 .3977 L .50885 .44778 L p .626 g
F P
0 g
s
.50885 .44778 m .51009 .44897 L p .50915 .44787 L .626 g
F P
0 g
s
.50915 .44787 m .47084 .40297 L .50885 .44778 L .626 g
F
.51596 .4511 m .51672 .45175 L .51459 .45045 L .532 g
F
.51648 .4515 m .51589 .45087 L p .51756 .45224 L .534 g
F P
0 g
s
.51495 .44986 m .48547 .41833 L p .51565 .45022 L .534 g
F P
0 g
s
.48547 .41833 m .49887 .42683 L .51824 .45295 L p .534 g
F P
0 g
s
.48413 .41044 m .47084 .40297 L .51089 .44777 L p .615 g
F P
0 g
s
.51089 .44777 m .51275 .44985 L p .51144 .44806 L .615 g
F P
0 g
s
.51144 .44806 m .48413 .41044 L .51089 .44777 L .615 g
F
.51589 .45087 m .51495 .44986 L p .51665 .45127 L .534 g
F P
0 g
s
.51565 .45022 m .51665 .45127 L .51495 .44986 L .534 g
F
.51665 .45127 m .51756 .45224 L .51589 .45087 L F
.51824 .45295 m .51675 .45095 L p .51905 .45375 L .536 g
F P
0 g
s
.51675 .45095 m .49887 .42683 L p .51726 .45134 L .536 g
F P
0 g
s
.51726 .45134 m .51937 .45414 L .51675 .45095 L .536 g
F
.51549 .44411 m .50888 .43577 L .50101 .42384 L p .502 g
F P
0 g
s
.50101 .42384 m .51201 .43645 L .51549 .44411 L p .502 g
F P
0 g
s
.49887 .42683 m .50888 .43577 L .51937 .45414 L p .536 g
F P
0 g
s
.52011 .45521 m .51937 .45414 L .51921 .45386 L p .538 g
F P
0 g
s
.51888 .45329 m .50888 .43577 L p .51923 .45369 L .538 g
F P
0 g
s
.50888 .43577 m .51549 .44411 L .52011 .45521 L p .538 g
F P
0 g
s
.51238 .43783 m .5053 .42875 L .51771 .45196 L p .575 g
F P
0 g
s
.51771 .45196 m .51824 .45295 L p .51797 .45225 L .575 g
F P
0 g
s
.51797 .45225 m .51238 .43783 L .51771 .45196 L .575 g
F
.51921 .45386 m .51888 .45329 L p .51967 .45445 L .538 g
F P
0 g
s
.51923 .45369 m .51967 .45445 L .51888 .45329 L .538 g
F
.51967 .45445 m .52011 .45521 L .51921 .45386 L F
.51824 .45295 m .51771 .45196 L p .51642 .45114 L .589 g
F P
0 g
s
.51771 .45196 m .5053 .42875 L p .51531 .44891 L .589 g
F P
0 g
s
.51642 .45114 m .51771 .45196 L .51531 .44891 L .589 g
F
.51672 .45175 m .51648 .4515 L p .51734 .45221 L .534 g
F P
0 g
s
.51824 .45295 m .51672 .45175 L p .51734 .45221 L .534 g
F P
0 g
s
.51756 .45224 m .51824 .45295 L .51648 .4515 L .534 g
F
.51672 .45175 m .51824 .45295 L p .51642 .45114 L .589 g
F P
0 g
s
.51937 .45414 m .51824 .45295 L p .51905 .45375 L .536 g
F P
0 g
s
.4958 .41932 m .48413 .41044 L .51268 .44783 L p .602 g
F P
0 g
s
.51268 .44783 m .5144 .45007 L p .51335 .44834 L .602 g
F P
0 g
s
.51335 .44834 m .4958 .41932 L .51268 .44783 L .602 g
F
.5144 .45007 m .51486 .45068 L p .51453 .45015 L F P
0 g
s
.51453 .45015 m .4958 .41932 L .5144 .45007 L .602 g
F
.51672 .45175 m .4958 .41932 L p .51453 .45015 L F P
0 g
s
.51672 .45175 m .51486 .45068 L p .51563 .45109 L .532 g
F P
0 g
s
.51486 .45068 m .51672 .45175 L p .51453 .45015 L .602 g
F P
0 g
s
.51486 .45068 m .5144 .45007 L p .51241 .44939 L .615 g
F P
0 g
s
.5144 .45007 m .48413 .41044 L p .51144 .44806 L .615 g
F P
0 g
s
.51241 .44939 m .5144 .45007 L .51144 .44806 L .615 g
F
.51486 .45068 m .51275 .44985 L p .51414 .45033 L .53 g
F P
0 g
s
.51275 .44985 m .51486 .45068 L p .51241 .44939 L .615 g
F P
0 g
s
.51275 .44985 m .5123 .44936 L p .51017 .44898 L .626 g
F P
0 g
s
.5123 .44936 m .47084 .40297 L p .50925 .4479 L .626 g
F P
0 g
s
.51017 .44898 m .5123 .44936 L .50925 .4479 L .626 g
F
.51051 .44937 m .50951 .44882 L p .51197 .44961 L .529 g
F P
0 g
s
.51275 .44985 m .51051 .44937 L p .51197 .44961 L .529 g
F P
0 g
s
.5083 .44931 m .41118 .4069 L p .51018 .44923 L .528 g
F P
0 g
s
.51051 .44937 m .5083 .44931 L p .51018 .44923 L .528 g
F P
0 g
s
.39311 .41227 m .41118 .4069 L .5083 .44931 L p .527 g
F P
0 g
s
.50628 .44968 m .39311 .41227 L p .50797 .4492 L .527 g
F P
0 g
s
.5083 .44931 m .50628 .44968 L p .50797 .4492 L .527 g
F P
0 g
s
.37788 .4209 m .39311 .41227 L .50628 .44968 L p .527 g
F P
0 g
s
.5046 .45048 m .37788 .4209 L p .50595 .4496 L .527 g
F P
0 g
s
.50628 .44968 m .5046 .45048 L p .50595 .4496 L .527 g
F P
0 g
s
.36669 .43224 m .37788 .4209 L .5046 .45048 L p .528 g
F P
0 g
s
.5034 .45165 m .36669 .43224 L p .50427 .45043 L .528 g
F P
0 g
s
.5046 .45048 m .5034 .45165 L p .50427 .45043 L .528 g
F P
0 g
s
.36046 .44546 m .36669 .43224 L .5034 .45165 L p .529 g
F P
0 g
s
.50276 .45311 m .36046 .44546 L p .50306 .45164 L .529 g
F P
0 g
s
.5034 .45165 m .50276 .45311 L p .50306 .45164 L .529 g
F P
0 g
s
.51046 .46093 m .50995 .4612 L p .50902 .46071 L .545 g
F P
0 g
s
.50995 .4612 m .42786 .50509 L p .50677 .46112 L .545 g
F P
0 g
s
.50677 .46112 m .50825 .4603 L .50995 .4612 L .545 g
F
.51271 .46116 m .44824 .50449 L p .51005 .46122 L .547 g
F P
0 g
s
.51046 .46093 m .51271 .46116 L p .51005 .46122 L .547 g
F P
0 g
s
.51483 .461 m .46754 .50061 L p .51229 .46152 L .55 g
F P
0 g
s
.51271 .46116 m .51483 .461 L p .51229 .46152 L .55 g
F P
0 g
s
.5167 .46051 m .48455 .49415 L p .51442 .46144 L .553 g
F P
0 g
s
.51483 .461 m .5167 .46051 L p .51442 .46144 L .553 g
F P
0 g
s
.51822 .45979 m .4984 .48604 L p .51632 .46104 L .555 g
F P
0 g
s
.5167 .46051 m .51822 .45979 L p .51632 .46104 L .555 g
F P
0 g
s
.51936 .45895 m .50868 .47737 L p .51787 .46043 L .557 g
F P
0 g
s
.51822 .45979 m .51936 .45895 L p .51787 .46043 L .557 g
F P
0 g
s
.51936 .45895 m .52011 .45812 L .51542 .46922 L p .56 g
F P
0 g
s
.51542 .46922 m .50868 .47737 L .51936 .45895 L p .56 g
F P
0 g
s
.50868 .47737 m .4984 .48604 L .51757 .46065 L p .557 g
F P
0 g
s
.51757 .46065 m .51822 .45979 L p .51787 .46043 L .557 g
F P
0 g
s
.50868 .47737 m .51757 .46065 L .51787 .46043 L .557 g
F
.51936 .45895 m .51892 .45967 L p .51996 .45835 L .353 g
F P
0 g
s
.51892 .45967 m .51225 .47072 L p .51931 .45939 L .353 g
F P
0 g
s
.51996 .45835 m .51892 .45967 L .51931 .45939 L .353 g
F
.52011 .45812 m .51936 .45895 L p .51996 .45835 L F P
0 g
s
.4984 .48604 m .48455 .49415 L .51611 .46113 L p .555 g
F P
0 g
s
.51611 .46113 m .5167 .46051 L p .51632 .46104 L .555 g
F P
0 g
s
.4984 .48604 m .51611 .46113 L .51632 .46104 L .555 g
F
.51822 .45979 m .51763 .4605 L p .51917 .45917 L .362 g
F P
0 g
s
.51763 .4605 m .50502 .47559 L p .51824 .46025 L .362 g
F P
0 g
s
.51917 .45917 m .51763 .4605 L .51824 .46025 L .362 g
F
.51936 .45895 m .51822 .45979 L p .51917 .45917 L F P
0 g
s
.48455 .49415 m .46754 .50061 L .51427 .46147 L p .553 g
F P
0 g
s
.51427 .46147 m .51483 .461 L p .51442 .46144 L .553 g
F P
0 g
s
.48455 .49415 m .51427 .46147 L .51442 .46144 L .553 g
F
.5167 .46051 m .51596 .46116 L p .518 .45998 L .371 g
F P
0 g
s
.51596 .46116 m .49526 .47933 L p .5168 .461 L .371 g
F P
0 g
s
.518 .45998 m .51596 .46116 L .5168 .461 L .371 g
F
.51822 .45979 m .5167 .46051 L p .518 .45998 L F P
0 g
s
.46754 .50061 m .44824 .50449 L .51217 .46152 L p .55 g
F P
0 g
s
.51217 .46152 m .51271 .46116 L p .51229 .46152 L .55 g
F P
0 g
s
.46754 .50061 m .51217 .46152 L .51229 .46152 L .55 g
F
.51483 .461 m .51399 .46153 L p .51645 .46067 L .387 g
F P
0 g
s
.51399 .46153 m .48324 .48118 L p .51503 .46154 L .387 g
F P
0 g
s
.51645 .46067 m .51399 .46153 L .51503 .46154 L .387 g
F
.5167 .46051 m .51483 .461 L p .51645 .46067 L F P
0 g
s
.51271 .46116 m .51246 .46127 L p .51362 .46114 L .41 g
F P
0 g
s
.51483 .461 m .51271 .46116 L p .51362 .46114 L .41 g
F P
0 g
s
.44824 .50449 m .42786 .50509 L .50995 .4612 L p .547 g
F P
0 g
s
.50995 .4612 m .51046 .46093 L p .51005 .46122 L .547 g
F P
0 g
s
.44824 .50449 m .50995 .4612 L .51005 .46122 L .547 g
F
.51246 .46127 m .51181 .46156 L p .51411 .46131 L .41 g
F P
0 g
s
.42786 .50509 m .40785 .50204 L .50643 .46105 L p .545 g
F P
0 g
s
.50643 .46105 m .50825 .4603 L p .50677 .46112 L .545 g
F P
0 g
s
.42786 .50509 m .50643 .46105 L .50677 .46112 L .545 g
F
.51181 .46156 m .51091 .46196 L p .513 .46179 L .41 g
F P
0 g
s
.51091 .46196 m .46955 .48054 L p .51205 .4622 L .41 g
F P
0 g
s
.513 .46179 m .51091 .46196 L .51205 .4622 L .41 g
F
.51411 .46131 m .51181 .46156 L .513 .46179 L F
.50623 .45928 m .50825 .4603 L .50777 .4605 L p .542 g
F P
0 g
s
.50777 .4605 m .40785 .50204 L p .50483 .45989 L .542 g
F P
0 g
s
.50483 .45989 m .50623 .45928 L .50777 .4605 L .542 g
F
.51046 .46093 m .51021 .461 L p .51243 .46123 L .44 g
F P
0 g
s
.40785 .50204 m .38974 .49539 L .50459 .45979 L p .542 g
F P
0 g
s
.50459 .45979 m .50623 .45928 L p .50483 .45989 L .542 g
F P
0 g
s
.40785 .50204 m .50459 .45979 L .50483 .45989 L .542 g
F
.51021 .461 m .50874 .46143 L p .51195 .46137 L .44 g
F P
0 g
s
.50874 .46143 m .45502 .47708 L p .50996 .46191 L .44 g
F P
0 g
s
.51195 .46137 m .50874 .46143 L .50996 .46191 L .44 g
F
.51243 .46123 m .51021 .461 L .51195 .46137 L F
.51271 .46116 m .51046 .46093 L p .51243 .46123 L F P
0 g
s
.50825 .4603 m .51046 .46093 L p .50902 .46071 L .545 g
F P
0 g
s
.51483 .461 m .51246 .46127 L .51411 .46131 L .41 g
F
.51046 .46093 m .50825 .4603 L .50749 .46041 L p .475 g
F P
0 g
s
.50307 .45826 m .37496 .48554 L p .50054 .45703 L .536 g
F P
0 g
s
.50623 .45928 m .38974 .49539 L p .50417 .45807 L .539 g
F P
0 g
s
.50456 .45795 m .50623 .45928 L p .50417 .45807 L .539 g
F P
0 g
s
.50297 .45644 m .50202 .45655 L p .50161 .45488 L .533 g
F P
0 g
s
.50202 .45655 m .3647 .47324 L p .50019 .45507 L .533 g
F P
0 g
s
.50019 .45507 m .50161 .45488 L .50202 .45655 L .533 g
F
.50623 .45928 m .50543 .45931 L p .50796 .4603 L .513 g
F P
0 g
s
.3647 .47324 m .35975 .4595 L .49992 .45482 L p .533 g
F P
0 g
s
.49992 .45482 m .50275 .45473 L p .50019 .45507 L .533 g
F P
0 g
s
.3647 .47324 m .49992 .45482 L .50019 .45507 L .533 g
F
.50543 .45931 m .50472 .45933 L p .5067 .46033 L .513 g
F P
0 g
s
.37496 .48554 m .3647 .47324 L .50297 .45644 L p .536 g
F P
0 g
s
.50297 .45644 m .50337 .45639 L p .503 .45647 L .536 g
F P
0 g
s
.37496 .48554 m .50297 .45644 L .503 .45647 L .536 g
F
.38974 .49539 m .37496 .48554 L .50307 .45826 L p .539 g
F P
0 g
s
.50307 .45826 m .50456 .45795 L p .50325 .45837 L .539 g
F P
0 g
s
.38974 .49539 m .50307 .45826 L .50325 .45837 L .539 g
F
.50749 .46041 m .50673 .46053 L p .50898 .46114 L .475 g
F P
0 g
s
.50673 .46053 m .44068 .47079 L p .50795 .46129 L .475 g
F P
0 g
s
.50898 .46114 m .50673 .46053 L .50795 .46129 L .475 g
F
.50428 .45792 m .50407 .45791 L p .50541 .45921 L .549 g
F P
0 g
s
.50456 .45795 m .50307 .45826 L p .503 .45647 L .536 g
F P
0 g
s
.50054 .45703 m .503 .45647 L .50307 .45826 L .536 g
F
.35975 .4595 m .36046 .44546 L .50025 .45297 L p .531 g
F P
0 g
s
.50025 .45297 m .50163 .45305 L p .50035 .45311 L .531 g
F P
0 g
s
.35975 .4595 m .50025 .45297 L .50035 .45311 L .531 g
F
.50407 .45791 m .50372 .45788 L p .50502 .45917 L .549 g
F P
0 g
s
.35975 .4595 m .50163 .45305 L .50167 .45312 L .531 g
F
.35975 .4595 m .50241 .45309 L .50242 .45312 L F
.50276 .45311 m .50275 .45473 L .35975 .4595 L p F P
0 g
s
.50372 .45788 m .4169 .45116 L p .50461 .45913 L .549 g
F P
0 g
s
.50502 .45917 m .50372 .45788 L .50461 .45913 L .549 g
F
.50541 .45921 m .50407 .45791 L .50502 .45917 L F
.50472 .45933 m .42763 .46195 L p .5058 .46035 L .513 g
F P
0 g
s
.5067 .46033 m .50472 .45933 L .5058 .46035 L .513 g
F
.50796 .4603 m .50543 .45931 L .5067 .46033 L F
.50825 .4603 m .50623 .45928 L p .50796 .4603 L F P
0 g
s
.51046 .46093 m .50749 .46041 L .50898 .46114 L .475 g
F
.50337 .45639 m .50456 .45795 L p .503 .45647 L .536 g
F P
0 g
s
.50456 .45795 m .50428 .45792 L p .50525 .4586 L .549 g
F P
0 g
s
.50623 .45928 m .50456 .45795 L p .50525 .4586 L .549 g
F P
0 g
s
.50623 .45928 m .50428 .45792 L .50541 .45921 L .549 g
F
.50337 .45639 m .50297 .45644 L p .5024 .45478 L .533 g
F P
0 g
s
.50161 .45488 m .5024 .45478 L .50297 .45644 L .533 g
F
.50275 .45473 m .50337 .45639 L p .5024 .45478 L F P
0 g
s
.50337 .45639 m .50308 .45634 L p .50382 .45715 L .582 g
F P
0 g
s
.50456 .45795 m .50337 .45639 L p .50382 .45715 L .582 g
F P
0 g
s
.50308 .45634 m .40939 .43926 L p .50372 .45778 L .582 g
F P
0 g
s
.50456 .45795 m .50308 .45634 L .50372 .45778 L .582 g
F
.50163 .45305 m .50241 .45309 L p .50167 .45312 L .531 g
F P
0 g
s
.50241 .45309 m .50276 .45311 L p .50242 .45312 L .531 g
F P
0 g
s
.50275 .45473 m .40569 .42722 L p .50308 .4563 L .608 g
F P
0 g
s
.50337 .45639 m .50275 .45473 L p .50308 .4563 L .608 g
F P
0 g
s
.50276 .45311 m .4061 .41603 L p .50246 .45461 L .627 g
F P
0 g
s
.50275 .45473 m .50276 .45311 L p .50246 .45461 L .627 g
F P
0 g
s
.5034 .45165 m .41054 .40662 L p .50246 .45296 L .639 g
F P
0 g
s
.50276 .45311 m .5034 .45165 L p .50246 .45296 L .639 g
F P
0 g
s
.5046 .45048 m .41859 .39973 L p .50309 .45146 L .645 g
F P
0 g
s
.5034 .45165 m .5046 .45048 L p .50309 .45146 L .645 g
F P
0 g
s
.50628 .44968 m .42958 .39585 L p .50428 .45025 L .646 g
F P
0 g
s
.5046 .45048 m .50628 .44968 L p .50428 .45025 L .646 g
F P
0 g
s
.5083 .44931 m .44261 .3952 L p .50595 .4494 L .642 g
F P
0 g
s
.50628 .44968 m .5083 .44931 L p .50595 .4494 L .642 g
F P
0 g
s
.51051 .44937 m .4567 .3977 L p .50797 .44897 L .636 g
F P
0 g
s
.5083 .44931 m .51051 .44937 L p .50797 .44897 L .636 g
F P
0 g
s
.51051 .44937 m .51275 .44985 L p .51017 .44898 L .626 g
F P
0 g
s
.51009 .44897 m .51051 .44937 L p .51017 .44898 L .626 g
F P
0 g
s
.51017 .44898 m .47084 .40297 L .51009 .44897 L .626 g
F
.4567 .3977 m .44261 .3952 L .5079 .44898 L p .636 g
F P
0 g
s
.5079 .44898 m .5083 .44931 L p .50797 .44897 L .636 g
F P
0 g
s
.50797 .44897 m .4567 .3977 L .5079 .44898 L .636 g
F
.51367 .53768 m .51517 .528 L .53351 .59544 L p .055 g
F P
0 g
s
.53016 .57285 m .53351 .59544 L .51517 .528 L p .079 g
F P
0 g
s
.53351 .59544 m .53016 .57285 L .55525 .60527 L p .485 g
F P
0 g
s
.58273 .43559 m .59283 .43989 L .69647 .39359 L p .539 g
F P
0 g
s
.71764 .4052 m .69647 .39359 L .59283 .43989 L p .527 g
F P
0 g
s
.69647 .39359 m .71764 .4052 L .79081 .34794 L p .507 g
F P
0 g
s
.79081 .34794 m .76084 .33568 L .69647 .39359 L p .507 g
F P
0 g
s
.53704 .42764 m .55084 .4152 L .56131 .39328 L p .64 g
F P
0 g
s
.56131 .39328 m .54272 .41313 L .53704 .42764 L p .64 g
F P
0 g
s
.54272 .41313 m .56131 .39328 L .5617 .38119 L p .741 g
F P
0 g
s
.58694 .35567 m .5617 .38119 L .56131 .39328 L p .736 g
F P
0 g
s
.68864 .3327 m .72593 .3306 L .73064 .28742 L p .641 g
F P
0 g
s
.73064 .28742 m .69191 .29545 L .68864 .3327 L p .641 g
F P
0 g
s
.63529 .61719 m .61088 .60101 L .59196 .54343 L p .717 g
F P
0 g
s
.59196 .54343 m .61162 .55221 L .63529 .61719 L p .717 g
F P
0 g
s
.5617 .38119 m .58694 .35567 L .57267 .35732 L p .865 g
F P
0 g
s
.58694 .35567 m .618 .33142 L .59717 .33159 L p .859 g
F P
0 g
s
.59717 .33159 m .57267 .35732 L .58694 .35567 L p .859 g
F P
0 g
s
.43853 .59163 m .41629 .60696 L .36479 .62411 L p .873 g
F P
0 g
s
.36046 .44546 m .35975 .4595 L .25537 .49568 L p .414 g
F P
0 g
s
.26265 .51779 m .25537 .49568 L .35975 .4595 L p .446 g
F P
0 g
s
.52454 .45047 m .53251 .43672 L p .52839 .44674 L .471 g
F P
0 g
s
.52779 .4482 m .52454 .45047 L p .52839 .44674 L .471 g
F P
0 g
s
.52592 .44384 m .53251 .43672 L .52481 .44999 L p .489 g
F P
0 g
s
.52481 .44999 m .52454 .45047 L p .5246 .45017 L .489 g
F P
0 g
s
.5246 .45017 m .52592 .44384 L .52481 .44999 L .489 g
F
.53251 .43672 m .52592 .44384 L .52733 .43804 L p .425 g
F P
0 g
s
.52274 .44731 m .52733 .43804 L .52592 .44384 L p .477 g
F P
0 g
s
.52592 .44384 m .5223 .45037 L .52274 .44731 L p .477 g
F P
0 g
s
.5223 .45037 m .52592 .44384 L .52359 .44975 L p .513 g
F P
0 g
s
.52359 .44975 m .52239 .45281 L p .52236 .45198 L .513 g
F P
0 g
s
.52236 .45198 m .5223 .45037 L .52355 .44977 L .513 g
F
.52239 .45281 m .52121 .45485 L .5223 .45037 L p F P
0 g
s
.5216 .45349 m .52291 .44859 L p .52125 .45438 L .544 g
F P
0 g
s
.5209 .45503 m .5223 .45037 L .52121 .45485 L p .546 g
F P
0 g
s
.52081 .45591 m .52143 .45402 L p .52125 .45438 L .544 g
F P
0 g
s
.52143 .45402 m .5216 .45349 L p .52125 .45438 L .544 g
F P
0 g
s
.52325 .45038 m .52355 .44977 L .52359 .44975 L .513 g
F
.52236 .45198 m .52355 .44977 L .52325 .45038 L F
.52733 .43804 m .52274 .44731 L .52248 .44607 L p .38 g
F P
0 g
s
.52096 .45415 m .52274 .44731 L .5223 .45037 L p .538 g
F P
0 g
s
.5209 .45503 m .52096 .45415 L p .52181 .45176 L .538 g
F P
0 g
s
.5223 .45037 m .52152 .45298 L p .52181 .45176 L .538 g
F P
0 g
s
.52152 .45298 m .5209 .45503 L p .52181 .45176 L .538 g
F P
0 g
s
.52108 .45377 m .52108 .45341 L .52077 .4561 L p .795 g
F P
0 g
s
.52076 .45625 m .5207 .45676 L .5209 .45503 L closepath p .061 g
F P
0 g
s
.52077 .4561 m .5207 .45676 L .52079 .45603 L p .795 g
F P
0 g
s
.52076 .45625 m .5209 .45503 L p .52094 .45501 L .546 g
F P
0 g
s
.52081 .45591 m .52098 .45466 L .52072 .45655 L p .653 g
F P
0 g
s
.52081 .45591 m .5207 .45676 L .52076 .45625 L closepath p .018 g
F P
0 g
s
.52072 .45655 m .5207 .45676 L .52074 .45646 L p .653 g
F P
0 g
s
.52074 .45646 m .52081 .45591 L p .52072 .45655 L .653 g
F P
0 g
s
.52098 .45499 m .52078 .45615 L .52094 .45501 L .546 g
F
.52078 .45615 m .52076 .45625 L .52094 .45501 L F
.52121 .45485 m .52078 .45619 L p .52098 .45499 L F P
0 g
s
.52078 .45619 m .52076 .45625 L p .52098 .45499 L .546 g
F P
0 g
s
.52098 .45466 m .52108 .45377 L .52072 .45659 L p .808 g
F P
0 g
s
.52072 .45659 m .5207 .45676 L .52072 .45655 L p .808 g
F P
0 g
s
.52072 .45655 m .52098 .45466 L p .52072 .45659 L .808 g
F P
0 g
s
.52079 .45603 m .52108 .45377 L p .52077 .4561 L .795 g
F P
0 g
s
.52291 .44859 m .52368 .44492 L p .52109 .45428 L .568 g
F P
0 g
s
.52098 .45466 m .52112 .45421 L p .52109 .45428 L .568 g
F P
0 g
s
.52112 .45421 m .52291 .44859 L p .52109 .45428 L .568 g
F P
0 g
s
.52239 .45281 m .52592 .44384 L p .52487 .44888 L .489 g
F P
0 g
s
.52454 .45047 m .52239 .45281 L p .52487 .44888 L .489 g
F P
0 g
s
.52239 .45281 m .52366 .44987 L p .5216 .45406 L .646 g
F P
0 g
s
.52121 .45485 m .52239 .45281 L p .5216 .45406 L .646 g
F P
0 g
s
.52366 .44987 m .52791 .43922 L p .52217 .45221 L .56 g
F P
0 g
s
.5216 .45349 m .52248 .45195 L p .52217 .45221 L .56 g
F P
0 g
s
.52248 .45195 m .52366 .44987 L p .52217 .45221 L .56 g
F P
0 g
s
.52454 .45047 m .52742 .44554 L p .52294 .45202 L .66 g
F P
0 g
s
.52239 .45281 m .52454 .45047 L p .52294 .45202 L .66 g
F P
0 g
s
.52742 .44554 m .53311 .44108 L .55084 .4152 L p .573 g
F P
0 g
s
.55084 .4152 m .53704 .42764 L .52742 .44554 L p .573 g
F P
0 g
s
.54291 .40568 m .5617 .38119 L .55282 .38347 L p .869 g
F P
0 g
s
.57267 .35732 m .55282 .38347 L .5617 .38119 L p .865 g
F P
0 g
s
.5617 .38119 m .54291 .40568 L .54272 .41313 L p .741 g
F P
0 g
s
.59902 .6346 m .57871 .60699 L .58732 .57934 L p .706 g
F P
0 g
s
.58732 .57934 m .61088 .60101 L .59902 .6346 L p .706 g
F P
0 g
s
.54988 .44633 m .55616 .44862 L .58273 .43559 L p .611 g
F P
0 g
s
.58273 .43559 m .57171 .4332 L .54988 .44633 L p .611 g
F P
0 g
s
.59283 .43989 m .58273 .43559 L .55616 .44862 L p .592 g
F P
0 g
s
.54351 .44523 m .54988 .44633 L .57171 .4332 L p .628 g
F P
0 g
s
.57171 .4332 m .56057 .43277 L .54351 .44523 L p .628 g
F P
0 g
s
.52177 .44674 m .52418 .43748 L .5265 .43594 L p .106 g
F P
0 g
s
.5265 .43594 m .52248 .44607 L .52177 .44674 L p .106 g
F P
0 g
s
.52248 .44607 m .5265 .43594 L .52733 .43804 L p .38 g
F P
0 g
s
.618 .33142 m .6536 .31067 L .62534 .30846 L p .849 g
F P
0 g
s
.62534 .30846 m .59717 .33159 L .618 .33142 L p .849 g
F P
0 g
s
.521 .44915 m .52168 .44219 L .52418 .43748 L p F P
s
.52418 .43748 m .52177 .44674 L .521 .44915 L p F P
s
.55616 .44862 m .56191 .45199 L .59283 .43989 L p .592 g
F P
0 g
s
.60127 .44586 m .59283 .43989 L .56191 .45199 L p .571 g
F P
0 g
s
.59283 .43989 m .60127 .44586 L .71764 .4052 L p .527 g
F P
0 g
s
.53748 .44529 m .54351 .44523 L .56057 .43277 L p .643 g
F P
0 g
s
.56057 .43277 m .55003 .43418 L .53748 .44529 L p .643 g
F P
0 g
s
.52791 .43922 m .53704 .42764 L .54272 .41313 L p .632 g
F P
0 g
s
.54272 .41313 m .53043 .43094 L .52791 .43922 L p .632 g
F P
0 g
s
.53043 .43094 m .54272 .41313 L .54291 .40568 L p .738 g
F P
0 g
s
.51764 .44532 m .51071 .43324 L .51184 .43447 L p .433 g
F P
0 g
s
.51184 .43447 m .51798 .4457 L .51764 .44532 L p .433 g
F P
0 g
s
.51798 .4457 m .51184 .43447 L .51472 .43942 L p .054 g
F P
0 g
s
.60127 .44586 m .60739 .45308 L .73334 .42064 L p .514 g
F P
0 g
s
.73334 .42064 m .71764 .4052 L .60127 .44586 L p .514 g
F P
0 g
s
.5305 .42699 m .54291 .40568 L .53808 .40789 L p .871 g
F P
0 g
s
.55282 .38347 m .53808 .40789 L .54291 .40568 L p .869 g
F P
0 g
s
.54291 .40568 m .5305 .42699 L .53043 .43094 L p .738 g
F P
0 g
s
.71764 .4052 m .73334 .42064 L .81344 .36677 L p .465 g
F P
0 g
s
.81344 .36677 m .79081 .34794 L .71764 .4052 L p .465 g
F P
0 g
s
.53215 .44636 m .53748 .44529 L .55003 .43418 L p .655 g
F P
0 g
s
.55003 .43418 m .54073 .43711 L .53215 .44636 L p .655 g
F P
0 g
s
.6107 .461 m .60739 .45308 L .57015 .46107 L p .524 g
F P
0 g
s
.52058 .45287 m .52031 .4493 L .52168 .44219 L p F P
s
.52168 .44219 m .521 .44915 L .52094 .44969 L p F P
s
.52094 .44969 m .52069 .45191 L p .52089 .44995 L F P
s
.52168 .44219 m .52094 .44969 L .52089 .44995 L F
.52168 .44219 m .52069 .45191 L .52067 .45202 L F
.52047 .40578 m .52058 .4235 L .52153 .44674 L p .029 g
F P
0 g
s
.52153 .44674 m .52155 .4472 L p .52154 .44671 L .029 g
F P
0 g
s
.52047 .40578 m .52153 .44674 L .52154 .44671 L .029 g
F
.52074 .4546 m .521 .44915 L .52177 .44674 L p 0 g
F P
s
.52058 .4235 m .52065 .43805 L .52103 .45016 L p .026 g
F P
0 g
s
.52103 .45016 m .52107 .45138 L p .52105 .45008 L .026 g
F P
0 g
s
.52058 .4235 m .52103 .45016 L .52105 .45008 L .026 g
F
.52069 .45191 m .52058 .45287 L p .52067 .45202 L 0 g
F P
s
.52366 .44987 m .52742 .44554 L .53704 .42764 L p .569 g
F P
0 g
s
.53704 .42764 m .52791 .43922 L .52366 .44987 L p .569 g
F P
0 g
s
.72593 .3306 m .76084 .33568 L .76719 .28771 L p .588 g
F P
0 g
s
.76719 .28771 m .73064 .28742 L .72593 .3306 L p .588 g
F P
0 g
s
.60739 .45308 m .6107 .461 L .74226 .43878 L p .5 g
F P
0 g
s
.74226 .43878 m .73334 .42064 L .60739 .45308 L p .5 g
F P
0 g
s
.53808 .40789 m .55282 .38347 L .53888 .40164 L p .923 g
F P
0 g
s
.55282 .38347 m .57267 .35732 L .55013 .38123 L p .934 g
F P
0 g
s
.55013 .38123 m .53888 .40164 L .55282 .38347 L p .934 g
F P
0 g
s
.27874 .53651 m .30248 .55026 L .27345 .60236 L p .475 g
F P
0 g
s
.30615 .60772 m .27345 .60236 L .30248 .55026 L p .552 g
F P
0 g
s
.52779 .4482 m .53215 .44636 L .54073 .43711 L p .662 g
F P
0 g
s
.54073 .43711 m .53311 .44108 L .52779 .4482 L p .662 g
F P
0 g
s
.6536 .31067 m .69191 .29545 L .65575 .29003 L p .831 g
F P
0 g
s
.65575 .29003 m .62534 .30846 L .6536 .31067 L p .831 g
F P
0 g
s
.61091 .469 m .6107 .461 L .57198 .4661 L p .499 g
F P
0 g
s
.53808 .40789 m .52836 .42865 L .5305 .42699 L p .871 g
F P
0 g
s
.52836 .42865 m .53808 .40789 L .53053 .42037 L p .898 g
F P
0 g
s
.53888 .40164 m .53053 .42037 L .53808 .40789 L p .923 g
F P
0 g
s
.57267 .35732 m .59717 .33159 L .56402 .36075 L p .935 g
F P
0 g
s
.56402 .36075 m .55013 .38123 L .57267 .35732 L p .935 g
F P
0 g
s
.51517 .528 m .51661 .51616 L .53016 .57285 L p .079 g
F P
0 g
s
.51911 .45086 m .51549 .44411 L .51201 .43645 L p .521 g
F P
0 g
s
.50605 .40376 m .49356 .37653 L .49463 .39832 L p .619 g
F P
0 g
s
.49463 .39832 m .50661 .41776 L .50605 .40376 L p .619 g
F P
0 g
s
.47849 .37757 m .49463 .39832 L .49356 .37653 L p .644 g
F P
0 g
s
.50661 .41776 m .49463 .39832 L .5053 .42875 L p .605 g
F P
0 g
s
.49463 .39832 m .47849 .37757 L .4958 .41932 L p .624 g
F P
0 g
s
.4958 .41932 m .5053 .42875 L .49463 .39832 L p .624 g
F P
0 g
s
.52291 .44859 m .52791 .43922 L .53043 .43094 L p .612 g
F P
0 g
s
.53043 .43094 m .52368 .44492 L .52291 .44859 L p .612 g
F P
0 g
s
.52368 .44492 m .53043 .43094 L .5305 .42699 L p .723 g
F P
0 g
s
.51598 .42432 m .50995 .39944 L .50605 .40376 L p .573 g
F P
0 g
s
.50605 .40376 m .51425 .42655 L .51598 .42432 L p .573 g
F P
0 g
s
.49356 .37653 m .50605 .40376 L .50995 .39944 L p .602 g
F P
0 g
s
.51425 .42655 m .50605 .40376 L .50661 .41776 L p .597 g
F P
0 g
s
.50995 .39944 m .50077 .36936 L .49356 .37653 L p .602 g
F P
0 g
s
.47668 .34683 m .49356 .37653 L .50077 .36936 L p .631 g
F P
0 g
s
.49356 .37653 m .47668 .34683 L .47849 .37757 L p .644 g
F P
0 g
s
.5237 .44332 m .5305 .42699 L .52836 .42865 L p .873 g
F P
0 g
s
.5305 .42699 m .5237 .44332 L .52368 .44492 L p .723 g
F P
0 g
s
.54438 .57377 m .55525 .60527 L .53016 .57285 L p .511 g
F P
0 g
s
.55525 .60527 m .54438 .57377 L .56043 .57565 L p .637 g
F P
0 g
s
.56043 .57565 m .57871 .60699 L .55525 .60527 L p .637 g
F P
0 g
s
.45859 .35724 m .47849 .37757 L .47668 .34683 L p .671 g
F P
0 g
s
.47849 .37757 m .45859 .35724 L .48413 .41044 L p .643 g
F P
0 g
s
.48413 .41044 m .4958 .41932 L .47849 .37757 L p .643 g
F P
0 g
s
.60798 .47642 m .61091 .469 L .57205 .47093 L p .472 g
F P
0 g
s
.52717 .54789 m .53016 .57285 L .51661 .51616 L p .14 g
F P
0 g
s
.53016 .57285 m .52717 .54789 L .54438 .57377 L p .511 g
F P
0 g
s
.6107 .461 m .61091 .469 L .74354 .45821 L p .487 g
F P
0 g
s
.74354 .45821 m .74226 .43878 L .6107 .461 L p .487 g
F P
0 g
s
.50661 .41776 m .5145 .43431 L .51425 .42655 L p .597 g
F P
0 g
s
.5145 .43431 m .50661 .41776 L .51238 .43783 L p .589 g
F P
0 g
s
.5053 .42875 m .51238 .43783 L .50661 .41776 L p .605 g
F P
0 g
s
.52454 .45047 m .52779 .4482 L .53311 .44108 L p .665 g
F P
0 g
s
.53311 .44108 m .52742 .44554 L .52454 .45047 L p .665 g
F P
0 g
s
.51858 .42837 m .51586 .40638 L .50995 .39944 L p .457 g
F P
0 g
s
.50995 .39944 m .51598 .42432 L .51858 .42837 L p .457 g
F P
0 g
s
.50077 .36936 m .50995 .39944 L .51586 .40638 L p .499 g
F P
0 g
s
.52836 .42865 m .52305 .44423 L .5237 .44332 L p .873 g
F P
0 g
s
.52305 .44423 m .52836 .42865 L .52503 .43604 L p .82 g
F P
0 g
s
.53053 .42037 m .52503 .43604 L .52836 .42865 L p .898 g
F P
0 g
s
.52791 .43922 m .52291 .44859 L .5216 .45349 L p .56 g
F P
0 g
s
.51586 .40638 m .51171 .37962 L .50077 .36936 L p .499 g
F P
0 g
s
.48833 .33607 m .50077 .36936 L .51171 .37962 L p .53 g
F P
0 g
s
.50077 .36936 m .48833 .33607 L .47668 .34683 L p .631 g
F P
0 g
s
.51926 .44253 m .51598 .42432 L .51425 .42655 L p .546 g
F P
0 g
s
.51425 .42655 m .51873 .44341 L .51926 .44253 L p .546 g
F P
0 g
s
.51873 .44341 m .51425 .42655 L .5145 .43431 L p .581 g
F P
0 g
s
.5053 .42875 m .4958 .41932 L .51672 .45175 L p .589 g
F P
0 g
s
.52084 .45393 m .52177 .44674 L .52248 .44607 L p .166 g
F P
0 g
s
.52248 .44607 m .52093 .45377 L .52084 .45393 L p .166 g
F P
0 g
s
.52093 .45377 m .52248 .44607 L .52274 .44731 L p .481 g
F P
0 g
s
.52005 .44437 m .51858 .42837 L .51598 .42432 L p .389 g
F P
0 g
s
.51598 .42432 m .51926 .44253 L .52005 .44437 L p .389 g
F P
0 g
s
.52193 .44798 m .5222 .44686 L p .52155 .4472 L .85 g
F P
0 g
s
.5222 .44686 m .5235 .44124 L .52299 .44281 L p .85 g
F P
0 g
s
.52299 .44281 m .52155 .4472 L p .5222 .44686 L .85 g
F P
0 g
s
.52084 .45393 m .52074 .4546 L p .52085 .45371 L F P
s
.52177 .44674 m .52089 .45355 L p .52085 .45371 L F P
s
.52089 .45355 m .52084 .45393 L p .52085 .45371 L F P
s
.30615 .60772 m .34307 .60461 L .36479 .62411 L p .711 g
F P
0 g
s
.39805 .609 m .36479 .62411 L .34307 .60461 L p .758 g
F P
0 g
s
.36479 .62411 m .39805 .609 L .43853 .59163 L p .873 g
F P
0 g
s
.45997 .57124 m .43853 .59163 L .39805 .609 L p .891 g
F P
0 g
s
.52065 .43805 m .52058 .4235 L .51586 .40638 L p .129 g
F P
0 g
s
.51586 .40638 m .51858 .42837 L .52065 .43805 L p .129 g
F P
0 g
s
.51171 .37962 m .51586 .40638 L .52058 .4235 L p .189 g
F P
0 g
s
.35975 .4595 m .3647 .47324 L .26265 .51779 L p .446 g
F P
0 g
s
.27874 .53651 m .26265 .51779 L .3647 .47324 L p .478 g
F P
0 g
s
.52031 .4493 m .52058 .45287 L .52064 .45618 L p .018 g
F P
0 g
s
.47084 .40297 m .48413 .41044 L .45859 .35724 L p .662 g
F P
0 g
s
.60213 .48267 m .60798 .47642 L .57034 .47517 L p .446 g
F P
0 g
s
.52503 .43604 m .52743 .42921 L p .52621 .43319 L .774 g
F P
0 g
s
.52743 .42921 m .53053 .42037 L .52807 .42767 L p .774 g
F P
0 g
s
.52807 .42767 m .52621 .43319 L p .52743 .42921 L .774 g
F P
0 g
s
.53053 .42037 m .53888 .40164 L .53004 .42304 L p .825 g
F P
0 g
s
.52503 .43604 m .52202 .44762 L .52305 .44423 L p .82 g
F P
0 g
s
.52589 .4331 m .52519 .43549 L p .53053 .42037 L .825 g
F P
0 g
s
.52202 .44762 m .52323 .44297 L p .52193 .44798 L .654 g
F P
0 g
s
.52323 .44297 m .52503 .43604 L .5235 .44195 L p .654 g
F P
0 g
s
.5235 .44195 m .52193 .44798 L p .52323 .44297 L .654 g
F P
0 g
s
.5235 .44124 m .52193 .44798 L .52503 .43604 L p .774 g
F P
0 g
s
.5235 .44124 m .5246 .43752 L .52479 .43698 L .774 g
F
.5235 .44124 m .52479 .43698 L .52621 .43319 L F
.52519 .43549 m .5235 .44124 L .52431 .43884 L p .825 g
F P
0 g
s
.5246 .43752 m .52503 .43604 L .52621 .43319 L .774 g
F
.52431 .43884 m .53053 .42037 L p .52519 .43549 L .825 g
F P
0 g
s
.53004 .42304 m .52589 .4331 L p .52778 .42789 L .825 g
F P
0 g
s
.52778 .42789 m .53053 .42037 L .53004 .42304 L .825 g
F
.53261 .41607 m .52997 .42312 L .53888 .40164 L .84 g
F
.52965 .424 m .53004 .42304 L p .52997 .42312 L F P
0 g
s
.53004 .42304 m .53888 .40164 L p .52997 .42312 L .84 g
F P
0 g
s
.52909 .42415 m .52965 .424 L .53261 .41607 L .84 g
F
.53888 .40164 m .55013 .38123 L .52909 .42415 L p F P
0 g
s
.53215 .41792 m .53747 .40707 L p .53473 .41173 L .824 g
F P
0 g
s
.53747 .40707 m .55013 .38123 L p .54187 .39759 L .824 g
F P
0 g
s
.53473 .41173 m .53747 .40707 L .54187 .39759 L .824 g
F
.53303 .41511 m .52909 .42415 L .53215 .41792 L p F P
0 g
s
.53303 .41511 m .53279 .41638 L .53473 .41173 L .824 g
F
.55013 .38123 m .56402 .36075 L .53303 .41511 L p F P
0 g
s
.53303 .41511 m .53751 .40673 L .53334 .41342 L p .925 g
F P
0 g
s
.53334 .41342 m .52578 .42555 L p .53303 .41511 L .925 g
F P
0 g
s
.53303 .41511 m .53215 .41792 L .53279 .41638 L .824 g
F
.52909 .42415 m .52589 .4331 L .52965 .424 L p .84 g
F P
0 g
s
.61088 .60101 m .58732 .57934 L .57317 .53109 L p .687 g
F P
0 g
s
.57317 .53109 m .59196 .54343 L .61088 .60101 L p .687 g
F P
0 g
s
.45577 .3169 m .47668 .34683 L .48833 .33607 L p .663 g
F P
0 g
s
.47668 .34683 m .45577 .3169 L .45859 .35724 L p .671 g
F P
0 g
s
.5145 .43431 m .51881 .44675 L .51873 .44341 L p .581 g
F P
0 g
s
.51881 .44675 m .5145 .43431 L .51704 .44573 L p .577 g
F P
0 g
s
.51238 .43783 m .51704 .44573 L .5145 .43431 L p .589 g
F P
0 g
s
.73334 .42064 m .74226 .43878 L .82671 .39088 L p .414 g
F P
0 g
s
.82671 .39088 m .81344 .36677 L .73334 .42064 L p .414 g
F P
0 g
s
.59717 .33159 m .62534 .30846 L .57996 .34188 L p .918 g
F P
0 g
s
.57996 .34188 m .56402 .36075 L .59717 .33159 L p .918 g
F P
0 g
s
.52274 .44731 m .52096 .45415 L .52093 .45377 L p .481 g
F P
0 g
s
.52742 .44554 m .52366 .44987 L .52239 .45281 L p .66 g
F P
0 g
s
.52069 .44861 m .52065 .43805 L .51858 .42837 L p .054 g
F P
0 g
s
.51858 .42837 m .52005 .44437 L .52069 .44861 L p .054 g
F P
0 g
s
.5198 .45447 m .51549 .44411 L p .51998 .45478 L .539 g
F P
0 g
s
.51549 .44411 m .51911 .45086 L .52052 .45605 L p .539 g
F P
0 g
s
.51704 .44573 m .51238 .43783 L .51868 .45253 L p .563 g
F P
0 g
s
.51868 .45253 m .51937 .45414 L p .51914 .45333 L .563 g
F P
0 g
s
.51914 .45333 m .51704 .44573 L .51868 .45253 L .563 g
F
.52052 .45605 m .52011 .45521 L .5198 .45447 L p .539 g
F P
0 g
s
.51998 .45478 m .52052 .45605 L .5198 .45447 L .539 g
F
.43577 .33911 m .45859 .35724 L .45577 .3169 L p .699 g
F P
0 g
s
.45859 .35724 m .43577 .33911 L .47084 .40297 L p .662 g
F P
0 g
s
.52068 .45566 m .52058 .45287 L .521 .44915 L p F P
s
.52065 .43805 m .52069 .44861 L .5208 .45373 L p .021 g
F P
0 g
s
.5208 .45373 m .52081 .45441 L p .5208 .45362 L .021 g
F P
0 g
s
.52065 .43805 m .5208 .45373 L .5208 .45362 L .021 g
F
.521 .44915 m .52074 .4546 L .52073 .45465 L p 0 g
F P
s
.52073 .45465 m .52068 .45566 L p .52072 .4548 L F P
s
.521 .44915 m .52073 .45465 L .52072 .4548 L F
.51824 .45295 m .51937 .45414 L .51238 .43783 L p .575 g
F P
0 g
s
.61091 .469 m .60798 .47642 L .73696 .47736 L p .474 g
F P
0 g
s
.73696 .47736 m .74354 .45821 L .61091 .469 L p .474 g
F P
0 g
s
.52058 .4235 m .52047 .40578 L .51171 .37962 L p .189 g
F P
0 g
s
.50608 .34982 m .51171 .37962 L .52047 .40578 L p .21 g
F P
0 g
s
.51171 .37962 m .50608 .34982 L .48833 .33607 L p .53 g
F P
0 g
s
.52108 .45341 m .5237 .44332 L .52305 .44423 L p .849 g
F P
0 g
s
.52108 .45377 m .52368 .44492 L .5237 .44332 L p .675 g
F P
0 g
s
.5237 .44332 m .52108 .45341 L .52108 .45377 L p .675 g
F P
0 g
s
.52368 .44492 m .52108 .45377 L .52098 .45466 L p .568 g
F P
0 g
s
.5179 .50327 m .51661 .51616 L .51882 .46531 L p .034 g
F P
0 g
s
.51661 .51616 m .5179 .50327 L .52717 .54789 L p .14 g
F P
0 g
s
.4567 .3977 m .47084 .40297 L .43577 .33911 L p .681 g
F P
0 g
s
.57871 .60699 m .56043 .57565 L .56624 .55436 L p .667 g
F P
0 g
s
.56624 .55436 m .58732 .57934 L .57871 .60699 L p .667 g
F P
0 g
s
.52107 .45138 m .52155 .4472 L .52058 .4235 L p .026 g
F P
0 g
s
.52305 .44423 m .521 .45368 L .52108 .45341 L p .849 g
F P
0 g
s
.521 .45368 m .52305 .44423 L .52202 .44762 L p .001 g
F P
0 g
s
.52062 .45378 m .52005 .44437 L .51926 .44253 L p .206 g
F P
0 g
s
.51926 .44253 m .52051 .45332 L .52062 .45378 L p .206 g
F P
0 g
s
.52051 .45332 m .51926 .44253 L .51873 .44341 L p .527 g
F P
0 g
s
.51873 .44341 m .52045 .45351 L .52051 .45332 L p .527 g
F P
0 g
s
.52045 .45351 m .51873 .44341 L .51881 .44675 L p .582 g
F P
0 g
s
.59381 .48724 m .60213 .48267 L .56698 .47848 L p .42 g
F P
0 g
s
.52081 .45441 m .52107 .45138 L .52065 .43805 L p .021 g
F P
0 g
s
.52291 .44859 m .52098 .45466 L .52081 .45591 L p .544 g
F P
0 g
s
.52067 .45658 m .52052 .45605 L .52036 .45547 L p .54 g
F P
0 g
s
.52036 .45547 m .51911 .45086 L p .52042 .45565 L .54 g
F P
0 g
s
.52042 .45565 m .52061 .45636 L .52036 .45547 L .54 g
F
.52067 .45658 m .52049 .45524 L .52068 .45666 L p .043 g
F P
0 g
s
.52068 .45666 m .5207 .45676 L .52067 .45658 L p .043 g
F P
0 g
s
.52067 .45658 m .52055 .45552 L p .52055 .45556 L .554 g
F P
0 g
s
.51911 .45086 m .52049 .45524 L .52067 .45658 L p .54 g
F P
0 g
s
.52061 .45636 m .52067 .45658 L .52059 .45629 L .54 g
F
.52061 .45636 m .52059 .45629 L .52036 .45547 L F
.52052 .45605 m .52067 .45658 L p .52055 .45556 L .554 g
F P
0 g
s
.52052 .45605 m .51958 .45178 L p .51996 .45425 L .554 g
F P
0 g
s
.52011 .45521 m .52052 .45605 L p .51996 .45425 L .554 g
F P
0 g
s
.51704 .44573 m .52011 .45521 L p .51996 .45425 L .554 g
F P
0 g
s
.51958 .45178 m .5177 .44731 L p .51996 .45425 L .554 g
F P
0 g
s
.5177 .44731 m .51704 .44573 L p .51996 .45425 L .554 g
F P
0 g
s
.51937 .45414 m .52011 .45521 L .51704 .44573 L p .563 g
F P
0 g
s
.52366 .44987 m .5216 .45349 L .52121 .45485 L p .646 g
F P
0 g
s
.5207 .4548 m .52069 .44861 L .52005 .44437 L p .027 g
F P
0 g
s
.52005 .44437 m .52062 .45378 L .5207 .4548 L p .027 g
F P
0 g
s
.51881 .44675 m .52046 .4543 L .52045 .45351 L p .582 g
F P
0 g
s
.52046 .4543 m .51881 .44675 L .51958 .45178 L p .578 g
F P
0 g
s
.52155 .4472 m .52227 .44214 L .52047 .40578 L p .029 g
F P
0 g
s
.52031 .38606 m .52047 .40578 L .52227 .44214 L p .031 g
F P
0 g
s
.52047 .40578 m .52031 .38606 L .50608 .34982 L p .21 g
F P
0 g
s
.52202 .44762 m .52087 .45454 L .521 .45368 L p .001 g
F P
0 g
s
.52087 .45454 m .52202 .44762 L .52107 .45292 L p .014 g
F P
0 g
s
.52193 .44798 m .52107 .45292 L .52202 .44762 L p .654 g
F P
0 g
s
.52069 .4566 m .52064 .45618 L .52058 .45287 L p .019 g
F P
0 g
s
.52058 .45287 m .52068 .45566 L .52069 .4566 L p .019 g
F P
0 g
s
.49414 .52792 m .50254 .51288 L .51941 .46345 L p .882 g
F P
0 g
s
.50254 .51288 m .49414 .52792 L .45997 .57124 L p .934 g
F P
0 g
s
.5235 .44124 m .52589 .4331 L .52227 .44214 L p .864 g
F P
0 g
s
.52227 .44214 m .52155 .4472 L .5235 .44124 L p .864 g
F P
0 g
s
.47286 .30196 m .48833 .33607 L .50608 .34982 L p .554 g
F P
0 g
s
.48833 .33607 m .47286 .30196 L .45577 .3169 L p .663 g
F P
0 g
s
.52084 .45393 m .5207 .45676 L .52074 .4546 L closepath p .449 g
F P
0 g
s
.52071 .4562 m .52081 .45441 L .52069 .44861 L p .012 g
F P
0 g
s
.52069 .44861 m .5207 .4548 L .52071 .4562 L p .012 g
F P
0 g
s
.69191 .29545 m .73064 .28742 L .68656 .27812 L p .789 g
F P
0 g
s
.68656 .27812 m .65575 .29003 L .69191 .29545 L p .789 g
F P
0 g
s
.76084 .33568 m .79081 .34794 L .79884 .29683 L p .509 g
F P
0 g
s
.79884 .29683 m .76719 .28771 L .76084 .33568 L p .509 g
F P
0 g
s
.52589 .4331 m .52909 .42415 L .52324 .43654 L p .882 g
F P
0 g
s
.52324 .43654 m .52227 .44214 L .52589 .4331 L p .882 g
F P
0 g
s
.52107 .45292 m .52193 .44798 L .52107 .45138 L p .839 g
F P
0 g
s
.52155 .4472 m .52107 .45138 L .52193 .44798 L p .85 g
F P
0 g
s
.52055 .45552 m .51958 .45178 L .52052 .45605 L p .554 g
F P
0 g
s
.52093 .45377 m .5207 .45676 L .52084 .45393 L closepath p .389 g
F P
0 g
s
.52096 .45415 m .5207 .45676 L .52093 .45377 L closepath p .31 g
F P
0 g
s
.52076 .45625 m .52121 .45485 L .5216 .45349 L p .615 g
F P
0 g
s
.5216 .45349 m .52081 .45591 L .52076 .45625 L p .615 g
F P
0 g
s
.58368 .4898 m .59381 .48724 L .56223 .4806 L p .396 g
F P
0 g
s
.60798 .47642 m .60213 .48267 L .72294 .49463 L p .463 g
F P
0 g
s
.72294 .49463 m .73696 .47736 L .60798 .47642 L p .463 g
F P
0 g
s
.5209 .45503 m .5207 .45676 L .52096 .45415 L closepath p .196 g
F P
0 g
s
.521 .45368 m .5207 .45676 L .52108 .45341 L closepath p .745 g
F P
0 g
s
.43577 .33911 m .41123 .32487 L .4567 .3977 L p .681 g
F P
0 g
s
.44261 .3952 m .4567 .3977 L .41123 .32487 L p .699 g
F P
0 g
s
.52064 .45618 m .52069 .4566 L .52059 .45535 L p .031 g
F P
0 g
s
.52059 .45535 m .5207 .45676 L .52046 .45434 L closepath p .627 g
F P
0 g
s
.52051 .45332 m .5207 .45676 L .52062 .45378 L closepath p .486 g
F P
0 g
s
.52069 .4566 m .5207 .45676 L .52059 .45535 L closepath p .584 g
F P
0 g
s
.52045 .45351 m .5207 .45676 L .52051 .45332 L closepath p .434 g
F P
0 g
s
.52046 .4543 m .5207 .45676 L .52045 .45351 L closepath p .368 g
F P
0 g
s
.52074 .4546 m .5207 .45676 L .52068 .45566 L closepath p .498 g
F P
0 g
s
.52087 .45454 m .5207 .45676 L .521 .45368 L closepath p .695 g
F P
0 g
s
.52107 .45292 m .52074 .45583 L .52087 .45454 L p .014 g
F P
0 g
s
.52074 .45583 m .52107 .45292 L .52081 .45441 L p .793 g
F P
0 g
s
.52107 .45138 m .52081 .45441 L .52107 .45292 L p .839 g
F P
0 g
s
.52068 .45566 m .5207 .45676 L .52069 .4566 L closepath p .542 g
F P
0 g
s
.52062 .45378 m .5207 .45676 L .5207 .4548 L closepath p .529 g
F P
0 g
s
.52055 .45552 m .5207 .45676 L .52046 .4543 L closepath p .274 g
F P
0 g
s
.52227 .44214 m .52324 .43654 L .52031 .38606 L p .031 g
F P
0 g
s
.52074 .45583 m .5207 .45676 L .52087 .45454 L closepath p .65 g
F P
0 g
s
.5247 .52287 m .52717 .54789 L .5179 .50327 L p .213 g
F P
0 g
s
.52717 .54789 m .5247 .52287 L .53537 .54191 L p .515 g
F P
0 g
s
.53537 .54191 m .54438 .57377 L .52717 .54789 L p .515 g
F P
0 g
s
.5207 .4548 m .5207 .45676 L .52071 .4562 L closepath p .569 g
F P
0 g
s
.52081 .45441 m .52071 .4562 L .52074 .45583 L p .793 g
F P
0 g
s
.52909 .42415 m .53303 .41511 L .52443 .43086 L p .904 g
F P
0 g
s
.52443 .43086 m .52324 .43654 L .52909 .42415 L p .904 g
F P
0 g
s
.51882 .46531 m .51941 .46345 L .5179 .50327 L p .034 g
F P
0 g
s
.52067 .45658 m .5207 .45676 L .52055 .45552 L closepath p .125 g
F P
0 g
s
.52051 .45855 m .52027 .45994 L .52018 .4603 L p .873 g
F P
0 g
s
.51941 .46345 m .5199 .46161 L .51986 .46279 L p .036 g
F P
0 g
s
.5194 .46643 m .51941 .46345 L .51986 .46279 L .036 g
F
.51907 .48391 m .51941 .46345 L .51935 .47853 L F
.5179 .50327 m .5192 .46895 L p .51907 .48391 L F P
0 g
s
.5192 .46895 m .51941 .46345 L p .51936 .46677 L .036 g
F P
0 g
s
.51907 .48391 m .5192 .46895 L .51936 .46677 L .036 g
F
.5199 .46161 m .51941 .46345 L .50882 .49447 L p .9 g
F P
0 g
s
.50882 .49447 m .50254 .51288 L p .5111 .48761 L .9 g
F P
0 g
s
.5199 .46161 m .50882 .49447 L .5111 .48761 L .9 g
F
.51986 .46279 m .51935 .47853 L p .5194 .46643 L .036 g
F P
0 g
s
.5199 .46161 m .52027 .45994 L .52022 .46179 L p .037 g
F P
0 g
s
.52022 .46179 m .51975 .47877 L p .51986 .4663 L .037 g
F P
0 g
s
.51986 .4663 m .5199 .46161 L .52022 .46179 L .037 g
F
.50254 .51288 m .50945 .49769 L .5199 .46161 L p .9 g
F P
0 g
s
.52027 .45994 m .5199 .46161 L .51134 .49117 L p .894 g
F P
0 g
s
.51134 .49117 m .50945 .49769 L p .51325 .48442 L .894 g
F P
0 g
s
.52027 .45994 m .51134 .49117 L .51325 .48442 L .894 g
F
.50945 .49769 m .51461 .4837 L .52027 .45994 L p F P
0 g
s
.52018 .4603 m .51966 .46249 L p .52028 .45952 L .873 g
F P
0 g
s
.51966 .46249 m .51701 .47361 L p .51969 .46203 L .873 g
F P
0 g
s
.51701 .47361 m .51461 .4837 L p .51689 .47399 L .873 g
F P
0 g
s
.51969 .46203 m .51701 .47361 L .51689 .47399 L .873 g
F
.51975 .47877 m .51896 .49044 L .51935 .47853 L p .037 g
F P
0 g
s
.51935 .47853 m .5199 .46161 L p .51986 .4663 L .037 g
F P
0 g
s
.51975 .47877 m .51935 .47853 L .51986 .4663 L .037 g
F
.51461 .4837 m .51802 .47202 L .52036 .45933 L p .873 g
F P
0 g
s
.5201 .46048 m .51977 .46255 L .51977 .46231 L .838 g
F
.52028 .45952 m .51966 .46249 L .51969 .46203 L .873 g
F
.52014 .46011 m .51461 .4837 L .52036 .45933 L F
.52048 .4584 m .5201 .46062 L .5201 .46048 L .838 g
F
.5201 .46062 m .51977 .46255 L .5201 .46048 L F
.45997 .57124 m .47915 .54782 L .50254 .51288 L p .934 g
F P
0 g
s
.50945 .49769 m .50254 .51288 L .4874 .5355 L p .914 g
F P
0 g
s
.4874 .5355 m .47915 .54782 L p .49404 .52319 L .914 g
F P
0 g
s
.50945 .49769 m .4874 .5355 L .49404 .52319 L .914 g
F
.47915 .54782 m .49496 .52369 L .50945 .49769 L p F P
0 g
s
.51461 .4837 m .50945 .49769 L .50059 .51359 L p .887 g
F P
0 g
s
.50059 .51359 m .49496 .52369 L p .50195 .50946 L .887 g
F P
0 g
s
.50554 .50216 m .50276 .50859 L .50195 .50946 L .887 g
F
.50276 .50859 m .50059 .51359 L .50195 .50946 L F
.51461 .4837 m .50059 .51359 L .50554 .50216 L F
.49496 .52369 m .50679 .50112 L .511 .49173 L p F P
0 g
s
.50719 .4988 m .49496 .52369 L .511 .49173 L .887 g
F
.50003 .50891 m .50679 .50112 L p .49614 .5158 L .853 g
F P
0 g
s
.48241 .5347 m .49298 .51923 L p .49614 .5158 L .853 g
F P
0 g
s
.49298 .51923 m .50003 .50891 L p .49614 .5158 L .853 g
F P
0 g
s
.511 .49173 m .51461 .4837 L p .50719 .4988 L .887 g
F P
0 g
s
.51461 .4837 m .51013 .49366 L p .51277 .48644 L .855 g
F P
0 g
s
.51802 .47202 m .5148 .48304 L p .51277 .48644 L .855 g
F P
0 g
s
.5148 .48304 m .51461 .4837 L p .51277 .48644 L .855 g
F P
0 g
s
.51013 .49366 m .50679 .50112 L p .51348 .48378 L .855 g
F P
0 g
s
.51802 .47202 m .51013 .49366 L .51348 .48378 L .855 g
F
.50679 .50112 m .51267 .48673 L p .51412 .48234 L F P
0 g
s
.51466 .48071 m .5133 .48424 L .51412 .48234 L .855 g
F
.5133 .48424 m .50679 .50112 L .51412 .48234 L F
.51267 .48673 m .51458 .48206 L p .51466 .48071 L F P
0 g
s
.51162 .48679 m .51458 .48206 L p .50697 .4961 L .835 g
F P
0 g
s
.50003 .50891 m .50515 .49914 L p .50697 .4961 L .835 g
F P
0 g
s
.50515 .49914 m .51162 .48679 L p .50697 .4961 L .835 g
F P
0 g
s
.52027 .45994 m .52051 .45855 L .52028 .46914 L p .039 g
F P
0 g
s
.52028 .46914 m .51975 .47877 L .52027 .45994 L p .039 g
F P
0 g
s
.51802 .47202 m .51988 .46345 L .52037 .45963 L p .838 g
F P
0 g
s
.52051 .45855 m .52018 .4603 L .52028 .45952 L .873 g
F
.52036 .45933 m .52051 .45855 L p .52014 .46011 L F P
0 g
s
.52034 .45945 m .51977 .46255 L p .52035 .45917 L .838 g
F P
0 g
s
.51977 .46255 m .51952 .46389 L p .51977 .46231 L .838 g
F P
0 g
s
.51952 .46389 m .51802 .47202 L p .5194 .46436 L .838 g
F P
0 g
s
.51977 .46231 m .51952 .46389 L .5194 .46436 L .838 g
F
.52013 .46035 m .5194 .46436 L .52037 .45963 L F
.5194 .46436 m .51802 .47202 L .51951 .46415 L F
.5194 .46436 m .51951 .46415 L .52037 .45963 L F
.51458 .48206 m .51802 .47202 L p .51466 .48071 L .855 g
F P
0 g
s
.51988 .46345 m .51888 .46802 L p .51816 .46988 L .816 g
F P
0 g
s
.51606 .47773 m .51458 .48206 L p .51805 .46988 L .816 g
F P
0 g
s
.51988 .46345 m .51606 .47773 L .51805 .46988 L .816 g
F
.51793 .47015 m .51883 .46793 L p .51421 .48003 L .81 g
F P
0 g
s
.51162 .48679 m .51344 .482 L p .51421 .48003 L .81 g
F P
0 g
s
.51344 .482 m .51793 .47015 L p .51421 .48003 L .81 g
F P
0 g
s
.51802 .47202 m .51606 .47773 L p .51816 .46988 L .816 g
F P
0 g
s
.51888 .46802 m .51802 .47202 L p .51816 .46988 L .816 g
F P
0 g
s
.52064 .45754 m .52051 .45855 L .52034 .45945 L p .838 g
F P
0 g
s
.52064 .45754 m .52048 .45846 L .52048 .4584 L .838 g
F
.52048 .45846 m .51977 .46255 L .52048 .4584 L F
.52064 .45754 m .52034 .45945 L .52035 .45917 L F
.52037 .45963 m .52064 .45754 L p .52013 .46035 L F P
0 g
s
.52064 .45754 m .52039 .45947 L p .52068 .45701 L .768 g
F P
0 g
s
.52068 .45701 m .52039 .45947 L .52035 .45964 L .768 g
F
.52069 .45695 m .52068 .45702 L p .52068 .45701 L F P
0 g
s
.52068 .45702 m .52064 .45754 L p .52068 .45701 L .768 g
F P
0 g
s
.52051 .45855 m .52064 .45754 L .52057 .46214 L p .041 g
F P
0 g
s
.52059 .45837 m .52069 .45695 L p .52035 .45964 L .768 g
F P
0 g
s
.52039 .45947 m .51988 .46345 L p .52035 .45964 L .768 g
F P
0 g
s
.51988 .46345 m .52046 .45931 L p .52035 .45964 L .768 g
F P
0 g
s
.52046 .45931 m .52059 .45837 L p .52035 .45964 L .768 g
F P
0 g
s
.52057 .46214 m .52028 .46914 L .52051 .45855 L p .041 g
F P
0 g
s
.51883 .46793 m .51988 .46345 L p .51797 .47014 L .816 g
F P
0 g
s
.52059 .45837 m .51988 .46345 L .51902 .4671 L p .758 g
F P
0 g
s
.51902 .4671 m .51883 .46793 L p .51894 .46731 L .758 g
F P
0 g
s
.52059 .45837 m .51902 .4671 L .51894 .46731 L .758 g
F
.52007 .46118 m .51961 .46369 L .52033 .46009 L F
.52007 .46118 m .52033 .46009 L .52046 .45948 L F
.52046 .45948 m .52059 .45837 L p .52007 .46118 L F P
0 g
s
.51883 .46793 m .51976 .46311 L p .51961 .46369 L .758 g
F P
0 g
s
.51976 .46311 m .52046 .45948 L p .51961 .46369 L .758 g
F P
0 g
s
.52046 .45948 m .51883 .46793 L .51793 .47015 L p .773 g
F P
0 g
s
.52034 .46005 m .52046 .45948 L p .51933 .46422 L .773 g
F P
0 g
s
.51793 .47015 m .51916 .46499 L p .51933 .46422 L .773 g
F P
0 g
s
.51916 .46499 m .52034 .46005 L p .51933 .46422 L .773 g
F P
0 g
s
.52034 .46005 m .51802 .46978 L p .51758 .46978 L .792 g
F P
0 g
s
.51802 .46978 m .51793 .47015 L .51789 .47011 L p .792 g
F P
0 g
s
.51789 .47011 m .51758 .46978 L p .51802 .46978 L .792 g
F P
0 g
s
.52034 .46005 m .5203 .46 L .52067 .45698 L p .771 g
F P
0 g
s
.52067 .45698 m .5207 .45676 L .52067 .45699 L p .771 g
F P
0 g
s
.52067 .45699 m .52034 .46005 L p .52067 .45698 L .771 g
F P
0 g
s
.51797 .47014 m .51734 .47236 L .51765 .47143 L .816 g
F
.51797 .47014 m .51765 .47143 L .51883 .46793 L F
.51458 .48206 m .51875 .4682 L p .51734 .47236 L F P
0 g
s
.51875 .4682 m .51883 .46793 L p .51734 .47236 L .816 g
F P
0 g
s
.51935 .47853 m .51896 .49044 L p .51907 .48391 L .036 g
F P
0 g
s
.51896 .49044 m .51879 .49251 L p .51907 .48391 L .036 g
F P
0 g
s
.51879 .49251 m .5179 .50327 L p .51907 .48391 L .036 g
F P
0 g
s
.5179 .50327 m .51896 .49044 L .5247 .52287 L p .213 g
F P
0 g
s
.52071 .4562 m .5207 .45676 L .52074 .45583 L closepath p .609 g
F P
0 g
s
.44261 .3952 m .42958 .39585 L .50628 .44968 L p .642 g
F P
0 g
s
.5207 .45676 m .52076 .45729 L .5209 .45865 L closepath p .209 g
F P
0 g
s
.5209 .45865 m .52076 .45729 L p .52077 .45733 L .453 g
F P
0 g
s
.52107 .45938 m .52096 .45891 L p .52079 .45744 L .453 g
F P
0 g
s
.52076 .45729 m .52121 .4589 L .52229 .46443 L p .453 g
F P
0 g
s
.5216 .46019 m .52081 .45763 L .52097 .45884 L p .616 g
F P
0 g
s
.52097 .45884 m .52081 .45763 L .52074 .45707 L p .03 g
F P
0 g
s
.52077 .45733 m .52079 .45744 L .52096 .45891 L .453 g
F
.52121 .4589 m .52077 .45731 L p .52081 .45763 L .507 g
F P
0 g
s
.52073 .45698 m .52096 .45874 L p .52074 .45707 L .03 g
F P
0 g
s
.52096 .45874 m .52097 .45884 L p .52096 .45871 L .03 g
F P
0 g
s
.52096 .45874 m .52096 .45871 L .52074 .45707 L .03 g
F
.52077 .45731 m .52076 .45729 L .52081 .45763 L p .507 g
F P
0 g
s
.52107 .45962 m .52097 .45884 L .52081 .45761 L p .604 g
F P
0 g
s
.5207 .45676 m .52081 .45763 L .52076 .45729 L closepath p .051 g
F P
0 g
s
.5207 .45676 m .52107 .45986 L .52107 .45962 L closepath p .703 g
F P
0 g
s
.52096 .45891 m .5209 .45865 L p .52077 .45733 L .453 g
F P
0 g
s
.5209 .45865 m .52229 .46443 L .52272 .46876 L p .457 g
F P
0 g
s
.52099 .45953 m .52107 .45986 L .52076 .45725 L p .688 g
F P
0 g
s
.52076 .45725 m .5207 .45676 L .52075 .45727 L p .688 g
F P
0 g
s
.52079 .45768 m .52099 .45953 L p .5208 .45768 L .688 g
F P
0 g
s
.5207 .45676 m .5209 .45865 L .52095 .45968 L closepath p .326 g
F P
0 g
s
.5207 .45676 m .52086 .45871 L .52099 .45953 L closepath p .648 g
F P
0 g
s
.52229 .46443 m .52107 .45938 L p .52079 .45744 L .453 g
F P
0 g
s
.52593 .47391 m .52229 .46443 L .52121 .4589 L p .521 g
F P
0 g
s
.5229 .4648 m .52097 .45884 L .52107 .45962 L p .612 g
F P
0 g
s
.52272 .46876 m .52095 .45968 L .5209 .45865 L p .457 g
F P
0 g
s
.52367 .46766 m .52107 .45962 L .52107 .45986 L p .602 g
F P
0 g
s
.5227 .46476 m .52323 .46688 L .52367 .46766 L .602 g
F
.5225 .4645 m .52323 .46688 L p .5227 .46476 L F P
0 g
s
.52107 .45986 m .5225 .4645 L p .5227 .46476 L .602 g
F P
0 g
s
.52107 .45986 m .52099 .45953 L p .52253 .46458 L .615 g
F P
0 g
s
.52229 .46443 m .52593 .47391 L .52736 .48393 L p .521 g
F P
0 g
s
.52121 .4589 m .52238 .46149 L .52593 .47391 L p .521 g
F P
0 g
s
.53263 .48649 m .52593 .47391 L .52238 .46149 L p .557 g
F P
0 g
s
.52238 .46149 m .52453 .46483 L .53263 .48649 L p .557 g
F P
0 g
s
.54282 .50113 m .53263 .48649 L .52453 .46483 L p .584 g
F P
0 g
s
.5305 .47962 m .52367 .46766 L .52369 .46837 L p .448 g
F P
0 g
s
.52253 .46458 m .52341 .46745 L .5225 .4645 L .615 g
F
.52369 .46837 m .52368 .46803 L p .52348 .46752 L .602 g
F P
0 g
s
.52323 .46688 m .52341 .46744 L p .52348 .46752 L .602 g
F P
0 g
s
.52341 .46744 m .52369 .46837 L p .52348 .46752 L .602 g
F P
0 g
s
.52369 .46837 m .53059 .48065 L .5305 .47962 L p .448 g
F P
0 g
s
.52369 .46837 m .52303 .46697 L p .52635 .47297 L .438 g
F P
0 g
s
.52635 .47297 m .52886 .47751 L .52664 .47358 L .438 g
F
.52635 .47297 m .52664 .47358 L .52369 .46837 L F
.52369 .46837 m .52341 .46744 L p .52341 .46745 L .615 g
F P
0 g
s
.52341 .46744 m .5225 .4645 L p .52341 .46745 L .615 g
F P
0 g
s
.5225 .4645 m .52107 .45986 L p .52253 .46458 L .615 g
F P
0 g
s
.52303 .46697 m .52355 .46791 L p .52103 .45968 L .615 g
F P
0 g
s
.52103 .45969 m .52303 .46697 L .52103 .45968 L .615 g
F
.52086 .45871 m .52074 .45756 L p .52123 .45996 L .635 g
F P
0 g
s
.52099 .45953 m .52103 .45969 L .52103 .45968 L .615 g
F
.52099 .45953 m .52086 .45871 L p .52233 .46429 L .623 g
F P
0 g
s
.52257 .46528 m .52099 .45953 L p .52233 .46429 L .623 g
F P
0 g
s
.52303 .46697 m .52257 .46528 L p .52235 .46437 L .623 g
F P
0 g
s
.52233 .46429 m .52235 .46437 L .52235 .46437 L .623 g
F
.52235 .46437 m .52303 .46697 L .52235 .46437 L F
.52201 .46384 m .52303 .46697 L p .52136 .4606 L F P
0 g
s
.52086 .45871 m .52134 .46085 L p .52136 .4606 L .623 g
F P
0 g
s
.52134 .46085 m .52201 .46384 L p .52136 .4606 L .623 g
F P
0 g
s
.52201 .46384 m .52098 .45925 L p .52123 .45996 L .635 g
F P
0 g
s
.52114 .45993 m .52195 .46356 L p .52116 .45965 L .635 g
F P
0 g
s
.52073 .45928 m .52098 .46732 L .52057 .46214 L p .424 g
F P
0 g
s
.52098 .46732 m .52073 .45928 L .52083 .46005 L p .491 g
F P
0 g
s
.52247 .47096 m .52092 .46018 L .52095 .45968 L p .474 g
F P
0 g
s
.52095 .45968 m .52272 .46876 L .52247 .47096 L p .474 g
F P
0 g
s
.52083 .46005 m .52175 .47047 L .52098 .46732 L p .491 g
F P
0 g
s
.52175 .47047 m .52083 .46005 L .52092 .46018 L p .49 g
F P
0 g
s
.52092 .46018 m .52247 .47096 L .52175 .47047 L p .49 g
F P
0 g
s
.52028 .46914 m .52057 .46214 L .52098 .46732 L p .346 g
F P
0 g
s
.52928 .47831 m .52579 .47209 L p .52886 .47751 L .438 g
F P
0 g
s
.52579 .47209 m .52369 .46837 L p .52582 .47214 L .438 g
F P
0 g
s
.52886 .47751 m .52579 .47209 L .52582 .47214 L .438 g
F
.52453 .46483 m .52781 .46864 L .54282 .50113 L p .584 g
F P
0 g
s
.55649 .51649 m .54282 .50113 L .52781 .46864 L p .607 g
F P
0 g
s
.52367 .46766 m .5305 .47962 L .52794 .47394 L p .52 g
F P
0 g
s
.53725 .48514 m .52794 .47394 L .5305 .47962 L p .415 g
F P
0 g
s
.52781 .46864 m .53221 .47252 L .55649 .51649 L p .607 g
F P
0 g
s
.5305 .47962 m .54316 .49382 L .53725 .48514 L p .415 g
F P
0 g
s
.54316 .49382 m .5305 .47962 L .53059 .48065 L p .242 g
F P
0 g
s
.53062 .47798 m .5384 .48868 L p .52775 .47443 L .056 g
F P
0 g
s
.52886 .47751 m .52956 .47878 L .52928 .47831 L .438 g
F
.53059 .48065 m .52951 .47873 L p .52956 .47878 L F P
0 g
s
.52951 .47873 m .52928 .47831 L p .52956 .47878 L .438 g
F P
0 g
s
.53059 .48065 m .5434 .49466 L .54316 .49382 L p .242 g
F P
0 g
s
.5384 .48868 m .5434 .49466 L p .53038 .47964 L .058 g
F P
0 g
s
.52841 .47736 m .53059 .48065 L p .52956 .47878 L .438 g
F P
0 g
s
.52383 .46841 m .52841 .47736 L .52956 .47878 L .438 g
F
.52841 .47736 m .53083 .4801 L p .53038 .47964 L .058 g
F P
0 g
s
.53083 .4801 m .5384 .48868 L p .53038 .47964 L .058 g
F P
0 g
s
.5241 .46903 m .52841 .47736 L p .52383 .46841 L .438 g
F P
0 g
s
.52311 .46711 m .5241 .46903 L .52383 .46841 L .438 g
F
.52303 .46697 m .5231 .4671 L p .52311 .46711 L F P
0 g
s
.5231 .4671 m .5241 .46903 L p .52311 .46711 L .438 g
F P
0 g
s
.52368 .46803 m .52367 .46766 L p .52323 .46688 L .602 g
F P
0 g
s
.52107 .45962 m .52367 .46766 L .5229 .4648 L p .612 g
F P
0 g
s
.52794 .47394 m .5229 .4648 L .52367 .46766 L p .52 g
F P
0 g
s
.52841 .47736 m .52303 .46697 L .52201 .46384 L p .465 g
F P
0 g
s
.52513 .47097 m .52632 .47329 L p .52403 .46828 L .465 g
F P
0 g
s
.52736 .48393 m .52272 .46876 L .52229 .46443 L p .521 g
F P
0 g
s
.52205 .46392 m .52513 .47097 L .52403 .46828 L .465 g
F
.52632 .47329 m .52841 .47736 L p .52373 .46746 L F P
0 g
s
.52276 .46543 m .52632 .47329 L .52373 .46746 L .465 g
F
.52205 .46392 m .52275 .46547 L .52276 .46543 L F
.52275 .46547 m .52632 .47329 L .52276 .46543 L F
.51975 .47877 m .52028 .46914 L .52164 .48106 L p .302 g
F P
0 g
s
.52098 .46732 m .52164 .48106 L .52028 .46914 L p .346 g
F P
0 g
s
.52503 .47078 m .52513 .47097 L p .52367 .46764 L .465 g
F P
0 g
s
.52205 .46392 m .52363 .46756 L .52367 .46764 L .465 g
F
.52363 .46756 m .52503 .47078 L .52367 .46764 L F
.52201 .46384 m .52204 .46391 L p .52205 .46392 L F P
0 g
s
.52204 .46391 m .52503 .47078 L p .52205 .46392 L .465 g
F P
0 g
s
.52195 .46356 m .52201 .46384 L p .52196 .46359 L .635 g
F P
0 g
s
.52098 .45875 m .52195 .46356 L .52196 .46359 L .635 g
F
.52503 .47078 m .52201 .46384 L .52143 .46125 L p .509 g
F P
0 g
s
.52143 .46125 m .52107 .45962 L p .52158 .46106 L .509 g
F P
0 g
s
.5229 .4648 m .52794 .47394 L .52365 .46422 L p .556 g
F P
0 g
s
.5223 .46309 m .52503 .47078 L .52177 .46215 L .509 g
F
.52164 .48106 m .52098 .46732 L .52175 .47047 L p .492 g
F P
0 g
s
.52206 .46245 m .52403 .46808 L .52404 .4681 L .509 g
F
.52206 .46245 m .52403 .46808 L .52206 .46245 L F
.52158 .46108 m .52403 .46808 L .52158 .46108 L F
.52365 .46422 m .5216 .46019 L .5229 .4648 L p .556 g
F P
0 g
s
.52743 .46929 m .52365 .46422 L .52794 .47394 L p .524 g
F P
0 g
s
.52794 .47394 m .53725 .48514 L .52743 .46929 L p .524 g
F P
0 g
s
.52349 .46502 m .52408 .46608 L p .52298 .46424 L .045 g
F P
0 g
s
.52408 .46608 m .52847 .47407 L p .5241 .46624 L .045 g
F P
0 g
s
.52298 .46424 m .52408 .46608 L .5241 .46624 L .045 g
F
.52051 .47344 m .52037 .477 L .52168 .467 L p 0 g
F P
s
.52051 .47344 m .52168 .467 L .52161 .46705 L F
.52051 .47344 m .52187 .46554 L .52192 .46466 L F
.52187 .46554 m .52037 .477 L p .52206 .46855 L .629 g
F P
0 g
s
.52117 .4599 m .52404 .4681 L .52276 .4644 L .509 g
F
.52098 .45875 m .52114 .45993 L .52116 .45965 L .635 g
F
.52107 .45962 m .52117 .45991 L .52117 .4599 L .509 g
F
.52158 .46106 m .5223 .46309 L .52143 .46125 L F
.52117 .45991 m .52404 .4681 L .52117 .4599 L F
.5223 .46309 m .52177 .46215 L .52143 .46125 L F
.52192 .46233 m .52403 .46808 L p .52117 .45991 L F P
0 g
s
.52107 .45962 m .52118 .45997 L p .52117 .45991 L .509 g
F P
0 g
s
.52118 .45997 m .52192 .46233 L p .52117 .45991 L .509 g
F P
0 g
s
.52064 .47262 m .52192 .46466 L .52068 .47153 L F
.52286 .46402 m .52847 .47407 L .52618 .47 L .045 g
F
.52192 .46233 m .52286 .46402 L .52286 .46402 L F
.52286 .46402 m .52847 .47407 L .52286 .46402 L F
.52453 .46483 m .52238 .46149 L .52365 .46422 L p .495 g
F P
0 g
s
.52097 .45884 m .5229 .4648 L .5216 .46019 L p .616 g
F P
0 g
s
.5216 .46019 m .52365 .46422 L .52238 .46149 L p .542 g
F P
0 g
s
.52781 .46864 m .52453 .46483 L .52743 .46929 L p .445 g
F P
0 g
s
.52365 .46422 m .52743 .46929 L .52453 .46483 L p .495 g
F P
0 g
s
.52158 .46108 m .52206 .46245 L .52206 .46245 L .509 g
F
.52107 .45962 m .52158 .46108 L .52158 .46108 L F
.52098 .45925 m .52086 .45871 L p .52123 .45996 L .635 g
F P
0 g
s
.52107 .45962 m .52114 .45993 L p .52098 .45875 L .635 g
F P
0 g
s
.52107 .45962 m .52081 .45847 L p .52136 .46038 L .543 g
F P
0 g
s
.52192 .46233 m .52113 .45983 L p .52136 .46038 L .543 g
F P
0 g
s
.52113 .45983 m .52107 .45962 L p .52136 .46038 L .543 g
F P
0 g
s
.52081 .45847 m .52106 .46005 L .52192 .46233 L p .543 g
F P
0 g
s
.52349 .46502 m .52192 .46233 L .52164 .4616 L p .428 g
F P
0 g
s
.52164 .4616 m .52106 .46005 L p .52212 .46222 L .428 g
F P
0 g
s
.52212 .46222 m .5228 .46361 L .52164 .4616 L .428 g
F
.5228 .46361 m .52349 .46502 L .52271 .46358 L F
.5228 .46361 m .52271 .46358 L .52164 .4616 L F
.52183 .4621 m .52262 .46348 L p .52197 .46205 L F P
0 g
s
.52106 .46005 m .52171 .46177 L .52197 .46205 L .428 g
F
.52171 .46177 m .52183 .4621 L .52197 .46205 L F
.52262 .46348 m .52349 .46502 L p .52202 .46201 L F P
0 g
s
.52106 .46005 m .52262 .46348 L .52202 .46201 L .428 g
F
.52192 .46233 m .52299 .46417 L p .52298 .46424 L .045 g
F P
0 g
s
.52276 .4644 m .52404 .4681 L .52418 .46838 L .509 g
F
.52403 .46808 m .52503 .47078 L p .52418 .46838 L F P
0 g
s
.53062 .47798 m .52503 .47078 L .52192 .46233 L p .045 g
F P
0 g
s
.52589 .46697 m .52349 .46502 L .52153 .46158 L p .236 g
F P
0 g
s
.52225 .46261 m .52187 .46554 L p .52284 .46356 L .629 g
F P
0 g
s
.52225 .46261 m .52442 .46521 L p .52189 .46203 L .236 g
F P
0 g
s
.52153 .46158 m .52442 .46521 L .5235 .46401 L .236 g
F
.52322 .46277 m .52529 .46444 L p .52272 .46289 L .165 g
F P
0 g
s
.52225 .46261 m .52322 .46277 L p .52272 .46289 L .165 g
F P
0 g
s
.52225 .46261 m .52529 .46444 L .52437 .46414 L .165 g
F
.52442 .46521 m .52589 .46697 L p .5235 .46401 L .236 g
F P
0 g
s
.52914 .46757 m .52589 .46697 L .52258 .463 L p .165 g
F P
0 g
s
.52258 .463 m .52225 .46261 L p .52266 .4629 L .165 g
F P
0 g
s
.52266 .4629 m .52914 .46757 L .52258 .463 L .165 g
F
.52206 .46855 m .52306 .46359 L .52187 .46554 L .629 g
F
.52119 .47256 m .52274 .4651 L p .52193 .46923 L F P
0 g
s
.52274 .4651 m .52307 .46353 L p .52281 .46482 L .629 g
F P
0 g
s
.52193 .46923 m .52274 .4651 L .52281 .46482 L .629 g
F
.52306 .46359 m .52322 .46277 L .52292 .4634 L F
.52307 .46353 m .52322 .46277 L p .52306 .46359 L F P
0 g
s
.52193 .46923 m .52307 .46353 L .52306 .46359 L .629 g
F
.52299 .46417 m .52349 .46502 L p .52298 .46424 L .045 g
F P
0 g
s
.52037 .477 m .52051 .47344 L .51564 .48273 L p F P
s
.51458 .48206 m .50679 .50112 L .50003 .50891 L p .835 g
F P
0 g
s
.51564 .48273 m .51126 .48861 L .52037 .477 L p F P
s
.52018 .47748 m .52037 .477 L .51126 .48861 L p .881 g
F P
0 g
s
.52037 .477 m .52018 .47748 L .52119 .47256 L p .629 g
F P
0 g
s
.52037 .477 m .52119 .47256 L .52193 .46923 L .629 g
F
.52175 .47047 m .52417 .48822 L .52164 .48106 L p .492 g
F P
0 g
s
.52417 .48822 m .52175 .47047 L .52247 .47096 L p .521 g
F P
0 g
s
.57317 .53109 m .55649 .51649 L .53221 .47252 L p .627 g
F P
0 g
s
.53319 .47488 m .52743 .46929 L .53725 .48514 L p .499 g
F P
0 g
s
.59196 .54343 m .57317 .53109 L .53759 .47608 L p .644 g
F P
0 g
s
.53221 .47252 m .53759 .47608 L .57317 .53109 L p .627 g
F P
0 g
s
.53725 .48514 m .55148 .49706 L .53319 .47488 L p .499 g
F P
0 g
s
.53923 .48379 m .53062 .47798 L .52349 .46502 L p .095 g
F P
0 g
s
.52743 .46929 m .53319 .47488 L .52781 .46864 L p .445 g
F P
0 g
s
.52589 .46697 m .53923 .48379 L p .52549 .46741 L .095 g
F P
0 g
s
.52349 .46502 m .52548 .46664 L p .52549 .46741 L .095 g
F P
0 g
s
.52548 .46664 m .52589 .46697 L p .52549 .46741 L .095 g
F P
0 g
s
.52207 .46831 m .52018 .47748 L p .52396 .46346 L .684 g
F P
0 g
s
.53315 .4663 m .52914 .46757 L .52322 .46277 L p .284 g
F P
0 g
s
.52442 .46177 m .53315 .4663 L p .52368 .46293 L .284 g
F P
0 g
s
.52322 .46277 m .52442 .46177 L p .52368 .46293 L .284 g
F P
0 g
s
.53773 .46288 m .53315 .4663 L .52442 .46177 L p .389 g
F P
0 g
s
.52442 .46177 m .52578 .45944 L .53773 .46288 L p .389 g
F P
0 g
s
.52442 .46177 m .5237 .46369 L p .52541 .46021 L .72 g
F P
0 g
s
.52578 .45944 m .52442 .46177 L p .52541 .46021 L .72 g
F P
0 g
s
.52396 .46346 m .52421 .46253 L .52207 .46831 L .684 g
F
.52322 .46277 m .52207 .46831 L p .52421 .46253 L F P
0 g
s
.52051 .47344 m .52153 .46158 L p .52096 .46569 L .003 g
F P
0 g
s
.52056 .47068 m .52051 .47344 L p .52096 .46569 L .003 g
F P
0 g
s
.52068 .47153 m .52051 .47344 L p .52064 .47262 L F P
s
.52051 .47344 m .52061 .46817 L .51848 .47439 L p F P
s
.51848 .47439 m .51564 .48273 L .52051 .47344 L p F P
s
.52018 .47748 m .51994 .47379 L .5237 .46369 L p .684 g
F P
0 g
s
.52274 .46628 m .52194 .46844 L p .5231 .46604 L .72 g
F P
0 g
s
.52194 .46844 m .51994 .47379 L p .52167 .46956 L .72 g
F P
0 g
s
.52167 .46956 m .5231 .46604 L .52194 .46844 L .72 g
F
.52442 .46177 m .52322 .46277 L p .52421 .46253 L .684 g
F P
0 g
s
.52322 .46277 m .52225 .46261 L p .52284 .46356 L .629 g
F P
0 g
s
.52018 .47748 m .5237 .46369 L .52378 .46415 L .684 g
F
.5237 .46369 m .52274 .46628 L p .52393 .4636 L .72 g
F P
0 g
s
.5237 .46369 m .52442 .46177 L p .52378 .46415 L .684 g
F P
0 g
s
.52393 .4636 m .52578 .45944 L .5237 .46369 L .72 g
F
.52192 .46466 m .52225 .46261 L .52191 .46456 L 0 g
F
.52192 .46466 m .52191 .46456 L .52068 .47153 L F
.5215 .46198 m .52068 .47153 L p .52191 .46456 L F P
s
.52191 .46456 m .52225 .46261 L .5215 .46198 L F
.52306 .46359 m .52292 .4634 L .52187 .46554 L .629 g
F
.5231 .46604 m .52578 .45944 L .52274 .46628 L .72 g
F
.52168 .467 m .52187 .46554 L p .52161 .46705 L 0 g
F P
s
.52187 .46554 m .52225 .46261 L p .52192 .46466 L F P
s
.52061 .46817 m .52056 .47068 L p .52096 .46569 L .003 g
F P
0 g
s
.52061 .45931 m .52002 .46584 L .52067 .46267 L p .289 g
F P
0 g
s
.52002 .46584 m .52061 .45931 L .52051 .45974 L p .312 g
F P
0 g
s
.52051 .45974 m .51921 .46745 L .52002 .46584 L p .312 g
F P
0 g
s
.52153 .46158 m .52106 .46005 L .52061 .46817 L p .003 g
F P
0 g
s
.52067 .46267 m .52061 .46817 L .52106 .46005 L p .017 g
F P
0 g
s
.52061 .46817 m .52067 .46267 L .52002 .46584 L p .088 g
F P
0 g
s
.52002 .46584 m .51848 .47439 L .52061 .46817 L p .088 g
F P
0 g
s
.51848 .47439 m .52002 .46584 L .51921 .46745 L p .149 g
F P
0 g
s
.51994 .47379 m .51968 .46526 L .52537 .45983 L p .72 g
F P
0 g
s
.52537 .45983 m .52578 .45944 L p .52538 .46043 L .72 g
F P
0 g
s
.51994 .47379 m .52537 .45983 L .52538 .46043 L .72 g
F
.52153 .46158 m .52225 .46261 L p .52189 .46203 L .236 g
F P
0 g
s
.52529 .46444 m .52914 .46757 L p .52437 .46414 L .165 g
F P
0 g
s
.52106 .46005 m .52153 .46158 L .52183 .4621 L p .428 g
F P
0 g
s
.52225 .46261 m .52153 .46158 L .5215 .46198 L p F P
s
.52847 .47407 m .53062 .47798 L p .52618 .47 L .045 g
F P
0 g
s
.52503 .47078 m .52919 .47614 L p .52775 .47443 L .056 g
F P
0 g
s
.52919 .47614 m .53062 .47798 L p .52775 .47443 L .056 g
F P
0 g
s
.52085 .45811 m .52089 .45837 L .52098 .45875 L .635 g
F
.52089 .45837 m .52107 .45962 L .52098 .45875 L F
.52076 .45766 m .52089 .45847 L .52085 .45811 L F
.5207 .45676 m .52095 .45968 L .52092 .46018 L closepath p .404 g
F P
0 g
s
.5207 .45676 m .52074 .45756 L .52086 .45871 L closepath p .605 g
F P
0 g
s
.52074 .45756 m .52076 .45765 L p .52076 .45766 L .635 g
F P
0 g
s
.52076 .45765 m .52089 .45847 L p .52076 .45766 L .635 g
F P
0 g
s
.52075 .45727 m .52079 .45768 L p .52076 .45725 L .688 g
F P
0 g
s
.52079 .45768 m .5208 .45768 L .52076 .45725 L .688 g
F
.52107 .45962 m .52074 .45756 L .52071 .45724 L p .581 g
F P
0 g
s
.52081 .45847 m .52107 .45962 L p .52073 .45737 L .581 g
F P
0 g
s
.5207 .45676 m .52092 .46018 L .52083 .46005 L closepath p .461 g
F P
0 g
s
.5207 .45676 m .52071 .45724 L .52074 .45756 L closepath p .563 g
F P
0 g
s
.52071 .45724 m .52072 .45739 L p .52073 .45737 L .581 g
F P
0 g
s
.52072 .45739 m .52081 .45847 L p .52073 .45737 L .581 g
F P
0 g
s
.52089 .45847 m .52107 .45962 L p .52085 .45811 L .635 g
F P
0 g
s
.52081 .45761 m .52073 .45698 L p .52081 .45765 L .604 g
F P
0 g
s
.52081 .45765 m .52107 .45962 L .52081 .45761 L .604 g
F
.52074 .45707 m .5207 .45676 L .52073 .45698 L p .03 g
F P
0 g
s
.52073 .45698 m .5207 .45676 L .52072 .45694 L p .604 g
F P
0 g
s
.52072 .45694 m .52107 .45962 L p .52073 .45698 L .604 g
F P
0 g
s
.5207 .45676 m .52073 .45928 L .52068 .45805 L closepath p .55 g
F P
0 g
s
.5207 .45676 m .52069 .45842 L .52071 .45724 L closepath p .521 g
F P
0 g
s
.5207 .45676 m .52068 .45805 L .52069 .45695 L closepath p .589 g
F P
0 g
s
.52068 .45805 m .52057 .46214 L .52064 .45754 L p .048 g
F P
0 g
s
.5207 .45676 m .52061 .45931 L .52069 .45842 L closepath p .474 g
F P
0 g
s
.52064 .45754 m .52069 .45695 L p .52068 .45801 L .048 g
F P
0 g
s
.52069 .45695 m .52059 .45837 L .52069 .45686 L p .629 g
F P
0 g
s
.52069 .45686 m .5207 .45676 L .52069 .45695 L p .629 g
F P
0 g
s
.52069 .45695 m .52068 .45805 L p .52068 .45801 L .048 g
F P
0 g
s
.5207 .45676 m .52051 .45974 L .52061 .45931 L closepath p .421 g
F P
0 g
s
.5207 .45676 m .52059 .45837 L .52046 .45948 L closepath p .672 g
F P
0 g
s
.5207 .45676 m .52044 .45962 L .52051 .45974 L closepath p .353 g
F P
0 g
s
.5207 .45676 m .52046 .45948 L .52034 .46005 L closepath p .719 g
F P
0 g
s
.5207 .45676 m .52045 .45898 L .52044 .45962 L closepath p .259 g
F P
0 g
s
.5207 .45676 m .52055 .45791 L .52045 .45898 L closepath p .115 g
F P
0 g
s
.5203 .46 m .52035 .45936 L .52063 .45727 L p .811 g
F P
0 g
s
.52063 .45727 m .5207 .45676 L .52064 .45722 L p .811 g
F P
0 g
s
.52064 .45722 m .5203 .46 L p .52063 .45727 L .811 g
F P
0 g
s
.52035 .45936 m .52049 .45826 L .52061 .45737 L p .762 g
F P
0 g
s
.52069 .45683 m .52063 .45727 L p .52068 .45685 L .762 g
F P
0 g
s
.52055 .45791 m .52067 .45693 L p .52067 .45694 L .271 g
F P
0 g
s
.52068 .45685 m .5207 .45676 L .52069 .45683 L p .762 g
F P
0 g
s
.52067 .45693 m .5207 .45676 L .52068 .45685 L p .001 g
F P
0 g
s
.52061 .45737 m .52068 .45685 L p .52063 .45727 L .762 g
F P
0 g
s
.52068 .45685 m .52049 .45826 L .52067 .45693 L p .001 g
F P
0 g
s
.52052 .45741 m .52067 .45693 L .52049 .45826 L p .576 g
F P
0 g
s
.52063 .45727 m .52035 .45936 L p .52061 .45737 L .762 g
F P
0 g
s
.52053 .45798 m .52054 .45795 L p .52064 .45714 L .271 g
F P
0 g
s
.52067 .45694 m .52053 .45798 L .52064 .45714 L .271 g
F
.52051 .45805 m .52053 .45798 L p .52067 .45694 L F P
0 g
s
.52054 .45795 m .52055 .45791 L p .52065 .45709 L .271 g
F P
0 g
s
.52067 .45694 m .52054 .45795 L .52065 .45709 L .271 g
F
.52049 .45826 m .51909 .46259 L .52052 .45741 L p .576 g
F P
0 g
s
.51956 .46106 m .52051 .45805 L p .52067 .45694 L .271 g
F P
0 g
s
.52045 .45898 m .52055 .45791 L p .52049 .45816 L .258 g
F P
0 g
s
.51909 .46259 m .52049 .45826 L .52035 .45936 L p .762 g
F P
0 g
s
.52049 .45816 m .5202 .4593 L .52033 .45913 L .258 g
F
.52049 .45816 m .52033 .45913 L .52045 .45898 L F
.52035 .45936 m .518 .46703 L .51909 .46259 L p .762 g
F P
0 g
s
.518 .46703 m .52035 .45936 L .5203 .46 L p .8 g
F P
0 g
s
.5203 .46 m .51758 .46978 L .518 .46703 L p .8 g
F P
0 g
s
.51877 .46494 m .51971 .4616 L p .5202 .4593 L .258 g
F P
0 g
s
.51971 .4616 m .52045 .45898 L p .5202 .4593 L .258 g
F P
0 g
s
.5207 .45676 m .52067 .45693 L .52055 .45791 L closepath p .03 g
F P
0 g
s
.5207 .45676 m .52083 .46005 L .52073 .45928 L closepath p .508 g
F P
0 g
s
.52067 .45693 m .52052 .45741 L .51956 .46106 L p .271 g
F P
0 g
s
.52324 .43654 m .52443 .43086 L .52011 .3658 L p .03 g
F P
0 g
s
.52011 .3658 m .52031 .38606 L .52324 .43654 L p .03 g
F P
0 g
s
.52081 .45847 m .52071 .45724 L .52069 .45842 L p .054 g
F P
0 g
s
.52011 .45812 m .52052 .45741 L .51909 .46259 L p .563 g
F P
0 g
s
.51909 .46259 m .51542 .46922 L .52011 .45812 L p .563 g
F P
0 g
s
.51699 .46559 m .51956 .46106 L .52052 .45741 L p .337 g
F P
0 g
s
.52052 .45741 m .52011 .45812 L .51699 .46559 L p .337 g
F P
0 g
s
.49909 .31908 m .50608 .34982 L .52031 .38606 L p .199 g
F P
0 g
s
.50608 .34982 m .49909 .31908 L .47286 .30196 L p .554 g
F P
0 g
s
.52081 .45763 m .5216 .46019 L .52121 .4589 L p .507 g
F P
0 g
s
.42958 .39585 m .41859 .39973 L .5046 .45048 L p .646 g
F P
0 g
s
.52057 .46214 m .52068 .45805 L .52073 .45928 L p .424 g
F P
0 g
s
.57253 .49021 m .58368 .4898 L .55647 .48138 L p .377 g
F P
0 g
s
.52055 .45791 m .51956 .46106 L .51877 .46494 L p .258 g
F P
0 g
s
.54438 .57377 m .53537 .54191 L .54532 .54365 L p .607 g
F P
0 g
s
.54532 .54365 m .56043 .57565 L .54438 .57377 L p .607 g
F P
0 g
s
.51225 .47072 m .51699 .46559 L .52011 .45812 L p .353 g
F P
0 g
s
.52031 .38606 m .52011 .3658 L .49909 .31908 L p .199 g
F P
0 g
s
.52238 .46149 m .52121 .4589 L .5216 .46019 L p .542 g
F P
0 g
s
.43161 .28915 m .45577 .3169 L .47286 .30196 L p .698 g
F P
0 g
s
.45577 .3169 m .43161 .28915 L .43577 .33911 L p .699 g
F P
0 g
s
.52069 .45842 m .52067 .46267 L .52081 .45847 L p .054 g
F P
0 g
s
.52067 .46267 m .52069 .45842 L .52061 .45931 L p .289 g
F P
0 g
s
.41123 .32487 m .43577 .33911 L .43161 .28915 L p .73 g
F P
0 g
s
.53751 .40673 m .53303 .41511 L .53834 .4058 L p .763 g
F P
0 g
s
.53834 .4058 m .56402 .36075 L p .53751 .40673 L .763 g
F P
0 g
s
.56402 .36075 m .57996 .34188 L .53751 .40673 L p .763 g
F P
0 g
s
.5423 .39973 m .53751 .40673 L .54559 .39438 L p F P
s
.54559 .39438 m .57996 .34188 L p .5423 .39973 L F P
s
.5423 .39973 m .54706 .39478 L .53954 .40421 L p .886 g
F P
0 g
s
.53751 .40673 m .5423 .39973 L .53674 .4076 L p .934 g
F P
0 g
s
.53674 .4076 m .52721 .42109 L p .53751 .40673 L .934 g
F P
0 g
s
.52721 .42109 m .52578 .42555 L .53751 .40673 L p .934 g
F P
0 g
s
.52863 .41788 m .52721 .42109 L .52773 .42036 L p .886 g
F P
0 g
s
.52773 .42036 m .5423 .39973 L p .52863 .41788 L .886 g
F P
0 g
s
.53954 .40421 m .52863 .41788 L p .5423 .39973 L .886 g
F P
0 g
s
.52863 .41788 m .52994 .41623 L .52979 .41472 L p .013 g
F P
0 g
s
.52979 .41472 m .51909 .3103 L p .52863 .41788 L .013 g
F P
0 g
s
.51758 .46978 m .5203 .46 L .52034 .46005 L p .792 g
F P
0 g
s
.51869 .46716 m .52044 .45962 L .52045 .45898 L p .266 g
F P
0 g
s
.52045 .45898 m .51877 .46494 L .51869 .46716 L p .266 g
F P
0 g
s
.30248 .55026 m .33203 .55793 L .30615 .60772 L p .552 g
F P
0 g
s
.34307 .60461 m .30615 .60772 L .33203 .55793 L p .608 g
F P
0 g
s
.52106 .46005 m .52081 .45847 L .52067 .46267 L p .017 g
F P
0 g
s
.41859 .39973 m .41054 .40662 L .5034 .45165 L p .645 g
F P
0 g
s
.50502 .47559 m .51225 .47072 L .51936 .45895 L p .362 g
F P
0 g
s
.51921 .46745 m .52051 .45974 L .52044 .45962 L p .294 g
F P
0 g
s
.52044 .45962 m .51869 .46716 L .51921 .46745 L p .294 g
F P
0 g
s
.39805 .609 m .43014 .58745 L .45997 .57124 L p .891 g
F P
0 g
s
.47915 .54782 m .45997 .57124 L .43014 .58745 L p .883 g
F P
0 g
s
.52578 .42555 m .52443 .43086 L .53303 .41511 L p .925 g
F P
0 g
s
.52443 .43086 m .52578 .42555 L .51988 .34656 L p .028 g
F P
0 g
s
.51988 .34656 m .52011 .3658 L .52443 .43086 L p .028 g
F P
0 g
s
.49526 .47933 m .50502 .47559 L .51822 .45979 L p .371 g
F P
0 g
s
.51896 .49044 m .51975 .47877 L .52285 .49999 L p .263 g
F P
0 g
s
.52285 .49999 m .5247 .52287 L .51896 .49044 L p .263 g
F P
0 g
s
.41054 .40662 m .4061 .41603 L .50276 .45311 L p .639 g
F P
0 g
s
.60213 .48267 m .59381 .48724 L .70256 .50859 L p .454 g
F P
0 g
s
.70256 .50859 m .72294 .49463 L .60213 .48267 L p .454 g
F P
0 g
s
.56117 .48856 m .57253 .49021 L .55014 .48079 L p .365 g
F P
0 g
s
.59711 .32628 m .57996 .34188 L .62534 .30846 L p .848 g
F P
0 g
s
.55146 .39237 m .54706 .39478 L .61347 .31652 L p .003 g
F P
0 g
s
.62534 .30846 m .65575 .29003 L .60391 .32207 L p .848 g
F P
0 g
s
.60391 .32207 m .59711 .32628 L p .60214 .3231 L .848 g
F P
0 g
s
.6144 .31542 m .59711 .32628 L .65575 .29003 L p .659 g
F P
0 g
s
.61347 .31652 m .6144 .31542 L p .61353 .31648 L .003 g
F P
0 g
s
.55146 .39237 m .61347 .31652 L .61353 .31648 L .003 g
F
.60214 .3231 m .62534 .30846 L .60391 .32207 L .848 g
F
.51542 .46922 m .51909 .46259 L .518 .46703 L p .706 g
F P
0 g
s
.518 .46703 m .51184 .47913 L .51542 .46922 L p .706 g
F P
0 g
s
.51437 .47327 m .51877 .46494 L .51956 .46106 L p .285 g
F P
0 g
s
.51956 .46106 m .51699 .46559 L .51437 .47327 L p .285 g
F P
0 g
s
.48324 .48118 m .49526 .47933 L .5167 .46051 L p .387 g
F P
0 g
s
.58732 .57934 m .56624 .55436 L .55649 .51649 L p .658 g
F P
0 g
s
.55649 .51649 m .57317 .53109 L .58732 .57934 L p .658 g
F P
0 g
s
.74226 .43878 m .74354 .45821 L .82928 .41843 L p .355 g
F P
0 g
s
.82928 .41843 m .82671 .39088 L .74226 .43878 L p .355 g
F P
0 g
s
.4061 .41603 m .40569 .42722 L .50275 .45473 L p .627 g
F P
0 g
s
.52164 .48106 m .52285 .49999 L .51975 .47877 L p .302 g
F P
0 g
s
.46955 .48054 m .48324 .48118 L .51483 .461 L p .41 g
F P
0 g
s
.41123 .32487 m .38648 .31593 L .44261 .3952 L p .699 g
F P
0 g
s
.42958 .39585 m .44261 .3952 L .38648 .31593 L p .715 g
F P
0 g
s
.55042 .48512 m .56117 .48856 L .5437 .47895 L p .365 g
F P
0 g
s
.53221 .47252 m .52781 .46864 L .53319 .47488 L p .405 g
F P
0 g
s
.40569 .42722 m .40939 .43926 L .50337 .45639 L p .608 g
F P
0 g
s
.51883 .46793 m .51458 .48206 L .51162 .48679 L p .81 g
F P
0 g
s
.45502 .47708 m .46955 .48054 L .51271 .46116 L p .44 g
F P
0 g
s
.53759 .47608 m .53221 .47252 L .54093 .48037 L p .377 g
F P
0 g
s
.53319 .47488 m .54093 .48037 L .53221 .47252 L p .405 g
F P
0 g
s
.54093 .48037 m .55042 .48512 L .53759 .47608 L p .377 g
F P
0 g
s
.52652 .48917 m .52247 .47096 L .52272 .46876 L p .524 g
F P
0 g
s
.52272 .46876 m .52736 .48393 L .52652 .48917 L p .524 g
F P
0 g
s
.5247 .52287 m .52285 .49999 L .52862 .51258 L p .51 g
F P
0 g
s
.52862 .51258 m .53537 .54191 L .5247 .52287 L p .51 g
F P
0 g
s
.40939 .43926 m .4169 .45116 L .50456 .45795 L p .582 g
F P
0 g
s
.44068 .47079 m .45502 .47708 L .51046 .46093 L p .475 g
F P
0 g
s
.34307 .60461 m .38134 .59355 L .39805 .609 L p .758 g
F P
0 g
s
.43014 .58745 m .39805 .609 L .38134 .59355 L p .783 g
F P
0 g
s
.3647 .47324 m .37496 .48554 L .27874 .53651 L p .478 g
F P
0 g
s
.30248 .55026 m .27874 .53651 L .37496 .48554 L p .509 g
F P
0 g
s
.4169 .45116 m .42763 .46195 L .50623 .45928 L p .549 g
F P
0 g
s
.42763 .46195 m .44068 .47079 L .50825 .4603 L p .513 g
F P
0 g
s
.52247 .47096 m .52652 .48917 L .52417 .48822 L p .521 g
F P
0 g
s
.56043 .57565 m .54532 .54365 L .54888 .52855 L p .632 g
F P
0 g
s
.54888 .52855 m .56624 .55436 L .56043 .57565 L p .632 g
F P
0 g
s
.51184 .47913 m .518 .46703 L .51758 .46978 L p .778 g
F P
0 g
s
.52578 .42555 m .52721 .42109 L .51962 .32994 L p .025 g
F P
0 g
s
.51962 .32994 m .51988 .34656 L .52578 .42555 L p .025 g
F P
0 g
s
.51048 .48557 m .51758 .46978 L .51793 .47015 L p .803 g
F P
0 g
s
.51793 .47015 m .51162 .48679 L .51048 .48557 L p .803 g
F P
0 g
s
.52285 .49999 m .52164 .48106 L .52417 .48822 L p .501 g
F P
0 g
s
.51758 .46978 m .51048 .48557 L .51184 .47913 L p .778 g
F P
0 g
s
.51409 .47743 m .51869 .46716 L .51877 .46494 L p .228 g
F P
0 g
s
.51877 .46494 m .51437 .47327 L .51409 .47743 L p .228 g
F P
0 g
s
.5359 .50437 m .52736 .48393 L .52593 .47391 L p .563 g
F P
0 g
s
.52593 .47391 m .53263 .48649 L .5359 .50437 L p .563 g
F P
0 g
s
.59381 .48724 m .58368 .4898 L .67744 .51814 L p .447 g
F P
0 g
s
.67744 .51814 m .70256 .50859 L .59381 .48724 L p .447 g
F P
0 g
s
.52417 .48822 m .52862 .51258 L .52285 .49999 L p .501 g
F P
0 g
s
.50868 .47737 m .51542 .46922 L .51184 .47913 L p .681 g
F P
0 g
s
.51184 .47913 m .50049 .49451 L .50868 .47737 L p .681 g
F P
0 g
s
.4984 .48604 m .50868 .47737 L .50049 .49451 L p .664 g
F P
0 g
s
.50625 .48235 m .51437 .47327 L .51699 .46559 L p .276 g
F P
0 g
s
.51699 .46559 m .51225 .47072 L .50625 .48235 L p .276 g
F P
0 g
s
.53537 .54191 m .52862 .51258 L .53399 .51399 L p .579 g
F P
0 g
s
.53399 .51399 m .54532 .54365 L .53537 .54191 L p .579 g
F P
0 g
s
.52862 .51258 m .52417 .48822 L .52652 .48917 L p .551 g
F P
0 g
s
.51583 .47771 m .51921 .46745 L .51869 .46716 L p .194 g
F P
0 g
s
.51869 .46716 m .51409 .47743 L .51583 .47771 L p .194 g
F P
0 g
s
.54093 .48037 m .53319 .47488 L .55148 .49706 L p .479 g
F P
0 g
s
.53399 .51399 m .52652 .48917 L .52736 .48393 L p .563 g
F P
0 g
s
.52736 .48393 m .5359 .50437 L .53399 .51399 L p .563 g
F P
0 g
s
.43014 .58745 m .45882 .56179 L .47915 .54782 L p .883 g
F P
0 g
s
.49496 .52369 m .47915 .54782 L .45882 .56179 L p .869 g
F P
0 g
s
.52011 .3658 m .51988 .34656 L .49099 .2897 L p .165 g
F P
0 g
s
.49099 .2897 m .49909 .31908 L .52011 .3658 L p .165 g
F P
0 g
s
.51921 .46745 m .51583 .47771 L .51848 .47439 L p .149 g
F P
0 g
s
.45493 .26958 m .47286 .30196 L .49909 .31908 L p .57 g
F P
0 g
s
.47286 .30196 m .45493 .26958 L .43161 .28915 L p .698 g
F P
0 g
s
.54888 .52855 m .5359 .50437 L .53263 .48649 L p .597 g
F P
0 g
s
.53263 .48649 m .54282 .50113 L .54888 .52855 L p .597 g
F P
0 g
s
.52652 .48917 m .53399 .51399 L .52862 .51258 L p .551 g
F P
0 g
s
.58368 .4898 m .57253 .49021 L .6496 .52267 L p .445 g
F P
0 g
s
.6496 .52267 m .67744 .51814 L .58368 .4898 L p .445 g
F P
0 g
s
.52721 .42109 m .52863 .41788 L .51935 .31745 L p .02 g
F P
0 g
s
.52994 .41623 m .52863 .41788 L .52916 .41722 L p .694 g
F P
0 g
s
.52916 .41722 m .54706 .39478 L p .52994 .41623 L .694 g
F P
0 g
s
.54706 .39478 m .55146 .39237 L .53047 .41565 L p .694 g
F P
0 g
s
.53047 .41565 m .52994 .41623 L p .53044 .41561 L .694 g
F P
0 g
s
.53044 .41561 m .54706 .39478 L .53047 .41565 L .694 g
F
.53104 .41633 m .52994 .41623 L .53047 .41565 L p 0 g
F P
s
.53047 .41565 m .55146 .39237 L p .53104 .41633 L F P
s
.53182 .4182 m .53104 .41633 L .53156 .41581 L p .051 g
F P
0 g
s
.53156 .41581 m .55517 .39279 L p .53182 .4182 L .051 g
F P
0 g
s
.53182 .4182 m .53224 .42172 L .53211 .4208 L p .619 g
F P
0 g
s
.53104 .41633 m .53089 .41504 L p .53084 .4151 L .524 g
F P
0 g
s
.52994 .41623 m .53104 .41633 L p .53084 .4151 L .524 g
F P
0 g
s
.53089 .41504 m .52141 .33175 L p .52994 .41623 L .524 g
F P
0 g
s
.51909 .3103 m .51935 .31745 L .52175 .34342 L p .013 g
F P
0 g
s
.52175 .34342 m .5278 .40882 L p .52271 .35127 L .013 g
F P
0 g
s
.51909 .3103 m .52175 .34342 L .52271 .35127 L .013 g
F
.52597 .38782 m .5278 .40882 L .52732 .40301 L F
.51909 .3103 m .52605 .38899 L .52597 .38782 L F
.52605 .38899 m .5278 .40882 L .52597 .38782 L F
.51962 .32994 m .51935 .31745 L .47318 .24442 L p .058 g
F P
0 g
s
.51935 .31745 m .51909 .3103 L .48528 .2622 L p .349 g
F P
0 g
s
.47318 .24442 m .48218 .26405 L .4838 .2669 L p .058 g
F P
0 g
s
.4838 .2669 m .50546 .30502 L p .48724 .27081 L .058 g
F P
0 g
s
.47318 .24442 m .4838 .2669 L .48724 .27081 L .058 g
F
.47318 .24442 m .50546 .30502 L .50134 .29628 L F
.48218 .26405 m .47318 .24442 L .41535 .22048 L p .532 g
F P
0 g
s
.47318 .24442 m .4646 .23279 L .39619 .20847 L p .374 g
F P
0 g
s
.46154 .2396 m .47318 .24442 L p .4628 .23957 L .374 g
F P
0 g
s
.4646 .23279 m .47318 .24442 L .49963 .28625 L p .349 g
F P
0 g
s
.4646 .23279 m .49963 .28625 L .49584 .28109 L .349 g
F
.48528 .2622 m .46928 .23944 L p .48973 .27164 L F P
0 g
s
.46928 .23944 m .4646 .23279 L p .46891 .23944 L .349 g
F P
0 g
s
.46891 .23944 m .48973 .27164 L .46928 .23944 L .349 g
F
.41535 .22048 m .46154 .2396 L p .41696 .21836 L .374 g
F P
0 g
s
.40723 .21539 m .41535 .22048 L p .41696 .21836 L .374 g
F P
0 g
s
.39619 .20847 m .46154 .2396 L .4628 .23957 L .374 g
F
.41535 .22048 m .39619 .20847 L .35328 .24142 L p .848 g
F P
0 g
s
.33114 .24312 m .35328 .24142 L .39619 .20847 L p .89 g
F P
0 g
s
.39619 .20847 m .37941 .20718 L .33114 .24312 L p .89 g
F P
0 g
s
.45713 .23064 m .37941 .20718 L p .43869 .225 L .14 g
F P
0 g
s
.4646 .23279 m .45785 .23085 L p .43869 .225 L .14 g
F P
0 g
s
.45785 .23085 m .45713 .23064 L p .43869 .225 L .14 g
F P
0 g
s
.39619 .20847 m .40723 .21539 L p .41696 .21836 L .374 g
F P
0 g
s
.49963 .28625 m .51237 .3064 L p .49584 .28109 L .349 g
F P
0 g
s
.51237 .3064 m .51935 .31745 L p .51278 .30729 L .349 g
F P
0 g
s
.49584 .28109 m .51237 .3064 L .51278 .30729 L .349 g
F
.48973 .27164 m .51935 .31745 L .48528 .2622 L F
.51909 .3103 m .525 .36799 L p .51954 .31576 L .524 g
F P
0 g
s
.51405 .30312 m .51909 .3103 L p .5147 .30465 L .499 g
F P
0 g
s
.45713 .23064 m .51405 .30312 L .5147 .30465 L .499 g
F
.51909 .3103 m .51887 .30937 L .5003 .2857 L p F P
0 g
s
.49724 .28221 m .51909 .3103 L .5003 .2857 L .499 g
F
.51887 .30937 m .525 .36799 L .52507 .36917 L .524 g
F
.52141 .33175 m .51965 .31626 L p .52232 .34263 L F P
0 g
s
.51887 .30937 m .51909 .3103 L p .51954 .31576 L .524 g
F P
0 g
s
.51965 .31626 m .51887 .30937 L p .51956 .31604 L .524 g
F P
0 g
s
.51956 .31604 m .52232 .34263 L .51965 .31626 L .524 g
F
.45713 .23064 m .4646 .23279 L .51405 .30312 L p .499 g
F P
0 g
s
.52232 .34263 m .52378 .35678 L .52141 .33175 L .524 g
F
.525 .36799 m .52994 .41623 L p .52507 .36917 L F P
0 g
s
.52378 .35678 m .52994 .41623 L .52141 .33175 L .524 g
F
.51935 .31745 m .51962 .32994 L .52395 .38188 L p .02 g
F P
0 g
s
.51935 .31745 m .52395 .38188 L .52408 .37979 L .02 g
F
.51869 .31499 m .51887 .30937 L .53104 .41633 L p .571 g
F P
0 g
s
.52386 .35562 m .52207 .34155 L p .52412 .35953 L .571 g
F P
0 g
s
.52207 .34155 m .51956 .32179 L p .52298 .35009 L .571 g
F P
0 g
s
.52298 .35009 m .52412 .35953 L .52207 .34155 L .571 g
F
.51956 .32179 m .51869 .31499 L p .51951 .32168 L F P
0 g
s
.51951 .32168 m .52412 .35953 L .51956 .32179 L .571 g
F
.5003 .2857 m .48341 .26416 L p .49724 .28221 L .499 g
F P
0 g
s
.48341 .26416 m .45713 .23064 L p .48696 .269 L .499 g
F P
0 g
s
.48696 .269 m .49724 .28221 L .48341 .26416 L .499 g
F
.50546 .30502 m .51962 .32994 L p .50134 .29628 L .058 g
F P
0 g
s
.52504 .3649 m .52386 .35562 L p .52495 .36635 L .571 g
F P
0 g
s
.52412 .35953 m .52495 .36635 L .52386 .35562 L .571 g
F
.52625 .38013 m .5253 .37352 L p .52597 .37783 L .619 g
F P
0 g
s
.51988 .34656 m .51962 .32994 L .48218 .26405 L p .112 g
F P
0 g
s
.5253 .37352 m .51858 .3269 L p .52527 .37303 L .619 g
F P
0 g
s
.52527 .37303 m .52597 .37783 L .5253 .37352 L .619 g
F
.55146 .39237 m .55517 .39279 L .53258 .41482 L p 0 g
F P
s
.53258 .41482 m .53104 .41633 L p .5326 .41449 L F P
s
.5326 .41449 m .55146 .39237 L .53258 .41482 L F
.53224 .42172 m .53225 .42661 L .53188 .42439 L p .66 g
F P
0 g
s
.53054 .41211 m .53104 .41633 L .53136 .41671 L .571 g
F
.53054 .41211 m .53136 .41671 L .53142 .41678 L F
.52504 .3649 m .53054 .41211 L .53142 .41678 L F
.53104 .41633 m .5315 .41742 L p .53142 .41678 L F P
0 g
s
.52495 .36635 m .53104 .41633 L .52504 .3649 L .571 g
F
.53188 .42439 m .51854 .3442 L p .53213 .42107 L .66 g
F P
0 g
s
.53213 .42107 m .53224 .42172 L .53188 .42439 L .66 g
F
.5315 .41742 m .53182 .4182 L .53179 .41793 L p .571 g
F P
0 g
s
.53179 .41793 m .52504 .3649 L p .5315 .41742 L .571 g
F P
0 g
s
.53211 .4208 m .52625 .38013 L p .53182 .4182 L .619 g
F P
0 g
s
.52597 .37783 m .53182 .4182 L .52625 .38013 L .619 g
F
.5278 .40882 m .52863 .41788 L p .52732 .40301 L .013 g
F P
0 g
s
.52395 .38188 m .52721 .42109 L p .52408 .37979 L .02 g
F P
0 g
s
.56624 .55436 m .54888 .52855 L .54282 .50113 L p .628 g
F P
0 g
s
.54282 .50113 m .55649 .51649 L .56624 .55436 L p .628 g
F P
0 g
s
.55042 .48512 m .54093 .48037 L .57071 .50816 L p .464 g
F P
0 g
s
.55148 .49706 m .57071 .50816 L .54093 .48037 L p .479 g
F P
0 g
s
.54532 .54365 m .53399 .51399 L .5359 .50437 L p .598 g
F P
0 g
s
.5359 .50437 m .54888 .52855 L .54532 .54365 L p .598 g
F P
0 g
s
.38648 .31593 m .36324 .31336 L .42958 .39585 L p .715 g
F P
0 g
s
.41859 .39973 m .42958 .39585 L .36324 .31336 L p .727 g
F P
0 g
s
.50679 .50112 m .49496 .52369 L .48241 .5347 L p .853 g
F P
0 g
s
.49741 .50617 m .51048 .48557 L .51162 .48679 L p .808 g
F P
0 g
s
.51162 .48679 m .50003 .50891 L .49741 .50617 L p .808 g
F P
0 g
s
.57996 .34188 m .59711 .32628 L .5423 .39973 L p F P
s
.50049 .49451 m .51184 .47913 L .51048 .48557 L p .762 g
F P
0 g
s
.57253 .49021 m .56117 .48856 L .62122 .52211 L p .446 g
F P
0 g
s
.62122 .52211 m .6496 .52267 L .57253 .49021 L p .446 g
F P
0 g
s
.45882 .56179 m .48241 .5347 L .49496 .52369 L p .869 g
F P
0 g
s
.56117 .48856 m .55042 .48512 L .59435 .51696 L p .453 g
F P
0 g
s
.57071 .50816 m .59435 .51696 L .55042 .48512 L p .464 g
F P
0 g
s
.59435 .51696 m .62122 .52211 L .56117 .48856 L p .453 g
F P
0 g
s
.48455 .49415 m .4984 .48604 L .48319 .51156 L p .647 g
F P
0 g
s
.50049 .49451 m .48319 .51156 L .4984 .48604 L p .664 g
F P
0 g
s
.49376 .49041 m .50625 .48235 L .51225 .47072 L p .257 g
F P
0 g
s
.51225 .47072 m .50502 .47559 L .49376 .49041 L p .257 g
F P
0 g
s
.49909 .31908 m .49099 .2897 L .45493 .26958 L p .57 g
F P
0 g
s
.51048 .48557 m .49741 .50617 L .50049 .49451 L p .762 g
F P
0 g
s
.79081 .34794 m .81344 .36677 L .82295 .31451 L p .381 g
F P
0 g
s
.82295 .31451 m .79884 .29683 L .79081 .34794 L p .381 g
F P
0 g
s
.43161 .28915 m .4054 .26593 L .41123 .32487 L p .73 g
F P
0 g
s
.38648 .31593 m .41123 .32487 L .4054 .26593 L p .765 g
F P
0 g
s
.73064 .28742 m .76719 .28771 L .71569 .27413 L p .676 g
F P
0 g
s
.71569 .27413 m .68656 .27812 L .73064 .28742 L p .676 g
F P
0 g
s
.5384 .48868 m .52841 .47736 L .52503 .47078 L p .056 g
F P
0 g
s
.54706 .39478 m .5423 .39973 L .59711 .32628 L p F P
s
.38134 .59355 m .41806 .57593 L .43014 .58745 L p .783 g
F P
0 g
s
.45882 .56179 m .43014 .58745 L .41806 .57593 L p .797 g
F P
0 g
s
.33203 .55793 m .36505 .55905 L .34307 .60461 L p .608 g
F P
0 g
s
.38134 .59355 m .34307 .60461 L .36505 .55905 L p .65 g
F P
0 g
s
.74354 .45821 m .73696 .47736 L .82066 .44715 L p .286 g
F P
0 g
s
.82066 .44715 m .82928 .41843 L .74354 .45821 L p .286 g
F P
0 g
s
.50555 .48817 m .51409 .47743 L .51437 .47327 L p .153 g
F P
0 g
s
.51437 .47327 m .50625 .48235 L .50555 .48817 L p .153 g
F P
0 g
s
.4054 .26593 m .43161 .28915 L .45493 .26958 L p .739 g
F P
0 g
s
.47749 .5297 m .49741 .50617 L .50003 .50891 L p .808 g
F P
0 g
s
.50003 .50891 m .48241 .5347 L .47749 .5297 L p .808 g
F P
0 g
s
.37496 .48554 m .38974 .49539 L .30248 .55026 L p .509 g
F P
0 g
s
.33203 .55793 m .30248 .55026 L .38974 .49539 L p .538 g
F P
0 g
s
.55095 .48665 m .53923 .48379 L .52589 .46697 L p .208 g
F P
0 g
s
.52589 .46697 m .52914 .46757 L .55095 .48665 L p .208 g
F P
0 g
s
.55148 .49706 m .53725 .48514 L .54316 .49382 L p .306 g
F P
0 g
s
.65575 .29003 m .68656 .27812 L .6144 .31542 L p .659 g
F P
0 g
s
.48319 .51156 m .50049 .49451 L .49741 .50617 L p .747 g
F P
0 g
s
.5434 .49466 m .53059 .48065 L .52841 .47736 L p .058 g
F P
0 g
s
.36324 .31336 m .34328 .31771 L .41859 .39973 L p .727 g
F P
0 g
s
.41054 .40662 m .41859 .39973 L .34328 .31771 L p .733 g
F P
0 g
s
.47678 .49571 m .49376 .49041 L .50502 .47559 L p .241 g
F P
0 g
s
.50502 .47559 m .49526 .47933 L .47678 .49571 L p .241 g
F P
0 g
s
.41806 .57593 m .45072 .55381 L .45882 .56179 L p .797 g
F P
0 g
s
.48241 .5347 m .45882 .56179 L .45072 .55381 L p .805 g
F P
0 g
s
.45072 .55381 m .47749 .5297 L .48241 .5347 L p .805 g
F P
0 g
s
.49741 .50617 m .47749 .5297 L .48319 .51156 L p .747 g
F P
0 g
s
.51564 .48273 m .51848 .47439 L .51583 .47771 L p .046 g
F P
0 g
s
.50954 .48805 m .51583 .47771 L .51409 .47743 L p .1 g
F P
0 g
s
.51409 .47743 m .50555 .48817 L .50954 .48805 L p .1 g
F P
0 g
s
.48218 .26405 m .49099 .2897 L .51988 .34656 L p .112 g
F P
0 g
s
.59711 .32628 m .6144 .31542 L .54706 .39478 L p F P
s
.51583 .47771 m .50954 .48805 L .51564 .48273 L p .046 g
F P
0 g
s
.46754 .50061 m .48455 .49415 L .45987 .52843 L p .629 g
F P
0 g
s
.48319 .51156 m .45987 .52843 L .48455 .49415 L p .647 g
F P
0 g
s
.36505 .55905 m .39898 .55381 L .38134 .59355 L p .65 g
F P
0 g
s
.41806 .57593 m .38134 .59355 L .39898 .55381 L p .682 g
F P
0 g
s
.56553 .48525 m .55095 .48665 L .52914 .46757 L p .314 g
F P
0 g
s
.52914 .46757 m .53315 .4663 L .56553 .48525 L p .314 g
F P
0 g
s
.45987 .52843 m .48319 .51156 L .47749 .5297 L p .729 g
F P
0 g
s
.47749 .5297 m .45072 .55381 L .45987 .52843 L p .729 g
F P
0 g
s
.57071 .50816 m .55148 .49706 L .5626 .50824 L p .203 g
F P
0 g
s
.54316 .49382 m .5626 .50824 L .55148 .49706 L p .306 g
F P
0 g
s
.73696 .47736 m .72294 .49463 L .80136 .47458 L p .21 g
F P
0 g
s
.80136 .47458 m .82066 .44715 L .73696 .47736 L p .21 g
F P
0 g
s
.55381 .49871 m .5384 .48868 L .53062 .47798 L p .204 g
F P
0 g
s
.53062 .47798 m .53923 .48379 L .55381 .49871 L p .204 g
F P
0 g
s
.5426 .45724 m .53773 .46288 L .52578 .45944 L p .438 g
F P
0 g
s
.52578 .45944 m .52723 .45577 L .5426 .45724 L p .438 g
F P
0 g
s
.52723 .45577 m .52578 .45944 L .51968 .46526 L p .741 g
F P
0 g
s
.45569 .49674 m .47678 .49571 L .49526 .47933 L p .234 g
F P
0 g
s
.49526 .47933 m .48324 .48118 L .45569 .49674 L p .234 g
F P
0 g
s
.49238 .497 m .50555 .48817 L .50625 .48235 L p .111 g
F P
0 g
s
.50625 .48235 m .49376 .49041 L .49238 .497 L p .111 g
F P
0 g
s
.38974 .49539 m .40785 .50204 L .33203 .55793 L p .538 g
F P
0 g
s
.36505 .55905 m .33203 .55793 L .40785 .50204 L p .565 g
F P
0 g
s
.34328 .31771 m .32827 .32894 L .41054 .40662 L p .733 g
F P
0 g
s
.4061 .41603 m .41054 .40662 L .32827 .32894 L p .729 g
F P
0 g
s
.43538 .24158 m .45493 .26958 L .49099 .2897 L p .572 g
F P
0 g
s
.45493 .26958 m .43538 .24158 L .4054 .26593 L p .739 g
F P
0 g
s
.44824 .50449 m .46754 .50061 L .43129 .54312 L p .61 g
F P
0 g
s
.45987 .52843 m .43129 .54312 L .46754 .50061 L p .629 g
F P
0 g
s
.5626 .50824 m .54316 .49382 L .5434 .49466 L p .187 g
F P
0 g
s
.39898 .55381 m .43129 .54312 L .41806 .57593 L p .682 g
F P
0 g
s
.45072 .55381 m .41806 .57593 L .43129 .54312 L p .708 g
F P
0 g
s
.4054 .26593 m .37869 .24942 L .38648 .31593 L p .765 g
F P
0 g
s
.36324 .31336 m .38648 .31593 L .37869 .24942 L p .802 g
F P
0 g
s
.43129 .54312 m .45987 .52843 L .45072 .55381 L p .708 g
F P
0 g
s
.6144 .31542 m .63063 .31046 L .55146 .39237 L p .003 g
F P
0 g
s
.55517 .39279 m .55146 .39237 L .63063 .31046 L p .057 g
F P
0 g
s
.55517 .39279 m .55786 .39607 L .53182 .4182 L p .051 g
F P
0 g
s
.53224 .42172 m .53182 .4182 L .55786 .39607 L p .153 g
F P
0 g
s
.51858 .3269 m .51869 .31499 L .53182 .4182 L p .619 g
F P
0 g
s
.49099 .2897 m .48218 .26405 L .43538 .24158 L p .572 g
F P
0 g
s
.54743 .44956 m .5426 .45724 L .52723 .45577 L p .456 g
F P
0 g
s
.52723 .45577 m .52867 .4509 L .54743 .44956 L p .456 g
F P
0 g
s
.52867 .4509 m .52723 .45577 L .51941 .45173 L p .749 g
F P
0 g
s
.51968 .46526 m .51941 .45173 L .52723 .45577 L p .741 g
F P
0 g
s
.81344 .36677 m .82671 .39088 L .83729 .33964 L p .159 g
F P
0 g
s
.83729 .33964 m .82295 .31451 L .81344 .36677 L p .159 g
F P
0 g
s
.42786 .50509 m .44824 .50449 L .39898 .55381 L p .589 g
F P
0 g
s
.43129 .54312 m .39898 .55381 L .44824 .50449 L p .61 g
F P
0 g
s
.40785 .50204 m .42786 .50509 L .36505 .55905 L p .565 g
F P
0 g
s
.39898 .55381 m .36505 .55905 L .42786 .50509 L p .589 g
F P
0 g
s
.58232 .47869 m .56553 .48525 L .53315 .4663 L p .375 g
F P
0 g
s
.53315 .4663 m .53773 .46288 L .58232 .47869 L p .375 g
F P
0 g
s
.59435 .51696 m .57071 .50816 L .589 .52073 L p .147 g
F P
0 g
s
.5626 .50824 m .589 .52073 L .57071 .50816 L p .203 g
F P
0 g
s
.76719 .28771 m .79884 .29683 L .74091 .27888 L p .383 g
F P
0 g
s
.74091 .27888 m .71569 .27413 L .76719 .28771 L p .383 g
F P
0 g
s
.43146 .49236 m .45569 .49674 L .48324 .48118 L p .246 g
F P
0 g
s
.44039 .48959 m .43146 .49236 L p .44133 .49023 L .246 g
F P
0 g
s
.40558 .48201 m .43146 .49236 L .46955 .48054 L p .283 g
F P
0 g
s
.41447 .48113 m .40558 .48201 L p .4154 .48179 L .283 g
F P
0 g
s
.37991 .46582 m .40558 .48201 L .45502 .47708 L p .346 g
F P
0 g
s
.43146 .49236 m .40558 .48201 L .40175 .47771 L p .397 g
F P
0 g
s
.40175 .47771 m .39744 .47285 L p .41648 .48377 L .397 g
F P
0 g
s
.43146 .49236 m .40175 .47771 L .41648 .48377 L .397 g
F
.39744 .47285 m .4256 .49058 L .42926 .49169 L p F P
0 g
s
.42926 .49169 m .43146 .49236 L p .42506 .48869 L .397 g
F P
0 g
s
.42506 .48869 m .39744 .47285 L .42926 .49169 L .397 g
F
.43163 .49239 m .43146 .49236 L .4256 .49058 L p .376 g
F P
0 g
s
.48324 .48118 m .46955 .48054 L .44039 .48959 L p .246 g
F P
0 g
s
.48324 .48118 m .44039 .48959 L .44133 .49023 L .246 g
F
.47678 .49571 m .45569 .49674 L .45231 .49949 L p .057 g
F P
0 g
s
.45231 .49949 m .45175 .49994 L p .45454 .49947 L .057 g
F P
0 g
s
.47678 .49571 m .45231 .49949 L .45454 .49947 L .057 g
F
.47433 .5016 m .49238 .497 L .49376 .49041 L p .088 g
F P
0 g
s
.49376 .49041 m .47678 .49571 L .47433 .5016 L p .088 g
F P
0 g
s
.45175 .49994 m .47433 .5016 L .47678 .49571 L p .057 g
F P
0 g
s
.49238 .497 m .47433 .5016 L .48645 .49873 L p F P
s
.46967 .49448 m .48645 .49873 L .48457 .49917 L p .724 g
F P
0 g
s
.48457 .49917 m .47433 .5016 L p .47282 .49929 L .724 g
F P
0 g
s
.47282 .49929 m .46967 .49448 L .48457 .49917 L .724 g
F
.45015 .48163 m .46967 .49448 L .46151 .49697 L p .763 g
F P
0 g
s
.45569 .49674 m .43163 .49239 L p .42619 .49076 L .376 g
F P
0 g
s
.45569 .49674 m .42619 .49076 L .42816 .4911 L .376 g
F
.4256 .49058 m .45175 .49994 L .4531 .49885 L p F P
0 g
s
.4531 .49885 m .45349 .49853 L p .44977 .49747 L .376 g
F P
0 g
s
.44977 .49747 m .4256 .49058 L .4531 .49885 L .376 g
F
.45349 .49853 m .45569 .49674 L p .4488 .49533 L F P
0 g
s
.42816 .4911 m .42619 .49076 L .4256 .49058 L .376 g
F
.4488 .49533 m .4256 .49058 L .45349 .49853 L F
.46151 .49697 m .45175 .49994 L p .45134 .49518 L .763 g
F P
0 g
s
.45134 .49518 m .45015 .48163 L .46151 .49697 L .763 g
F
.46955 .48054 m .45502 .47708 L .41447 .48113 L p .283 g
F P
0 g
s
.46955 .48054 m .41447 .48113 L .4154 .48179 L .283 g
F
.56314 .50807 m .5434 .49466 L .5384 .48868 L p .249 g
F P
0 g
s
.5384 .48868 m .55381 .49871 L .56314 .50807 L p .249 g
F P
0 g
s
.55786 .39607 m .55932 .402 L .53224 .42172 L p .153 g
F P
0 g
s
.53225 .42661 m .53224 .42172 L .55932 .402 L p .279 g
F P
0 g
s
.51854 .3442 m .51858 .3269 L .53224 .42172 L p .66 g
F P
0 g
s
.5434 .49466 m .56314 .50807 L .5626 .50824 L p .187 g
F P
0 g
s
.55186 .44029 m .54743 .44956 L .52867 .4509 L p .455 g
F P
0 g
s
.52867 .4509 m .52999 .4451 L .55186 .44029 L p .455 g
F P
0 g
s
.52999 .4451 m .52867 .4509 L .51914 .43368 L p .747 g
F P
0 g
s
.51941 .45173 m .51914 .43368 L .52867 .4509 L p .749 g
F P
0 g
s
.72294 .49463 m .70256 .50859 L .77291 .49837 L p .132 g
F P
0 g
s
.77291 .49837 m .80136 .47458 L .72294 .49463 L p .132 g
F P
0 g
s
.32827 .32894 m .3196 .34636 L .4061 .41603 L p .729 g
F P
0 g
s
.40569 .42722 m .4061 .41603 L .3196 .34636 L p .71 g
F P
0 g
s
.37869 .24942 m .4054 .26593 L .43538 .24158 L p .788 g
F P
0 g
s
.51126 .48861 m .51564 .48273 L .50954 .48805 L p F P
s
.55932 .402 m .55941 .41012 L .53225 .42661 L p .279 g
F P
0 g
s
.53185 .43246 m .53225 .42661 L .55941 .41012 L p .358 g
F P
0 g
s
.53225 .42661 m .53185 .43246 L .51859 .36545 L p .693 g
F P
0 g
s
.51859 .36545 m .51854 .3442 L .53225 .42661 L p .693 g
F P
0 g
s
.55551 .43009 m .55186 .44029 L .52999 .4451 L p .439 g
F P
0 g
s
.52999 .4451 m .53108 .4388 L .55551 .43009 L p .439 g
F P
0 g
s
.53108 .4388 m .52999 .4451 L .5189 .41216 L p .737 g
F P
0 g
s
.51914 .43368 m .5189 .41216 L .52999 .4451 L p .747 g
F P
0 g
s
.68656 .27812 m .71569 .27413 L .63063 .31046 L p F P
s
.63063 .31046 m .6144 .31542 L .68656 .27812 L p F P
s
.49981 .49588 m .50954 .48805 L .50555 .48817 L p .038 g
F P
0 g
s
.50555 .48817 m .49238 .497 L .49981 .49588 L p .038 g
F P
0 g
s
.63063 .31046 m .64454 .31213 L .55517 .39279 L p .057 g
F P
0 g
s
.55786 .39607 m .55517 .39279 L .64454 .31213 L p .118 g
F P
0 g
s
.55941 .41012 m .5581 .41975 L .53185 .43246 L p .358 g
F P
0 g
s
.53108 .4388 m .53185 .43246 L .5581 .41975 L p .408 g
F P
0 g
s
.53185 .43246 m .53108 .4388 L .51871 .38878 L p .719 g
F P
0 g
s
.51871 .38878 m .51859 .36545 L .53185 .43246 L p .719 g
F P
0 g
s
.5581 .41975 m .55551 .43009 L .53108 .4388 L p .408 g
F P
0 g
s
.5189 .41216 m .51871 .38878 L .53108 .4388 L p .737 g
F P
0 g
s
.62122 .52211 m .59435 .51696 L .62168 .52925 L p .122 g
F P
0 g
s
.589 .52073 m .62168 .52925 L .59435 .51696 L p .147 g
F P
0 g
s
.57487 .50527 m .55381 .49871 L .53923 .48379 L p .366 g
F P
0 g
s
.53923 .48379 m .55095 .48665 L .57487 .50527 L p .366 g
F P
0 g
s
.6003 .46661 m .58232 .47869 L .53773 .46288 L p .409 g
F P
0 g
s
.53773 .46288 m .5426 .45724 L .6003 .46661 L p .409 g
F P
0 g
s
.50954 .48805 m .49981 .49588 L .51126 .48861 L p F P
s
.70256 .50859 m .67744 .51814 L .7377 .5166 L p .108 g
F P
0 g
s
.7377 .5166 m .77291 .49837 L .70256 .50859 L p .108 g
F P
0 g
s
.3196 .34636 m .31816 .36864 L .40569 .42722 L p .71 g
F P
0 g
s
.40939 .43926 m .40569 .42722 L .31816 .36864 L p .67 g
F P
0 g
s
.589 .52073 m .5626 .50824 L .56314 .50807 L p .36 g
F P
0 g
s
.6496 .52267 m .62122 .52211 L .65904 .53205 L p .104 g
F P
0 g
s
.62168 .52925 m .65904 .53205 L .62122 .52211 L p .122 g
F P
0 g
s
.45502 .47708 m .44068 .47079 L .38823 .4665 L p .346 g
F P
0 g
s
.45502 .47708 m .38823 .4665 L .38903 .46719 L .346 g
F
.35651 .44464 m .37991 .46582 L .44068 .47079 L p .43 g
F P
0 g
s
.44068 .47079 m .42763 .46195 L .36669 .44712 L p .43 g
F P
0 g
s
.36669 .44712 m .36376 .4464 L p .36789 .44818 L .43 g
F P
0 g
s
.36789 .44818 m .36376 .4464 L .36436 .44708 L .43 g
F
.44068 .47079 m .36669 .44712 L .36789 .44818 L F
.32424 .39391 m .3374 .42 L .4169 .45116 L p .606 g
F P
0 g
s
.42763 .46195 m .4169 .45116 L .34313 .42225 L p .522 g
F P
0 g
s
.34313 .42225 m .3374 .42 L p .3435 .42284 L .522 g
F P
0 g
s
.42763 .46195 m .34313 .42225 L .3435 .42284 L .522 g
F
.31816 .36864 m .32424 .39391 L .40939 .43926 L p .67 g
F P
0 g
s
.4169 .45116 m .40939 .43926 L .32424 .39391 L p .606 g
F P
0 g
s
.3374 .42 m .35651 .44464 L .42763 .46195 L p .522 g
F P
0 g
s
.32264 .37837 m .34362 .41481 L .35498 .4411 L p .181 g
F P
0 g
s
.35498 .4411 m .35651 .44464 L p .35348 .43871 L .181 g
F P
0 g
s
.35348 .43871 m .32264 .37837 L .35498 .4411 L .181 g
F
.34362 .41481 m .36933 .44711 L .37802 .46249 L p .295 g
F P
0 g
s
.37802 .46249 m .37991 .46582 L p .37557 .45972 L .295 g
F P
0 g
s
.37557 .45972 m .34362 .41481 L .37802 .46249 L .295 g
F
.36376 .4464 m .35651 .44464 L p .36436 .44708 L .43 g
F P
0 g
s
.36933 .44711 m .39744 .47285 L .40276 .47885 L p .366 g
F P
0 g
s
.40276 .47885 m .40347 .47965 L p .40109 .47737 L .366 g
F P
0 g
s
.40109 .47737 m .36933 .44711 L .40276 .47885 L .366 g
F
.40347 .47965 m .40558 .48201 L p .40006 .4767 L F P
0 g
s
.40006 .4767 m .36933 .44711 L .40347 .47965 L .366 g
F
.38823 .4665 m .37991 .46582 L p .38903 .46719 L .346 g
F P
0 g
s
.67744 .51814 m .6496 .52267 L .69869 .52797 L p .095 g
F P
0 g
s
.69869 .52797 m .7377 .5166 L .67744 .51814 L p .095 g
F P
0 g
s
.37869 .24942 m .35328 .24142 L .36324 .31336 L p .802 g
F P
0 g
s
.34328 .31771 m .36324 .31336 L .35328 .24142 L p .841 g
F P
0 g
s
.64454 .31213 m .65495 .32057 L .55786 .39607 L p .118 g
F P
0 g
s
.55932 .402 m .55786 .39607 L .65495 .32057 L p .228 g
F P
0 g
s
.65904 .53205 m .69869 .52797 L .6496 .52267 L p .104 g
F P
0 g
s
.61818 .44932 m .6003 .46661 L .5426 .45724 L p .425 g
F P
0 g
s
.5426 .45724 m .54743 .44956 L .61818 .44932 L p .425 g
F P
0 g
s
.82671 .39088 m .82928 .41843 L .8403 .37035 L p .034 g
F P
0 g
s
.8403 .37035 m .83729 .33964 L .82671 .39088 L p .034 g
F P
0 g
s
.41535 .22048 m .43538 .24158 L .48218 .26405 L p .532 g
F P
0 g
s
.43538 .24158 m .41535 .22048 L .37869 .24942 L p .788 g
F P
0 g
s
.65495 .32057 m .66089 .33531 L .55932 .402 L p .228 g
F P
0 g
s
.55941 .41012 m .55932 .402 L .66089 .33531 L p .305 g
F P
0 g
s
.59009 .51848 m .56314 .50807 L .55381 .49871 L p .434 g
F P
0 g
s
.56314 .50807 m .59009 .51848 L .589 .52073 L p .36 g
F P
0 g
s
.55381 .49871 m .57487 .50527 L .59009 .51848 L p .434 g
F P
0 g
s
.63455 .42778 m .61818 .44932 L .54743 .44956 L p .427 g
F P
0 g
s
.54743 .44956 m .55186 .44029 L .63455 .42778 L p .427 g
F P
0 g
s
.79884 .29683 m .82295 .31451 L .76009 .29243 L p .182 g
F P
0 g
s
.76009 .29243 m .74091 .27888 L .79884 .29683 L p .182 g
F P
0 g
s
.51994 .47379 m .52018 .47748 L .50525 .48989 L p .935 g
F P
0 g
s
.51126 .48861 m .50525 .48989 L .52018 .47748 L p .881 g
F P
0 g
s
.62168 .52925 m .589 .52073 L .59009 .51848 L p .546 g
F P
0 g
s
.60114 .50641 m .57487 .50527 L .55095 .48665 L p .47 g
F P
0 g
s
.55095 .48665 m .56553 .48525 L .60114 .50641 L p .47 g
F P
0 g
s
.66089 .33531 m .66174 .35523 L .55941 .41012 L p .305 g
F P
0 g
s
.5581 .41975 m .55941 .41012 L .66174 .35523 L p .359 g
F P
0 g
s
.50525 .48989 m .51126 .48861 L .49981 .49588 L p .814 g
F P
0 g
s
.648 .40356 m .63455 .42778 L .55186 .44029 L p .417 g
F P
0 g
s
.55186 .44029 m .55551 .43009 L .648 .40356 L p .417 g
F P
0 g
s
.48645 .49873 m .49981 .49588 L .49238 .497 L p F P
s
.35328 .24142 m .37869 .24942 L .41535 .22048 L p .848 g
F P
0 g
s
.71569 .27413 m .74091 .27888 L .64454 .31213 L p .091 g
F P
0 g
s
.64454 .31213 m .63063 .31046 L .71569 .27413 L p .091 g
F P
0 g
s
.66174 .35523 m .65733 .37866 L .5581 .41975 L p .359 g
F P
0 g
s
.55551 .43009 m .5581 .41975 L .65733 .37866 L p .394 g
F P
0 g
s
.65733 .37866 m .648 .40356 L .55551 .43009 L p .394 g
F P
0 g
s
.35328 .24142 m .33114 .24312 L .34328 .31771 L p .841 g
F P
0 g
s
.32827 .32894 m .34328 .31771 L .33114 .24312 L p .873 g
F P
0 g
s
.82928 .41843 m .82066 .44715 L .8314 .40406 L p .672 g
F P
0 g
s
.8314 .40406 m .8403 .37035 L .82928 .41843 L p .672 g
F P
0 g
s
.49981 .49588 m .48645 .49873 L .50525 .48989 L p .814 g
F P
0 g
s
.65904 .53205 m .62168 .52925 L .62363 .52369 L p .682 g
F P
0 g
s
.59009 .51848 m .62363 .52369 L .62168 .52925 L p .546 g
F P
0 g
s
.62363 .52369 m .59009 .51848 L .57487 .50527 L p .558 g
F P
0 g
s
.51968 .46526 m .51994 .47379 L .49773 .4848 L p .921 g
F P
0 g
s
.50525 .48989 m .49773 .4848 L .51994 .47379 L p .935 g
F P
0 g
s
.57487 .50527 m .60114 .50641 L .62363 .52369 L p .558 g
F P
0 g
s
.63146 .50067 m .60114 .50641 L .56553 .48525 L p .527 g
F P
0 g
s
.56553 .48525 m .58232 .47869 L .63146 .50067 L p .527 g
F P
0 g
s
.82295 .31451 m .83729 .33964 L .77139 .31403 L p .49 g
F P
0 g
s
.77139 .31403 m .76009 .29243 L .82295 .31451 L p .49 g
F P
0 g
s
.82066 .44715 m .80136 .47458 L .81113 .43783 L p .9 g
F P
0 g
s
.81113 .43783 m .8314 .40406 L .82066 .44715 L p .9 g
F P
0 g
s
.65495 .32057 m .64454 .31213 L .74091 .27888 L p .239 g
F P
0 g
s
.69869 .52797 m .65904 .53205 L .66221 .52192 L p .776 g
F P
0 g
s
.62363 .52369 m .66221 .52192 L .65904 .53205 L p .682 g
F P
0 g
s
.33114 .24312 m .31419 .25497 L .32827 .32894 L p .873 g
F P
0 g
s
.3196 .34636 m .32827 .32894 L .31419 .25497 L p .869 g
F P
0 g
s
.74091 .27888 m .76009 .29243 L .65495 .32057 L p .239 g
F P
0 g
s
.49773 .4848 m .50525 .48989 L .48645 .49873 L p .893 g
F P
0 g
s
.47433 .5016 m .45175 .49994 L .46967 .49448 L p .724 g
F P
0 g
s
.80136 .47458 m .77291 .49837 L .78119 .46869 L p .934 g
F P
0 g
s
.78119 .46869 m .81113 .43783 L .80136 .47458 L p .934 g
F P
0 g
s
.7377 .5166 m .69869 .52797 L .70343 .5121 L p .847 g
F P
0 g
s
.66221 .52192 m .70343 .5121 L .69869 .52797 L p .776 g
F P
0 g
s
.51887 .30937 m .51869 .31499 L .45141 .23871 L p .612 g
F P
0 g
s
.45141 .23871 m .45713 .23064 L .51887 .30937 L p .612 g
F P
0 g
s
.51941 .45173 m .51968 .46526 L .48901 .47215 L p .89 g
F P
0 g
s
.49773 .4848 m .48901 .47215 L .51968 .46526 L p .921 g
F P
0 g
s
.66221 .52192 m .62363 .52369 L .60114 .50641 L p .63 g
F P
0 g
s
.66397 .48729 m .63146 .50067 L .58232 .47869 L p .558 g
F P
0 g
s
.58232 .47869 m .6003 .46661 L .66397 .48729 L p .558 g
F P
0 g
s
.48645 .49873 m .46967 .49448 L .49773 .4848 L p .893 g
F P
0 g
s
.77291 .49837 m .7377 .5166 L .74421 .49406 L p .902 g
F P
0 g
s
.74421 .49406 m .78119 .46869 L .77291 .49837 L p .902 g
F P
0 g
s
.70343 .5121 m .74421 .49406 L .7377 .5166 L p .847 g
F P
0 g
s
.60114 .50641 m .63146 .50067 L .66221 .52192 L p .63 g
F P
0 g
s
.66089 .33531 m .65495 .32057 L .76009 .29243 L p .379 g
F P
0 g
s
.31419 .25497 m .3041 .27641 L .3196 .34636 L p .869 g
F P
0 g
s
.31816 .36864 m .3196 .34636 L .3041 .27641 L p .749 g
F P
0 g
s
.83729 .33964 m .8403 .37035 L .77357 .34206 L p .627 g
F P
0 g
s
.77357 .34206 m .77139 .31403 L .83729 .33964 L p .627 g
F P
0 g
s
.76009 .29243 m .77139 .31403 L .66089 .33531 L p .379 g
F P
0 g
s
.40558 .48201 m .37991 .46582 L .36933 .44711 L p .366 g
F P
0 g
s
.37941 .20718 m .39619 .20847 L .4646 .23279 L p .14 g
F P
0 g
s
.51869 .31499 m .51858 .3269 L .44803 .25677 L p .68 g
F P
0 g
s
.44803 .25677 m .45141 .23871 L .51869 .31499 L p .68 g
F P
0 g
s
.51914 .43368 m .51941 .45173 L .47959 .45157 L p .859 g
F P
0 g
s
.48901 .47215 m .47959 .45157 L .51941 .45173 L p .89 g
F P
0 g
s
.6963 .46641 m .66397 .48729 L .6003 .46661 L p .573 g
F P
0 g
s
.6003 .46661 m .61818 .44932 L .6963 .46641 L p .573 g
F P
0 g
s
.45175 .49994 m .4256 .49058 L .45015 .48163 L p .763 g
F P
0 g
s
.70343 .5121 m .66221 .52192 L .63146 .50067 L p .672 g
F P
0 g
s
.48901 .47215 m .49773 .4848 L .46967 .49448 L p .866 g
F P
0 g
s
.66174 .35523 m .66089 .33531 L .77139 .31403 L p .464 g
F P
0 g
s
.3041 .27641 m .30201 .3059 L .31816 .36864 L p .749 g
F P
0 g
s
.31816 .36864 m .30201 .3059 L p .31744 .367 L .469 g
F P
0 g
s
.30201 .3059 m .30834 .34094 L .32424 .39391 L p .469 g
F P
0 g
s
.32264 .37837 m .3374 .42 L p .3152 .3596 L .057 g
F P
0 g
s
.30834 .34094 m .31416 .35616 L p .3152 .3596 L .057 g
F P
0 g
s
.31416 .35616 m .32264 .37837 L p .3152 .3596 L .057 g
F P
0 g
s
.32424 .39391 m .31902 .37219 L p .31744 .367 L .469 g
F P
0 g
s
.31902 .37219 m .31816 .36864 L p .31744 .367 L .469 g
F P
0 g
s
.31419 .25497 m .33114 .24312 L .37941 .20718 L p .69 g
F P
0 g
s
.63146 .50067 m .66397 .48729 L .70343 .5121 L p .672 g
F P
0 g
s
.8403 .37035 m .8314 .40406 L .76621 .37417 L p .683 g
F P
0 g
s
.76621 .37417 m .77357 .34206 L .8403 .37035 L p .683 g
F P
0 g
s
.37991 .46582 m .35651 .44464 L .34362 .41481 L p .295 g
F P
0 g
s
.3374 .42 m .32424 .39391 L .30834 .34094 L p .057 g
F P
0 g
s
.72578 .43915 m .6963 .46641 L .61818 .44932 L p .575 g
F P
0 g
s
.61818 .44932 m .63455 .42778 L .72578 .43915 L p .575 g
F P
0 g
s
.51858 .3269 m .51854 .3442 L .44736 .28354 L p .722 g
F P
0 g
s
.44736 .28354 m .44803 .25677 L .51858 .3269 L p .722 g
F P
0 g
s
.5189 .41216 m .51914 .43368 L .47017 .42367 L p .83 g
F P
0 g
s
.47959 .45157 m .47017 .42367 L .51914 .43368 L p .859 g
F P
0 g
s
.77139 .31403 m .77357 .34206 L .66174 .35523 L p .464 g
F P
0 g
s
.65733 .37866 m .66174 .35523 L .77357 .34206 L p .516 g
F P
0 g
s
.46967 .49448 m .45015 .48163 L .48901 .47215 L p .866 g
F P
0 g
s
.35651 .44464 m .3374 .42 L .32264 .37837 L p .181 g
F P
0 g
s
.74421 .49406 m .70343 .5121 L .66397 .48729 L p .697 g
F P
0 g
s
.74981 .40752 m .72578 .43915 L .63455 .42778 L p .567 g
F P
0 g
s
.63455 .42778 m .648 .40356 L .74981 .40752 L p .567 g
F P
0 g
s
.8314 .40406 m .81113 .43783 L .74981 .40752 L p .707 g
F P
0 g
s
.74981 .40752 m .76621 .37417 L .8314 .40406 L p .707 g
F P
0 g
s
.77357 .34206 m .76621 .37417 L .65733 .37866 L p .516 g
F P
0 g
s
.648 .40356 m .65733 .37866 L .76621 .37417 L p .549 g
F P
0 g
s
.51854 .3442 m .51859 .36545 L .44955 .31675 L p .753 g
F P
0 g
s
.44955 .31675 m .44736 .28354 L .51854 .3442 L p .753 g
F P
0 g
s
.51871 .38878 m .5189 .41216 L .46151 .39008 L p .803 g
F P
0 g
s
.47017 .42367 m .46151 .39008 L .5189 .41216 L p .83 g
F P
0 g
s
.76621 .37417 m .74981 .40752 L .648 .40356 L p .549 g
F P
0 g
s
.45713 .23064 m .45141 .23871 L .36648 .21739 L p .334 g
F P
0 g
s
.36648 .21739 m .37941 .20718 L .45713 .23064 L p .334 g
F P
0 g
s
.66397 .48729 m .6963 .46641 L .74421 .49406 L p .697 g
F P
0 g
s
.42904 .45961 m .45015 .48163 L .4256 .49058 L p .734 g
F P
0 g
s
.4256 .49058 m .39744 .47285 L .42904 .45961 L p .734 g
F P
0 g
s
.78119 .46869 m .74421 .49406 L .6963 .46641 L p .711 g
F P
0 g
s
.51859 .36545 m .51871 .38878 L .45441 .35338 L p .778 g
F P
0 g
s
.45441 .35338 m .44955 .31675 L .51859 .36545 L p .778 g
F P
0 g
s
.46151 .39008 m .45441 .35338 L .51871 .38878 L p .803 g
F P
0 g
s
.47959 .45157 m .48901 .47215 L .45015 .48163 L p .82 g
F P
0 g
s
.81113 .43783 m .78119 .46869 L .72578 .43915 L p .714 g
F P
0 g
s
.72578 .43915 m .74981 .40752 L .81113 .43783 L p .714 g
F P
0 g
s
.37941 .20718 m .36648 .21739 L .31419 .25497 L p .69 g
F P
0 g
s
.3041 .27641 m .31419 .25497 L .36648 .21739 L p .027 g
F P
0 g
s
.6963 .46641 m .72578 .43915 L .78119 .46869 L p .711 g
F P
0 g
s
.45015 .48163 m .42904 .45961 L .47959 .45157 L p .82 g
F P
0 g
s
.40788 .42896 m .42904 .45961 L .39744 .47285 L p .687 g
F P
0 g
s
.39744 .47285 m .36933 .44711 L .40788 .42896 L p .687 g
F P
0 g
s
.45141 .23871 m .44803 .25677 L .35871 .23882 L p .487 g
F P
0 g
s
.35871 .23882 m .36648 .21739 L .45141 .23871 L p .487 g
F P
0 g
s
.36648 .21739 m .35871 .23882 L .3041 .27641 L p .027 g
F P
0 g
s
.30201 .3059 m .3041 .27641 L .35871 .23882 L p .229 g
F P
0 g
s
.47017 .42367 m .47959 .45157 L .42904 .45961 L p .776 g
F P
0 g
s
.38847 .39145 m .40788 .42896 L .36933 .44711 L p .634 g
F P
0 g
s
.36933 .44711 m .34362 .41481 L .38847 .39145 L p .634 g
F P
0 g
s
.35871 .23882 m .35703 .26997 L .30201 .3059 L p .229 g
F P
0 g
s
.30834 .34094 m .30201 .3059 L .35703 .26997 L p .402 g
F P
0 g
s
.42904 .45961 m .40788 .42896 L .47017 .42367 L p .776 g
F P
0 g
s
.44803 .25677 m .44736 .28354 L .35703 .26997 L p .568 g
F P
0 g
s
.35703 .26997 m .35871 .23882 L .44803 .25677 L p .568 g
F P
0 g
s
.46151 .39008 m .47017 .42367 L .40788 .42896 L p .737 g
F P
0 g
s
.37259 .34998 m .38847 .39145 L .34362 .41481 L p .575 g
F P
0 g
s
.34362 .41481 m .32264 .37837 L .37259 .34998 L p .575 g
F P
0 g
s
.35703 .26997 m .36177 .3082 L .30834 .34094 L p .402 g
F P
0 g
s
.32264 .37837 m .30834 .34094 L .36177 .3082 L p .503 g
F P
0 g
s
.36177 .3082 m .37259 .34998 L .32264 .37837 L p .503 g
F P
0 g
s
.44736 .28354 m .44955 .31675 L .36177 .3082 L p .621 g
F P
0 g
s
.36177 .3082 m .35703 .26997 L .44736 .28354 L p .621 g
F P
0 g
s
.45441 .35338 m .46151 .39008 L .38847 .39145 L p .699 g
F P
0 g
s
.40788 .42896 m .38847 .39145 L .46151 .39008 L p .737 g
F P
0 g
s
.44955 .31675 m .45441 .35338 L .37259 .34998 L p .662 g
F P
0 g
s
.37259 .34998 m .36177 .3082 L .44955 .31675 L p .662 g
F P
0 g
s
.38847 .39145 m .37259 .34998 L .45441 .35338 L p .699 g
F P
0 g
s
.25 Mabswid
.68734 0 m
.97019 .4311 L
s
.97019 .4311 m
1 .65038 L
s
1 .65038 m
.70104 .23999 L
s
.70104 .23999 m
.68734 0 L
s
.0362 .2546 m
0 .48397 L
s
0 .48397 m
.70104 .23999 L
s
.70104 .23999 m
.68734 0 L
s
.68734 0 m
.0362 .2546 L
s
.0362 .2546 m
.68734 0 L
s
.0406 .25288 m
.04539 .25737 L
s
gsave
.03101 .24391 -74.9375 -13.682 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.18479 .1965 m
.18935 .20122 L
s
gsave
.17566 .18707 -81.2255 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.33747 .1368 m
.34177 .14176 L
s
gsave
.32887 .12688 -68.8743 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.4994 .07349 m
.50339 .0787 L
s
gsave
.49142 .06307 -74.2987 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.67145 .00621 m
.67509 .01168 L
s
gsave
.66418 -0.00472 -68.0246 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.06879 .24186 m
.07164 .24458 L
s
.0973 .23071 m
.10012 .23346 L
s
.12614 .21944 m
.12893 .22221 L
s
.1553 .20803 m
.15806 .21084 L
s
.21462 .18484 m
.21733 .1877 L
s
.2448 .17304 m
.24748 .17593 L
s
.27533 .1611 m
.27798 .16402 L
s
.30622 .14902 m
.30883 .15197 L
s
.36909 .12444 m
.37163 .12745 L
s
.40108 .11193 m
.40359 .11497 L
s
.43346 .09927 m
.43593 .10234 L
s
.46623 .08646 m
.46867 .08955 L
s
.53297 .06036 m
.53532 .06352 L
s
.56695 .04707 m
.56927 .05026 L
s
.60136 .03362 m
.60363 .03684 L
s
.63619 .02 m
.63841 .02325 L
s
gsave
.29055 .07541 -68.4544 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.0253834 0.97619 0.508876 MathSubStart
%% Graphics3D
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8  scalefont  setfont
% Scaling calculations
5.55112e-17 1.05076 -0.0430942 1.05076 [
[.5 .87583 -21.125 0 ]
[.5 .87583 21.125 10.625 ]
[.14275 .20159 -20.3368 -10 ]
[.14275 .20159 .22569 0 ]
[.33541 .12482 -7.81009 -10 ]
[.33541 .12482 .62741 0 ]
[.5432 .04208 -12.9877 -10 ]
[.5432 .04208 2.07476 0 ]
[.29487 .07398 -7.40006 -10 ]
[.29487 .07398 .59994 0 ]
[.75833 .09145 0 -6.87754 ]
[.75833 .09145 20.5625 3.12246 ]
[.85004 .23311 0 -6.72587 ]
[.85004 .23311 8.4375 3.27413 ]
[.93038 .35722 0 -6.59687 ]
[.93038 .35722 15.0625 3.40313 ]
[.91212 .21168 0 -6.72587 ]
[.91212 .21168 8 3.27413 ]
[.03387 .25877 -20.5625 -3.01751 ]
[.03387 .25877 0 6.98249 ]
[.02311 .32651 -20.5625 -3.08126 ]
[.02311 .32651 0 6.91874 ]
[.01187 .39734 -8.4375 -3.14821 ]
[.01187 .39734 0 6.85179 ]
[.0001 .47147 -15.0625 -3.21862 ]
[.0001 .47147 0 6.78138 ]
[-0.01224 .54915 -15.0625 -3.29276 ]
[-0.01224 .54915 0 6.70724 ]
[-0.04972 .42014 -8 -3.14821 ]
[-0.04972 .42014 0 6.85179 ]
[ 0 0 0 0 ]
[ 1 .86333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .87583 -82.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.625000 moveto
 540.000000 14.625000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.625000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
67.437500 12.375000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 5.687500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(xy) show
74.500000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
79.625000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(orbital) show
101.250000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.25 Mabswid
[ ] 0 setdash
.04624 .25291 m
.68378 0 L
s
.15193 .21098 m
.15653 .21567 L
s
gsave
.14275 .20159 -81.3368 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.34392 .13482 m
.34818 .13982 L
s
gsave
.33541 .12482 -68.8101 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.5509 .05271 m
.55476 .05803 L
s
gsave
.5432 .04208 -73.9877 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.18921 .19619 m
.19193 .19905 L
s
.22704 .18119 m
.22971 .18408 L
s
.26542 .16596 m
.26806 .16889 L
s
.30438 .15051 m
.30697 .15347 L
s
.38406 .1189 m
.38657 .12193 L
s
.42482 .10273 m
.42728 .10581 L
s
.4662 .08631 m
.46861 .08943 L
s
.50822 .06964 m
.51059 .0728 L
s
.11519 .22555 m
.11799 .22834 L
s
.07898 .23992 m
.08181 .24267 L
s
.59426 .03551 m
.59652 .03874 L
s
.6383 .01804 m
.6405 .02131 L
s
.68304 .00029 m
.68519 .0036 L
s
gsave
.29487 .07398 -68.4001 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.68378 0 m
.96194 .42923 L
s
.74604 .09607 m
.73989 .09837 L
s
gsave
.75833 .09145 -61 -10.8775 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.83762 .23739 m
.83141 .23953 L
s
gsave
.85004 .23311 -61 -10.7259 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.91786 .36121 m
.91161 .36321 L
s
gsave
.93038 .35722 -61 -10.5969 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.76538 .12591 m
.76168 .12727 L
s
.78418 .15493 m
.78048 .15627 L
s
.80248 .18316 m
.79877 .18449 L
s
.82029 .21064 m
.81657 .21194 L
s
.85451 .26345 m
.85078 .26471 L
s
.87096 .28883 m
.86722 .29008 L
s
.88699 .31357 m
.88325 .3148 L
s
.90262 .33769 m
.89887 .33891 L
s
.72614 .06537 m
.72246 .06678 L
s
.70567 .03378 m
.702 .03521 L
s
.6846 .00126 m
.68093 .00271 L
s
.93273 .38416 m
.92898 .38534 L
s
.94724 .40655 m
.94348 .40772 L
s
.96141 .42841 m
.95764 .42956 L
s
gsave
.91212 .21168 -61 -10.7259 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04624 .25291 m
0 .54614 L
s
.04608 .25393 m
.05218 .25151 L
s
gsave
.03387 .25877 -81.5625 -7.01751 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.03538 .3218 m
.04151 .31945 L
s
gsave
.02311 .32651 -81.5625 -7.08126 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
68.500000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Helvetica
grestore
.02418 .39277 m
.03034 .39049 L
s
gsave
.01187 .39734 -69.4375 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.01247 .46706 m
.01866 .46486 L
s
gsave
.0001 .47147 -76.0625 -7.21862 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.00019 .54491 m
.00641 .54279 L
s
gsave
-0.01224 .54915 -76.0625 -7.29276 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.125 Mabswid
.04345 .27062 m
.04711 .26918 L
s
.04079 .28749 m
.04446 .28606 L
s
.0381 .30455 m
.04177 .30313 L
s
.03262 .33925 m
.03631 .33785 L
s
.02984 .35689 m
.03353 .3555 L
s
.02703 .37473 m
.03072 .37335 L
s
.02131 .41103 m
.025 .40967 L
s
.01839 .42949 m
.0221 .42814 L
s
.01545 .44817 m
.01916 .44683 L
s
.00945 .48618 m
.01317 .48487 L
s
.0064 .50553 m
.01012 .50423 L
s
.00332 .5251 m
.00704 .52382 L
s
gsave
-0.04972 .42014 -69 -7.14821 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 14.000000 moveto
 540.000000 14.000000 lineto
 540.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 14.000000 lineto
closepath
clip newpath
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
67.000000 11.000000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica
grestore
.25 Mabswid
.04624 .25291 m
0 .54614 L
s
0 .54614 m
.40023 .86333 L
s
.40023 .86333 m
.40933 .59805 L
s
.40933 .59805 m
.04624 .25291 L
s
.68378 0 m
.96194 .42923 L
s
.96194 .42923 m
1 .7095 L
s
1 .7095 m
.70123 .30687 L
s
.70123 .30687 m
.68378 0 L
s
.04624 .25291 m
0 .54614 L
s
0 .54614 m
.70123 .30687 L
s
.70123 .30687 m
.68378 0 L
s
.68378 0 m
.04624 .25291 L
s
.40933 .59805 m
.96194 .42923 L
s
.96194 .42923 m
1 .7095 L
s
1 .7095 m
.40023 .86333 L
s
.40023 .86333 m
.40933 .59805 L
s
0 0 m
1 0 L
1 .86333 L
0 .86333 L
closepath
clip
newpath
.5 Mabswid
.38246 .53504 m .36662 .57102 L .41772 .59801 L p .794 g
F P
0 g
s
.41772 .59801 m .42828 .55663 L .38246 .53504 L p .794 g
F P
0 g
s
.4098 .64023 m .41772 .59801 L .36662 .57102 L p .772 g
F P
0 g
s
.42828 .55663 m .41772 .59801 L .49208 .59887 L p .634 g
F P
0 g
s
.41772 .59801 m .4098 .64023 L .48973 .63889 L p .609 g
F P
0 g
s
.48973 .63889 m .49208 .59887 L .41772 .59801 L p .609 g
F P
0 g
s
.36662 .57102 m .35477 .60817 L .4098 .64023 L p .772 g
F P
0 g
s
.40504 .68059 m .4098 .64023 L .35477 .60817 L p .747 g
F P
0 g
s
.4098 .64023 m .40504 .68059 L .48832 .67687 L p .576 g
F P
0 g
s
.48832 .67687 m .48973 .63889 L .4098 .64023 L p .576 g
F P
0 g
s
.49208 .59887 m .49521 .55937 L .42828 .55663 L p .634 g
F P
0 g
s
.49521 .55937 m .49208 .59887 L .5522 .57145 L p .457 g
F P
0 g
s
.49208 .59887 m .48973 .63889 L .55432 .60209 L p .425 g
F P
0 g
s
.55432 .60209 m .5522 .57145 L .49208 .59887 L p .425 g
F P
0 g
s
.48973 .63889 m .48832 .67687 L .55554 .63099 L p .372 g
F P
0 g
s
.55554 .63099 m .55432 .60209 L .48973 .63889 L p .372 g
F P
0 g
s
.40128 .50248 m .38246 .53504 L .42828 .55663 L p .817 g
F P
0 g
s
.42828 .55663 m .44082 .51859 L .40128 .50248 L p .817 g
F P
0 g
s
.44082 .51859 m .42828 .55663 L .49521 .55937 L p .653 g
F P
0 g
s
.35477 .60817 m .34774 .64405 L .40504 .68059 L p .747 g
F P
0 g
s
.4038 .71638 m .40504 .68059 L .34774 .64405 L p .712 g
F P
0 g
s
.40504 .68059 m .4038 .71638 L .48796 .71022 L p .528 g
F P
0 g
s
.48796 .71022 m .48832 .67687 L .40504 .68059 L p .528 g
F P
0 g
s
.49521 .55937 m .49895 .52283 L .44082 .51859 L p .653 g
F P
0 g
s
.49895 .52283 m .49521 .55937 L .54932 .54116 L p .473 g
F P
0 g
s
.5522 .57145 m .54932 .54116 L .49521 .55937 L p .457 g
F P
0 g
s
.48832 .67687 m .48796 .71022 L .55576 .65611 L p .285 g
F P
0 g
s
.55576 .65611 m .55554 .63099 L .48832 .67687 L p .285 g
F P
0 g
s
.42192 .47529 m .40128 .50248 L .44082 .51859 L p .839 g
F P
0 g
s
.44082 .51859 m .45461 .48614 L .42192 .47529 L p .839 g
F P
0 g
s
.45461 .48614 m .44082 .51859 L .49895 .52283 L p .667 g
F P
0 g
s
.34774 .64405 m .34608 .67614 L .4038 .71638 L p .712 g
F P
0 g
s
.40627 .74494 m .4038 .71638 L .34608 .67614 L p .647 g
F P
0 g
s
.4038 .71638 m .40627 .74494 L .48871 .73647 L p .447 g
F P
0 g
s
.48871 .73647 m .48796 .71022 L .4038 .71638 L p .447 g
F P
0 g
s
.49895 .52283 m .50305 .4914 L .45461 .48614 L p .667 g
F P
0 g
s
.50305 .4914 m .49895 .52283 L .54588 .51316 L p .468 g
F P
0 g
s
.54932 .54116 m .54588 .51316 L .49895 .52283 L p .473 g
F P
0 g
s
.48796 .71022 m .48871 .73647 L .55494 .67554 L p .129 g
F P
0 g
s
.55494 .67554 m .55576 .65611 L .48796 .71022 L p .129 g
F P
0 g
s
.38813 .505 m .37264 .52912 L .36662 .57102 L p .813 g
F P
0 g
s
.36662 .57102 m .38246 .53504 L .38753 .50819 L p .813 g
F P
0 g
s
.36662 .57102 m .38753 .50819 L .38636 .51042 L .813 g
F
.46881 .46109 m .45461 .48614 L .50305 .4914 L p .671 g
F P
0 g
s
.40658 .48374 m .38813 .505 L .38246 .53504 L p .8 g
F P
0 g
s
.38246 .53504 m .40128 .50248 L .40547 .48767 L p .8 g
F P
0 g
s
.40547 .48767 m .40658 .48374 L p .40277 .49185 L .8 g
F P
0 g
s
.38246 .53504 m .40547 .48767 L .40277 .49185 L .8 g
F
.45538 .49217 m .38112 .52533 L p .46037 .48503 L .177 g
F P
0 g
s
.38131 .52504 m .46245 .48398 L .38112 .52533 L .177 g
F
.37801 .52642 m .46245 .48398 L .3778 .52682 L F
.44311 .45496 m .42192 .47529 L .45461 .48614 L p .857 g
F P
0 g
s
.38753 .50819 m .38813 .505 L p .38636 .51042 L .813 g
F P
0 g
s
.42676 .46664 m .40658 .48374 L .40128 .50248 L p .731 g
F P
0 g
s
.40128 .50248 m .42192 .47529 L .42515 .46951 L p .731 g
F P
0 g
s
.42515 .46951 m .42676 .46664 L p .42104 .47468 L .731 g
F P
0 g
s
.40128 .50248 m .42515 .46951 L .42104 .47468 L .731 g
F
.35477 .60817 m .36662 .57102 L .37264 .52912 L p .778 g
F P
0 g
s
.37264 .52912 m .36119 .5545 L .35477 .60817 L p .778 g
F P
0 g
s
.36119 .5545 m .37264 .52912 L .45538 .49217 L p .185 g
F P
0 g
s
.45025 .50104 m .36119 .5545 L p .45334 .49352 L .185 g
F P
0 g
s
.45538 .49217 m .45025 .50104 L p .45334 .49352 L .185 g
F P
0 g
s
.37264 .52912 m .38813 .505 L .45714 .48548 L p .177 g
F P
0 g
s
.45714 .48548 m .46245 .48398 L p .45671 .48687 L .177 g
F P
0 g
s
.37264 .52912 m .45714 .48548 L .45671 .48687 L .177 g
F
.34774 .64405 m .35477 .60817 L .36119 .5545 L p .687 g
F P
0 g
s
.36119 .5545 m .35462 .57935 L .34774 .64405 L p .687 g
F P
0 g
s
.35462 .57935 m .36119 .5545 L .45025 .50104 L p .2 g
F P
0 g
s
.44748 .5099 m .35462 .57935 L p .44823 .50269 L .2 g
F P
0 g
s
.45025 .50104 m .44748 .5099 L p .44823 .50269 L .2 g
F P
0 g
s
.35348 .60183 m .35462 .57935 L .44748 .5099 L p .222 g
F P
0 g
s
.44728 .51807 m .35348 .60183 L p .44545 .51188 L .222 g
F P
0 g
s
.44748 .5099 m .44728 .51807 L p .44545 .51188 L .222 g
F P
0 g
s
.35796 .62021 m .35348 .60183 L .44728 .51807 L p .249 g
F P
0 g
s
.44971 .52489 m .35796 .62021 L p .44525 .5204 L .249 g
F P
0 g
s
.44728 .51807 m .44971 .52489 L p .44525 .5204 L .249 g
F P
0 g
s
.44971 .52489 m .44728 .51807 L p .44902 .52396 L .573 g
F P
0 g
s
.43998 .515 m .44971 .52489 L p .43797 .50884 L .573 g
F P
0 g
s
.43722 .50782 m .43998 .515 L p .43797 .50884 L .573 g
F P
0 g
s
.38112 .52533 m .3778 .52682 L p .38131 .52504 L .177 g
F P
0 g
s
.3778 .52682 m .37264 .52912 L p .37801 .52642 L .177 g
F P
0 g
s
.43998 .515 m .27239 .54229 L p .44195 .52104 L .449 g
F P
0 g
s
.44971 .52489 m .43998 .515 L p .45376 .52898 L .057 g
F P
0 g
s
.44552 .52059 m .45457 .5298 L p .44094 .51598 L .057 g
F P
0 g
s
.43998 .515 m .44552 .52059 L p .44094 .51598 L .057 g
F P
0 g
s
.45457 .5298 m .44971 .52489 L p .45376 .52898 L .057 g
F P
0 g
s
.36786 .63295 m .35796 .62021 L .44971 .52489 L p .278 g
F P
0 g
s
.44971 .52489 m .45457 .5298 L .36786 .63295 L p .278 g
F P
0 g
s
.44728 .51807 m .43722 .50782 L p .44902 .52396 L .573 g
F P
0 g
s
.46151 .53241 m .45457 .5298 L .44552 .52059 L p .404 g
F P
0 g
s
.44552 .52059 m .28809 .56049 L p .44982 .52494 L .395 g
F P
0 g
s
.45341 .52415 m .46151 .53241 L p .44672 .52148 L .404 g
F P
0 g
s
.44552 .52059 m .45341 .52415 L p .44672 .52148 L .404 g
F P
0 g
s
.47 .53253 m .46151 .53241 L .45341 .52415 L p .621 g
F P
0 g
s
.46305 .52541 m .47 .53253 L p .45488 .52489 L .621 g
F P
0 g
s
.45341 .52415 m .46305 .52541 L p .45488 .52489 L .621 g
F P
0 g
s
.38254 .63894 m .36786 .63295 L .45457 .5298 L p .308 g
F P
0 g
s
.45457 .5298 m .46151 .53241 L .38254 .63894 L p .308 g
F P
0 g
s
.47938 .5302 m .47 .53253 L .46305 .52541 L p .711 g
F P
0 g
s
.47369 .52433 m .47938 .5302 L p .46481 .52592 L .711 g
F P
0 g
s
.46305 .52541 m .47369 .52433 L p .46481 .52592 L .711 g
F P
0 g
s
.40099 .63762 m .38254 .63894 L .46151 .53241 L p .336 g
F P
0 g
s
.46151 .53241 m .47 .53253 L .40099 .63762 L p .336 g
F P
0 g
s
.48897 .52571 m .47938 .5302 L .47369 .52433 L p .754 g
F P
0 g
s
.48454 .5211 m .48897 .52571 L p .47575 .52451 L .754 g
F P
0 g
s
.47369 .52433 m .48454 .5211 L p .47575 .52451 L .754 g
F P
0 g
s
.42183 .62907 m .40099 .63762 L .47 .53253 L p .362 g
F P
0 g
s
.47 .53253 m .47938 .5302 L .42183 .62907 L p .362 g
F P
0 g
s
.49808 .51952 m .48897 .52571 L .48454 .5211 L p .779 g
F P
0 g
s
.49485 .51612 m .49551 .51682 L p .4901 .51893 L .779 g
F P
0 g
s
.49551 .51682 m .49808 .51952 L p .49056 .5204 L .779 g
F P
0 g
s
.49056 .5204 m .48454 .5211 L .49551 .51682 L .779 g
F
.4435 .61413 m .42183 .62907 L .47938 .5302 L p .385 g
F P
0 g
s
.47938 .5302 m .48897 .52571 L .4435 .61413 L p .385 g
F P
0 g
s
.50615 .51228 m .49808 .51952 L .49686 .51824 L p .794 g
F P
0 g
s
.49686 .51824 m .49485 .51612 L p .50119 .51397 L .794 g
F P
0 g
s
.50615 .51228 m .49686 .51824 L .50119 .51397 L .794 g
F
.54588 .51316 m .54209 .48919 L .50305 .4914 L p .468 g
F P
0 g
s
.51694 .49672 m .51767 .49751 L p .5142 .50069 L .807 g
F P
0 g
s
.5114 .50326 m .51694 .49672 L p .5142 .50069 L .807 g
F P
0 g
s
.52059 .49098 m .52091 .49133 L p .51945 .49331 L .808 g
F P
0 g
s
.51694 .49672 m .52059 .49098 L p .51945 .49331 L .808 g
F P
0 g
s
.50728 .46687 m .50305 .4914 L .54209 .48919 L p .432 g
F P
0 g
s
.52091 .49133 m .52059 .49098 L p .52237 .4873 L .803 g
F P
0 g
s
.52267 .48667 m .52218 .48797 L p .52237 .4873 L .803 g
F P
0 g
s
.52218 .48797 m .52091 .49133 L p .52237 .4873 L .803 g
F P
0 g
s
.52059 .49098 m .52258 .48656 L .52267 .48667 L p .803 g
F P
0 g
s
.52091 .49133 m .52267 .48667 L .52164 .49377 L p .478 g
F P
0 g
s
.52164 .49377 m .51751 .50752 L .51992 .49606 L p .478 g
F P
0 g
s
.52154 .49343 m .51992 .49606 L .52095 .49236 L .478 g
F
.52154 .49343 m .52095 .49236 L .52109 .49195 L F
.52322 .48555 m .52164 .49377 L .52267 .48667 L p .524 g
F P
0 g
s
.51767 .49751 m .52091 .49133 L .51751 .50752 L p .46 g
F P
0 g
s
.51957 .49702 m .51923 .49821 L p .52272 .48729 L F P
s
.51923 .49821 m .5192 .49832 L p .51926 .49813 L F P
s
.52272 .48729 m .51923 .49821 L .51926 .49813 L F
.5214 .49409 m .51992 .49606 L .52154 .49343 L .478 g
F
.5192 .49832 m .52291 .48695 L .52296 .48654 L p 0 g
F P
s
.52291 .48695 m .5192 .49832 L .51982 .49676 L p F P
s
.51275 .5047 m .51767 .49751 L .50993 .52606 L p .448 g
F P
0 g
s
.51751 .50752 m .50993 .52606 L .51767 .49751 L p .46 g
F P
0 g
s
.52108 .49191 m .52051 .49396 L .52091 .49133 L .478 g
F
.52003 .4955 m .52091 .49133 L p .52051 .49396 L F P
0 g
s
.50993 .52606 m .49843 .54801 L .50975 .51379 L p .448 g
F P
0 g
s
.50975 .51379 m .51275 .5047 L p .51215 .50928 L .448 g
F P
0 g
s
.50993 .52606 m .50975 .51379 L .51215 .50928 L .448 g
F
.51485 .50466 m .51067 .51316 L p .51631 .50191 L 0 g
F P
s
.51078 .51293 m .51957 .49702 L .52083 .4929 L p F P
s
.49808 .51952 m .50615 .51228 L .48305 .57148 L p .422 g
F P
0 g
s
.50615 .51228 m .51275 .5047 L .49843 .54801 L p .436 g
F P
0 g
s
.49843 .54801 m .48305 .57148 L .50615 .51228 L p .436 g
F P
0 g
s
.49421 .53312 m .51067 .51316 L .51485 .50466 L p F P
s
.48305 .57148 m .46438 .59427 L .49808 .51952 L p .422 g
F P
0 g
s
.50382 .51962 m .49421 .53312 L p .50275 .52134 L F P
s
.46438 .59427 m .4435 .61413 L .48897 .52571 L p .405 g
F P
0 g
s
.48897 .52571 m .49808 .51952 L .46438 .59427 L p .405 g
F P
0 g
s
.46895 .55454 m .49421 .53312 L .50382 .51962 L p F P
s
.48042 .54288 m .46895 .55454 L p .48009 .54339 L F P
s
.43471 .57474 m .46895 .55454 L .487 .5362 L p F P
s
.46895 .55454 m .46344 .55664 L p .4883 .53763 L .877 g
F P
0 g
s
.49421 .53312 m .48254 .54302 L p .4883 .53763 L .877 g
F P
0 g
s
.48254 .54302 m .46895 .55454 L p .4883 .53763 L .877 g
F P
0 g
s
.49134 .53572 m .49421 .53312 L p .47937 .54446 L .877 g
F P
0 g
s
.49421 .53312 m .49134 .53572 L p .5076 .51674 L .81 g
F P
0 g
s
.49932 .52641 m .49532 .53108 L .49836 .52783 L .81 g
F
.49134 .53572 m .49619 .53026 L p .49532 .53108 L F P
0 g
s
.49619 .53026 m .49836 .52783 L p .49532 .53108 L .81 g
F P
0 g
s
.46344 .55664 m .47906 .54493 L p .47937 .54446 L .877 g
F P
0 g
s
.47906 .54493 m .49134 .53572 L p .47937 .54446 L .877 g
F P
0 g
s
.50382 .51962 m .487 .5362 L .48042 .54288 L p F P
s
.50382 .51962 m .48042 .54288 L .48009 .54339 L F
.51067 .51316 m .50484 .52023 L p .5076 .51674 L .81 g
F P
0 g
s
.50484 .52023 m .49421 .53312 L p .5076 .51674 L .81 g
F P
0 g
s
.51208 .51058 m .51116 .51225 L .51151 .51174 L .691 g
F
.50945 .51535 m .51139 .51196 L p .51116 .51225 L F P
0 g
s
.51139 .51196 m .51151 .51174 L p .51116 .51225 L .691 g
F P
0 g
s
.50945 .51535 m .51067 .51316 L p .49932 .52641 L .81 g
F P
0 g
s
.49836 .52783 m .50945 .51535 L p .49932 .52641 L .81 g
F P
0 g
s
.51485 .50466 m .505 .51802 L p .50275 .52134 L F P
s
.505 .51802 m .50382 .51962 L p .50275 .52134 L F P
s
.51957 .49702 m .51067 .51316 L .50945 .51535 L p .691 g
F P
0 g
s
.5192 .49832 m .51957 .49702 L p .51208 .51058 L .691 g
F P
0 g
s
.51151 .51174 m .5192 .49832 L p .51208 .51058 L .691 g
F P
0 g
s
.52015 .49426 m .51767 .49912 L .51631 .50191 L F
.51767 .49912 m .51485 .50466 L .51631 .50191 L F
.52083 .4929 m .51994 .49465 L p .52015 .49426 L F P
s
.51994 .49465 m .51485 .50466 L p .52015 .49426 L F P
s
.51147 .51149 m .5158 .50295 L p .5197 .49694 L .875 g
F P
0 g
s
.51982 .49676 m .51967 .49701 L p .5197 .49694 L .875 g
F P
0 g
s
.51967 .49701 m .51147 .51149 L p .5197 .49694 L .875 g
F P
0 g
s
.52273 .48724 m .51957 .49702 L .52272 .48729 L F
.52294 .48659 m .51957 .49702 L p .52294 .48658 L F P
s
.52258 .48656 m .52334 .48382 L .52335 .48383 L p .792 g
F P
0 g
s
.52335 .48383 m .52267 .48667 L .52258 .48656 L p .792 g
F P
0 g
s
.52335 .48383 m .52322 .48555 L p .52311 .48578 L .524 g
F P
0 g
s
.52311 .48578 m .523 .486 L .52329 .48419 L .524 g
F
.52311 .48578 m .52329 .48419 L .52335 .48383 L F
.523 .486 m .52324 .48433 L .52335 .48383 L F
.52312 .48544 m .52334 .48382 L p .52333 .48386 L 0 g
F P
s
.523 .486 m .5228 .4864 L .52324 .48433 L .524 g
F
.52267 .48667 m .52305 .48508 L p .5228 .4864 L F P
0 g
s
.52305 .48508 m .52334 .48387 L p .5228 .4864 L .524 g
F P
0 g
s
.52334 .48387 m .52335 .48383 L p .52334 .48388 L .524 g
F P
0 g
s
.5228 .4864 m .52334 .48387 L .52334 .48388 L .524 g
F
.52334 .48382 m .52312 .48544 L .5234 .48329 L p .811 g
F P
0 g
s
.5234 .48329 m .52345 .48291 L .52338 .48345 L p .811 g
F P
0 g
s
.52338 .48345 m .52334 .48382 L p .5234 .48329 L .811 g
F P
0 g
s
.52083 .4929 m .52312 .48544 L p .52333 .48386 L F P
s
.52312 .48544 m .52296 .48654 L .52335 .48365 L p .761 g
F P
0 g
s
.52335 .48365 m .52341 .4832 L p .52335 .48363 L .761 g
F P
0 g
s
.52083 .4929 m .51957 .49702 L p .52271 .48675 L .65 g
F P
0 g
s
.52278 .48655 m .52272 .48674 L .52271 .48675 L .65 g
F
.52272 .48674 m .52083 .4929 L .52271 .48675 L F
.52312 .48544 m .52268 .48685 L p .52278 .48655 L F P
0 g
s
.52268 .48685 m .52083 .4929 L p .52278 .48655 L .65 g
F P
0 g
s
.51992 .49606 m .52003 .4955 L p .52051 .49396 L .478 g
F P
0 g
s
.51957 .49702 m .52296 .48654 L .52312 .48544 L p .65 g
F P
0 g
s
.52296 .48654 m .52291 .48695 L .52342 .48315 L p .002 g
F P
0 g
s
.52296 .48654 m .52294 .48659 L p .52294 .48658 L F P
s
.52306 .48591 m .52245 .4881 L .52259 .48738 L .798 g
F
.52307 .48588 m .52245 .4881 L .52306 .48591 L F
.52112 .49283 m .52252 .48765 L p .52245 .4881 L F P
0 g
s
.52252 .48765 m .52259 .48738 L p .52245 .4881 L .798 g
F P
0 g
s
.52299 .4866 m .52291 .48695 L p .52237 .48867 L F P
s
.51982 .49676 m .52239 .48852 L p .52237 .48867 L F P
s
.52239 .48852 m .52299 .4866 L p .52237 .48867 L F P
s
.52299 .4866 m .51982 .49676 L .52112 .49283 L p F P
s
.52164 .49377 m .5214 .49409 L .52154 .49343 L .478 g
F
.52164 .49377 m .52322 .48555 L .5232 .48681 L p .622 g
F P
0 g
s
.5232 .48681 m .52148 .49908 L .52164 .49377 L p .622 g
F P
0 g
s
.51751 .50752 m .52164 .49377 L .52148 .49908 L p .601 g
F P
0 g
s
.51961 .50281 m .52177 .49644 L .52245 .48933 L p .532 g
F P
0 g
s
.52312 .48572 m .52112 .49283 L p .52313 .48568 L .798 g
F P
0 g
s
.52294 .48658 m .52273 .48724 L .52272 .48729 L F
.52112 .49283 m .52315 .4856 L .52299 .4866 L p F P
s
.52258 .48656 m .52236 .48736 L p .52274 .48599 L F P
s
.52236 .48736 m .52083 .4929 L p .52253 .48675 L F P
s
.52274 .48599 m .52236 .48736 L .52253 .48675 L F
.52109 .49195 m .52095 .49236 L .52108 .49191 L .478 g
F
.52091 .49133 m .51767 .49751 L .51694 .49672 L p .808 g
F P
0 g
s
.51485 .50466 m .52083 .4929 L .52258 .48656 L p F P
s
.52259 .48738 m .52063 .49176 L .52278 .48579 L p .823 g
F P
0 g
s
.52063 .49176 m .52259 .48738 L .52112 .49283 L p .841 g
F P
0 g
s
.52245 .48933 m .52272 .48646 L p .52006 .50043 L .532 g
F P
0 g
s
.52006 .50043 m .51961 .50281 L .52245 .48933 L .532 g
F
.52272 .48646 m .52278 .48579 L p .52263 .48661 L F P
0 g
s
.52263 .48661 m .51961 .50281 L .52272 .48646 L .532 g
F
.52345 .48291 m .52335 .48383 L .52334 .48382 L closepath p .771 g
F P
0 g
s
.52345 .48291 m .52299 .4866 L .52315 .4856 L closepath p .116 g
F P
0 g
s
.52313 .48568 m .52307 .48588 L .52306 .48591 L .798 g
F
.52345 .48291 m .52322 .48555 L .52335 .48383 L closepath p .719 g
F P
0 g
s
.52315 .4856 m .52334 .48414 L .52342 .48327 L p .259 g
F P
0 g
s
.52342 .48327 m .52345 .48291 L .52341 .48323 L p .259 g
F P
0 g
s
.52341 .48323 m .52315 .4856 L p .52342 .48327 L .259 g
F P
0 g
s
.52334 .48414 m .52331 .48429 L p .52332 .48419 L .795 g
F P
0 g
s
.52335 .48363 m .52312 .48544 L .52335 .48365 L .761 g
F
.52345 .48291 m .5232 .48681 L .52322 .48555 L closepath p .672 g
F P
0 g
s
.52345 .48291 m .52334 .48414 L .52342 .48332 L closepath p .353 g
F P
0 g
s
.52341 .4832 m .52296 .48654 L p .52341 .48317 L .002 g
F P
0 g
s
.52341 .4832 m .52345 .48291 L .5234 .48329 L p .761 g
F P
0 g
s
.52342 .48316 m .52341 .48317 L .52342 .48315 L .002 g
F
.52341 .4832 m .52341 .48317 L .52342 .48316 L F
.52342 .48333 m .52342 .48332 L .52342 .48334 L p .795 g
F P
0 g
s
.52342 .48334 m .52334 .48414 L p .52342 .48333 L .795 g
F P
0 g
s
.52325 .48439 m .52342 .48333 L p .52334 .48414 L .795 g
F P
0 g
s
.52342 .48333 m .52335 .48379 L p .52342 .48334 L .513 g
F P
0 g
s
.5234 .48329 m .52312 .48544 L p .52341 .4832 L .761 g
F P
0 g
s
.52291 .48695 m .52299 .4866 L .52342 .48311 L p .03 g
F P
0 g
s
.52335 .48379 m .52325 .48439 L p .52334 .48381 L .513 g
F P
0 g
s
.52335 .48379 m .52334 .48381 L .52342 .48334 L .513 g
F
.52148 .49908 m .5232 .48681 L .52327 .48734 L p .632 g
F P
0 g
s
.52327 .48734 m .52208 .50142 L .52148 .49908 L p .632 g
F P
0 g
s
.52325 .48439 m .52294 .48989 L p .52342 .48334 L .513 g
F P
0 g
s
.52345 .48291 m .52327 .48734 L .5232 .48681 L closepath p .629 g
F P
0 g
s
.52342 .48332 m .52342 .48333 L p .52342 .48334 L .513 g
F P
0 g
s
.52259 .48738 m .52325 .48439 L p .52332 .48419 L .795 g
F P
0 g
s
.52331 .48429 m .52259 .48738 L p .52332 .48419 L .795 g
F P
0 g
s
.52342 .48315 m .5231 .48551 L p .52342 .48311 L .03 g
F P
0 g
s
.5231 .48551 m .52291 .48695 L p .52311 .48549 L .03 g
F P
0 g
s
.5231 .48551 m .52311 .48549 L .52342 .48311 L .03 g
F
.52259 .48738 m .52334 .48414 L .52315 .4856 L p .798 g
F P
0 g
s
.52325 .48439 m .52305 .48499 L p .52177 .49644 L .535 g
F P
0 g
s
.52278 .48579 m .52325 .48439 L .52259 .48738 L p .823 g
F P
0 g
s
.52305 .48499 m .52278 .48579 L .52272 .48644 L p .535 g
F P
0 g
s
.52272 .48644 m .52177 .49644 L p .52305 .48499 L .535 g
F P
0 g
s
.52342 .48315 m .52345 .48291 L .52341 .4832 L p .002 g
F P
0 g
s
.52342 .48311 m .52345 .48291 L .52342 .48315 L p .03 g
F P
0 g
s
.52059 .49098 m .51485 .50466 L p .52138 .48937 L F P
s
.52258 .48656 m .52059 .49098 L p .52138 .48937 L F P
s
.52193 .48718 m .52278 .48579 L .52254 .48645 L p .807 g
F P
0 g
s
.52254 .48645 m .52063 .49176 L p .52193 .48718 L .807 g
F P
0 g
s
.52064 .48819 m .52193 .48718 L .52161 .48778 L p .794 g
F P
0 g
s
.52161 .48778 m .51701 .4963 L p .52064 .48819 L .794 g
F P
0 g
s
.51889 .4885 m .52064 .48819 L .51148 .49995 L p .782 g
F P
0 g
s
.52064 .48819 m .51889 .4885 L .51871 .48902 L p .492 g
F P
0 g
s
.51767 .49751 m .51275 .5047 L .5114 .50326 L p .807 g
F P
0 g
s
.51694 .49672 m .5156 .49907 L p .5188 .49403 L .001 g
F P
0 g
s
.51275 .5047 m .50615 .51228 L .5059 .51202 L p .803 g
F P
0 g
s
.51275 .5047 m .5059 .51202 L .51026 .50619 L .803 g
F
.5114 .50326 m .51275 .5047 L p .50674 .50829 L F P
0 g
s
.50395 .50996 m .5114 .50326 L p .50674 .50829 L .803 g
F P
0 g
s
.5114 .50326 m .50965 .50562 L p .51302 .50152 L .001 g
F P
0 g
s
.51694 .49672 m .5114 .50326 L p .51302 .50152 L .001 g
F P
0 g
s
.5156 .49907 m .50382 .51962 L p .51677 .4975 L .001 g
F P
0 g
s
.5188 .49403 m .5156 .49907 L .51677 .4975 L .001 g
F
.5059 .51202 m .50395 .50996 L p .51026 .50619 L .803 g
F P
0 g
s
.51694 .49672 m .50965 .50562 L .51181 .50349 L .001 g
F
.50382 .51962 m .51485 .50466 L .52059 .49098 L p F P
0 g
s
.50395 .50996 m .50615 .51228 L p .49745 .51524 L .794 g
F P
0 g
s
.49485 .51612 m .50395 .50996 L p .49745 .51524 L .794 g
F P
0 g
s
.50395 .50996 m .50184 .51223 L p .50626 .50808 L .029 g
F P
0 g
s
.5114 .50326 m .50395 .50996 L p .50626 .50808 L .029 g
F P
0 g
s
.487 .5362 m .50382 .51962 L .51694 .49672 L p .001 g
F P
0 g
s
.52059 .49098 m .51694 .49672 L p .5188 .49403 L .001 g
F P
0 g
s
.52063 .49176 m .51701 .4963 L .52193 .48718 L p .807 g
F P
0 g
s
.51701 .4963 m .52063 .49176 L .5158 .50295 L p .811 g
F P
0 g
s
.51701 .4963 m .51148 .49995 L .52064 .48819 L p .794 g
F P
0 g
s
.50965 .50562 m .487 .5362 L p .51181 .50349 L .001 g
F P
0 g
s
.5114 .50326 m .50184 .51223 L .50508 .50989 L .029 g
F
.46433 .55259 m .487 .5362 L .5114 .50326 L p F P
0 g
s
.51148 .49995 m .51701 .4963 L .50592 .51402 L p .787 g
F P
0 g
s
.5158 .50295 m .50592 .51402 L .51701 .4963 L p .811 g
F P
0 g
s
.50592 .51402 m .5158 .50295 L .51147 .51149 L p .918 g
F P
0 g
s
.51871 .48902 m .51175 .50814 L p .52064 .48819 L .492 g
F P
0 g
s
.52193 .48718 m .52064 .48819 L .52047 .48892 L p .516 g
F P
0 g
s
.52112 .49283 m .5158 .50295 L .52063 .49176 L p .841 g
F P
0 g
s
.5158 .50295 m .52112 .49283 L .51982 .49676 L p .875 g
F P
0 g
s
.51147 .51149 m .51982 .49676 L .5192 .49832 L p .767 g
F P
0 g
s
.5192 .49832 m .50945 .51535 L .51147 .51149 L p .767 g
F P
0 g
s
.52047 .48892 m .51629 .50725 L p .52193 .48718 L .516 g
F P
0 g
s
.51629 .50725 m .51651 .50695 L p .52193 .48718 L .516 g
F P
0 g
s
.51651 .50695 m .51843 .50438 L p .52066 .49345 L .516 g
F P
0 g
s
.52193 .48718 m .51651 .50695 L .52066 .49345 L .516 g
F
.51843 .50438 m .51961 .50281 L .52075 .49514 L p F P
0 g
s
.52075 .49514 m .52193 .48718 L p .51843 .50438 L .516 g
F P
0 g
s
.52315 .4856 m .52312 .48572 L p .52313 .48568 L .798 g
F P
0 g
s
.52334 .48382 m .52258 .48656 L p .52274 .48599 L F P
s
.49485 .51612 m .43655 .56688 L p .50086 .51257 L .064 g
F P
0 g
s
.50395 .50996 m .49485 .51612 L p .50086 .51257 L .064 g
F P
0 g
s
.48454 .5211 m .49485 .51612 L p .4901 .51893 L .779 g
F P
0 g
s
.50184 .51223 m .46433 .55259 L p .50508 .50989 L .029 g
F P
0 g
s
.48454 .5211 m .40512 .57728 L p .49151 .5184 L .103 g
F P
0 g
s
.49485 .51612 m .48454 .5211 L p .49151 .5184 L .103 g
F P
0 g
s
.47369 .52433 m .37212 .58237 L p .48105 .52301 L .148 g
F P
0 g
s
.48454 .5211 m .47369 .52433 L p .48105 .52301 L .148 g
F P
0 g
s
.46305 .52541 m .33999 .5813 L p .47011 .52585 L .243 g
F P
0 g
s
.47369 .52433 m .46305 .52541 L p .47011 .52585 L .243 g
F P
0 g
s
.45341 .52415 m .31122 .57385 L p .45945 .52656 L .326 g
F P
0 g
s
.46305 .52541 m .45341 .52415 L p .45945 .52656 L .326 g
F P
0 g
s
.45341 .52415 m .44552 .52059 L p .44982 .52494 L .395 g
F P
0 g
s
.44552 .52059 m .43998 .515 L p .44195 .52104 L .449 g
F P
0 g
s
.44748 .5099 m .43744 .49962 L p .44673 .51704 L .745 g
F P
0 g
s
.44728 .51807 m .44748 .5099 L p .44673 .51704 L .745 g
F P
0 g
s
.45025 .50104 m .4406 .49108 L p .44707 .50879 L .792 g
F P
0 g
s
.44748 .5099 m .45025 .50104 L p .44707 .50879 L .792 g
F P
0 g
s
.45538 .49217 m .45473 .4915 L p .45 .49985 L .802 g
F P
0 g
s
.45461 .48614 m .46881 .46109 L .45415 .45759 L p .857 g
F P
0 g
s
.45415 .45759 m .44311 .45496 L p .44571 .462 L .857 g
F P
0 g
s
.45461 .48614 m .45415 .45759 L .44571 .462 L .857 g
F
.46354 .44239 m .44311 .45496 L .46881 .46109 L p .846 g
F P
0 g
s
.42192 .47529 m .44311 .45496 L .44603 .45473 L p F P
s
.44603 .45473 m .44734 .45463 L p .44304 .45812 L F P
s
.42192 .47529 m .44603 .45473 L .44304 .45812 L F
.50305 .4914 m .50728 .46687 L .46881 .46109 L p .671 g
F P
0 g
s
.47858 .47164 m .43485 .46742 L p .48431 .46841 L .201 g
F P
0 g
s
.46065 .48449 m .39949 .50179 L p .46528 .479 L .177 g
F P
0 g
s
.45958 .48097 m .46042 .48186 L p .46083 .48054 L .784 g
F P
0 g
s
.40016 .50094 m .46885 .47774 L .39949 .50179 L .177 g
F
.46885 .47774 m .47093 .47704 L .46882 .47777 L F
.46885 .47774 m .46882 .47777 L .39949 .50179 L F
.38813 .505 m .40658 .48374 L .47093 .47704 L p F P
0 g
s
.47093 .47704 m .46921 .47722 L p .47445 .47463 L .185 g
F P
0 g
s
.46921 .47722 m .40658 .48374 L p .47478 .47268 L .185 g
F P
0 g
s
.47478 .47268 m .48019 .4718 L .46921 .47722 L .185 g
F
.46528 .479 m .46882 .47777 L .46065 .48449 L .177 g
F
.46882 .47777 m .47093 .47704 L .46563 .48088 L F
.46882 .47777 m .46563 .48088 L .46065 .48449 L F
.47093 .47704 m .46245 .48398 L .46065 .48449 L p F P
0 g
s
.46245 .48398 m .45538 .49217 L p .46037 .48503 L .177 g
F P
0 g
s
.44734 .45463 m .42676 .46664 L .4226 .47409 L p F P
s
.4226 .47409 m .42192 .47529 L p .42486 .47291 L F P
s
.42486 .47291 m .44734 .45463 L .4226 .47409 L F
.40658 .48374 m .42676 .46664 L .48019 .4718 L p .185 g
F P
0 g
s
.46245 .48398 m .45447 .47561 L p .45531 .49094 L .797 g
F P
0 g
s
.45538 .49217 m .46245 .48398 L p .45531 .49094 L .797 g
F P
0 g
s
.47093 .47704 m .4641 .46981 L p .46259 .48273 L .784 g
F P
0 g
s
.46245 .48398 m .47093 .47704 L p .46259 .48273 L .784 g
F P
0 g
s
.48019 .4718 m .47093 .47704 L p .47445 .47463 L .185 g
F P
0 g
s
.45447 .47561 m .44643 .48287 L .4534 .49012 L p .797 g
F P
0 g
s
.4534 .49012 m .45473 .4915 L p .45469 .48908 L .797 g
F P
0 g
s
.45469 .48908 m .45447 .47561 L .4534 .49012 L .797 g
F
.45473 .4915 m .45538 .49217 L p .45531 .49094 L F P
0 g
s
.45531 .49094 m .45447 .47561 L .45473 .4915 L .797 g
F
.46083 .48054 m .4641 .46981 L .45958 .48097 L .784 g
F
.4641 .46981 m .45447 .47561 L .45958 .48097 L p F P
0 g
s
.46042 .48186 m .46245 .48398 L p .46285 .48049 L .784 g
F P
0 g
s
.46285 .48049 m .4641 .46981 L .46042 .48186 L .784 g
F
.48019 .4718 m .47858 .47164 L p .48377 .47017 L .201 g
F P
0 g
s
.48431 .46841 m .4896 .46852 L .47858 .47164 L .201 g
F
.43531 .4669 m .48753 .46846 L .43485 .46742 L F
.48753 .46846 m .4896 .46852 L .48749 .46847 L F
.48753 .46846 m .48749 .46847 L .43485 .46742 L F
.42676 .46664 m .44734 .45463 L .4896 .46852 L p F P
0 g
s
.4746 .46583 m .4641 .46981 L .47025 .47633 L p .762 g
F P
0 g
s
.47025 .47633 m .47093 .47704 L p .47132 .47584 L .762 g
F P
0 g
s
.47132 .47584 m .4746 .46583 L .47025 .47633 L .762 g
F
.48019 .4718 m .4746 .46583 L p .47132 .47584 L F P
0 g
s
.47093 .47704 m .48019 .4718 L p .47132 .47584 L .762 g
F P
0 g
s
.4896 .46852 m .48019 .4718 L p .48377 .47017 L .201 g
F P
0 g
s
.43485 .46742 m .42676 .46664 L p .43531 .4669 L .201 g
F P
0 g
s
.45473 .4915 m .44643 .48287 L p .44954 .49765 L .802 g
F P
0 g
s
.45 .49985 m .45473 .4915 L .44954 .49765 L .802 g
F
.39949 .50179 m .38813 .505 L p .40016 .50094 L .177 g
F P
0 g
s
.45025 .50104 m .45538 .49217 L p .45 .49985 L .802 g
F P
0 g
s
.34608 .67614 m .35006 .70204 L .40627 .74494 L p .647 g
F P
0 g
s
.41244 .7639 m .40627 .74494 L .35006 .70204 L p .474 g
F P
0 g
s
.40627 .74494 m .41244 .7639 L .49056 .75344 L p .281 g
F P
0 g
s
.49056 .75344 m .48871 .73647 L .40627 .74494 L p .281 g
F P
0 g
s
.34608 .67614 m .34774 .64405 L .35462 .57935 L p .002 g
F P
0 g
s
.48871 .73647 m .49056 .75344 L .55312 .68765 L p .008 g
F P
0 g
s
.55494 .67554 m .48871 .73647 L p .53901 .69835 L .008 g
F P
0 g
s
.49056 .75344 m .49341 .75947 L .5504 .69131 L p F P
s
.5504 .69131 m .55312 .68765 L .52511 .71711 L p F P
s
.52511 .71711 m .49056 .75344 L p .52256 .72021 L F P
s
.5504 .69131 m .52511 .71711 L .52256 .72021 L F
.4971 .75365 m .51457 .72995 L p .4964 .75536 L .919 g
F P
0 g
s
.51457 .72995 m .54695 .686 L p .51773 .7261 L .919 g
F P
0 g
s
.51773 .7261 m .4964 .75536 L .51457 .72995 L .919 g
F
.49341 .75947 m .49384 .75879 L p .4964 .75536 L F P
0 g
s
.49384 .75879 m .4971 .75365 L p .4964 .75536 L .919 g
F P
0 g
s
.55312 .68765 m .55466 .6774 L p .53901 .69835 L .008 g
F P
0 g
s
.55466 .6774 m .55494 .67554 L p .53901 .69835 L .008 g
F P
0 g
s
.54932 .54116 m .5522 .57145 L .56283 .52297 L p .059 g
F P
0 g
s
.5522 .57145 m .55432 .60209 L .56575 .53776 L p .051 g
F P
0 g
s
.56575 .53776 m .56283 .52297 L .5522 .57145 L p .051 g
F P
0 g
s
.55432 .60209 m .55554 .63099 L .56735 .55168 L p .038 g
F P
0 g
s
.56735 .55168 m .56575 .53776 L .55432 .60209 L p .038 g
F P
0 g
s
.35462 .57935 m .35348 .60183 L .34608 .67614 L p .002 g
F P
0 g
s
.35006 .70204 m .34608 .67614 L .35348 .60183 L p .031 g
F P
0 g
s
.54588 .51316 m .54932 .54116 L .55845 .5096 L p .063 g
F P
0 g
s
.55818 .50861 m .54588 .51316 L .55845 .5096 L .063 g
F
.56283 .52297 m .5588 .50838 L .54932 .54116 L p .059 g
F P
0 g
s
.54209 .48919 m .54588 .51316 L .55342 .49625 L p .06 g
F P
0 g
s
.55337 .49612 m .54209 .48919 L .55342 .49625 L .06 g
F
.55296 .49453 m .54209 .48919 L .55345 .49617 L F
.5588 .50838 m .55397 .49502 L .54588 .51316 L p .063 g
F P
0 g
s
.54705 .49963 m .54541 .49463 L .54558 .4949 L p .571 g
F P
0 g
s
.5459 .49542 m .54601 .49559 L p .5472 .49985 L .571 g
F P
0 g
s
.5675 .56367 m .56735 .55168 L .55554 .63099 L p .016 g
F P
0 g
s
.55554 .63099 m .55576 .65611 L .5675 .56367 L p .016 g
F P
0 g
s
.55952 .5796 m .55468 .57674 L .54054 .51331 L p .833 g
F P
0 g
s
.54054 .51331 m .54328 .51415 L .54348 .51495 L p .833 g
F P
0 g
s
.54348 .51495 m .55952 .5796 L p .54054 .51331 L .833 g
F P
0 g
s
.53752 .51116 m .54054 .51331 L .54074 .51423 L p .81 g
F P
0 g
s
.54074 .51423 m .55468 .57674 L p .53752 .51116 L .81 g
F P
0 g
s
.53445 .50791 m .53752 .51116 L .53773 .5122 L p .785 g
F P
0 g
s
.53773 .5122 m .54927 .56991 L p .53445 .50791 L .785 g
F P
0 g
s
.53154 .50387 m .53445 .50791 L .53466 .50906 L p .76 g
F P
0 g
s
.53466 .50906 m .54371 .55974 L p .53154 .50387 L .76 g
F P
0 g
s
.52897 .49941 m .53154 .50387 L .53174 .50512 L p .735 g
F P
0 g
s
.53174 .50512 m .53839 .54717 L p .52897 .49941 L .735 g
F P
0 g
s
.52529 .49083 m .52686 .49494 L .52977 .51954 L p .685 g
F P
0 g
s
.52686 .49494 m .52529 .49083 L .52566 .49191 L p .682 g
F P
0 g
s
.52915 .50073 m .5296 .50398 L p .52686 .49494 L .71 g
F P
0 g
s
.52686 .49494 m .5296 .50398 L .52717 .49667 L .71 g
F
.54371 .55974 m .53839 .54717 L .53154 .50387 L p .76 g
F P
0 g
s
.53839 .54717 m .53366 .53335 L .52897 .49941 L p .735 g
F P
0 g
s
.53366 .53335 m .52977 .51954 L .52702 .49628 L p .71 g
F P
0 g
s
.52702 .49628 m .52686 .49494 L p .52717 .49667 L .71 g
F P
0 g
s
.52717 .49667 m .53366 .53335 L .52702 .49628 L .71 g
F
.52426 .4874 m .52529 .49083 L .52541 .49208 L p .659 g
F P
0 g
s
.52541 .49208 m .52686 .5069 L p .52426 .4874 L .659 g
F P
0 g
s
.5237 .48488 m .52426 .4874 L .52495 .49644 L p .627 g
F P
0 g
s
.52426 .4874 m .5237 .48488 L .52386 .48578 L p .702 g
F P
0 g
s
.52686 .5069 m .52495 .49644 L .52426 .4874 L p .659 g
F P
0 g
s
.52495 .49644 m .52391 .48881 L .5237 .48488 L p .627 g
F P
0 g
s
.52501 .49214 m .52365 .48516 L .52383 .48648 L p .115 g
F P
0 g
s
.52427 .48803 m .52501 .49214 L p .52443 .48847 L .702 g
F P
0 g
s
.52365 .48516 m .52501 .49214 L .5237 .48488 L p .718 g
F P
0 g
s
.5296 .50398 m .53366 .53335 L p .52717 .49667 L .71 g
F P
0 g
s
.52977 .51954 m .52686 .5069 L .52535 .49147 L p .685 g
F P
0 g
s
.52535 .49147 m .52529 .49083 L p .52542 .49167 L .685 g
F P
0 g
s
.52542 .49167 m .52977 .51954 L .52535 .49147 L .685 g
F
.52859 .50381 m .52426 .4874 L p .52501 .49214 L .702 g
F P
0 g
s
.52859 .50381 m .52501 .49214 L .52647 .4974 L p .059 g
F P
0 g
s
.52383 .48648 m .52647 .4974 L .52501 .49214 L p .115 g
F P
0 g
s
.52402 .48735 m .52421 .48811 L .52409 .48753 L .213 g
F
.52647 .4974 m .52427 .48831 L p .52421 .48811 L F P
0 g
s
.52427 .48831 m .52409 .48753 L p .52421 .48811 L .213 g
F P
0 g
s
.52383 .48648 m .52396 .4871 L p .52402 .48735 L .213 g
F P
0 g
s
.52409 .48753 m .52383 .48648 L p .52402 .48735 L .213 g
F P
0 g
s
.52386 .48578 m .52427 .48803 L p .52426 .4874 L .702 g
F P
0 g
s
.52443 .48847 m .52426 .4874 L .52427 .48803 L .702 g
F
.52493 .48996 m .52562 .49254 L p .52551 .49169 L .69 g
F P
0 g
s
.52562 .49254 m .5283 .50272 L p .52596 .49345 L .69 g
F P
0 g
s
.52835 .50286 m .52596 .49345 L .5283 .50272 L .69 g
F
.52859 .50381 m .53516 .51951 L .52529 .49083 L p F P
0 g
s
.53516 .51951 m .52859 .50381 L .53337 .51539 L p .055 g
F P
0 g
s
.53337 .51539 m .527 .49879 L p .52748 .49971 L .261 g
F P
0 g
s
.527 .49879 m .52647 .4974 L .52677 .49809 L p .261 g
F P
0 g
s
.52677 .49809 m .52748 .49971 L p .527 .49879 L .261 g
F P
0 g
s
.5283 .50272 m .52859 .50381 L p .52835 .50286 L .69 g
F P
0 g
s
.52596 .49345 m .52551 .49169 L .52562 .49254 L .69 g
F
.52566 .49191 m .53516 .51951 L p .52686 .49494 L .682 g
F P
0 g
s
.52686 .49494 m .52897 .49941 L .52915 .50073 L p .71 g
F P
0 g
s
.52529 .49083 m .52426 .4874 L .52493 .48996 L p .69 g
F P
0 g
s
.52551 .49169 m .52529 .49083 L .52493 .48996 L .69 g
F
.52897 .49941 m .52686 .49494 L .52732 .49602 L p .675 g
F P
0 g
s
.55468 .57674 m .54927 .56991 L .53752 .51116 L p .81 g
F P
0 g
s
.54927 .56991 m .54371 .55974 L .53445 .50791 L p .785 g
F P
0 g
s
.52732 .49602 m .54513 .5381 L p .52897 .49941 L .675 g
F P
0 g
s
.53154 .50387 m .52897 .49941 L .5295 .50046 L p .67 g
F P
0 g
s
.56617 .57277 m .56345 .57823 L .54617 .51588 L p .842 g
F P
0 g
s
.56345 .57823 m .55952 .5796 L .54328 .51415 L p .846 g
F P
0 g
s
.54328 .51415 m .54553 .51359 L .56345 .57823 L p .846 g
F P
0 g
s
.5295 .50046 m .55849 .55796 L p .53154 .50387 L .67 g
F P
0 g
s
.53445 .50791 m .53154 .50387 L .53212 .50485 L p .667 g
F P
0 g
s
.54626 .51582 m .56617 .57277 L .54617 .51588 L .842 g
F
.54576 .51423 m .56617 .57277 L .54572 .51428 L F
.56617 .57277 m .5675 .56367 L .56115 .61365 L p .618 g
F P
0 g
s
.56115 .61365 m .55576 .65611 L p .56072 .61643 L .618 g
F P
0 g
s
.56617 .57277 m .56115 .61365 L .56072 .61643 L .618 g
F
.55576 .65611 m .55494 .67554 L .56617 .57277 L p F P
0 g
s
.55494 .67554 m .55312 .68765 L .55852 .63048 L p .807 g
F P
0 g
s
.55852 .63048 m .56345 .57823 L p .55934 .62521 L .807 g
F P
0 g
s
.55934 .62521 m .55494 .67554 L .55852 .63048 L .807 g
F
.5675 .56367 m .56617 .57277 L .54772 .51357 L p .81 g
F P
0 g
s
.54772 .51357 m .54712 .51165 L p .54781 .5134 L .81 g
F P
0 g
s
.54781 .5134 m .5675 .56367 L .54772 .51357 L .81 g
F
.54376 .51693 m .54523 .51858 L p .54465 .51573 L .664 g
F P
0 g
s
.56735 .55168 m .5675 .56367 L .54917 .51195 L p .744 g
F P
0 g
s
.54917 .51195 m .5485 .51008 L p .54924 .51172 L .744 g
F P
0 g
s
.54924 .51172 m .56735 .55168 L .54917 .51195 L .744 g
F
.54523 .51858 m .54655 .52006 L p .54592 .51719 L .664 g
F P
0 g
s
.54853 .50992 m .56735 .55168 L .5485 .51008 L .744 g
F
.54812 .50891 m .56735 .55168 L .54812 .509 L F
.56575 .53776 m .56735 .55168 L .54998 .50942 L p .657 g
F P
0 g
s
.54998 .50942 m .54791 .50438 L p .55015 .50857 L .657 g
F P
0 g
s
.55015 .50857 m .56575 .53776 L .54998 .50942 L .657 g
F
.54655 .52006 m .54768 .52133 L p .54705 .51849 L .664 g
F P
0 g
s
.54794 .5085 m .54791 .50438 L .54808 .5048 L p .744 g
F P
0 g
s
.54808 .5048 m .56735 .55168 L p .54794 .5085 L .744 g
F P
0 g
s
.54712 .51165 m .54794 .5085 L .5675 .56367 L p .81 g
F P
0 g
s
.54794 .5085 m .54712 .51165 L .5478 .51214 L p .67 g
F P
0 g
s
.5485 .51008 m .54812 .509 L p .54853 .50992 L .744 g
F P
0 g
s
.54812 .509 m .54794 .5085 L p .54812 .50891 L .744 g
F P
0 g
s
.5478 .51214 m .55148 .5148 L p .54794 .5085 L .67 g
F P
0 g
s
.54553 .51359 m .54712 .51165 L .54731 .51224 L p .842 g
F P
0 g
s
.54731 .51224 m .56617 .57277 L p .54553 .51359 L .842 g
F P
0 g
s
.54553 .51359 m .54328 .51415 L .54393 .51479 L p .665 g
F P
0 g
s
.54617 .51588 m .54572 .51428 L p .54626 .51582 L .842 g
F P
0 g
s
.54572 .51428 m .54553 .51359 L p .54576 .51423 L .842 g
F P
0 g
s
.54393 .51479 m .54707 .51786 L p .54553 .51359 L .665 g
F P
0 g
s
.54768 .52133 m .63023 .61408 L p .54802 .5196 L .664 g
F P
0 g
s
.54802 .5196 m .54705 .51849 L .54768 .52133 L .664 g
F
.54705 .51849 m .54592 .51719 L .54655 .52006 L F
.54592 .51719 m .54465 .51573 L .54523 .51858 L F
.53212 .50485 m .57473 .57725 L p .53445 .50791 L .667 g
F P
0 g
s
.53752 .51116 m .53445 .50791 L .53507 .50881 L p .664 g
F P
0 g
s
.53507 .50881 m .59295 .59409 L p .53752 .51116 L .664 g
F P
0 g
s
.54054 .51331 m .53752 .51116 L .53816 .51198 L p .663 g
F P
0 g
s
.53816 .51198 m .5428 .51794 L p .54054 .51331 L .663 g
F P
0 g
s
.5428 .51794 m .61191 .60678 L p .54367 .51741 L .663 g
F P
0 g
s
.54367 .51741 m .54054 .51331 L .5428 .51794 L .663 g
F
.54328 .51415 m .54054 .51331 L .54376 .51693 L p .664 g
F P
0 g
s
.54465 .51573 m .54328 .51415 L .54376 .51693 L .664 g
F
.56283 .52297 m .56575 .53776 L .54893 .50347 L p .571 g
F P
0 g
s
.54893 .50347 m .54705 .49963 L p .54894 .50243 L .571 g
F P
0 g
s
.54894 .50243 m .56283 .52297 L .54893 .50347 L .571 g
F
.54707 .51786 m .54872 .51948 L p .54749 .51556 L .665 g
F P
0 g
s
.54791 .50438 m .54705 .49963 L .54893 .50347 L p .657 g
F P
0 g
s
.54893 .50347 m .56575 .53776 L p .54909 .50659 L .657 g
F P
0 g
s
.54791 .50438 m .54893 .50347 L .54909 .50659 L .657 g
F
.54872 .51948 m .54983 .52057 L p .54875 .51683 L .665 g
F P
0 g
s
.54983 .52057 m .64653 .61525 L p .54968 .51777 L .665 g
F P
0 g
s
.54968 .51777 m .54875 .51683 L .54983 .52057 L .665 g
F
.54875 .51683 m .54749 .51556 L .54872 .51948 L F
.54749 .51556 m .54553 .51359 L .54707 .51786 L F
.54712 .51165 m .54553 .51359 L .5475 .51526 L p .667 g
F P
0 g
s
.5475 .51526 m .65959 .61019 L p .5478 .51224 L .667 g
F P
0 g
s
.5478 .51224 m .54712 .51165 L .5475 .51526 L .667 g
F
.5464 .49624 m .56024 .51875 L p .54752 .50032 L .571 g
F P
0 g
s
.56024 .51875 m .56151 .52083 L p .56035 .51912 L .571 g
F P
0 g
s
.5472 .49986 m .56024 .51875 L .56035 .51912 L .571 g
F
.54705 .49963 m .5472 .49985 L .5472 .49986 L F
.5472 .49985 m .56024 .51875 L .5472 .49986 L F
.54791 .50438 m .54794 .5085 L .55011 .5098 L p .674 g
F P
0 g
s
.54705 .49963 m .56151 .52083 L .5616 .52116 L .571 g
F
.55845 .5096 m .5588 .50838 L p .55818 .50861 L .063 g
F P
0 g
s
.5588 .50838 m .56283 .52297 L .54541 .49463 L p .513 g
F P
0 g
s
.55011 .5098 m .67262 .58364 L p .54866 .50486 L .674 g
F P
0 g
s
.54866 .50486 m .54791 .50438 L .55011 .5098 L .674 g
F
.56151 .52083 m .56283 .52297 L p .5616 .52116 L .571 g
F P
0 g
s
.55148 .5148 m .66848 .59934 L p .55023 .51022 L .67 g
F P
0 g
s
.55023 .51022 m .54794 .5085 L .55148 .5148 L .67 g
F
.54601 .49559 m .5464 .49624 L p .54726 .49995 L .571 g
F P
0 g
s
.54726 .49995 m .5464 .49624 L .54752 .50032 L .571 g
F
.5472 .49985 m .54601 .49559 L .54726 .49995 L F
.66848 .59934 m .67262 .58364 L .55011 .5098 L p .67 g
F P
0 g
s
.55011 .5098 m .54794 .5085 L p .55023 .51022 L .67 g
F P
0 g
s
.66848 .59934 m .55011 .5098 L .55023 .51022 L .67 g
F
.67262 .58364 m .67178 .56438 L .54862 .50472 L p .674 g
F P
0 g
s
.54862 .50472 m .54791 .50438 L p .54866 .50486 L .674 g
F P
0 g
s
.67262 .58364 m .54862 .50472 L .54866 .50486 L .674 g
F
.54558 .4949 m .5459 .49542 L p .54705 .49963 L .571 g
F P
0 g
s
.54705 .49963 m .5459 .49542 L .5472 .49985 L .571 g
F
.54705 .49963 m .54791 .50438 L .54862 .50472 L p .679 g
F P
0 g
s
.54331 .48995 m .54362 .49032 L p .54541 .49463 L .513 g
F P
0 g
s
.54385 .49059 m .55702 .50627 L p .54566 .49487 L .513 g
F P
0 g
s
.54541 .49463 m .55702 .50627 L .55719 .50672 L .513 g
F
.55342 .49625 m .55345 .49617 L p .55337 .49612 L .06 g
F P
0 g
s
.55345 .49617 m .55397 .49502 L p .55296 .49453 L .06 g
F P
0 g
s
.55397 .49502 m .5588 .50838 L .54314 .48975 L p .481 g
F P
0 g
s
.67178 .56438 m .66611 .54308 L .54779 .4999 L p .679 g
F P
0 g
s
.54779 .4999 m .54705 .49963 L p .54785 .50005 L .679 g
F P
0 g
s
.67178 .56438 m .54779 .4999 L .54785 .50005 L .679 g
F
.54362 .49032 m .54385 .49059 L p .54555 .49477 L .513 g
F P
0 g
s
.54555 .49477 m .54385 .49059 L .54566 .49487 L .513 g
F
.54541 .49463 m .54362 .49032 L .54555 .49477 L F
.54862 .50472 m .55022 .5055 L p .54705 .49963 L .679 g
F P
0 g
s
.55702 .50627 m .5588 .50838 L p .55719 .50672 L .513 g
F P
0 g
s
.55022 .5055 m .67178 .56438 L p .54785 .50005 L .679 g
F P
0 g
s
.54785 .50005 m .54705 .49963 L .55022 .5055 L .679 g
F
.54541 .49463 m .54705 .49963 L .54779 .4999 L p .683 g
F P
0 g
s
.54779 .4999 m .66611 .54308 L p .54541 .49463 L .683 g
F P
0 g
s
.54541 .49463 m .54314 .48975 L .54331 .48995 L p .513 g
F P
0 g
s
.46881 .46109 m .47581 .44383 L .465 .44758 L .846 g
F
.46702 .44813 m .44734 .45463 L .44392 .4549 L p 0 g
F P
s
.44392 .4549 m .44311 .45496 L p .44666 .45395 L F P
s
.44666 .45395 m .46702 .44813 L .44392 .4549 L F
.46881 .46109 m .48258 .44462 L .47581 .44383 L p .846 g
F P
0 g
s
.47581 .44383 m .46354 .44239 L p .465 .44758 L .846 g
F P
0 g
s
.48258 .44462 m .46881 .46109 L .50728 .46687 L p .651 g
F P
0 g
s
.35006 .70204 m .35959 .71959 L .41244 .7639 L p .474 g
F P
0 g
s
.41244 .7639 m .42203 .77142 L .49341 .75947 L p .074 g
F P
0 g
s
.49056 .75344 m .41244 .7639 L p .47832 .76029 L .074 g
F P
0 g
s
.49341 .75947 m .49254 .75762 L p .47832 .76029 L .074 g
F P
0 g
s
.49254 .75762 m .49056 .75344 L p .47832 .76029 L .074 g
F P
0 g
s
.43448 .76643 m .4971 .75365 L p .43349 .76871 L .707 g
F P
0 g
s
.42203 .77142 m .42467 .77036 L p .43349 .76871 L .707 g
F P
0 g
s
.42467 .77036 m .43448 .76643 L p .43349 .76871 L .707 g
F P
0 g
s
.42203 .77142 m .41244 .7639 L .35959 .71959 L p .118 g
F P
0 g
s
.50728 .46687 m .51137 .45041 L .48258 .44462 L p .651 g
F P
0 g
s
.51137 .45041 m .50728 .46687 L .53819 .47061 L p .333 g
F P
0 g
s
.54209 .48919 m .53819 .47061 L .50728 .46687 L p .432 g
F P
0 g
s
.35348 .60183 m .35796 .62021 L .35006 .70204 L p .031 g
F P
0 g
s
.35959 .71959 m .35006 .70204 L .35796 .62021 L p .056 g
F P
0 g
s
.53819 .47061 m .54209 .48919 L .54797 .48433 L p .05 g
F P
0 g
s
.55397 .49502 m .54866 .48376 L .54209 .48919 L p .06 g
F P
0 g
s
.54314 .48975 m .54541 .49463 L .54619 .49481 L p .688 g
F P
0 g
s
.54057 .48548 m .55187 .49353 L p .54314 .48975 L .481 g
F P
0 g
s
.55187 .49353 m .55397 .49502 L p .55213 .49413 L .481 g
F P
0 g
s
.54314 .48975 m .55187 .49353 L .55213 .49413 L .481 g
F
.54797 .48433 m .54866 .48376 L p .54667 .48126 L .05 g
F P
0 g
s
.54667 .48126 m .53819 .47061 L .54797 .48433 L .05 g
F
.54866 .48376 m .55397 .49502 L .54041 .48536 L p .473 g
F P
0 g
s
.54619 .49481 m .65608 .52133 L p .54314 .48975 L .688 g
F P
0 g
s
.54314 .48975 m .54041 .48536 L .54057 .48548 L p .481 g
F P
0 g
s
.44311 .45496 m .46354 .44239 L .46702 .44813 L p F P
s
.56345 .57823 m .56617 .57277 L .55494 .67554 L p .807 g
F P
0 g
s
.62617 .48255 m .64244 .50069 L .74806 .48445 L p .663 g
F P
0 g
s
.74806 .48445 m .7173 .45952 L .62617 .48255 L p .663 g
F P
0 g
s
.77408 .51395 m .74806 .48445 L .64244 .50069 L p .643 g
F P
0 g
s
.7173 .45952 m .74806 .48445 L .82502 .44809 L p .642 g
F P
0 g
s
.74806 .48445 m .77408 .51395 L .86078 .47921 L p .605 g
F P
0 g
s
.86078 .47921 m .82502 .44809 L .74806 .48445 L p .605 g
F P
0 g
s
.64244 .50069 m .65608 .52133 L .77408 .51395 L p .643 g
F P
0 g
s
.79358 .54611 m .77408 .51395 L .65608 .52133 L p .623 g
F P
0 g
s
.77408 .51395 m .79358 .54611 L .88792 .51476 L p .564 g
F P
0 g
s
.88792 .51476 m .86078 .47921 L .77408 .51395 L p .564 g
F P
0 g
s
.48199 .43771 m .46354 .44239 L .48258 .44462 L p .716 g
F P
0 g
s
.48258 .44462 m .49508 .43712 L .48199 .43771 L p .716 g
F P
0 g
s
.49508 .43712 m .48258 .44462 L .51137 .45041 L p .55 g
F P
0 g
s
.60837 .46803 m .62617 .48255 L .7173 .45952 L p .683 g
F P
0 g
s
.7173 .45952 m .68383 .4406 L .60837 .46803 L p .683 g
F P
0 g
s
.68383 .4406 m .7173 .45952 L .78313 .42334 L p .679 g
F P
0 g
s
.82502 .44809 m .78313 .42334 L .7173 .45952 L p .642 g
F P
0 g
s
.65608 .52133 m .66611 .54308 L .79358 .54611 L p .623 g
F P
0 g
s
.80511 .57874 m .79358 .54611 L .66611 .54308 L p .602 g
F P
0 g
s
.79358 .54611 m .80511 .57874 L .90433 .55236 L p .519 g
F P
0 g
s
.90433 .55236 m .88792 .51476 L .79358 .54611 L p .519 g
F P
0 g
s
.51137 .45041 m .51508 .44244 L .49508 .43712 L p .55 g
F P
0 g
s
.51508 .44244 m .51137 .45041 L .53443 .45828 L p .206 g
F P
0 g
s
.53819 .47061 m .53443 .45828 L .51137 .45041 L p .333 g
F P
0 g
s
.35959 .71959 m .37419 .72713 L .42203 .77142 L p .118 g
F P
0 g
s
.43448 .76643 m .42203 .77142 L .37419 .72713 L p .441 g
F P
0 g
s
.4971 .75365 m .49341 .75947 L .42203 .77142 L p .707 g
F P
0 g
s
.54695 .686 m .5504 .69131 L .49341 .75947 L p .919 g
F P
0 g
s
.35796 .62021 m .36786 .63295 L .35959 .71959 L p .056 g
F P
0 g
s
.37419 .72713 m .35959 .71959 L .36786 .63295 L p .191 g
F P
0 g
s
.78313 .42334 m .82502 .44809 L .84318 .40817 L p .632 g
F P
0 g
s
.82502 .44809 m .86078 .47921 L .88205 .43443 L p .554 g
F P
0 g
s
.88205 .43443 m .84318 .40817 L .82502 .44809 L p .554 g
F P
0 g
s
.78313 .42334 m .73786 .40631 L .68383 .4406 L p .679 g
F P
0 g
s
.73786 .40631 m .78313 .42334 L .79789 .38925 L p .7 g
F P
0 g
s
.84318 .40817 m .79789 .38925 L .78313 .42334 L p .632 g
F P
0 g
s
.86078 .47921 m .88792 .51476 L .91164 .46645 L p .452 g
F P
0 g
s
.91164 .46645 m .88205 .43443 L .86078 .47921 L p .452 g
F P
0 g
s
.59023 .45793 m .60837 .46803 L .68383 .4406 L p .703 g
F P
0 g
s
.68383 .4406 m .64977 .42863 L .59023 .45793 L p .703 g
F P
0 g
s
.64977 .42863 m .68383 .4406 L .73786 .40631 L p .715 g
F P
0 g
s
.53443 .45828 m .53819 .47061 L .54325 .47525 L p .334 g
F P
0 g
s
.54866 .48376 m .54325 .47525 L .53819 .47061 L p .05 g
F P
0 g
s
.66611 .54308 m .67178 .56438 L .80511 .57874 L p .602 g
F P
0 g
s
.80766 .60947 m .80511 .57874 L .67178 .56438 L p .581 g
F P
0 g
s
.80511 .57874 m .80766 .60947 L .90852 .58925 L p .466 g
F P
0 g
s
.90852 .58925 m .90433 .55236 L .80511 .57874 L p .466 g
F P
0 g
s
.55312 .68765 m .5504 .69131 L .55952 .5796 L p .895 g
F P
0 g
s
.55952 .5796 m .56345 .57823 L .55312 .68765 L p .895 g
F P
0 g
s
.73786 .40631 m .69205 .39769 L .64977 .42863 L p .715 g
F P
0 g
s
.69205 .39769 m .73786 .40631 L .74926 .37861 L p .761 g
F P
0 g
s
.79789 .38925 m .74926 .37861 L .73786 .40631 L p .7 g
F P
0 g
s
.48462 .44701 m .46702 .44813 L .46354 .44239 L p .019 g
F P
0 g
s
.46354 .44239 m .48199 .43771 L .48462 .44701 L p .019 g
F P
0 g
s
.88792 .51476 m .90433 .55236 L .92954 .50207 L p .301 g
F P
0 g
s
.92954 .50207 m .91164 .46645 L .88792 .51476 L p .301 g
F P
0 g
s
.5729 .45257 m .59023 .45793 L .64977 .42863 L p .722 g
F P
0 g
s
.64977 .42863 m .61722 .4239 L .5729 .45257 L p .722 g
F P
0 g
s
.61722 .4239 m .64977 .42863 L .69205 .39769 L p .752 g
F P
0 g
s
.69205 .39769 m .64846 .39743 L .61722 .4239 L p .752 g
F P
0 g
s
.64846 .39743 m .69205 .39769 L .70038 .37645 L p .819 g
F P
0 g
s
.74926 .37861 m .70038 .37645 L .69205 .39769 L p .761 g
F P
0 g
s
.65608 .52133 m .64244 .50069 L .54314 .48975 L p .688 g
F P
0 g
s
.66611 .54308 m .65608 .52133 L .54541 .49463 L p .683 g
F P
0 g
s
.49744 .44018 m .48199 .43771 L .49508 .43712 L p .01 g
F P
0 g
s
.5056 .43796 m .49508 .43712 L .51508 .44244 L p .316 g
F P
0 g
s
.49508 .43712 m .5056 .43796 L .49744 .44018 L p .01 g
F P
0 g
s
.67178 .56438 m .67262 .58364 L .80766 .60947 L p .581 g
F P
0 g
s
.80081 .6359 m .80766 .60947 L .67262 .58364 L p .559 g
F P
0 g
s
.80766 .60947 m .80081 .6359 L .89976 .62257 L p .397 g
F P
0 g
s
.89976 .62257 m .90852 .58925 L .80766 .60947 L p .397 g
F P
0 g
s
.54041 .48536 m .54314 .48975 L .64244 .50069 L p .693 g
F P
0 g
s
.64244 .50069 m .62617 .48255 L .54041 .48536 L p .693 g
F P
0 g
s
.36786 .63295 m .38254 .63894 L .37419 .72713 L p .191 g
F P
0 g
s
.39293 .72377 m .37419 .72713 L .38254 .63894 L p .338 g
F P
0 g
s
.37419 .72713 m .39293 .72377 L .43448 .76643 L p .441 g
F P
0 g
s
.51508 .44244 m .51819 .44242 L .5056 .43796 L p .316 g
F P
0 g
s
.51819 .44242 m .51508 .44244 L .53105 .45243 L p .199 g
F P
0 g
s
.53443 .45828 m .53105 .45243 L .51508 .44244 L p .206 g
F P
0 g
s
.53105 .45243 m .53443 .45828 L .53809 .46984 L p .427 g
F P
0 g
s
.54325 .47525 m .53809 .46984 L .53443 .45828 L p .334 g
F P
0 g
s
.90433 .55236 m .90852 .58925 L .93404 .53862 L p .055 g
F P
0 g
s
.93404 .53862 m .92954 .50207 L .90433 .55236 L p .055 g
F P
0 g
s
.54325 .47525 m .54866 .48376 L .53766 .48179 L p .479 g
F P
0 g
s
.53766 .48179 m .53742 .48175 L p .53755 .48159 L .479 g
F P
0 g
s
.53755 .48159 m .54325 .47525 L .53766 .48179 L .479 g
F
.53809 .46984 m .54325 .47525 L .53464 .479 L p .504 g
F P
0 g
s
.53464 .479 m .53438 .47912 L p .53449 .47882 L .504 g
F P
0 g
s
.53449 .47882 m .53809 .46984 L .53464 .479 L .504 g
F
.52495 .47455 m .52685 .47068 L .52568 .47661 L p .607 g
F P
0 g
s
.52568 .47661 m .52529 .47855 L p .52522 .47765 L .607 g
F P
0 g
s
.52522 .47765 m .52495 .47455 L .52568 .47661 L .607 g
F
.52373 .48095 m .52391 .47858 L p .52402 .47902 L .634 g
F P
0 g
s
.52426 .47998 m .5237 .48141 L p .52408 .47926 L .634 g
F P
0 g
s
.52685 .47068 m .52951 .46822 L p .527 .47355 L .582 g
F P
0 g
s
.52685 .47668 m .52685 .47068 L .52716 .47646 L .582 g
F
.52685 .47068 m .52606 .45748 L p .52953 .46756 L .566 g
F P
0 g
s
.5297 .46805 m .52879 .46889 L p .52953 .46756 L .566 g
F P
0 g
s
.52879 .46889 m .52685 .47068 L p .52953 .46756 L .566 g
F P
0 g
s
.52821 .45257 m .53105 .45243 L .53349 .46755 L p .504 g
F P
0 g
s
.53809 .46984 m .53349 .46755 L .53105 .45243 L p .427 g
F P
0 g
s
.52606 .45748 m .52821 .45257 L .5297 .46805 L p .566 g
F P
0 g
s
.53349 .46755 m .5297 .46805 L .52821 .45257 L p .504 g
F P
0 g
s
.52529 .47855 m .52685 .47068 L p .52685 .47668 L .582 g
F P
0 g
s
.52685 .47747 m .52529 .47855 L p .52685 .47668 L .582 g
F P
0 g
s
.52529 .47855 m .52598 .47731 L p .52481 .47913 L .708 g
F P
0 g
s
.52426 .47998 m .52495 .47455 L p .52522 .47765 L .607 g
F P
0 g
s
.52529 .47855 m .52426 .47998 L p .52522 .47765 L .607 g
F P
0 g
s
.5246 .47904 m .52397 .48069 L .52469 .47885 L .704 g
F
.52397 .48069 m .5237 .48141 L .52403 .48054 L F
.52397 .48069 m .52403 .48054 L .52469 .47885 L F
.52426 .47998 m .52529 .47855 L p .52481 .47913 L .708 g
F P
0 g
s
.52855 .46847 m .53104 .46326 L p .52516 .47534 L .746 g
F P
0 g
s
.53104 .46326 m .53241 .46039 L p .52825 .46897 L .746 g
F P
0 g
s
.52825 .46897 m .52516 .47534 L .53104 .46326 L .746 g
F
.5309 .46349 m .52516 .47534 L .53241 .46039 L F
.52518 .4753 m .52855 .46847 L p .52516 .47534 L F P
0 g
s
.52526 .47512 m .52502 .47563 L .52478 .47664 L p .704 g
F P
0 g
s
.52495 .47455 m .52426 .47998 L p .52408 .47926 L .634 g
F P
0 g
s
.52855 .46847 m .52526 .47512 L p .5237 .48141 L .704 g
F P
0 g
s
.5237 .48141 m .5239 .48053 L p .5236 .48195 L .698 g
F P
0 g
s
.52478 .47664 m .5237 .48141 L p .52526 .47512 L .704 g
F P
0 g
s
.5239 .48053 m .52502 .47563 L p .52386 .48079 L .698 g
F P
0 g
s
.52386 .48079 m .5236 .48195 L .5239 .48053 L .698 g
F
.52391 .47858 m .52452 .47621 L p .52408 .47926 L .634 g
F P
0 g
s
.52452 .47621 m .52495 .47455 L p .52408 .47926 L .634 g
F P
0 g
s
.52408 .47926 m .52373 .48095 L .52402 .47902 L .634 g
F
.52461 .46528 m .52606 .45748 L .52685 .47068 L p .612 g
F P
0 g
s
.52685 .47068 m .52514 .47417 L p .52529 .47353 L .612 g
F P
0 g
s
.52685 .47068 m .52494 .47417 L .52595 .46851 L .612 g
F
.52675 .47036 m .52525 .47515 L p .53324 .45866 L .746 g
F P
0 g
s
.5251 .47546 m .52646 .47089 L .52502 .47563 L p .746 g
F P
0 g
s
.52502 .47563 m .52518 .4753 L p .52516 .47534 L .746 g
F P
0 g
s
.5237 .48141 m .52373 .48095 L p .52408 .47926 L .634 g
F P
0 g
s
.52348 .48249 m .5237 .48141 L p .5236 .48195 L .698 g
F P
0 g
s
.52348 .48249 m .52351 .48169 L p .52353 .48166 L .671 g
F P
0 g
s
.5237 .48141 m .52348 .48248 L p .52353 .48166 L .671 g
F P
0 g
s
.52348 .48248 m .52348 .48249 L p .52353 .48166 L .671 g
F P
0 g
s
.52365 .4809 m .52348 .48249 L p .52349 .48247 L .698 g
F P
0 g
s
.52502 .47563 m .52365 .4809 L p .52349 .48247 L .698 g
F P
0 g
s
.52391 .47858 m .5237 .48141 L p .52355 .48163 L .671 g
F P
0 g
s
.52383 .47965 m .52365 .4809 L p .52532 .47496 L .709 g
F P
0 g
s
.52383 .47965 m .52396 .47896 L .52353 .48229 L p .061 g
F P
0 g
s
.52353 .48229 m .52345 .48291 L .52353 .48221 L p .061 g
F P
0 g
s
.52353 .48221 m .52383 .47965 L p .52353 .48229 L .061 g
F P
0 g
s
.52355 .48163 m .52353 .48166 L .52356 .48144 L .671 g
F
.52355 .48163 m .52356 .48144 L .52391 .47858 L F
.52351 .48169 m .52353 .48155 L p .52353 .48166 L F P
0 g
s
.52353 .48155 m .52391 .47858 L p .52353 .48166 L .671 g
F P
0 g
s
.52365 .4809 m .52383 .47965 L .52353 .48221 L p .196 g
F P
0 g
s
.52353 .48221 m .52347 .48273 L p .52353 .48211 L .196 g
F P
0 g
s
.52353 .48221 m .52353 .48211 L .52365 .4809 L .196 g
F
.52347 .48273 m .52345 .48291 L .52347 .48266 L p F P
0 g
s
.52347 .48266 m .52365 .4809 L p .52347 .48273 L .196 g
F P
0 g
s
.52502 .47563 m .52646 .47089 L p .52372 .48067 L .709 g
F P
0 g
s
.52365 .4809 m .52371 .48066 L p .52372 .48067 L .709 g
F P
0 g
s
.52371 .48066 m .52502 .47563 L p .52372 .48067 L .709 g
F P
0 g
s
.52512 .47537 m .52383 .47965 L p .52532 .47496 L .709 g
F P
0 g
s
.52395 .47929 m .52387 .47953 L .52395 .47924 L .787 g
F
.52383 .47965 m .52387 .47953 L p .52387 .47953 L F P
0 g
s
.52387 .47953 m .52395 .47924 L p .52387 .47953 L .787 g
F P
0 g
s
.52413 .4787 m .52395 .47929 L .52414 .47863 L .787 g
F
.52396 .47896 m .52383 .47965 L p .52533 .47489 L F P
0 g
s
.52396 .47896 m .52398 .47898 L .52391 .47952 L p .018 g
F P
0 g
s
.52391 .47952 m .52374 .48073 L p .52389 .47952 L .018 g
F P
0 g
s
.52391 .47952 m .52389 .47952 L .52396 .47896 L .018 g
F
.52374 .48073 m .52345 .48291 L .52374 .48071 L p F P
0 g
s
.52374 .48071 m .52396 .47896 L p .52374 .48073 L .018 g
F P
0 g
s
.52646 .47089 m .52512 .47537 L p .52532 .47496 L .709 g
F P
0 g
s
.52819 .4677 m .52663 .47058 L .53114 .46243 L .852 g
F
.52663 .47058 m .52654 .47074 L .52662 .47059 L F
.52663 .47058 m .52662 .47059 L .53114 .46243 L F
.52653 .47076 m .53324 .45866 L p .52654 .47074 L F P
0 g
s
.53649 .45245 m .52746 .4681 L .52646 .47089 L p .852 g
F P
0 g
s
.52398 .47898 m .52702 .4697 L p .52677 .47062 L .286 g
F P
0 g
s
.52702 .4697 m .5276 .46792 L .52712 .46947 L p .286 g
F P
0 g
s
.52712 .46947 m .52677 .47062 L p .52702 .4697 L .286 g
F P
0 g
s
.52646 .47089 m .52653 .47076 L p .52654 .47074 L .852 g
F P
0 g
s
.52646 .47089 m .52746 .4681 L p .52413 .4787 L .787 g
F P
0 g
s
.52681 .47016 m .52517 .47522 L .52533 .47489 L .787 g
F
.52746 .4681 m .52677 .47023 L p .52681 .47016 L F P
0 g
s
.52677 .47023 m .52517 .47522 L p .52681 .47016 L .787 g
F P
0 g
s
.53324 .45866 m .53649 .45245 L p .52819 .4677 L .852 g
F P
0 g
s
.52819 .4677 m .53114 .46243 L .53324 .45866 L .852 g
F
.52746 .4681 m .5276 .46792 L p .52701 .46973 L .01 g
F P
0 g
s
.52413 .4787 m .52414 .47863 L .52646 .47089 L .787 g
F
.52395 .47924 m .52646 .47089 L p .52395 .47929 L F P
0 g
s
.52517 .47522 m .52396 .47896 L p .52533 .47489 L .787 g
F P
0 g
s
.52701 .46973 m .52404 .47872 L .52677 .47023 L .01 g
F
.52701 .46973 m .52677 .47023 L .52746 .4681 L F
.52396 .47896 m .52405 .4787 L p .52404 .47872 L F P
0 g
s
.52405 .4787 m .52746 .4681 L p .52404 .47872 L .01 g
F P
0 g
s
.52495 .47455 m .52494 .47417 L p .52529 .47353 L .612 g
F P
0 g
s
.52514 .47417 m .52495 .47455 L p .52529 .47353 L .612 g
F P
0 g
s
.52494 .47417 m .52461 .46528 L p .52595 .46851 L .612 g
F P
0 g
s
.53241 .46039 m .53324 .45866 L p .5309 .46349 L .746 g
F P
0 g
s
.52387 .47975 m .52352 .48236 L p .52391 .47952 L .651 g
F P
0 g
s
.52398 .47898 m .5239 .47959 L p .52391 .47952 L .651 g
F P
0 g
s
.5239 .47959 m .52387 .47975 L p .52391 .47952 L .651 g
F P
0 g
s
.52352 .48236 m .52345 .48291 L .52353 .48231 L p .651 g
F P
0 g
s
.52353 .48231 m .52398 .47898 L p .52352 .48236 L .651 g
F P
0 g
s
.5237 .48141 m .52426 .47998 L .52469 .47885 L p .704 g
F P
0 g
s
.52469 .47885 m .52535 .47707 L p .5246 .47904 L .704 g
F P
0 g
s
.52535 .47707 m .52855 .46847 L p .52525 .47728 L .704 g
F P
0 g
s
.52525 .47728 m .5237 .48141 L .52535 .47707 L .704 g
F
.5297 .46805 m .52716 .47646 L p .527 .47355 L .582 g
F P
0 g
s
.52951 .46822 m .5297 .46805 L p .527 .47355 L .582 g
F P
0 g
s
.52716 .47646 m .52685 .47747 L p .52685 .47668 L .582 g
F P
0 g
s
.5297 .46805 m .53349 .46755 L .53048 .47386 L p .557 g
F P
0 g
s
.53048 .47386 m .52894 .47706 L p .52916 .4745 L .557 g
F P
0 g
s
.52916 .4745 m .5297 .46805 L .53048 .47386 L .557 g
F
.52598 .47731 m .52694 .47557 L p .52563 .47756 L .708 g
F P
0 g
s
.52685 .47747 m .5297 .46805 L p .529 .47643 L .557 g
F P
0 g
s
.52894 .47706 m .52685 .47747 L p .529 .47643 L .557 g
F P
0 g
s
.52685 .47747 m .52905 .4747 L p .52589 .47794 L .71 g
F P
0 g
s
.52529 .47855 m .52685 .47747 L p .52589 .47794 L .71 g
F P
0 g
s
.52694 .47557 m .53498 .46105 L p .52669 .4757 L .708 g
F P
0 g
s
.52669 .4757 m .52563 .47756 L .52694 .47557 L .708 g
F
.52563 .47756 m .52426 .47998 L .52598 .47731 L F
.53349 .46755 m .53809 .46984 L .5327 .47615 L p .531 g
F P
0 g
s
.53201 .47588 m .53349 .46755 L .5327 .47615 L .531 g
F
.53158 .47711 m .53349 .46755 L .53176 .47725 L F
.52894 .47706 m .53349 .46755 L p .53158 .47711 L F P
0 g
s
.53149 .47756 m .52894 .47706 L p .53158 .47711 L .531 g
F P
0 g
s
.52894 .47706 m .53015 .47599 L p .52781 .47704 L .71 g
F P
0 g
s
.52685 .47747 m .52894 .47706 L p .52781 .47704 L .71 g
F P
0 g
s
.52905 .4747 m .54464 .45501 L p .52861 .47452 L .71 g
F P
0 g
s
.52861 .47452 m .52529 .47855 L .52905 .4747 L .71 g
F
.5327 .47615 m .53176 .47725 L p .53201 .47588 L .531 g
F P
0 g
s
.53176 .47725 m .53149 .47756 L p .53158 .47711 L .531 g
F P
0 g
s
.53015 .47599 m .55744 .45181 L p .52936 .47537 L .71 g
F P
0 g
s
.52936 .47537 m .52685 .47747 L .53015 .47599 L .71 g
F
.53149 .47756 m .53809 .46984 L p .53449 .47882 L .504 g
F P
0 g
s
.53438 .47912 m .53149 .47756 L p .53449 .47882 L .504 g
F P
0 g
s
.53149 .47756 m .53289 .47672 L p .53006 .47697 L .708 g
F P
0 g
s
.52894 .47706 m .53149 .47756 L p .53006 .47697 L .708 g
F P
0 g
s
.53289 .47672 m .5729 .45257 L p .5319 .47542 L .708 g
F P
0 g
s
.5319 .47542 m .52894 .47706 L .53289 .47672 L .708 g
F
.53438 .47912 m .54325 .47525 L p .53755 .48159 L .479 g
F P
0 g
s
.53742 .48175 m .53438 .47912 L p .53755 .48159 L .479 g
F P
0 g
s
.53438 .47912 m .53588 .47855 L p .53274 .47784 L .705 g
F P
0 g
s
.53149 .47756 m .53438 .47912 L p .53274 .47784 L .705 g
F P
0 g
s
.53588 .47855 m .59023 .45793 L p .53474 .47648 L .705 g
F P
0 g
s
.53474 .47648 m .53149 .47756 L .53588 .47855 L .705 g
F
.54041 .48536 m .53742 .48175 L .54866 .48376 L p .473 g
F P
0 g
s
.53742 .48175 m .54041 .48536 L .62617 .48255 L p .698 g
F P
0 g
s
.62617 .48255 m .60837 .46803 L .53742 .48175 L p .698 g
F P
0 g
s
.50138 .73612 m .4971 .75365 L .43448 .76643 L p .818 g
F P
0 g
s
.4971 .75365 m .50138 .73612 L .54302 .67203 L p .912 g
F P
0 g
s
.54302 .67203 m .54695 .686 L .4971 .75365 L p .912 g
F P
0 g
s
.44892 .74898 m .43448 .76643 L .39293 .72377 L p .598 g
F P
0 g
s
.43448 .76643 m .44892 .74898 L .50138 .73612 L p .818 g
F P
0 g
s
.5504 .69131 m .54695 .686 L .55468 .57674 L p .902 g
F P
0 g
s
.55468 .57674 m .55952 .5796 L .5504 .69131 L p .902 g
F P
0 g
s
.58808 .42599 m .61722 .4239 L .64846 .39743 L p .788 g
F P
0 g
s
.64846 .39743 m .60955 .4047 L .58808 .42599 L p .788 g
F P
0 g
s
.60955 .4047 m .64846 .39743 L .65418 .38225 L p .873 g
F P
0 g
s
.70038 .37645 m .65418 .38225 L .64846 .39743 L p .819 g
F P
0 g
s
.4896 .46852 m .44734 .45463 L p .49651 .46676 L .221 g
F P
0 g
s
.44734 .45463 m .46702 .44813 L .49851 .46726 L p .221 g
F P
0 g
s
.48525 .46384 m .4746 .46583 L .47952 .47108 L p .729 g
F P
0 g
s
.47952 .47108 m .48019 .4718 L p .48087 .47073 L .729 g
F P
0 g
s
.48087 .47073 m .48525 .46384 L .47952 .47108 L .729 g
F
.49851 .46726 m .4896 .46852 L p .49651 .46676 L .221 g
F P
0 g
s
.74926 .37861 m .79789 .38925 L .74863 .37801 L p .403 g
F P
0 g
s
.79789 .38925 m .84318 .40817 L .78638 .38842 L p .075 g
F P
0 g
s
.78638 .38842 m .74863 .37801 L .79789 .38925 L p .075 g
F P
0 g
s
.49922 .45054 m .48462 .44701 L .48199 .43771 L p .086 g
F P
0 g
s
.48199 .43771 m .49744 .44018 L .49922 .45054 L p .086 g
F P
0 g
s
.55744 .45181 m .5729 .45257 L .61722 .4239 L p .74 g
F P
0 g
s
.61722 .4239 m .58808 .42599 L .55744 .45181 L p .74 g
F P
0 g
s
.53438 .47912 m .53742 .48175 L .60837 .46803 L p .702 g
F P
0 g
s
.60837 .46803 m .59023 .45793 L .53438 .47912 L p .702 g
F P
0 g
s
.70038 .37645 m .74926 .37861 L .70816 .3748 L p .509 g
F P
0 g
s
.74863 .37801 m .70816 .3748 L .74926 .37861 L p .403 g
F P
0 g
s
.67262 .58364 m .66848 .59934 L .80081 .6359 L p .559 g
F P
0 g
s
.78478 .65585 m .80081 .6359 L .66848 .59934 L p .536 g
F P
0 g
s
.80081 .6359 m .78478 .65585 L .87828 .64952 L p .301 g
F P
0 g
s
.87828 .64952 m .89976 .62257 L .80081 .6359 L p .301 g
F P
0 g
s
.84318 .40817 m .88205 .43443 L .81872 .40562 L p .155 g
F P
0 g
s
.81872 .40562 m .78638 .38842 L .84318 .40817 L p .155 g
F P
0 g
s
.65418 .38225 m .70038 .37645 L .66766 .37854 L p .557 g
F P
0 g
s
.70816 .3748 m .66766 .37854 L .70038 .37645 L p .509 g
F P
0 g
s
.90852 .58925 m .89976 .62257 L .92432 .57322 L p F P
s
.92432 .57322 m .93404 .53862 L .90852 .58925 L p F P
s
.88205 .43443 m .91164 .46645 L .84314 .42861 L p .362 g
F P
0 g
s
.84314 .42861 m .81872 .40562 L .88205 .43443 L p .362 g
F P
0 g
s
.59023 .45793 m .5729 .45257 L .53149 .47756 L p .705 g
F P
0 g
s
.53105 .45243 m .52821 .45257 L .51819 .44242 L p .199 g
F P
0 g
s
.65959 .61019 m .66848 .59934 L .54712 .51165 L p .667 g
F P
0 g
s
.66848 .59934 m .65959 .61019 L .78478 .65585 L p .536 g
F P
0 g
s
.50922 .44819 m .49744 .44018 L .5056 .43796 L p .111 g
F P
0 g
s
.5056 .43796 m .51366 .44549 L .50922 .44819 L p .111 g
F P
0 g
s
.51366 .44549 m .5056 .43796 L .51819 .44242 L p .165 g
F P
0 g
s
.49851 .46726 m .46702 .44813 L p .50452 .46692 L .244 g
F P
0 g
s
.49533 .46381 m .48525 .46384 L .48893 .4678 L p .677 g
F P
0 g
s
.48893 .4678 m .4896 .46852 L p .49059 .4677 L .677 g
F P
0 g
s
.49059 .4677 m .49533 .46381 L .48893 .4678 L .677 g
F
.50641 .46786 m .49851 .46726 L p .50452 .46692 L .244 g
F P
0 g
s
.46702 .44813 m .48462 .44701 L .50641 .46786 L p .244 g
F P
0 g
s
.65418 .38225 m .61321 .39478 L .60955 .4047 L p .873 g
F P
0 g
s
.61321 .39478 m .65418 .38225 L .62959 .38841 L p F P
s
.66766 .37854 m .62959 .38841 L .65418 .38225 L p .557 g
F P
0 g
s
.56386 .43378 m .58808 .42599 L .60955 .4047 L p .823 g
F P
0 g
s
.60955 .4047 m .57728 .4179 L .56386 .43378 L p .823 g
F P
0 g
s
.57728 .4179 m .60955 .4047 L .61321 .39478 L p .915 g
F P
0 g
s
.38254 .63894 m .40099 .63762 L .39293 .72377 L p .338 g
F P
0 g
s
.41449 .70956 m .39293 .72377 L .40099 .63762 L p .432 g
F P
0 g
s
.39293 .72377 m .41449 .70956 L .44892 .74898 L p .598 g
F P
0 g
s
.54695 .686 m .54302 .67203 L .54927 .56991 L p .874 g
F P
0 g
s
.54927 .56991 m .55468 .57674 L .54695 .686 L p .874 g
F P
0 g
s
.51819 .44242 m .52057 .44882 L .51366 .44549 L p .165 g
F P
0 g
s
.52057 .44882 m .51819 .44242 L .52821 .45257 L p .385 g
F P
0 g
s
.54464 .45501 m .55744 .45181 L .58808 .42599 L p .754 g
F P
0 g
s
.58808 .42599 m .56386 .43378 L .54464 .45501 L p .754 g
F P
0 g
s
.50593 .70822 m .50138 .73612 L .44892 .74898 L p .794 g
F P
0 g
s
.50138 .73612 m .50593 .70822 L .5389 .65053 L p .857 g
F P
0 g
s
.5389 .65053 m .54302 .67203 L .50138 .73612 L p .857 g
F P
0 g
s
.76053 .66755 m .78478 .65585 L .65959 .61019 L p .511 g
F P
0 g
s
.78478 .65585 m .76053 .66755 L .84537 .66772 L p .152 g
F P
0 g
s
.84537 .66772 m .87828 .64952 L .78478 .65585 L p .152 g
F P
0 g
s
.4643 .72036 m .44892 .74898 L .41449 .70956 L p .646 g
F P
0 g
s
.44892 .74898 m .4643 .72036 L .50593 .70822 L p .794 g
F P
0 g
s
.91164 .46645 m .92954 .50207 L .85756 .45579 L p .567 g
F P
0 g
s
.85756 .45579 m .84314 .42861 L .91164 .46645 L p .567 g
F P
0 g
s
.51025 .45745 m .49922 .45054 L .49744 .44018 L p .15 g
F P
0 g
s
.49744 .44018 m .50922 .44819 L .51025 .45745 L p .15 g
F P
0 g
s
.5729 .45257 m .55744 .45181 L .52894 .47706 L p .708 g
F P
0 g
s
.61321 .39478 m .57942 .41215 L .57728 .4179 L p .915 g
F P
0 g
s
.57942 .41215 m .61321 .39478 L .59604 .40305 L p F P
s
.62959 .38841 m .59604 .40305 L .61321 .39478 L p F P
s
.64653 .61525 m .65959 .61019 L .54553 .51359 L p .665 g
F P
0 g
s
.65959 .61019 m .64653 .61525 L .76053 .66755 L p .511 g
F P
0 g
s
.31044 .36053 m .26371 .36472 L .3486 .42487 L p .632 g
F P
0 g
s
.3486 .42487 m .37961 .41774 L .31044 .36053 L p .632 g
F P
0 g
s
.31992 .43731 m .3486 .42487 L .26371 .36472 L p .646 g
F P
0 g
s
.37961 .41774 m .3486 .42487 L .4641 .46981 L p .547 g
F P
0 g
s
.3486 .42487 m .31992 .43731 L .45447 .47561 L p .553 g
F P
0 g
s
.45447 .47561 m .4641 .46981 L .3486 .42487 L p .553 g
F P
0 g
s
.89976 .62257 m .87828 .64952 L .90071 .60292 L p .866 g
F P
0 g
s
.90071 .60292 m .92432 .57322 L .89976 .62257 L p .866 g
F P
0 g
s
.35713 .36432 m .31044 .36053 L .37961 .41774 L p .614 g
F P
0 g
s
.37961 .41774 m .41088 .4161 L .35713 .36432 L p .614 g
F P
0 g
s
.41088 .4161 m .37961 .41774 L .4746 .46583 L p .535 g
F P
0 g
s
.4641 .46981 m .4746 .46583 L .37961 .41774 L p .547 g
F P
0 g
s
.50641 .46786 m .48462 .44701 L p .51117 .46859 L .267 g
F P
0 g
s
.50424 .46551 m .49533 .46381 L .49787 .46655 L p .591 g
F P
0 g
s
.49787 .46655 m .49851 .46726 L p .49983 .46685 L .591 g
F P
0 g
s
.49983 .46685 m .50424 .46551 L .49787 .46655 L .591 g
F
.51288 .46998 m .50641 .46786 L p .51117 .46859 L .267 g
F P
0 g
s
.48462 .44701 m .49922 .45054 L .51288 .46998 L p .267 g
F P
0 g
s
.33997 .32363 m .28755 .31192 L .31044 .36053 L p .683 g
F P
0 g
s
.31044 .36053 m .35713 .36432 L .33997 .32363 L p .683 g
F P
0 g
s
.26371 .36472 m .31044 .36053 L .28755 .31192 L p .717 g
F P
0 g
s
.3888 .3428 m .33997 .32363 L .35713 .36432 L p .645 g
F P
0 g
s
.35713 .36432 m .40099 .37518 L .3888 .3428 L p .645 g
F P
0 g
s
.40099 .37518 m .35713 .36432 L .41088 .4161 L p .59 g
F P
0 g
s
.26371 .36472 m .21999 .37713 L .31992 .43731 L p .646 g
F P
0 g
s
.29561 .45441 m .31992 .43731 L .21999 .37713 L p .654 g
F P
0 g
s
.31992 .43731 m .29561 .45441 L .44643 .48287 L p .555 g
F P
0 g
s
.44643 .48287 m .45447 .47561 L .31992 .43731 L p .555 g
F P
0 g
s
.54551 .44544 m .56386 .43378 L .57728 .4179 L p .851 g
F P
0 g
s
.57728 .4179 m .55284 .43474 L .54551 .44544 L p .851 g
F P
0 g
s
.55284 .43474 m .57728 .4179 L .57942 .41215 L p .919 g
F P
0 g
s
.41088 .4161 m .44045 .41961 L .40099 .37518 L p .59 g
F P
0 g
s
.44045 .41961 m .41088 .4161 L .48525 .46384 L p .519 g
F P
0 g
s
.4746 .46583 m .48525 .46384 L .41088 .4161 L p .535 g
F P
0 g
s
.43156 .36733 m .3888 .3428 L .40099 .37518 L p .604 g
F P
0 g
s
.40099 .37518 m .43966 .39159 L .43156 .36733 L p .604 g
F P
0 g
s
.43966 .39159 m .40099 .37518 L .44045 .41961 L p .561 g
F P
0 g
s
.28755 .31192 m .2346 .30923 L .26371 .36472 L p .717 g
F P
0 g
s
.21999 .37713 m .26371 .36472 L .2346 .30923 L p .748 g
F P
0 g
s
.52821 .45257 m .52606 .45748 L .52057 .44882 L p .385 g
F P
0 g
s
.21999 .37713 m .18237 .39729 L .29561 .45441 L p .654 g
F P
0 g
s
.2775 .47505 m .29561 .45441 L .18237 .39729 L p .654 g
F P
0 g
s
.29561 .45441 m .2775 .47505 L .4406 .49108 L p .55 g
F P
0 g
s
.4406 .49108 m .44643 .48287 L .29561 .45441 L p .55 g
F P
0 g
s
.53498 .46105 m .54464 .45501 L .56386 .43378 L p .762 g
F P
0 g
s
.56386 .43378 m .54551 .44544 L .53498 .46105 L p .762 g
F P
0 g
s
.54302 .67203 m .5389 .65053 L .54371 .55974 L p .838 g
F P
0 g
s
.54371 .55974 m .54927 .56991 L .54302 .67203 L p .838 g
F P
0 g
s
.55744 .45181 m .54464 .45501 L .52685 .47747 L p .71 g
F P
0 g
s
.62959 .38841 m .66766 .37854 L .60135 .41416 L p .113 g
F P
0 g
s
.66766 .37854 m .70816 .3748 L .62338 .40908 L p .136 g
F P
0 g
s
.62338 .40908 m .60135 .41416 L .66766 .37854 L p .136 g
F P
0 g
s
.70816 .3748 m .74863 .37801 L .64534 .40797 L p .207 g
F P
0 g
s
.64534 .40797 m .62338 .40908 L .70816 .3748 L p .207 g
F P
0 g
s
.51713 .45935 m .50922 .44819 L .51366 .44549 L p .238 g
F P
0 g
s
.51366 .44549 m .5191 .45708 L .51713 .45935 L p .238 g
F P
0 g
s
.5191 .45708 m .51366 .44549 L .52057 .44882 L p .359 g
F P
0 g
s
.44045 .41961 m .46662 .42747 L .43966 .39159 L p .561 g
F P
0 g
s
.46662 .42747 m .44045 .41961 L .49533 .46381 L p .499 g
F P
0 g
s
.48525 .46384 m .49533 .46381 L .44045 .41961 L p .519 g
F P
0 g
s
.92954 .50207 m .93404 .53862 L .86057 .4851 L p .682 g
F P
0 g
s
.86057 .4851 m .85756 .45579 L .92954 .50207 L p .682 g
F P
0 g
s
.40099 .63762 m .42183 .62907 L .41449 .70956 L p .432 g
F P
0 g
s
.43725 .68566 m .41449 .70956 L .42183 .62907 L p .493 g
F P
0 g
s
.41449 .70956 m .43725 .68566 L .4643 .72036 L p .646 g
F P
0 g
s
.57942 .41215 m .55394 .43194 L .55284 .43474 L p .919 g
F P
0 g
s
.55394 .43194 m .57942 .41215 L .56854 .42068 L p F P
s
.59604 .40305 m .56854 .42068 L .57942 .41215 L p F P
s
.46644 .39468 m .43156 .36733 L .43966 .39159 L p .559 g
F P
0 g
s
.43966 .39159 m .47137 .41155 L .46644 .39468 L p .559 g
F P
0 g
s
.47137 .41155 m .43966 .39159 L .46662 .42747 L p .528 g
F P
0 g
s
.52057 .44882 m .52217 .4592 L .5191 .45708 L p .359 g
F P
0 g
s
.52217 .4592 m .52057 .44882 L .52606 .45748 L p .512 g
F P
0 g
s
.63023 .61408 m .64653 .61525 L .54328 .51415 L p .664 g
F P
0 g
s
.64653 .61525 m .63023 .61408 L .72975 .66992 L p .482 g
F P
0 g
s
.72975 .66992 m .76053 .66755 L .64653 .61525 L p .482 g
F P
0 g
s
.59604 .40305 m .62959 .38841 L .58065 .42253 L p .1 g
F P
0 g
s
.60135 .41416 m .58065 .42253 L .62959 .38841 L p .113 g
F P
0 g
s
.2346 .30923 m .18454 .31644 L .21999 .37713 L p .748 g
F P
0 g
s
.18237 .39729 m .21999 .37713 L .18454 .31644 L p .775 g
F P
0 g
s
.76053 .66755 m .72975 .66992 L .80339 .67554 L p .091 g
F P
0 g
s
.80339 .67554 m .84537 .66772 L .76053 .66755 L p .091 g
F P
0 g
s
.74863 .37801 m .78638 .38842 L .66571 .41118 L p .297 g
F P
0 g
s
.66571 .41118 m .64534 .40797 L .74863 .37801 L p .297 g
F P
0 g
s
.18237 .39729 m .15372 .42406 L .2775 .47505 L p .654 g
F P
0 g
s
.26706 .49775 m .2775 .47505 L .15372 .42406 L p .644 g
F P
0 g
s
.2775 .47505 m .26706 .49775 L .43744 .49962 L p .538 g
F P
0 g
s
.43744 .49962 m .4406 .49108 L .2775 .47505 L p .538 g
F P
0 g
s
.44427 .36393 m .40709 .33556 L .3888 .3428 L p .583 g
F P
0 g
s
.3888 .3428 m .43156 .36733 L .44427 .36393 L p .583 g
F P
0 g
s
.33997 .32363 m .3888 .3428 L .40709 .33556 L p .65 g
F P
0 g
s
.51773 .4731 m .51288 .46998 L .49922 .45054 L p .289 g
F P
0 g
s
.49922 .45054 m .51025 .45745 L .51773 .4731 L p .289 g
F P
0 g
s
.40709 .33556 m .36439 .31133 L .33997 .32363 L p .65 g
F P
0 g
s
.28755 .31192 m .33997 .32363 L .36439 .31133 L p .715 g
F P
0 g
s
.51761 .46604 m .51025 .45745 L .50922 .44819 L p .244 g
F P
0 g
s
.50922 .44819 m .51713 .45935 L .51761 .46604 L p .244 g
F P
0 g
s
.47445 .39383 m .44427 .36393 L .43156 .36733 L p .509 g
F P
0 g
s
.46644 .39468 m .47445 .39383 L p .45681 .38293 L .509 g
F P
0 g
s
.49691 .42259 m .47445 .39383 L .46644 .39468 L p .421 g
F P
0 g
s
.50638 .4357 m .49188 .41218 L .48268 .40249 L p .357 g
F P
0 g
s
.49251 .42209 m .49691 .42259 L p .48156 .40853 L .421 g
F P
0 g
s
.51174 .44769 m .49691 .42259 L .49251 .42209 L p .305 g
F P
0 g
s
.51593 .45573 m .50638 .4357 L .50593 .43507 L p .487 g
F P
0 g
s
.50978 .4468 m .51174 .44769 L p .49979 .43179 L .305 g
F P
0 g
s
.52166 .47438 m .52089 .4728 L p .51713 .45935 L .299 g
F P
0 g
s
.52089 .4728 m .51761 .46604 L .51737 .46272 L p .299 g
F P
0 g
s
.51737 .46272 m .51713 .45935 L p .52089 .4728 L .299 g
F P
0 g
s
.52151 .47078 m .5232 .47952 L .52322 .48056 L p .304 g
F P
0 g
s
.52292 .47871 m .52299 .47894 L p .52276 .47815 L .037 g
F P
0 g
s
.51761 .46604 m .52166 .47438 L .52268 .47978 L p .321 g
F P
0 g
s
.51713 .45935 m .52151 .47078 L .52166 .47438 L p .299 g
F P
0 g
s
.51926 .46631 m .52126 .4731 L p .52124 .47302 L .037 g
F P
0 g
s
.51739 .46203 m .51132 .4475 L .50978 .4468 L p .136 g
F P
0 g
s
.51811 .4628 m .51891 .46506 L p .51987 .46698 L .136 g
F P
0 g
s
.51302 .45073 m .51174 .44769 L p .51166 .44766 L .136 g
F P
0 g
s
.52151 .47078 m .51713 .45935 L .5191 .45708 L p .353 g
F P
0 g
s
.51926 .46631 m .51987 .46698 L p .51492 .45709 L .136 g
F P
0 g
s
.51179 .45083 m .51468 .45682 L .51492 .45709 L .136 g
F
.51468 .45682 m .51926 .46631 L .51492 .45709 L F
.52322 .48056 m .52166 .47438 L .52151 .47078 L p .304 g
F P
0 g
s
.52299 .47894 m .51987 .46698 L .51926 .46631 L p .037 g
F P
0 g
s
.52124 .47302 m .5227 .47799 L .52276 .47815 L .037 g
F
.5227 .47799 m .52292 .47871 L p .52276 .47815 L F P
0 g
s
.52335 .48206 m .52268 .47978 L .52166 .47438 L p .322 g
F P
0 g
s
.52253 .47783 m .52322 .48056 L p .5231 .48092 L .322 g
F P
0 g
s
.5231 .48092 m .52316 .48075 L .52331 .48186 L .322 g
F
.52334 .48205 m .52258 .47968 L .52268 .47978 L p .607 g
F P
0 g
s
.52268 .47978 m .52335 .48206 L .52334 .48205 L p .607 g
F P
0 g
s
.52258 .47968 m .52334 .48205 L .52312 .48045 L p .398 g
F P
0 g
s
.52316 .48075 m .52319 .48065 L .52331 .48186 L .322 g
F
.52312 .48045 m .52334 .48205 L .52338 .48238 L p .676 g
F P
0 g
s
.52338 .48238 m .52345 .48291 L .5234 .48251 L p .676 g
F P
0 g
s
.5234 .48251 m .52312 .48045 L p .52338 .48238 L .676 g
F P
0 g
s
.52319 .48065 m .52322 .48056 L .52328 .48147 L .322 g
F
.52319 .48065 m .52328 .48147 L .52331 .48186 L F
.52296 .47925 m .52312 .48045 L .5234 .48251 L p .013 g
F P
0 g
s
.5234 .48251 m .52345 .48291 L .52341 .48258 L p .013 g
F P
0 g
s
.52341 .48258 m .52296 .47925 L p .5234 .48251 L .013 g
F P
0 g
s
.52322 .48056 m .52335 .48206 L p .52331 .48186 L .322 g
F P
0 g
s
.52166 .47438 m .52253 .47783 L p .5231 .48092 L .322 g
F P
0 g
s
.52292 .47871 m .5195 .46711 L p .51962 .46871 L .385 g
F P
0 g
s
.51962 .46871 m .52296 .47925 L .52292 .47871 L p .385 g
F P
0 g
s
.52341 .48262 m .52292 .47871 L p .52341 .48258 L .043 g
F P
0 g
s
.52299 .47894 m .52292 .47871 L .52326 .48143 L p .126 g
F P
0 g
s
.52335 .48206 m .52345 .48291 L .52334 .48205 L closepath p .702 g
F P
0 g
s
.52326 .48143 m .52345 .48291 L .52328 .48139 L p .126 g
F P
0 g
s
.52328 .48139 m .52299 .47894 L p .52326 .48143 L .126 g
F P
0 g
s
.52299 .47894 m .52316 .47993 L p .52074 .47042 L .679 g
F P
0 g
s
.52073 .47038 m .52074 .4704 L .52074 .47042 L .679 g
F
.52074 .4704 m .52299 .47894 L .52074 .47042 L F
.52043 .46914 m .52299 .47894 L p .52073 .47038 L F P
0 g
s
.52245 .47716 m .52307 .47957 L .52296 .47907 L .679 g
F
.52245 .47716 m .52276 .47833 L .52149 .47235 L F
.52276 .47833 m .52275 .47809 L .52149 .47235 L F
.52045 .46927 m .52245 .47716 L .52149 .47235 L F
.52115 .47078 m .52156 .47265 L p .52204 .47512 L .684 g
F P
0 g
s
.52307 .47951 m .52115 .47078 L p .52307 .47957 L .679 g
F P
0 g
s
.52156 .47265 m .52274 .47804 L p .52204 .47512 L .684 g
F P
0 g
s
.52274 .47804 m .52316 .47993 L p .52262 .47764 L .684 g
F P
0 g
s
.52274 .47804 m .52262 .47764 L .52204 .47512 L .684 g
F
.5195 .46711 m .51926 .46631 L .51931 .46666 L p .385 g
F P
0 g
s
.51987 .46698 m .52043 .46914 L p .52073 .47038 L .679 g
F P
0 g
s
.52115 .47078 m .51987 .46698 L p .52045 .46927 L .679 g
F P
0 g
s
.51987 .46698 m .52115 .47078 L p .51607 .45832 L .621 g
F P
0 g
s
.51483 .45502 m .51987 .46698 L p .51607 .45832 L .621 g
F P
0 g
s
.52115 .47078 m .51808 .46192 L p .51616 .45854 L .621 g
F P
0 g
s
.51808 .46192 m .51593 .45573 L p .51616 .45854 L .621 g
F P
0 g
s
.5114 .45014 m .51926 .46631 L p .51179 .45083 L .136 g
F P
0 g
s
.51926 .46631 m .50978 .4468 L .51094 .45254 L p .405 g
F P
0 g
s
.51094 .45254 m .51962 .46871 L .51926 .46631 L p .405 g
F P
0 g
s
.52276 .47833 m .52296 .47907 L .52275 .47809 L .679 g
F
.52316 .47993 m .52299 .47894 L .52339 .48237 L p .274 g
F P
0 g
s
.52322 .48056 m .52345 .48291 L .52335 .48206 L closepath p .669 g
F P
0 g
s
.52339 .48237 m .52345 .48291 L .5234 .48237 L p .274 g
F P
0 g
s
.5234 .48237 m .52316 .47993 L p .52339 .48237 L .274 g
F P
0 g
s
.52307 .48008 m .52339 .48244 L p .52307 .47993 L .043 g
F P
0 g
s
.52339 .48244 m .52341 .48258 L p .52339 .48243 L .043 g
F P
0 g
s
.52339 .48244 m .52339 .48243 L .52307 .47993 L .043 g
F
.52307 .47957 m .52316 .47993 L .52307 .47953 L .679 g
F
.52316 .47993 m .52307 .47951 L p .52307 .47953 L F P
0 g
s
.52292 .47871 m .52296 .47925 L .52307 .48008 L p .043 g
F P
0 g
s
.52307 .48008 m .52307 .47993 L .52292 .47871 L .043 g
F
.52296 .47925 m .51962 .46871 L .52086 .47351 L p .418 g
F P
0 g
s
.52086 .47351 m .52312 .48045 L .52296 .47925 L p .418 g
F P
0 g
s
.52316 .47993 m .52334 .48151 L p .52204 .47512 L .684 g
F P
0 g
s
.5232 .47952 m .52345 .48291 L .52322 .48056 L closepath p .627 g
F P
0 g
s
.52334 .48151 m .52316 .47993 L .52343 .48273 L p .368 g
F P
0 g
s
.52343 .48273 m .52345 .48291 L .52343 .48265 L p .368 g
F P
0 g
s
.52343 .48265 m .52334 .48151 L p .52343 .48273 L .368 g
F P
0 g
s
.5234 .47938 m .52345 .48291 L .52328 .4791 L closepath p .542 g
F P
0 g
s
.52342 .48243 m .52339 .48062 L p .52337 .48066 L .727 g
F P
0 g
s
.52328 .4791 m .52345 .48291 L .5232 .47952 L closepath p .584 g
F P
0 g
s
.52334 .48151 m .52345 .48291 L .52342 .48243 L closepath p .434 g
F P
0 g
s
.52334 .48151 m .52342 .48243 L p .52333 .48181 L .722 g
F P
0 g
s
.52334 .48151 m .52331 .48131 L p .5233 .48132 L .684 g
F P
0 g
s
.52325 .48092 m .52342 .48241 L p .52337 .48066 L .727 g
F P
0 g
s
.52342 .48241 m .52342 .48243 L p .52337 .48066 L .727 g
F P
0 g
s
.52296 .47962 m .5233 .48132 L .52316 .48045 L .684 g
F
.52331 .48131 m .52316 .48045 L p .5233 .48132 L F P
0 g
s
.52316 .48045 m .5226 .47715 L p .52296 .47962 L .684 g
F P
0 g
s
.5226 .47715 m .52334 .48151 L p .52334 .48155 L .722 g
F P
0 g
s
.5226 .47715 m .52334 .48155 L .52317 .48079 L .722 g
F
.52126 .4731 m .5227 .47799 L p .52124 .47302 L .037 g
F P
0 g
s
.5226 .47715 m .52137 .47176 L p .52296 .47962 L .684 g
F P
0 g
s
.52045 .46927 m .52149 .47235 L .52115 .47078 L .679 g
F
.52137 .47176 m .52115 .47078 L p .52133 .47165 L .684 g
F P
0 g
s
.52133 .47165 m .52324 .48103 L .52137 .47176 L .684 g
F
.52324 .48103 m .52334 .48151 L .52324 .48102 L F
.52324 .48103 m .52324 .48102 L .52137 .47176 L F
.52115 .47078 m .5226 .47715 L p .5198 .46814 L .682 g
F P
0 g
s
.52013 .46909 m .5219 .47485 L .52123 .47199 L .682 g
F
.5226 .47715 m .5218 .47413 L p .5219 .47485 L F P
0 g
s
.5218 .47413 m .52123 .47199 L p .5219 .47485 L .682 g
F P
0 g
s
.51971 .44408 m .51652 .42347 L .51947 .45706 L p .739 g
F P
0 g
s
.51788 .46134 m .52115 .47078 L p .5198 .46814 L .682 g
F P
0 g
s
.51593 .45573 m .51788 .46134 L p .5198 .46814 L .682 g
F P
0 g
s
.52066 .46985 m .51727 .45973 L p .52013 .46909 L .682 g
F P
0 g
s
.52123 .47199 m .52066 .46985 L p .52013 .46909 L .682 g
F P
0 g
s
.51713 .45957 m .51987 .46839 L .51727 .45973 L .682 g
F
.51987 .46839 m .52097 .47192 L .51818 .46269 L F
.52097 .47192 m .5226 .47715 L .52095 .47177 L F
.52097 .47192 m .52095 .47177 L .51818 .46269 L F
.51652 .42347 m .5122 .40057 L .51275 .40592 L p .753 g
F P
0 g
s
.51987 .46839 m .51818 .46269 L .51727 .45973 L .682 g
F
.51884 .46442 m .52066 .46985 L p .51891 .46567 L .668 g
F P
0 g
s
.51174 .44769 m .51483 .45502 L p .5154 .45654 L .621 g
F P
0 g
s
.51505 .45581 m .5154 .45654 L .51607 .45832 L .621 g
F
.51174 .44769 m .5154 .45654 L .51505 .45581 L F
.51593 .45573 m .51174 .44769 L p .51616 .45854 L F P
0 g
s
.51174 .44769 m .51593 .45573 L p .50744 .44093 L .487 g
F P
0 g
s
.50628 .43874 m .51174 .44769 L .50744 .44093 L .487 g
F
.50831 .44189 m .51174 .44769 L p .50465 .43607 L F P
0 g
s
.50475 .43444 m .51593 .45573 L .50593 .43507 L .487 g
F
.50465 .43607 m .50628 .43874 L .50744 .44093 L F
.49691 .42259 m .50831 .44189 L p .50465 .43607 L F P
0 g
s
.50325 .43364 m .51019 .44573 L .50475 .43444 L .487 g
F
.51019 .44573 m .51593 .45573 L .50475 .43444 L F
.50638 .4357 m .51884 .46442 L .51884 .46442 L .668 g
F
.51348 .45268 m .51884 .46442 L .51628 .45936 L F
.50638 .4357 m .51442 .45422 L .51348 .45268 L F
.51442 .45422 m .51884 .46442 L .51348 .45268 L F
.51727 .45973 m .51593 .45573 L p .51713 .45957 L .682 g
F P
0 g
s
.50638 .4357 m .51593 .45573 L .51884 .46442 L p .668 g
F P
0 g
s
.51628 .45936 m .51884 .46442 L .51891 .46567 L .668 g
F
.5171 .45997 m .51497 .45514 L p .52029 .46896 L F P
0 g
s
.51497 .45514 m .50638 .4357 L p .5128 .45104 L .668 g
F P
0 g
s
.5128 .45104 m .52029 .46896 L .51497 .45514 L .668 g
F
.50593 .43507 m .49691 .42259 L p .50325 .43364 L .487 g
F P
0 g
s
.47445 .39383 m .49691 .42259 L .49767 .42363 L p .357 g
F P
0 g
s
.49767 .42363 m .50638 .4357 L p .49437 .41994 L .357 g
F P
0 g
s
.48882 .41267 m .49214 .41678 L .49437 .41994 L .357 g
F
.49214 .41678 m .49767 .42363 L .49437 .41994 L F
.47445 .39383 m .49767 .42363 L .48882 .41267 L F
.4951 .4209 m .50638 .4357 L .49374 .41799 L F
.49424 .41953 m .49374 .41799 L .48969 .41232 L F
.4951 .4209 m .49374 .41799 L .49424 .41953 L F
.49188 .41218 m .50638 .4357 L .51054 .4451 L p .65 g
F P
0 g
s
.51054 .4451 m .5171 .45997 L p .50604 .43901 L .65 g
F P
0 g
s
.49188 .41218 m .51054 .4451 L .50604 .43901 L .65 g
F
.50076 .429 m .50374 .43466 L .50117 .42959 L F
.5171 .45997 m .5117 .44819 L .50723 .44008 L p F P
0 g
s
.50723 .44008 m .49776 .42287 L p .5063 .43924 L .65 g
F P
0 g
s
.5063 .43924 m .5171 .45997 L .50723 .44008 L .65 g
F
.50374 .43466 m .5171 .45997 L .49776 .42287 L F
.48236 .4042 m .4951 .4209 L .48268 .40249 L .357 g
F
.49776 .42287 m .49188 .41218 L p .50076 .429 L .65 g
F P
0 g
s
.50076 .429 m .50117 .42959 L .49776 .42287 L .65 g
F
.4951 .4209 m .48969 .41232 L .48268 .40249 L .357 g
F
.49188 .41218 m .47233 .38704 L .45986 .37677 L p .25 g
F P
0 g
s
.48268 .40249 m .47445 .39383 L p .48236 .4042 L .357 g
F P
0 g
s
.47422 .3936 m .47445 .39383 L .49188 .41218 L p .25 g
F P
0 g
s
.47233 .38704 m .44821 .36236 L .42815 .34929 L p .182 g
F P
0 g
s
.44427 .36393 m .47422 .3936 L p .47887 .39849 L .25 g
F P
0 g
s
.44427 .36393 m .47887 .39849 L .46724 .38721 L .25 g
F
.46902 .38812 m .49188 .41218 L .45986 .37677 L F
.45986 .37677 m .45237 .3706 L p .46902 .38812 L F P
0 g
s
.45237 .3706 m .44427 .36393 L p .45325 .37302 L .25 g
F P
0 g
s
.46724 .38721 m .47887 .39849 L .49188 .41218 L .25 g
F
.45325 .37302 m .49188 .41218 L .45237 .3706 L F
.40709 .33556 m .44427 .36393 L .45452 .37237 L p .182 g
F P
0 g
s
.45452 .37237 m .47233 .38704 L p .44002 .36155 L .182 g
F P
0 g
s
.40709 .33556 m .45452 .37237 L .44002 .36155 L .182 g
F
.44821 .36236 m .42048 .34027 L .39147 .32531 L p .166 g
F P
0 g
s
.42815 .34929 m .40709 .33556 L p .44411 .36478 L .182 g
F P
0 g
s
.44411 .36478 m .47233 .38704 L .42815 .34929 L .182 g
F
.36439 .31133 m .40709 .33556 L .44821 .36236 L p .166 g
F P
0 g
s
.39147 .32531 m .36439 .31133 L p .40975 .33895 L .166 g
F P
0 g
s
.40975 .33895 m .44821 .36236 L .39147 .32531 L .166 g
F
.47233 .38704 m .49188 .41218 L .5117 .44819 L p .631 g
F P
0 g
s
.5117 .44819 m .50442 .43539 L .48768 .41016 L p .631 g
F P
0 g
s
.48768 .41016 m .47233 .38704 L p .49524 .42262 L .631 g
F P
0 g
s
.49524 .42262 m .5117 .44819 L .48768 .41016 L .631 g
F
.44821 .36236 m .47233 .38704 L .50442 .43539 L p .614 g
F P
0 g
s
.50442 .43539 m .49546 .42262 L .46943 .38943 L p .614 g
F P
0 g
s
.46943 .38943 m .44821 .36236 L p .47864 .4019 L .614 g
F P
0 g
s
.47864 .4019 m .50442 .43539 L .46943 .38943 L .614 g
F
.52019 .46856 m .5171 .45997 L p .52029 .46896 L .668 g
F P
0 g
s
.52325 .48092 m .5226 .47715 L p .52312 .48047 L .722 g
F P
0 g
s
.52066 .46985 m .5226 .47715 L .52271 .47782 L p .719 g
F P
0 g
s
.52271 .47782 m .52325 .48092 L p .52217 .4763 L .719 g
F P
0 g
s
.52066 .46985 m .52271 .47782 L .52217 .4763 L .719 g
F
.52279 .47837 m .52231 .47644 L p .52258 .47803 L F P
0 g
s
.52231 .47644 m .52123 .47213 L p .52219 .47632 L .719 g
F P
0 g
s
.52219 .47632 m .52258 .47803 L .52231 .47644 L .719 g
F
.52123 .47213 m .52066 .46985 L p .52206 .47583 L F P
0 g
s
.52206 .47583 m .52325 .48092 L .52123 .47213 L .719 g
F
.52029 .46896 m .52066 .46985 L .52019 .46856 L .668 g
F
.51931 .46666 m .51962 .46871 L p .5195 .46711 L .385 g
F P
0 g
s
.5171 .45997 m .52066 .46985 L .52173 .47412 L p .71 g
F P
0 g
s
.5171 .45997 m .52173 .47412 L .52086 .47213 L .71 g
F
.52173 .47412 m .52279 .47837 L p .52086 .47213 L F P
0 g
s
.52279 .47837 m .52194 .47489 L .52114 .47242 L p .71 g
F P
0 g
s
.52114 .47242 m .52026 .46971 L p .52102 .47229 L .71 g
F P
0 g
s
.52102 .47229 m .52279 .47837 L .52114 .47242 L .71 g
F
.52026 .46971 m .5171 .45997 L p .5204 .47064 L F P
0 g
s
.5204 .47064 m .52279 .47837 L .52026 .46971 L .71 g
F
.51025 .45745 m .51761 .46604 L .52093 .47659 L p .308 g
F P
0 g
s
.52268 .47978 m .52093 .47659 L .51761 .46604 L p .321 g
F P
0 g
s
.51962 .46871 m .51094 .45254 L .51498 .46316 L p .423 g
F P
0 g
s
.51498 .46316 m .52086 .47351 L .51962 .46871 L p .423 g
F P
0 g
s
.5117 .44819 m .5171 .45997 L .52194 .47489 L p .699 g
F P
0 g
s
.52194 .47489 m .52066 .47069 L .51536 .45737 L p .699 g
F P
0 g
s
.51536 .45737 m .5117 .44819 L p .51738 .46299 L .699 g
F P
0 g
s
.51738 .46299 m .52194 .47489 L .51536 .45737 L .699 g
F
.50978 .4468 m .5114 .45014 L p .51179 .45083 L .136 g
F P
0 g
s
.49898 .43135 m .50978 .4468 L p .49979 .43179 L .305 g
F P
0 g
s
.50978 .4468 m .49251 .42209 L .49515 .4327 L p .456 g
F P
0 g
s
.49515 .4327 m .51094 .45254 L .50978 .4468 L p .456 g
F P
0 g
s
.50442 .43539 m .5117 .44819 L .52066 .47069 L p .688 g
F P
0 g
s
.52066 .47069 m .51894 .46609 L .51005 .4473 L p .688 g
F P
0 g
s
.51005 .4473 m .50442 .43539 L p .51273 .45344 L .688 g
F P
0 g
s
.51273 .45344 m .52066 .47069 L .51005 .4473 L .688 g
F
.51275 .40592 m .51707 .44797 L p .51784 .4468 L .753 g
F P
0 g
s
.51707 .44797 m .51894 .46609 L p .51844 .45725 L .753 g
F P
0 g
s
.51844 .45725 m .51784 .4468 L .51707 .44797 L .753 g
F
.51784 .4468 m .51652 .42347 L .51275 .40592 L F
.5191 .45708 m .52211 .46944 L .52151 .47078 L p .353 g
F P
0 g
s
.52211 .46944 m .5191 .45708 L .52217 .4592 L p .491 g
F P
0 g
s
.51947 .45706 m .52066 .47069 L p .52043 .4641 L .739 g
F P
0 g
s
.52043 .4641 m .51971 .44408 L .51947 .45706 L .739 g
F
.5232 .47952 m .52151 .47078 L .52211 .46944 L p .388 g
F P
0 g
s
.52211 .46944 m .52328 .4791 L .5232 .47952 L p .388 g
F P
0 g
s
.52328 .4791 m .52211 .46944 L .52306 .47048 L p .583 g
F P
0 g
s
.52194 .47489 m .52279 .47837 L .52232 .47002 L p .728 g
F P
0 g
s
.52217 .4592 m .52306 .47048 L .52211 .46944 L p .491 g
F P
0 g
s
.52232 .47002 m .52181 .46103 L p .52184 .46439 L .728 g
F P
0 g
s
.52194 .47489 m .52232 .47002 L .52184 .46439 L .728 g
F
.52325 .48092 m .52298 .47943 L p .52258 .47803 L .719 g
F P
0 g
s
.52298 .47943 m .52279 .47837 L p .52258 .47803 L .719 g
F P
0 g
s
.52317 .48079 m .52334 .48155 L .52333 .48181 L .722 g
F
.52312 .48047 m .52336 .48204 L .52327 .48112 L F
.52336 .48204 m .52341 .48236 L .52335 .48179 L F
.52336 .48204 m .52335 .48179 L .52327 .48112 L F
.52342 .48243 m .52342 .48236 L p .52341 .48236 L F P
0 g
s
.52342 .48236 m .52327 .48112 L p .52341 .48236 L .722 g
F P
0 g
s
.51971 .44408 m .52194 .47489 L p .52186 .46592 L .728 g
F P
0 g
s
.52181 .46103 m .52106 .45495 L p .52186 .46592 L .728 g
F P
0 g
s
.52106 .45495 m .51971 .44408 L p .52186 .46592 L .728 g
F P
0 g
s
.52327 .48112 m .52325 .48092 L p .52312 .48047 L .722 g
F P
0 g
s
.52341 .48258 m .52345 .48291 L .52341 .48262 L p .043 g
F P
0 g
s
.49251 .42209 m .49898 .43135 L p .49979 .43179 L .305 g
F P
0 g
s
.46644 .39468 m .48125 .41025 L p .48156 .40853 L .421 g
F P
0 g
s
.48125 .41025 m .49251 .42209 L p .48156 .40853 L .421 g
F P
0 g
s
.43156 .36733 m .45892 .38878 L p .45681 .38293 L .509 g
F P
0 g
s
.45892 .38878 m .46644 .39468 L p .45681 .38293 L .509 g
F P
0 g
s
.51041 .67243 m .50593 .70822 L .4643 .72036 L p .763 g
F P
0 g
s
.50593 .70822 m .51041 .67243 L .5349 .62346 L p .809 g
F P
0 g
s
.5349 .62346 m .5389 .65053 L .50593 .70822 L p .809 g
F P
0 g
s
.56854 .42068 m .59604 .40305 L .56246 .43323 L p .1 g
F P
0 g
s
.58065 .42253 m .56246 .43323 L .59604 .40305 L p .1 g
F P
0 g
s
.46662 .42747 m .48813 .43841 L .47137 .41155 L p .528 g
F P
0 g
s
.48813 .43841 m .46662 .42747 L .50424 .46551 L p .475 g
F P
0 g
s
.49533 .46381 m .50424 .46551 L .46662 .42747 L p .499 g
F P
0 g
s
.47942 .68317 m .4643 .72036 L .43725 .68566 L p .661 g
F P
0 g
s
.4643 .72036 m .47942 .68317 L .51041 .67243 L p .763 g
F P
0 g
s
.44643 .48287 m .4406 .49108 L .45025 .50104 L p .802 g
F P
0 g
s
.53324 .45866 m .54551 .44544 L .55284 .43474 L p .865 g
F P
0 g
s
.55284 .43474 m .53649 .45245 L .53324 .45866 L p .865 g
F P
0 g
s
.53649 .45245 m .55284 .43474 L .55394 .43194 L p .837 g
F P
0 g
s
.49251 .42209 m .46644 .39468 L .47137 .41155 L p .51 g
F P
0 g
s
.47137 .41155 m .49515 .4327 L .49251 .42209 L p .51 g
F P
0 g
s
.49515 .4327 m .47137 .41155 L .48813 .43841 L p .492 g
F P
0 g
s
.78638 .38842 m .81872 .40562 L .68295 .41865 L p .384 g
F P
0 g
s
.68295 .41865 m .66571 .41118 L .78638 .38842 L p .384 g
F P
0 g
s
.87828 .64952 m .84537 .66772 L .86477 .62516 L p .925 g
F P
0 g
s
.86477 .62516 m .90071 .60292 L .87828 .64952 L p .925 g
F P
0 g
s
.54464 .45501 m .53498 .46105 L .52529 .47855 L p .71 g
F P
0 g
s
.36439 .31133 m .31829 .29358 L .28755 .31192 L p .715 g
F P
0 g
s
.2346 .30923 m .28755 .31192 L .31829 .29358 L p .779 g
F P
0 g
s
.52606 .45748 m .52461 .46528 L .52217 .4592 L p .512 g
F P
0 g
s
.52855 .46847 m .53498 .46105 L .54551 .44544 L p .761 g
F P
0 g
s
.54551 .44544 m .53324 .45866 L .52855 .46847 L p .761 g
F P
0 g
s
.4406 .49108 m .43744 .49962 L .44748 .5099 L p .792 g
F P
0 g
s
.48019 .4718 m .4896 .46852 L .48525 .46384 L p .729 g
F P
0 g
s
.15372 .42406 m .1365 .45561 L .26706 .49775 L p .644 g
F P
0 g
s
.26525 .52078 m .26706 .49775 L .1365 .45561 L p .62 g
F P
0 g
s
.26706 .49775 m .26525 .52078 L .43722 .50782 L p .519 g
F P
0 g
s
.43722 .50782 m .43744 .49962 L .26706 .49775 L p .519 g
F P
0 g
s
.18454 .31644 m .14096 .33363 L .18237 .39729 L p .775 g
F P
0 g
s
.15372 .42406 m .18237 .39729 L .14096 .33363 L p .796 g
F P
0 g
s
.55394 .43194 m .53696 .45144 L .53649 .45245 L p .837 g
F P
0 g
s
.53696 .45144 m .55394 .43194 L .54794 .43924 L p .032 g
F P
0 g
s
.56854 .42068 m .54794 .43924 L .55394 .43194 L p F P
s
.54794 .43924 m .56854 .42068 L .54761 .44513 L p .112 g
F P
0 g
s
.56246 .43323 m .54761 .44513 L .56854 .42068 L p .1 g
F P
0 g
s
.61191 .60678 m .63023 .61408 L .54054 .51331 L p .663 g
F P
0 g
s
.63023 .61408 m .61191 .60678 L .69474 .66273 L p .448 g
F P
0 g
s
.69474 .66273 m .72975 .66992 L .63023 .61408 L p .448 g
F P
0 g
s
.48813 .43841 m .50427 .45089 L .49515 .4327 L p .492 g
F P
0 g
s
.50427 .45089 m .48813 .43841 L .51155 .46852 L p .448 g
F P
0 g
s
.50424 .46551 m .51155 .46852 L .48813 .43841 L p .475 g
F P
0 g
s
.4896 .46852 m .49851 .46726 L .49533 .46381 L p .677 g
F P
0 g
s
.43744 .49962 m .43722 .50782 L .44728 .51807 L p .745 g
F P
0 g
s
.5389 .65053 m .5349 .62346 L .53839 .54717 L p .803 g
F P
0 g
s
.53839 .54717 m .54371 .55974 L .5389 .65053 L p .803 g
F P
0 g
s
.93404 .53862 m .92432 .57322 L .85159 .51415 L p .73 g
F P
0 g
s
.85159 .51415 m .86057 .4851 L .93404 .53862 L p .73 g
F P
0 g
s
.52093 .47659 m .51773 .4731 L .51025 .45745 L p .308 g
F P
0 g
s
.51094 .45254 m .49515 .4327 L .50427 .45089 L p .455 g
F P
0 g
s
.52306 .47048 m .52217 .4592 L .52461 .46528 L p .597 g
F P
0 g
s
.81872 .40562 m .84314 .42861 L .6957 .42996 L p .459 g
F P
0 g
s
.6957 .42996 m .68295 .41865 L .81872 .40562 L p .459 g
F P
0 g
s
.75557 .67235 m .80339 .67554 L .72975 .66992 L p .022 g
F P
0 g
s
.72975 .66992 m .69474 .66273 L .75557 .67235 L p .022 g
F P
0 g
s
.49851 .46726 m .50641 .46786 L .50424 .46551 L p .591 g
F P
0 g
s
.42183 .62907 m .4435 .61413 L .43725 .68566 L p .493 g
F P
0 g
s
.45948 .65431 m .43725 .68566 L .4435 .61413 L p .532 g
F P
0 g
s
.43725 .68566 m .45948 .65431 L .47942 .68317 L p .661 g
F P
0 g
s
.31829 .29358 m .27146 .28425 L .2346 .30923 L p .779 g
F P
0 g
s
.18454 .31644 m .2346 .30923 L .27146 .28425 L p .836 g
F P
0 g
s
.53498 .46105 m .52855 .46847 L .52426 .47998 L p .708 g
F P
0 g
s
.54794 .43924 m .53428 .45656 L .53696 .45144 L p .032 g
F P
0 g
s
.53428 .45656 m .54794 .43924 L .53653 .45698 L p .159 g
F P
0 g
s
.54761 .44513 m .53653 .45698 L .54794 .43924 L p .112 g
F P
0 g
s
.52746 .4681 m .53649 .45245 L .53696 .45144 L p F P
s
.1365 .45561 m .13242 .48957 L .26525 .52078 L p .62 g
F P
0 g
s
.27239 .54229 m .26525 .52078 L .13242 .48957 L p .575 g
F P
0 g
s
.26525 .52078 m .27239 .54229 L .43998 .515 L p .49 g
F P
0 g
s
.43998 .515 m .43722 .50782 L .26525 .52078 L p .49 g
F P
0 g
s
.50427 .45089 m .51498 .46316 L .51094 .45254 L p .455 g
F P
0 g
s
.51498 .46316 m .50427 .45089 L .51701 .47231 L p .422 g
F P
0 g
s
.51155 .46852 m .51701 .47231 L .50427 .45089 L p .448 g
F P
0 g
s
.51155 .46852 m .50424 .46551 L .50641 .46786 L p .445 g
F P
0 g
s
.50641 .46786 m .51288 .46998 L .51155 .46852 L p .445 g
F P
0 g
s
.53696 .45144 m .5276 .46792 L .52746 .4681 L p F P
s
.5276 .46792 m .53696 .45144 L .53428 .45656 L p .104 g
F P
0 g
s
.52461 .46528 m .52381 .47369 L .52306 .47048 L p .597 g
F P
0 g
s
.52381 .47369 m .52461 .46528 L .52495 .47455 L p .653 g
F P
0 g
s
.52345 .48291 m .56246 .43323 L .58065 .42253 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .58065 .42253 L .60135 .41416 L closepath p .469 g
F P
0 g
s
.51447 .63219 m .51041 .67243 L .47942 .68317 L p .736 g
F P
0 g
s
.51041 .67243 m .51447 .63219 L .53129 .59337 L p .77 g
F P
0 g
s
.53129 .59337 m .5349 .62346 L .51041 .67243 L p .77 g
F P
0 g
s
.31829 .29358 m .36439 .31133 L .42048 .34027 L p .171 g
F P
0 g
s
.59295 .59409 m .61191 .60678 L .53752 .51116 L p .664 g
F P
0 g
s
.61191 .60678 m .59295 .59409 L .65821 .64678 L p .406 g
F P
0 g
s
.65821 .64678 m .69474 .66273 L .61191 .60678 L p .406 g
F P
0 g
s
.52345 .48291 m .60135 .41416 L .62338 .40908 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .54761 .44513 L .56246 .43323 L closepath p .469 g
F P
0 g
s
.14096 .33363 m .10734 .36004 L .15372 .42406 L p .796 g
F P
0 g
s
.1365 .45561 m .15372 .42406 L .10734 .36004 L p .802 g
F P
0 g
s
.49317 .64102 m .47942 .68317 L .45948 .65431 L p .664 g
F P
0 g
s
.47942 .68317 m .49317 .64102 L .51447 .63219 L p .736 g
F P
0 g
s
.84537 .66772 m .80339 .67554 L .81924 .63801 L p .86 g
F P
0 g
s
.81924 .63801 m .86477 .62516 L .84537 .66772 L p .86 g
F P
0 g
s
.52345 .48291 m .53653 .45698 L .54761 .44513 L closepath p .469 g
F P
0 g
s
.51701 .47231 m .51155 .46852 L .51288 .46998 L p .251 g
F P
0 g
s
.51288 .46998 m .51773 .4731 L .51701 .47231 L p .251 g
F P
0 g
s
.52345 .48291 m .62338 .40908 L .64534 .40797 L closepath p .469 g
F P
0 g
s
.53428 .45656 m .52677 .47062 L .5276 .46792 L p .104 g
F P
0 g
s
.52677 .47062 m .53428 .45656 L .52922 .46758 L p .244 g
F P
0 g
s
.53653 .45698 m .52922 .46758 L .53428 .45656 L p .159 g
F P
0 g
s
.5349 .62346 m .53129 .59337 L .53366 .53335 L p .771 g
F P
0 g
s
.53366 .53335 m .53839 .54717 L .5349 .62346 L p .771 g
F P
0 g
s
.52996 .45175 m .53821 .42821 L .5363 .41178 L p .545 g
F P
0 g
s
.5363 .41178 m .52911 .44266 L .52996 .45175 L p .545 g
F P
0 g
s
.54724 .37437 m .5363 .41178 L .53821 .42821 L p .562 g
F P
0 g
s
.52911 .44266 m .5363 .41178 L .53005 .40875 L p .654 g
F P
0 g
s
.5363 .41178 m .54724 .37437 L .53567 .36926 L p .67 g
F P
0 g
s
.53567 .36926 m .53005 .40875 L .5363 .41178 L p .67 g
F P
0 g
s
.52086 .47351 m .51498 .46316 L .52061 .47624 L p .401 g
F P
0 g
s
.51701 .47231 m .52061 .47624 L .51498 .46316 L p .422 g
F P
0 g
s
.53005 .40875 m .52636 .44112 L .52911 .44266 L p .654 g
F P
0 g
s
.52636 .44112 m .53005 .40875 L .52322 .42029 L p .719 g
F P
0 g
s
.53005 .40875 m .53567 .36926 L .52301 .38685 L p .734 g
F P
0 g
s
.52301 .38685 m .52322 .42029 L .53005 .40875 L p .734 g
F P
0 g
s
.52799 .46623 m .53376 .45389 L .53821 .42821 L p .431 g
F P
0 g
s
.53821 .42821 m .52996 .45175 L .52799 .46623 L p .431 g
F P
0 g
s
.55077 .40005 m .53821 .42821 L .53376 .45389 L p .444 g
F P
0 g
s
.53821 .42821 m .55077 .40005 L .54724 .37437 L p .562 g
F P
0 g
s
.53376 .45389 m .54252 .43938 L .55077 .40005 L p .444 g
F P
0 g
s
.56773 .36928 m .55077 .40005 L .54252 .43938 L p .448 g
F P
0 g
s
.55077 .40005 m .56773 .36928 L .56208 .33282 L p .571 g
F P
0 g
s
.56208 .33282 m .54724 .37437 L .55077 .40005 L p .571 g
F P
0 g
s
.84314 .42861 m .85756 .45579 L .70285 .44428 L p .518 g
F P
0 g
s
.70285 .44428 m .6957 .42996 L .84314 .42861 L p .518 g
F P
0 g
s
.52345 .48291 m .52922 .46758 L .53653 .45698 L closepath p .469 g
F P
0 g
s
.54724 .37437 m .56208 .33282 L .54331 .32505 L p .684 g
F P
0 g
s
.54331 .32505 m .53567 .36926 L .54724 .37437 L p .684 g
F P
0 g
s
.52306 .47048 m .5234 .47938 L .52328 .4791 L p .583 g
F P
0 g
s
.5234 .47938 m .52306 .47048 L .52381 .47369 L p .677 g
F P
0 g
s
.52544 .46916 m .52996 .45175 L .52911 .44266 L p .511 g
F P
0 g
s
.52911 .44266 m .52518 .46526 L .52544 .46916 L p .511 g
F P
0 g
s
.52518 .46526 m .52911 .44266 L .52636 .44112 L p .634 g
F P
0 g
s
.52636 .44112 m .52434 .46466 L .52518 .46526 L p .634 g
F P
0 g
s
.52434 .46466 m .52636 .44112 L .52335 .44768 L p .711 g
F P
0 g
s
.52322 .42029 m .52335 .44768 L .52636 .44112 L p .719 g
F P
0 g
s
.52335 .44768 m .52322 .42029 L .51971 .44408 L p .737 g
F P
0 g
s
.52322 .42029 m .52301 .38685 L .51652 .42347 L p .751 g
F P
0 g
s
.51652 .42347 m .51971 .44408 L .52322 .42029 L p .751 g
F P
0 g
s
.52061 .47624 m .51701 .47231 L .51773 .4731 L p .055 g
F P
0 g
s
.51773 .4731 m .52093 .47659 L .52061 .47624 L p .055 g
F P
0 g
s
.52484 .47548 m .52799 .46623 L .52996 .45175 L p .405 g
F P
0 g
s
.52996 .45175 m .52544 .46916 L .52484 .47548 L p .405 g
F P
0 g
s
.27239 .54229 m .28809 .56049 L .44552 .52059 L p .449 g
F P
0 g
s
.5276 .46792 m .52398 .47898 L .52396 .47896 L p .01 g
F P
0 g
s
.52345 .48291 m .64534 .40797 L .66571 .41118 L closepath p .469 g
F P
0 g
s
.52922 .46758 m .52521 .47589 L .52677 .47062 L p .244 g
F P
0 g
s
.52345 .48291 m .52521 .47589 L .52922 .46758 L closepath p .469 g
F P
0 g
s
.54252 .43938 m .53376 .45389 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.5543 .42387 m .54252 .43938 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.54252 .43938 m .5543 .42387 L .56773 .36928 L p .448 g
F P
0 g
s
.52495 .47455 m .52391 .47858 L .52381 .47369 L p .653 g
F P
0 g
s
.53567 .36926 m .54331 .32505 L .52273 .34941 L p .752 g
F P
0 g
s
.52273 .34941 m .52301 .38685 L .53567 .36926 L p .752 g
F P
0 g
s
.52335 .44768 m .52342 .46755 L .52434 .46466 L p .711 g
F P
0 g
s
.52342 .46755 m .52335 .44768 L .52181 .46103 L p .731 g
F P
0 g
s
.51971 .44408 m .52181 .46103 L .52335 .44768 L p .737 g
F P
0 g
s
.92432 .57322 m .90071 .60292 L .83111 .54049 L p .742 g
F P
0 g
s
.83111 .54049 m .85159 .51415 L .92432 .57322 L p .742 g
F P
0 g
s
.49546 .42262 m .50442 .43539 L .51894 .46609 L p .679 g
F P
0 g
s
.51682 .46145 m .49546 .42262 L p .51846 .4652 L .679 g
F P
0 g
s
.51894 .46609 m .51682 .46145 L p .51846 .4652 L .679 g
F P
0 g
s
.51682 .46145 m .50685 .37704 L p .51426 .45559 L .788 g
F P
0 g
s
.47288 .39383 m .49546 .42262 L p .48343 .40941 L .602 g
F P
0 g
s
.42048 .34027 m .47288 .39383 L .48343 .40941 L .602 g
F
.49546 .42262 m .48522 .41096 L .42048 .34027 L p F P
0 g
s
.48522 .41096 m .49546 .42262 L .51461 .45744 L p .672 g
F P
0 g
s
.51461 .45744 m .51682 .46145 L p .51231 .45424 L .672 g
F P
0 g
s
.48522 .41096 m .51461 .45744 L .51231 .45424 L .672 g
F
.51441 .45717 m .4955 .42723 L p .51629 .46059 L F P
0 g
s
.51682 .46145 m .51441 .45717 L p .51629 .46059 L .672 g
F P
0 g
s
.51441 .45717 m .50069 .35471 L p .51169 .45221 L .807 g
F P
0 g
s
.49424 .42538 m .51682 .46145 L .4955 .42723 L .672 g
F
.51035 .45155 m .48125 .41116 L p .51117 .45268 L .668 g
F P
0 g
s
.48647 .4184 m .51294 .45513 L .48125 .41116 L .668 g
F
.51294 .45513 m .51441 .45717 L .51293 .45511 L F
.51294 .45513 m .51293 .45511 L .48125 .41116 L F
.50793 .44948 m .50667 .44794 L p .50877 .44991 L .666 g
F P
0 g
s
.50562 .44667 m .46331 .39504 L p .50626 .44689 L .666 g
F P
0 g
s
.4955 .42723 m .48522 .41096 L p .49424 .42538 L .672 g
F P
0 g
s
.47427 .40147 m .48522 .41096 L .51441 .45717 L p .668 g
F P
0 g
s
.46331 .39504 m .47427 .40147 L .51185 .45364 L p .666 g
F P
0 g
s
.50698 .45002 m .50582 .44878 L p .50821 .45041 L .667 g
F P
0 g
s
.50582 .44878 m .50544 .44837 L p .5066 .44832 L .667 g
F P
0 g
s
.50421 .44705 m .50387 .44669 L p .50479 .44643 L .667 g
F P
0 g
s
.50287 .45516 m .50228 .45476 L p .50297 .45339 L .68 g
F P
0 g
s
.51173 .48326 m .47286 .4895 L p .50854 .47955 L .734 g
F P
0 g
s
.50918 .47937 m .51173 .48326 L p .50854 .47955 L .734 g
F P
0 g
s
.51173 .48326 m .51431 .48613 L .48414 .49689 L p .745 g
F P
0 g
s
.48414 .49689 m .47286 .4895 L .51173 .48326 L p .745 g
F P
0 g
s
.50684 .47467 m .50918 .47937 L .5084 .47936 L p .723 g
F P
0 g
s
.5084 .47936 m .46167 .47893 L p .5047 .47487 L .723 g
F P
0 g
s
.5047 .47487 m .50684 .47467 L .5084 .47936 L .723 g
F
.51173 .48326 m .51158 .48323 L p .51414 .48607 L .417 g
F P
0 g
s
.47286 .4895 m .46167 .47893 L .5084 .47936 L p .734 g
F P
0 g
s
.5084 .47936 m .50918 .47937 L p .50854 .47955 L .734 g
F P
0 g
s
.47286 .4895 m .5084 .47936 L .50854 .47955 L .734 g
F
.51158 .48323 m .51136 .48318 L p .51385 .48597 L .417 g
F P
0 g
s
.51136 .48318 m .49532 .47956 L p .51342 .48583 L .417 g
F P
0 g
s
.51342 .48583 m .49532 .47956 L .49553 .47991 L .417 g
F
.51385 .48597 m .51136 .48318 L .51342 .48583 L F
.51414 .48607 m .51158 .48323 L .51385 .48597 L F
.51431 .48613 m .51173 .48326 L p .51414 .48607 L F P
0 g
s
.52312 .48045 m .52086 .47351 L .52258 .47968 L p .398 g
F P
0 g
s
.52258 .47968 m .52061 .47624 L .52093 .47659 L p .433 g
F P
0 g
s
.52093 .47659 m .52268 .47978 L .52258 .47968 L p .433 g
F P
0 g
s
.52061 .47624 m .52258 .47968 L .52086 .47351 L p .401 g
F P
0 g
s
.52278 .48579 m .52193 .48718 L .51961 .50281 L p .532 g
F P
0 g
s
.52148 .49908 m .51697 .51986 L .51751 .50752 L p .601 g
F P
0 g
s
.51697 .51986 m .52148 .49908 L .52208 .50142 L p .639 g
F P
0 g
s
.51175 .50814 m .51629 .50725 L .52064 .48819 L p .492 g
F P
0 g
s
.51148 .49995 m .50399 .50176 L .51889 .4885 L p .782 g
F P
0 g
s
.43655 .56688 m .46433 .55259 L .50395 .50996 L p .064 g
F P
0 g
s
.50399 .50176 m .51148 .49995 L .49071 .52388 L p .766 g
F P
0 g
s
.50592 .51402 m .49071 .52388 L .51148 .49995 L p .787 g
F P
0 g
s
.50611 .50418 m .51175 .50814 L .51889 .4885 L p .46 g
F P
0 g
s
.51675 .48787 m .51889 .4885 L .50399 .50176 L p .769 g
F P
0 g
s
.51889 .4885 m .51675 .48787 L .50611 .50418 L p .46 g
F P
0 g
s
.52208 .50142 m .52327 .48734 L .5234 .48705 L p .622 g
F P
0 g
s
.5234 .48705 m .52304 .50023 L .52208 .50142 L p .622 g
F P
0 g
s
.52211 .52281 m .52304 .50023 L .5238 .49572 L p .649 g
F P
0 g
s
.5238 .49572 m .5246 .51239 L .52211 .52281 L p .649 g
F P
0 g
s
.51897 .52544 m .52208 .50142 L .52304 .50023 L p .649 g
F P
0 g
s
.52304 .50023 m .52211 .52281 L .51897 .52544 L p .649 g
F P
0 g
s
.52208 .50142 m .51897 .52544 L .51697 .51986 L p .639 g
F P
0 g
s
.52177 .49644 m .51961 .50281 L .52316 .51474 L p .432 g
F P
0 g
s
.51431 .48613 m .51675 .48787 L .49473 .50091 L p .757 g
F P
0 g
s
.50399 .50176 m .49473 .50091 L .51675 .48787 L p .769 g
F P
0 g
s
.49473 .50091 m .48414 .49689 L .51431 .48613 L p .757 g
F P
0 g
s
.49959 .49452 m .50611 .50418 L .51675 .48787 L p .436 g
F P
0 g
s
.51675 .48787 m .51431 .48613 L .49959 .49452 L p .436 g
F P
0 g
s
.49258 .47894 m .49959 .49452 L .51431 .48613 L p .417 g
F P
0 g
s
.52117 .47281 m .52168 .49961 L .50486 .49574 L p .285 g
F P
0 g
s
.50486 .49574 m .49959 .49452 L p .50245 .49165 L .285 g
F P
0 g
s
.51173 .48326 m .50918 .47937 L .50902 .47923 L p .413 g
F P
0 g
s
.5061 .47455 m .45145 .46579 L p .50286 .46936 L .713 g
F P
0 g
s
.46167 .47893 m .45145 .46579 L .5061 .47455 L p .723 g
F P
0 g
s
.5061 .47455 m .50684 .47467 L p .50621 .47473 L .723 g
F P
0 g
s
.46167 .47893 m .5061 .47455 L .50621 .47473 L .723 g
F
.50902 .47923 m .50883 .47906 L p .51125 .4828 L .413 g
F P
0 g
s
.50491 .4695 m .50252 .46878 L p .50333 .46518 L .703 g
F P
0 g
s
.50491 .4695 m .50684 .47467 L p .50429 .46946 L .713 g
F P
0 g
s
.45145 .46579 m .44303 .451 L .50252 .46878 L p .713 g
F P
0 g
s
.50252 .46878 m .50491 .4695 L p .50286 .46936 L .713 g
F P
0 g
s
.45145 .46579 m .50252 .46878 L .50286 .46936 L .713 g
F
.50874 .47897 m .50849 .47875 L p .51081 .48237 L .413 g
F P
0 g
s
.50252 .46878 m .44303 .451 L p .49916 .46329 L .703 g
F P
0 g
s
.50849 .47875 m .49059 .46248 L p .51045 .48201 L .413 g
F P
0 g
s
.51081 .48237 m .50849 .47875 L .51045 .48201 L .413 g
F
.50491 .4695 m .50389 .46738 L p .50643 .47367 L .476 g
F P
0 g
s
.50684 .47467 m .50491 .4695 L p .50643 .47367 L .476 g
F P
0 g
s
.50354 .46424 m .50491 .4695 L p .50333 .46518 L .703 g
F P
0 g
s
.49916 .46329 m .50354 .46424 L .50252 .46878 L .703 g
F
.50883 .47906 m .50874 .47897 L p .51087 .48243 L .413 g
F P
0 g
s
.51087 .48243 m .50874 .47897 L .51081 .48237 L .413 g
F
.51125 .4828 m .50883 .47906 L .51087 .48243 L F
.44303 .451 m .43712 .43573 L .50354 .46424 L p .703 g
F P
0 g
s
.49059 .46248 m .48559 .45793 L p .49092 .4631 L .413 g
F P
0 g
s
.51125 .4828 m .49059 .46248 L .49092 .4631 L .413 g
F
.50245 .49165 m .50488 .4892 L .50486 .49574 L .285 g
F
.51173 .48326 m .50902 .47923 L .51125 .4828 L .413 g
F
.48559 .45793 m .49258 .47894 L .51173 .48326 L p F P
0 g
s
.50488 .4892 m .52117 .47281 L .50686 .49292 L .285 g
F
.50488 .4892 m .50686 .49292 L .50486 .49574 L F
.49532 .47956 m .49258 .47894 L p .49553 .47991 L .417 g
F P
0 g
s
.50684 .47467 m .5061 .47455 L p .50429 .46946 L .713 g
F P
0 g
s
.50286 .46936 m .50429 .46946 L .5061 .47455 L .713 g
F
.50684 .47467 m .50519 .47217 L p .50882 .47873 L .431 g
F P
0 g
s
.50918 .47937 m .50684 .47467 L p .50882 .47873 L .431 g
F P
0 g
s
.4988 .4524 m .49508 .44987 L p .49811 .45038 L .68 g
F P
0 g
s
.49508 .44987 m .43459 .40882 L p .49309 .44547 L .68 g
F P
0 g
s
.49309 .44547 m .50012 .44988 L .49508 .44987 L .68 g
F
.50012 .44988 m .50193 .45101 L .50031 .45074 L F
.50012 .44988 m .50031 .45074 L .49508 .44987 L F
.50354 .46424 m .43712 .43573 L p .50226 .45912 L .694 g
F P
0 g
s
.50284 .45933 m .50354 .46424 L p .50226 .45912 L .694 g
F P
0 g
s
.50354 .46424 m .50302 .46289 L p .50445 .46791 L .545 g
F P
0 g
s
.50491 .4695 m .50354 .46424 L p .50445 .46791 L .545 g
F P
0 g
s
.50228 .45476 m .4988 .4524 L p .50193 .45101 L .68 g
F P
0 g
s
.49811 .45038 m .50193 .45101 L .4988 .4524 L .68 g
F
.50159 .44425 m .49822 .44064 L p .50176 .44326 L .667 g
F P
0 g
s
.43712 .43573 m .43424 .42126 L .50284 .45933 L p .694 g
F P
0 g
s
.50389 .46738 m .49907 .45739 L p .50516 .47113 L .476 g
F P
0 g
s
.49299 .43505 m .45311 .39236 L p .49263 .43371 L .667 g
F P
0 g
s
.45311 .39236 m .46331 .39504 L .50469 .44553 L p .667 g
F P
0 g
s
.45311 .39236 m .50469 .44553 L .50469 .44565 L .667 g
F
.45311 .39236 m .50538 .44637 L .5054 .44707 L F
.48125 .41116 m .47427 .40147 L p .48647 .4184 L .668 g
F P
0 g
s
.42048 .34027 m .44821 .36236 L .47288 .39383 L p .602 g
F P
0 g
s
.42048 .34027 m .39056 .32277 L .31829 .29358 L p .171 g
F P
0 g
s
.39056 .32277 m .42048 .34027 L .48522 .41096 L p .594 g
F P
0 g
s
.48522 .41096 m .47427 .40147 L .39056 .32277 L p .594 g
F P
0 g
s
.50503 .45032 m .50398 .44934 L p .50596 .44979 L .67 g
F P
0 g
s
.50398 .44934 m .50341 .4488 L p .50428 .44759 L .67 g
F P
0 g
s
.50341 .4488 m .44448 .39382 L p .50385 .4472 L .67 g
F P
0 g
s
.50385 .4472 m .50428 .44759 L .50341 .4488 L .67 g
F
.49822 .44064 m .49299 .43505 L p .4981 .43943 L .667 g
F P
0 g
s
.49263 .43371 m .4981 .43943 L .49299 .43505 L .667 g
F
.44448 .39382 m .45311 .39236 L .50428 .44713 L p .67 g
F P
0 g
s
.50428 .44713 m .50698 .45002 L p .50428 .44759 L .67 g
F P
0 g
s
.44448 .39382 m .50428 .44713 L .50428 .44759 L .67 g
F
.5046 .46867 m .50446 .4683 L .5046 .46885 L .545 g
F
.50284 .45933 m .43424 .42126 L p .5023 .45488 L .686 g
F P
0 g
s
.50287 .45516 m .50284 .45933 L p .5023 .45488 L .686 g
F P
0 g
s
.50284 .45933 m .50266 .45879 L p .50311 .46157 L .637 g
F P
0 g
s
.50354 .46424 m .50284 .45933 L p .50311 .46157 L .637 g
F P
0 g
s
.43424 .42126 m .43459 .40882 L .50228 .45476 L p .686 g
F P
0 g
s
.50228 .45476 m .50287 .45516 L p .5023 .45488 L .686 g
F P
0 g
s
.43424 .42126 m .50228 .45476 L .5023 .45488 L .686 g
F
.50337 .4637 m .50034 .45157 L .50007 .45318 L .637 g
F
.50354 .46424 m .50334 .46345 L .50337 .4637 L F
.50334 .46345 m .50034 .45157 L .50337 .4637 L F
.50287 .45516 m .50268 .4545 L p .50269 .45833 L .73 g
F P
0 g
s
.50306 .45162 m .43812 .39942 L p .5034 .44907 L .674 g
F P
0 g
s
.50193 .45101 m .50362 .45207 L .50228 .45476 L .68 g
F
.43459 .40882 m .43812 .39942 L .50328 .4518 L p F P
0 g
s
.50328 .4518 m .50362 .45207 L p .50328 .45186 L .68 g
F P
0 g
s
.43459 .40882 m .50328 .4518 L .50328 .45186 L .68 g
F
.43812 .39942 m .44448 .39382 L .50476 .45006 L p .674 g
F P
0 g
s
.50476 .45006 m .50503 .45032 L p .50476 .45011 L .674 g
F P
0 g
s
.43812 .39942 m .50476 .45006 L .50476 .45011 L .674 g
F
.47391 .40524 m .47918 .43274 L .50577 .47305 L p .476 g
F P
0 g
s
.50577 .47305 m .50592 .47328 L p .50577 .47295 L .476 g
F P
0 g
s
.50577 .47295 m .47391 .40524 L .50577 .47305 L .476 g
F
.46854 .35266 m .47025 .37774 L .50337 .46381 L p .637 g
F P
0 g
s
.50337 .46381 m .50354 .46424 L p .50337 .46371 L .637 g
F P
0 g
s
.50337 .46371 m .46854 .35266 L .50337 .46381 L .637 g
F
.50268 .4545 m .50145 .45004 L p .50242 .45652 L .73 g
F P
0 g
s
.50269 .45833 m .50268 .4545 L .50242 .45652 L .73 g
F
.50362 .45207 m .50306 .45162 L p .50398 .44952 L .674 g
F P
0 g
s
.5034 .44907 m .50398 .44952 L .50306 .45162 L .674 g
F
.50503 .45032 m .50385 .45179 L p .50398 .44952 L F P
0 g
s
.50385 .45179 m .50362 .45207 L p .50398 .44952 L .674 g
F P
0 g
s
.50446 .4683 m .50309 .46469 L .50446 .46848 L .545 g
F
.50309 .46469 m .47025 .37774 L .50308 .46484 L F
.50309 .46469 m .50308 .46484 L .50446 .46848 L F
.50446 .4683 m .50446 .46848 L .5046 .46885 L F
.46891 .33224 m .46854 .35266 L .50158 .45542 L p .73 g
F P
0 g
s
.50158 .45542 m .50284 .45933 L p .50169 .45503 L .73 g
F P
0 g
s
.50169 .45503 m .46891 .33224 L .50158 .45542 L .73 g
F
.50428 .44759 m .50698 .45002 L .50398 .44934 L .67 g
F
.50387 .44669 m .50159 .44425 L p .50438 .446 L .667 g
F P
0 g
s
.50176 .44326 m .50438 .446 L .50159 .44425 L .667 g
F
.50438 .446 m .50479 .44643 L .50387 .44669 L F
.50544 .44837 m .50421 .44705 L p .50632 .44803 L F P
0 g
s
.50479 .44643 m .50632 .44803 L .50421 .44705 L .667 g
F
.50503 .45032 m .47542 .31154 L p .50345 .45122 L .836 g
F P
0 g
s
.50362 .45207 m .50503 .45032 L p .50345 .45122 L .836 g
F P
0 g
s
.50698 .45002 m .50503 .45032 L p .50596 .44979 L .67 g
F P
0 g
s
.47427 .40147 m .46331 .39504 L .37379 .32257 L p .592 g
F P
0 g
s
.27146 .28425 m .31829 .29358 L .37241 .31544 L p .208 g
F P
0 g
s
.27146 .28425 m .37241 .31544 L .37271 .317 L .208 g
F
.37241 .31544 m .39056 .32277 L p .37271 .317 L F P
0 g
s
.39056 .32277 m .36026 .31162 L .27146 .28425 L p .208 g
F P
0 g
s
.37379 .32257 m .36026 .31162 L p .37372 .32223 L .592 g
F P
0 g
s
.37372 .32223 m .47427 .40147 L .37379 .32257 L .592 g
F
.36026 .31162 m .39056 .32277 L .47427 .40147 L p F P
0 g
s
.47025 .37774 m .47391 .40524 L .50164 .46272 L p .545 g
F P
0 g
s
.50164 .46272 m .5046 .46885 L p .50184 .46155 L .545 g
F P
0 g
s
.50184 .46155 m .47025 .37774 L .50164 .46272 L .545 g
F
.5046 .46885 m .50491 .4695 L p .5046 .46867 L F P
0 g
s
.50469 .44553 m .50538 .44637 L p .50469 .44565 L .667 g
F P
0 g
s
.50538 .44637 m .50932 .45117 L p .5054 .44707 L .667 g
F P
0 g
s
.50592 .47328 m .50684 .47467 L p .50591 .47271 L .476 g
F P
0 g
s
.50591 .47271 m .47391 .40524 L .50592 .47328 L .476 g
F
.49907 .45739 m .4774 .41249 L p .49964 .45948 L F P
0 g
s
.49964 .45948 m .4774 .41249 L .47756 .41294 L .476 g
F
.4981 .43943 m .50176 .44326 L .49822 .44064 L .667 g
F
.49959 .45399 m .47255 .38372 L p .49979 .45596 L .545 g
F P
0 g
s
.47255 .38372 m .47025 .37774 L p .47262 .38402 L .545 g
F P
0 g
s
.49979 .45596 m .47255 .38372 L .47262 .38402 L .545 g
F
.50034 .45157 m .46854 .35266 L p .50007 .45318 L .637 g
F P
0 g
s
.50145 .45004 m .46891 .33224 L p .50065 .45114 L .73 g
F P
0 g
s
.47129 .31818 m .46891 .33224 L .50145 .45004 L p .799 g
F P
0 g
s
.50164 .44984 m .47129 .31818 L .50145 .45004 L .799 g
F
.50296 .44933 m .47129 .31818 L p .50164 .44984 L F P
0 g
s
.50632 .44803 m .5066 .44832 L .50544 .44837 L .667 g
F
.5066 .44832 m .50932 .45117 L .50582 .44878 L F
.50667 .44794 m .50562 .44667 L p .5074 .44826 L .666 g
F P
0 g
s
.50626 .44689 m .5074 .44826 L .50562 .44667 L .666 g
F
.50698 .45002 m .48091 .31258 L p .50486 .44934 L .846 g
F P
0 g
s
.47542 .31154 m .47129 .31818 L .50201 .44542 L p .836 g
F P
0 g
s
.50231 .44552 m .47542 .31154 L .50201 .44542 L .836 g
F
.48091 .31258 m .47542 .31154 L .5043 .44691 L p .846 g
F P
0 g
s
.50444 .44697 m .48091 .31258 L .5043 .44691 L .846 g
F
.48727 .32088 m .48091 .31258 L .50676 .44887 L p .84 g
F P
0 g
s
.50681 .4489 m .48727 .32088 L .50676 .44887 L .84 g
F
.50909 .44981 m .48727 .32088 L p .50638 .44608 L F P
0 g
s
.49403 .33541 m .48727 .32088 L .50909 .44981 L p .825 g
F P
0 g
s
.50915 .4499 m .49403 .33541 L .50909 .44981 L .825 g
F
.51185 .45364 m .51035 .45155 L p .51387 .45642 L .668 g
F P
0 g
s
.51117 .45268 m .51387 .45642 L .51035 .45155 L .668 g
F
.51185 .45364 m .49403 .33541 L p .50915 .4499 L .825 g
F P
0 g
s
.52301 .38685 m .52273 .34941 L .5122 .40057 L p .77 g
F P
0 g
s
.5122 .40057 m .51652 .42347 L .52301 .38685 L p .77 g
F P
0 g
s
.51682 .46145 m .51894 .46609 L .5122 .40057 L p .77 g
F P
0 g
s
.50685 .37704 m .5122 .40057 L .52273 .34941 L p .794 g
F P
0 g
s
.5122 .40057 m .50685 .37704 L .51682 .46145 L p .77 g
F P
0 g
s
.52273 .34941 m .52236 .31047 L .50685 .37704 L p .794 g
F P
0 g
s
.50685 .37704 m .50069 .35471 L .51441 .45717 L p .788 g
F P
0 g
s
.50069 .35471 m .49403 .33541 L .51185 .45364 L p .807 g
F P
0 g
s
.50069 .35471 m .50685 .37704 L .52236 .31047 L p .822 g
F P
0 g
s
.5198 .3452 m .52018 .3928 L .48329 .42873 L p .272 g
F P
0 g
s
.48329 .42873 m .47918 .43274 L p .48253 .42552 L .272 g
F P
0 g
s
.48253 .42552 m .5198 .3452 L .48329 .42873 L .272 g
F
.50519 .47217 m .4836 .43944 L p .50673 .47556 L .431 g
F P
0 g
s
.50673 .47556 m .4836 .43944 L .48373 .43972 L .431 g
F
.50673 .47556 m .48157 .43636 L .48169 .43664 L F
.50516 .47113 m .49907 .45739 L .49964 .45948 L .476 g
F
.50491 .4695 m .50302 .46289 L .50388 .46678 L .545 g
F
.50684 .47467 m .50389 .46738 L .50516 .47113 L .476 g
F
.50918 .47937 m .50519 .47217 L .50673 .47556 L .431 g
F
.51441 .45717 m .51185 .45364 L p .51387 .45642 L .668 g
F P
0 g
s
.51185 .45364 m .51441 .45717 L p .51169 .45221 L .807 g
F P
0 g
s
.51441 .45717 m .51682 .46145 L p .51426 .45559 L .788 g
F P
0 g
s
.52066 .47069 m .52194 .47489 L .51971 .44408 L p .739 g
F P
0 g
s
.51894 .46609 m .52066 .47069 L .51652 .42347 L p .753 g
F P
0 g
s
.47918 .43274 m .48559 .45793 L .50918 .47937 L p .431 g
F P
0 g
s
.52065 .43649 m .52117 .47281 L .50042 .47726 L p .32 g
F P
0 g
s
.50042 .47726 m .49258 .47894 L p .49771 .47118 L .32 g
F P
0 g
s
.50302 .46289 m .49959 .45399 L p .50388 .46678 L .545 g
F P
0 g
s
.50388 .46678 m .49959 .45399 L .49979 .45596 L .545 g
F
.50354 .46424 m .50266 .45879 L .50296 .46197 L .637 g
F
.50932 .45117 m .50793 .44948 L p .5113 .45297 L .666 g
F P
0 g
s
.50877 .44991 m .5113 .45297 L .50793 .44948 L .666 g
F
.51185 .45364 m .50932 .45117 L p .5113 .45297 L F P
0 g
s
.50932 .45117 m .51185 .45364 L p .50915 .4499 L .825 g
F P
0 g
s
.49771 .47118 m .52065 .43649 L .50042 .47726 L .32 g
F
.4836 .43944 m .48157 .43636 L p .48373 .43972 L .431 g
F P
0 g
s
.48157 .43636 m .47918 .43274 L p .48169 .43664 L .431 g
F P
0 g
s
.4917 .4542 m .48981 .45536 L p .49008 .44948 L .313 g
F P
0 g
s
.48981 .45536 m .48559 .45793 L p .48853 .45241 L .313 g
F P
0 g
s
.48853 .45241 m .49008 .44948 L .48981 .45536 L .313 g
F
.50201 .44542 m .50362 .45207 L p .50231 .44552 L .836 g
F P
0 g
s
.52018 .3928 m .52065 .43649 L .4917 .4542 L p .313 g
F P
0 g
s
.49008 .44948 m .52018 .3928 L .4917 .4542 L .313 g
F
.4774 .41249 m .47391 .40524 L p .47756 .41294 L .476 g
F P
0 g
s
.50284 .45933 m .50287 .45516 L p .50269 .45833 L .73 g
F P
0 g
s
.50362 .45207 m .50287 .45516 L p .50297 .45339 L .68 g
F P
0 g
s
.50266 .45879 m .50034 .45157 L p .50296 .46197 L .637 g
F P
0 g
s
.50284 .45933 m .50145 .45004 L .50065 .45114 L .73 g
F
.50145 .45004 m .50287 .45516 L p .50164 .44984 L .799 g
F P
0 g
s
.50287 .45516 m .50362 .45207 L .50296 .44933 L p .799 g
F P
0 g
s
.50287 .45516 m .50296 .44933 L .50164 .44984 L .799 g
F
.50503 .45032 m .50698 .45002 L p .50486 .44934 L .846 g
F P
0 g
s
.50932 .45117 m .50698 .45002 L p .50821 .45041 L .667 g
F P
0 g
s
.5043 .44691 m .50483 .44936 L p .50444 .44697 L .846 g
F P
0 g
s
.50483 .44936 m .50503 .45032 L p .50486 .44934 L .846 g
F P
0 g
s
.50486 .44934 m .50444 .44697 L .50483 .44936 L .846 g
F
.5074 .44826 m .50877 .44991 L .50667 .44794 L .666 g
F
.50676 .44887 m .50698 .45002 L p .50681 .4489 L .84 g
F P
0 g
s
.50932 .45117 m .50909 .44981 L p .50794 .44993 L .84 g
F P
0 g
s
.50698 .45002 m .50932 .45117 L p .50794 .44993 L .84 g
F P
0 g
s
.50698 .45002 m .50909 .44981 L .50638 .44608 L .84 g
F
.50909 .44981 m .50932 .45117 L p .50915 .4499 L .825 g
F P
0 g
s
.52381 .47369 m .5235 .4803 L .5234 .47938 L p .677 g
F P
0 g
s
.5235 .4803 m .52381 .47369 L .52391 .47858 L p .701 g
F P
0 g
s
.4435 .61413 m .46438 .59427 L .45948 .65431 L p .532 g
F P
0 g
s
.13242 .48957 m .14224 .52318 L .27239 .54229 L p .575 g
F P
0 g
s
.28809 .56049 m .27239 .54229 L .14224 .52318 L p .499 g
F P
0 g
s
.53376 .45389 m .52799 .46623 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.5688 .40868 m .5543 .42387 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.5543 .42387 m .5688 .40868 L .58875 .3382 L p .445 g
F P
0 g
s
.58875 .3382 m .56773 .36928 L .5543 .42387 L p .445 g
F P
0 g
s
.56773 .36928 m .58875 .3382 L .58058 .28997 L p .57 g
F P
0 g
s
.58058 .28997 m .56208 .33282 L .56773 .36928 L p .57 g
F P
0 g
s
.69474 .66273 m .65821 .64678 L .70572 .65872 L p .508 g
F P
0 g
s
.70572 .65872 m .75557 .67235 L .69474 .66273 L p .508 g
F P
0 g
s
.27146 .28425 m .22699 .2847 L .18454 .31644 L p .836 g
F P
0 g
s
.14096 .33363 m .18454 .31644 L .22699 .2847 L p .852 g
F P
0 g
s
.47955 .61862 m .45948 .65431 L .46438 .59427 L p .557 g
F P
0 g
s
.45948 .65431 m .47955 .61862 L .49317 .64102 L p .664 g
F P
0 g
s
.52677 .47062 m .52387 .47975 L .52398 .47898 L p .286 g
F P
0 g
s
.52387 .47975 m .52677 .47062 L .52521 .47589 L p .346 g
F P
0 g
s
.5237 .47956 m .52544 .46916 L .52518 .46526 L p .435 g
F P
0 g
s
.52518 .46526 m .52367 .47865 L .5237 .47956 L p .435 g
F P
0 g
s
.52367 .47865 m .52518 .46526 L .52434 .46466 L p .605 g
F P
0 g
s
.52434 .46466 m .52356 .47852 L .52367 .47865 L p .605 g
F P
0 g
s
.52356 .47852 m .52434 .46466 L .52342 .46755 L p .725 g
F P
0 g
s
.57473 .57725 m .59295 .59409 L .53445 .50791 L p .667 g
F P
0 g
s
.56545 .5671 m .57894 .58225 L p .55849 .55796 L .276 g
F P
0 g
s
.58485 .58661 m .57473 .57725 L .58303 .58526 L p .361 g
F P
0 g
s
.55849 .55796 m .57473 .57725 L .53154 .50387 L p .67 g
F P
0 g
s
.5914 .59625 m .62294 .62379 L .57473 .57725 L p .32 g
F P
0 g
s
.57473 .57725 m .56057 .56043 L p .5914 .59625 L .32 g
F P
0 g
s
.56057 .56043 m .55849 .55796 L .56053 .56034 L p .32 g
F P
0 g
s
.56053 .56034 m .5914 .59625 L p .56057 .56043 L .32 g
F P
0 g
s
.54513 .5381 m .55849 .55796 L .52897 .49941 L p .675 g
F P
0 g
s
.54609 .53927 m .56027 .55965 L p .54513 .5381 L .049 g
F P
0 g
s
.5801 .5831 m .55849 .55796 L p .57894 .58225 L .276 g
F P
0 g
s
.56027 .55965 m .56545 .5671 L .56032 .55977 L p .049 g
F P
0 g
s
.56032 .55977 m .54513 .5381 L p .56027 .55965 L .049 g
F P
0 g
s
.57894 .58225 m .5914 .59625 L .5801 .5831 L p .276 g
F P
0 g
s
.59295 .59409 m .58485 .58661 L p .62294 .62379 L .361 g
F P
0 g
s
.58303 .58526 m .62294 .62379 L p .58485 .58661 L .361 g
F P
0 g
s
.62294 .62379 m .65821 .64678 L .59295 .59409 L p .361 g
F P
0 g
s
.52521 .47589 m .52367 .48114 L .52387 .47975 L p .346 g
F P
0 g
s
.52367 .48114 m .52345 .48291 L .52387 .47975 L closepath p .807 g
F P
0 g
s
.52345 .48291 m .52367 .48114 L .52521 .47589 L closepath p .469 g
F P
0 g
s
.52799 .46623 m .52484 .47548 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52181 .46103 m .52295 .47336 L .52342 .46755 L p .731 g
F P
0 g
s
.52295 .47336 m .52181 .46103 L .52279 .47837 L p .722 g
F P
0 g
s
.52342 .46755 m .52345 .47922 L .52356 .47852 L p .725 g
F P
0 g
s
.52345 .47922 m .52342 .46755 L .52295 .47336 L p .743 g
F P
0 g
s
.52363 .48108 m .52484 .47548 L .52544 .46916 L p .355 g
F P
0 g
s
.52544 .46916 m .5237 .47956 L .52363 .48108 L p .355 g
F P
0 g
s
.58537 .39515 m .5688 .40868 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.5688 .40868 m .58537 .39515 L .61303 .30928 L p .433 g
F P
0 g
s
.61303 .30928 m .58875 .3382 L .5688 .40868 L p .433 g
F P
0 g
s
.28809 .56049 m .31122 .57385 L .45341 .52415 L p .395 g
F P
0 g
s
.52391 .47858 m .52351 .48169 L .5235 .4803 L p .701 g
F P
0 g
s
.52295 .47336 m .52339 .48062 L .52345 .47922 L p .743 g
F P
0 g
s
.52339 .48062 m .52295 .47336 L .52325 .48092 L p .727 g
F P
0 g
s
.52279 .47837 m .52325 .48092 L .52295 .47336 L p .722 g
F P
0 g
s
.56208 .33282 m .58058 .28997 L .55284 .27898 L p .696 g
F P
0 g
s
.55284 .27898 m .54331 .32505 L .56208 .33282 L p .696 g
F P
0 g
s
.52484 .47548 m .52363 .48108 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.5235 .4803 m .52345 .48291 L .5234 .47938 L closepath p .498 g
F P
0 g
s
.52351 .48169 m .52345 .48291 L .5235 .4803 L closepath p .449 g
F P
0 g
s
.52356 .47852 m .52345 .48291 L .52367 .47865 L closepath p .609 g
F P
0 g
s
.52345 .47922 m .52345 .48291 L .52356 .47852 L closepath p .569 g
F P
0 g
s
.52348 .48249 m .52345 .48291 L .52351 .48169 L closepath p .389 g
F P
0 g
s
.52367 .47865 m .52345 .48291 L .5237 .47956 L closepath p .65 g
F P
0 g
s
.51786 .59141 m .51447 .63219 L .49317 .64102 L p .713 g
F P
0 g
s
.51447 .63219 m .51786 .59141 L .52831 .56309 L p .737 g
F P
0 g
s
.52831 .56309 m .53129 .59337 L .51447 .63219 L p .737 g
F P
0 g
s
.52339 .48062 m .52345 .48291 L .52345 .47922 L closepath p .529 g
F P
0 g
s
.52365 .4809 m .52345 .48291 L .52348 .48249 L closepath p .311 g
F P
0 g
s
.5237 .47956 m .52345 .48291 L .52363 .48108 L closepath p .695 g
F P
0 g
s
.52345 .48291 m .66571 .41118 L .68295 .41865 L closepath p .469 g
F P
0 g
s
.53129 .59337 m .52831 .56309 L .52977 .51954 L p .742 g
F P
0 g
s
.52977 .51954 m .53366 .53335 L .53129 .59337 L p .742 g
F P
0 g
s
.52342 .48243 m .52345 .48291 L .52339 .48062 L closepath p .486 g
F P
0 g
s
.60312 .38456 m .58537 .39515 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.62092 .37795 m .60312 .38456 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.63751 .37611 m .62092 .37795 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.65163 .3794 m .63751 .37611 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.66211 .38775 m .65163 .3794 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.66801 .40063 m .66211 .38775 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.66875 .41702 m .66801 .40063 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .68295 .41865 L .6957 .42996 L closepath p .469 g
F P
0 g
s
.66417 .43557 m .66875 .41702 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .6957 .42996 L .70285 .44428 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .70285 .44428 L .70374 .4605 L closepath p .469 g
F P
0 g
s
.65464 .4547 m .66417 .43557 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .70374 .4605 L .6982 .47729 L closepath p .469 g
F P
0 g
s
.64094 .47279 m .65464 .4547 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .6982 .47729 L .68662 .49324 L closepath p .469 g
F P
0 g
s
.62425 .4884 m .64094 .47279 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .68662 .49324 L .66992 .50704 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .66992 .50704 L .64946 .51761 L closepath p .469 g
F P
0 g
s
.60596 .50043 m .62425 .4884 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .64946 .51761 L .62691 .52425 L closepath p .469 g
F P
0 g
s
.58751 .50824 m .60596 .50043 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .62691 .52425 L .60402 .5267 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .60402 .5267 L .58242 .52518 L closepath p .469 g
F P
0 g
s
.5702 .51169 m .58751 .50824 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .58242 .52518 L .56346 .52033 L closepath p .469 g
F P
0 g
s
.55509 .51117 m .5702 .51169 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .56346 .52033 L .54807 .51311 L closepath p .469 g
F P
0 g
s
.52345 .48291 m .54807 .51311 L .53669 .50471 L closepath p .469 g
F P
0 g
s
.54288 .50746 m .55509 .51117 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .53669 .50471 L .52925 .49639 L closepath p .469 g
F P
0 g
s
.52925 .49639 m .53669 .50471 L .54855 .52587 L p .4 g
F P
0 g
s
.53388 .50167 m .54288 .50746 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .52925 .49639 L .52521 .48935 L closepath p .469 g
F P
0 g
s
.52521 .48935 m .52925 .49639 L .53442 .50886 L p .296 g
F P
0 g
s
.54855 .52587 m .53442 .50886 L .52925 .49639 L p .4 g
F P
0 g
s
.52801 .49505 m .53388 .50167 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52387 .48604 m .52398 .48693 L .52353 .48351 L p .03 g
F P
0 g
s
.52353 .48351 m .52345 .48291 L .52354 .48361 L p .03 g
F P
0 g
s
.52354 .48361 m .52387 .48604 L p .52353 .48351 L .03 g
F P
0 g
s
.5237 .48488 m .52391 .48881 L p .52348 .48341 L .575 g
F P
0 g
s
.52348 .48338 m .52348 .4834 L p .52348 .48341 L .575 g
F P
0 g
s
.52348 .4834 m .5237 .48488 L p .52348 .48341 L .575 g
F P
0 g
s
.5237 .48488 m .52348 .48338 L .52365 .48516 L p .718 g
F P
0 g
s
.52383 .48648 m .52365 .48516 L .52349 .48333 L p .326 g
F P
0 g
s
.52349 .48333 m .52345 .48291 L .52349 .48327 L p .326 g
F P
0 g
s
.52349 .48327 m .52383 .48648 L p .52349 .48333 L .326 g
F P
0 g
s
.52345 .48291 m .52396 .4871 L .52383 .48648 L closepath p .21 g
F P
0 g
s
.52398 .48693 m .52396 .4871 L .52365 .48459 L p .052 g
F P
0 g
s
.52365 .48459 m .52345 .48291 L .52369 .48473 L p .052 g
F P
0 g
s
.52369 .48473 m .52398 .48693 L p .52365 .48459 L .052 g
F P
0 g
s
.52762 .4988 m .52398 .48693 L .52387 .48604 L p .114 g
F P
0 g
s
.52396 .4871 m .52748 .49971 L .52647 .4974 L p .213 g
F P
0 g
s
.52748 .49971 m .52396 .4871 L .52398 .48693 L p .181 g
F P
0 g
s
.52398 .48693 m .52762 .4988 L .52748 .49971 L p .181 g
F P
0 g
s
.5237 .48585 m .52544 .49359 L .52498 .49006 L p .492 g
F P
0 g
s
.52387 .48604 m .52678 .49504 L .52762 .4988 L p .114 g
F P
0 g
s
.52498 .49006 m .52484 .48894 L p .52446 .48793 L .492 g
F P
0 g
s
.5237 .48585 m .52498 .49006 L .52446 .48793 L .492 g
F
.52363 .48455 m .5237 .48585 L p .52404 .48677 L F P
0 g
s
.52678 .49504 m .52387 .48604 L .52367 .4846 L p .064 g
F P
0 g
s
.52484 .48894 m .52378 .48511 L p .52404 .48677 L .492 g
F P
0 g
s
.52378 .48511 m .52363 .48455 L p .52404 .48677 L .492 g
F P
0 g
s
.52345 .48291 m .52367 .4846 L .52387 .48604 L closepath p .602 g
F P
0 g
s
.52345 .48291 m .52521 .48935 L .52367 .4846 L closepath p .469 g
F P
0 g
s
.52367 .4846 m .52521 .48935 L .52678 .49504 L p .064 g
F P
0 g
s
.53516 .51951 m .54513 .5381 L .52686 .49494 L p .682 g
F P
0 g
s
.53442 .50886 m .52678 .49504 L .52521 .48935 L p .296 g
F P
0 g
s
.52484 .48894 m .52801 .49505 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52363 .48455 m .52484 .48894 L .52345 .48291 L closepath p .341 g
F P
0 g
s
.52345 .48291 m .5237 .48585 L .52363 .48455 L closepath p .648 g
F P
0 g
s
.52345 .48291 m .52365 .48516 L .52348 .48338 L closepath p .404 g
F P
0 g
s
.52391 .48881 m .52351 .48432 L .52348 .48338 L p .575 g
F P
0 g
s
.52345 .48291 m .52367 .4866 L .5237 .48585 L closepath p .605 g
F P
0 g
s
.52345 .48291 m .52348 .48338 L .52351 .48432 L closepath p .461 g
F P
0 g
s
.52351 .48432 m .52391 .48881 L .5238 .49572 L p .601 g
F P
0 g
s
.52345 .48291 m .52356 .48667 L .52367 .4866 L closepath p .563 g
F P
0 g
s
.52345 .48291 m .52349 .48597 L .5234 .48705 L closepath p .55 g
F P
0 g
s
.52345 .48291 m .52351 .48432 L .52349 .48597 L closepath p .508 g
F P
0 g
s
.52345 .48291 m .52344 .48605 L .52356 .48667 L closepath p .52 g
F P
0 g
s
.52345 .48291 m .5234 .48705 L .52327 .48734 L closepath p .589 g
F P
0 g
s
.52345 .48291 m .52338 .48487 L .52344 .48605 L closepath p .474 g
F P
0 g
s
.52345 .48291 m .52342 .48332 L .52338 .48487 L closepath p .421 g
F P
0 g
s
.52294 .48989 m .52338 .48487 L .52342 .48332 L p .513 g
F P
0 g
s
.31122 .57385 m .33999 .5813 L .46305 .52541 L p .326 g
F P
0 g
s
.5238 .49572 m .52349 .48597 L .52351 .48432 L p .601 g
F P
0 g
s
.50462 .59808 m .49317 .64102 L .47955 .61862 L p .662 g
F P
0 g
s
.49317 .64102 m .50462 .59808 L .51786 .59141 L p .713 g
F P
0 g
s
.54331 .32505 m .55284 .27898 L .52236 .31047 L p .775 g
F P
0 g
s
.52236 .31047 m .52273 .34941 L .54331 .32505 L p .775 g
F P
0 g
s
.52177 .49644 m .52294 .48989 L .52325 .48439 L p .535 g
F P
0 g
s
.10734 .36004 m .08674 .39398 L .1365 .45561 L p .802 g
F P
0 g
s
.13242 .48957 m .1365 .45561 L .08674 .39398 L p .773 g
F P
0 g
s
.52304 .50023 m .5234 .48705 L .52349 .48597 L p .608 g
F P
0 g
s
.52349 .48597 m .5238 .49572 L .52304 .50023 L p .608 g
F P
0 g
s
.52341 .49409 m .52344 .48605 L .52338 .48487 L p .495 g
F P
0 g
s
.52338 .48487 m .52294 .48989 L .52341 .49409 L p .495 g
F P
0 g
s
.58537 .39515 m .60312 .38456 L .6394 .28497 L p .414 g
F P
0 g
s
.6394 .28497 m .61303 .30928 L .58537 .39515 L p .414 g
F P
0 g
s
.58875 .3382 m .61303 .30928 L .60215 .24892 L p .561 g
F P
0 g
s
.60215 .24892 m .58058 .28997 L .58875 .3382 L p .561 g
F P
0 g
s
.52544 .49359 m .5237 .48585 L .52367 .4866 L p .519 g
F P
0 g
s
.5246 .51239 m .5238 .49572 L .52391 .48881 L p .651 g
F P
0 g
s
.52391 .48881 m .52495 .49644 L .5246 .51239 L p .651 g
F P
0 g
s
.52433 .49631 m .52356 .48667 L .52344 .48605 L p .503 g
F P
0 g
s
.52344 .48605 m .52341 .49409 L .52433 .49631 L p .503 g
F P
0 g
s
.46438 .59427 m .48305 .57148 L .47955 .61862 L p .557 g
F P
0 g
s
.52367 .4866 m .52518 .49616 L .52544 .49359 L p .519 g
F P
0 g
s
.52518 .49616 m .52367 .4866 L .52356 .48667 L p .515 g
F P
0 g
s
.52356 .48667 m .52433 .49631 L .52518 .49616 L p .515 g
F P
0 g
s
.52686 .5069 m .52977 .51954 L .52831 .56309 L p .714 g
F P
0 g
s
.52607 .53535 m .5246 .51239 L .52495 .49644 L p .685 g
F P
0 g
s
.52495 .49644 m .52686 .5069 L .52607 .53535 L p .685 g
F P
0 g
s
.33999 .5813 m .37212 .58237 L .47369 .52433 L p .243 g
F P
0 g
s
.52831 .56309 m .52607 .53535 L .52686 .5069 L p .714 g
F P
0 g
s
.52801 .49505 m .52484 .48894 L .52544 .49359 L p .39 g
F P
0 g
s
.85756 .45579 m .86057 .4851 L .70374 .4605 L p .56 g
F P
0 g
s
.70374 .4605 m .70285 .44428 L .85756 .45579 L p .56 g
F P
0 g
s
.14224 .52318 m .16553 .55358 L .28809 .56049 L p .499 g
F P
0 g
s
.31122 .57385 m .28809 .56049 L .16553 .55358 L p .378 g
F P
0 g
s
.80339 .67554 m .75557 .67235 L .76779 .64053 L p .788 g
F P
0 g
s
.76779 .64053 m .81924 .63801 L .80339 .67554 L p .788 g
F P
0 g
s
.49621 .58209 m .47955 .61862 L .48305 .57148 L p .573 g
F P
0 g
s
.47955 .61862 m .49621 .58209 L .50462 .59808 L p .662 g
F P
0 g
s
.52607 .53535 m .52831 .56309 L .51786 .59141 L p .708 g
F P
0 g
s
.52332 .50457 m .52341 .49409 L .52294 .48989 L p .48 g
F P
0 g
s
.52294 .48989 m .52177 .49644 L .52332 .50457 L p .48 g
F P
0 g
s
.52647 .4974 m .53337 .51539 L .52859 .50381 L p .059 g
F P
0 g
s
.37212 .58237 m .40512 .57728 L .48454 .5211 L p .148 g
F P
0 g
s
.65821 .64678 m .62294 .62379 L .6577 .63639 L p .529 g
F P
0 g
s
.6577 .63639 m .70572 .65872 L .65821 .64678 L p .529 g
F P
0 g
s
.5372 .51753 m .52762 .4988 L .52678 .49504 L p .307 g
F P
0 g
s
.52678 .49504 m .53442 .50886 L .5372 .51753 L p .307 g
F P
0 g
s
.52042 .5539 m .52211 .52281 L .5246 .51239 L p .68 g
F P
0 g
s
.5246 .51239 m .52607 .53535 L .52042 .5539 L p .68 g
F P
0 g
s
.40512 .57728 m .43655 .56688 L .49485 .51612 L p .103 g
F P
0 g
s
.55849 .55796 m .54513 .5381 L .56545 .5671 L p .276 g
F P
0 g
s
.52042 .5539 m .51786 .59141 L .50462 .59808 L p .692 g
F P
0 g
s
.51786 .59141 m .52042 .5539 L .52607 .53535 L p .708 g
F P
0 g
s
.50993 .52606 m .51751 .50752 L .51697 .51986 L p .592 g
F P
0 g
s
.52748 .49971 m .53673 .5201 L .53337 .51539 L p .261 g
F P
0 g
s
.53673 .5201 m .52748 .49971 L .52762 .4988 L p .309 g
F P
0 g
s
.52762 .4988 m .5372 .51753 L .53673 .5201 L p .309 g
F P
0 g
s
.48305 .57148 m .49843 .54801 L .49621 .58209 L p .573 g
F P
0 g
s
.52544 .49359 m .53003 .50411 L .52801 .49505 L p .39 g
F P
0 g
s
.53003 .50411 m .52544 .49359 L .52518 .49616 L p .419 g
F P
0 g
s
.54513 .5381 m .53516 .51951 L .54609 .53927 L p .049 g
F P
0 g
s
.53337 .51539 m .54609 .53927 L .53516 .51951 L p .055 g
F P
0 g
s
.52638 .50897 m .52433 .49631 L .52341 .49409 L p .453 g
F P
0 g
s
.52341 .49409 m .52332 .50457 L .52638 .50897 L p .453 g
F P
0 g
s
.51325 .55842 m .51897 .52544 L .52211 .52281 L p .671 g
F P
0 g
s
.52211 .52281 m .52042 .5539 L .51325 .55842 L p .671 g
F P
0 g
s
.51325 .55842 m .50462 .59808 L .49621 .58209 L p .656 g
F P
0 g
s
.50462 .59808 m .51325 .55842 L .52042 .5539 L p .692 g
F P
0 g
s
.60312 .38456 m .62092 .37795 L .66631 .26751 L p .385 g
F P
0 g
s
.66631 .26751 m .6394 .28497 L .60312 .38456 L p .385 g
F P
0 g
s
.51697 .51986 m .50872 .5482 L .50993 .52606 L p .592 g
F P
0 g
s
.50872 .5482 m .51697 .51986 L .51897 .52544 L p .648 g
F P
0 g
s
.49843 .54801 m .50993 .52606 L .50872 .5482 L p .584 g
F P
0 g
s
.53388 .50167 m .52801 .49505 L .53003 .50411 L p .305 g
F P
0 g
s
.51897 .52544 m .51325 .55842 L .50872 .5482 L p .648 g
F P
0 g
s
.50872 .5482 m .49621 .58209 L .49843 .54801 L p .584 g
F P
0 g
s
.52518 .49616 m .52919 .5089 L .53003 .50411 L p .419 g
F P
0 g
s
.52919 .5089 m .52518 .49616 L .52433 .49631 L p .437 g
F P
0 g
s
.52433 .49631 m .52638 .50897 L .52919 .5089 L p .437 g
F P
0 g
s
.49621 .58209 m .50872 .5482 L .51325 .55842 L p .656 g
F P
0 g
s
.58058 .28997 m .60215 .24892 L .56399 .23427 L p .706 g
F P
0 g
s
.56399 .23427 m .55284 .27898 L .58058 .28997 L p .706 g
F P
0 g
s
.90071 .60292 m .86477 .62516 L .80064 .56186 L p .734 g
F P
0 g
s
.80064 .56186 m .83111 .54049 L .90071 .60292 L p .734 g
F P
0 g
s
.54609 .53927 m .53337 .51539 L .53673 .5201 L p .327 g
F P
0 g
s
.22699 .2847 m .27146 .28425 L .36026 .31162 L p .268 g
F P
0 g
s
.22699 .2847 m .18816 .29556 L .14096 .33363 L p .852 g
F P
0 g
s
.10734 .36004 m .14096 .33363 L .18816 .29556 L p .687 g
F P
0 g
s
.52316 .51474 m .52332 .50457 L .52177 .49644 L p .432 g
F P
0 g
s
.55492 .54136 m .5372 .51753 L .53442 .50886 L p .414 g
F P
0 g
s
.53442 .50886 m .54855 .52587 L .55492 .54136 L p .414 g
F P
0 g
s
.5702 .54403 m .54855 .52587 L .53669 .50471 L p .465 g
F P
0 g
s
.53669 .50471 m .54807 .51311 L .5702 .54403 L p .465 g
F P
0 g
s
.53673 .5201 m .55379 .54668 L .54609 .53927 L p .327 g
F P
0 g
s
.55379 .54668 m .53673 .5201 L .5372 .51753 L p .405 g
F P
0 g
s
.16553 .55358 m .20059 .57814 L .31122 .57385 L p .378 g
F P
0 g
s
.33999 .5813 m .31122 .57385 L .20059 .57814 L p .203 g
F P
0 g
s
.62294 .62379 m .5914 .59625 L .61492 .60807 L p .499 g
F P
0 g
s
.61492 .60807 m .6577 .63639 L .62294 .62379 L p .499 g
F P
0 g
s
.61303 .30928 m .6394 .28497 L .62582 .21288 L p .54 g
F P
0 g
s
.62582 .21288 m .60215 .24892 L .61303 .30928 L p .54 g
F P
0 g
s
.52194 .27283 m .52236 .31047 L .55284 .27898 L p .802 g
F P
0 g
s
.52236 .31047 m .52194 .27283 L .50069 .35471 L p .822 g
F P
0 g
s
.56545 .5671 m .54609 .53927 L .55379 .54668 L p .392 g
F P
0 g
s
.5372 .51753 m .55492 .54136 L .55379 .54668 L p .405 g
F P
0 g
s
.55284 .27898 m .56399 .23427 L .52194 .27283 L p .802 g
F P
0 g
s
.54288 .50746 m .53388 .50167 L .53856 .51509 L p .218 g
F P
0 g
s
.53003 .50411 m .53856 .51509 L .53388 .50167 L p .305 g
F P
0 g
s
.53856 .51509 m .53003 .50411 L .52919 .5089 L p .286 g
F P
0 g
s
.08674 .39398 m .08136 .43292 L .13242 .48957 L p .773 g
F P
0 g
s
.14224 .52318 m .13242 .48957 L .08136 .43292 L p .643 g
F P
0 g
s
.5914 .59625 m .56545 .5671 L .57986 .57703 L p .45 g
F P
0 g
s
.57986 .57703 m .61492 .60807 L .5914 .59625 L p .45 g
F P
0 g
s
.55379 .54668 m .57986 .57703 L .56545 .5671 L p .392 g
F P
0 g
s
.75557 .67235 m .70572 .65872 L .71457 .63297 L p .724 g
F P
0 g
s
.71457 .63297 m .76779 .64053 L .75557 .67235 L p .724 g
F P
0 g
s
.62092 .37795 m .63751 .37611 L .69193 .25881 L p .347 g
F P
0 g
s
.69193 .25881 m .66631 .26751 L .62092 .37795 L p .347 g
F P
0 g
s
.86057 .4851 m .85159 .51415 L .6982 .47729 L p .589 g
F P
0 g
s
.6982 .47729 m .70374 .4605 L .86057 .4851 L p .589 g
F P
0 g
s
.49597 .52839 m .51147 .51149 L .50945 .51535 L p .914 g
F P
0 g
s
.50945 .51535 m .49134 .53572 L .49597 .52839 L p .914 g
F P
0 g
s
.51147 .51149 m .49597 .52839 L .50592 .51402 L p .918 g
F P
0 g
s
.49403 .33541 m .50069 .35471 L .52194 .27283 L p .855 g
F P
0 g
s
.53021 .52145 m .52638 .50897 L .52332 .50457 L p .357 g
F P
0 g
s
.52332 .50457 m .52316 .51474 L .53021 .52145 L p .357 g
F P
0 g
s
.59954 .56104 m .5702 .54403 L .54807 .51311 L p .511 g
F P
0 g
s
.54807 .51311 m .56346 .52033 L .59954 .56104 L p .511 g
F P
0 g
s
.46344 .55664 m .46895 .55454 L p .45164 .56269 L .893 g
F P
0 g
s
.487 .5362 m .46433 .55259 L .44666 .56581 L p F P
s
.487 .5362 m .44666 .56581 L .44782 .56509 L F
.3925 .59099 m .43471 .57474 L .46433 .55259 L p F P
s
.42537 .57506 m .45407 .56117 L p .45164 .56269 L .893 g
F P
0 g
s
.45407 .56117 m .46344 .55664 L p .45164 .56269 L .893 g
F P
0 g
s
.44666 .56581 m .43471 .57474 L p .44782 .56509 L F P
s
.46331 .39504 m .45311 .39236 L .33163 .30812 L p .593 g
F P
0 g
s
.33163 .30812 m .36026 .31162 L .46331 .39504 L p .593 g
F P
0 g
s
.57986 .57703 m .55379 .54668 L .55492 .54136 L p .482 g
F P
0 g
s
.20059 .57814 m .2446 .59481 L .33999 .5813 L p .203 g
F P
0 g
s
.37212 .58237 m .33999 .5813 L .2446 .59481 L p .112 g
F P
0 g
s
.58205 .56783 m .55492 .54136 L .54855 .52587 L p .488 g
F P
0 g
s
.54855 .52587 m .5702 .54403 L .58205 .56783 L p .488 g
F P
0 g
s
.52919 .5089 m .53667 .52177 L .53856 .51509 L p .286 g
F P
0 g
s
.53667 .52177 m .52919 .5089 L .52638 .50897 L p .305 g
F P
0 g
s
.51175 .50814 m .50611 .50418 L .51179 .50842 L p .127 g
F P
0 g
s
.52291 .52179 m .5231 .51629 L p .5218 .51538 L .343 g
F P
0 g
s
.51961 .50281 m .51629 .50725 L .52291 .52179 L p .343 g
F P
0 g
s
.52258 .52303 m .52291 .52179 L .5191 .51342 L p .223 g
F P
0 g
s
.5191 .51342 m .51629 .50725 L p .51864 .51315 L .223 g
F P
0 g
s
.51864 .51315 m .52258 .52303 L .5191 .51342 L .223 g
F
.51629 .50725 m .51175 .50814 L .52258 .52303 L p F P
0 g
s
.52216 .51616 m .52258 .52303 L .51175 .50814 L p .127 g
F P
0 g
s
.51179 .50842 m .51637 .51184 L p .51514 .51075 L .127 g
F P
0 g
s
.51637 .51184 m .52216 .51616 L p .5171 .51226 L .127 g
F P
0 g
s
.51514 .51075 m .51637 .51184 L .5171 .51226 L .127 g
F
.51175 .50814 m .51179 .50842 L .51514 .51075 L F
.52316 .51474 m .51961 .50281 L p .5218 .51538 L .343 g
F P
0 g
s
.5231 .51629 m .52316 .51474 L p .5218 .51538 L .343 g
F P
0 g
s
.52638 .50897 m .53021 .52145 L .53667 .52177 L p .305 g
F P
0 g
s
.55492 .54136 m .58205 .56783 L .57986 .57703 L p .482 g
F P
0 g
s
.42537 .57506 m .43471 .57474 L p .41623 .57907 L .872 g
F P
0 g
s
.46433 .55259 m .43655 .56688 L .40475 .58429 L p F P
s
.46433 .55259 m .40475 .58429 L .40672 .58339 L F
.3445 .60083 m .3925 .59099 L .43655 .56688 L p F P
s
.43655 .56688 m .40512 .57728 L .35661 .59612 L p F P
s
.35661 .59612 m .3445 .60083 L p .35888 .59552 L F P
s
.43655 .56688 m .35661 .59612 L .35888 .59552 L F
.2446 .59481 m .29391 .60241 L .37212 .58237 L p .112 g
F P
0 g
s
.40512 .57728 m .37212 .58237 L .30535 .59948 L p .045 g
F P
0 g
s
.30535 .59948 m .29391 .60241 L p .30752 .59934 L .045 g
F P
0 g
s
.40512 .57728 m .30535 .59948 L .30752 .59934 L .045 g
F
.29391 .60241 m .3445 .60083 L .40512 .57728 L p F P
0 g
s
.26637 .58773 m .32391 .59281 L .33584 .59745 L p .753 g
F P
0 g
s
.33584 .59745 m .3445 .60083 L p .32763 .598 L .753 g
F P
0 g
s
.32763 .598 m .26637 .58773 L .33584 .59745 L .753 g
F
.32391 .59281 m .3781 .58798 L .38331 .58907 L p .825 g
F P
0 g
s
.38331 .58907 m .3925 .59099 L p .37421 .59148 L .825 g
F P
0 g
s
.37421 .59148 m .32391 .59281 L .38331 .58907 L .825 g
F
.3781 .58798 m .42454 .57529 L p .41623 .57907 L .872 g
F P
0 g
s
.42454 .57529 m .42537 .57506 L p .41623 .57907 L .872 g
F P
0 g
s
.40475 .58429 m .3925 .59099 L p .40672 .58339 L F P
s
.86477 .62516 m .81924 .63801 L .76263 .57652 L p .717 g
F P
0 g
s
.76263 .57652 m .80064 .56186 L .86477 .62516 L p .717 g
F P
0 g
s
.55509 .51117 m .54288 .50746 L .55176 .52405 L p .129 g
F P
0 g
s
.53856 .51509 m .55176 .52405 L .54288 .50746 L p .218 g
F P
0 g
s
.49071 .52388 m .50592 .51402 L .49597 .52839 L p .883 g
F P
0 g
s
.70572 .65872 m .6577 .63639 L .66371 .61667 L p .665 g
F P
0 g
s
.66371 .61667 m .71457 .63297 L .70572 .65872 L p .665 g
F P
0 g
s
.6357 .57456 m .59954 .56104 L .56346 .52033 L p .546 g
F P
0 g
s
.56346 .52033 m .58242 .52518 L .6357 .57456 L p .546 g
F P
0 g
s
.61492 .60807 m .57986 .57703 L .58205 .56783 L p .547 g
F P
0 g
s
.36026 .31162 m .33163 .30812 L .22699 .2847 L p .268 g
F P
0 g
s
.63751 .37611 m .65163 .3794 L .71429 .26016 L p .298 g
F P
0 g
s
.71429 .26016 m .69193 .25881 L .63751 .37611 L p .298 g
F P
0 g
s
.60215 .24892 m .62582 .21288 L .57626 .19434 L p .713 g
F P
0 g
s
.57626 .19434 m .56399 .23427 L .60215 .24892 L p .713 g
F P
0 g
s
.49473 .50091 m .50399 .50176 L .46994 .53043 L p .748 g
F P
0 g
s
.49071 .52388 m .46994 .53043 L .50399 .50176 L p .766 g
F P
0 g
s
.18816 .29556 m .22699 .2847 L .33163 .30812 L p .34 g
F P
0 g
s
.45311 .39236 m .44448 .39382 L .30685 .31304 L p .598 g
F P
0 g
s
.30685 .31304 m .33163 .30812 L .45311 .39236 L p .598 g
F P
0 g
s
.6394 .28497 m .66631 .26751 L .65029 .18505 L p .5 g
F P
0 g
s
.65029 .18505 m .62582 .21288 L .6394 .28497 L p .5 g
F P
0 g
s
.6577 .63639 m .61492 .60807 L .61871 .59399 L p .607 g
F P
0 g
s
.58205 .56783 m .61871 .59399 L .61492 .60807 L p .547 g
F P
0 g
s
.61871 .59399 m .66371 .61667 L .6577 .63639 L p .607 g
F P
0 g
s
.18816 .29556 m .1582 .31657 L .10734 .36004 L p .687 g
F P
0 g
s
.08674 .39398 m .10734 .36004 L .1582 .31657 L p F P
s
.61871 .59399 m .58205 .56783 L .5702 .54403 L p .544 g
F P
0 g
s
.5702 .54403 m .59954 .56104 L .61871 .59399 L p .544 g
F P
0 g
s
.85159 .51415 m .83111 .54049 L .68662 .49324 L p .606 g
F P
0 g
s
.68662 .49324 m .6982 .47729 L .85159 .51415 L p .606 g
F P
0 g
s
.55176 .52405 m .53856 .51509 L .53667 .52177 L p .132 g
F P
0 g
s
.47204 .54473 m .49597 .52839 L .49134 .53572 L p .934 g
F P
0 g
s
.49134 .53572 m .46344 .55664 L .47204 .54473 L p .934 g
F P
0 g
s
.52147 .2394 m .52194 .27283 L .56399 .23427 L p .836 g
F P
0 g
s
.52194 .27283 m .52147 .2394 L .49403 .33541 L p .855 g
F P
0 g
s
.48727 .32088 m .49403 .33541 L .52147 .2394 L p .892 g
F P
0 g
s
.08136 .43292 m .09224 .47366 L .14224 .52318 L p .643 g
F P
0 g
s
.16553 .55358 m .15455 .53925 L p .14849 .535 L .338 g
F P
0 g
s
.09224 .47366 m .11889 .51265 L .16553 .55358 L p .338 g
F P
0 g
s
.16553 .55358 m .11889 .51265 L p .17889 .56075 L .221 g
F P
0 g
s
.20059 .57814 m .17795 .56228 L p .17889 .56075 L .221 g
F P
0 g
s
.17795 .56228 m .16553 .55358 L p .17889 .56075 L .221 g
F P
0 g
s
.2099 .57206 m .2446 .59481 L p .18035 .55837 L .463 g
F P
0 g
s
.15927 .5464 m .20059 .57814 L p .13486 .52545 L .221 g
F P
0 g
s
.15927 .5464 m .18095 .55739 L p .18035 .55837 L .463 g
F P
0 g
s
.18095 .55739 m .2099 .57206 L p .18035 .55837 L .463 g
F P
0 g
s
.11889 .51265 m .1308 .5226 L p .13486 .52545 L .221 g
F P
0 g
s
.1308 .5226 m .15927 .5464 L p .13486 .52545 L .221 g
F P
0 g
s
.14224 .52318 m .09224 .47366 L p .14849 .535 L .338 g
F P
0 g
s
.15455 .53925 m .14224 .52318 L p .14849 .535 L .338 g
F P
0 g
s
.49597 .52839 m .47204 .54473 L .49071 .52388 L p .883 g
F P
0 g
s
.67683 .58254 m .6357 .57456 L .58242 .52518 L p .572 g
F P
0 g
s
.58242 .52518 m .60402 .5267 L .67683 .58254 L p .572 g
F P
0 g
s
.5702 .51169 m .55509 .51117 L .56987 .52862 L p .092 g
F P
0 g
s
.55176 .52405 m .56987 .52862 L .55509 .51117 L p .129 g
F P
0 g
s
.46895 .55454 m .43471 .57474 L .42537 .57506 L p .893 g
F P
0 g
s
.56399 .23427 m .57626 .19434 L .52147 .2394 L p .836 g
F P
0 g
s
.81924 .63801 m .76779 .64053 L .72023 .58345 L p .692 g
F P
0 g
s
.72023 .58345 m .76263 .57652 L .81924 .63801 L p .692 g
F P
0 g
s
.52291 .52179 m .52258 .52303 L .52479 .52399 L p .099 g
F P
0 g
s
.5362 .53038 m .53302 .52563 L p .53208 .52545 L .195 g
F P
0 g
s
.52316 .51474 m .52291 .52179 L .5362 .53038 L p .195 g
F P
0 g
s
.53021 .52145 m .5362 .53038 L .54833 .53156 L p .145 g
F P
0 g
s
.56446 .53514 m .54833 .53156 L .5362 .53038 L p .043 g
F P
0 g
s
.5362 .53038 m .5445 .53253 L .56446 .53514 L p .043 g
F P
0 g
s
.5362 .53038 m .52291 .52179 L p .53704 .52882 L .099 g
F P
0 g
s
.5445 .53253 m .53893 .53109 L p .53704 .52882 L .099 g
F P
0 g
s
.53893 .53109 m .5362 .53038 L p .53704 .52882 L .099 g
F P
0 g
s
.52291 .52179 m .52479 .52399 L .52903 .52484 L .099 g
F
.53021 .52145 m .52316 .51474 L p .53208 .52545 L .195 g
F P
0 g
s
.52258 .52303 m .52216 .51616 L .52774 .51767 L p .412 g
F P
0 g
s
.53667 .52177 m .54833 .53156 L .55176 .52405 L p .132 g
F P
0 g
s
.54833 .53156 m .53667 .52177 L .53021 .52145 L p .145 g
F P
0 g
s
.56987 .52862 m .55176 .52405 L .54833 .53156 L p .054 g
F P
0 g
s
.52774 .51767 m .55505 .52506 L p .53274 .52366 L .412 g
F P
0 g
s
.53302 .52563 m .53021 .52145 L p .53208 .52545 L .195 g
F P
0 g
s
.52258 .52303 m .52774 .51767 L .53274 .52366 L .412 g
F
.52479 .52399 m .5445 .53253 L p .52903 .52484 L .099 g
F P
0 g
s
.48414 .49689 m .49473 .50091 L .44406 .53177 L p .73 g
F P
0 g
s
.46994 .53043 m .44406 .53177 L .49473 .50091 L p .748 g
F P
0 g
s
.72023 .58345 m .67683 .58254 L .60402 .5267 L p .592 g
F P
0 g
s
.60402 .5267 m .62691 .52425 L .72023 .58345 L p .592 g
F P
0 g
s
.44448 .39382 m .43812 .39942 L .28803 .3264 L p .605 g
F P
0 g
s
.28803 .3264 m .30685 .31304 L .44448 .39382 L p .605 g
F P
0 g
s
.65163 .3794 m .66211 .38775 L .73144 .27206 L p .236 g
F P
0 g
s
.73144 .27206 m .71429 .26016 L .65163 .3794 L p .236 g
F P
0 g
s
.66371 .61667 m .61871 .59399 L .59954 .56104 L p .59 g
F P
0 g
s
.59954 .56104 m .6357 .57456 L .66371 .61667 L p .59 g
F P
0 g
s
.46994 .53043 m .49071 .52388 L .47204 .54473 L p .84 g
F P
0 g
s
.66992 .50704 m .68662 .49324 L .83111 .54049 L p .613 g
F P
0 g
s
.83111 .54049 m .80064 .56186 L .66992 .50704 L p .613 g
F P
0 g
s
.76263 .57652 m .72023 .58345 L .62691 .52425 L p .605 g
F P
0 g
s
.62691 .52425 m .64946 .51761 L .76263 .57652 L p .605 g
F P
0 g
s
.76779 .64053 m .71457 .63297 L .67683 .58254 L p .663 g
F P
0 g
s
.67683 .58254 m .72023 .58345 L .76779 .64053 L p .663 g
F P
0 g
s
.64946 .51761 m .66992 .50704 L .80064 .56186 L p .613 g
F P
0 g
s
.33163 .30812 m .30685 .31304 L .18816 .29556 L p .34 g
F P
0 g
s
.80064 .56186 m .76263 .57652 L .64946 .51761 L p .613 g
F P
0 g
s
.71457 .63297 m .66371 .61667 L .6357 .57456 L p .63 g
F P
0 g
s
.58751 .50824 m .5702 .51169 L .59257 .52669 L p .057 g
F P
0 g
s
.56987 .52862 m .59257 .52669 L .5702 .51169 L p .092 g
F P
0 g
s
.43471 .57474 m .3925 .59099 L .3781 .58798 L p .872 g
F P
0 g
s
.47286 .4895 m .48414 .49689 L .41423 .5265 L p .713 g
F P
0 g
s
.44406 .53177 m .41423 .5265 L .48414 .49689 L p .73 g
F P
0 g
s
.6357 .57456 m .67683 .58254 L .71457 .63297 L p .63 g
F P
0 g
s
.43928 .55766 m .47204 .54473 L .46344 .55664 L p .903 g
F P
0 g
s
.46344 .55664 m .42537 .57506 L .43928 .55766 L p .903 g
F P
0 g
s
.43812 .39942 m .43459 .40882 L .27694 .34744 L p .614 g
F P
0 g
s
.27694 .34744 m .28803 .3264 L .43812 .39942 L p .614 g
F P
0 g
s
.52147 .2394 m .52098 .2131 L .48727 .32088 L p .892 g
F P
0 g
s
.48091 .31258 m .48727 .32088 L .52098 .2131 L p .923 g
F P
0 g
s
.1582 .31657 m .18816 .29556 L .30685 .31304 L p .403 g
F P
0 g
s
.47204 .54473 m .43928 .55766 L .46994 .53043 L p .84 g
F P
0 g
s
.66211 .38775 m .66801 .40063 L .74167 .294 L p .164 g
F P
0 g
s
.74167 .294 m .73144 .27206 L .66211 .38775 L p .164 g
F P
0 g
s
.66631 .26751 m .69193 .25881 L .67395 .1683 L p .429 g
F P
0 g
s
.67395 .1683 m .65029 .18505 L .66631 .26751 L p .429 g
F P
0 g
s
.1582 .31657 m .13995 .3465 L .08674 .39398 L p F P
s
.08136 .43292 m .08674 .39398 L .13995 .3465 L p .109 g
F P
0 g
s
.62582 .21288 m .65029 .18505 L .589 .1626 L p .71 g
F P
0 g
s
.589 .1626 m .57626 .19434 L .62582 .21288 L p .71 g
F P
0 g
s
.46167 .47893 m .47286 .4895 L .38228 .51386 L p .696 g
F P
0 g
s
.41423 .5265 m .38228 .51386 L .47286 .4895 L p .713 g
F P
0 g
s
.3925 .59099 m .3445 .60083 L .32391 .59281 L p .825 g
F P
0 g
s
.52098 .2131 m .52147 .2394 L .57626 .19434 L p .877 g
F P
0 g
s
.60596 .50043 m .58751 .50824 L .61891 .51676 L p .028 g
F P
0 g
s
.59257 .52669 m .61891 .51676 L .58751 .50824 L p .057 g
F P
0 g
s
.43459 .40882 m .43424 .42126 L .27479 .37458 L p .626 g
F P
0 g
s
.27479 .37458 m .27694 .34744 L .43459 .40882 L p .626 g
F P
0 g
s
.2446 .59481 m .20059 .57814 L .15927 .5464 L p .463 g
F P
0 g
s
.44406 .53177 m .46994 .53043 L .43928 .55766 L p .798 g
F P
0 g
s
.66801 .40063 m .66875 .41702 L .7438 .3244 L p .083 g
F P
0 g
s
.7438 .3244 m .74167 .294 L .66801 .40063 L p .083 g
F P
0 g
s
.45145 .46579 m .46167 .47893 L .35054 .49399 L p .681 g
F P
0 g
s
.38228 .51386 m .35054 .49399 L .46167 .47893 L p .696 g
F P
0 g
s
.3445 .60083 m .29391 .60241 L .26637 .58773 L p .753 g
F P
0 g
s
.43424 .42126 m .43712 .43573 L .282 .40554 L p .638 g
F P
0 g
s
.282 .40554 m .27479 .37458 L .43424 .42126 L p .638 g
F P
0 g
s
.29391 .60241 m .2446 .59481 L .2099 .57206 L p .644 g
F P
0 g
s
.30685 .31304 m .28803 .3264 L .1582 .31657 L p .403 g
F P
0 g
s
.57626 .19434 m .589 .1626 L .52098 .2131 L p .877 g
F P
0 g
s
.39842 .56448 m .43928 .55766 L .42537 .57506 L p .856 g
F P
0 g
s
.42537 .57506 m .3781 .58798 L .39842 .56448 L p .856 g
F P
0 g
s
.2099 .57206 m .26637 .58773 L .29391 .60241 L p .644 g
F P
0 g
s
.62425 .4884 m .60596 .50043 L .64732 .49815 L p .011 g
F P
0 g
s
.61891 .51676 m .64732 .49815 L .60596 .50043 L p .028 g
F P
0 g
s
.44303 .451 m .45145 .46579 L .32162 .46793 L p .666 g
F P
0 g
s
.35054 .49399 m .32162 .46793 L .45145 .46579 L p .681 g
F P
0 g
s
.43712 .43573 m .44303 .451 L .29807 .4376 L p .651 g
F P
0 g
s
.29807 .4376 m .282 .40554 L .43712 .43573 L p .651 g
F P
0 g
s
.54833 .53156 m .56446 .53514 L .56987 .52862 L p .054 g
F P
0 g
s
.52098 .2131 m .5205 .19659 L .48091 .31258 L p .923 g
F P
0 g
s
.47542 .31154 m .48091 .31258 L .5205 .19659 L p .91 g
F P
0 g
s
.32162 .46793 m .29807 .4376 L .44303 .451 L p .666 g
F P
0 g
s
.66875 .41702 m .66417 .43557 L .73741 .36068 L p .053 g
F P
0 g
s
.73741 .36068 m .7438 .3244 L .66875 .41702 L p .053 g
F P
0 g
s
.52168 .49961 m .52216 .51616 L .50611 .50418 L p .24 g
F P
0 g
s
.50611 .50418 m .49959 .49452 L .52168 .49961 L p .24 g
F P
0 g
s
.43928 .55766 m .39842 .56448 L .44406 .53177 L p .798 g
F P
0 g
s
.13995 .3465 m .13544 .38313 L .08136 .43292 L p .109 g
F P
0 g
s
.09224 .47366 m .08136 .43292 L .13544 .38313 L p .332 g
F P
0 g
s
.59257 .52669 m .56987 .52862 L .56446 .53514 L p F P
s
.64094 .47279 m .62425 .4884 L .67571 .47123 L p .015 g
F P
0 g
s
.64732 .49815 m .67571 .47123 L .62425 .4884 L p .011 g
F P
0 g
s
.13995 .3465 m .1582 .31657 L .28803 .3264 L p .458 g
F P
0 g
s
.69193 .25881 m .71429 .26016 L .69497 .16496 L p .301 g
F P
0 g
s
.69497 .16496 m .67395 .1683 L .69193 .25881 L p .301 g
F P
0 g
s
.66417 .43557 m .65464 .4547 L .72294 .39957 L p .031 g
F P
0 g
s
.72294 .39957 m .73741 .36068 L .66417 .43557 L p .031 g
F P
0 g
s
.41423 .5265 m .44406 .53177 L .39842 .56448 L p .76 g
F P
0 g
s
.65464 .4547 m .64094 .47279 L .70171 .43752 L p .022 g
F P
0 g
s
.67571 .47123 m .70171 .43752 L .64094 .47279 L p .015 g
F P
0 g
s
.70171 .43752 m .72294 .39957 L .65464 .4547 L p .022 g
F P
0 g
s
.35131 .56298 m .39842 .56448 L .3781 .58798 L p .805 g
F P
0 g
s
.3781 .58798 m .32391 .59281 L .35131 .56298 L p .805 g
F P
0 g
s
.28803 .3264 m .27694 .34744 L .13995 .3465 L p .458 g
F P
0 g
s
.65029 .18505 m .67395 .1683 L .60136 .1423 L p .676 g
F P
0 g
s
.60136 .1423 m .589 .1626 L .65029 .18505 L p .676 g
F P
0 g
s
.5205 .19659 m .52098 .2131 L .589 .1626 L p .905 g
F P
0 g
s
.5205 .19659 m .52007 .19199 L .47542 .31154 L p .91 g
F P
0 g
s
.47129 .31818 m .47542 .31154 L .52007 .19199 L p .76 g
F P
0 g
s
.55505 .52506 m .5445 .53253 L .52258 .52303 L p .412 g
F P
0 g
s
.13544 .38313 m .14556 .42341 L .09224 .47366 L p .332 g
F P
0 g
s
.11889 .51265 m .09224 .47366 L .14556 .42341 L p .469 g
F P
0 g
s
.49959 .49452 m .49258 .47894 L .52117 .47281 L p .285 g
F P
0 g
s
.39842 .56448 m .35131 .56298 L .41423 .5265 L p .76 g
F P
0 g
s
.38228 .51386 m .41423 .5265 L .35131 .56298 L p .723 g
F P
0 g
s
.13544 .38313 m .13995 .3465 L .27694 .34744 L p .505 g
F P
0 g
s
.30092 .55178 m .35131 .56298 L .32391 .59281 L p .7