function Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

load Na0_0.txt;
load Na0_7.txt;
load Na1_0.txt;
load Na1_6.txt;
load Na2_0.txt;
load Na3_0.txt;
load Na10_0.txt;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
% figure(1); set(figure(1),'Units','inches','Position',[1 1 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(1)
plot(Na0_0(:,1),Na0_0(:,2)*1e6,'ob','linewidth',2, 'MarkerEdgeColor','b', ...
    'MarkerFaceColor','b', 'Markersize',6); hold on;
plot(Na0_7(:,1),Na0_7(:,2)*1e6,'ob','linewidth',2, 'MarkerEdgeColor','b', ...
    'MarkerFaceColor','b', 'Markersize',6); hold on;
plot(Na1_0(:,1),Na1_0(:,2)*1e6,'og','linewidth',2, 'MarkerEdgeColor','g', ...
    'MarkerFaceColor','g', 'Markersize',6); hold on;
plot(Na1_6(:,1),Na1_6(:,2)*1e6,'or','linewidth',2, 'MarkerEdgeColor','r', ...
    'MarkerFaceColor','r', 'Markersize',6); hold on;
plot(Na2_0(:,1),Na2_0(:,2)*1e6,'oc','linewidth',2, 'MarkerEdgeColor','c', ...
    'MarkerFaceColor','c', 'Markersize',6); hold on;
plot(Na3_0(:,1),Na3_0(:,2)*1e6,'om','linewidth',2, 'MarkerEdgeColor','m', ...
    'MarkerFaceColor','m', 'Markersize',6); hold on;
plot(Na10_0(:,1),Na10_0(:,2)*1e6,'ok','linewidth',2, 'MarkerEdgeColor','k', ...
    'MarkerFaceColor','k', 'Markersize',6); hold on;
plot(t_vec,C_mat(:,2)*1e6,ls,'linewidth',2); hold on;
axis([0 360 0 1.4]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (0:0.2:1.4));
xlabel('Time (sec)'); ylabel('Matrix free [Ca^{2+}] (\muM)');
if (exchange == 2)
text(265,1.35,'Buffer [Na^+], mM','FontSize',13,'Color','k','Rotation',0);
text(265,1.30,'----------------------','FontSize',13,'Color','k','Rotation',0);
text(331,1.00,' 0.7','FontSize',14,'Color','b','Rotation',0);
text(331,0.75,' 1.0','FontSize',14,'Color','g','Rotation',0);
text(331,0.45,' 1.6','FontSize',14,'Color','r','Rotation',0);
text(331,0.22,' 2.0','FontSize',14,'Color','c','Rotation',0);
text(331,0.10,' 3.0','FontSize',14,'Color','m','Rotation',0);
text(331,0.025,'10.0','FontSize',14,'Color','k','Rotation',0);
elseif (exchange == 3)
text(265,1.35,'Buffer [Na^+], mM','FontSize',13,'Color','k','Rotation',0);
text(265,1.30,'----------------------','FontSize',13,'Color','k','Rotation',0);
text(331,1.10,' 0.7','FontSize',14,'Color','b','Rotation',0);
text(331,0.85,' 1.0','FontSize',14,'Color','g','Rotation',0);
text(331,0.50,' 1.6','FontSize',14,'Color','r','Rotation',0);
text(331,0.20,' 2.0','FontSize',14,'Color','c','Rotation',0);
text(331,0.10,' 3.0','FontSize',14,'Color','m','Rotation',0);
text(331,0.025,'10.0','FontSize',14,'Color','k','Rotation',0);
end

%%
% figure(2); set(figure(2),'Units','inches','Position',[1.5 1.5 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(2)
ls2 = '-k';
plot(t_vec,C_mat(:,1)*1e3,ls2,'linewidth',2.0); hold on;
axis([0 360 0 10]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (0:2:10));
xlabel('Time (sec)'); ylabel('Matrix [Na^+] (mM)');
text(265,9.40,'Buffer [Na^+], mM','FontSize',13,'Color','k','Rotation',0);
text(265,9.00,'----------------------','FontSize',13,'Color','k','Rotation',0);
text(331,7.95,'10.0','FontSize',14,'Color','k','Rotation',0);
text(331,2.45,' 3.0','FontSize',14,'Color','k','Rotation',0);
text(331,1.75,' 2.0','FontSize',14,'Color','k','Rotation',0);
text(331,1.35,' 1.6','FontSize',14,'Color','k','Rotation',0);
text(331,0.95,' 1.0','FontSize',14,'Color','k','Rotation',0);
text(331,0.55,' 0.7','FontSize',14,'Color','k','Rotation',0);

%%
% figure(3); set(figure(3),'Units','inches','Position',[2 2 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(3)
ls2 = '-k';
plot(t_vec,J_mat(:,2)*1e6,ls2,'linewidth',2.0); hold on;
axis([0 360 -0.03 0.18]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (-0.03:0.03:0.18));
xlabel('Time (sec)'); ylabel('Flux J_{NCE} (\mumol/L/s)');
text(245,0.160,'[Na^+]_e =  0.7 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.145,'[Na^+]_e =  1.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.130,'[Na^+]_e =  1.6 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.115,'[Na^+]_e =  2.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.100,'[Na^+]_e =  3.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.085,'[Na^+]_e = 10.0 mM','FontSize',14,'Color','k','Rotation',0);
% Create arrow
annotation1 = annotation(...
  figure(3),'arrow',...
  [0.37 0.66],[0.14 0.74],...
  'LineWidth',1.5);
% Create annotation
annotation2 = annotation(...
  figure(3),'line',...
  [0.68 0.68],[0.91 0.53],...
  'LineWidth',1.5);

%%
% figure(4); set(figure(4),'Units','inches','Position',[2.5 2.5 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(4)
ls2 = '-k';
plot(t_vec,J_mat(:,3)*1e6,ls2,'linewidth',2.0); hold on;
axis([0 360 -110 40]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (-110:30:40));
xlabel('Time (sec)'); ylabel('Flux J_{NHE} (\mumol/L/s)');
text(245,-38.0,'[Na^+]_e =  0.7 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-50.0,'[Na^+]_e =  1.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-62.0,'[Na^+]_e =  1.6 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-74.0,'[Na^+]_e =  2.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-86.0,'[Na^+]_e =  3.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-98.0,'[Na^+]_e = 10.0 mM','FontSize',14,'Color','k','Rotation',0);
% Create annotation
annotation1 = annotation(...
  figure(4),'line',...
  [0.68 0.68],[0.55 0.15],...
  'LineWidth',1.5);
% Create arrow
annotation2 = annotation(...
  figure(4),'arrow',...
  [0.40 0.64],[0.80 0.36],...
  'LineWidth',1.5);

%%
if (exchange == 2)
    ls2 = '-.k';
elseif (exchange == 3)
    ls2 = '--k';
end
% figure(5); set(figure(5),'Units','inches','Position',[2 2 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(5)
plot(t_vec,J_mat(:,2)*1e6,ls2,'linewidth',2.0); hold on;
axis([0 360 -0.03 0.18]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (-0.03:0.03:0.18));
xlabel('Time (sec)'); ylabel('Flux J_{NCE} (\mumol/L/s)');
text(245,0.160,'[Na^+]_e =  0.7 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.145,'[Na^+]_e =  1.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.130,'[Na^+]_e =  1.6 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.115,'[Na^+]_e =  2.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.100,'[Na^+]_e =  3.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,0.085,'[Na^+]_e = 10.0 mM','FontSize',14,'Color','k','Rotation',0);
text(200,0.060,'-.-.- 2:1 NCE stoichiometry','FontSize',14,'Color','k','Rotation',0);
text(200,0.045,'- - - 3:1 NCE stoichiometry','FontSize',14,'Color','k','Rotation',0);
% Create arrow
annotation1 = annotation(...
  figure(5),'arrow',...
  [0.37 0.66],[0.14 0.74],...
  'LineWidth',1.5);
% Create annotation
annotation2 = annotation(...
  figure(5),'line',...
  [0.68 0.68],[0.91 0.53],...
  'LineWidth',1.5);

%%
if (exchange == 2)
    ls2 = '-.k';
elseif (exchange == 3)
    ls2 = '--k';
end
% figure(6); set(figure(6),'Units','inches','Position',[2.5 2.5 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(6)
plot(t_vec,J_mat(:,3)*1e6,ls2,'linewidth',2.0); hold on;
axis([0 360 -110 40]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (-110:30:40));
xlabel('Time (sec)'); ylabel('Flux J_{NHE} (\mumol/L/s)');
text(245,-38.0,'[Na^+]_e =  0.7 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-50.0,'[Na^+]_e =  1.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-62.0,'[Na^+]_e =  1.6 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-74.0,'[Na^+]_e =  2.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-86.0,'[Na^+]_e =  3.0 mM','FontSize',14,'Color','k','Rotation',0);
text(245,-98.0,'[Na^+]_e = 10.0 mM','FontSize',14,'Color','k','Rotation',0);
text(200,30,'-.-.- 2:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
text(200,20,'- - - 3:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
% Create annotation
annotation1 = annotation(...
  figure(6),'line',...
  [0.68 0.68],[0.55 0.15],...
  'LineWidth',1.5);
% Create arrow
annotation2 = annotation(...
  figure(6),'arrow',...
  [0.40 0.64],[0.80 0.36],...
  'LineWidth',1.5);

%%
if (exchange == 2)
    ls2 = '-.k';
elseif (exchange == 3)
    ls2 = '--k';
end
% figure(7); set(figure(7),'Units','inches','Position',[1.5 1.5 7 5])
% axes('position',[0.125 0.125 0.825 0.825]);  % OK with subplots, but not OK with main plot
figure(7)
plot(t_vec,C_mat(:,1)*1e3,ls2,'linewidth',2.0); hold on;
axis([0 360 0 10]); box on; grid off
set(gca, 'LineWidth',1.5, 'FontSize',15);
set(gca, 'XTick', (0:60:360), 'YTick', (0:2:10));
xlabel('Time (sec)'); ylabel('Matrix [Na^+] (mM)');
text(265,9.40,'Buffer [Na^+], mM','FontSize',13,'Color','k','Rotation',0);
text(265,9.00,'----------------------','FontSize',13,'Color','k','Rotation',0);
text(331,7.95,'10.0','FontSize',14,'Color','k','Rotation',0);
text(331,2.45,' 3.0','FontSize',14,'Color','k','Rotation',0);
text(331,1.75,' 2.0','FontSize',14,'Color','k','Rotation',0);
text(331,1.35,' 1.6','FontSize',14,'Color','k','Rotation',0);
text(331,0.95,' 1.0','FontSize',14,'Color','k','Rotation',0);
text(331,0.55,' 0.7','FontSize',14,'Color','k','Rotation',0);
text(10,9.3,'-.-.- 2:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
text(10,8.6,'- - - 3:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
