% Driver to simulate the dynamics of extra- and intra-mitochondrial Na and Ca 
% with the addition of Na or Ca to the external buffer medium.

% clf
% clc
% close all
% clear all
% 
format long
global J C exchange p

%% Initial concentrations
exchange = 2;            % NaCa exchanger type

xo(1) = 2.5e-3;          % Na_x   (matrix Na not known)
xo(2) = 1.27e-6;         % Ca_fx  (free Ca2+ in matrix)
xo(3) = 0.0e-3;          % Na_e   (added Na to the buffer; Na-PYR)

% % Parameters based on initial flux rates from Cox and Matlib
% if (exchange == 2)
%    xo(4) = 20.0e-6;      % Ca_te  (total Ca2+ in buffer)
%    p(1) = 1.5e-5;        % Factor for x_NCE
%    p(2) = 0.29;          % Factor of Km_Na_NCE
%    p(3) = 1.0;           % Factor for Km_Ca_NCE
% elseif (exchange == 3)
%    xo(4) = 20.0e-6;      % Ca_te  (total Ca2+ in buffer)
%    p(1) = 2.5e-5;        % Factor for x_NCE
%    p(2) = 0.29;          % Factor of Km_Na_NCE
%    p(3) = 1.0;           % Factor for Km_Ca_NCE
% end

% Parameters based on concentration dynamics from Cox and Matlib
if (exchange == 2)
   xo(4) = 1.0e-6;       % Ca_te  (total Ca2+ in buffer)
   p(1) = 2.0e-5;        % Factor for x_NCE
   p(2) = 0.42;          % Factor of Km_Na_NCE
   p(3) = 1.0;           % Factor for Km_Ca_NCE
elseif (exchange == 3)
   xo(4) = 1.0e-6;       % Ca_te  (total Ca2+ in buffer)
   p(1) = 2.54e-5;       % Factor for x_NCE
   p(2) = 0.293;         % Factor of Km_Na_NCE
   p(3) = 1.0;           % Factor for Km_Ca_NCE
end

tadd = 50;               % Time of Na addition
tend = 330;              % End time of simulation

% Option for differential equations
options = odeset('RelTol',1e-8, 'AbsTol',1e-8, 'MaxStep',5e-1, ...
          'InitialStep',1e-1, 'MaxOrder',5, 'BDF','on');
%options = [];

%% All figures settings for final plots
figure(1); set(figure(1),'Units','inches','Position',[1 1 7 5]);
axes('position',[0.11 0.11 0.86 0.86]);  % OK with subplots, not OK with main plot
figure(2); set(figure(2),'Units','inches','Position',[1.5 1.5 7 5]);
axes('position',[0.10 0.11 0.85 0.85]);  % OK with subplots, not OK with main plot
figure(3); set(figure(3),'Units','inches','Position',[2 2 7 5]);
axes('position',[0.14 0.11 0.82 0.85]);  % OK with subplots, not OK with main plot
figure(4); set(figure(4),'Units','inches','Position',[2.5 2.5 7 5]);
axes('position',[0.14 0.11 0.82 0.85]);  % OK with subplots, not OK with main plot
figure(5); set(figure(5),'Units','inches','Position',[3 3 7 5]);
axes('position',[0.14 0.11 0.82 0.85]);  % OK with subplots, not OK with main plot
figure(6); set(figure(6),'Units','inches','Position',[3.5 3.5 7 5]);
axes('position',[0.14 0.11 0.82 0.85]);  % OK with subplots, not OK with main plot
figure(7); set(figure(7),'Units','inches','Position',[4 4 7 5]);
axes('position',[0.10 0.11 0.85 0.85]);  % OK with subplots, not OK with main plot

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 0.75*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-b';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 1.05*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-g';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 1.55*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-r';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 2.05*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-c';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 3.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-m';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 10.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end

% compute the concentration matrix for plots
t_vec = [t1_vec;t2_vec]; x_mat = [x1_mat;x2_mat]; 
f_mat = [f1_mat;f2_mat]; J_mat = [J1_mat;J2_mat];
C_mat = [C1_mat;C2_mat];

ls = '-k';
Plot_Script(t_vec,C_mat,J_mat,ls,exchange)
