% Driver to simulate the dynamics of extra- and intra-mitochondrial Na and Ca 
% with the addition of Na or Ca to the external buffer medium.

% clf
% clc
% close all
% clear all

format long
global J C exchange p

%% Initial concentrations
exchange = 2;            % NaCa exchanger type

xo(1) = 2.5e-3;          % Na_x   (matrix Na not known)
xo(2) = 1.3e-6;          % Ca_fx  (free Ca2+ in matrix)
xo(3) = 0.0e-3;          % Na_e   (added Na to the buffer; Na-PYR)

% % Parameters based on initial flux rates from Cox and Matlib
% if (exchange == 2)
%    xo(4) = 20.0e-6;      % Ca_te  (total Ca2+ in buffer)
%    p(1) = 1.5e-5;        % Factor for x_NCE
%    p(2) = 0.29;          % Factor of Km_Na_NCE
%    p(3) = 1.0;           % Factor for Km_Ca_NCE
%    ls = '-.k';
% elseif (exchange == 3)
%    xo(4) = 20.0e-6;      % Ca_te  (total Ca2+ in buffer)
%    p(1) = 2.5e-5;        % Factor for x_NCE
%    p(2) = 0.29;          % Factor of Km_Na_NCE
%    p(3) = 1.0;           % Factor for Km_Ca_NCE
%    ls = '--k';
% end

% Parameters based on concentration dynamics from Cox and Matlib
if (exchange == 2)
   xo(4) = 1.0e-6;       % Ca_te  (total Ca2+ in buffer)
   p(1) = 2.0e-5;        % Factor for x_NCE
   p(2) = 0.42;          % Factor of Km_Na_NCE
   p(3) = 1.0;           % Factor for Km_Ca_NCE
   ls = '-.k';
elseif (exchange == 3)
   xo(4) = 1.0e-6;       % Ca_te  (total Ca2+ in buffer)
   p(1) = 2.5e-5;        % Factor for x_NCE
   p(2) = 0.29;          % Factor of Km_Na_NCE
   p(3) = 1.0;           % Factor for Km_Ca_NCE
   ls = '--k';
end

tadd = 50;               % Time of Na addition
tend = 230;              % End time of simulation

% Option for differential equations
options = odeset('RelTol',1e-8, 'AbsTol',1e-8, 'MaxStep',5e-1, ...
          'InitialStep',1e-1, 'MaxOrder',5, 'BDF','on');
%options = [];

Jsim_NCE = [0 0];
Csim_Ca_fx = [0 1.3];

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 0.4*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 0.4  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 0.4  C2_mat(end,2)*1e6];
% figure(10)
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 0.7*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 0.7  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 0.7  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 1.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 1.0  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 1.0  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 1.5*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 1.5  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 1.5  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 2.1*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 2.1  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 2.1  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 2.6*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 2.6  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 2.6  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 3.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 3.0  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 3.0  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 4.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 4.0  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 4.0  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 5.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 5.0  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 5.0  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 7.5*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 7.7  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 7.5  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% Compute matrix Na-Ca dynamics initial phase with mitochondria loaded Ca. 
[t1_vec,x1_mat] = ode15s(@dXdT123,[0 tadd],xo,options);
f1_mat = []; J1_mat = []; C1_mat = [];
for i = 1:length(t1_vec);
    t = t1_vec(i); x = x1_mat(i,:)'; f = dXdT123(t,x);
    f1_mat = [f1_mat;f']; J1_mat = [J1_mat;J']; C1_mat = [C1_mat;C'];
end

% Compute matrix Na-Ca dynamics with NaCl addition (Na influx, Ca efflux).
x1_mat(end,3) = x1_mat(end,3) + 10.0*1e-3;      % Buffer Na
[t2_vec,x2_mat] = ode15s(@dXdT123,[tadd tend],x1_mat(end,:),options);
f2_mat = []; J2_mat = []; C2_mat = [];
for i = 1:length(t2_vec);
    t = t2_vec(i); x = x2_mat(i,:)'; f = dXdT123(t,x);
    f2_mat = [f2_mat;f']; J2_mat = [J2_mat;J']; C2_mat = [C2_mat;C']; 
end
Jsim_NCE = [Jsim_NCE; 10.0  max(-f2_mat(:,2))*60*1e6];
Csim_Ca_fx = [Csim_Ca_fx; 10.0  C2_mat(end,2)*1e6];
% plot(t2_vec,-f2_mat(:,2)*60*1e6); hold on

%%
% NCE flux vs. buffer [Na+] after 0+ minutes of addition
Jdata_NCE = [0.0 0.0
        1.0      0.176
        1.6      0.387   % extraplotaed or manupulated
        2.0      0.528
        3.0	     0.820
        5.0	     1.076   % 0.984
        10.0	 1.234];

% Matrix free [Ca2+] vs. buffer [Na+] after 3 minutes of addition
Cdata_Ca_fx = [0.0   1.3  %1.33
         0.7     1.152   %1.17
         1.0     1.012   %1.07
         1.6     0.721   %0.631
         2.0     0.426   %0.354
         3.0     0.262   %0.271
         5.0     0.141   %0.221
        10.0     0.125];   %0.199];

%% 
figure(5); set(figure(5),'Units','inches','Position',[1.5 2.0 7 5])
%axes('position',[0.125 0.125 0.825 0.825]);
plot(Jdata_NCE(:,1),Jdata_NCE(:,2),'ok','linewidth',2, 'MarkerEdgeColor','k', ...
    'MarkerFaceColor','k', 'Markersize',8); hold on;
plot(Jsim_NCE(:,1),Jsim_NCE(:,2),ls,'linewidth',2); hold on;
axis([0 10 0 1.8]); box on; grid off
%axis 'autoy'
set(gca, 'LineWidth',1.5, 'FontSize',14);
set(gca, 'XTick', (0:2:10)); set(gca, 'YTick', (0:0.3:1.8));
xlabel('Buffer [Na^+] (mM)'); ylabel('Rate of decrease in matrix [Ca^{2+}] (\mumol/L/min)');
text(0.5,1.65,'-.-.- 2:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
text(0.5,1.52,'- - - 3:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);

figure(6); set(figure(6),'Units','inches','Position',[2.0 1.5 7 5])
%axes('position',[0.125 0.125 0.825 0.825]);
plot(Cdata_Ca_fx(:,1),Cdata_Ca_fx(:,2),'ok','linewidth',2, 'MarkerEdgeColor','k', ...
    'MarkerFaceColor','k', 'Markersize',8); hold on;
plot(Csim_Ca_fx(:,1),Csim_Ca_fx(:,2),ls,'linewidth',2); hold on
axis([0 10 0 1.5]); box on; grid off
%axis 'autoy'
set(gca, 'LineWidth',1.5, 'FontSize',14);
set(gca, 'XTick', (0:2:10)); set(gca, 'YTick', (0:0.3:1.5));
xlabel('Buffer [Na^+] (mM)'); ylabel('Matrix free [Ca^{2+}] (\muM)');
text(5.0,1.35,'-.-.- 2:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
text(5.0,1.22,'- - - 3:1 NCE Stoichiometry','FontSize',14,'Color','k','Rotation',0);
