#! /usr/bin/env python
## mh_rw_sampling_2d.py
import numpy as np
import matplotlib.pyplot as plt

def bi_gauss(y,mu):
    return(np.exp(-.5*np.dot(y-mu,y-mu)))

def target(y,mu):
    return(np.log(bi_gauss(y,mu)+bi_gauss(y,-mu)))

def mh_sampling(M=100,seed=9,initial=[0,0],mu=1):
    gen = np.random.default_rng(seed=seed)
    xs = np.empty(shape=[M+1,2])
    xs[0,] = x = np.array(initial)
    p = target(x,mu)
    acc = 0
    for i in range(M):
        x_ = x + 2*gen.normal(size=2)
        p_ = target(x_,mu)
        if p_ > p or -gen.exponential() < p_ - p:
            x,p = x_,p_
            acc +=1
        xs[i+1,] = x
    print("Mu="+str(mu),"acc. rate:",str(acc/M*100)+"%")
    return(xs)

def trace_plots(z):
    fig,axs=plt.subplots(1,len(z),figsize=(12,4), constrained_layout=True)
    for ind in range(len(z)):
        x,y = z[ind][:,0],z[ind][:,1]
        axs[ind].plot(x,y,'bx-',linewidth=.2,markersize=4)
        axs[ind].set_xlabel(r'$\theta_1$', fontsize=16)
        axs[ind].set_ylabel(r'$\theta_2$', fontsize=16)
    plt.show()

trace_plots([mh_sampling(mu=mu) for mu in (1,3)])
