// linear_model_latent_factors.stan

data {
    int<lower=0> n; // number of observations
    int<lower=1> p; // number of grid points
    vector[n] y; // responses
    matrix[n, p] X; // factor matrix
    int<lower=1> q; // number of latent factors
    real<lower=0> u;
    real<lower=0> v;
    real<lower=0> a;
    real<lower=0> b;
}
transformed data {
    matrix[n, n] vXXTI = v * X * X' + identity_matrix(n);
}
parameters {
    matrix[n, q] Z; // latent factor matrix
}
model {
    matrix[n, n] S = u * Z * Z' + vXXTI;
    y ~ multi_student_t(2*a,rep_vector(0, n), b * S / a);
}
