#! /usr/bin/env python
# dirichlet_process_sample.py

import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import geom

def DP_sample(a,P_0=geom,th=.1,m=50,seed=0):
    gen = np.random.default_rng(seed=seed)
    p = [P_0.pmf(k,th) for k in range(1,m+1)]+[P_0.sf(m,th)]
    return(range(1,m+2),gen.dirichlet(a*np.array(p)))

for a in [10,10**3,10**5]:
    plt.scatter(*DP_sample(a),marker='x',label=r'$\alpha=$'+str(a))
plt.legend(loc="upper right")
plt.gcf().canvas.manager.set_window_title('Dirichlet process samples')
plt.show()
