#! /usr/bin/env python
## cavi.py
import numpy as np
from scipy.stats import multivariate_normal
import matplotlib.pyplot as plt

#target distribution parameters
mu, Sigma = [0,0], [[1,.95], [.95,1]]

#initial approximation
m, s = [2,3], [.01,81]

for _ in range(200):
   for j in range(2):
      m[j]=mu[j]+Sigma[j][1-j]/Sigma[1-j][1-j]*(m[1-j]-mu[1-j])
      s[j]=Sigma[j][j]-Sigma[j][1-j]**2/Sigma[1-j][1-j]

print(m,s)

x,y = np.mgrid[-2.5:2.5:.05, -2.5:2.5:.05]
xy = np.dstack((x,y))
N1 = multivariate_normal(mu,Sigma)
N2 = multivariate_normal(m,[[s[0],0],[0,s[1]]])
plt.rcParams["figure.figsize"] = (5,5)
plt.contour(x,y,N1.pdf(xy),10,colors='black')
plt.contour(x,y,N2.pdf(xy),10,colors='blue')
plt.xlabel(r'$\theta_1$', fontsize=14)
plt.ylabel(r'$\theta_2$', fontsize=14)
plt.gcf().canvas.manager.set_window_title('Density contours')
plt.show()
