## linear_regression.py

import numpy as np
from scipy.special import gammaln

def lm_log_likelihood(y,X,a=0.1,b=0.1,lam=0.01):
    n, p= X.shape
    XtX = X.T @ X
    Xty = X.T @ y
    V_n = np.linalg.inv(XtX+lam*np.identity(p))
    det_Vn= np.linalg.slogdet(V_n)[1]
    m_n = V_n @ Xty
    a_n = a+.5*n
    b_n = b + .5*(np.dot(y,y)  - Xty.T @ m_n)
    ml = .5*det_Vn + .5*p*np.log(lam) - a_n*np.log(b_n) + a*np.log(b) + gammaln(a_n) -.5*n*np.log(2*np.pi) - gammaln(a)
    return(ml,m_n)
