// latent_factors.stan

data {
    int<lower=0> n; // number of observations
    int<lower=1> p; // number of grid points
    array[n] vector[p] X; // data matrix
    int<lower=1> k; // number of latent factors
    real<lower=0> a;
    real<lower=0> b;
}
parameters {
    vector<lower=0>[p] Sigma; // diagonal Sigma
    matrix[p, k] Lambda; // factor loadings
}
transformed parameters{
    matrix[p, p] Omega = Lambda * Lambda' + diag_matrix(Sigma);
}
model {
    Sigma ~ inv_gamma(a,b);
    X ~ multi_normal(rep_vector(0, p), Omega);
}
