#! /usr/bin/env python
## bayes_histogram_simulate.py
from bayesian_histogram import *
import matplotlib.pyplot as plt
from scipy.stats import beta
gen = np.random.default_rng(seed=0)

def simulate_beta_mixture(n, beta_pars, probs):
    z=gen.choice(len(probs), n, p=probs)
    return(np.array([gen.beta(*(beta_pars[z_i])) for z_i in z]))

def mixture_density(x, beta_pars, probs):
    return(sum([probs[i]*beta.pdf(x,*beta_pars[i]) for i in range(len(probs))]))

n = 10000
beta_pars=[[20,10],[2,3]]
probs=[0.3,0.7]
x = simulate_beta_mixture(n, beta_pars, probs)
ave_density, m, ctr, pm = model_average(x,40)
m_density = [(ctr[i]*m + 1)/(1 + n) for i in range(m)]

fig,axs=plt.subplots(1,3,figsize=(12,4),constrained_layout=True)
fig.canvas.manager.set_window_title('Bayes histogram posterior')
grid = np.linspace(start=0, stop=1, num=len(ave_density))
true_f = [mixture_density(t, beta_pars, probs) for t in grid]
axs[0].plot(grid,ave_density)
axs[0].plot(grid,true_f, color='c', lw=2, linestyle='--')
axs[1].bar(range(len(pm)),pm)
axs[1].set_xlabel(r'$m$')
axs[1].set_title('Posterior '+r'$p(m\vert x,y)$')
axs[0].set_title('Averaged posterior mean density function')
axs[2].autoscale(enable=True, axis='x', tight=True)
axs[2].step(np.linspace(start=0, stop=1, num=m),m_density,where='post')
axs[2].set_title('Posterior mean density for '+r'$m=$'+str(m))
for plt_ind in [0,2]:
    axs[plt_ind].autoscale(enable=True, axis='x', tight=True)
    axs[plt_ind].set_xlabel(r'$x$')
    axs[plt_ind].set_ylim(bottom=0)
plt.show()


