## spline_regression.py

import numpy as np
from linear_regression import lm_log_likelihood

def log_prior(m,theta=.01):
    return(np.log(theta)+m*np.log(1-theta))

def spline_design_matrix(x,tau=[],d=1):
    X = np.zeros([len(x),d+1+len(tau)])
    X[:,0] = np.ones(len(x))
    for j in range(1,d+1):
        X[:,j] = [x_i**j for x_i in x]
    for j in range(len(tau)):
        for i in range(len(x)):
            if x[i] > tau[j]:
                X[i,d+1+j] = (x[i]-tau[j])**d
    return(X)

def model_average(x,y,max_m=100,grid=50,T=1,d=1,a=.1,b=1,lam=.01):
    max_post = -float('inf')
    sum_probs = 0
    ave_f = np.zeros(grid)
    probs = np.empty(max_m+1)
    x_grid = np.linspace(start=0, stop=T, num=grid)
    for m in range(max_m+1):
        tau = np.arange(1,m+1)/float(m+1)*T
        X = spline_design_matrix(x,tau,d)
        log_lhd,m_n = lm_log_likelihood(y,X,a,b,lam)
        log_post= log_lhd + log_prior(m)
        if log_post > max_post:
            renormalise = np.exp(max_post-log_post)
            sum_probs *= renormalise
            probs[:m] *= renormalise
            ave_f *= renormalise
            max_post = log_post
            max_m,max_m_n,max_tau = m,m_n,tau
        probs[m] = np.exp(log_post-max_post)
        sum_probs += probs[m]
        f = np.dot(spline_design_matrix(x_grid,tau,d),m_n)
        ave_f += probs[m] * f
    return(ave_f/sum_probs, max_m, max_m_n, max_tau, probs/sum_probs)
