C----------------------------------------------------------------------
C----------------------------------------------------------------------
C   ab :            The A --> B reaction 
C----------------------------------------------------------------------
C----------------------------------------------------------------------
C
      subroutine func(ndim,u,icp,par,ijac,f,dfdu,dfdp)
c     ---------- ----
c
c evaluates the algebraic equations or ode right hand side
c
c input arguments :
c      ndim   :   dimension of the ode system 
c      u      :   state variables
c      icp    :   array indicating the free parameter(s)
c      par    :   equation parameters
c
c values to be returned :
c      f      :   ode right hand side values
c
c normally unused jacobian arguments : ijac, dfdu, dfdp (see manual)
c
      implicit double precision (a-h,o-z)
      dimension u(ndim),par(*),f(ndim),icp(*),dfdu(ndim,*),dfdp(ndim,*)
c
      tmp=u(1)*u(2)/(1d0+par(1)*u(1))
      tmpdu1 = u(2)/(1+par(1)*u(1))**2d0
      tmpdu2 = u(1)/(1+par(1)*u(1))
      tmpdp = -u(1)*u(1)*u(2)/(1+par(1)*u(1))**2d0
c
      f(1)= u(1) - tmp - par(3)*u(1)*u(1)
      f(2)=-par(4)*u(2) + tmp - par(2)*u(2)*u(2)
c
      if(ijac.eq.0) return
c 
c  The Jacobian
c  
      dfdu(1,1) = 1 - tmpdu1 - 2d0*par(3)*u(1)
      dfdu(1,2) = -tmpdu2
c
      dfdu(2,1) = tmpdu1
      dfdu(2,2) = -par(4)+tmpdu2-2d0*par(2)*u(2)
c
c  Parameter derivatives
c
      dfdp(1,1) = -tmpdp
      dfdp(1,2) = 0
      dfdp(1,3) = -u(1)*u(1)
      dfdp(1,4) = 0
c      
      dfdp(2,1) = tmpdp
      dfdp(2,2) = -u(2)*u(2)
      dfdp(2,3) = 0
      dfdp(2,4) = -u(2)
c
      return
      end
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
      subroutine stpnt(ndim,u,par)
c     ---------- -----
c
c input arguments :
c      ndim   :   dimension of the ode system 
c
c values to be returned :
c      u      :   a starting solution vector
c      par    :   the corresponding equation-parameter values
c
      implicit double precision (a-h,o-z)
      dimension u(ndim), par(*)
C COMMON block needed if IPS=9 (homoclinic bifurcations) :
      COMMON /BLHOM/ ITWIST,ISTART,IEQUIB,NFIXED,NPSI,NUNSTAB,NSTAB
c
c initialize the equation parameters
c       par(1)=0d0
c       par(2)=0d0
c       par(3)=0.01d0
c       par(4)=1d0
c
c initialize the solution
c       u(1)=1d0
c       u(2)=1d0-par(3)
c
c initial eq. for saddle-ode homoclinic orbit
c
       par(12) = 45.96081
       par(13) = 10.06229
C       
      return
      end
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c the following subroutines are not used here,
c but they must be supplied as dummy routines
c
      subroutine bcnd 
      return 
      end 
c 
      subroutine icnd 
      return 
      end 
c 
      subroutine fopt 
      return 
      end 
c 
      subroutine pvls
      return 
      end 
c----------------------------------------------------------------------
c----------------------------------------------------------------------

