C----------------------------------------------------------------------
C----------------------------------------------------------------------
C   ab :            The A --> B reaction 
C----------------------------------------------------------------------
C----------------------------------------------------------------------
C
      subroutine func(ndim,u,icp,par,ijac,f,dfdu,dfdp)
c     ---------- ----
c
c evaluates the algebraic equations or ode right hand side
c
c input arguments :
c      ndim   :   dimension of the ode system 
c      u      :   state variables
c      icp    :   array indicating the free parameter(s)
c      par    :   equation parameters
c
c values to be returned :
c      f      :   ode right hand side values
c
c normally unused jacobian arguments : ijac, dfdu, dfdp (see manual)
c
      implicit double precision (a-h,o-z)
      dimension u(ndim), par(*), f(ndim), icp(*)
c
      tmp=u(1)*u(2)/(1d0+par(1)*u(1))
c
      f(1)= u(1) - tmp - par(3)*u(1)*u(1)
      f(2)=-par(4)*u(2) + tmp - par(2)*u(2)*u(2)
c
      return
      end
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
      subroutine stpnt(ndim,u,par)
c     ---------- -----
c
c input arguments :
c      ndim   :   dimension of the ode system 
c
c values to be returned :
c      u      :   a starting solution vector
c      par    :   the corresponding equation-parameter values
c
      implicit double precision (a-h,o-z)
      dimension u(ndim), par(*)
c
c initialize the equation parameters
       par(1)=0d0
       par(2)=0d0
       par(3)=0.01d0
       par(4)=1d0
c
c initialize the solution
       u(1)=1d0
       u(2)=1d0-par(3)
c
      return
      end
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c the following subroutines are not used here,
c but they must be supplied as dummy routines
c
      subroutine bcnd 
      return 
      end 
c 
      subroutine icnd 
      return 
      end 
c 
      subroutine fopt 
      return 
      end 
c 
      subroutine pvls(ndim,u,par)
c     ---------- ----
c
      implicit double precision (a-h,o-z)
      dimension u(ndim),par(*)
c
c---------------------------------------------------------------------- 
c note : 
c parameters set in this subroutine should be considered as ``solution 
c measures'' and be used for output purposes only.
c 
c they should never be used as `true'' continuation parameters. 
c
c they may, however, be added as ``over-specified parameters'' in the 
c parameter list associated with the auto-constant nicp, in order to 
c print their values on the screen and in the ``p.xxx file.
c
c they may also appear in the list associated with auto-constant nuzr.
c
c---------------------------------------------------------------------- 
c for algebraic problems the argument u is, as usual, the state vector.
c for differential equations the argument u represents the approximate 
c solution on the entire interval [0,1]. in this case its values must 
c be accessed indirectly by calls to getp, as illustrated below.
c---------------------------------------------------------------------- 
c
c set par(5) to the hopf period
      hbf=getp('HBF',1,u)
      if ((dabs(hbf).lt.1d-10).and.(dabs(par(11)).gt.1e-12)) then
         par(5)=1d0/par(11)*pi(2d0)
      endif
c
C---------------------------------------------------------------------- 
C The first argument of GETP may be one of the following:
C        'NRM' (L2-norm),     'MAX' (maximum),
C        'INT' (integral),    'BV0 (left boundary value),
C        'MIN' (minimum),     'BV1' (right boundary value).
C
C Also available are
C   'STP' (Pseudo-arclength step size used).
C   'FLD' (`Fold function', which vanishes at folds).
C   'BIF' (`Bifurcation function', which vanishes at singular points).
C   'HBF' (`Hopf function'; which vanishes at Hopf points).
C   'SPB' ( Function which vanishes at secondary periodic bifurcations).
C---------------------------------------------------------------------- 
C
      return 
      end 
c----------------------------------------------------------------------
c----------------------------------------------------------------------
